<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customerprofile extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->library('form_validation');
        $this->load->model("common");
        $this->load->model("customerprofilemodel");
        if (!checkUrlAccessForUser('CUSTOMERPROFILE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {
        $data["page_title"] = $this->lang->line('cust_profile');
        $data["sub_title"] = $this->lang->line('cust_search');

        $post = $whr = $where = [];
        $whr['user_id'] = $this->session->userdata('user_id');
        $where['status'] = 1;
        // common where.
        $whr['company_code'] = $this->session->userdata('company_code');
        if($whr['company_code'] != 'RUKN') {
            $whr['branch_code'] = $this->session->userdata('branch_code');
        }

        if (isset($_POST['searchsubmit']) &&  $this->input->post('searchsubmit',TRUE) == "Search") {
            $post = $this->input->post(NULL,TRUE);
        }

        if (!empty($post)) {
            $where = $this->searchprofile($post);
            if (isset($post['name1']) && $post['name1'] != "") {
                $name1    = $post['name1'];
                $whr["name"] = $name1;
            }

            if (isset($post['customer_name']) && $post['customer_name'] != "") {
                $customer_name    = $post['customer_name'];
                $whr["name"] = $customer_name;
            }
        }

        $data['cutomer_profile_list'] = $this->customerprofilemodel->getcustomerprofiledata($whr, $where);
        $this->newtemplate->dashboard("customerprofile/index", $data);
    }

    public function searchprofile($post)
    {
        $whr = [];
        if (isset($post['fromdate']) && $post['fromdate'] != "") {
            $fromdate                                      = date('Y-m-d', strtotime($post['fromdate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') >="] = $fromdate;
        }

        if (isset($post['todate']) && $post['todate'] != "") {
            $todate                                        = date('Y-m-d', strtotime($post['todate']));
            $whr["DATE_FORMAT(createdon,'%Y-%m-%d') <="] = $todate;
        }

        if (isset($post['profile_id1']) && $post['profile_id1'] != "") {
            $profile_id1  = $post['profile_id1'];
            $whr["cust_profile_id="] = $profile_id1;
        }

        if (isset($post['profile_id']) && $post['profile_id'] != "") {
            $profile_id  = $post['profile_id'];
            $whr["cust_profile_id="] = $profile_id;
        }

        if (isset($post['status']) && $post['status'] != "") {
            $status  = $post['status'];
            $whr["status="] = $status;
        } else {
            $whr['status='] = 1;
        }

        return $whr;
    }

    public function getcustprofileid()
    {
        $uid = $this->session->userdata('user_id');

        $profile_id1 = isset($_REQUEST["profile_id1"])?$_REQUEST["profile_id1"]:"";

        $profile_id1 = trim($profile_id1);

        $data = [];

        $get_data = $this->db->query("
            SELECT cust_profile_id
            FROM tb_customer_profile
            WHERE
                cust_profile_id like ?
                AND user_id = ?
                AND status = 1
        ", [
            '%'. $this->db->escape_like_str($profile_id1) . '%',
            $uid
        ]);

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->cust_profile_id;

            }

        }

        echo json_encode($data);
    }

    public function add() {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $table = 'tb_customers';
        $whr = [
            "user_id" => $user_id
        ];
        $cusname = $this->customerprofilemodel->selectlist('id,name', $table, $whr, 'name');
        $data['cusname'] = $cusname;
        $table1 = 'tb_department_master';
        $whr1 = [
            "company_code" => $company_code,
            "branch_code" => $branch_code
        ];
        $deprt = $this->customerprofilemodel->selectlist('id,department_name', $table1, $whr1, 'department_name');
        $data['depat'] = $deprt;

        $data["page_title"] = $this->lang->line('cust_profile');
        $data["sub_title"] = $this->lang->line('general_add');

        //$this->newtemplate->dashboard("customerprofile/add", $data);
        $this->load->view("customerprofile/add", $data);
    }

    public function update() {
        $id = $this->input->post('id',TRUE);
        if (!is_numeric($id))
            return json_encode(FALSE);

        $name = $this->input->post('profile_name');
        $description = $this->input->post('desc');
        $company_code = $this->input->post('company_code');
        $branch_code = $this->input->post('branch_code');
        $status = $this->input->post('status');
        $user_id = $this->session->userdata('user_id');
        $data = [
            'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
             'status' => $status
        ];

        $table = 'tb_customer_profile';
        $whr = [
            'id' => $id
        ];

        $result = $this->common->updatetbledata($table, $data, $whr);
        echo json_encode($result);
    }

    public function edit($id) {
        $data["page_title"] = $this->lang->line('cust_profile');
        $data["sub_title"] = $this->lang->line('cutomer_edit');

        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        $user_id = $this->session->userdata('user_id');
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $profile_list = [];

        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['cust_profile'] = $this->customerprofilemodel->editdata($id,$company_code,$branch_code);
        if ($data['cust_profile']) {
            //$this->newtemplate->dashboard('customerprofile/edit', $data);
            $this->load->view("customerprofile/edit", $data);
        } else {
            //redirect('customerprofile/add');
            $this->load->view("customerprofile/add", $data);
        }
    }

    public function view($id) {
        $data["page_title"] = $this->lang->line('cust_profile');
        $company_code = $this->session->userdata('company_code');
        $branch_code = "";
        if($company_code != 'RUKN') {
            $branch_code = $this->session->userdata('branch_code');
        }
        $profile_list = [];
        $data["sub_title"] = $this->lang->line('view_view');
        $data['cust_profile'] = $this->customerprofilemodel->viewdata($id, $company_code, $branch_code);
        if ($data['cust_profile']) {
            //$this->newtemplate->dashboard('customerprofile/view', $data);
            $this->load->view("customerprofile/view", $data);
        } else {
            //redirect('customerprofile/add');
            $this->load->view("customerprofile/add", $data);
        }
    }

    public function delete($id) {
        if ($id != '' && is_numeric($id)) {
            $company_code = $this->session->userdata('company_code');
            $branch_code = $this->session->userdata('branch_code');
            $this->db->where(['id' => $id]);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_customer_profile');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function save() {
        $post = $this->input->post(NULL,TRUE);
        $cust_profile_id = $this->profileidgen();
        $name = ($post['profile_name']) ? ($post['profile_name']) : '';
        $company_code = ($post['company_code']) ? ($post['company_code']) : '';
        $branch_code = ($post['branch_code']) ? ($post['branch_code']) : '';
        $description = ($post['description']) ? ($post['description']) : '';
        $user_id = $this->session->userdata('user_id');

        $data = [
            'cust_profile_id' => $cust_profile_id, 'name' => $name,
            'description' => $description, 'company_code' => $company_code, 'branch_code' => $branch_code,
            'user_id' => $user_id, 'status' => 1
        ];

        $table = 'tb_customer_profile';
        $cp_id = $this->common->insertTableData($table, $data);
        $customer_ids = explode(',',$post['customer_ids']);
        $updatedata = ['cp_id'=>$cp_id];
        $result = $this->customerprofilemodel->updatelistmodule('tb_customer_profile_list',$updatedata,$customer_ids);
        echo json_encode($result);
    }

    public function getpartymaster()
    {
        $userId = $this->session->userdata('user_id');
        $result = [];
        $customerList = $this->customerprofilemodel->getCustomerPopupList($userId);
        foreach ($customerList as $res) {
            $check = "<input type='radio' name='listcompany' id='listcompany_" . $res['id'] . "' class='listcompany' onchange='selectPartyMaster(" . $res['id'] . ")' value='" . $res['id'] . "'>";
            $result[] = ['check' => $check, 'name' => $res['name'], 'mobile' => $res['phone'], 'street' => $res['street'], "pincode" => $res['pincode']];
        }

        echo json_encode($result);
    }

    public function savecustomer($id = null) {
        $post = $this->input->post(NULL,TRUE);
        $customer_p = [];
        $userid = $this->session->userdata('user_id');
        $customer_p['profile_id'] = ($post['code'])?$post['code']:'';
        $customer_p['party_id'] = $post['party_id'];
        if($id == null) {
            if(isset($post['custprid'])) {
                $customer_p['cp_id'] = $post['custprid'];
            } else {
                $customer_p['cp_id'] = 0;
            }
            $customer_p['status'] = 1;
            $customer_p['createdon'] = date('Y-m-d H:i:s');
            $customer_p['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_customer_profile_list',$customer_p);
        } else {
            $customer_p['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_customer_profile_list',$customer_p,['id'=>$id]);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function showprofilelist()
    {
        $profilelist  = [];
        $ids  = isset($_POST['customer_ids_list']) ? $this->input->post('customer_ids_list',TRUE) : "";
        if ($ids != "") {
            $profile_list = $this->customerprofilemodel->getprofilelistdata($ids);
            foreach($profile_list as $profile){
                $name = '"'.$profile['name'].'"';
                $email = '"'.$profile['email_id'].'"';
                $mobile = '"'.$profile['phone'].'"';
                $street = '"'.$profile['street'].'"';
                $pincode = '"'.$profile['pincode'].'"';
                $code = '"'.$profile['code'].'"';

                $profile['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowprofileEdit(this," . $profile['customer_profile_list_id'] .",".$profile['party_id'].");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowprofileElim(this," . $profile['customer_profile_list_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowCustProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";
                $profilelist[] = $profile;
            }
        }
        echo json_encode($profilelist);
    }

    public function profileidgen()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $cust_res = $this->db->query("SELECT cust_profile_id FROM tb_customer_profile ORDER BY id DESC LIMIT 1");
        if ($cust_res->num_rows() > 0) {
            $get_cust_id = $cust_res->row()->cust_profile_id;
            $get_cust_id_c = strlen($get_cust_id);
            $previous_weeknumber = substr($get_cust_id, 6, 2);
            $get_cust_id1 = substr($get_cust_id, 8);
            $get_cust_id2 = ltrim($get_cust_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_cust_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $cust_id1 = "CP" . $country_code . $year . $week . $id1;
            $chk = $this->db->query("
                SELECT cust_profile_id
                FROM tb_customer_profile
                WHERE cust_profile_id = ?
            ", [
                $cust_id1
            ]);
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $cust_id1 = "CP" . $country_code . $year . $week . $ii_d;
            } else {
                $cust_id1 = $cust_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $cust_id1 = "CP" . $country_code . $year . $week . $id1;
        }
        return $cust_id1;
    }

    public function checkname()
    {
        $post = $this->input->post(NULL,TRUE);

        $name = isset($post['name']) ? $post['name'] : "";

        $company_code = isset($post['company_code']) ? $post['company_code'] : "";

        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";

        $id = isset($post['id']) ? $post['id'] : "";

        $user_id = $this->session->userdata('user_id');

        $status = 1;

        $where = [

            'name' => $name,

            'branch_code' => $branch_code,

            'company_code' => $company_code,

            'user_id' => $user_id,

            'status' => $status

        ];

        if ($id) {

            $where['id !='] = $id;

        }

        $check_cust_data = $this->common->gettblrowdata($where, '*', 'tb_customer_profile', 0, 0);

        if (empty($check_cust_data)) {

            echo "2";

        } else {

            echo "1";

        }
    }

    public function getprofilelist()
    {
        $profile_list  = [];
        $custprid    = isset($_POST['custprid']) ? $this->input->post('custprid',TRUE) : "";
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        if ($custprid != "") {
            $profilelist = $this->customerprofilemodel->profilelistbyid($custprid, $company_code, $branch_code);
            foreach($profilelist as $profile) {

                $party_id = '"'.$profile['party_id'].'"';
                $name = '"'.$profile['name'].'"';
                $phone = '"'.$profile['phone'].'"';
                $email_id = '"'.$profile['email_id'].'"';
                $street = '"'.$profile['street'].'"';
                $pincode = '"'.$profile['pincode'].'"';
                $code = '"'.$profile['code'].'"';

                $profile['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowprofileEdit(this," . $profile['customer_profile_list_id'] .",".$profile['party_id'].");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='rowprofileElim(this," . $profile['customer_profile_list_id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowCustProfile(this);'><span class='glyphicon glyphicon-plus' > </span>".$this->lang->line('add_profile')."</a></li>";

                $profile_list[] = $profile;
            }
        }
        echo json_encode( $profile_list);
    }

    public function deleteprofiledetails()
    {
        $id = isset($_POST['id']) ? $this->input->post('id',TRUE) : '0';
        if ($id != '0') {
            $chk = $this->db->select('id,profile_id')->get_where('tb_customer_profile_list', [
                'id' => $id
            ]);
            if ($chk->num_rows() > 0) {
                $row_id = $chk->row()->profile_id;
                $upd = $this->db->where([
                    'id' => $id
                ])->update('tb_customer_profile_list', [
                    'status' => 0
                ]);
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }
     public function getcustinfo($id) {
        $result = [];
        if ($id > 0) {
            $where = ['id'=>$id];
            $chk_cust = $this->common->gettblrowdata($where, 'id,name,phone,email_id,code,street,pincode', 'tb_customers', 0, 0);
            if (!empty($chk_cust)) {
                    $result = ['id' => $chk_cust['id'], 'name' => $chk_cust['name'], 'mobile' => $chk_cust['phone'], 'street' => $chk_cust['street'], "pincode" => $chk_cust['pincode'],'code'=>$chk_cust['code'],'email_id'=>$chk_cust['email_id']];
            }
        }
         echo json_encode($result);
    }
}
