<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customreferencesupdate extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library(['customreferenceshandler', 'statusintigration', 'macdamstatusintigration', 'knlogin']);
    }

    public function index()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            echo "Please Send Proper XML";
            return;
        }
        //log_message("error", "Customreferencesupdate Triggered XML " . json_encode($postData));
        try {
            $response = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            $this->customreferenceshandler->pullOrderReferenceXml($response);
            $status = "Success";
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Inserting Order References " . $ex->getMessage());
            $status = "Some Problem occured!, While Inserting Order References " . $ex->getMessage();
        }
        echo $status;
    }

}
