<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Customstatusupdate extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common','Singlestatusmodel']);
    }

    public function index(): void
    {
        ini_set('max_execution_time', 300);

        if (empty($postData = file_get_contents('php://input'))) {
            echo "Please Send Proper XML";
            return;
        }

        $xmldata = new SimpleXMLElement($postData);
        if (!$xmldata) {
            echo "Invalid request,Please try again!";
            return;
        }


        echo $this->parseStatusXml($xmldata);
    }

    public function parseStatusXml(object $xmldata): string
    {
        $header = $xmldata->xpath('SVKEDITransmissionHeader');
        $body = $xmldata->xpath('SVKEDITransmissionBody');
        $headerdata = [
            "SenderTransmissionNo" => isset($header[0]->SenderTransmissionNo) ? (string)($header[0]->SenderTransmissionNo) : "",
            "emailaddress" => isset($header[0]->AckSpec->EmailAddress) ? (string)($header[0]->AckSpec->EmailAddress) : "",
            "ackoption" => isset($header[0]->AckSpec->AckOption) ? (string)($header[0]->AckSpec->AckOption) : "",
            "sourceapp" => isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "",
            "destinationapp" => isset($header[0]->DestinationApp) ? (string)($header[0]->DestinationApp) : "",
            "action" => isset($header[0]->Action) ? (string)($header[0]->Action) : "",
        ];
        $ordersData = [];

        foreach ($body[0]->OrderStatus->Status as $Status) {
            $orderId = isset($body[0]->OrderStatus->OrderID) ? (string)($body[0]->OrderStatus->OrderID) : "";
            $ordersData[] = [
                "OrderID" => $orderId,
                "statustype" => isset($Status[0]->StatusType) ? (string)($Status[0]->StatusType) : "",
                "statuscode" => isset($Status[0]->StatusCode) ? (string)($Status[0]->StatusCode) : "",
                "statusvalue" => isset($Status[0]->StatusValue) ? (string)($Status[0]->StatusValue) : "",
                "datetime" => isset($Status[0]->DateTime) ? (string)($Status[0]->DateTime) : "",
                "timezone" => isset($Status[0]->TimeZone) ? (string)($Status[0]->TimeZone) : "",
                "actionuser" => isset($Status[0]->ActionUser) ? (string)($Status[0]->ActionUser) : "",
            ];
        }

        $params = [
            'edi_type' => 2, /* 1->EDI Transport Order, 2->EDI Status */
            'transaction_id' => time(),
            'edi_id' => 33, /* edi id based on name take it from tb_edi_types */
            'edi_name' => 'Excel DTO',
            'bounded_type' => 1, /* 1->Inbound(partner to KN), 2->Outbound (KN to partner) */
            'edi_format_type' => 'XML',
            'status' => 0,
            'obj_type' => 1,
            'txn_obj_id' => 0,
            'user_id' => 0,
            'company_code' => "",
            'branch_code' => "",
            'edi_request' => json_encode($xmldata),
            'edi_response' => ""
        ];

        $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

        $statusresponse = $this->Singlestatusmodel->updateCustomStatus(json_encode($ordersData),$edilogid);
        if ("Status Insert" === $statusresponse) {
            return "Status Insert Successfully";
        } else {
            return "Status Not Successfully";
        }
    }
}
