<?php if ( ! defined( 'BASEPATH' ) ) {	exit( 'No direct script access allowed' ); }

class DelhiveryIndiaEDI extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library('DelhiveryB2BEDIServices');
	}

	public function generateAPIToken() : void {
		$this->delhiveryb2bediservices->generateDelhiveryToken();
	}

	private function requestAuthorization(): int {
	    $authHeader = $this->input->get_request_header('Authorization', TRUE);
        log_message("error", "Authorization: " . $authHeader);
		$headers = $this->input->request_headers();
		log_message("error","AAA:".json_encode($headers));
		$status = 0;
		log_message("error","000:".$headers['Authorization']);
		if (isset($headers['Authorization']) && $headers['Authorization']) {
		    log_message("error","111:".$headers['Authorization']);
			$authorization = explode('Basic ', $headers['Authorization']);
			log_message("error","222:".count($authorization));
			if ((int) count($authorization) === 2) {
				$userCredential = explode(':',base64_decode($authorization[1]));
				log_message("error","333:".$userCredential);
				if ((int) count($userCredential) === 2 && $userCredential[0] === DELHIVERY_WEBHOOK_USERNAME && $userCredential[1] === DELHIVERY_WEBHOOK_PASSWORD) {
					$status = 1;
				}
			}
		}
		return $status;
	}
	public function delhiveryStatusWebhook() : void {
		$status = 401;
		if ($this->requestAuthorization() === 1) {
			$status = 200;
			$data = json_decode(file_get_contents("php://input"), true, 512, JSON_THROW_ON_ERROR);
			if (is_array($data) && !empty($data)) {
				date_default_timezone_set('Asia/Kolkata');
				$data['timestamp'] = date('d-m-Y H:i:s');
				if (isset($data['promised_delivery_date']) && !empty($data['promised_delivery_date']) && $data['promised_delivery_date'] > 0) {
					$data['promised_delivery_date'] = date('Y-m-d H:i:s',$data['promised_delivery_date']);
				}
				if (isset($data['expected_delivery_date']) && !empty($data['expected_delivery_date']) && $data['expected_delivery_date'] > 0) {
					$data['expected_delivery_date'] = date('Y-m-d H:i:s',$data['expected_delivery_date']);
				}
				//log_message("error","Delhivery Career Status Payload received => ".json_encode($data));
				//$this->delhiveryb2bediservices->sendDelhiveryStatusToAltova(ALTOVA_DELHIVERY_STATUS_URL, $data);
				log_message("error","DataStatus:".json_encode($data));
				$this->delhiveryb2bediservices->delhiveryStatus($data);
			}
		}
		http_response_code($status);
		echo json_encode(compact('status'));
	}

	public function delhiveryEPODWebhook(): void {
		$status = 401;
		if ($this->requestAuthorization() === 1) {
			$status = 200;
			$data = json_decode(file_get_contents("php://input"), true, 512, JSON_THROW_ON_ERROR);
			if (is_array($data) && !empty($data)) {
				//log_message("error","Delhivery Career ePOD Status Payload received => ".json_encode($data));
				//$this->delhiveryb2bediservices->sendDelhiveryStatusToAltova(ALTOVA_DELHIVERY_EPOD_URL, $data);
				log_message("error","DataPod:".json_encode($data));
				$this->delhiveryb2bediservices->delhiveryPod($data);
			}
		}
		http_response_code($status);
		echo json_encode(compact('status'));
	}

	public function delhiveryETNETA(): void {
		ini_set('max_execution_time', 300);
		$data = file_get_contents('php://input');
		if (!empty($data)) {
			//log_message("error","Delhivery Career ETN ETA Status Payload received from Altova => ".json_encode($data));
			$xmldata = new SimpleXMLElement($data);
			if ($xmldata === false) {
                echo "Invalid request, Please try again!";
            } else {
                echo $this->parseStatusXml($xmldata);
            }
		}
	}

	private function parseStatusXml(object $xmldata): string
    {
        $header = $xmldata->xpath('SVKEDITransmissionHeader');
        $body = $xmldata->xpath('SVKEDITransmissionBody');
        $headerdata = [
            "partyId" => isset($header[0]->PartyId) ? (string)($header[0]->PartyId) : "",
            "SenderTransmissionNo" => isset($header[0]->SenderTransmissionNo) ? (string)($header[0]->SenderTransmissionNo) : "",
            "emailaddress" => isset($header[0]->AckSpec->EmailAddress) ? (string)($header[0]->AckSpec->EmailAddress) : "",
            "ackoption" => isset($header[0]->AckSpec->AckOption) ? (string)($header[0]->AckSpec->AckOption) : "",
            "sourceapp" => isset($header[0]->SourceApp) ? (string)($header[0]->SourceApp) : "",
            "destinationapp" => isset($header[0]->DestinationApp) ? (string)($header[0]->DestinationApp) : "",
            "referenceid" => isset($header[0]->ReferenceId) ? (string)($header[0]->ReferenceId) : "",
            "action" => isset($header[0]->Action) ? (string)($header[0]->Action) : "",
        ];
        $ordersData = [];
        foreach ($body[0]->Order as $order) {
            $orderId = isset($order[0]->OrderID) ? (string)($order[0]->OrderID) : "";
            $statusCode = isset($order[0]->Status->StatusCode) ? (string)($order[0]->Status->StatusCode) : "";
            if ($orderId > 0 && !empty($statusCode)) {
                $ordersData[] = [
                    "OrderID" => $orderId,
                    "statuscode" => $statusCode,
                    "statusvalue" => isset($order[0]->Status->StatusValue) ? (string)($order[0]->Status->StatusValue) : "",
                    "datetime" => isset($order[0]->Status->DateTime) ? (string)($order[0]->Status->DateTime) : "",
                    "timezone" => isset($order[0]->Status->TimeZone) ? (string)($order[0]->Status->TimeZone) : "",
                    "location" => isset($order[0]->Status->Location) ? (string)($order[0]->Status->Location) : "",
                    "shipmentremark" => isset($order[0]->Status->ShipmentRemark) ? (string)($order[0]->Status->ShipmentRemark) : "",
                    "promiseddeliverydate" => isset($order[0]->Status->PromisedDeliveryDate) ? (string)($order[0]->Status->PromisedDeliveryDate) : "",
                    "expecteddeliverydate" => isset($order[0]->Status->ExpectedDeliveryDate) ? (string)($order[0]->Status->ExpectedDeliveryDate) : ""
                ];
            }
        }
        $this->load->model('DelhiveryB2BEDIModel');
        $statusresponse = $this->DelhiveryB2BEDIModel->updateStatus(json_encode($ordersData));
        if ("0" === $statusresponse) {
            return "No Order Id Found";
        } else {
            return "Status Updated Successfully";
        }
    }
}