<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Delhiveryedi extends CI_Controller
{
    public function __construct()
    {
        unset($_COOKIE);
        parent::__construct();
        $this->load->model('common');
        $this->load->helper('log_helper');
    }

    /* send order creation to delhivery */
    /**
     * get order tracking data from delhivery push api
     *
     *
     *
     * @param
     *
     * @return    Array
     * @throws      JsonException
     * @author    Developer Name external.ram.k@kuehne-nagel.com
     * @date      30-03-2021 19:55:00+05.30
     * @change    Asia
     */
    public function etntrackdelhivery()
    {
        $response = array("status" => "0", "message" => "No Request Data");
        $post = json_decode(file_get_contents("php://input"), true, 512, JSON_THROW_ON_ERROR);
        if (!empty($post)) {
            if (isset($post['Shipment'])) {
                $status = $post['Shipment']['Status']['Status'];
                $sts_dt = $post['Shipment']['Status']['StatusDateTime'];
                $sts_dt = date("Y-m-d H:i:s", strtotime($sts_dt));
                $sts_type = $post['Shipment']['Status']['StatusType'];
                $sts_loc = $post['Shipment']['Status']['StatusLocation'];
                $instructions = $post['Shipment']['Status']['Instructions'];
                $pickup_date = $post['Shipment']['PickUpDate'];
                $pickup_date = date("Y-m-d H:i:s", strtotime($pickup_date));
                $promise_deliver = $post['Shipment']['promised_delivery_date'];
                $promise_deliver = date("Y-m-d H:i:s", strtotime($promise_deliver));
                $expect_deliver = $post['Shipment']['expected_delivery_date'];
                $expect_deliver = date("Y-m-d H:i:s", strtotime($expect_deliver));
                $noofattempt = $post['Shipment']['noOfAttempt'];
                $nslcode = $post['Shipment']['NSLCode'];
                $shortcode = $post['Shipment']['Sortcode'];
                $refnum = $post['Shipment']['ReferenceNo'];
                $awb = $post['Shipment']['AWB'];
                $chkexists = $this->common->gettblrowdata(
                    [
                        "awbnum" => $awb,
                        "status_name" => $status,
                        "status_type" => $sts_type,
                        "instructions" => $instructions
                    ],
                    "id",
                    "tb_uniqlo_push_api_data",
                    0,
                    0
                );
                if (count($chkexists) > 0) {
                    $whr = ["id" => $chkexists['id']];
                    $set = [
                        'status_name' => $status,
                        'status_datetime' => $sts_dt,
                        'status_type' => $sts_type,
                        'status_location' => $sts_loc,
                        'instructions' => $instructions,
                        'pickup_date' => $pickup_date,
                        'exp_deliver_date' => $expect_deliver,
                        'no_of_attempt' => $noofattempt,
                        'nsl_code' => $nslcode,
                        'short_code' => $shortcode,
                        'referenceno' => $refnum
                    ];
                    $set = $this->setPromiseDeliveryDate($promise_deliver, $set);
                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "etntrackdelhivery updated data in a tb_uniqlo_push_api_data: " . implode(', ', $set)
                    );

                    $upd = $this->common->updatetbledata("tb_uniqlo_push_api_data", $set, $whr);
                } else {
                    $ins = [
                        'status_name' => $status,
                        'status_datetime' => $sts_dt,
                        'status_type' => $sts_type,
                        'status_location' => $sts_loc,
                        'instructions' => $instructions,
                        'pickup_date' => $pickup_date,
                        'exp_deliver_date' => $expect_deliver,
                        'no_of_attempt' => $noofattempt,
                        'nsl_code' => $nslcode,
                        'short_code' => $shortcode,
                        'referenceno' => $refnum,
                        'awbnum' => $awb
                    ];
                    $ins = $this->setPromiseDeliveryDate($promise_deliver, $ins);
                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "etntrackdelhivery inserted data in a tb_uniqlo_push_api_data: " . implode(', ', $ins)
                    );

                    $chkexists = $this->common->insertTableData("tb_uniqlo_push_api_data", $ins);
                }
                /* update promise date and no of attempts in order details table */

                    $checkOrderExists = $this->common->gettblrowdata(["ref_value" => $awb], "order_id", "tb_order_references", 0, 0);
                    if (count($checkOrderExists) > 0) {
                        $setData['no_of_attempt'] = $noofattempt;
                        $setData = $this->setPromiseDeliveryDate($promise_deliver, $setData);
                        $whereCondition = ["order_row_id" => $checkOrderExists['order_id']];
                        $updatePromiseData = $this->common->updatetbledata("tb_order_details", $setData, $whereCondition);
                    }

                $response = array("status" => "1", "message" => "Success");
            } else {
                $response = array("status" => "0", "message" => "No Shipment");
            }
        }

        log_error(UNIQLO_LOG_PREFIX . "etntrackdelhivery outbound data: " . implode(', ', $response));

        echo json_encode($response);
    }

    /**
     * @param string $promiseDeliverDate
     * @param array $pushApiData
     * @return array
     */
    private function setPromiseDeliveryDate(string $promiseDeliverDate, array $pushApiData): array
    {
        if (strpos($promiseDeliverDate, "1970-01-01") === false) {
            $pushApiData['promise_deliver_date'] = $promiseDeliverDate;
        }
        return $pushApiData;
    }
}
