<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once './vendor/pear/http_request2/HTTP/Request2.php';


use App\Libraries\infrastructure\ScheduledJobLoggerService;
use phpseclib\Net\SFTP;

class Delhiverytrackingcron extends CI_Controller
{

    /** @var ScheduledJobLoggerService */
    private $scheduledJobService;

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('log_helper');
        $this->load->model('common');
        $this->load->model('Uniqlomodel');
        $this->scheduledJobService = ScheduledJobLoggerService::instance(get_class($this));
    }

    public function delhiveryOrderTracking()
    {
        $referencesAndOrders = $this->Uniqlomodel->getPushApiOrdersData();
        $this->scheduledJobService->log("delhiveryOrderTracking","Number of references in delhiveryOrderTracking(): " . count($referencesAndOrders));

        if (empty($referencesAndOrders)) {
            return;
        }

        foreach ($referencesAndOrders as $referenceAndOrder) {
            $refValue = $referenceAndOrder['refValue'];
            $requestData = "?waybill=" . $refValue . "&token=" . DELHIVERY_AUTH_TOKEN;
            $ediRequest = $requestData;
            $ediResponse = "Status check";
            $delhiveryEdiId = 8;
            $ediName = "Delhivery";
            $status = 0;

            $params = [
                'edi_type' => 2, /* 1->EDI Transport Order, 2->EDI Status */
                'transaction_id' => time(),
                'edi_id' => $delhiveryEdiId, /* edi id based on name take it from tb_edi_types */
                'edi_name' => $ediName,
                'bounded_type' => 1, /* 1->Inbound(partner => kN),2->Outbound (KN => partner) */
                'edi_format_type' => 'json',
                'status' => $status,
                'obj_type' => 1,
                'txn_obj_id' => $referenceAndOrder['ordersId'],
                'user_id' => 244,
                'company_code' => "INKN",
                'branch_code' => "INCL",
                'edi_request' => $ediRequest,
                'edi_response' => $ediResponse
            ];

            $edilogid = $this->common->insertTableData('tb_etn_edi_transactions', $params);

            $statusArray = [];
            $serverUrlBody = DELHIVERY_ORD_TRACK . "" . $requestData;

            $request = new HTTP_Request2();
            $request->setUrl($serverUrlBody);
            $request->setMethod(HTTP_Request2::METHOD_GET);
            $request->setConfig(getHttpRequestConfig());

            try {
                $response = $request->send();

                if ($response->getStatus() === 200) {
                    $delhiveryResponse = $ediResponse = $response->getBody();
                    $delhiveryResponse = json_decode($delhiveryResponse, true);
                    $statusArray = $this->dvordertrackupdate($delhiveryResponse, $referenceAndOrder['ordersId'], $referenceAndOrder['id'], $referenceAndOrder['refValue']);
                } else {
                    $this->scheduledJobService->log("delhiveryOrderTracking", "Delhivery API getStatus is not 200 but is: " . print_r($response->getStatus(), true));
                }

                if (!empty($statusArray)) {
                    $set = [
                        "status" => 1,
                        "user_id" => $statusArray['user_id'],
                        "company_code" => $statusArray['company_code'],
                        "branch_code" => $statusArray['branch_code'],
                        "edi_response" => $ediResponse
                    ];

                    $currentDate =  date('Y-m-d H:i:s');
                    $setPushData = ["queue_triggered" => '1',"triggered_datetime" => $currentDate];
                    $wherePushData = ["awbnum" => $referenceAndOrder['refValue']];

                    $this->common->updatetbledata("tb_uniqlo_push_api_data", $setPushData, $wherePushData);

                } else {
                    $set = array("status" => 0, "edi_response" => $ediResponse);
                }

                $where = ["id" => $edilogid];
                $this->common->updatetbledata("tb_etn_edi_transactions", $set, $where);
            } catch (HTTP_Request2_Exception $e) {
                $this->scheduledJobService->log("delhiveryOrderTracking", "Delhivery API error: " . print_r($e, true));
            }
        }
    }

    /**
     * Update trip statuses from delhivery API order tracking data
     */
    public function dvordertrackupdate($statusData, $orderId, $id, $awb)
    {
        $resp = [];
        $response = [];

        if(isset($statusData['Error']) && $statusData['Error'] === 'No such waybill or Order Id found') {
            $currentDate =  date('Y-m-d H:i:s');
            $setPushData = ["queue_triggered" => '1',"triggered_datetime" => $currentDate];
            $wherePushData = ["awbnum" => $awb];
            $this->common->updatetbledata("tb_uniqlo_push_api_data", $setPushData, $wherePushData);
            return;
        }

        if (isset($statusData['ShipmentData']) && !isset($statusData['Error'])) {
            foreach ($statusData['ShipmentData'] as $result) {
                $ship = $result['Shipment'];
                $scans = $ship['Scans'];
                $scansArray = [];

                foreach ($scans as $scan) {
                    $scansArray[] = $scan['ScanDetail'];
                }

                $reverseInTransitShipment = 0;

                if ($ship['ReverseInTransit']) {
                    $reverseInTransitShipment = 1;
                }

                $statusDateTime = $returnedDate = $destinationReceivedDate = $outToDestinationDate = $firstAttemptDate = null;

                if ($ship['Status']['StatusDateTime'] != "") {
                    $statusDateTime = date("Y-m-d H:i:s", strtotime($ship['Status']['StatusDateTime']));
                }

                if ($ship['ReturnedDate'] != "") {
                    $returnedDate = date("Y-m-d H:i:s", strtotime($ship['ReturnedDate']));
                }

                if ($ship['DestRecieveDate'] != "") {
                    $destinationReceivedDate = date("Y-m-d H:i:s", strtotime($ship['DestRecieveDate']));
                }

                if ($ship['OutDestinationDate'] != "") {
                    $outToDestinationDate = date("Y-m-d H:i:s", strtotime($ship['OutDestinationDate']));
                }

                if ($ship['FirstAttemptDate'] != "") {
                    $firstAttemptDate = date("Y-m-d H:i:s", strtotime($ship['FirstAttemptDate']));
                }

                $uniqloOrderTrackingData = [
                    'order_id' => $orderId,
                    'origin' => $ship['Origin'],
                    'status_name' => $ship['Status']['Status'],
                    'status_location' => $ship['Status']['StatusLocation'],
                    'status_datetime' => $statusDateTime,
                    'receivedby' => $ship['Status']['RecievedBy'],
                    'instructions' => $ship['Status']['Instructions'],
                    'status_type' => $ship['Status']['StatusType'],
                    'status_code' => $ship['Status']['StatusCode'],
                    'pickup_date' => $ship['PickUpDate'],
                    'charged_weight' => $ship['ChargedWeight'],
                    'order_type' => $ship['OrderType'],
                    'destination' => $ship['Destination'],
                    'returned_date' => $returnedDate,
                    'dest_recieve_date' => $destinationReceivedDate,
                    'origin_recieve_date' => $ship['OriginRecieveDate'],
                    'out_destination_date' => $outToDestinationDate,
                    'cod_amount' => $ship['CODAmount'],
                    'first_attempt_date' => $firstAttemptDate,
                    'reverse_ntransit' => $reverseInTransitShipment,
                    'sender_name' => $ship['SenderName'],
                    'dispatch_count' => $ship['DispatchCount'],
                    'invoice_amount' => $ship['InvoiceAmount'],
                    'status' => 1
                ];

                $orderTrackingWhere = array(
                    'order_id' => $orderId,
                    'status_name' => $ship['Status']['Status'],
                    'status_datetime' => $statusDateTime,
                    'status_type' => $ship['Status']['StatusType'],
                    'status_code' => $ship['Status']['StatusCode'],
                    'order_type' => $ship['OrderType']
                );
                $orderTrackingData = $this->common->gettblrowdata($orderTrackingWhere, "id", "tb_uniqlo_order_tracking", 0, 0);

                if (count($orderTrackingData) > 0) {
                    $orderTrackingId = ["id" => $orderTrackingData['id']];
                    $this->common->updatetbledata("tb_uniqlo_order_tracking", $uniqloOrderTrackingData, $orderTrackingId);
                } else {
                    $this->common->insertTableData("tb_uniqlo_order_tracking", $uniqloOrderTrackingData);
                }

                if (!empty($scansArray)) {
                    foreach ($scansArray as $scanResult) {
                        if (isset($scanResult['Scan'])) {
                            $scanDateTime = $scanStatusTime = null;

                            if ($scanResult['ScanDateTime'] != "") {
                                $scanDateTime = date("Y-m-d H:i:s", strtotime($scanResult['ScanDateTime']));
                            }

                            if ($scanResult['StatusDateTime'] != "") {
                                $scanStatusTime = date("Y-m-d H:i:s", strtotime($scanResult['StatusDateTime']));
                            }

                            $uniqloOrderScansData['order_id'] = $orderId;
                            $uniqloOrderScansData['scan_datetime'] = $scanDateTime;
                            $uniqloOrderScansData['scan_type'] = $scanResult['ScanType'];
                            $uniqloOrderScansData['scan_val'] = $scanResult['Scan'];
                            $uniqloOrderScansData['scan_status_time'] = $scanStatusTime;
                            $uniqloOrderScansData['scan_location'] = $scanResult['ScannedLocation'];
                            $uniqloOrderScansData['scan_instruction'] = $scanResult['Instructions'];
                            $uniqloOrderScansData['scan_status_code'] = $scanResult['StatusCode'];
                            $uniqloOrderScansData['call_duration'] = isset($scanResult['call_duration']) ? $scanResult['call_duration'] : 0;
                            $latitudeAndLongitude = isset($scanResult['geo_location']) ? $scanResult['geo_location'] : [];

                            if (!empty($latitudeAndLongitude)) {
                                $uniqloOrderScansData['scan_geo_lat'] = $latitudeAndLongitude['lat'];
                                $uniqloOrderScansData['scan_geo_lng'] = $latitudeAndLongitude['long'];
                            }

                            $uniqloOrderScansData['status'] = 1;

                            $orderTrackingWhere = array(
                                'order_id' => $orderId,
                                'scan_datetime' => $scanDateTime,
                                'scan_type' => $scanResult['ScanType'],
                                'scan_val' => $scanResult['Scan'],
                                'scan_instruction' => $scanResult['Instructions'],
                                'scan_status_code' => $scanResult['StatusCode']
                            );
                            $orderTrackingData = $this->common->gettblrowdata($orderTrackingWhere, "id", "tb_uniqlo_order_scans", 0, 0);

                            if (count($orderTrackingData) == 0) {
                                $this->common->insertTableData("tb_uniqlo_order_scans", $uniqloOrderScansData);
                            }
                        }
                    }
                }

                $ship['EWBN'] = isset($ship['EWBN']) ? $ship['EWBN'] : "";
                $response = [
                    'Status' => $ship['Status']['Status'],
                    'StatusLocation' => $ship['Status']['StatusLocation'],
                    'StatusDateTime' => $ship['Status']['StatusDateTime'],
                    'RecievedBy' => $ship['Status']['RecievedBy'],
                    'Instructions' => $ship['Status']['Instructions'],
                    'StatusType' => $ship['Status']['StatusType'],
                    'StatusCode' => $ship['Status']['StatusCode'],
                    'ref_num' => $ship['ReferenceNo'],
                    'CODAmount' => $ship['CODAmount'],
                    'EWBN' => $ship['EWBN'],
                    'SenderName' => $ship['SenderName'],
                    'AWB' => $ship['AWB'],
                    'DispatchCount' => $ship['DispatchCount'],
                    'InvoiceAmount' => $ship['InvoiceAmount'],
                    'ScanDetail' => $scansArray
                ];
            }
        }

        if (!empty($response)) {
            $currentDateTime = date("Y-m-d H:i:s");
            $response['Stop_Type'] = 'P';
            $inTransitStatus = [];

            if ($response['StatusType'] == "") {
                $response['StatusType'] = "UD";
            }

            $response['desc'] = "statustype: " . $response['StatusType'] . ", Desc:" . $response['Instructions'];

            if (($response['Status'] == "Manifested") || ($response['Status'] == "Open") || ($response['Status'] == "Shipment details manifested")) {
                $response['Status'] = "Manifested";
                $response['Status_Code'] = '0470';
                $response['Stop_Type'] = 'P';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if (isset($scanResult['Scan'])) {
                            if ($scanResult['Scan'] == "Manifested" || $scanResult['Scan'] == "Open") {
                                $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                            }
                        }
                    }
                }
            } elseif ($response['Status'] == "Not Picked") {
                $response['Status'] = "Gate In";
                $response['StatusID'] = 2;
                $response['Status_Code'] = '0420';
                $response['Stop_Type'] = 'P';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Not Picked") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "In Transit") {
                $response['Status'] = "In-Transit";
                $response['StatusID'] = 4;
                $response['Status_Code'] = '1550';
                $response['Stop_Type'] = 'P';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "In Transit" || $scanResult['Scan'] == "Pending") {
                            if ($scanResult['Instructions'] == "Shipment picked up") {
                                $inTransitStatus[] = array(
                                    'sts_name' => 'Pickup Or Drop',
                                    'stp_type' => 'P',
                                    'stscode' => '0500',
                                    'stsid' => 1,
                                    'time' => $scanResult['StatusDateTime'],
                                    'location' => $scanResult['ScannedLocation'],
                                    'desc' => $scanResult['Instructions']
                                );
                            }

                            if ($scanResult['Instructions'] == "Shipment Recieved at Origin Center") {
                                $inTransitStatus[] = array(
                                    'sts_name' => 'Gate Out',
                                    'stp_type' => 'P',
                                    'stscode' => '0191',
                                    'stsid' => 3,
                                    'time' => $scanResult['StatusDateTime'],
                                    'location' => $scanResult['ScannedLocation'],
                                    'desc' => $scanResult['Instructions']
                                );
                            }

                            if ($scanResult['Instructions'] == "Connected to destination") {
                                $inTransitStatus[] = array(
                                    'sts_name' => 'In-Transit',
                                    'stp_type' => 'P',
                                    'stscode' => '1550',
                                    'stsid' => 4,
                                    'time' => $scanResult['StatusDateTime'],
                                    'location' => $scanResult['ScannedLocation'],
                                    'desc' => $scanResult['Instructions']
                                );
                            }

                            if ($scanResult['Instructions'] == "Shipment Received at Facility") {
                                $inTransitStatus[] = array(
                                    'sts_name' => 'Shipment Received at Facility',
                                    'stp_type' => 'D',
                                    'stscode' => '2990',
                                    'stsid' => 0,
                                    'time' => $scanResult['StatusDateTime'],
                                    'location' => $scanResult['ScannedLocation'],
                                    'desc' => $scanResult['Instructions']
                                );
                            }

                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Pending") {
                $response['Status'] = "Pending";
                $response['Status_Code'] = '2989';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Pending") {
                            if ($scanResult['Instructions'] == "Shipment Received at Facility") {
                                $response['Status'] = "In-Transit";
                                $response['Status_Code'] = '2990';
                                $response['Stop_Type'] = 'D';
                                $statusType = 'yes';
                                $inTransitStatus[] = array(
                                    'sts_name' => 'Shipment Received at Facility',
                                    'stp_type' => 'D',
                                    'stscode' => '2990',
                                    'stsid' => 0,
                                    'time' => $scanResult['StatusDateTime'],
                                    'location' => $scanResult['ScannedLocation'],
                                    'desc' => $scanResult['Instructions']
                                );
                            }
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Dispatched") {
                $response['Status'] = "Gate In";
                $response['StatusID'] = 2;
                $response['Status_Code'] = '0192';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Dispatched" || $scanResult['Scan'] == "Out for delivery") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Delivered") {
                $response['Status'] = "Pickup Or Drop";
                $response['StatusID'] = 1;
                $response['Status_Code'] = '2300';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Delivered") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "RTO") {
                $response['Status'] = "RTO";
                $response['Status_Code'] = 'RTO';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "RTO") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Cancelled" || $response['Status'] == "Canceled") {
                $response['Status'] = "Cancelled";
                $response['StatusID'] = 19;
                $response['Status_Code'] = '3050';
                $response['Stop_Type'] = 'D';
                $statusType = 'no';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Cancelled" || $scanResult['Scan'] == "Canceled") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Closed") {
                $response['Status'] = "Closed";
                $response['Status_Code'] = '3051';
                $response['Stop_Type'] = 'D';
                $statusType = 'no';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Closed") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "DTO") {
                $response['Status'] = "DTO";
                $response['Status_Code'] = 'DTO';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "DTO") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Scheduled") {
                $response['Status'] = "Planned Delivery Date";
                $response['StatusID'] = 11;
                $response['Status_Code'] = '2400';
                $response['Stop_Type'] = 'P';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Scheduled") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } elseif ($response['Status'] == "Collected") {
                $response['Status'] = "Gate Out";
                $response['StatusID'] = 3;
                $response['Status_Code'] = '3000';
                $response['Stop_Type'] = 'D';
                $statusType = 'yes';

                if (!empty($response['ScanDetail'])) {
                    foreach ($response['ScanDetail'] as $scanResult) {
                        if ($scanResult['Scan'] == "Collected") {
                            $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                        }
                    }
                }
            } else {
                $response['Status_Code'] = $response['StatusCode'];
                $response['Stop_Type'] = $response['StatusType'];
                $statusType = 'no';
            }

            if ($response['Status_Code'] == "") {
                $response['Status_Code'] = $response['StatusType'];
            }
            $statusCode = $response['Status_Code'];

            if ($response['Stop_Type'] == "P" || $response['Stop_Type'] == "D") {
                $stopType = $response['Stop_Type'];
            } else {
                $stopType = "P";
            }

            $statusDate = $response['StatusDateTime'];
            $seldt = date("Y-m-d H:i:s", strtotime($statusDate));
            $currentTimeZone = "Asia/Kolkata";
            $dateTimeByTimezone = getdatetimebytimezone(DFLT_TZ, $seldt, $currentTimeZone);
            $stsdate = $dateTimeByTimezone['datetime'];
            $orderData = $this->common->gettblrowdata(
                ["id" => $orderId],
                "id,order_id,pickup_city,plat,plng,dlat,dlng,user_id,shift_id,trip_id,vendor_id,company_code,branch_code,created_source",
                "tb_orders",
                0,
                0
            );

            if ($orderData['trip_id'] == 0) {
                $acceptTrip = $this->accepttrip($orderData);
                $orderData['trip_id'] = $acceptTrip;
            }

            $resp['user_id'] = $orderData['user_id'];
            $resp['company_code'] = $orderData['company_code'];
            $resp['branch_code'] = $orderData['branch_code'];

            if ($orderData['created_source'] == 16) {
                if (($response['Status'] == "Scheduled") || ($response['Status'] == "Planned Delivery Date") || ($response['Status'] == "Pickup Scheduled")) {
                    $response['Status'] = "Pickup Scheduled";
                    $response['StatusID'] = 47;
                    $response['Status_Code'] = '2400';
                    $response['Stop_Type'] = 'P';
                    $statusType = 'yes';

                    if (!empty($response['ScanDetail'])) {
                        foreach ($response['ScanDetail'] as $scanResult) {
                            if ($scanResult['Scan'] == "Scheduled") {
                                $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                            }
                        }
                    }
                } elseif ($response['Status'] == "Dispatched" || ($response['Status'] == "Gate In" && $response['Stop_Type'] == "D")) {
                    $response['Status'] = "Gate In";
                    $response['StatusID'] = 2;
                    $response['Status_Code'] = '0191';
                    $response['Stop_Type'] = 'P';
                    $statusType = 'yes';

                    if (!empty($response['ScanDetail'])) {
                        foreach ($response['ScanDetail'] as $scanResult) {
                            if ($scanResult['Scan'] == "Dispatched" || $scanResult['Scan'] == "Out for pickup") {
                                $response['desc'] = "Time:" . $scanResult['StatusDateTime'] . ", Location:" . $scanResult['ScannedLocation'] . ", Desc:" . $scanResult['Instructions'];
                            }
                        }
                    }
                }
            }

            if ($response['Status'] == "Gate In" && $response['Stop_Type'] == "P") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } elseif ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "P") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } elseif ($response['Status'] == "Gate In" && $response['StatusID'] == "D") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } elseif ($response['Status'] == "Pickup Or Drop" && $response['StatusID'] == "D") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } elseif ($response['Status'] == "Gate Out" && $response['StatusID'] == "D") {
                $statusCode = $response['Status_Code'];
                $statusId = $response['StatusID'];
            } else {
                $status = $this->common->gettblrowdata(
                    ["status_name" => $response['Status'], "status_code" => $statusCode],
                    "id,status_code",
                    "tb_status_master",
                    0,
                    0
                );

                if (count($status) > 0) {
                    $statusCode = $status['status_code'];
                    $statusId = $status['id'];
                } else {
                    $statusMasterData = array(
                        'status_name' => $response['Status'],
                        'description' => $response['Status'],
                        'status_type' => $statusType,
                        'status_code' => $statusCode,
                        'customer_id' => 0,
                        'company_code' => $orderData['company_code'],
                        'branch_code' => $orderData['branch_code'],
                        'status' => 1,
                        'createdon' => $currentDateTime
                    );

                    $statusId = $this->common->insertTableData("tb_status_master", $statusMasterData);
                }
            }

            $resp['user_id'] = $orderData['user_id'];
            $resp['company_code'] = $orderData['company_code'];
            $resp['branch_code'] = $orderData['branch_code'];

            if ($response['Status'] == "In-Transit" && $response['StatusID'] == "4") {
                if (!empty($inTransitStatus)) {
                    foreach ($inTransitStatus as $transitStatus) {
                        if ($transitStatus['stsid'] == 0) {
                            $status = $this->common->gettblrowdata(
                                ["status_name" => $transitStatus['sts_name'], "status_code" => $transitStatus['stscode']],
                                "id,status_code",
                                "tb_status_master",
                                0,
                                0
                            );

                            if (count($status) > 0) {
                                $transitStatus['stsid'] = $status['id'];
                            } else {
                                $statusMasterData = [
                                    'status_name' => $transitStatus['sts_name'],
                                    'description' => $transitStatus['desc'],
                                    'status_type' => 'yes',
                                    'status_code' => $transitStatus['stscode'],
                                    'customer_id' => 0,
                                    'company_code' => $orderData['company_code'],
                                    'branch_code' => $orderData['branch_code'],
                                    'status' => 1,
                                    'createdon' => $currentDateTime
                                ];

                                $transitStatus['stsid'] = $this->common->insertTableData("tb_status_master", $statusMasterData);
                            }
                        }

                        $chqryx = $this->common->gettblrowdata(
                            [
                                "order_id" => $orderId,
                                "shipment_id" => $orderData['shift_id'],
                                "status_id" => $transitStatus['stsid'],
                                "status_code" => $transitStatus['stscode'],
                                "stop_type" => $transitStatus['stp_type']
                            ],
                            "id",
                            "tb_stop_status",
                            0,
                            0
                        );

                        if (count($chqryx) == 0) {
                            $stopId = $stopDetailId = $vehicleId = $driverId = 0;
                            $select = "id";
                            $shipOrderStopsTable = "tb_shiporder_stops";
                            $where = [
                                "shipment_id" => $orderData['shift_id'],
                                'stoptype' => $transitStatus['stp_type'],
                                "status" => 1
                            ];
                            $stopIdInfo = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                            if (count($stopIdInfo) > 0) {
                                $stopId = $stopIdInfo['id'];
                            }
                            $select = "id";
                            $shipOrderStopsTable = "tb_employee";
                            $where = array(
                                "shift_id" => $orderData['shift_id'],
                                "order_id" => $orderData['order_id'],
                                "status" => 1
                            );
                            $stopDetail = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                            if (count($stopDetail) > 0) {
                                $stopDetailId = $stopDetail['id'];
                            }
                            $select = "vehicle_id,driver_id";
                            $shipOrderStopsTable = "tb_trips";
                            $where = array("shift_id" => $orderData['shift_id'], "status" => 1);
                            $trip = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                            if (count($trip) > 0) {
                                $vehicleId = $trip['vehicle_id'];
                                $driverId = $trip['driver_id'];
                            }

                            $gentime1 = getdatetimebytimezone(DFLT_TZ, $transitStatus['time'], $currentTimeZone);
                            $stsdate2 = $gentime1['datetime'];
                            $stopStatusData = array(
                                "order_id" => $orderId,
                                "shipment_id" => $orderData['shift_id'],
                                "stop_id" => $stopId,
                                "stop_detail_id" => $stopDetailId,
                                "stop_type" => $transitStatus['stp_type'],
                                "trip_id" => $orderData['trip_id'],
                                "status_id" => $transitStatus['stsid'],
                                "loc_name" => $response['StatusLocation'],
                                "status" => 1,
                                "reason" => $response['desc'],
                                "vehicle_id" => $vehicleId,
                                "driver_id" => $driverId,
                                "status_code" => $transitStatus['stscode'],
                                "createdon" => $stsdate2
                            );

                            $this->common->insertTableData("tb_stop_status", $stopStatusData);
                        }
                    }
                }
                $resp['user_id'] = $orderData['user_id'];
                $resp['company_code'] = $orderData['company_code'];
                $resp['branch_code'] = $orderData['branch_code'];
            }

            $chqryx = $this->common->gettblrowdata(
                array(
                    "order_id" => $orderId,
                    "shipment_id" => $orderData['shift_id'],
                    "status_id" => $statusId,
                    "status_code" => $statusCode,
                    "stop_type" => $stopType
                ),
                "id",
                "tb_stop_status",
                0,
                0
            );

            if (count($chqryx) == 0) {
                $stopId = $stopDetailId = $vehicleId = $driverId = 0;
                $select = "id";
                $shipOrderStopsTable = "tb_shiporder_stops";
                $where = array("shipment_id" => $orderData['shift_id'], 'stoptype' => $stopType, "status" => 1);
                $stopIdInfo = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                if (count($stopIdInfo) > 0) {
                    $stopId = $stopIdInfo['id'];
                }

                $select = "id";
                $shipOrderStopsTable = "tb_employee";
                $where = array("shift_id" => $orderData['shift_id'], "order_id" => $orderData['order_id'], "status" => 1);
                $stopDetail = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                if (count($stopDetail) > 0) {
                    $stopDetailId = $stopDetail['id'];
                }

                $select = "vehicle_id,driver_id";
                $shipOrderStopsTable = "tb_trips";
                $where = ["shift_id" => $orderData['shift_id'], "status" => 1];
                $trip = $this->common->gettblrowdata($where, $select, $shipOrderStopsTable, 0, 0);

                if (count($trip) > 0) {
                    $vehicleId = $trip['vehicle_id'];
                    $driverId = $trip['driver_id'];
                }

                $stopStatusData = [
                    "order_id" => $orderId,
                    "shipment_id" => $orderData['shift_id'],
                    "stop_id" => $stopId,
                    "stop_detail_id" => $stopDetailId,
                    "stop_type" => $stopType,
                    "trip_id" => $orderData['trip_id'],
                    "status_id" => $statusId,
                    "loc_name" => $response['StatusLocation'],
                    "status" => 1,
                    "reason" => $response['desc'],
                    "vehicle_id" => $vehicleId,
                    "driver_id" => $driverId,
                    "status_code" => $statusCode,
                    "createdon" => $stsdate
                ];

                $this->common->insertTableData("tb_stop_status", $stopStatusData);
                $resp['user_id'] = $orderData['user_id'];
                $resp['company_code'] = $orderData['company_code'];
                $resp['branch_code'] = $orderData['branch_code'];
            } else {
                $reasonDescription = ["reason" => $response['desc']];
                $whereId = ["id" => $chqryx['id']];

                $this->common->updatetbledata("tb_stop_status", $reasonDescription, $whereId);
            }

            if ($orderData['created_source'] != "16") {
                if ($stopType == "D" && ($statusCode == "2300" || $statusCode == "3000" || $statusCode == "DTO")) {
                    $tripsData = [];
                    $tripId = ["id" => $orderData['trip_id']];
                    $tripsData["end_imei"] = "";
                    $tripsData["end_reading"] = '0';
                    $tripsData["etime"] = $tripsData["updated_on"] = $stsdate;
                    $tripsData["status"] = '0';
                    $tripsData["transit_status"] = '1';
                    $this->common->updatetbledata(
                        "tb_orders",
                        ["trip_sts" => '1'],
                        ["id" => $orderId, "trip_id <>" => 0]
                    );

                    $this->common->updatetbledata("tb_trips", $tripsData, $tripId);
                    $this->common->updatetbledata(
                        "tb_orders",
                        ["trip_sts" => '1'],
                        ["id" => $orderId, "shift_id" => $orderData['shift_id']]
                    );
                    $tripType = 0;
                   // $this->generateSummary($orderData['trip_id'], $currentTimeZone, $tripType);
                }
            }
        }
        return $resp;
    }

    /**
     * generate trip summary after trip status closed/delivered
     */
    public function generateSummary($tripId, $currentTimeZone, $tripType)
    {
        if ($tripId != "") {
            if ($currentTimeZone == "") {
                $currentTimeZone = date_default_timezone_get();
            }

            if ($tripType == "") {
                $tripType = 0;
            }

            $logDate = date('Y-m-d H:i:s');
            $actualTimeZone = getdatetimebytimezone(DFLT_TZ, $logDate, $currentTimeZone);
            $currentDateTime = $actualTimeZone['datetime'];
            $registerNumber = "";
            $sql = $this->db->query(
                "SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $currentTimeZone . "') as stime,convertToClientTZ(etime,'" . $currentTimeZone . "') as etime,etime as tetime, start_imei, end_imei, start_reading,end_reading,trip_type,plat,plng FROM tb_trips WHERE id=$tripId AND status=0 LIMIT 1"
            );

            if ($sql->num_rows() > 0) {
                $data = [];
                $data['driver_name'] = $data['driver_num'] = "";
                $shiftId = $sql->row()->shift_id;
                $sql1 = $this->db->query(
                    "SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $currentTimeZone . "') as startdate, convertToClientTZ(enddate,'" . $currentTimeZone . "') as enddate,splace,eplace,elat,elng FROM tb_shifts WHERE id=" . $shiftId . " LIMIT 1"
                );
                $data["trip"] = $sql1->row();
                $employee1 = $this->db->query(
                    "select e.name,convertToClientTZ(te.stime,'" . $currentTimeZone . "') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=" . $tripId
                );
                $employee = $this->db->query(
                    "SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripId
                );
                $startTime = $sql->row()->stime;
                $endTime = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $endImei = $sql->row()->end_imei;
                $driverId = $sql->row()->driver_id;
                $vehicleId = $sql->row()->vehicle_id;
                $startDate = $sql1->row()->startdate;
                $endDate = $sql1->row()->enddate;
                $userId = $sql1->row()->user_id;
                $odometerStart = trim($sql->row()->start_reading);
                $odometerEnd = trim($sql->row()->end_reading);
                $vendorId = 0;
                $deliveryLatitude = $deliveryLongitude = "";
                $trucksDataQuery = $this->common->gettblrowdata(
                    ["id" => $vehicleId],
                    "truck_capacity,register_number,vendor_id,truck_weight,truck_volume,latitude,longitude",
                    "tb_trucks_data",
                    0,
                    0
                );
                $cabCapacity = $truckWeight = $truckVolume = 0;

                if (count($trucksDataQuery) > 0) {
                    $cabCapacity = $trucksDataQuery['truck_capacity'];
                    $registerNumber = $trucksDataQuery['register_number'];
                    $vendorId = $trucksDataQuery['vendor_id'];
                    $truckWeight = $trucksDataQuery['truck_weight'];
                    $truckVolume = $trucksDataQuery['truck_volume'];
                    $deliveryLatitude = $trucksDataQuery['latitude'];
                    $deliveryLongitude = $trucksDataQuery['longitude'];
                }

                if ($deliveryLatitude == "") {
                    $deliveryLatitude = $sql->row()->plat;
                    $deliveryLongitude = $sql->row()->plng;
                }

                if ($deliveryLatitude == $sql->row()->plat) {
                    $deliveryLatitude = $sql1->row()->elat;
                    $deliveryLongitude = $sql1->row()->elng;
                }

                $whereTripId = ["id" => $tripId];
                $setTrip = ["dlat" => $deliveryLatitude, "dlng" => $deliveryLongitude];

                $this->db->where($whereTripId)->update("tb_trips", $setTrip);
                $tripInfo = array(
                    "plat" => $sql->row()->plat,
                    "plng" => $sql->row()->plng,
                    "dlat" => $deliveryLatitude,
                    "dlng" => $deliveryLongitude
                );
                $data['tripinfo'] = (object)$tripInfo;

                if ($cabCapacity == "") {
                    $cabCapacity = 0;
                }

                $regg = $this->db->query(
                    "select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverId LIMIT 1"
                );

                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;

                    if ($vendorId == 0 && $vnid != 0) {
                        $vendorId = $vnid;
                    }
                }

                $sql2 = $this->db->query(
                    "select latitude,longitude,convertToClientTZ(`timestamp`,'" . $currentTimeZone . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$endTime' and timestamp>='$startTime' order by timestamp asc"
                );
                $flag = 0;
                $latitude = $longitude = 0;
                $distance = 0;

                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $distanceBetweenCoordinates = calculateDistance12($latitude, $longitude, $row->latitude, $row->longitude);
                            $distance = $distance + $distanceBetweenCoordinates;
                        }
                        $latitude = $row->latitude;
                        $longitude = $row->longitude;
                    }
                }

                $attemptEmployee = 1;
                $totalNumberOfAttempts = getempcount($tripId);

                if ($employee->num_rows() > 0) {
                    $attemptEmployee = $employee->row()->attcnt;
                }

                $data["noofemp"] = $totalNumberOfAttempts;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);

                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }

                $tripSummaryData = array(
                    'trip_id' => $tripId,
                    'vehicle_id' => $vehicleId,
                    'driver_id' => $driverId,
                    'vendor_id' => $vendorId,
                    'trip_distance' => $distance,
                    'no_of_emp' => $totalNumberOfAttempts,
                    'attended_emp' => $attemptEmployee,
                    'start_imei' => $imei,
                    'end_imei' => $endImei,
                    'start_time' => $startDate,
                    'end_time' => $endDate,
                    'user_id' => $userId,
                    'cab_capacity' => $cabCapacity,
                    'trip_status' => 1,
                    'trip_type' => $tripType,
                    'ship_delay' => $driver_late,
                    'createdon' => $currentDateTime
                );
                $chktrip = $this->common->gettblrowdata(["trip_id" => $tripId], "id", "tb_trip_summary", 0, 0);

                if (count($chktrip) == 0) {
                    log_error(
                        UNIQLO_LOG_PREFIX .
                        "Uniqlo Cronjob generatesummary inserted data in a tb_trip_summary: " . implode(', ', $tripSummaryData)
                    );

                    $this->common->insertTableData("tb_trip_summary", $tripSummaryData);
                }
                $data["trip_id"] = $tripId;

                if ($tripType != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }

                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $distance;
                $data["stime"] = $startDate;
                $data["etime"] = $endDate;
                $data["simei"] = $imei;
                $data["eimei"] = $endImei;

                if ($odometerEnd == "") {
                    $odometerEnd = 0;
                }

                if ($odometerStart == "") {
                    $odometerStart = 0;
                }

                $data["odometer"] = ($odometerEnd - $odometerStart);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cabCapacity;
                $data["employees"] = $employee1;
                $data["trip_type"] = $tripType;
                $data["register_number"] = $registerNumber;
                $data["truck_weight"] = $truckWeight;
                $data["truck_volume"] = $truckVolume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where(
                    "tb_users",
                    array(
                        "id" => $userId,
                        "emailid !=" => ""
                    ),
                    1,
                    0
                );

                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @array(
                        'trip_id' => $tripId,
                        'shift_id' => $shiftId,
                        'splace' => $data["trip"]->splace,
                        'eplace' => $data["trip"]->eplace,
                        'stime' => $startDate,
                        'etime' => $endDate,
                        'capacity' => $cabCapacity,
                        'simei' => $data['simei'],
                        'eimei' => $data['eimei'],
                        'totcnt' => $totalNumberOfAttempts,
                        'attcnt' => $attemptEmployee,
                        'distance' => $data['distance'],
                        'odometer' => $data['odometer'],
                        'driver_late' => $data['driver_late'],
                        'receivemail' => $receivemail,
                        'receivename' => $receivename,
                        'user_id' => $userId,
                        'createdon' => $currentDateTime
                    );

                    $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);

                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }

                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');

                    if ($tripType == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }

                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $this->email->send();
                }
            }
        }
    }

    /**
     * if awb generated, update the accept trip status, here while accept, need to create data in tb_trips table for trip, status in tb_stop_status table
     */
    public function accepttrip($orddata)
    {
        $vehicle_id = $driver_id = 0;
        $imei = "";
        $getvehicleid = $this->common->gettblrowdata(
            array('shft_id' => $orddata['shift_id']),
            "vehicle_id",
            "tb_shft_veh",
            0,
            0
        );

        if (count($getvehicleid) > 0) {
            $vehicle_id = $getvehicleid['vehicle_id'];
        }

        if ($vehicle_id > 0) {
            $getdriverid = $this->common->gettblrowdata(
                array('vehicle_id' => $vehicle_id, 'status' => '1'),
                "driver_id,imei",
                "tbl_assigned_drivers",
                0,
                0
            );

            if (count($getdriverid) > 0) {
                $driver_id = $getdriverid['driver_id'];
                $imei = $getdriverid['imei'];
            }
        }

        $latitude = $longitude = "";

        if ($orddata['plat'] != "" && $orddata['plng'] != "") {
            $latitude = $orddata['plat'];
            $longitude = $orddata['plng'];
        } else {
            $chklatlng = $this->common->gettblrowdata(
                array("user_id" => $orddata['user_id']),
                "latitude,longitude",
                "tb_site_settings",
                0,
                0
            );

            if (count($chklatlng) > 0) {
                $latitude = $chklatlng['latitude'];
                $longitude = $chklatlng['longitude'];
            }
        }
        $curdt = date("Y-m-d H:i:s");
        $curtz = "Asia/Kolkata";
        $gentime = getdatetimebytimezone(DFLT_TZ, $curdt, $curtz);
        $stsdate = $gentime['datetime'];
        $triparr = array(
            'shift_id' => $orddata['shift_id'],
            'vehicle_id' => $vehicle_id,
            'driver_id' => $driver_id,
            'stime' => $stsdate,
            'start_imei' => $imei,
            'splace' => "",
            'eplace' => "",
            'start_reading' => 0,
            'end_reading' => 0,
            'created_on' => $stsdate,
            'updated_on' => $curdt,
            'status' => 1,
            'trip_type' => 0,
            'transit_status' => 0,
            'plat' => $latitude,
            'plng' => $longitude
        );

        $trip = $this->common->insertTableData('tb_trips', $triparr);
        $stid = 10;
        $stcode = '0212';
        $insarry = array(
            "order_id" => $orddata['id'],
            "shipment_id" => $orddata['shift_id'],
            "stop_id" => 0,
            "stop_detail_id" => 0,
            "stop_type" => "",
            "trip_id" => $trip,
            "status_id" => $stid,
            "latitude" => $latitude,
            "longitude" => $longitude,
            "status" => 1,
            "reason" => "From Admin",
            "vehicle_id" => $vehicle_id,
            "driver_id" => $driver_id,
            "status_code" => $stcode,
            "createdon" => $stsdate
        );

        $this->db->insert("tb_stop_status", $insarry);
        $set = array("trip_id" => $trip);
        $whr = array("id" => $orddata['id']);

        $this->common->updatetbledata("tb_orders", $set, $whr);

        if ($orddata['created_source'] == "16") {
            $sts = $this->common->gettblrowdata(
                array("status_name" => "Planned Pickup Date", "status_code" => "0106"),
                "id,status_code",
                "tb_status_master",
                0,
                0
            );

            if (count($sts) > 0) {
                $stscode1 = $sts['status_code'];
                $stsid1 = $sts['id'];
            } else {
                $stscode1 = '0106';
                $arr = array(
                    'status_name' => 'Planned Pickup Date',
                    'description' => 'Planned Pickup Date',
                    'status_type' => 'yes',
                    'status_code' => '0106',
                    'customer_id' => 0,
                    'company_code' => $orddata['company_code'],
                    'branch_code' => $orddata['branch_code'],
                    'status' => 1,
                    'createdon' => $curdt
                );

                $stsid1 = $this->common->insertTableData("tb_status_master", $arr);
            }
            $chqryx = $this->common->gettblrowdata(
                array(
                    "order_id" => $orddata['id'],
                    "shipment_id" => $orddata['shift_id'],
                    "status_id" => $stsid1,
                    "status_code" => $stscode1,
                    "stop_type" => 'P'
                ),
                "id",
                "tb_stop_status",
                0,
                0
            );

            if (count($chqryx) == 0) {
                $stop_id = $stop_detail_id = 0;
                $select = "id";
                $table = "tb_shiporder_stops";
                $where = array("shipment_id" => $orddata['shift_id'], 'stoptype' => 'P', "status" => 1);
                $stopidinfo = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stopidinfo) > 0) {
                    $stop_id = $stopidinfo['id'];
                }

                $select = "id";
                $table = "tb_employee";
                $where = array("shift_id" => $orddata['shift_id'], "order_id" => $orddata['order_id'], "status" => 1);
                $stop_detail = $this->common->gettblrowdata($where, $select, $table, 0, 0);

                if (count($stop_detail) > 0) {
                    $stop_detail_id = $stop_detail['id'];
                }

                $dt = date("Y-m-d");
                $dt1 = strtotime($dt);
                $dt2 = date("l", $dt1);
                $dt3 = strtolower($dt2);
                $cur = date($stsdate, strtotime('+12 hours'));

                if ($dt3 == "saturday") {
                    if (date('H') >= 18) {
                        $cur = date("Y-m-d" . " 23:59:59", strtotime($cur . '+36 hours'));
                    } elseif (date('H') <= 6) {
                        $cur = date('Y-m-d H:i:s', strtotime($cur . '+12 hours'));
                    } else {
                        $cur = date("Y-m-d H:i:s", strtotime('+12 hours'));
                    }
                } elseif ($dt3 == "sunday") {
                    $cur = date("Y-m-d" . " 23:59:59", strtotime($cur . '+12 hours'));
                }

                $insarry = array(
                    "order_id" => $orddata['id'],
                    "shipment_id" => $orddata['shift_id'],
                    "stop_id" => $stop_id,
                    "stop_detail_id" => $stop_detail_id,
                    "stop_type" => 'P',
                    "trip_id" => $trip,
                    "status_id" => $stsid1,
                    "loc_name" => $orddata['pickup_city'],
                    "status" => 1,
                    "reason" => 'Planned Pickup Date',
                    "vehicle_id" => $vehicle_id,
                    "driver_id" => $driver_id,
                    "status_code" => $stscode1,
                    "createdon" => $cur
                );

                $this->common->insertTableData("tb_stop_status", $insarry);
            }
        }

        return $trip;
    }

}
