<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

use Mpdf\Mpdf;

class DeliveryDocument extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common', 'DeliveryDocumentModel', 'PodUpload']);
        $this->load->library(['StatusRemappingService']);
    }

    public function index(int $orderId): void
    {
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        if (empty($orderId)) {
            redirect("admin/doneorders");
        }
        $getOrderData = $this->DeliveryDocumentModel->getOrderData($orderId);
        if (empty($getOrderData)) {
            redirect("admin/doneorders");
        }
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];
        $addresses = $this->getAddress($getOrderData);
        $partyNames = $this->DeliveryDocumentModel->getOrderPartyData(['Customer', 'Consignee', 'Shipper', 'Carrier'], $orderId);
        $companyCode = $this->session->userdata("company_code");
        if ($getOrderData['shift_id'] > 0) {
            $milestoneStatuses = $this->DeliveryDocumentModel->getMilestoneStatuses($getOrderData['shift_id'], $currentTimeZone);
            if ($partyNames['carrier'] != "") {
                $customStatusesByCarrierName = $this->statusremappingservice->getCustomStatusesByCarrierName($partyNames['carrier'],$companyCode);
            }
            $statuses = $this->parseStatuses($milestoneStatuses, ($customStatusesByCarrierName ?? []));
        }
        $orderData = [
            'orderData' => $getOrderData,
            'shipperAddress' => $addresses['pickup_address'],
            'consigneeAddress' => $addresses['delivery_address'],
            'epods' => $this->PodUpload->getPodUploadsWithDetailsByOrderId($orderId),
            'partyNames' => $partyNames,
            'vehicleData' => $this->DeliveryDocumentModel->getVehicleData($orderId),
            'cargoDetails' => $this->DeliveryDocumentModel->getCargoDetails($orderId),
            'transportMode' => $this->DeliveryDocumentModel->getOrderTransportMode($getOrderData['transport_mode']),
            'statuses' => $this->statusremappingservice->getCompanySpecificOrderStatuses($statuses ?? [] , $companyCode),
            'timeZone' => $currentTimeZone,
            'manifestId' => $this->DeliveryDocumentModel->getManifestId($orderId),
            'showCarrier' => true
        ];
        $this->generatePdf($orderData, $getOrderData['order_id']);
    }

    protected function getAddress(array $getOrderData): array
    {
        $pickupStreet = empty($getOrderData['pickup_address2'])
            ? $getOrderData['pickup_address1']
            : $getOrderData['pickup_address1'] . "\n" . $getOrderData['pickup_address2'];
        $deliveryStreet = empty($getOrderData['delivery_address2'])
            ? $getOrderData['delivery_address1']
            : $getOrderData['delivery_address1'] . "\n" . $getOrderData['delivery_address2'];
        $addresses['pickup_address'] = $getOrderData['pickup_company'] . "<br/>" . $pickupStreet . " " . $getOrderData['pickup_pincode'] . "<br/>" . $getOrderData['pickup_city'] . " " . $getOrderData['pickup_country'];
        $addresses['delivery_address'] = $getOrderData['delivery_company'] . "<br/>" . $deliveryStreet . " " . $getOrderData['delivery_pincode'] . "<br/>" . $getOrderData['delivery_city'] . " " . $getOrderData['delivery_country'];
        return $addresses;
    }

    protected function parseStatuses(array $milestoneStatuses, array $customStatusesByCarrierName): array
    {
        $statuses = [];
        foreach ($milestoneStatuses as $milestoneStatus) {
            $locationName = $milestoneStatus['loc_name'];
            if ($locationName == "") {
                $locationName = getLocationName($milestoneStatus['latitude'], $milestoneStatus['longitude']);
            }
            if (!empty($customStatusesByCarrierName) && isset($customStatusesByCarrierName[$milestoneStatus['status_code']])) {
                $milestoneStatus['status_name'] = $customStatusesByCarrierName[$milestoneStatus['status_code']];
            }
            $statuses[] = [
                'status_code' => $milestoneStatus['status_code'],
                'status_name' => $milestoneStatus['status_name'],
                'date' => $milestoneStatus['createdon'],
                'location' => $locationName
            ];
        }
        return $statuses;
    }

    private function generatePdf(array $orderData, string $bookingId): void
    {
        $pdf = new Mpdf([
            'tempDir' => FCPATH . 'assets/tmp',
            'default_font_size' => 8,
            'format' => 'A4-L',
            'autoScriptToLang' => true,
            'autoLangToFont' => true
        ]);
        $pdf->WriteHTML($this->load->view('deliverydocument/deliverydocument', $orderData, true));
        $pdf->Output('Delivery_Document_' . $bookingId . '.pdf', 'D');
    }
}
