<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";
require_once APPPATH . "/third_party/PHPExcel/Writer/Excel2007.php";

class Destinationbranchcodes extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('common');
    }

    public function index(int $successId = null): void
    {
        $companyCode = $this->session->userdata("company_code");
        $codes = $data = [];
        $data['page_title'] = "Destination Branch Codes";
        if ($companyCode == "NZPG") {
            $getDestinationCodes = $this->common->gettbldata([], "*", "tb_destination_branch_codes", 0, 0);
            foreach ($getDestinationCodes as $eachRow) {
                $codes[] = ['id' => $eachRow['id'], 'province' => $eachRow['province'],'city'=>$eachRow['city'], 'destination_branch_code' => $eachRow['destination_branch_code'],'location_code'=>$eachRow['location_code'], 'createdon' => $eachRow['createdon'],'status'=>$eachRow['status']];
            }
        }
        $data['codes'] = $codes;
        $data['successId'] = $successId;
        $this->newtemplate->dashboard("destinationbranchcodes/listpage", $data);
    }

    public function uploadbranchcodes(): void
    {
        $companyCode = $this->session->userdata('company_code');
        if ($companyCode != "NZPG") {
            redirect('destinationbranchcodes/index/0');
        }
        $createdOn = date("Y-m-d H:i:s");
        try {
            if ($_FILES['import_file']['size'] > 0) {
                $inputExcel = $_FILES['import_file']['tmp_name'];
                $objPHPExcel = PHPExcel_IOFactory::load($inputExcel);
                $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, true, true, true);
                for ($i = 2; $i <= count($sheetData); $i++) {
                    $province = trim( $sheetData[$i]['A'] ?? "" );
                    $locationCode = trim( $sheetData[$i]['B'] ?? "" );
                    $givenCity = trim( $sheetData[$i]['C'] ?? "" );
                    $branchCode = trim( $sheetData[$i]['D'] ?? "" );
                    $city = str_replace("TLD ","",$givenCity);
                    if (!in_array('', [$province, $branchCode])) {
                        $checkQuery = $this->common->gettblrowdata(['province' => $province,'city'=>$city, 'status' => '1'], "id", "tb_destination_branch_codes", 0, 0);
                        if(empty($checkQuery)){
                            $insertQuery = $this->common->insertTableData("tb_destination_branch_codes", ['province' => $province,'location_code'=>$locationCode,'city'=>$city, 'destination_branch_code' => $branchCode, 'status' => '1', 'createdon' => $createdOn]);
                        }
                    }
                }
            }
            redirect('destinationbranchcodes/index/1');
        } catch (Exception $e) {
            log_error($e->getMessage());
        }
    }
}
?>
