<?php defined('BASEPATH') or exit('No direct script access allowed');

class Documentcontrol extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library( 'session' );
		if ( $this->session->userdata( 'user_id' ) == '' ) {
			redirect( 'login' );
		}
		if ( $this->session->userdata( 'company_code' ) == "UKKN" ) {
			redirect( 'amzorders' );
		}
		$this->load->library( 'form_validation' );
		$this->load->model( 'Order' );
		$this->load->model( 'common' );
		$this->load->helper( 'generic' );
		$this->load->library( 'email' );
		$this->load->helper('log_helper');
        if (!checkUrlAccessForUser('DOCUMENTCONTROL')) {
            redirect("Forbiddenaccess");
        }
	}

	public function index( $id = NULL ) {
		if ( $id != "" ) {
			$this->doclist( $id );
		} else {
			$this->doclist();
		}
	}

	public function doclist( $id = NULL ) {
		$data['page_title'] = $this->lang->line( 'doc_list' );
		$data['sub_title']  = $this->lang->line( 'menu_doc_ctrl_list' );
		$order              = $country_userids = array();
		$userid             = $this->session->userdata( "user_id" );
		$custid             = $this->session->userdata( "cust_id" );
		$country_userids    = $this->session->userdata( "country_user_ids" );
		$whr                = $searchids = array();
		$post               = array();
		if ( $id != "" ) {
			$searchids         = array( $id );
			$post['bookingid'] = array();
			$getbooking_id     = $this->common->gettblrowdata( array( 'id' => $id ), "order_id", "tb_orders", 0, 0 );
			if ( ! empty( $getbooking_id ) ) {
				$post['bookingid'] = array( $getbooking_id['order_id'] );
			}
			$data['getbookingid'] = $this->db->escape_str($post['bookingid']);
		}
		$status_search = "";
		if ( isset( $_POST['searchsubmit'] ) && $_POST['searchsubmit'] == "Search" ) {
			$post = $_POST;
		}
		if ( ! empty( $post ) ) {
			$whr            = $this->searchorders( $post );
			$order_status   = isset( $post['status'] ) ? $this->db->escape_str($post['status']) : "";
			$ad_orderstatus = isset( $post['order_status'] ) ? $this->db->escape_str($post['order_status']) : "";
			$status_search  = $order_status;
			if ( $status_search == "" ) {
				$status_search = $ad_orderstatus;
			}
			$searchids = isset( $post['bookingid'] ) ? $this->db->escape_str($post['bookingid']) : array();


			$company_code = $this->session->userdata( 'company_code' );
			$branch_code  = $this->session->userdata( 'branch_code' );
			$subcusts     = array();
			$role_id      = $this->session->userdata( 'user_role_id' );
			if ( $role_id == "4" ) {
				if ( $this->session->userdata( 'sub_cust' ) ) {
					$subcusts = $this->session->userdata( 'sub_cust' );
					if ( ! empty( $subcusts ) ) {
						array_push( $subcusts, $custid );
					}
				}
			}
			$orderdata = $this->Order->getorderdatamini( $userid, $searchids, $status_search, $custid, $country_userids, $whr, $subcusts );
//			echo $this->db->last_query(); exit;
//			echo json_encode($orderdata); exit;
			if ( ! empty( $orderdata ) ) {
				$au_i = - 1;
				foreach ( $orderdata as $res ) {
					$au_i ++;
					$delivery_note = $container_no = $manifestno = "";
					$po_ref        = "N/A";
					$car_od_1      = "N/A";
					$car_od_2      = "N/A";
					$shipmentid    = $res['shipment_id'];
					$trip_no       = $res['shipmentid'];
					if ( $trip_no == '0' ) {
						$trip_no = "";
					}
					$shift_id     = $res['shift_id'];
					$trip_sts     = $res['trip_sts'];
					$otherstatus  = $res['order_status'];
					$trip_id      = $res['trip_id'];
					$order_status = 'PENDING';
					if ( $trip_id != 0 && $trip_sts == 0 ) {
						$order_status = 'ACTIVE';
					}
					if ( $trip_id != 0 && $trip_sts == 1 ) {
						$order_status = 'CLOSED';
					}
					if ( $order_status == 'PENDING' && $res['company_code'] == 'AUKN' ) {
						$statuslist = $this->db->select( "status_code" )->order_by( "id", "DESC" )->get_where( "tb_order_status", array( 'order_id' => $res['id'], 'status' => '1' ) );
						if ( $statuslist->num_rows() > 0 ) {
							$status_code = $statuslist->row()->status_code;
							if ( $status_code == '2491' ) {
								$order_status = "SCANNED";
							}
							if ( $status_code == '2492' ) {
								$order_status = 'MANIFESTED';
							}
						}
					}
					$otherstatus = strtoupper( $res['order_status'] );
					if ( $otherstatus == "" ) {
						$chkdetails = $this->db->select( "order_status" )->get_where( "tb_order_details", array( 'order_row_id' => $res['id'] ) );
						if ( $chkdetails->num_rows() > 0 ) {
							$otherstatus = $chkdetails->row()->order_status;
						}
					}
					if ( $otherstatus == 'READY' ) {
						$otherstatus = 'READY';
					} else if ( $otherstatus == 'INVOICE' ) {
						$otherstatus = 'INVOICE';
					} else {
						$otherstatus = "";
					}

					$getdnote = $this->db->query(
						"SELECT reference_id, ref_value
						FROM tb_order_references
						WHERE order_id = ? AND reference_id IN ('DQ', 'CTR', 'MN', 'PO', 'RUCK', 'RUCKSN')",
						[$res['id']]
					);
					if ( $getdnote->num_rows() > 0 ) {
						foreach ( $getdnote->result() as $ref ) {
							$ref_id = $ref->reference_id;
							if ( $ref_id == "DQ" ) {
								$delivery_note = $ref->ref_value;
							}
							if ( $ref_id == "CTR" ) {
								$container_no = $ref->ref_value;
							}
							if ( $ref_id == 'MN' ) {
								$manifestno = $ref->ref_value;
							}
							if ( $ref_id == 'PO' ) {
								$po_ref = $ref->ref_value;
							}
							if ( $ref_id == 'RUCK' ) {
								$car_od_1 = $ref->ref_value;
							}
							if ( $ref_id == 'RUCKSN' ) {
								$car_od_2 = $ref->ref_value;
							}
						}
					}
					$chkdate      = '2020-07-01 00:00:00';
					$createdon    = $res['createdon'];
					$order_str    = strtotime( $createdon );
					$chk_str      = strtotime( $chkdate );
					$early_pickup = $res['pickup_datetime'];

					$early_delivery = $res['delivery_datetime'];
					$curtz          = $this->session->userdata( "usr_tzone" )['timezone'];
					if ( $order_str > $chk_str ) {
						if ( $early_pickup != "" && $early_pickup != "0000-00-00 00:00:00" ) {
							$epickup      = getdatetimebytimezone( $curtz, $early_pickup, DFLT_TZ );
							$early_pickup = $epickup['datetime'];
						}
						if ( $early_delivery != "" && $early_delivery != "0000-00-00 00:00:00" ) {
							$edelivery      = getdatetimebytimezone( $curtz, $early_delivery, DFLT_TZ );
							$early_delivery = $edelivery['datetime'];
						}
					}
					$html = $status = "";

					$docs_sent_datetime = @$this->getDocDates( $res['id'] )->docs_sent_datetime;
					if ( $docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00" ) {
						$docsent            = getdatetimebytimezone( $curtz, $docs_sent_datetime, DFLT_TZ );
						$docs_sent_datetime = $docsent['datetime'];
					}
					$docs_received_datetime = @$this->getDocDates( $res['id'] )->docs_received_datetime;
					if ( $docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00" ) {
						$docrec                 = getdatetimebytimezone( $curtz, $docs_received_datetime, DFLT_TZ );
						$docs_received_datetime = $docrec['datetime'];
					}

					$order[] = array(
						'order_row_id'           => $res['id'],
						'order_id'               => $res['order_id'],
						'delivery'               => $res['delivery'],
						'purchase_order'         => $po_ref,
						'pickup'                 => $res['pickup'],
						'delivery_note'          => $delivery_note,
						'customer_name'          => @$this->getCustomers( $res['customer_id'] )->customer_name,
//						'vendor_id'              => $res['vendor_id'],
						'carrier_name'           => ( $res['vendor_id'] == 0 ) ? 'N/A' : @$this->getCarrier( $res['vendor_id'] )->vendor_name,
						'trip_no'                => $trip_no,
						'order_status'           => $order_status,
						'transport_mode'         => $res['transport_mode'],
						'createdon'              => $createdon,
						'carrier_order_id1'      => ( $car_od_1 ) ? $car_od_1 : "N/A",
						'carrier_order_id2'      => $car_od_2,
//						'total_packages'         => round( $res['totqty'] ),
//						'weight'                 => $res['totwg'],
//						'volume'                 => $res['totvol'],
						'company_code'           => $res['company_code'],
						'branch_code'            => $res['branch_code'],
						'department_code'        => $res['department_code'],
						'otherstatus'            => $otherstatus,
						'delivery_date'          => $early_delivery,
						'pickup_date'            => $early_pickup,
						'html'                   => $html,
						'container_no'           => $container_no,
//						'vendor_name'     => $vendor_name,
						'manifestno'             => $manifestno,
						'num_of_pallets'         => $res['num_of_pallets'],
						'docs_received_datetime' => $docs_received_datetime,
						'docs_sent_datetime'     => $docs_sent_datetime,
						'doc_comment'            => @$this->getDocComment( $res['id'] )->doc_comment,
						'place_count'            => @$this->getDocPlaceCount( $res['id'] )->place_count,
					);


				}
			}
		}

		$data['order']     = $order;
		log_error("Document Control List : " . json_encode($data['order']));
		$data['bill_type'] = "Svkonekt";
		$company_code      = $this->session->userdata( 'company_code' );
		$branch_code       = $this->session->userdata( 'branch_code' );
		$getbilltype       = $this->db->select( "bill_type" )->get_where( "tb_branch_master", array( 'branch_code' => $branch_code, 'company_code' => $company_code ) );
		if ( $getbilltype->num_rows() > 0 ) {
			$data['bill_type'] = $getbilltype->row()->bill_type;
		}
		$data['ref_names_arr'] = $this->Order->getrefnums();
		$this->newtemplate->dashboard( "documentcontrol/doc_control_list", $data );
	}

	public function getDocDates( $id ) {
		return $this->db->select( "docs_received_datetime, docs_sent_datetime" )->get_where( "tb_order_details", array( 'order_row_id' => $id ) )->row();
	}

	public function getDocComment( $id ) {
		return $this->db->select( "ref_value as doc_comment" )->get_where( "tb_order_references", array( 'order_id' => $id, 'reference_id' => 'DOC_DESC' ) )->row();
	}

	public function getDocPlaceCount( $id ) {
		return $this->db->query(
			"SELECT SUM(quantity) AS place_count FROM tb_order_cargodetails WHERE order_id = ? AND status = 1 GROUP BY order_id",
			[$id]
		)->row();
	}

	public function getCustomers( $cus_id ) {
		return ( $cus_id ) ? $this->db->select( "name as customer_name" )->get_where( "tb_customers", array( 'id' => $cus_id, 'status' => 1 ) )->row() : (object) array( "customer_name" => 'N/A' );
	}

	public function getCarrier( $vendor_id ) {
		return $this->db->select( "name as vendor_name" )->get_where( "tb_vendors", array( 'id' => $vendor_id, 'status' => 1 ) )->row();
	}

	public function update_order_status() {
		$curtz = $this->session->userdata( "usr_tzone" )['timezone'];
		if ( isset( $_POST['order_row_id'] ) ) {
			$row_id = $this->input->post( 'order_row_id' );
			if ( $_POST['doc_chnge_type'] == 'comment' ) {
				$wh              = array( 'order_id' => $row_id, 'status' => 1, 'reference_id' => 'DOC_DESC' );
				$arr             = array(
					'reference_id' => 'DOC_DESC',
					'ref_value'    => $this->input->post( 'val' ),
					'order_id'     => $row_id,
				);
				$doc_desc_exists = $this->db->get_where( 'tb_order_references', $wh )->row();
				if ( ! empty( $doc_desc_exists ) ) {
					unset( $arr['order_id'] );
					$arr['updatedon'] = date( 'Y-m-d H:i:s' );
					$up               = $this->db->update( 'tb_order_references', $arr, $wh );
				} else {
					$arr['createdon'] = date( 'Y-m-d H:i:s' );
					$up               = $this->db->insert( 'tb_order_references', $arr );
				}
				if ( $up ) {
					echo 1;
				} else {
					echo 0;
				}

				return TRUE;
			}


			if ( $_POST['doc_chnge_type'] == 'receive' ) {
				$docs_received_datetime = $this->input->post( 'val' );
				if ( $docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00" ) {
					$getdocrec              = getdatetimebytimezone( DFLT_TZ, $docs_received_datetime, $curtz );
					$docs_received_datetime = $getdocrec['datetime'];
				}
				$up_ar['docs_received_datetime'] = $docs_received_datetime;

			} else if ( $_POST['doc_chnge_type'] == 'sent' ) {
				$docs_sent_datetime = $this->input->post( 'val' );
				if ( $docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00" ) {
					$getdocsent         = getdatetimebytimezone( DFLT_TZ, $docs_sent_datetime, $curtz );
					$docs_sent_datetime = $getdocsent['datetime'];
				}
				$up_ar['docs_sent_datetime'] = $docs_sent_datetime;
			}
			$up = $this->db->update( 'tb_order_details', $up_ar, array( 'order_row_id' => $row_id, 'status' => 1 ) );
			if ( $up ) {
				echo 1;
			} else {
				echo 0;
			}

		} else {
			echo 0;
		}

	}

	public function bulk_update_order_status() {
		$curtz = $this->session->userdata( "usr_tzone" )['timezone'];
		if ( isset( $_POST['row_ids'] ) ) {
			$row_ids = $this->input->post( 'row_ids' );
			if ( $_POST['doc_received'] && $_POST['doc_received'] != '' ) {
				$docs_received_datetime = $this->input->post( 'doc_received' );
				if ( $docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00" ) {
					$getdocrec              = getdatetimebytimezone( DFLT_TZ, $docs_received_datetime, $curtz );
					$docs_received_datetime = $getdocrec['datetime'];
				}
				$up_ar['docs_received_datetime'] = $docs_received_datetime;
			}
			if ( $_POST['sent_date'] && $_POST['sent_date'] != '' ) {
				$docs_sent_datetime = $this->input->post( 'sent_date' );
				if ( $docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00" ) {
					$getdocsent         = getdatetimebytimezone( DFLT_TZ, $docs_sent_datetime, $curtz );
					$docs_sent_datetime = $getdocsent['datetime'];
				}
				$up_ar['docs_sent_datetime'] = $docs_sent_datetime;
			}

			$this->db->where_in( "order_row_id", $row_ids );
			$this->db->where( "status", 1 );
			$up = $this->db->update( 'tb_order_details', $up_ar );
			if ( $up ) {
				echo 1;
			}
		} else {
			echo 0;
		}

	}

	public function searchorders( $post ) {
//		da( $post, TRUE );
		$whr = array();
		if ( isset( $post['fromdate'] ) && $post['fromdate'] != "" ) {
			$post_fromdate = $this->db->escape_str($post['fromdate']);
			$fromdate = date( 'Y-m-d', strtotime( $post_fromdate ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;

		}
		if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
			$post_todate = $this->db->escape_str($post['todate']);
			$todate = date( 'Y-m-d', strtotime( $post_todate ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

		}
		/*if ( isset( $post['advfrom_date'] ) && $post['advfrom_date'] != "" ) {
			$advfrom_date                                  = date( 'Y-m-d', strtotime( $post['advfrom_date'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $advfrom_date;
		}
		if ( isset( $post['advto_date'] ) && $post['advto_date'] != "" ) {
			$advto_date                                    = date( 'Y-m-d', strtotime( $post['advto_date'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $advto_date;
		}*/
		if ( isset( $post['from_order_pk_date'] ) && $post['from_order_pk_date'] != "" ) {
			$post_from_order_pk_date = $this->db->escape_str($post['from_order_pk_date']);
			$from_order_pk_date = date( 'Y-m-d', strtotime( $post_from_order_pk_date ) );
			$whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >="] = $from_order_pk_date;
		}
		if ( isset( $post['to_order_pk_date'] ) && $post['to_order_pk_date'] != "" ) {
			$post_to_order_pk_date = $this->db->escape_str($post['to_order_pk_date']);
			$to_order_pk_date = date( 'Y-m-d', strtotime( $post_to_order_pk_date ) );
			$whr["DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="] = $to_order_pk_date;
		}

		if ( isset( $post['order_id'] ) && $post['order_id'] != "" ) {
			$whr['o.order_id'] = $this->db->escape_str($post['order_id']);
		}
		if ( isset( $post['customer_name'] ) && $post['customer_name'] != "" ) {
			$customer_name  = $this->db->escape_str($post['customer_name']);
			$getcustomer_id = $this->db->select( 'id' )->from( 'tb_customers' )->where( "name LIKE '%$customer_name%' " )->get();
			if ( $getcustomer_id->num_rows() > 0 ) {
				$cus = $getcustomer_id->result();
				$c_ids = implode(',', array_column( $cus, 'id'));
				$whr['customer_id_c'] = 'o.customer_id in ('.$c_ids.')';
//				da($getcustomer_id->result(), true);
			} else {
				$whr['o.id'] = '0';
			}
		}


//		if ( isset( $post['delivery_note'] ) && $post['delivery_note'] != "" ) {
//			/* $getdelivery_noteid = $this->db->select("id")->get_where("tb_shipments",array('shipid'=>$post['delivery_note']));*/
//			$getdelivery_noteid = $this->db->select( "order_id" )->get_where( "tb_order_references", array( 'ref_value' => $post['delivery_note'], 'status' => '1', 'reference_id' => 'DQ' ) );
//			if ( $getdelivery_noteid->num_rows() > 0 ) {
//				$order_id    = $getdelivery_noteid->row()->order_id;
//				$whr['o.id'] = $order_id;
//			} else {
//				$whr['o.id'] = '0';
//			}
//		}

		if ( isset( $post['purchase_order'] ) && $post['purchase_order'] != "" ) {
			$whr['r.ref_value like ']    = '%'.$post['purchase_order'].'%';
			$whr['r.reference_id'] = 'PO';
		}
		if ( isset( $post['delivery_note'] ) && $post['delivery_note'] != "" ) {
			$whr['r.ref_value like ']    = '%'.$post['delivery_note'].'%';
			$whr['r.reference_id'] = 'DQ';
		}
		if ( isset( $post['order_id_1'] ) && $post['order_id_1'] != "" ) {
			$whr['r.ref_value like ']    = '%'.$post['order_id_1'].'%';
			$whr['r.reference_id'] = 'RUCK';
		}
		if ( isset( $post['order_id_2'] ) && $post['order_id_2'] != "" ) {
			$whr['r.ref_value like ']    = '%'.$post['order_id_2'].'%';
			$whr['r.reference_id'] = 'RUCKSN';
		}

		if ( isset( $post['doc_remarks'] ) && $post['doc_remarks'] != "" ) {
			if ( $post['doc_remarks'] == 'empty' ) {
				$whr['DOC_DESC'] = "(CASE WHEN r.reference_id = 'DOC_DESC' THEN r.ref_value ELSE 0 END) = 0 AND o.id NOT IN (SELECT order_id FROM tb_order_references rr WHERE (CASE WHEN rr.reference_id = 'DOC_DESC' AND rr.ref_value != '' THEN rr.ref_value ELSE 0 END) != 0 GROUP BY rr.order_id)";
			} else {
				$whr['DOC_DESC'] = "(CASE WHEN r.reference_id='DOC_DESC' AND r.ref_value != '' THEN r.ref_value ELSE 0 END) != 0";
			}
//			$whr['r.reference_id'] = 'DOC_DESC';
		}


		$like = $like_cl = $rec = $send = $wher_l_c = '';
		if ( isset( $post['doc_date'] ) ) {
			if ( $post['doc_date'] != "" && $post['doc_date'] == "yes" ) {

				if ( $post['adv_doc_from_date'] != "" ) {
					$like = "(";
					if ( isset( $post['adv_doc_from_date'] ) && $post['adv_doc_from_date'] != "" ) {
						$doc_rec_date = date( 'Y-m-d', strtotime( $post['adv_doc_from_date'] ) );
						$rec          = " docs_received_datetime like '%$doc_rec_date%' ";
					}
					$like_cl = ")";
				} else {
					$like    = "(";
					$rec     = " ( docs_received_datetime != '' and docs_received_datetime is not null )  ";
					$like_cl = ")";
				}


			}
			if ( $post['doc_date'] != "" && $post['doc_date'] == "no" ) {
				$like    = "(";
				$rec     = " ( docs_received_datetime = '' or docs_received_datetime is null ) ";
				$like_cl = ")";
			}
		}

//		da($post, true);
		if ( isset( $post['doc_date2'] ) ) {
			if ( $post['doc_date2'] != "" && $post['doc_date2'] == "yes" ) {

				if ( $post['adv_doc_to_date'] != "" ) {
					$like = "(";
					if ( isset( $post['adv_doc_to_date'] ) && $post['adv_doc_to_date'] != "" ) {
						$doc_send_date = date( 'Y-m-d', strtotime( $post['adv_doc_to_date'] ) );
						$send          = " docs_sent_datetime like '%$doc_send_date%' ";
					}
					$like_cl = ")";
				} else {
					$like    = "(";
					$send    = " ( docs_sent_datetime != '' and docs_sent_datetime is not null )  ";
					$like_cl = ")";
				}

			}
			if ( $post['doc_date2'] != "" && $post['doc_date2'] == "no" ) {
				$like    = "(";
				$send    = " ( docs_sent_datetime = '' or docs_sent_datetime is null ) ";
				$like_cl = ")";
			}
		}

		if ( $rec != '' && $send != '' ) {
			$wher_l_c = " and ";
		}
		$like .= $rec . $wher_l_c . $send . $like_cl;


		if ( $like ) {
			$whr['like_c'] = $like;
//			echo $whr['like_c'];
		}
		da( $whr, TRUE );


		/*if ( isset( $post['company_code'] ) && $post['company_code'] != "" ) {
			$whr['o.company_code'] = $post['company_code'];

		}
		if ( isset( $post['branch_code'] ) && $post['branch_code'] != "" ) {
			$whr['o.branch_code'] = $post['branch_code'];

		}*/

		/*if ( isset( $post['from_date'] ) && $post['from_date'] != "" ) {
			$from_date                                     = date( 'Y-m-d', strtotime( $post['from_date'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $from_date;
		}
		if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
			$todate                                        = date( 'Y-m-d', strtotime( $post['todate'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
		}*/

		return $whr;

	}

    public function ajaxListing(){
        if ($this->session->userdata('user_id') == '') {
            echo 'SessionTimeout';
            return false;
        }
        $this->load->model('DataArrayFormatter_model');
        $this->load->model('DataQueryFormatter_model');
        $this->load->model('Datatables_model');

        $draw  = $this->input->post( 'draw',TRUE );
        $start = $this->input->post( 'start',TRUE );
        $limit =  $this->input->post('length',TRUE );
        $orderBy   =  $this->input->post('order',TRUE );

        $company_code = $this->session->userdata("company_code");
        $currentTimeZone = $this->session->userdata("usr_tzone")['timezone'];

        $order              = $country_userids = [];
        $userid             = $this->session->userdata( "user_id" );
        $custid             = $this->session->userdata( "cust_id" );
        $country_userids    = $this->session->userdata( "country_user_ids" );
        $whr                = $searchids = $post = [];

        $post              = $this->input->post( 'data',TRUE );
        $whr = $this->searchorders($post);

        $order_status   = isset( $post['status'] ) ? $this->db->escape_str($post['status']) : "";
        $ad_orderstatus = isset( $post['order_status'] ) ? $this->db->escape_str($post['order_status']) : "";
        $status_search  = $order_status;
        if ( $status_search == "" ) {
            $status_search = $ad_orderstatus;
        }
        $searchids = isset( $post['bookingid'] ) ? $this->db->escape_str($post['bookingid']) : [];

        $company_code = $this->session->userdata( 'company_code' );
        $branch_code  = $this->session->userdata( 'branch_code' );
        $subcusts     = [];
        $role_id      = $this->session->userdata( 'user_role_id' );
        if ( $role_id == "4" ) {
            if ( $this->session->userdata( 'sub_cust' ) ) {
                $subcusts = $this->session->userdata( 'sub_cust' );
                if ( ! empty( $subcusts ) ) {
                    array_push( $subcusts, $custid );
                }
            }
        }

        $orderTableCondition = [];
        $orderTableCondition[]= " o.status != 0";

        if (!empty($searchids)) {
            $oIds =  implode(',',$searchids);
            if($oIds!=''){
                $oIds = $this->db->escape_str($oIds);
                $orderTableCondition[]= " o.order_id in ($oIds)";
            }
        }

        if ($userid != '0') {
            if (!empty($country_userids)) {
                $uIds =  implode(',',$country_userids);
                if($uIds!=''){
                    $uIds = $this->db->escape_str($uIds);
                    $orderTableCondition[]= " o.user_id in ($uIds)";
                }
            } else {
                $userid = $this->db->escape_str($userid);
                $orderTableCondition[]= "o.user_id = $userid";
            }
        }

        if ($status_search == 'PENDING') {
            $orderTableCondition[]= "o.trip_id = 0";
        } else if ($status_search == 'ACTIVE') {
            $orderTableCondition[]= "o.trip_id != 0";
            $orderTableCondition[]= "o.trip_sts = 0";
        } else if ($status_search == 'CLOSED') {
            $orderTableCondition[]= "o.trip_id != 0";
            $orderTableCondition[]= "o.trip_sts = 1";
        }

        if (!empty($subcusts)) {
            $sCusts =  implode(',',$subcusts);
            if($sCusts!=''){
                $sCusts = $this->db->escape_str($sCusts);
                $orderTableCondition[]= " o.customer_id in ($sCusts)";
            }
        } else {
            if ($custid != "") {
                $custid = $this->db->escape_str($custid);
                $orderTableCondition[]= " o.customer_id = $custid";
            }
        }

        if (isset($whr['like_c'])) {
            $like_c = $whr['like_c'];
            unset($whr['like_c']);
            $orderTableCondition[]= " $like_c ";
        }

        unset($whr['DOC_DESC']);
        unset($whr['r.ref_value like ']);
        unset($whr['r.reference_id']);

        if (isset($whr['customer_id_c'])) {
            $customer_id_c = $whr['customer_id_c'];
            unset($whr['customer_id_c']);
            $customer_id_c = $this->db->escape_str($customer_id_c);
            $orderTableCondition[]= " $customer_id_c ";
        }

        if(!empty($whr)){
            foreach($whr as $key=>$value){
                $value="'$value'";
                if($key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.createdon,'%Y-%m-%d') <=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') >=" || $key=="DATE_FORMAT(o.pickup_datetime,'%Y-%m-%d') <="){
                    $orderTableCondition[]= $key.$value;
                }else{
                    $orderTableCondition[]= $key.' = '.$value;
                }
            }
        }

        $orderReferenceArray = [];
        if($post['delivery_note']!=''){
            $referenceDeliveryNote =$this->db->escape_str($post['delivery_note']);
            $orderReferenceArray[] = " ( ref_value like '%$referenceDeliveryNote%' AND r.reference_id = 'DQ' ) ";
        }
        if($post['purchase_order']!=''){
            $referencePurchaseOrder = $this->db->escape_str($post['purchase_order']);
            $orderReferenceArray[] = " ( ref_value like '%$referencePurchaseOrder%' AND r.reference_id = 'PO' ) ";
        }
        if($post['doc_remarks']=='empty'){
            $orderReferenceArray[] = " ( ref_value = '' AND r.reference_id = 'DOC_DESC' ) ";
        }else if($post['doc_remarks']=='nonempty'){
            $orderReferenceArray[] = " ( ref_value != '' AND r.reference_id = 'DOC_DESC' ) ";
        }

        if(!empty($orderReferenceArray)){
            $condition = implode(' or ', $orderReferenceArray);
            if($condition!=''){
                $sql = " select r.order_id from tb_order_references r  where order_id!='' and  $condition  ";
                $referenceData = $this->db->query($sql);
                if ($referenceData->num_rows() > 0) {
                    $resultant = $referenceData->result_array();
                    $orderNumbers = '';
                    if (! empty($resultant) && sizeof($resultant) > 0) {
                        foreach ($resultant as $eachOrdNum) {
                            $orderNumbers = $orderNumbers . $eachOrdNum['order_id'] . ',';
                        }
                    }
                    $orderNumbers = trim($orderNumbers, ',');
                    if($orderNumbers!=''){
                        $orderNumbers = $this->db->escape_str($orderNumbers);
                        $orderTableCondition[] =" o.id in ($orderNumbers)";
                    }
                }
            }

        }

        $orderTableWhere= implode(' AND ',$orderTableCondition);
        $table_name='tb_orders o';
        $indexColumn='o.id';
        $groupBy='o.id';
        $orderBy='o.id desc';
        $excludeCountQuery='Yes';
        $wherecondition= $indexColumn."!='' and ".$orderTableWhere;
        $joinsArray[]=array('table_name'=>'tb_order_details as d','condition'=>"o.id=d.order_row_id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_vendors as v','condition'=>"o.vendor_id=v.id",'join_type'=>'left');
        $joinsArray[]=array('table_name'=>'tb_customers as c','condition'=>"c.id=o.customer_id",'join_type'=>'left');

        $selectColumns = [ 'o.id, o.order_id, o.pickup_datetime, o.delivery_datetime, o.pickup_company as pickup,
                         o.delivery_company as delivery, o.vendor_id, o.customer_id, o.company_code, o.shipment_id,
                         o.status, o.order_status, o.trip_sts, o.shift_id, o.trip_id, o.shipmentid, o.createdon,
                         d.delivery_note,d.docs_sent_datetime,d.docs_received_datetime,
                         v.name as vendor_name,c.name as customer_name'
        ];

        $countAndOrderIdQuery="select count(o.id) as count from tb_orders o
        left join tb_order_details d on o.id=d.order_row_id
        where o.id!=0 and  $orderTableWhere ";

        $compiledCount='';
        $resultSet=$this->db->query($countAndOrderIdQuery);
        if($resultSet->num_rows()>0){
            $resdata = $resultSet->result_array();
            if(isset($resdata[0]['count'])){
                $compiledCount=$resdata[0]['count'];
            }
        }else{
            $compiledCount=0;
        }

        $dataTableSortOrdering=[];
        $getRecordListing = $this->Datatables_model->datatablesQuery( $selectColumns, $dataTableSortOrdering, $table_name, $joinsArray, $wherecondition, $indexColumn, 'TRUE', $groupBy,$excludeCountQuery,'POST' );

        if($excludeCountQuery=='Yes'){
            $totalRecords     = $compiledCount;
            $recordsFiltered  = $compiledCount;
        }else{
            $totalRecords     = $getRecordListing['recordsTotal'];
            $recordsFiltered  = $getRecordListing['recordsFiltered'];
        }

        $reqData = ['id'];
        $this->db->query('SET SESSION  group_concat_max_len=102400');
        $formattedData=$this->DataArrayFormatter_model->getCommaSeparatedFields($reqData,$getRecordListing['data']);
        if(isset($formattedData['commaSeparated']['id']) && $formattedData['commaSeparated']['id']!=''){
            $codes = " 'DQ', 'CTR', 'MN', 'PO', 'RUCK', 'RUCKSN', 'DOC_DESC' ";
            $formattedData=$this->DataQueryFormatter_model->getOrderReferenceData($formattedData['commaSeparated']['id'],$formattedData,$codes);
            $formattedData=$this->DataQueryFormatter_model->getOrderCargoDetails($formattedData['commaSeparated']['id'],$formattedData);
        }

        $getRecordListing=[];
        if(isset($formattedData['orders'])){
            $getRecordListing=$formattedData['orders'];
            krsort($getRecordListing);
        }

        $recordListing    = [];
        $i                = 0;

        if ( ! empty( $getRecordListing ) ) {
            foreach ( $getRecordListing as $res ) {
                $shipmentid    = $res['shipment_id'];
                $trip_no       = $res['shipmentid'];
                if ( $trip_no == '0' ) {
                    $trip_no = "";
                }
                $shift_id     = $res['shift_id'];
                $trip_sts     = $res['trip_sts'];
                $otherstatus  = $res['order_status'];
                $trip_id      = $res['trip_id'];
                $order_status = 'PENDING';
                if ( $trip_id != 0 && $trip_sts == 0 ) {
                    $order_status = 'ACTIVE';
                }
                if ( $trip_id != 0 && $trip_sts == 1 ) {
                    $order_status = 'CLOSED';
                }

                $referenceData='';
                if (isset($res['reference_value'])) {
                    $referenceData = $res['reference_value'];
                }

                $totalQuantity='';
                if (isset($res['totqty'])) {
                    $totalQuantity = $res['totqty'];
                }


                if ($referenceData != '') {
                    $arrayData = $this->DataArrayFormatter_model->formatReferenceParameters($referenceData);
                    $delivery_note = $container_no = $manifestno = $doc_comment = "";
                    $po_ref = $car_od_1 = $car_od_2 = "N/A";

                    if (isset($arrayData['DQ'])) {
                        $delivery_note = $arrayData['DQ'];
                    }
                    if (isset($arrayData['CTR'])) {
                        $container_no = $arrayData['CTR'];
                    }
                    if (isset($arrayData['MN'])) {
                        $manifestno = $arrayData['MN'];
                    }
                    if (isset($arrayData['PO'])) {
                        $po_ref = $arrayData['PO'];
                    }
                    if (isset($arrayData['RUCK'])) {
                        $car_od_1 = $arrayData['RUCK'];
                    }
                    if (isset($arrayData['RUCKSN'])) {
                        $car_od_2 = $arrayData['RUCKSN'];
                    }
                    if (isset($arrayData['DOC_DESC'])) {
                        $doc_comment = $arrayData['DOC_DESC'];
                    }
                }

                $chkdate      = '2020-07-01 00:00:00';
                $createdon    = $res['createdon'];
                $order_str    = strtotime( $createdon );
                $chk_str      = strtotime( $chkdate );
                $early_pickup = $res['pickup_datetime'];
                $early_delivery = $res['delivery_datetime'];

                if ( $order_str > $chk_str ) {
                    if ( $early_pickup != "" && $early_pickup != "0000-00-00 00:00:00" ) {
                        $epickup      = getdatetimebytimezone( $currentTimeZone, $early_pickup, DFLT_TZ );
                        $early_pickup = $epickup['datetime'];
                    }
                    if ( $early_delivery != "" && $early_delivery != "0000-00-00 00:00:00" ) {
                        $edelivery      = getdatetimebytimezone( $currentTimeZone, $early_delivery, DFLT_TZ );
                        $early_delivery = $edelivery['datetime'];
                    }
                }
                $html = $status = "";

                $docs_sent_datetime = $res['docs_sent_datetime'];
                if ( $docs_sent_datetime != "" && $docs_sent_datetime != "0000-00-00 00:00:00" ) {
                    $docsent            = getdatetimebytimezone( $currentTimeZone, $docs_sent_datetime, DFLT_TZ );
                    $docs_sent_datetime = $docsent['datetime'];
                }
                $docs_received_datetime = $res['docs_received_datetime'];
                if ( $docs_received_datetime != "" && $docs_received_datetime != "0000-00-00 00:00:00" ) {
                    $docrec                 = getdatetimebytimezone( $currentTimeZone, $docs_received_datetime, DFLT_TZ );
                    $docs_received_datetime = $docrec['datetime'];
                }

                $empty  = "";
                $j=0;

                $checkBox = '<div class="checkbox checkbox-info">
                                 <label>
                                    <input type="checkbox" class="chckbox" name="chck1" id="'.$res['id'].'" data-row-id="'.$res['id'].'">
                                    <span class="cr"><i class="cr-icon fa fa-check"></i></span>
                                 </label>
                              </div>';

                $recordListing[ $i ][0]  = $checkBox;
                $recordListing[ $i ][++$j]  = $res['order_id'];
                $recordListing[ $i ][++$j]  = $delivery_note;
                $recordListing[ $i ][++$j]  = $po_ref;
                $recordListing[ $i ][++$j]  = ( $car_od_1 ) ? $car_od_1 : "N/A";
                $recordListing[ $i ][++$j]  = $car_od_2;
                $recordListing[ $i ][++$j]  = ( $res['vendor_name'] ) ? $res['vendor_name'] : "N/A";
                $recordListing[ $i ][++$j]  = $res['customer_name'];
                $recordListing[ $i ][++$j]  = $res['pickup'];
                $recordListing[ $i ][++$j]  = $res['delivery'];
                $recordListing[ $i ][++$j]  = date( 'Y-m-d h:i A', strtotime( $early_pickup ) );
                $recordListing[ $i ][++$j]  = date( 'Y-m-d h:i A', strtotime( $early_delivery ) );
                $recordListing[ $i ][++$j]  = $totalQuantity;

                $styinp = "width: 100px;height: 20px;";
                if($docs_received_datetime != ''){
                    $styinp .= "background-color: #1aa41a;color: #fff;";
                }

                $receive = "'receive'";
                $onBlurEventReceive = 'order_update_doc_date('.$res['id'].','.$receive.')';

                $docsReceivedInput = '<span class="hide">'.$res['docs_received_datetime'].'</span>
                                              <input type="text" placeholder="doc receive" value="'.$docs_received_datetime.'"
                                                       id="order_row_r_'.$res['id'].'"
                                                       onblur="'.$onBlurEventReceive.'"
                                                       style="'.$styinp.'" class="select_date" autocomplete="off">';
                $recordListing[ $i ][++$j]  = $docsReceivedInput;

                $styinp = "width: 100px;height: 20px;";
                if($docs_sent_datetime != ''){
                    $styinp .= "background-color: #1aa41a;color: #fff;";
                }
                $sent = "'sent'";
                $onBlurEventReceive = 'order_update_doc_date('.$res['id'].','.$sent.')';

                $docsSentInput = '<span class="hide">'.$docs_sent_datetime.'</span>
                                              <input type="text" placeholder="doc sent" name="" value="'.$docs_sent_datetime.'"
                                                       id="order_row_s_'.$res['id'].'"
                                                       onblur="'.$onBlurEventReceive.'" style="'.$styinp .'"
                                                       class="select_date" autocomplete="off">';
                $recordListing[ $i ][++$j]  = $docsSentInput;

                $styinp = 'width: 150px;height: 20px;';
                if ( $doc_comment != "" ) {
                    $styinp .= "background-color: #1aa41a;color: #fff;";
                }
                $comment = "'comment'";
                $onBlurEventComment = 'order_update_doc_date('.$res['id'].','.$comment.')';

                $commentInput = '<span class="hide">'.$doc_comment.'</span>
                                <input type="text" placeholder="Comment" value="'.$doc_comment.'" class="comment_inp"
                                id="order_row_c_'.$res['id'].'"
                                onblur="order_update_doc_date('.$onBlurEventComment.')" style="'.$styinp.'" autocomplete="off">';
                $recordListing[ $i ][++$j]  = $commentInput;
                $i ++;
            }

            $final_data = json_encode( $recordListing );
        } else {
            $final_data = '[]';
        }
        echo '{"draw":' . $draw . ',"recordsTotal":' . $totalRecords . ',"recordsFiltered":' . $recordsFiltered . ',"data":' . $final_data . '}';
    }

}
