<?php

if(!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class DownloadEpod extends CI_Controller
{
    /**
     * force download of podupload, given in url, without login
     */
    public function safelink(string $uuidWithExtension): void
    {
        $this->load->helper('download');
        $uuid = pathinfo($uuidWithExtension, PATHINFO_FILENAME);

        $result = $this->db->query("SELECT imgpath FROM tb_pod_uploads WHERE hash= ? ", [ $uuid ]);
        if (!($filename = $result->row())) {
            return;
        }

        force_download($this->getFilepathBaseOnExtension($filename), null);
    }

    private function getFilepathBaseOnExtension(object $filename): string
    {
        switch (pathinfo($filename->imgpath, PATHINFO_EXTENSION)) {
            case '':
                return 'assets/img/Imgloader.gif';
            case 'jpl':
                return 'assets/jpl_files/' . $filename->imgpath;
            default:
                return NEW_POD_PATH . $filename->imgpath;
        }
    }
}
