<?php defined('BASEPATH') or exit('No direct script access allowed');

use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\PodUploads\CheckSignatureAndPodTrait;
use App\ShiftsData\AddressesFromShiftTrait;
use App\ShiftsData\CountPickupDropGateins;
use App\ShiftsData\ExtractShiporderStopsTrait;
use App\ShiftsData\GetStopstatuses;
use App\ShiftsData\ProcessStopstatuses;
use App\ShipmentStopDetails\ShipmentStopDetailsService;
use App\Generators\RandomString;

/*
* @deprecated
*/
class Driverapiv3 extends CI_Controller {
    use CheckSignatureAndPodTrait;
    use AddressesFromShiftTrait;
    use ExtractShiporderStopsTrait;
    use CountPickupDropGateins;

    public function __construct() {
        parent::__construct();
        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper(['cabs','date']);
        $this->load->model(['common','cabmodel']);
        $this->load->library(['uuid','statusintigration','sendfirebase','smsnotifier']);
    }

    public function index() {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }

    public function driverLogin() {
        $response = array();
        // log_message("Error", json_encode($_POST) . '=== dRIVER REQ FORMAT ====');
        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {
            $mobile = isset($_POST["mobile"]) ? trim($_POST["mobile"]) : '';
            $pwd = isset($_POST["password"]) ? trim($_POST["password"]) : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : '';
            $phone = isset($_POST["mobile_number"]) ? $_POST["mobile_number"] : '';
            if ($mobile != "") {
                if (!empty($phone)) {
                    if (is_array($phone)) {
                        $phone = implode(",", $phone);
                    }
                }
                $password = password_hash($pwd, PASSWORD_DEFAULT);
                $whr = array("d.contact_num" => $mobile, "d.password" => $password, "d.status" => "Active");
                $this->db->select('d.*,u.country_code,u.mobile_no,u.default_currency as currency');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();

                $curdt = date('Y-m-d H:i:s');
                $drcnt = $sql->num_rows();
                $insdata = array("mobile" => $mobile, "password" => $pwd, "imei" => $imei, "simcard_phone" => $phone, "status" => $drcnt);
                $res = $this->common->insertTableData("tb_driver_login_logs", $insdata);
                if ($drcnt > 0) {
                    $data = $sql->row_array();
                    $id = $data["id"];
                    $imei_k = $data["imei"] ?? '';
                    $qry = $this->db->query(
                        "SELECT t.id, t.register_number
                        FROM tbl_assigned_drivers AS a, tb_trucks_data AS t, tb_truck_drivers AS d
                        WHERE a.driver_id = ? AND t.id = a.vehicle_id AND a.status = 1
                        AND d.status = 'Active' AND d.id = a.driver_id AND t.status = 'Active'
                        ORDER BY a.id DESC
                        LIMIT 1",
                        [$id]
                    );
                    $veh = $veh_id = "";
                    if ($qry->num_rows() > 0) {
                        $veh = $qry->row()->register_number;
                        $veh_id = $qry->row()->id;
                    }
                    $whrarr = array("id" => $id);
                    if ($gcm_id != "") {
                        $updset = array("gcm_id" => $gcm_id);
                        $this->common->updatetbledata("tb_truck_drivers", $updset, $whrarr);
                    }
                    $countrytimezone = "Asia/Singapore";
                    $selwhr = array("country_code" => $data['country_code']);
                    $chkcntry = $this->common->gettblrowdata($selwhr, "cntry_timezone", "tbl_country_master", 0, 0);
                    if (count($chkcntry) > 0) {
                        $countrytimezone = $chkcntry['cntry_timezone'];
                    }
                    $data['imei'] = $imei_k;
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = "";
                    $data['timezone'] = $countrytimezone;
                    $data['border_type'] = 0;
                    if ($veh_id != "") {
                        $whr = array("vehicle_id" => $veh_id, "driver_id" => $id, "status" => "1");
                        $trip = $this->common->gettblrowdata($whr, 'id,shift_id', 'tb_trips', 0, 0);
                        if (count($trip) > 0) {
                            $data['trip_id'] = $trip['id'];
                            $shiptid = $trip['shift_id'];
                            $bwhr = array("id" => $shiptid, "border_type" => 1);
                            $shipid = $this->common->gettblrowdata($bwhr, "id", "tb_shifts", 0, 0);
                            if (count($shipid) > 0) {
                                $data['border_type'] = 1;
                            }
                        }
                    }
                    $response = array("status" => 1, "data" => $data);
                } else {
                    $response = array("status" => 0, "data" => "Not Found");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }

//        if (isset($_POST['application_type']) && $this->input->post('application_type') == "mobile_web_app") {
//            if ($response['status'] == 1) {
//                $data['response_body'] = $response['data'];
//                $_SESSION['driver_info'] = array($response['data']);
//                $data['body_content'] = 'home';
//                $this->load->view('index', $data);
//                return;
//            } else {
//                redirect('login', 'refresh');
//            }
//        }
        echo json_encode($response);
    }

    public function crossborderchange() {
        $response = array();
        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {
            // log_message('error', "crossborderchange " . json_encode($_POST));
            $prev_admin_area = isset($_POST["prev_admin_area"]) ? $_POST["prev_admin_area"] : '';
            $prev_country_code = isset($_POST["prev_country_code"]) ? $_POST["prev_country_code"] : '';
            $admin_area = isset($_POST["admin_area"]) ? $_POST["admin_area"] : '';
            $country_code = isset($_POST["country_code"]) ? $_POST["country_code"] : '';
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : '';
            $driver_id = isset($_POST["driver_id"]) ? $_POST["driver_id"] : '';
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : '';
            $prev_latitude = isset($_POST["prev_latitude"]) ? $_POST["prev_latitude"] : '';
            $prev_longitude = isset($_POST["prev_longitude"]) ? $_POST["prev_longitude"] : '';
            $latitude = isset($_POST["latitude"]) ? $_POST["latitude"] : '';
            $longitude = isset($_POST["longitude"]) ? $_POST["longitude"] : '';
            if ($user_id != "" && $driver_id != "" && $trip_id != "") {
                $arr = array('trip_id' => $trip_id, 'driver_id' => $driver_id, 'user_id' => $user_id, 'prev_admin_area' => $prev_admin_area, 'prev_country_code' => $prev_country_code, 'prev_latitude' => $prev_latitude, 'prev_longitude' => $prev_longitude, 'admin_area' => $admin_area, 'country_code' => $country_code, 'latitude' => $latitude, 'longitude' => $longitude);
                $ins = $this->db->insert("tb_crossed_borders", $arr);
                $getusermail = $this->db->select("name,emailid,company_code,cc_mails")->get_where("tb_users", array("id" => $user_id, "status" => "Active"), 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $cmpcode = $getusermail->row()->company_code;
                    if ($cmpcode == "SGKN" || $cmpcode == "MYKN") {
                        $receivemail = $getusermail->row()->cc_mails;
                        $receivename = $getusermail->row()->name;
                        if ($receivemail == "") {
                            $receivemail = $getusermail->row()->emailid;
                        }
                    } else {
                        $receivemail = $getusermail->row()->emailid;
                        $receivename = $getusermail->row()->name;
                    }
                    $orddata = $this->db->query(
                        "SELECT * FROM tb_orders WHERE trip_id = ? AND trip_sts = 0 LIMIT 1",
                        [$trip_id]
                    );
                    if ($orddata->num_rows() > 0) {
                        $data['order'] = $orddata->row_array();
                        $data['order_id'] = $order_id = $data['order']['order_id'];
                        $customer_id = $data['order']['customer_id'];
                        $custname = $custemail = "";
                        $customer = $this->db->query(
                            "SELECT name, email_id
                            FROM tb_customers
                            WHERE id = ? AND email_id != '' AND status = 1
                            LIMIT 1",
                            [$customer_id]
                        );
                        if ($customer->num_rows() > 0) {
                            $custname = $customer->row()->name;
                            $custemail = $customer->row()->email_id;
                        }
                        $this->load->library('email');
                        $ordid = $data['order']['id'];
                        $data['orderref'] = "";
                        $ordref = $this->db->select("ref_value")->get_where("tb_order_references", array("order_id" => $ordid, "reference_id" => "DQ"), 1, 0);
                        if ($ordref->num_rows() > 0) {
                            $data['orderref'] = $ordref->row()->ref_value;
                        }
                        $data['exit_area'] = $prev_admin_area . ", " . $prev_country_code;
                        $data['entry_area'] = $admin_area . ", " . $country_code;
                        $data['page_title'] = "Cross Border Shipment";
                        $data['receivemail'] = $receivemail;
                        $data['receivename'] = $receivename;
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);
                        if ($custname != "") {
                            $this->email->bcc($custemail, $custname);
                        }
                        $this->email->subject("svkonekt::Cross Border for Shipment #" . $order_id);
                        $this->email->set_mailtype("html");
                        $data['receivename'] = "Team";
                        $body = $this->load->view('mail_forms/crossborder', $data, true);
                        $this->email->message($body);
                        $response = array("status" => 1, "data" => "Success");
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function getDriverData() {
        $response = array();
        $response = array("status" => 0, "data" => "Not Found");
        if (isset($_POST)) {
            /* log_message('error', "getDriverData " . json_encode($_POST)); */
            $id = isset($_POST["id"]) ? $_POST["id"] : '';
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : '';
            $gcm_id = isset($_POST["gcm_id"]) ? $_POST["gcm_id"] : '';
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : '';
            if ($user_id != "" || $id != "") {
                $veh = $veh_id = $tripid = "";
                $whr = array("d.id" => $id, "d.status" => "Active");
                $this->db->select('d.*,u.mobile_no');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                if ($sql->num_rows() > 0) {
                    $data = $sql->row_array();
                    if ($gcm_id != "" && $imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei, "gcm_id" => $gcm_id));
                    } else if ($imei != "") {
                        $upd = $this->db->where("id", $id)->update("tb_truck_drivers", array("imei" => $imei));
                    }
                    $whr1 = array("driver_id" => $id, "status" => "1", "transit_status" => "1");
                    $trip1 = $this->db->select('id,vehicle_id')->order_by('id', 'DESC')->get_where("tb_trips", $whr1, 1, 0);
                    if ($trip1->num_rows() > 0) {
                        $veh_id = $trip1->row()->vehicle_id;
                        $vehqry = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $veh_id, "status" => "Active"), 1, 0);
                        if ($vehqry->num_rows() > 0) {
                            $veh = $vehqry->row()->register_number;
                        }
                        $tripid = $trip1->row()->id;
                    } else {
                        $whr1 = array("driver_id" => $id, "status" => "1", "transit_status" => "0");
                        $trip = $this->db->select('id,vehicle_id')->order_by('id', 'DESC')->get_where("tb_trips", $whr1, 1, 0);
                        if ($trip->num_rows() > 0) {
                            $veh_id = $trip->row()->vehicle_id;
                            $vehqry = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $veh_id, "status" => "Active"), 1, 0);
                            if ($vehqry->num_rows() > 0) {
                                $veh = $vehqry->row()->register_number;
                            }
                            $tripid = $trip->row()->id;
                        }
                    }
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = $tripid;
                    $response = array("status" => 1, "data" => $data);
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found");
            }
        }
        echo json_encode($response);
    }

    /* after clicked on accept in shipment stops screen */

    public function startTrip() {

        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");
//        log_message("Error", json_encode($_POST).'----wwww---------');
        if (isset($_POST)) {
            if (isset($_POST['data'])) {
                $order_rowid = 0;
                $post = json_decode($_POST['data']);
                // log_message('error', "accept shipment " . json_encode($post));
                $data["shift_id"] = isset($post->shift_id) ? $post->shift_id : '';
                $data["vehicle_id"] = isset($post->vehicle_id) ? $post->vehicle_id : '';
                $data["trip_type"] = isset($post->trip_type) ? $post->trip_type : 0;
                $data["driver_id"] = isset($post->driver_id) ? $post->driver_id : '';
                $data["splace"] = isset($post->splace) ? $post->splace : '';
                $data["eplace"] = isset($post->eplace) ? $post->eplace : '';
                $data["start_reading"] = isset($post->odemeter) ? $post->odemeter : '0';
                $latitude = isset($post->latitude) ? $post->latitude : '';
                $longitude = isset($post->longitude) ? $post->longitude : '';
                $imei = isset($post->imei) ? $post->imei : '';
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                /* $logdate = date('Y-m-d H:i:s');
                  $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
                $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
                $data["stime"] = $data["created_on"] = $curdt;
                $arr = array("id" => $data["driver_id"], "imei" => $imei, "status" => 'Active');
                /* $arr = array("id"=>$data["driver_id"],"status"=>'Active'); */
                $chkqry = $this->db->select("id")->get_where("tb_truck_drivers", $arr)->num_rows();
                if ($chkqry > 0 && $data["shift_id"] != "") {
                    /* commented code for stop duplicate shifts */
                    /* here need to send SHIPMENT_CONFIRM status to otm */
                    /* ,"driver_id"=>$data["driver_id"],"vehicle_id"=>$data["vehicle_id"] */
                    $chk = $this->db->select("id")->get_where("tb_trips", array("shift_id" => $data["shift_id"]), 1, 0);
                    if ($chk->num_rows() == 0) {
                        $data["start_imei"] = $imei;
                        $ins = $this->db->insert("tb_trips", $data);
                        $id = $this->db->insert_id();
                        /* update orders table */
                        $ordwhr = array("shift_id" => $data["shift_id"]);
                        $ordset = array("trip_id" => $id);
                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                        $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $data["driver_id"], "trip_id" => $id, "imei" => $imei, "createdon" => $data["created_on"]));
                        $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(array("shift_id" => $data["shift_id"]))->get("tb_employee");
                        if ($shift->num_rows() > 0) {
                            $uid = $shift->row()->user_id;
                            $bookingid = $shift->row()->order_id;
                            $order_rowid = 0;
                            $getorder_rowid = gettblrowdata(array('order_id'=>$bookingid,'user_id'=>$uid),'id','tb_orders',0,0);
                            if(!empty($getorder_rowid)){
                                $order_rowid= $getorder_rowid['id'];
                            }
                            $gethrs = $this->db->query(
                                "SELECT c.cntry_hrs
                                FROM tbl_country_master AS c, tb_users AS u
                                WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                LIMIT 1",
                                [$uid]
                            );
                            $hrs = $gethrs->row()->cntry_hrs;
                            $postdata = array(
                                "shipment_id" => $data["shift_id"],
                                "trip_id" => $id,
                                "driver_id" => $data["driver_id"],
                                "order_id" => $shift->row()->order_id,
                                "vehicle_id" => $data["vehicle_id"],
                                "user_id" => $uid,
                                "stop_id" => '',
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );
                            /* $sts = $this->statusintigration->shipmentconfirm($postdata); */
                            /* send to roadlog */
                            $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                            /* status update */
                            $chqry = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "trip_id" => $id, "status_id" => 10), 1, 0);
                            if ($chqry->num_rows() == 0) {
                                $insarry = array("shipment_id" => $data["shift_id"],"order_id"=>$order_rowid, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => '', "trip_id" => $id, "status_id" => 10, "latitude" => $latitude, "longitude" => $longitude, "status" => 1, "status_code" => "0212", "reason" => "From Mobile", "vehicle_id" => $data["vehicle_id"], "driver_id" => $data["driver_id"], "createdon" => $curdt);
                                $ins = $this->db->insert("tb_stop_status", $insarry);
                                /* send email confim to admin */
                                if ($uid == "12") {
                                    $sndmail = $this->loadconfirmmail($postdata);
                                }
                            }
                        }
                        if ($id > 0) {
                            $empdata = array();
                            $empdata["trip_id"] = $id;
                            $response = array("status" => 1, "data" => array($empdata));
                        } else {
                            $response = array("status" => 0, "data" => "Failed to Start");
                        }
                    } else {
                        $empdata = array();
                        $empdata["trip_id"] = $chk->row()->id;
                        $response = array("status" => 1, "data" => array($empdata));
                    }
                } else {
                    $response = array("status" => 3, "data" => "Please re-login to continue");
                }
            }
        }
        echo json_encode($response);
    }

    public function loadconfirmmail($post) {
        $data['page_title'] = "Load Confirmed by Driver";
        $data['order_id'] = $post['order_id'];
        $driver_id = $post['driver_id'];
        $vehicle_id = $post['vehicle_id'];
        $data['user_id'] = $post['user_id'];
        $data['driver'] = $data['drivermobile'] = $data['register_number'] = "";
        $chk = $this->db->select("name,contact_num,user_id")->get_where("tb_truck_drivers", array("id" => $driver_id), 1, 0);
        if ($chk->num_rows() > 0) {
            $data['driver'] = $chk->row()->name;
            $data['user_id'] = $chk->row()->user_id;
            $data['drivermobile'] = $chk->row()->contact_num;
        }
        $chk1 = $this->db->select("register_number")->get_where("tb_trucks_data", array("id" => $vehicle_id), 1, 0);
        if ($chk1->num_rows() > 0) {
            $data['register_number'] = $chk1->row()->register_number;
        }
        $this->load->library('email');
        $chkven = $this->db->select("name,emailid")->get_where("tb_users", array("id" => $data['user_id']), 1, 0);
        if ($chkven->num_rows() > 0) {
            $receivename = $chkven->row()->name;
            $receivemail = $chkven->row()->emailid;
            $newsub = "svkonekt: Load Confirmed by Driver for Order#" . $data['order_id'];
            $data['receivename'] = $receivename;
            if ($receivemail != "") {
                $body = $this->load->view('mail_forms/confirmbydriver', $data, true);
                $this->email->from('svkonekt@kuehne-nagel.com', 'Svkonekt');
                $this->email->to($receivemail, $receivename);
                $this->email->cc('external.ram.k@kuehne-nagel.com', "RCREDDY");
                $this->email->subject($newsub);
                $this->email->set_mailtype("html");
                $this->email->message($body);
            }
        }
    }

    public function startMultipleShipments() {
        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $order_rowid = 0;
            $post = (object) $_POST;
            $data["driver_id"] = isset($post->driver_id) ? $post->driver_id : '';
            $shipmentsJSON = isset($post->shipments) ? $post->shipments : '';
            $imei = isset($post->imei) ? $post->imei : '';
            $latitude = isset($post->latitude) ? $post->latitude : '';
            $longitude = isset($post->longitude) ? $post->longitude : '';
            $shipments = json_decode($shipmentsJSON);
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            if (!empty($shipments)) {
                foreach ($shipments as $shipmentArry) {
                    $shipment = (object) $shipmentArry;
                    /* log_message('error', "accepting shipment " . json_encode($shipment)); */
                    $data["shift_id"] = isset($shipment->shift_id) ? $shipment->shift_id : '';
                    $data["vehicle_id"] = isset($shipment->vehicle_id) ? $shipment->vehicle_id : '';
                    $data["trip_type"] = isset($shipment->trip_type) ? $shipment->trip_type : 0;
                    $data["splace"] = isset($shipment->splace) ? $shipment->splace : '';
                    $data["eplace"] = isset($shipment->eplace) ? $shipment->eplace : '';
                    $data["start_reading"] = isset($shipment->odemeter) ? $shipment->odemeter : '0';
                    /* $logdate = date('Y-m-d H:i:s');
                      $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
                    $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
                    $data["stime"] = $data["created_on"] = $curdt;
                    $arr = array("id" => $data["driver_id"], "imei" => $imei, "status" => 'Active');
                    $chkqry = $this->db->select("id")->get_where("tb_truck_drivers", $arr)->num_rows();
                    if ($chkqry > 0) {
                        /* commented code for stop duplicate shifts */
                        $chk = $this->db->select("id")->get_where("tb_trips", array("shift_id" => $data["shift_id"], "driver_id" => $data["driver_id"], "vehicle_id" => $data["vehicle_id"]), 1, 0);
                        if ($chk->num_rows() == 0) {
                            $data["start_imei"] = $imei;
                            $ins = $this->db->insert("tb_trips", $data);
                            $id = $this->db->insert_id();
                            /* update orders table */
                            $ordwhr = array("shift_id" => $data["shift_id"]);
                            $ordset = array("trip_id" => $id);
                            $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                            $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $data["driver_id"], "trip_id" => $id, "imei" => $imei, "createdon" => $data["created_on"]));
                            $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(array("shift_id" => $data["shift_id"]))->get("tb_employee");
                            if ($shift->num_rows() > 0) {
                                $uid = $shift->row()->user_id;
                                $bookingid = $shift->row()->order_id;
                                $order_rowid = 0;
                                $getorder_rowid = gettblrowdata(array('order_id'=>$bookingid,'user_id'=>$uid),'id','tb_orders',0,0);
                                if(!empty($getorder_rowid)){
                                    $order_rowid= $getorder_rowid['id'];
                                }
                                $gethrs = $this->db->query(
                                    "SELECT c.cntry_hrs
                                    FROM tbl_country_master AS c, tb_users AS u
                                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                    LIMIT 1",
                                    [$uid]
                                );
                                $hrs = $gethrs->row()->cntry_hrs;
                                $postdata = array(
                                    "shipment_id" => $data["shift_id"],
                                    "trip_id" => $id,
                                    "driver_id" => $data["driver_id"],
                                    "order_id" => $shift->row()->order_id,
                                    "stop_id" => '',
                                    "latitude" => $latitude,
                                    "longitude" => $longitude,
                                    "curtz" => $curtz,
                                    "hrs" => $hrs
                                );
                                /* $sts = $this->statusintigration->shipmentconfirm($postdata); */
                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                                /* status update */
                                $chqry = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "trip_id" => $id, "status_id" => 10), 1, 0);
                                if ($chqry->num_rows() == 0) {
                                    $insarry = array("shipment_id" => $data["shift_id"],"order_id"=>$order_rowid, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => '', "trip_id" => $id, "status_id" => 10, "status" => 1,
                                        "latitude" => $latitude, "longitude" => $longitude, "status_code" => "0212", "reason" => "From Mobile", "vehicle_id" => $data["vehicle_id"], "driver_id" => $data["driver_id"], "createdon" => $curdt);
                                    $ins = $this->db->insert("tb_stop_status", $insarry);
                                }
                                if ($id > 0) {
                                    $empdata = array();
                                    $empdata["trip_id"] = $id;
                                    $response = array("status" => 1, "data" => array($empdata));
                                }
                            }
                        } else {
                            $empdata = array();
                            $empdata["trip_id"] = $chk->row()->id;
                            $response = array("status" => 1, "data" => array($empdata));
                        }
                    } else {
                        $response = array("status" => 3, "data" => "Please re-login to continue");
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function sendTripAlert($trip = null, $curtz = null) {
        $result = array();
        if ($trip != null) {
            $q = $this->db->query(
                "SELECT employee_id FROM tb_trip_employee WHERE trip_id = ?",
                [$trip]
            );
            $emps = array();
            if ($q->num_rows() > 0) {
                foreach ($q->result() as $qr) {
                    array_push($emps, $qr->employee_id);
                }
            }
            $result = $this->sendFirstAlert($trip, $emps, $curtz);
        }
        return $result;
    }

    public function sendFirstAlert($trip = null, $emps = array(), $curtz = null) {
        $result = array();
        $tt = $this->db->query(
            "SELECT t.driver_id, t.vehicle_id, sv.id, sv.register_number
            FROM tb_trips AS t, tb_shft_veh AS sv
            WHERE t.id = ? AND sv.vehicle_id = t.vehicle_id AND sv.shft_id = t.shift_id AND sv.status = 1
            ORDER BY sv.id DESC
            LIMIT 1",
            [$trip]
        );
        if ($tt->num_rows() > 0) {
            $t = $tt->row();
            $driver = $t->driver_id;
            $vehicle_id = $t->vehicle_id;
            $shft_veh_id = $t->id;
            $reg = $t->register_number;
            if (count($emps) == 0) {
                $arr = array("shft_veh_id" => $shft_veh_id, "status" => 1);
                $sql2 = $this->db->select("priority,user_id")->group_by("priority")->order_by("priority", "asc")->get_where("tb_shft_veh_emp", $arr, 1, 0);
            } else {
                $sql2 = $this->db->select("priority,user_id")->where("shft_veh_id", $shft_veh_id)->where("status", 1)->where_not_in("emp_id", $emps)->group_by("priority")->order_by("priority", "asc")->limit(1)->get("tb_shft_veh_emp");
            }
            if ($sql2->num_rows() > 0) {
                $chksent = $this->db->select('id')->get_where('tb_tripfirst_alerts', array('trip_id' => $trip))->num_rows();
                $user_id = $sql2->row()->user_id;
                if ($chksent == 0) {
                    $this->db->select('d.contact_num');
                    $this->db->from('tb_truck_drivers d');
                    $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
                    $this->db->where('t.id', $trip);
                    $this->db->limit(1);
                    $drivermobile = $this->db->get();
                    $drivernum = "";
                    if ($drivermobile->num_rows() > 0) {
                        $drivernum = $drivermobile->row()->contact_num;
                    }
                    $link = $this->getLink($driver, $trip);
                    $mquery = $this->db->query(
                        "SELECT s.emp_id, e.name, e.pickup, e.drop, e.phone, e.plat, e.plng, e.dlat, e.dlng
                        FROM tb_shft_veh_emp AS s, tb_employee AS e
                        WHERE s.shft_veh_id = ? AND s.status = 1 AND e.id = s.emp_id AND e.status = 1",
                        [$shft_veh_id]
                    );
                    $ecnt = $mquery->num_rows();
                    if ($ecnt > 0) {
                        $sntdata = array('trip_id' => $trip, 'module' => 'Truck Auto Arrival Alert Once', 'message' => $drivernum, 'sent_count' => $ecnt);
                        $sendres = $this->db->insert('tb_tripfirst_alerts', $sntdata);
                        foreach ($mquery->result() as $rw) {
                            $result['sms_data'][] = $this->sendBulkAlert($trip, $rw->emp_id, $rw->phone, $rw->name, $drivernum, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
                $query = $this->db->query(
                    "SELECT s.emp_id, e.name, e.pickup, e.drop, e.phone, e.plat, e.plng, e.dlat, e.dlng
                    FROM tb_shft_veh_emp AS s, tb_employee AS e
                    WHERE s.shft_veh_id = ? AND s.status = 1 AND e.id = s.emp_id AND e.status = 1 AND priority = ?",
                    [$shft_veh_id, $sql2->row()->priority]
                );
                if ($query->num_rows() > 0) {
                    $link = $this->getLink($driver, $trip);
                    foreach ($query->result() as $emps) {
                        $res = $this->db->select('id')->get_where("tb_trip_alerts", array("trip_id" => $trip, "emp_id" => $emps->emp_id))->num_rows();
                        if ($res == 0) {
                            $distance = $this->getDist($vehicle_id, $emps->plat, $emps->plng);
                            $result['pickup_data'][] = $this->sendAlert($trip, $emps->emp_id, $emps->phone, $emps->name, $distance, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function getLink($driver, $trip) {
        $link1 = base_url() . "cab/track/" . encryptIt($driver, $trip);
        return $link1;
    }

    public function getDist($vehicle_id, $lat, $lng) {
        $rr = array('0', '0');
        $imei1 = $this->db->select("latitude,longitude")->get_where("tb_trucks_data", array('id' => $vehicle_id), 1, 0);
        if ($imei1->num_rows() > 0) {
            $mbl = $imei1->row();
            if ($lat > 0 && $lng > 0 && $mbl->latitude > 0 && $mbl->longitude > 0) {
                $d = array();
            }
            $dist = distancemetrixship($lat, $lng, $mbl->latitude, $mbl->longitude);
            $d['distance'] = $dist['disttext'];
            $d['duration'] = $dist['duratext'];
            $rr[0] = $d['distance'];
            $rr[1] = $d['duration'];
        }
        return $rr;
    }

    public function sendBulkAlert($trip, $emp, $mobile, $name, $drivernum, $veh, $link, $user_id, $curtz) {
        $result = array();
        if ($drivernum != "") {
            $drivernum = "(" . $drivernum . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }
        $logdate = date('Y-m-d H:i:s');
        /* $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
          $senddate = $getactual['datetime']; */
        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " is started now,track your truck by " . $link;
        $smsdata = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $logdate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message" => $message,
            "id" => $sentid);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert Once", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));
        /* $sendack = $this->smsnotifier->driverarrivalsms($smsdata); */
        return $result;
    }

    public function sendAlert($trip, $emp, $mobile, $name, $distance, $veh, $link, $user_id, $curtz) {
        $result = array();
        $this->db->select('d.contact_num');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
        $this->db->where('t.id', $trip);
        $this->db->limit(1);
        $drivermobile = $this->db->get();
        $drivernum = "";
        if ($drivermobile->num_rows() > 0) {
            $drivernum = "(" . $drivermobile->row()->contact_num . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }
        /* $logdate = date('Y-m-d H:i:s');
          $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
        $senddate = date('Y-m-d H:i:s');
        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " will be reached in " . $distance[1] . ", it is in distance " . $distance[0] . ",track your truck by " . $link;
        $smsdata = array("sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $senddate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0);
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = array("mobile" => $mobile,
            "message" => $message,
            "id" => $sentid);
        if ($user_id == "") {
            $user_id = 0;
        }
        $datas = array(
            "emp_id" => $emp,
            "trip_id" => $trip,
            "mobile" => $mobile,
            "message" => $message,
            "user_id" => $user_id,
            "created_on" => $senddate,
        );
        $ins = $this->db->insert("tb_trip_alerts", $datas);
        $fire_ret = @$this->sendfirebase->sendSinglePush(array("title" => "Truck Auto Arrival Alert", "message" => $message, "emp_id" => $emp, 'type' => 'Driver'));
        /* $sendack = $this->smsnotifier->driverarrivalsms($smsdata); */
        return $result;
    }

    public function closeTrip() {
        if ($_POST) {
            // log_message('error', "close_status " . json_encode($_POST));
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"] = $_POST["trip_id"];
            if ($data["id"] != "") {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $data["id"] = trim($data["id"]);
                $gettrip = $this->db->select("shift_id")->get_where("tb_trips", array("id" => $data["id"], "status" => 1), 1, 0);
                if ($gettrip->num_rows() > 0) {
                    /* $logdate = date('Y-m-d H:i:s');
                      $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
                    $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
                    $shiftid = $gettrip->row()->shift_id;
                    if ($shiftid > 0) {
                        $updwhr = ["id" => $shiftid];
                        $upddata = ["status" => '0', "updated_on" => $curdt];
                        $upd = $this->db->where(["id" => $shiftid])->update("tb_shifts", $upddata);
                        $upd = $this->db->where(["shift_id" => $shiftid])->update("tb_orders", ["trip_sts" => '1']);
                    }
                    $data1 = array();
                    $data1["end_imei"] = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
                    $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '0';
                    $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : $shiftid;
                    $latitude = isset($_POST["latitude"]) ? $_POST["latitude"] : '';
                    $longitude = isset($_POST["longitude"]) ? $_POST["longitude"] : '';
                    $data1["etime"] = $data1["updated_on"] = $curdt;
                    $data1["status"] = '0';
                    $data1["dlat"] = $latitude;
                    $data1["dlng"] = $longitude;
                    $res = $this->db->set($data1)->where($data)->update("tb_trips");
                    if ($res) {
                        $shift_res = $this->db->select('user_id,order_id')->order_by('id', 'desc')->get_where("tb_employee", array("shift_id" => $shipment_id), 1, 0);
                        if ($shift_res->num_rows() > 0) {
                            $shift = $shift_res->row();
                            $uid = $shift->user_id;
                            $gethrs = $this->db->query(
                                "SELECT c.cntry_hrs
                                FROM tbl_country_master AS c, tb_users AS u
                                WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                LIMIT 1",
                                [$uid]
                            );
                            $hrs = $gethrs->row()->cntry_hrs;
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id" => $data["id"],
                                "driver_id" => $data["driver_id"],
                                "stop_id" => '',
                                "order_id" => $shift->order_id,
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );
                            $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, "");
                            if ($stop_closed) {
                                /* $sts = $this->statusintigration->shipmentdeliveredpartially($postdata); */
                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipmenttripdeliverpartial($postdata);
                            } else {
                                /* $sts = $this->statusintigration->shipmentdelivered($postdata); */
                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                            }
                            $gensum = $this->generatesummary($data["id"], $curtz);
                            echo json_encode($this->printable(array("status" => "1", "data" => "Closed Sucessfully")));
                        } else {
                            echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                        }
                    } else {
                        echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                    }
                } else {
                    echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
                }
            } else {
                echo json_encode($this->printable(array("status" => "0", "data" => "Failed to Close")));
            }
        } else {
            echo json_encode($this->printable(array("status" => "0", "data" => "Insufficient Input Data")));
        }
    }

    private function printable($array) {
        $ret = [];
        foreach ($array as $key => $value) {
            if (is_array($value)) {
                $ret[$key] = $this->printable($value);
            } else {
                if (!isset($value) || $value == null) {
                    $value = "";
                }
                $ret[$key] = "$value";
            }
        }
        return $ret;
    }

    public function closeTripfromweb() {
        ob_start();
        if ($_POST) {
            $doneby = $this->session->userdata("user_id");
            // log_message('error', "close_statusweb " . $doneby . " " . json_encode($_POST));
            $data1 = $data = array();
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"] = $_POST["trip_id"];
            $curtz = date_default_timezone_get();
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            $chk = $this->db->select("shift_id,vehicle_id,plat,plng")->get_where("tb_trips", array("id" => $data["id"], "status" => 1), 1, 0);
            if ($chk->num_rows() > 0) {
                $data["id"] = trim($data["id"]);
                $logdate = date('Y-m-d H:i:s');
                $vehicle_id = $chk->row()->vehicle_id;
                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                $curdt = $getactual['datetime'];
                $shipment_id = $chk->row()->shift_id;
                if ($shipment_id > 0) {
                    $upd = $this->db->where(["id" => $shipment_id])->update("tb_shifts", ["status" => '0', "updated_on" => $curdt]);
                    $upd = $this->db->where(["shift_id" => $shipment_id])->update("tb_orders", ["trip_sts" => '1']);
                }
                $data1["end_imei"] = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
                $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '';
                $data1["etime"] = $data1["updated_on"] = $curdt;
                $trucks_query = $this->db->query(
                    "SELECT latitude, longitude FROM tb_trucks_data WHERE id = ? LIMIT 1",
                    [$vehicle_id]
                );
                $data1["status"] = '0';
                $data1["dlat"] = $chk->row()->plat;
                $data1["dlng"] = $chk->row()->plng;
                if ($trucks_query->num_rows() > 0) {
                    if ($trucks_query->row()->latitude != "") {
                        $data1["dlat"] = $trucks_query->row()->latitude;
                        $data1["dlng"] = $trucks_query->row()->longitude;
                    }
                }
                $res = $this->db->where($data)->update("tb_trips", $data1);
                $send = $this->generatewebsummary($data["id"], $curtz);
                $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(array("shift_id" => $shipment_id, 'ship_type' => 'P'))->get("tb_employee")->row();
                $uid = $shift->user_id;
                $gethrs = $this->db->query(
                    "SELECT c.cntry_hrs
                    FROM tbl_country_master AS c, tb_users AS u
                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                    LIMIT 1",
                    [$uid]
                );
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $data["id"],
                    "driver_id" => $data["driver_id"],
                    "stop_id" => '',
                    "order_id" => $shift->order_id,
                    "latitude" => "",
                    "longitude" => "",
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );
                $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, "");
                if ($stop_closed) {
                    /* $sts = $this->statusintigration->shipmentdeliveredpartially($postdata); */
                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmenttripdeliverpartial($postdata);
                } else {
                    /* $sts = $this->statusintigration->shipmentdelivered($postdata); */
                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                }
            }
        }
        redirect("dashboard/livecabdetails");
    }

    public function getstopstatus($whr, $curtz) {
        $res = array();
        $escapedCurtz = $this->db->escape($curtz);
        $this->db->select("s.id, s.stop_type, s.status_id, convertToClientTZ(s.createdon, {$escapedCurtz}) AS createdon, t.status_name");
        $this->db->from('tb_stop_status s');
        $this->db->join('tb_status_master t', 's.status_id=t.id', 'INNER');
        $this->db->where($whr);
        $this->db->order_by('s.createdon', 'DESC');
        $this->db->limit(1);
        $chkrecent = $this->db->get();
        if ($chkrecent->num_rows() > 0) {
            $res['name'] = $chkrecent->row()->status_name;
            $res['id'] = $chkrecent->row()->id;
            $res['createdon'] = $chkrecent->row()->createdon;
            $res['status_id'] = $chkrecent->row()->status_id;
            $res['stop_type'] = $chkrecent->row()->stop_type;
        }
        return $res;
    }

    public function checkLatLng($emp) {
        $sql = $this->db->select("plat,plng")->get_where("tb_employee", array("id" => $emp), 1, 0);
        if ($sql->num_rows() > 0) {
            $res = $sql->row();
            if ($res->plat == "" || $res->plng == "") {
                return "true";
            } else {
                return "false";
            }
        } else {
            return "false";
        }
    }

    public function generatewebsummary($tripid = null, $curtz = null) {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->db->query(
                "SELECT shift_id, vehicle_id, driver_id,
                convertToClientTZ(stime, ?) AS stime, convertToClientTZ(etime, ?) AS etime,
                etime AS tetime, start_imei, end_imei, start_reading, end_reading, trip_type,
                plat, plng, dlat, dlng
                FROM tb_trips WHERE id = ? AND status = 0 LIMIT 1",
                [$curtz, $curtz, $tripid]
            );
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $data["tripinfo"] = $sql->row();
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query(
                    "SELECT user_id, stime AS setime, convertToClientTZ(startdate, ?) AS startdate,
                    convertToClientTZ(enddate, ?) AS enddate, splace, eplace
                    FROM tb_shifts
                    WHERE id = ?
                    LIMIT 1",
                    [$curtz, $curtz, $shift]
                );
                $data["trip"] = $sql1->row();
                $order_id = "";
                $emp1 = $this->db->query(
                    "SELECT e.name, convertToClientTZ(te.stime, ?) AS in_time,
                    te.status AS emp_status, te.driver_late, te.emp_late, te.absent_reason,
                    m.material, e.shipment_volume, e.shipment_weight, e.order_id
                    FROM tb_employee AS e, tb_trip_employee AS te, tb_materials AS m
                    WHERE te.employee_id = e.id AND m.id = e.material_id AND te.trip_id = ?",
                    [$curtz, $tripid]
                );
                if ($emp1->num_rows() > 0) {
                    $order_id = $emp1->row()->order_id;
                }
                if ($order_id == "") {
                    $order = $this->db->query(
                        "SELECT order_id FROM tb_employee WHERE shift_id = ? LIMIT 1",
                        [$shift]
                    );
                    if ($order->num_rows() > 0) {
                        $order_id = $order->row()->order_id;
                    }
                }
                $emp = $this->db->query(
                    "SELECT IFNULL(SUM(IF(status = 1, 1, 0)), 0) AS attcnt,
                    COUNT(employee_id) AS totcnt
                    FROM tb_trip_employee
                    WHERE trip_id = ?",
                    [$tripid]
                );
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $trucks_query = $this->db->query(
                    "SELECT truck_capacity, register_number, vendor_id, truck_weight, truck_volume
                    FROM tb_trucks_data
                    WHERE id = ?
                    LIMIT 1",
                    [$vehicleid]
                );
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                }
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query(
                    "SELECT name, contact_num, vendor_id
                    FROM tb_truck_drivers
                    WHERE id = ?
                    LIMIT 1",
                    [$driverid]
                );
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                // if($order_id != ""){
                //     $upd = $this->db->where(array("order_id"=>$order_id))->update("tb_orders",array("trip_sts"=>'1'));
                // }else{
                //     $upd = $this->db->where(array("trip_id"=>$tripid))->update("tb_orders",array("trip_sts"=>'1'));
                // }

                $sql2 = $this->db->query(
                    "SELECT latitude, longitude, convertToClientTZ(timestamp, ?) AS timestamp
                    FROM tb_rtdrive_locations
                    WHERE mobileimei = ? and timestamp <= ? and timestamp >= ?
                    ORDER BY timestamp ASC",
                    [$curtz, $imei, $end, $start]
                );
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 0;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt);
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                $data["trip_id"] = $tripid;
                $shifttime = 0;
                if ($trip_type != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }
                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $dist;
                $data["stime"] = $stime;
                $data["etime"] = $etime;
                $data["simei"] = $imei;
                $data["eimei"] = $eimei;
                if ($odometer_end == "") {
                    $odometer_end = 0;
                }
                if ($odometer_start == "") {
                    $odometer_start = 0;
                }
                $data["odometer"] = ($odometer_end - $odometer_start);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cab_capacity;
                $data["employees"] = $emp1;
                $data["trip_type"] = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"] = $truck_weight;
                $data["truck_volume"] = $truck_volume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);
                    $repotmaildata = $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);
                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    if ($trip_type == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else if ($trip_type == 2) {
                        $this->email->subject('svkonekt: Empty Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }
            }
        }
    }

    public function generatesummary($tripid = null, $curtz = null) {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s');
            $reg = "";
            $sql = $this->db->query(
                "SELECT shift_id, vehicle_id, driver_id,
                convertToClientTZ(stime, ?) AS stime, convertToClientTZ(etime, ?) AS etime,
                etime AS tetime, start_imei, end_imei, start_reading, end_reading,
                trip_type, plat, plng, dlat, dlng
                FROM tb_trips
                WHERE id = ? AND status = 0
                LIMIT 1",
                [$curtz, $curtz, $tripid]
            );
            if ($sql->num_rows() > 0) {
                $data = array();
                $data['driver_name'] = $data['driver_num'] = "";
                $data["tripinfo"] = $sql->row();
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query(
                    "SELECT user_id, stime AS setime, convertToClientTZ(startdate, ?) AS startdate,
                    convertToClientTZ(enddate, ?) AS enddate, splace, eplace
                    FROM tb_shifts
                    WHERE id = ?
                    LIMIT 1",
                    [$curtz, $curtz, $shift]
                );
                $data["trip"] = $sql1->row();
                $order_id = "";
                $emp1 = $this->db->query(
                    "SELECT e.name, convertToClientTZ(te.stime, ?) AS in_time,
                    te.status AS emp_status, te.driver_late, te.emp_late, te.absent_reason,
                    m.material, e.shipment_volume, e.shipment_weight, e.order_id
                    FROM tb_employee AS e, tb_trip_employee AS te, tb_materials AS m
                    WHERE te.employee_id = e.id AND m.id = e.material_id AND te.trip_id = ?",
                    [$curtz, $tripid]
                );
                if ($emp1->num_rows() > 0) {
                    $order_id = $emp1->row()->order_id;
                }
                if ($order_id == "") {
                    $order = $this->db->query(
                        "SELECT order_id FROM tb_employee WHERE shift_id = ? LIMIT 1",
                        [$shift]
                    );
                    if ($order->num_rows() > 0) {
                        $order_id = $order->row()->order_id;
                    }
                }
                $emp = $this->db->query(
                    "SELECT IFNULL(SUM(IF(status = 1, 1, 0)), 0) AS attcnt, COUNT(employee_id) AS totcnt
                    FROM tb_trip_employee
                    WHERE trip_id = ?",
                    [$tripid]
                );
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $trucks_query = $this->db->query(
                    "SELECT truck_capacity, register_number, vendor_id, truck_weight, truck_volume
                    FROM tb_trucks_data
                    WHERE id = ?
                    LIMIT 1",
                    [$vehicleid]
                );
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                }
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query(
                    "SELECT name, contact_num, vendor_id FROM tb_truck_drivers WHERE id = ? LIMIT 1",
                    [$driverid]
                );
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                // if($order_id != ""){
                //     $upd = $this->db->where(array("order_id"=>$order_id))->update("tb_orders",array("trip_sts"=>'1'));
                // }else{
                //     $upd = $this->db->where(array("trip_id"=>$tripid))->update("tb_orders",array("trip_sts"=>'1'));
                // }

                $sql2 = $this->db->query(
                    "SELECT latitude, longitude, convertToClientTZ(timestamp, ?) AS timestamp
                    FROM tb_rtdrive_locations
                    WHERE mobileimei = ? AND timestamp <= ? AND timestamp >= ?
                    ORDER BY timestamp ASC",
                    [$curtz, $imei, $end, $start]
                );
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 0;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = array('trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt);
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", array("trip_id" => $tripid), 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                $data["trip_id"] = $tripid;
                $shifttime = 0;
                if ($trip_type != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }
                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $dist;
                $data["stime"] = $stime;
                $data["etime"] = $etime;
                $data["simei"] = $imei;
                $data["eimei"] = $eimei;
                if ($odometer_end == "") {
                    $odometer_end = 0;
                }
                if ($odometer_start == "") {
                    $odometer_start = 0;
                }
                $data["odometer"] = ($odometer_end - $odometer_start);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cab_capacity;
                $data["employees"] = $emp1;
                $data["trip_type"] = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"] = $truck_weight;
                $data["truck_volume"] = $truck_volume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", array("id" => $uid, "emailid !=" => ""), 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @array('trip_id' => $tripid, 'shift_id' => $shift, 'splace' => $data["trip"]->splace, 'eplace' => $data["trip"]->eplace, 'stime' => $stime, 'etime' => $etime, 'capacity' => $cab_capacity, 'simei' => $data['simei'], 'eimei' => $data['eimei'], 'totcnt' => $totalemp, 'attcnt' => $attendemp, 'distance' => $data['distance'], 'odometer' => $data['odometer'], 'driver_late' => $data['driver_late'], 'receivemail' => $receivemail, 'receivename' => $receivename, 'user_id' => $uid, 'createdon' => $curdt);
                    $repotmaildata = $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);
                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    if ($trip_type == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } else if ($trip_type == 2) {
                        $this->email->subject('svkonekt: Empty Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }
                //echo json_encode(array("status" => 1, "data" => $data));
            }
        }
    }

    public function savePickup($emp, $lat, $lng) {
        $data = array();
        $data["plat"] = $lat;
        $data["plng"] = $lng;
        $loc = getLocationName($lat, $lng);
        if (strlen($loc) > 0) {
            $type = 'P';
            $emptype = $this->db->select('ship_type')->get_where('tb_employee', array('id' => $emp), 1, 0);
            if ($emptype->num_rows() > 0) {
                $type = $emptype->row()->ship_type;
            }
            if ($type == 'P') {
                $data["pickup"] = $data["address"] = $loc;
            } else {
                $data["dlat"] = $lat;
                $data["dlng"] = $lng;
                $data['drop'] = $data["address"] = $loc;
            }
        }
        $res = $this->db->where("id", $emp)->update("tb_employee", $data);
    }

    public function poduploads1() {
        $response = array("status" => 0, "data" => "Upload Failed!");
        if (isset($_POST)) {
            $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
            $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;
            $status_id = isset($_POST['status_id']) ? $_POST['status_id'] : null;
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : null;
            $shipment_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : null;
            $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : null;
            $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : null;
            $stop_detail_type = isset($_POST['stop_detail_type']) ? $_POST['stop_detail_type'] : null;
            $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : null;
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
            $pdfName = $fileName = "";

            if (isset($_FILES)) {

                if (isset($_FILES['file_name']['name'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => '*',
                        'overwrite' => true,
                    );
                    $receive_base64 = false;
                    $file_name = $_FILES['file_name']['name'];
                    $file_ext = @strtolower(end(explode('.', $_FILES['file_name']['name'])));

                    /*
                     * If Image is a base64
                     */

                    if (isset($_POST['i_am_base64']) && $_POST['i_am_base64'] != '') {
                        // valid base64
                        $encoded_image = explode(",", $_POST['i_am_base64'])[1];
                        $decoded_image = base64_decode($encoded_image);

                        $receive_base64 = TRUE;
                        $file_ext = 'jpeg';
                        $file_name = 'Sign_' . date('Ymd') . '_' . $trip_id . '_' . $shipment_id . '_' . $stop_id . '_' . $stop_detail_id . '_' . time() . '_' . uniqid() . '' . $file_ext;
                        file_put_contents($config['upload_path'] . $file_name, $decoded_image);
                    }

                    $expensions = array("jpeg", "jpg", "png", "gif", "pdf");

                    if (in_array($file_ext, $expensions) === false) {
                        $response = array("status" => 0, "data" => "Image Format Not Allowed");
                    } else {
                        if (!$receive_base64) {
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                                $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                            } else {
                                $errors = $this->upload->display_errors();
                                $response = array("status" => 0, "data" => $errors);
                            }
                        } else {
                            // base 64 data block
                            $imgname = $file_name;
                            $imgtype = $file_ext;
                            $fileName = $file_name;
                            $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                        }
                        if ($fileName != "") {
                            $stptype = "P";
                            $txncode = "";
                            $ordid = 0;
                            $legsorder_id = "";
                            if ($stop_id != "") {
                                $chkstype = $this->db->select("stoptype,txncode")->get_where("tb_shiporder_stops", array("id" => $stop_id, "status" => 1), 1, 0);
                                if ($chkstype->num_rows() > 0) {
                                    if ($chkstype->row()->stoptype == "D") {
                                        $stptype = $chkstype->row()->stoptype;
                                    }
                                    $txncode = $chkstype->row()->txncode;
                                }
                            }
                            $uid = 0;
                            $ord_whr = "";
                            if ($stop_id != "") {
                                $escapedStopId = $this->db->escape($stop_id);
                                $ord_whr = " AND (e.stop_id = {$escapedStopId} OR e.drop_stopid = {$escapedStopId}) ";
                            }
                            if ($stop_detail_id != "") {
                                $escapedStopDetailId = $this->db->escape($stop_detail_id);
                                $ord_whr = " AND e.id = {$escapedStopDetailId} ";
                            }
                            $chkord = $this->db->query(
                                "SELECT o.id, o.order_id, o.user_id, o.shipmentid
                                FROM tb_orders AS o, tb_employee AS e
                                WHERE o.order_id = e.order_id AND o.shift_id = ? AND e.status = 1 {$ord_whr}
                                LIMIT 1",
                                [$shipment_id]
                            );
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $uid = $chkord->row()->user_id;
                                if ($txncode == "") {
                                    $txncode = $chkord->row()->shipmentid;
                                }
                            }
                            $imageSize = filesize(NEW_POD_PATH.$fileName);
                            $newUuid = $this->uuid->v4();
                            $filedata = ['stop_id' => $stop_id, "shipment_id" => $shipment_id, 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_id, 'imgpath' => $fileName, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stptype, 'user_id' => $uid, 'createdby' => $driver_id, 'order_id' => $ordid, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                            $res = $this->db->insert("tb_pod_uploads", $filedata);
                            $podinsid = $this->db->insert_id();
                            if ($stop_id == "") {
                                $stop = $this->db->select('id,stoptype,txncode')->order_by('ordernumber', 'ASC')->get_where("tb_shiporder_stops", array("shipment_id" => $shipment_id), 1, 0)->row();
                                $txncode = $stop->txncode;
                                $stop_id = $stop->id;
                                $stptype = $stop->stoptype;
                            }
                            $cnt = $this->db->select('id')->get_where('tb_pod_uploads', array('trip_id' => $trip_id))->num_rows();
                            if ($cnt == 0) {
                                $cntstr = "001";
                            } else {
                                $cntstr = "00" . $cnt;
                                if ($cnt > 9) {
                                    $cntstr = "0" . $cnt;
                                }
                            }
                            $gethrs = $this->db->query(
                                "SELECT c.cntry_hrs
                                FROM tbl_country_master AS c, tb_users AS u
                                WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                LIMIT 1",
                                [$uid]
                            );
                            $hrs = $gethrs->row()->cntry_hrs;
                            $imgtype = isset($imgtype) ? $imgtype : 'png';
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id" => $trip_id,
                                "driver_id" => $driver_id,
                                "stop_id" => $stop_id,
                                "order_id" => $legsorder_id,
                                "txn_id" => $txncode,
                                "txn_code" => $txncode,
                                "file_name" => $fileName,
                                "file_type" => $imgtype,
                                "inc_id" => $cntstr,
                                'pod_type' => $status_id,
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "stop_type" => $stptype,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );
                            /* $sts = $this->statusintigration->orderrealesestatusapi($postdata); */
                            if ($status_id == '3') {
                                $sts = $this->statusintigration->roadlogorderpodstatus($postdata);
                                /* send mail to customer */
                                $sendnotify = $this->sendshipstatusnotify($postdata, 6);
                                /* send mail to admin cc mail */
                                /* $sendnotify = $this->sendepodstatusnotifyadmin($postdata); */
                                /* send mail to specific party */
                                $sendnotify = $this->sendepodstatusnotify($postdata);
                            }
                            /* $sts = $this->statusintigration->roadlogorderrealesestatus($postdata); */
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function poduploads() {
        $response = array("status" => 0, "data" => "Upload Failed!");
        if (isset($_POST)) {
            $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : null;
            $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : null;
            $status_id = isset($_POST['status_id']) ? $_POST['status_id'] : null;
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : null;
            $shipment_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : null;
            $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : null;
            $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : null;
            $stop_detail_type = isset($_POST['stop_detail_type']) ? $_POST['stop_detail_type'] : null;
            $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : null;
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
            $pdfName = $fileName = "";

            if (isset($_FILES) || isset($_POST['i_am_base64'])) {

                if (isset($_FILES['file_name']['name']) || isset($_POST['i_am_base64'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => '*',
                        'overwrite' => true,
                    );

                    $file_name = $_FILES['file_name']['name'];
                    $file_ext = @strtolower(end(explode('.', $_FILES['file_name']['name'])));

                    /*
                     * If Image is a base64
                     */
                    $receive_base64 = false;
                    if (isset($_POST['i_am_base64'])) {
                        // valid base64
                        $encoded_image = explode(",", $_POST['i_am_base64'])[1];
                        $decoded_image = base64_decode($encoded_image);

                        $receive_base64 = TRUE;
                        $file_ext = 'jpeg';

                        // $file_name = 'Sign_' . date('Ymd') . '_' . $trip_id . '_' . $shipment_id . '_' . $stop_id . '_' . $stop_detail_id . '.' . $file_ext;
                        $file_name = 'Sign_' . date('Ymd') . '_' . $trip_id . '_' . $shipment_id . '_' . $stop_id . '_' . $stop_detail_id . '_' . time() . '_' . uniqid() . '' . $file_ext;
                        file_put_contents($config['upload_path'] . $file_name, $decoded_image);
                    }

                    $expensions = array("jpeg", "jpg", "png", "gif", "pdf");

                    if (in_array($file_ext, $expensions) === false) {
                        $response = array("status" => 0, "data" => "Image Format Not Allowed");
                    } else {
                        if (!$receive_base64) {
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                                $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                            } else {
                                $errors = $this->upload->display_errors();
                                $response = array("status" => 0, "data" => $errors);
                            }
                        } else {
                            // base 64 data block
                            $imgname = $file_name;
                            $imgtype = $file_ext;
                            $fileName = $file_name;
                            $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                        }
                        if ($fileName != "") {
                            $stptype = "P";
                            $txncode = "";
                            $ordid = 0;
                            $legsorder_id = "";
                            if ($stop_id != "") {
                                $chkstype = $this->db->select("stoptype,txncode")->get_where("tb_shiporder_stops", array("id" => $stop_id, "status" => 1), 1, 0);
                                if ($chkstype->num_rows() > 0) {
                                    if ($chkstype->row()->stoptype == "D") {
                                        $stptype = $chkstype->row()->stoptype;
                                    }
                                    $txncode = $chkstype->row()->txncode;
                                }
                            }
                            $uid = 0;
                            $ord_whr = "";
                            if ($stop_id != "") {
                                $escapedStopId = $this->db->escape($stop_id);
                                $ord_whr = " AND (e.stop_id = {$escapedStopId} OR e.drop_stopid = {$escapedStopId}) ";
                            }
                            if ($stop_detail_id != "") {
                                $escapedStopDetailId = $this->db->escape($stop_detail_id);
                                $ord_whr = " AND e.id = {$escapedStopDetailId} ";
                            }
                            $chkord = $this->db->query(
                                "SELECT o.id, o.order_id, o.user_id, o.shipmentid
                                FROM tb_orders AS o, tb_employee AS e
                                WHERE o.order_id = e.order_id AND o.shift_id = ? AND e.status = 1 {$ord_whr}
                                LIMIT 1",
                                [$shipment_id]
                            );
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $uid = $chkord->row()->user_id;
                                if ($txncode == "") {
                                    $txncode = $chkord->row()->shipmentid;
                                }
                            }
                            $imageSize = filesize(NEW_POD_PATH.$fileName);
                            $newUuid = $this->uuid->v4();
                            $filedata = ['stop_id' => $stop_id, "shipment_id" => $shipment_id, 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_id, 'imgpath' => $fileName, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stptype, 'user_id' => $uid, 'createdby' => $driver_id, 'order_id' => $ordid, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                            $res = $this->db->insert("tb_pod_uploads", $filedata);
                            $podinsid = $this->db->insert_id();
                            if ($stop_id == "") {
                                $stop = $this->db->select('id,stoptype,txncode')->order_by('ordernumber', 'ASC')->get_where("tb_shiporder_stops", array("shipment_id" => $shipment_id), 1, 0)->row();
                                $txncode = $stop->txncode;
                                $stop_id = $stop->id;
                                $stptype = $stop->stoptype;
                            }
                            $cnt = $this->db->select('id')->get_where('tb_pod_uploads', array('trip_id' => $trip_id))->num_rows();
                            if ($cnt == 0) {
                                $cntstr = "001";
                            } else {
                                $cntstr = "00" . $cnt;
                                if ($cnt > 9) {
                                    $cntstr = "0" . $cnt;
                                }
                            }
                            $gethrs = $this->db->query(
                                "SELECT c.cntry_hrs
                                FROM tbl_country_master AS c, tb_users AS u
                                WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                LIMIT 1",
                                [$uid]
                            );
                            $hrs = $gethrs->row()->cntry_hrs;
                            $imgtype = isset($imgtype) ? $imgtype : 'png';
                            $postdata = array(
                                "shipment_id" => $shipment_id,
                                "trip_id" => $trip_id,
                                "driver_id" => $driver_id,
                                "stop_id" => $stop_id,
                                "order_id" => $legsorder_id,
                                "txn_id" => $txncode,
                                "txn_code" => $txncode,
                                "file_name" => $fileName,
                                "file_type" => $imgtype,
                                "inc_id" => $cntstr,
                                'pod_type' => $status_id,
                                "latitude" => $latitude,
                                "longitude" => $longitude,
                                "stop_type" => $stptype,
                                "curtz" => $curtz,
                                "hrs" => $hrs
                            );
                            /* $sts = $this->statusintigration->orderrealesestatusapi($postdata); */
                            if ($status_id == '3') {
                                $sts = $this->statusintigration->roadlogorderpodstatus($postdata);
                                /* send mail to customer */
                                $sendnotify = $this->sendshipstatusnotify($postdata, 6);
                                /* send mail to admin cc mail */
                                /* $sendnotify = $this->sendepodstatusnotifyadmin($postdata); */
                                /* send mail to specific party */
                                $sendnotify = $this->sendepodstatusnotify($postdata);
                            }
                            /* $sts = $this->statusintigration->roadlogorderrealesestatus($postdata); */
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }

    public function saveAsPdf($image = '') {
        $file = NEW_POD_PATH . $image;
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        $name = pathinfo($file, PATHINFO_FILENAME);
        $pdf = new FPDF();
        $pdf->AddPage();
        $ext = "";
        if (strtolower($ext) == "png") {
            $ext = "PNG";
        } else if (strtolower($ext) == "jpg") {
            $ext = "JPG";
        } else if (strtolower($ext) == "jpeg") {
            $ext = "JPEG";
        } else if (strtolower($ext) == "gif") {
            $ext = "GIF";
        }
        if (!file_exists(NEW_POD_PATH)) {
            mkdir(NEW_POD_PATH, 0710, true);
        }
        $pdf->Image($file, 10, 10, 190, 0, $ext);
        $pdf->Output(NEW_POD_PATH . $name . ".pdf", 'F');
        return $name . ".pdf";
    }

    public function stopsstatuses() {
        $response = array("status" => 0, "data" => "Something went wrong!");
        $data = array('status' => 1);
        $result['yes'] = $result['no'] = array();
        $res = $this->db->select('id,status_name,status_type')->order_by('id', 'ASC')->get_where("tb_status_master", $data);
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $r) {
                if ($r->status_type == 'yes') {
                    $result['yes'][] = array('id' => $r->id, 'status_name' => $r->status_name);
                } else {
                    $result['no'][] = array('id' => $r->id, 'status_name' => $r->status_name);
                }
            }
            $response = array("status" => 1, "data" => $result);
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }

    public function shipdashboard() {
        $response = array("status" => 0, "data" => "Something went wrong!");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        if ($driver_id > 0) {
            $acc_whr = array('driver_id' => $driver_id, 'status' => 1);
            $com_whr = array('driver_id' => $driver_id, 'status' => 0);
            $rej_whr = array('driver_id' => $driver_id, 'status' => 2);
            $accepted = $this->db->select('id')->get_where('tb_trips', $acc_whr)->num_rows();
            if ($accepted > 0) {
                $accepted = $this->db->query(
                    "SELECT id FROM tb_trips WHERE driver_id = ? AND status = 1",
                    [$driver_id]
                )->num_rows();
            }
            $rejected = $this->db->select('id')->get_where('tb_trips', $rej_whr)->num_rows();
            $completed = $this->db->select('id')->get_where('tb_trips', $com_whr)->num_rows();
            $data = array('accepted' => $accepted, 'rejected' => $rejected, 'completed' => $completed);
            $response = array("status" => 1, "data" => $data);
        } else {
            $response = array("status" => 0, "data" => "Something went wrong,please try again!");
        }
        echo json_encode($response);
    }

    public function getshipments_test() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");

        if (isset($_POST)) {
            /* null-new, 0-accepted , 1-in-transit, 2-completed */
            $driver = isset($_POST["driver_id"]) ? $_POST["driver_id"] : "";
            $imei = isset($_POST["imei"]) ? $_POST["imei"] : "";
            $type = isset($_POST["type"]) ? $_POST["type"] : "";
            $search = isset($_POST["search"]) ? $_POST["search"] : "";

            if ($driver != "" && $imei != "") {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $whr = array("id" => $driver, "status" => "Active");
                $res = $this->db->select("id,user_id")->get_where("tb_truck_drivers", $whr, 1, 0);

                if ($res->num_rows() > 0) {
                    if (isset($_POST["pman"]) && $_POST["pman"] == '2') {

                    } else {
                        $upd = $this->db->where(array("id" => $driver))->update("tb_truck_drivers", array("imei" => $imei));
                        $chkdri = $this->db->select("id")->get_where("tbl_assigned_drivers", array("driver_id" => $driver), 1, 0);
                        if ($chkdri->num_rows() > 0) {
                            $upd = $this->db->where(array("driver_id" => $driver))->update("tbl_assigned_drivers", array("imei" => $imei));
                        }
                    }

                    /* search by ord or ord ref num */
                    $searchres = array();
                    $resqry = $res->row();
                    $uid = $resqry->user_id;

                    if ($search != "") {
                        $escapedSearch = $this->db->escape_like_str($search);
                        $searchwhr = " AND (r.ref_value LIKE '%{$escapedSearch}%' OR o.order_id LIKE '%{$escapedSearch}%') ";
                        $cmpwhr = "";

                        if (($type == "") || ($type == 0) || ($type == 1)) {
                            $cmpwhr = " AND o.trip_sts = 0 ";
                        } else {
                            $cmpwhr = " AND o.trip_sts = 1 ";
                        }

                        $qry = $this->db->query(
                            "SELECT o.shift_id
                            FROM tb_orders AS o, tb_order_references AS r
                            WHERE o.id = r.order_id AND o.user_id = ? {$searchwhr}
                            AND o.status = 2 {$cmpwhr} AND r.status = 1
                            GROUP BY o.shift_id",
                            [$uid]
                        );

                        if ($qry->num_rows() > 0) {
                            foreach ($qry->result() as $res1) {
                                $searchres[] = $this->db->escape($res1->shift_id);
                            }
                        }
                    }

                    $reswhr = '';

                    if (!empty($searchres)) {
                        $implodedSearchres = implode(',', $searchres);
                        $reswhr = " AND s.id IN ({$implodedSearchres}) ";
                    }

                    if (($type == "") || ($type == 0) || ($type == 1)) {
                        $query = $this->db->query(
                            "SELECT
                                IFNULL(t.id, '') AS id, s.id AS shift_id,
                                s.user_id, d.id AS driver_id, s.stime, s.etime, s.trip_type,
                                convertToClientTZ(s.startdate, ?) AS startdate,
                                convertToClientTZ(s.enddate, ?) AS enddate,
                                s.splace, s.eplace, s.scity, s.dcity, s.slat, s.slng, s.elat, s.elng,
                                s.shipmentid, s.border_type, v.id AS shift_veh_id, a.vehicle_id, a.imei,
                                IFNULL((SELECT SUM(cargo.weight) FROM tb_order_cargodetails cargo JOIN tb_orders odr on odr.id=cargo.order_id WHERE odr.shipmentid=o.shipmentid),'0' ) AS shipweight,
                                IFNULL(t.transit_status, -1) AS astatus,
                                (SELECT IFNULL(COUNT(*), 0) pickup_count
                                    FROM tb_shiporder_stops AS tbss
                                    WHERE tbss.stoptype='P' AND tbss.shipment_id = shift_id) AS no_of_pickup,
                                (SELECT IFNULL(COUNT(*), 0) pickup_count
                                    FROM tb_shiporder_stops AS tbss
                                    WHERE tbss.stoptype = 'D' AND tbss.shipment_id = shift_id) AS no_of_drop
                            FROM tb_shifts AS s
                                JOIN tb_orders o ON o.shift_id=s.id
                                JOIN tb_shft_veh AS v ON s.id = v.shft_id AND v.status = 1
                                JOIN tbl_assigned_drivers AS a ON v.vehicle_id = a.vehicle_id
                                JOIN tb_truck_drivers AS d ON d.id = a.driver_id
                                LEFT JOIN tb_trips AS t ON t.shift_id = s.id AND t.driver_id = d.id AND t.status = 1
                            WHERE s.user_id = ? AND s.status = 1 AND v.status = 1 AND a.status = 1 AND a.driver_id = ? AND d.id = ? {$reswhr}
                            GROUP BY s.id
                            ORDER BY astatus DESC",
                            [$curtz, $curtz, $uid, $driver, $driver]
                        );
                    } else {
                        $query = $this->db->query(
                            "SELECT s.id AS shift_id, t.id, s.user_id, s.stime, s.etime, s.trip_type,
                                convertToClientTZ(s.startdate, ?) AS startdate,
                                convertToClientTZ(s.enddate, ?) AS enddate,
                                s.splace, s.eplace, s.scity, s.dcity, s.slat, s.slng, s.elat, s.elng,
                                s.shipmentid, s.border_type, v.id AS shift_veh_id, t.vehicle_id, t.start_imei AS imei,
                                IFNULL((SELECT SUM(cargo.weight) FROM tb_order_cargodetails cargo JOIN tb_orders odr on odr.id=cargo.order_id WHERE odr.shipmentid=o.shipmentid),'0' ) AS shipweight,
                                2 AS astatus
                            FROM tb_shifts AS s, tb_shft_veh AS v, tb_employee AS e, tb_trips AS t
                            JOIN tb_orders o ON o.shift_id=s.id
                            WHERE s.id = v.shft_id AND s.id = e.shift_id AND s.id = t.shift_id AND e.status = 1
                                AND t.driver_id = ? AND v.vehicle_id = t.vehicle_id AND s.status = 0 AND t.status = 0
                                AND v.user_id = ? {$reswhr}
                            GROUP BY s.id",
                            [$curtz, $curtz, $driver, $uid]
                        );
                    }

                    $res = array();
                    $res['trips'] = array();

                    if ($query->num_rows() > 0) {
                        $i = 0;
                        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', array('status' => 1))->result_array();

                        foreach ($query->result_array() as $d) {
                            $d = $this->extractShiporderStops($d);
                            [$pickup, $drop] = $this->addressesFromShift($d);

                            $d["splace"] = $pickup;
                            $d["eplace"] = $drop;

                            if (($type == "") || ($type == 0) || ($type == 1)) {
                                if ($d['id'] == "") {
                                    $trip = $this->db->query(
                                        "SELECT id, transit_status
                                        FROM tb_trips
                                        WHERE driver_id = ? AND shift_id = ? AND status = 1
                                        ORDER BY id DESC
                                        LIMIT 1",
                                        [$driver, $d['shift_id']]
                                    );

                                    if ($trip->num_rows() > 0) {
                                        $d['astatus'] = 0;
                                        if ($trip->row()->transit_status == 1) {
                                            $d['astatus'] = 1;
                                        }
                                        $d["id"] = $trip->row()->id;
                                    }
                                }

                                if ($d["id"] == "") {
                                    $d['astatus'] = '';
                                } else {
                                    [$signature, $pod] = $this->checkSignatureAndPod($d);
                                }

                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance'] = $dist['disttext'];
                                $d['duration'] = $dist['duratext'];
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate'] = strtotime($d['enddate']);
                                $d['pod'] = $pod;
                                $d['signature'] = $signature;
                                $res['trips'][] = $d;
                                $i++;
                            } else {
                                [$signature, $pod] = $this->checkSignatureAndPod($d);
                                $d['sno'] = $i;
                                $dist = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                                $d['distance'] = $dist['disttext'];
                                $d['duration'] = $dist['duratext'];
                                $d['startdate'] = strtotime($d['startdate']);
                                $d['enddate'] = strtotime($d['enddate']);
                                if ($d['astatus'] == '-1') {
                                    $d['astatus'] = '';
                                }
                                $d['pod'] = $pod;
                                $d['signature'] = $signature;
                                $res['trips'][] = $d;
                                $i++;
                            }
                        }
                        $response = array("status" => 1, "data" => $res);
                    } else {
                        $response = array("status" => 0, "data" => "Not Found");
                    }
                } else {
                    $response = array("status" => 2, "data" => "Imei Changed!");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found!");
            }
        }

        echo json_encode($response);
    }

    public function getshipments() {
        $response = array();
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $driver = $_POST["driver_id"] ?? "";
            $imei = $_POST["imei"] ?? "";
            $type = $_POST["type"] ?? "";
            $search = $_POST["search"] ?? "";
            if ($driver != "" && $imei != "") {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $whr = array("id" => $driver, "status" => "Active");
                $res = $this->db->select("id,user_id")->get_where("tb_truck_drivers", $whr, 1, 0);
                if ($res->num_rows() > 0) {
                    if (isset($_POST["pman"]) && $_POST["pman"] == '2') {

                    } else {
                        $upd = $this->db->where(array("id" => $driver))->update("tb_truck_drivers", array("imei" => $imei));
                        $chkdri = $this->db->select("id")->get_where("tbl_assigned_drivers", array("driver_id" => $driver), 1, 0);
                        if ($chkdri->num_rows() > 0) {
                            $upd = $this->db->where(array("driver_id" => $driver))->update("tbl_assigned_drivers", array("imei" => $imei));
                        }
                    }
                    /* search by ord or ord ref num */
                    $searchwhr = "";
                    $searchres = array();
                    $resqry = $res->row();
                    $uid = $resqry->user_id;
                    if ($search != "") {
                        $escapedSearch = $this->db->escape_like_str($search);
                        $searchwhr = " AND (r.ref_value LIKE '%{$escapedSearch}%' OR o.order_id LIKE '%{$escapedSearch}%') ";
                        $cmpwhr = "";
                        if (($type == "") || ($type == 0) || ($type == 1)) {
                            $cmpwhr = " AND o.trip_sts = 0 ";
                        } else {
                            $cmpwhr = " AND o.trip_sts = 1 ";
                        }
                        $qry = $this->db->query(
                            "SELECT o.shift_id
                            FROM tb_orders AS o, tb_order_references AS r
                            WHERE o.id = r.order_id AND o.user_id = ? {$searchwhr} AND o.status = 2 {$cmpwhr} AND r.status = 1
                            GROUP BY o.shift_id",
                            [$uid]
                        );
                        if ($qry->num_rows() > 0) {
                            foreach ($qry->result() as $res1) {
                                $searchres[] = $this->db->escape($res1->shift_id);
                            }
                        }
                    }
                    $reswhr = '';
                    if (!empty($searchres)) {
                        $implodedSearchres = implode(',', $searchres);
                        $reswhr = " AND s.id IN ({$implodedSearchres}) ";
                    }
                    if ($type === "" || $type === 0 || $type === 1) {
                        $query = $this->db->query(
                            "SELECT
                                IFNULL(t.id, '') AS id, s.id AS shift_id,
                                s.user_id, d.id AS driver_id, s.stime, s.etime, s.trip_type,
                                convertToClientTZ(s.startdate, ?) AS startdate,
                                convertToClientTZ(s.enddate, ?) AS enddate,
                                s.splace, s.eplace, s.scity, s.dcity, s.slat, s.slng, s.elat, s.elng,
                                s.shipmentid, s.border_type, v.id AS shift_veh_id, a.vehicle_id, a.imei,
                                IFNULL((SELECT SUM(cargo.weight) FROM tb_order_cargodetails cargo JOIN tb_orders odr on odr.id=cargo.order_id WHERE odr.shipmentid=o.shipmentid),'0' ) AS shipweight,
                                IFNULL(t.transit_status, -1) AS astatus,
                                tss.stop_id,
                                tss.drop_stopid
                            FROM tb_shifts AS s
                                JOIN tb_orders o ON o.shift_id=s.id
                                JOIN tb_shft_veh AS v ON s.id = v.shft_id
                                JOIN tbl_assigned_drivers AS a ON v.vehicle_id = a.vehicle_id
                                JOIN tb_truck_drivers AS d ON d.id = a.driver_id
                                LEFT JOIN tb_trips AS t ON t.shift_id = s.id AND t.driver_id = d.id
                                LEFT JOIN tb_employee AS tss ON tss.shift_id = s.id
                            WHERE  s.status = 1
                                AND v.status = 1
                                AND a.status = 1
                                AND t.status = 1
                                AND s.user_id = ?
                                AND a.driver_id = ?
                                AND d.id = ? {$reswhr}
                            GROUP BY s.id
                            ORDER BY astatus DESC",
                            [$curtz, $curtz, $uid, $driver, $driver]
                        );
                    } else {
                        $query = $this->db->query(
                            "SELECT
                                s.id AS shift_id, t.id, s.user_id, s.stime, s.etime, s.trip_type,
                                convertToClientTZ(s.startdate, ?) AS startdate,
                                convertToClientTZ(s.enddate, ?) AS enddate,
                                s.splace, s.eplace, s.scity, s.dcity, s.slat, s.slng, s.elat, s.elng,
                                s.shipmentid, s.border_type, v.id AS shift_veh_id, t.vehicle_id, t.start_imei AS imei,
                                IFNULL((SELECT SUM(cargo.weight) FROM tb_order_cargodetails cargo JOIN tb_orders odr on odr.id=cargo.order_id WHERE odr.shipmentid=o.shipmentid),'0' ) AS shipweight,
                                2 AS astatus
                            FROM tb_shifts AS s
                                JOIN tb_orders o ON o.shift_id=s.id
                                JOIN tb_shft_veh AS v ON s.id = v.shft_id
                                JOIN tb_employee AS tss ON tss.shift_id = s.id
                                JOIN tb_trips AS t ON s.id = t.shift_id AND v.vehicle_id = t.vehicle_id
                            WHERE tss.status = 1
                                AND s.status = 0
                                AND t.status = 0
                                AND t.driver_id = ?
                                AND v.user_id = ? {$reswhr}
                            GROUP BY s.id",
                            [$curtz, $curtz, $driver, $uid]
                        );
                    }
                    $res = array();
                    $res['trips'] = array();
                    if ($query->num_rows() > 0) {
                        $i = 0;
                        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', array('status' => 1))->result_array();
                        foreach ($query->result_array() as $shiftData) {
                            $ordersCountQuery = $this->db->select("count(order_id) as orders_count")->get_where("tb_orders", ['shift_id' => $shiftData['shift_id'], 'status >' => 0]);
                            if ($ordersCountQuery->num_rows() > 0) {
                                $ordersCount = $ordersCountQuery->row()->orders_count;
                                if ($ordersCount > 0) {
                                    $statusWhere = ['shipment_id' => $shiftData['shift_id'], 'status_id' => 6, 'status_code' => '0217'];
                                    $stopStatuses = $this->db->where($statusWhere)->get("tb_stop_status");
                                    if ($stopStatuses->num_rows() == 0) {
                                        $shiftData = $this->countPickupDropGateins($shiftData);
                                        $shiftData = $this->extractShiporderStops($shiftData);
                                        [$pickup, $drop] = $this->addressesFromShift($shiftData);
                                        $shiftData["splace"] = $pickup;
                                        $shiftData["eplace"] = $drop;
                                        $shiftData['no_of_pickup'] = $this->getpicksdropsbystop($shiftData['shift_id'], $shiftData['stop_id'], 'P');
                                        $shiftData['no_of_drop'] = $this->getpicksdropsbystop($shiftData['shift_id'], $shiftData['drop_stopid'], 'D');
                                        $shiftData['is_deviated'] = $this->is_deviated($shiftData['id'], $shiftData['shift_id'], $shiftData['stop_id']);
                                        if (($type == "") || ($type == 0) || ($type == 1)) {
                                            if ($shiftData['id'] == "") {
                                                $trip = $this->db->query(
                                                    "SELECT id, transit_status
                                                    FROM tb_trips
                                                    WHERE driver_id = ? AND shift_id = ? AND status = 1
                                                    ORDER BY id DESC
                                                    LIMIT 1",
                                                    [$driver, $shiftData['shift_id']]
                                                );
                                                if ($trip->num_rows() > 0) {
                                                    $shiftData['astatus'] = 0;
                                                    if ($trip->row()->transit_status == 1) {
                                                        $shiftData['astatus'] = 1;
                                                    }
                                                    $shiftData["id"] = $trip->row()->id;
                                                }
                                            }
                                            $signature = $pod = "";
                                            if ($shiftData["id"] == "") {
                                                $shiftData['astatus'] = '';
                                            } else {
                                                [$signature, $pod] = $this->checkSignatureAndPod($shiftData);
                                            }
                                            $shiftData['sno'] = $i;
                                            $dist = distancemetrixship($shiftData['slat'], $shiftData['slng'], $shiftData['elat'], $shiftData['elng']);
                                            $shiftData['distance'] = $dist['disttext'];
                                            $shiftData['duration'] = $dist['duratext'];
                                            $shiftData['startdate'] = strtotime($shiftData['startdate']);
                                            $shiftData['enddate'] = strtotime($shiftData['enddate']);
                                            $shiftData['pod'] = $pod;
                                            $shiftData['signature'] = $signature;
                                            $res['trips'][] = $shiftData;
                                            $i++;
                                        } else {
                                            [$signature, $pod] = $this->checkSignatureAndPod($shiftData);
                                            $shiftData['sno'] = $i;
                                            $dist = distancemetrixship($shiftData['slat'], $shiftData['slng'], $shiftData['elat'], $shiftData['elng']);
                                            $shiftData['distance'] = $dist['disttext'];
                                            $shiftData['duration'] = $dist['duratext'];
                                            $shiftData['startdate'] = strtotime($shiftData['startdate']);
                                            $shiftData['enddate'] = strtotime($shiftData['enddate']);
                                            if ($shiftData['astatus'] == '-1') {
                                                $shiftData['astatus'] = '';
                                            }
                                            $shiftData['pod'] = $pod;
                                            $shiftData['signature'] = $signature;
                                            $res['trips'][] = $shiftData;
                                            $i++;
                                        }
                                    }
                                }
                            }
                        }
                        $response = array("status" => 1, "data" => $res);
                    } else {
                        $response = array("status" => 0, "data" => "Not Found");
                    }
                } else {
                    $response = array("status" => 2, "data" => "Imei Changed!");
                }
            } else {
                $response = array("status" => 0, "data" => "Not Found!");
            }
        }
//        log_message("Error","---@---".json_encode($response));
        echo json_encode($response);
    }

    /*
     *   Purpose : To know a shipment is deviated or not
     *   @Param Trip int
     *   @Param shipment_id int
     *   @Param stop_id   Int
     *   retrun int
     */

    function is_deviated($trip_id,$shipment_id,$stop_id){
        $is_deviated=0;
        if(is_numeric($trip_id) && is_numeric($shipment_id) && is_numeric($stop_id)){
            $result_set = $this->db->query(
                "SELECT id
                FROM tb_deviations_details
                WHERE shift_id = ? AND trip_id = ? AND stop_id = ?
                LIMIT 1",
                [$shipment_id, $trip_id, $stop_id]
            );
            if($result_set->num_rows() >0){
                 $is_deviated=1;
            }
        }
        return $is_deviated;
    }


    function getpicksdropsbystop($ship,$stop,$type){
        $ci =& get_instance();
        $res = array();
        if($ship != "" && $type=="P"){
            $whr = array('shift_id'=>$ship,'stop_id'=>$stop,'status'=>1);
            $sql=$ci->db->select("id,ship_type")->where($whr)->get("tb_employee");
            if($sql->num_rows()>0){
                foreach($sql->result() as $qr){
                    $res[]= array('id'=>$qr->id,'ship_type'=>"P");
                }
            }
        }else if($ship != "" && $type=="D"){
            $whr = array('shift_id'=>$ship,'drop_stopid'=>$stop,'status'=>1);
            $sql1=$ci->db->select("id,ship_type")->where($whr)->get("tb_employee");
            if($sql1->num_rows()>0){
                foreach($sql1->result() as $qr1){
                    $res[]= array('id'=>$qr1->id,'ship_type'=>"D");
                }
            }
        }
          // log_message("error","----params----".$ship.','.$stop.','.$type.'---'.sizeof($res));
        return sizeof($res);
    }

    public function checkprvstopstatus() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : "";
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : "";
            $previous_stop = isset($_POST["previous_stop"]) ? $_POST["previous_stop"] : "";
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            if ($stop_id != "") {
                if ($previous_stop != "") {
                    $chkdet = $this->db->query(
                        "SELECT id FROM tb_stop_status WHERE shipment_id = ? AND stop_id = ? AND status_id = 1",
                        [$shift_id, $previous_stop]
                    );
                    if ($chkdet->num_rows() == 0) {
                        $response = array("status" => 1, "data" => 0);
                    } else {
                        $response = array("status" => 1, "data" => 1);
                    }
                } else {
                    $response = array("status" => 1, "data" => 1);
                }
            }
        }
        echo json_encode($response);
    }

    public function shipmentstopdetails($type = "0")
    {
        $result = array();

        if (isset($_POST)) {
            $shft_veh_id = isset($_POST["shift_veh_id"]) ? $_POST["shift_veh_id"] : '';
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
            $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
            $stop_sts = isset($_POST["stop_sts"]) ? $_POST["stop_sts"] : "N";

            if ($shft_veh_id > 0) {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $trip = ($trip == "") ? 0 : $trip;

                $where = ($type == "1") ? " AND accepted = 1 " : "";
                $query = ShipmentStopDetailsService::getStopDetailsDataV3($shift_id, $stop_id, $curtz, $where, $this->db);

                if ($query->num_rows() > 0) {
                    $k = 0;
                    $sts = 0;

                    foreach ($query->result() as $res) {
                        $allstatus['1'] = $allstatus['2'] = $allstatus['3'] = $allstatus['4'] = $allstatus['5'] = 0;
                        $status = 'N';
                        $statusid = '0';
                        $check_in = '';
                        $reason = '';

                        $whr = array('stop_id' => $res->stop_id);
                        $custname = $res->customer_name;
                        $custmobi = $res->custphone;
                        $getsts = $this->getstopstatus($whr, $curtz);

                        if (!empty($getsts)) {
                            $status = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason = $getsts['name'];
                        }

                        $stop_detail_id = $res->id;

                        if ($sts == 2) {
                            $sts = 1;
                        } else {
                            $sts = 0;
                        }

                        $anystatus = 0;
                        $has_pod = 0;

                        $chkpodsign = $this->db->query(
                            "SELECT id
                            FROM tb_pod_uploads
                            WHERE shipment_id = ? AND stop_id = ? AND stop_detail_id = ?
                            ORDER BY createdon DESC",
                            [$shift_id, $stop_id, $stop_detail_id]
                        );

                        if ($chkpodsign->num_rows() > 0) {
                            $anystatus = 1;
                            $allstatus['5'] = 1;
                            $has_pod = 1;
                        }

                        if ($trip > 0) {
                            $chk1 = $this->db->select('id,stop_type')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $res->id, 'status_id' => 3));

                            if ($chk1->num_rows() > 0) {
                                $sts = 1;

                                foreach ($chk1->result() as $cr) {
                                    if ($cr->stop_type == "D") {
                                        $chkdoc = $this->db->query(
                                            "SELECT id, doc_type
                                            FROM tb_pod_uploads
                                            WHERE doc_type IN (1, 3) AND shipment_id = ? AND stop_id = ?
                                            AND stop_detail_id = ? AND trip_id = ?",
                                            [$shift_id, $res->stop_id, $res->id, $trip]
                                        );

                                        if ($chkdoc->num_rows() > 0) {
                                            $sts = 2;
                                        }
                                    } else if ($cr->stop_type == "P") {
                                        $chk2 = $this->db->select('id')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $res->id, 'status_id' => 4));

                                        if ($chk2->num_rows() > 0) {
                                            $sts = 2;
                                        }
                                    }
                                }
                            }

                            $chk11 = $this->db->select('id,status_id')->get_where('tb_stop_status', array("shipment_id" => $shift_id, 'stop_id' => $res->stop_id, 'trip_id' => $trip, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $res->ship_type));

                            if ($chk11->num_rows() > 0) {
                                if ($sts != 2) {
                                    $sts = 1;
                                }

                                foreach ($chk11->result() as $chr) {
                                    if ($chr->status_id == 2) {
                                        $allstatus['2'] = 1;
                                    }
                                    if ($chr->status_id == 1) {
                                        $allstatus['1'] = 1;
                                    }
                                    if ($chr->status_id == 3) {
                                        $allstatus['3'] = 1;
                                    }
                                    if ($chr->status_id == 4) {
                                        $allstatus['4'] = 1;
                                    }
                                }
                            }
                        }

                        $material = ($res->material_name == "") ? $res->name : $res->material_name;
                        $drop = "";

                        if (strlen($res->drop_city) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop_city)) . " - ";
                        }

                        if (strlen($res->drop) > 0) {
                            $drop .= ucfirst(str_replace("_", " ", $res->drop));
                        }

                        $pickup = "";

                        if (strlen($res->pickup_city) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup_city)) . " - ";
                        }

                        if (strlen($res->pickup) > 0) {
                            $pickup .= ucfirst(str_replace("_", " ", $res->pickup));
                        }

                        if ($sts != 0) {
                            $k = 1;
                        }

                        $singarr = array('id' => $res->id, 'name' => $res->name, 'pickup' => $pickup . ',' . $res->pickup_address2 . ',' . $res->pickup_pincode, 'drop' => $drop . ',' . $res->delivery_address2 . ',' . $res->delivery_pincode, 'phone' => $res->phone, 'plat' => $res->plat, 'plng' => $res->plng, 'dlat' => $res->dlat, 'dlng' => $res->dlng, 'capacity' => $res->capacity, 'ship_type' => $res->ship_type, 'shipment_weight' => $res->shipment_weight, 'shipment_volume' => $res->shipment_volume, 'startdate' => strtotime($res->startdate), 'enddate' => strtotime($res->enddate), 'priority' => $res->priority, 'status' => $status, 'status_id' => $statusid, 'check_in' => $check_in, 'reason' => $reason, 'milestone' => $sts, 'exists_status' => $anystatus, 'material' => $material, 'order_id' => $res->order_id, "accepted" => $res->accepted, 'customer' => $custname, 'customerphone' => $custmobi, "allstatus" => $allstatus, "has_pod" => $has_pod, 'service_id' => $res->service_id, 'service_name' => $res->service_name, 'dg_goods' => $res->dg_goods, 'goods_description' => $res->goods_description, 'purchase_order' => $res->purchase_order, 'pickup_late_datetime' => strtotime($res->pickup_late_datetime), 'drop_late_datetime' => strtotime($res->drop_late_datetime), 'tb_orders_id' => $res->tb_orders_id, 'cargo_type' => $res->cargo_type, 'handling_unit' => $res->handling_unit, 'length' => $res->length, 'length_unit' => $res->length_unit, 'width' => $res->width, 'width_unit' => $res->width_unit, 'height' => $res->height, 'height_unit' => $res->height_unit, 'quantity' => $res->quantity, 'stackable' => $res->stackable, 'grounded' => $res->grounded, 'splittable' => $res->splittable, 'pickup_pincode' => $res->pickup_pincode, 'delivery_pincode' => $res->delivery_pincode,'cargo_id'=>$res->cargo_id,'pickup_datetime'=>strtotime($res->pickup_datetime),'drop_datetime'=>strtotime($res->drop_datetime),'tb_order_cargodetails_orderid'=>$res->tb_order_cargodetails_orderid);

                        $result[] = $singarr;
                    }

                    if ($stop_sts == "S" && $k == 1) {
                        if (count($result) > 0) {
                            $ms = array_column($result, 'milestone');
                            array_multisort($ms, SORT_DESC, $result);
                        }
                    } else if ($stop_sts == "S" && $k == 0) {
                        if (count($result) > 0) {
                            $result[0]['milestone'] = 1;
                        }
                    }

                    echo json_encode(array("status" => 1, "data" => $result));
                } else {
                    echo json_encode(array("status" => 0, "data" => "Not Found"));
                }
            } else {
                echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
            }
        } else {
            echo json_encode(array("status" => 0, "data" => "Insufficient Input Data"));
        }
    }

    public function setShipstopStatus() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {

            $data = array();
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            $latitude = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $data["trip_id"] = isset($_POST["trip_id"]) ? $_POST["trip_id"] : '';
            $shipment_id = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $stop_id = isset($_POST['stop_id']) ? $_POST["stop_id"] : '0';
            $data["employee_id"] = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_type = isset($_POST["stop_type"]) ? $_POST["stop_type"] : '';
            $driver_id = isset($_POST["driver_id"]) ? $_POST["driver_id"] : '';
            $employee_id = isset($_POST["employee_id"]) ? $_POST["employee_id"] : '';
            $stop_detail_type = isset($_POST["stop_detail_type"]) ? $_POST["stop_detail_type"] : '';
            $status_type = isset($_POST["status_type"]) ? $_POST["status_type"] : '';
            $pdfName = $fileName = "";

            $curdt = date('Y-m-d H:i:s');
            $file_upload_flag = false;
            $legsorder_id = "";
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                        'overwrite' => true,
                    );
                    $file_name = $_FILES['file_name']['name'];
                    $file = explode('.', $_FILES['file_name']['name']);
                    $file_ext = @strtolower(end($file));
                    $expensions = array("jpeg", "jpg", "png", "gif", "pdf");
                    if (in_array($file_ext, $expensions) === false) {

                    } else {
                        if ($file_ext == "pdf") {
                            $imgtype = "pdf";
                            $this->load->library('upload', $config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                            }
                        } else {
                            $fileName = date('dmyhis') . '' . $file_name;
                            $filePath = NEW_POD_PATH . $fileName;
                            $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if ($file_ext == "png") {
                                $top = imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            } else {
                                $top = imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                    $imgtype = "jpeg";
                                } else {
                                    $imgtype = $file_ext;
                                }
                            }
                            header('Content-Type: image/jpeg');
                            imagejpeg($top, $filePath, $quality);
                            imagedestroy($top);
                        }
                        if ($stop_type == "") {
                            $stop_type = "P";
                        }
                        $ordid = $uid = 0;
                        if ($stop_id != "") {
                            $chkstype = $this->db->select("stoptype")->get_where("tb_shiporder_stops", array("id" => $stop_id, "stoptype" => "D"), 1, 0);
                            if ($chkstype->num_rows() > 0) {
                                $stop_type = $chkstype->row()->stoptype;
                            }
                            $chkord = $this->db->query(
                                "SELECT id, order_id, user_id FROM tb_orders WHERE shift_id = ? LIMIT 1",
                                [$shipment_id]
                            );
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $uid = $chkord->row()->user_id;
                            }
                        }
                        $imageSize = filesize(NEW_POD_PATH.$fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = ['shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_type, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $file_upload_flag = true;
                    }
                }
            }
            if ($data["employee_id"] != "" && $data["trip_id"] != "") {
                $vehicle = $driver = 0;
                $checkintrans = $this->db->select("id,vehicle_id,driver_id")->get_where("tb_trips", array('id' => $data["trip_id"]), 1, 0);
                if ($checkintrans->num_rows() > 0) {
                    $update = $this->db->set(array('transit_status' => 1))->where(array('id' => $data["trip_id"]))->update("tb_trips");
                    $vehicle = $checkintrans->row()->vehicle_id;
                    $driver = $checkintrans->row()->driver_id;
                }
                $tdata['employee_id'] = $data['employee_id'];
                $tdata['trip_id'] = $data['trip_id'];
                $tdata['stop_id'] = $stop_id;
                $data["status"] = $status_type;
                $data["absent_reason"] = $stsreason = $data["pd_status"] = isset($_POST["status"]) ? $_POST["status"] : '';
                $data["stime"] = $data["created_on"] = $data["check_in"] = $curdt;
                $notests = 0;
                $stscode = "0420";
                if ($stsreason == 2 && $stop_type == "P") {
                    $stscode = "0420";
                    $notests = 2;
                }
                if ($stsreason == 2 && $stop_type == "D") {
                    $stscode = "0192";
                    $notests = 2;
                }
                if ($stsreason == 3 && $stop_type == "P") {
                    $stscode = "0191";
                    $notests = 3;
                }
                if ($stsreason == 3 && $stop_type == "D") {
                    $stscode = "3000";
                    $notests = 3;
                }
                if ($stsreason == 1 && $stop_type == "P") {
                    $stscode = "0500";
                    $notests = 1;
                }
                if ($stsreason == 1 && $stop_type == "D") {
                    $stscode = "2300";
                    $notests = 5;
                }
                if ($stsreason == 4) {
                    $stscode = "1550";
                    $notests = 4;
                }
                $chksts = array('shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'status' => $data["status"]);
                $checksts = $this->db->select("id")->get_where("tb_stop_status", $chksts, 1, 0);
                if ($checksts->num_rows() > 0) {
                    $updstsarr = array('latitude' => $latitude, 'longitude' => $longitude);
                    $stswhr = array('id' => $checksts->row()->id);
                    $upd = $this->db->where($stswhr)->update('tb_stop_status', $updstsarr);
                } else {
                    $data1 = array('shipment_id' => $shipment_id,'order_id'=>$ordid, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => $data["status"], 'status_code' => $stscode, "reason" => "From Mobile", 'vehicle_id' => $vehicle, 'driver_id' => $driver, 'createdon' => $curdt);
                    $insrt = $this->db->insert('tb_stop_status', $data1);
                }
                if ($legsorder_id == "") {
                    $shift = $this->db->query(
                        "SELECT order_id, user_id FROM tb_employee WHERE (stop_id = ? OR drop_stopid = ?) LIMIT 1",
                        [$stop_id, $stop_id]
                    );
                    if ($shift->num_rows() > 0) {
                        $legsorder_id = $shift->row()->order_id;
                        $uid = $shift->row()->user_id;
                    }
                }
                $cnt = $this->db->select('id')->get_where('tb_pod_uploads', array('trip_id' => $data["trip_id"]))->num_rows();
                if ($cnt == 0) {
                    $cntstr = "001";
                } else {
                    $cntstr = "00" . $cnt;
                    if ($cnt > 9) {
                        $cntstr = "0" . $cnt;
                    }
                }
                $gethrs = $this->db->query(
                    "SELECT c.cntry_hrs
                    FROM tbl_country_master c, tb_users u
                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                    LIMIT 1",
                    [$uid]
                );
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $data["trip_id"],
                    "driver_id" => $driver_id,
                    "stop_id" => $stop_id,
                    "order_id" => $legsorder_id,
                    "inc_id" => $cntstr,
                    "pod_type" => $status_type,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "stop_type" => $stop_type,
                    "vehicle_id" => $vehicle,
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );
                if ($stsreason == 8) {
                    /* $sts = $this->statusintigration->shipcollectcancel($postdata); */
                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipcollectcancel($postdata);
                } else if ($stsreason == 4) {
                    /* $sts = $this->statusintigration->shipmentintransit($postdata); */
                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmentintransit($postdata);
                } else if ($stsreason == 1) {
                    if ($stop_detail_type == "D") {
                        /* $sts = $this->statusintigration->shipmentdelivered($postdata); */
                        /* send to roadlog */
                        $sts = $this->statusintigration->roadlogshipmentdelivered($postdata);
                        if ($file_upload_flag == true) {
                            $stop = $this->db->select('txncode')->where(array("id" => $stop_id))->get("tb_shiporder_stops")->row();
                            $postdata["txn_code"] = $stop->txncode;
                            $postdata["file_name"] = $fileName; /* $pdfName; */
                            $postdata["file_type"] = isset($imgtype) ? $imgtype : 'png';
                            /* $sts = $this->statusintigration->orderrealesestatusapi($postdata); */
                            /* send to roadlog */
                            if ($status_type == '3') {
                                $sts = $this->statusintigration->roadlogorderpodstatus($postdata);
                                /* send mail to admin cc mail */
                                /* $sendnotify = $this->sendepodstatusnotifyadmin($postdata); */
                                /* send mail to specific party */
                                $sendnotify = $this->sendepodstatusnotify($postdata);
                            }
                            /* $sts = $this->statusintigration->roadlogorderrealesestatus($postdata); */
                        }
                        $stop_closed = $this->isStopUnitsPartiallyPicked($shipment_id, $stop_id);
                        if ($stop_closed) {
                            /* $sts = $this->statusintigration->shipmentdeliveredpartially($postdata); */
                            /* send to roadlog */
                            $sts = $this->statusintigration->roadlogshipmentdeliverpartial($postdata);
                        }
                    } else {
                        if ($stop_detail_type == "P") {
                            $sts = $this->statusintigration->roadlogshipmentpicked($postdata);
                        }
                    }
                } else if ($stsreason == 2) {
                    /* send to roadlog */
                    if ($stop_type == "P") {
                        $sts = $this->statusintigration->roadlogshipmentpgatein($postdata);
                    }
                    if ($stop_type == "D") {
                        $sts = $this->statusintigration->roadlogshipmentdgatein($postdata);
                    }
                } else if ($stsreason == 3) {
                    /* send to roadlog */
                    if ($stop_type == "P") {
                        $sts = $this->statusintigration->roadlogshipmentpgateout($postdata);
                    }
                    if ($stop_type == "D") {
                        /* send to epod notifymail */
                        $sts = $this->sendepodgateoutnotify($postdata);
                    }
                }
                /* Here send driver action status send to otm */
                $sql = $this->db->select("id")->get_where("tb_trip_employee", $tdata, 1, 0);
                if ($sql->num_rows() > 0) {
                    $id = $sql->row()->id;
                    if ($data["status"] == 1 && $stsreason == 1) {
                        $empdt = array('status' => 1, 'absent_reason' => 'Closed', 'pd_status' => 'Closed', 'updated_on' => $curdt);
                        $upd = $this->db->where(array('id' => $id))->update('tb_trip_employee', $empdt);
                    }
                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                } else {
                    if ($data['status'] == '1') {
                        $chkltlng = $this->checkLatLng($data["employee_id"]);
                        if ($chkltlng == "true") {
                            $lat = $latitude;
                            $lng = $longitude;
                            $svpk = $this->savePickup($data["employee_id"], $lat, $lng);
                        }
                    }
                    if (($stsreason == 1 && $data["status"] == 1) || ($data["status"] == 0)) {
                        if ($stsreason == 1) {
                            $data['absent_reason'] = 'Closed';
                        } else if ($stsreason == 0) {
                            $data['absent_reason'] = 'Cancelled';
                        }
                        $data["stop_id"] = $stop_id;
                        $res = $this->db->insert("tb_trip_employee", $data);
                        $id = $this->db->insert_id();
                        $smsdata = array();
                        if ($id > 0) {
                            $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => array(), "pickup_data" => array());
                            if ($data["status"] == 1) {
                                $result = array();
                                $result = $this->sendTripAlert($data["trip_id"], $curtz);
                                if (!empty($result)) {
                                    if (isset($result['sms_data'])) {
                                        $smsdata = $result['sms_data'];
                                    }
                                    if (isset($result['pickup_data'])) {
                                        $pickdata = $result['pickup_data'];
                                    }
                                    $response = array("status" => 1, "data" => array(array("trip_employee_id" => $id)), "sms_data" => $smsdata, "pickup_data" => $pickdata);
                                }
                            }
                            $response = array("status" => 1, "data" => "Updated Status!");
                        } else {
                            $response = array("status" => 0, "data" => "Failed to Set Shipment Status");
                        }
                    } else {
                        $response = array("status" => 1, "data" => "Updated Status!");
                    }
                }
                $sendnotify = $this->sendshipstatusnotify($postdata, $notests);
            }
        }
        echo json_encode($response);
    }

    public function sendepodgateoutnotify($postdata) {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $driver_id = $postdata['driver_id'];
        $vehicle_id = $postdata['vehicle_id'];
        $curtz = $postdata['curtz'];
        /* $order_id = "ORDER_1003291578026009";
          $ship_id = 454;
          $trip_id = 398;
          $stop_id = "";
          $driver_id = 62;
          $vehicle_id = 10825;
          $curtz = "Asia/Kolkata"; */
        $chkcust = $this->db->query(
            "SELECT o.*, c.name
            FROM tb_orders AS o, tb_customers AS c
            WHERE o.customer_id = c.id AND o.order_id = ?
            LIMIT 1",
            [$order_id]
        );
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $cust_id = $orddata['customer_id'];
            $user_id = $orddata['user_id'];
            $cust_name = $orddata['name'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            /* $mailwhr = "";
              if($company_code != ""){
              $mailwhr .= " AND company_code='".$company_code."'";
              }
              if($branch_code != ""){
              $mailwhr .= " AND branch_code='".$branch_code."'";
              } */
            $chkadminusr = $this->db->query(
                "SELECT name, emailid, cc_mails FROM tb_users WHERE id = ? AND emailid != '' LIMIT 1",
                [$user_id]
            );
            if ($chkadminusr->num_rows() > 0) {
                $this->load->library('email');
                $receivename = $chkadminusr->row()->name;
                $receivemail = $chkadminusr->row()->emailid;
                $ccmail = array();
                if ($chkadminusr->row()->cc_mails != "") {
                    $ccmail[] = $chkadminusr->row()->cc_mails;
                }
                /* $receivename = "RCREDDY";
                  $receivemail = "kambhamramachandra@gmail.com"; */
                $data['order'] = $orddata;
                $data['userid'] = $user_id;
                $epodpath = "./assets/trippods/RL" . $order_id . ".pdf";
                $data["pod"] = $this->db->query(
                    "SELECT ts.id, ts.latitude, ts.longitude,
                    ts.stop_id, ts.hash,ts.stop_type, dt.type_name, ts.createdby,
                    convertToClientTZ(ts.createdon, ?) AS createdon,
                    ts.imgpath, ts.hash, e.address, e.pickup, e.drop, e.order_id
                    FROM tb_pod_uploads AS ts
                    LEFT JOIN tb_document_types AS dt ON dt.id = ts.doc_type
                    LEFT JOIN tb_employee AS e ON e.id = ts.stop_detail_id
                    WHERE ts.shipment_id = ? AND ts.status = 1
                    GROUP BY ts.id, ts.createdon
                    ORDER BY ts.createdon ASC",
                    [$curtz, $ship_id]
                );
                $data["orderref"] = $this->db->query(
                    "SELECT GROUP_CONCAT(reference_id) AS reference_id
                    FROM tb_order_references
                    WHERE order_id = ? AND status = 1",
                    [$ordid]
                );
                $this->load->library('m_pdf');
                $sub = "svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                $data['page_title'] = "Trip ePOD";
                $data['receivemail'] = $receivemail;
                $data['receivename'] = $receivename;
                $chkref = "XSR";
                $chkordtypeqry = $this->db->query(
                    "SELECT reference_id, ref_value
                    FROM tb_order_references
                    WHERE order_id = ? AND reference_id IN ('XSR', 'SD') AND ref_value != ''
                    GROUP BY reference_id
                    HAVING COUNT(reference_id) >= 1",
                    [$ordid]
                );
                $refvalue = $newsub = "";
                $iofeof = "EOF";
                if ($chkordtypeqry->num_rows() > 1) {
                    $refs = array();
                    foreach ($chkordtypeqry->result() as $oref) {
                        $refs[] = $oref->ref_value;
                        if ($oref->reference_id = "XSR") {
                            $refvalue = $oref->ref_value;
                        }
                        if ($oref->reference_id = "SD" && $oref->ref_value == "2") {
                            $iofeof = "IOF";
                        }
                    }
                    $newsub = $refvalue . "#746#" . $iofeof;
                    $sub .= $chkref . ":" . $refvalue . "#746#" . $iofeof . "";
                    $query = $this->db->query(
                        "SELECT emailid, party_name
                        FROM tb_contact_notifys
                        WHERE status = 1 AND (pod_note = 1 OR all_note = 1)
                        GROUP BY emailid"
                    );
                    if ($query->num_rows() > 0) {
                        foreach ($query->result() as $pmails) {
                            $ccmail[] = $pmails->emailid;
                        }
                    }
                }
                if ($newsub == "") {
                    $newsub = $sub;
                }
                // log_message("error", "ePODApp " . $newsub);
                $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                $this->email->to($receivemail, $receivename);
                if (!empty($ccmail)) {
                    $ccmail = array_unique($ccmail);
                    $cc_mail = implode(", ", $ccmail);
                    $cc_mail = '"' . $cc_mail . '"';
                    $this->email->cc($cc_mail);
                }
                /* $this->email->bcc('kambhamramachandra@gmail.com', 'RCREDDY K'); */
                $this->email->subject($newsub);
                $this->email->set_mailtype("html");
                $data['mailtype'] = "ePOD";
                $stops = GetStopstatuses::getStopstatuses($curtz, $ship_id, $this->db);
                [$dataStops, $dataPickupDatetime, $dataDeliveryDatetime] = ProcessStopstatuses::processStopstatuses($stops);
                $data['stops'] = $dataStops;
                $data['pickup_datetime'] = $dataPickupDatetime;
                $data['delivery_datetime'] = $dataDeliveryDatetime;
                $html = $this->load->view('settings/bulkepod', $data, true);
                $chk = $this->m_pdf->pdf->WriteHTML($html);
                $chk = $this->m_pdf->pdf->Output($epodpath, "F");
                $body = $this->load->view('mail_forms/deliveredshipment', $data, true);
                $unique_id = "RL" . $order_id . "." . date("Ymd") . "." . date("his");
                $pagescnt = $this->m_pdf->pdf->pages;
                $pages = count($pagescnt);
                $jplData = array("country" => substr($company_code, 0, -2), "branch" => substr($branch_code, 2), "order_id" => $order_id, "time" => date("hi"), "unique_id" => $unique_id, "date" => date("d.m.Y"), "pages" => $pages);
                $jplFilePath = $this->saveJPF($jplData);
                $storeftipjpl = $this->uploadKNFile($jplFilePath);
                $storeftippdf = $this->uploadKNFile($epodpath);
                $this->email->message($body);
                $this->email->attach($epodpath);
            }
        }
    }

    public function saveJPF($jplData) {
        $content = $this->load->view("jpl_template", $jplData, TRUE);
        $order_id = $jplData["order_id"];
        $file_path = "./assets/jpl_files/RL$order_id.jpl";
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    public function uploadKNFile($localfile) {
        $remotefile = basename($localfile);
        /* log_message("error","$remotefile file uploaded to KN FTP"); */
        $ftp = ftp_connect(KN_FTP_URL) or die("Could not connect");
        ftp_login($ftp, KN_FTP_USER, KN_FTP_PASSWORD) or die("invalid username or password");
        $ret = @ftp_nb_put($ftp, "./pub/inbound/$remotefile", $localfile, FTP_BINARY, FTP_AUTORESUME);
        while (FTP_MOREDATA == $ret) {
            /* display progress bar, or someting */
            $ret = ftp_nb_continue($ftp);
        }
        ftp_close($ftp);
    }

    public function sendshipstatusnotify($postdata, $sts) {
        $ord_id = $postdata['order_id'];
        $chkcust = $this->db->query(
            "SELECT o.customer_id, o.user_id, c.name, c.gcm_id, c.company_code, c.branch_code
            FROM tb_orders AS o, tb_customers AS c
            WHERE o.customer_id = c.id AND o.order_id = ? AND c.gcm_id != ''
            LIMIT 1",
            [$ord_id]
        );
        if ($chkcust->num_rows() > 0) {
            $cust_id = $chkcust->row()->customer_id;
            $user_id = $chkcust->row()->user_id;
            $cust_name = $chkcust->row()->name;
            $company_code = $chkcust->row()->company_code;
            $branch_code = $chkcust->row()->branch_code;
            $chksend = $this->db->query(
                "SELECT id, status_name
                FROM tb_customer_status
                WHERE customer_id = ? AND status_id = ? AND company_code = ? AND branch_code = ? AND status = 1
                LIMIT 1",
                [$cust_id, $sts, $company_code, $branch_code]
            );
            if ($chksend->num_rows() > 0) {
                $sts_name = $chksend->row()->status_name;
                $ship_id = $postdata['shipment_id'];
                $trip_id = $postdata['trip_id'];
                $stop_id = $postdata['stop_id'];
                $stopdetailsid = 0;
                $notifydata = array();
                $stopdetails = $this->db->query(
                    "SELECT id FROM tb_employee WHERE (stop_id = ? OR drop_stopid = ?) AND shift_id = ? LIMIT 1",
                    [$stop_id, $stop_id, $ship_id]
                );
                if ($stopdetails->num_rows() > 0) {
                    $stopdetailsid = $stopdetails->row()->id;
                }
                if ($sts == 1) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 2) {
                    $stsmsg = $sts_name . " for Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " for Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 3) {
                    $stsmsg = $sts_name . " from Pickup";
                    if ($postdata['stop_type'] == "D") {
                        $stsmsg = $sts_name . " from Delivery";
                    }
                    $message = "Dear " . $cust_name . ", Driver updated the " . $stsmsg . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 4) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 5) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                } else if ($sts == 6) {
                    $message = "Dear " . $cust_name . ", Driver updated the " . $sts_name . " status on your order " . $ord_id . "";
                    $notifydata = array("title" => "Driver Status Update", "message" => $message, "emp_id" => $stopdetailsid, 'type' => 'Customer', "shipment_id" => $ship_id, "trip_id" => $trip_id, "stop_id" => $stop_id, "user_id" => $cust_id, "status_id" => $sts, "msg_status" => 0);
                }
                $fire_ret = @$this->sendfirebase->sendSingleOrderPush($notifydata);
                /* log_message("error","push note resp".json_encode($fire_ret)); */
            }
        }
    }

    public function sendepodstatusnotify($postdata) {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $fileName = $postdata['file_name'];
        $chkcust = $this->db->query(
            "SELECT o.*, c.name FROM tb_orders AS o, tb_customers AS c WHERE o.customer_id = c.id AND o.order_id = ? LIMIT 1",
            [$order_id]
        );
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $cust_id = $orddata['customer_id'];
            $user_id = $orddata['user_id'];
            $cust_name = $orddata['name'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            /* $mailwhr = "";
              if($company_code != ""){
              $mailwhr .= " AND company_code='".$company_code."'";
              }
              if($branch_code != ""){
              $mailwhr .= " AND branch_code='".$branch_code."'";
              } */
            $chkref = "XSR";
            $chkordtypeqry = $this->db->query(
                "SELECT reference_id, ref_value
                FROM tb_order_references
                WHERE order_id = ? AND reference_id IN ('XSR', 'SD') AND ref_value != ''
                GROUP BY reference_id
                HAVING COUNT(reference_id) >= 1",
                [$ordid]
            );
            $refval = $refvalue = "";
            $iofeof = "EOF";
            if ($chkordtypeqry->num_rows() > 1) {
                /* $nums = $refs = array(); */
                foreach ($chkordtypeqry->result() as $oref) {
                    /* $nums[] = $oref->reference_id;
                      $refs[] = $oref->ref_value; */
                    if ($oref->reference_id = "XSR") {
                        $refvalue = $oref->ref_value;
                    }
                    if ($oref->reference_id = "SD" && $oref->ref_value == "2") {
                        $iofeof = "IOF";
                    }
                }
                /* if(!empty($nums)){
                  $reference = implode("','", $nums);
                  $refval = implode("','", $refs);
                  $mailwhr .= " AND ref_type IN('".$reference."')";
                  } */
                /* $mailwhr */
                $query = $this->db->query(
                    "SELECT party_id, partycontact_id, customer_id, email_note, emailid, party_name
                    FROM tb_contact_notifys
                    WHERE status = 1 AND (pod_note = 1 OR all_note = 1)
                    GROUP BY emailid"
                );
                if ($query->num_rows() > 0) {
                    $this->load->library('email');
                    foreach ($query->result() as $pmails) {
                        $receivename = $pmails->party_name;
                        $receivemail = $pmails->emailid;
                        $data['order'] = $orddata;
                        $data['page_title'] = "Booking ePOD";
                        $data['receivemail'] = $receivemail;
                        $data['receivename'] = $receivename;
                        /* $sub = "svkonekt::Booking ePOD ".$chkref.":".$refvalue."#746#".$iofeof); */
                        $sub = $refvalue . "#746#" . $iofeof;
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);
                        /* $this->email->bcc('kambhamramachandra@gmail.com', 'RCREDDY K'); */
                        $this->email->subject($sub);
                        $this->email->set_mailtype("html");
                        $body = $this->load->view('mail_forms/bookepod', $data, true);
                        $this->email->message($body);
                        $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                        $this->email->attach($epodpath);
                    }
                }
            }
        }
    }

    public function sendepodstatusnotifyadmin($postdata) {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $fileName = $postdata['file_name'];
        $chkcust = $this->db->query(
            "SELECT * FROM tb_orders WHERE order_id = ? LIMIT 1",
            [$order_id]
        );
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $user_id = $orddata['user_id'];
            $getusermail = $this->db->select("name,company_code,cc_mails")->get_where("tb_users", array("id" => $user_id, "status" => "Active", "cc_mails !=" => ""), 1, 0);
            if ($getusermail->num_rows() > 0) {
                $cmpcode = $getusermail->row()->company_code;
                if ($cmpcode == "SGKN" || $cmpcode == "MYKN") {
                    $receivemail = $getusermail->row()->cc_mails;
                    $receivename = $getusermail->row()->name;
                    $this->load->library('email');
                    $data['order'] = $orddata;
                    $data['page_title'] = "Booking ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->to($receivemail, $receivename);
                    /* $this->email->bcc('kambhamramachandra@gmail.com', 'RCREDDY K'); */
                    $this->email->subject("svkonekt::Booking ePOD for #" . $order_id);
                    $this->email->set_mailtype("html");
                    $body = $this->load->view('mail_forms/bookepod', $data, true);
                    $this->email->message($body);
                    $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                    $this->email->attach($epodpath);
                }
            }
        }
    }

    public function isStopUnitsPartiallyPicked($shipment_id = '', $stop_id = '') {
        if ($stop_id != "") {
            $driver_entered = $this->db->query(
                "SELECT ship_units FROM tb_shiporder_stops WHERE id = ?",
                [$stop_id]
            )->row()->ship_units;
            if (strlen($driver_entered) > 0) {
                $total_units = 0;
                $sdet = $this->db->query(
                    "SELECT no_of_pkgs FROM tb_employee WHERE (stop_id = ? OR drop_stopid = ?) AND status = 1",
                    [$stop_id, $stop_id]
                );
                if ($sdet->num_rows() > 0) {
                    foreach ($sdet->result() as $row) {
                        $total_units += $row->no_of_pkgs;
                    }
                }
                if ($total_units != $driver_entered) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return true;
            }
        } else {
            if ($shipment_id != "") {
                $stops = $this->db->query(
                    "SELECT id FROM tb_shiporder_stops WHERE shipment_id = ?",
                    [$shipment_id]
                );
                $total_units = $driver_entered_total = 0;
                foreach ($stops->result() as $stop) {
                    $stop_id = $stop->id;
                    if ($stop_id != "") {
                        $driver_entered = $this->db->query(
                            "SELECT ship_units FROM tb_shiporder_stops WHERE id = ?",
                            [$stop_id]
                        )->row()->ship_units;
                        if (strlen($driver_entered) > 0) {
                            $driver_entered_total += $driver_entered;
                            $total_units = 0;
                            $sdet = $this->db->query(
                                "SELECT no_of_pkgs FROM tb_employee WHERE (stop_id = ? OR drop_stopid = ?) AND status = 1",
                                [$stop_id, $stop_id]);
                            if ($sdet->num_rows() > 0) {
                                foreach ($sdet->result() as $row) {
                                    $total_units += $row->no_of_pkgs;
                                }
                            }
                        } else {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                if ($total_units != $driver_entered_total) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

    public function getshipstatuses() {
//        trip_id,shipment_id,stop_id,stop_details_id,timezone
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data1 = array();
            $status = 0;
            // log_message('error', "ship_status " . json_encode($_POST));
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
            $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            if ($trip_id != "") {
                $sq["trip_id"] = $trip_id;
                /* if ($data["trip_id"] != "") {
                  $sq["trip_id"] = $data["trip_id"];
                  }else{
                  $sq["shipment_id"] = $shipment_id;
                  } */
                if ($stop_id != null) {
                    $sq["stop_id"] = $stop_id;
                }
                if ($stop_detail_id != null) {
                    $sq["stop_detail_id"] = $stop_detail_id;
                }
                /* $sq["doc_type"] = 1; */
                $sign_sign = $this->db->select('id')->get_where('tb_pod_uploads', $sq, 1, 0);
                if ($sign_sign->num_rows() > 0) {
                    /* $sq["doc_type"] = 3; */
                    $status = 1;
                }
                $ww = '';
                if ($stop_id != null) {
                    $escapedStopId = $this->db->escape($stop_id);
                    $ww = " AND s.stop_id= {$escapedStopId} ";
                }
                if ($stop_detail_id != null) {
                    $escapedStopDetailId = $this->db->escape($stop_detail_id);
                    $ww .= " AND s.stop_detail_id = {$escapedStopDetailId} ";
                }
                if ($sq["trip_id"] != "") {
                    $escapedTripId = $this->db->escape($sq['trip_id']);
                    $ww .= " AND s.trip_id = {$escapedTripId} ";
                } else {
                    if ($shipment_id != "") {
                        $sq["shipment_id"] = $shipment_id;
                        $escapedShipmentId = $this->db->escape($sq['shipment_id']);
                        $ww .= " AND s.shipment_id = {$escapedShipmentId} ";
                    }
                }
                $qry = $this->db->query(
                    "SELECT s.latitude, s.longitude,
                    convertToClientTZ(s.createdon, ?) AS createdon, m.status_name
                    FROM tb_stop_status AS s, tb_status_master AS m
                    WHERE s.status_id = m.id {$ww}",
                    [$curtz]
                );
                $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $placename = getLocationName($res->latitude, $res->longitude);
                        $data1[] = array('status_name' => $res->status_name, 'place' => $placename, 'createdon' => strtotime($res->createdon));
                    }
                    $response = array("status" => 1, "data" => $data1, 'docstatus' => $status);
                }
            }
        }
        echo json_encode($response);
    }

    function getDeviationList() {
        $response = array("status" => 0, "data" => array());
        if(isset($_POST)){
                $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : null;
                $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : null;
                $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
                $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
                $where = '';
                if ($trip_id != null) {
                    $escapedTripId = $this->db->escape($trip_id);
                    $where .= " AND trip_id = {$escapedTripId} ";
                }

                if ($shipment_id != null) {
                    $escapedShipmentId = $this->db->escape($shipment_id);
                    $where .= " AND shift_id = {$escapedShipmentId} ";
                }

                if ($stop_detail_id != null) {
                    // $escapedStopDetailId = $this->db->escape($stop_detail_id);
                    // $where .= " AND stop_detail_id = {$escapedStopDetailId} ";
                }

                if ($stop_id != null) {
                    // $escapedStopId = $this->db->escape($stop_id);
                    // $where .= " AND stop_id = {$escapedStopId} ";
                }

                $qry = $this->db->query(
                    "SELECT status_type, reason, comment, image_path FROM tb_deviations_details WHERE status = 1 {$where}"
                );
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result_array() as $res) {
                        $status_type = $res['status_type'];
                        $reason = $res['reason'];
                        $comment = $res['comment'];
                        $res['image_path'] = base_url() . "assets/deviationuploads/".$res['image_path'];
                        $data1[] = $res;
                    }
                    $response = array("status" => 1, "data" => $data1);
                }
                echo json_encode($response);
                return;
        }
        echo json_encode($response);
    }

    public function setShipReject() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $order_rowid = 0;
            $post = json_decode($_POST['data']);
            $data = array();
            /* log_message('error', "shipreject " . json_encode($_POST)); */
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
            $trip_id = isset($post->trip_id) ? $post->trip_id : 0;
            $latitude = isset($post->latitude) ? $post->latitude : '';
            $longitude = isset($post->longitude) ? $post->longitude : '';
            $reason = isset($post->reason) ? $post->reason : '';
            $type = isset($post->type) ? $post->type : '1';
            $vehicle_id = isset($post->vehicle_id) ? $post->vehicle_id : '';
            $driver_id = isset($post->driver_id) ? $post->driver_id : '';
            $shipment_id = isset($post->shipment_id) ? $post->shipment_id : '';
            $status = 6;
            $statuscode = "0213";
            if ($shipment_id != "" && $driver_id > 0) {
                if ($type == '1') {
                    /* type 1 will never come, because this operation is heppen before trip starts only */
                    $chktrip = $this->db->select('id')->get_where('tb_trips', array('id' => $trip_id, 'status !=' => 0));
                    if ($chktrip->num_rows() > 0) {
                        $whr = array('id' => $trip_id);
                        $set = array('status' => 2, 'updated_on' => $curdt);
                        $upd = $this->db->set($set)->where($whr)->update('tb_trips');
                    }
                    $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
                }
                if ($type == '0') {
                    if ($trip_id == "") {
                        $trip_id = 0;
                    }
                    $addstatus = array('shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt);
                }
                $upd = $this->db->where(array("shft_id" => $shipment_id))->update("tb_shft_veh", array("status" => "0"));
                $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->get_where("tb_employee", array("shift_id" => $shipment_id, 'ship_type' => 'P'), 1, 0);
                if ($shift->num_rows() > 0) {
                    $ordid = $shift->row()->order_id;
                    $uid = $shift->row()->user_id;
                    $getorder_rowid = gettblrowdata(array('order_id'=>$ordid,'user_id'=>$uid),'id','tb_orders',0,0);
                    if(!empty($getorder_rowid)){
                        $order_rowid= $getorder_rowid['id'];
                    }
                    $addstatus['order_id'] = $order_rowid;
                    $gethrs = $this->db->query(
                        "SELECT c.cntry_hrs
                        FROM tbl_country_master AS c, tb_users AS u
                        WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                        LIMIT 1",
                        [$uid]
                    );
                    $hrs = $gethrs->row()->cntry_hrs;
                    $postdata = array(
                        "shipment_id" => $shipment_id,
                        "trip_id" => $trip_id,
                        "driver_id" => $driver_id,
                        "stop_id" => "",
                        "order_id" => $ordid,
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "curtz" => $curtz,
                        "hrs" => $hrs
                    );
                    /* $sts = $this->statusintigration->shipmentreject($postdata); */
                    /* send to roadlog */
                    $sts = $this->statusintigration->roadlogshipmentreject($postdata);
                    $qry = $this->db->insert('tb_stop_status', $addstatus);
                }
                $response = array("status" => 1, "data" => "Updated");
            }
        }
        echo json_encode($response);
    }

    public function setshipAbort() {
        // log_message("error", '--setshipAbort--' . json_encode($_POST));
        // log_message("error", '--setshipAbort FILES--' . json_encode($_FILES));
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        if (isset($_POST)) {
            $data = array();
            /* log_message('error', "setshipAbort ".json_encode($_POST)); */
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
            $latitude = isset($_POST['latitude']) ? $_POST["latitude"] : '';
            $longitude = isset($_POST['longitude']) ? $_POST["longitude"] : '';
            $shipment_id = isset($_POST['shipment_id']) ? $_POST["shipment_id"] : '0';
            $trip_id = isset($_POST['trip_id']) ? $_POST["trip_id"] : 0;
            $driver_id = isset($_POST['driver_id']) ? $_POST["driver_id"] : '0';
            $vehicle_id = isset($_POST['vehicle_id']) ? $_POST["vehicle_id"] : '0';
            $reason = isset($_POST['reason']) ? $_POST["reason"] : '';
            $pdfName = $fileName = "";
            $ordid = $podinsid = 0;
            $legsorder_id = "";
            $uid = 5;
            if (isset($_FILES)) {
                if (isset($_FILES['photo']['name'])) {
                    $config = array(
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => 'jpg|gif|png|pdf',
                        'overwrite' => true,
                    );
                    $this->load->library('upload', $config);
                    if ($this->upload->do_upload('photo')) {
                        $imgname = $this->upload->data();
                        $fileName = $imgname['file_name'];
                        $chkord = $this->db->query(
                            "SELECT id, order_id, user_id FROM tb_orders WHERE shift_id = ? LIMIT 1",
                            [$shipment_id]
                        );
                        if ($chkord->num_rows() > 0) {
                            $ordid = $chkord->row()->id;
                            $legsorder_id = $chkord->row()->order_id;
                            $uid = $chkord->row()->user_id;
                        }
                        $imageSize = filesize(NEW_POD_PATH.$fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = ['trip_id' => $trip_id, 'shipment_id' => $shipment_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 3, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                        $res = $this->db->insert("tb_pod_uploads", $filedata);
                        $podinsid = $this->db->insert_id();
                    }
                }
            }
            if ($ordid == 0) {
                $chkord = $this->db->query(
                    "SELECT id, order_id, user_id FROM tb_orders WHERE shift_id = ? LIMIT 1",
                    [$shipment_id]);
                if ($chkord->num_rows() > 0) {
                    $ordid = $chkord->row()->id;
                    $legsorder_id = $chkord->row()->order_id;
                    $uid = $chkord->row()->user_id;
                    if ($podinsid > 0) {
                        $upd = $this->db->where(array("id" => $podinsid))->update("tb_pod_uploads", array("order_id" => $ordid));
                    }
                }
            }
            if ($ordid > 0) {
                $gethrs = $this->db->query(
                    "SELECT c.cntry_hrs
                    FROM tbl_country_master AS c, tb_users AS u
                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                    LIMIT 1",
                    [$uid]
                );
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $trip_id,
                    "driver_id" => $driver_id,
                    "stop_id" => "",
                    "order_id" => $legsorder_id,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );
                /* $sts = $this->statusintigration->shipmentabort($postdata); */
                /* send to roadlog */
                $sts = $this->statusintigration->roadlogshipmentabort($postdata);
                $statuscode = "0217";
                $addstatus = array('shipment_id' => $shipment_id,'order_id'=>$ordid, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => 6, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 1, 'createdon' => $curdt);
                $qry = $this->db->insert('tb_stop_status', $addstatus);

                if ($qry) {
                    $this->db->where('id', $shipment_id)->limit(1);
                    $this->db->update('tb_shifts', ['aborted' => 1]);
                }
            }
            $response = array("status" => 1, "data" => "Updated");
        }
        echo json_encode($response);
    }

    public function rescheduleShift() {
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $shift_id = isset($post->shift_id) ? $post->shift_id : "";
            $vehicle_id = isset($post->vehicle_id) ? $post->vehicle_id : "";
            $trip_type = isset($post->trip_type) ? $post->trip_type : "";
            $driver_id = isset($post->driver_id) ? $post->driver_id : "";
            $imei = isset($post->imei) ? $post->imei : "";
            $user_id = isset($post->user_id) ? $post->user_id : "";
            $splace = isset($post->splace) ? $post->splace : "";
            $eplace = isset($post->eplace) ? $post->eplace : "";
            $reschedule_date = isset($post->reschedule_date) ? $post->reschedule_date : "";
            $reason = isset($post->reason) ? $post->reason : "";
            $check = isset($post->check) ? $post->check : "";
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            if (strlen($reschedule_date) > 0 && strlen($shift_id) > 0 && strlen($vehicle_id) > 0 && strlen($user_id) > 0) {
                $vendor = $this->db->query(
                    "SELECT v.email
                    FROM tb_trucks_data AS vv
                    LEFT JOIN tb_vendors AS v ON v.id = vv.vendor_id
                    WHERE vv.status = 'Active' AND vv.id = ? AND v.email != ''",
                    [$vehicle_id]
                );
                $user = $this->db->query(
                    "SELECT name, emailid FROM tb_users WHERE id = ?",
                    [$user_id]
                )->row();
                $driver = $this->db->query(
                    "SELECT name, contact_num FROM tb_truck_drivers WHERE id = ?",
                    [$driver_id]
                )->row();
                $escapedCurtz = $this->db->escape($curtz);
                $shift = $this->db->select("convertToClientTZ(startdate, {$escapedCurtz}) AS startdate, shipmentid")->where(array("id" => $shift_id))->get("tb_shifts")->row();
                $this->load->library('email');
                $this->email->from("svkonekt@kuehne-nagel.com", "svkonekt");
                if ($vendor->num_rows() > 0) {
                    $this->email->to($vendor->email, $vendor->name);
                }
                if (strlen($user->emailid) > 0) {
                    $this->email->cc($user->emailid, $user->name);
                }
                $this->email->subject('Shipment reschedule requested');
                $this->email->set_mailtype('html');
                $this->email->message("
                    Hi,<br><br>
                    Your shipment is reschedule request by driver<br><br>
                    <table style=\"border: 1px solid #f4f4f4;width: 100%;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Shipment Id</th>
                            <th>Start Place</th>
                            <th>End Place</th>
                            <th>All materials are swapped in good condition</th>
                            <th>Actual Date</th>
                            <th>Re-scheduling Date</th>
                            <th>Re-scheduling reason</th>
                        </tr>
                        <tr>
                            <td>" . $shift->shipmentid . "</td>
                            <td>" . $splace . "</td>
                            <td>" . $eplace . "</td>
                            <td>" . $check . "</td>
                            <td>" . $shift->startdate . "</td>
                            <td>" . $reschedule_date . "</td>
                            <td>" . $reason . "</td>
                        </tr>
                    </tbody></table><br>
                    Driver Details:<br>
                    <table style=\"border: 1px solid #f4f4f4;\">
                        <tbody><tr style=\"background-color: gray;color: white;\">
                            <th>Driver</th>
                            <th>Mobile</th>
                        </tr>
                        <tr>
                            <td>" . $driver->name . "</td>
                            <td>" . $driver->contact_num . "</td>
                        </tr>
                    </tbody></table><br>
                    <a href='" . base_url() . "' target='_blank' title='Click here to Accept/Reject this request'>Click here</a> to Accept/Reject this request<br><br>
                    Thanks,<br>
                    Support Team,<br>
                    Svkonekt.
                ");
                $sendmail = $this->email->send();
                /* $smsObj  = new sendsms("alerts.sinfini.com/api/", "115948kz7517216zm1sl", "RTRUCK");
                  $message = "Your shipment-" . $shift->shipmentid . " is reschedule request by driver,please check " . base_url() . "";
                  $res = $smsObj->send_sms("9052440146", $message, SITEURL, "xml"); */
                echo json_encode(array("status" => "1", "message" => "Status updated sucessfully!"));
            } else {
                echo json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
            }
        } else {
            echo json_encode(array("status" => "0", "message" => "Invalid input parameters!"));
        }
    }

    public function stopdetailsaccept() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post = array();
        if (isset($_POST)) {
            /* log_message('error', "stopdetailsaccept " . json_encode($_POST)); */
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            $post = $_POST;
            $latitude = isset($post["latitude"]) ? $post["latitude"] : '';
            $longitude = isset($post["longitude"]) ? $post["longitude"] : '';
            $shipment_stop_details = isset($post["shipment_stop_details"]) ? $post["shipment_stop_details"] : '';
            $shift_veh_id = isset($post["shift_veh_id"]) ? $post["shift_veh_id"] : '';
            $shift_id = isset($post["shift_id"]) ? $post["shift_id"] : '';
            $stop_id = isset($post["stop_id"]) ? $post["stop_id"] : '';
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : '';
            $trip_id = isset($post["trip_id"]) ? $post["trip_id"] : '';
            if ($shift_id != "" && $driver_id != "") {
                $aa = json_decode($shipment_stop_details);
                $sql = $this->db->query(
                    "UPDATE tb_employee SET accepted = 0 WHERE shift_id = ? AND status = 1 AND stop_id = ?",
                    [$shift_id, $stop_id]
                );
                foreach ($aa as $stop_detail_id) {
                    $upd = $this->db->query(
                        "UPDATE tb_employee SET accepted = 1 WHERE id = ?",
                        [$stop_detail_id]
                    );
                }
                $trip = $this->db->query(
                    "SELECT id FROM tb_trips WHERE shift_id = ? AND status = 1",
                    [$shift_id]
                );
                $trip_id = null;
                if ($trip->num_rows() > 0) {
                    $trip_id = $trip->row()->id;
                }
                if ($trip_id != null) {
                    $del = $this->db->query(
                        "DELETE FROM tb_trip_employee WHERE trip_id = ?",
                        [$trip_id]
                    );
                    $emp = $this->db->query(
                        "SELECT e.id, stop_id
                        FROM tb_employee AS e
                        JOIN tb_shft_veh_emp AS sve ON sve.emp_id = e.id AND sve.status = 1
                        JOIN tb_shft_veh AS sv ON sv.id = sve.shft_veh_id AND sv.status = 1
                        JOIN tb_shifts AS s ON s.id = sv.shft_id AND s.status = 1
                        WHERE (e.accepted IS NULL OR e.accepted = '' OR e.accepted = 0) AND s.id = ?",
                        [$shift_id]
                    );
                    foreach ($emp->result() as $row1) {
                        $te["trip_id"] = $trip_id;
                        $te["stop_id"] = $row1->stop_id;
                        $te["employee_id"] = $row1->id;
                        $te["status"] = "0";
                        $te["absent_reason"] = "Driver Rejected";
                        $this->db->insert("tb_trip_employee", $te);
                    }
                }
                $stps = $this->db->select('id')->where(array("shipment_id" => $shift_id, "status" => "1"))->get("tb_shiporder_stops");
                $uid = "";
                $hrs = "Z";
                foreach ($stps->result() as $row) {
                    $stp_id = $row->id;
                    $shift = $this->db->query(
                        "SELECT user_id, order_id
                        FROM tb_employee
                        WHERE shift_id = ? AND (stop_id = ? OR drop_stopid = ?) AND status = 1",
                        [$shift_id, $stp_id, $stp_id]
                    );
                    $numrws = $shift->num_rows();
                    if ($numrws > 0) {
                        $ordid = $shift->row()->order_id;
                        if ($uid == "") {
                            $uid = $shift->row()->user_id;
                            $gethrs = $this->db->query(
                                "SELECT c.cntry_hrs
                                FROM tbl_country_master AS c, tb_users AS u
                                WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                                LIMIT 1",
                                [$uid]
                            );
                            $hrs = $gethrs->row()->cntry_hrs;
                        }
                        $postdata = array(
                            "shipment_id" => $shift_id,
                            "trip_id" => $trip_id,
                            "driver_id" => $driver_id,
                            "stop_id" => $stp_id,
                            "order_id" => $ordid,
                            "latitude" => $latitude,
                            "longitude" => $longitude,
                            "curtz" => $curtz,
                            "hrs" => $hrs
                        );
                        $act_det = $this->db->select('id')->where(array("shift_id" => $shift_id, "status" => "1", "accepted" => "1"))->where("(stop_id = $stp_id or drop_stopid = $stp_id)")->get("tb_employee");
                        if ($numrws == $act_det->num_rows()) {
                            /* $sts = $this->statusintigration->shipmentcollected($postdata); */
                            /* send to roadlog */
                            $sts = $this->statusintigration->roadlogshipmentcollected($postdata);
                        } else {
                            $act_det = $this->db->select('id')->where(array("shift_id" => $shift_id, "stop_id" => $stp_id, "status" => "1", "accepted" => "0"))->get("tb_employee");
                            if ($numrws == $act_det->num_rows()) {
                                /* $sts = $this->statusintigration->shipnotcollected($postdata); */
                                /* send to roadlog */
                                $sts = $this->statusintigration->roadlogshipnotcollected($postdata);
                            }
                        }
                    }
                }
            }
        }
        $response = array("status" => 1, "data" => $post);
        echo json_encode($response);
    }

    public function getvehicledrivers() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post = array();
        if (isset($_POST)) {
            $data = array();
            $post = $_POST;
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            if ($vehicle_id != "") {
                $query = $this->db->query(
                    "SELECT d.id, d.name, d.contact_num
                    FROM tb_vehicles_drivers AS v, tb_truck_drivers AS d
                    WHERE v.driver_id = d.id AND d.status = 'Active' AND v.status = 1
                    AND v.vehicle_id = ? AND v.driver_id != ?",
                    [$vehicle_id, $driver_id]
                );
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $data[] = array('id' => $res->id, 'name' => $res->name, 'mobile' => $res->contact_num);
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    public function assigndriver() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post = array();

        if (isset($_POST)) {
            $post = $_POST;
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            $assigdriver = isset($post["assigned_driver_id"]) ? $post["assigned_driver_id"] : 0;
            $trip_id = isset($post["trip_id"]) ? $post["trip_id"] : 0;
            /* $logdate = date('Y-m-d H:i:s');
              $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
            if ($assigdriver != 0 && strlen($assigdriver) > 0) {
                $driver = $this->db->select('name,contact_num,user_id')->get_where("tb_truck_drivers", array("id" => $assigdriver), 1, 0);
                if ($driver->num_rows() > 0) {
                    $name = $driver->row()->name;
                    $mobile_no = $driver->row()->contact_num;
                    $imei = '';
                    $user_id = $driver->row()->user_id;
                    if ($user_id != 0 && strlen($user_id) > 0) {
                        /* update trip driver */
                        $upd = $this->db->where(array("id" => $trip_id))->update("tb_trips", array("driver_id" => $assigdriver));
                        $ins = $this->db->insert("tb_trip_drivers", array("driver_id" => $assigdriver, "trip_id" => $trip_id, "imei" => $imei, "createdon" => $curdt));
                        $assigned = $this->db->where(array("vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "status" => "1"))->update("tbl_assigned_drivers", array("status" => 0));
                        $chk = $this->db->select('id')->get_where('tbl_assigned_drivers', array("vehicle_id" => $vehicle_id, "driver_id" => $assigdriver), 1, 0);
                        if ($chk->num_rows() > 0) {
                            $existid = $chk->row()->id;
                            $ins = $this->db->where(array("id" => $existid))->update("tbl_assigned_drivers", array("imei" => $imei, "user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "from_time" => $curdt, "to_time" => $curdt));
                        } else {
                            $ins = $this->db->insert("tbl_assigned_drivers", array("vehicle_id" => $vehicle_id, "driver_id" => $assigdriver, "imei" => $imei, "user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "created_on" => $curdt, "from_time" => $curdt, "to_time" => $curdt));
                        }
                        $veh = $this->db->select('register_number')->get_where('tb_trucks_data', array('id' => $vehicle_id), 1, 0)->row()->register_number;
                        $message = "Dear " . $name . ",You are assigned to " . $veh . ", please login to do the shipping";
                        $notifydata = array("title" => "Change Driver To Trip", "message" => $message, "emp_id" => $assigdriver, 'type' => 'Driver');
                        $fire_ret = @$this->sendfirebase->sendSinglePush($notifydata);
                        $response = array("status" => 1, "data" => []);
                    } else {
                        $response = array("status" => 0, "data" => []);
                    }
                } else {
                    $response = array("status" => 0, "data" => []);
                }
            } else {
                $response = array("status" => 0, "data" => []);
            }
        } else {
            $response = array("status" => 0, "data" => []);
        }
        echo json_encode($response);
    }

    public function getpickupshipunit() {
        $response = array("status" => 0, "data" => "Insufficient Input Data");
        $post = array();
        if (isset($_POST)) {
            $data = array();
            /* log_message('error', "getpickupshipunit " . json_encode($_POST)); */
            $post = $_POST;
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            $trip_id = isset($post["trip_id"]) ? $post["trip_id"] : 0;
            $shift_id = isset($post["shift_id"]) ? $post["shift_id"] : 0;
            $stop_id = isset($post["stop_id"]) ? $post["stop_id"] : 0;
            $ship_units = isset($post["ship_units"]) ? $post["ship_units"] : 0;
            if ($trip_id != "" && $stop_id != "") {
                $upd = $this->db->where(array("shipment_id" => $shift_id, "id" => $stop_id))->update("tb_shiporder_stops", array("ship_units" => $ship_units));
                $response = array("status" => 1, "data" => $post);
            }
        }
        echo json_encode($response);
    }

    public function setdriverfeedback() {
        $response = array("status" => 0, "data" => "Something went wrong!");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
        $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
        $feedback = isset($_POST['feedback']) ? $_POST['feedback'] : '';
        $rating = isset($_POST['rating']) ? $_POST['rating'] : 3;
        /* $logdate = date('Y-m-d H:i:s');
          $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
        $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
        /* log_message('error', " setdriverfeedback data " . json_encode($_POST)); */
        if ($driver_id != "" && $feedback != "") {
            $arr = array('trip_id' => $trip_id, 'ship_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_id, 'noted_by' => $driver_id, 'user_type' => 0, 'feedback' => $feedback, 'feedback_type' => $rating, 'status' => 1, 'created_on' => $curdt);
            $ins = $this->db->insert("tb_trip_feebacks", $arr);
            $response = array("status" => 1, "data" => "Success");
        }
        echo json_encode($response);
    }

    public function uploadcostomes() {
        $response = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
            $latitude = isset($_POST['latitude']) ? $_POST['latitude'] : 0;
            $longitude = isset($_POST['longitude']) ? $_POST['longitude'] : 0;
            if ($trip_id != "" && $user_id != "") {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                /* $logdate = date('Y-m-d H:i:s');
                  $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
                $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
                $fileName = "";
                /* log_message('error', " customs update " . json_encode($_POST)); */
                $file_upload_flag = false;
                if (isset($_FILES)) {
                    foreach ($_FILES as $k => $FILE) {
                        if (isset($FILE['name'])) {
                            $config = array(
                                'upload_path' => NEW_POD_PATH,
                                'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                                'overwrite' => true,
                            );
                            $file_name = $FILE['name'];
                            $file_ext = @strtolower(end(explode('.', $FILE['name'])));
                            $expensions = array("jpeg", "jpg", "png", "gif", "pdf");
                            if (in_array($file_ext, $expensions) === false) {

                            } else {
                                if ($file_ext == "pdf") {
                                    $imgtype = "pdf";
                                    $this->load->library('upload', $config);
                                    $ff = 'file_name' . $k;
                                    if ($this->upload->do_upload($ff)) {
                                        $imgname = $this->upload->data();
                                        $imgtype = $imgname['image_type'];
                                        $fileName = $imgname['file_name'];
                                    }
                                } else {
                                    $fileName = date('dmyhis') . '' . $file_name;
                                    $filePath = NEW_POD_PATH . $fileName;
                                    $imgsize = getimagesize($FILE['tmp_name']);
                                    $top_width = $imgsize[0];
                                    $top_height = $imgsize[1];
                                    $quality = 100;
                                    if ($file_ext == "png") {
                                        $top = imagecreatefrompng($FILE['tmp_name']);
                                        $imgtype = "png";
                                    } else {
                                        $top = imagecreatefromjpeg($FILE['tmp_name']);
                                        if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                            $imgtype = "jpeg";
                                        } else {
                                            $imgtype = $file_ext;
                                        }
                                    }
                                    header('Content-Type: image/jpeg');
                                    imagejpeg($top, $filePath, $quality);
                                    imagedestroy($top);
                                }
                            }
                        }
                    }
                }
                $chk = $this->db->select('shift_id,vehicle_id')->get_where('tb_trips', array('id' => $trip_id), 1, 0);
                $shipment_id = $vehicle_id = 0;
                if ($chk->num_rows() > 0) {
                    $shipment_id = $chk->row()->shift_id;
                    $vehicle_id = $chk->row()->vehicle_id;
                }
                $ordid = $order_id = 0;
                $uid = 5;
                if ($shipment_id > 0) {
                    $chkord = $this->db->query(
                        "SELECT id, order_id, user_id FROM tb_orders WHERE shift_id = ? LIMIT 1",
                        [$shipment_id]
                    );
                    if ($chkord->num_rows() > 0) {
                        $ordid = $chkord->row()->id;
                        $order_id = $chkord->row()->order_id;
                        $uid = $chkord->row()->user_id;
                    }
                }
                $imageSize = filesize(NEW_POD_PATH.$fileName);
                $newUuid = $this->uuid->v4();
                $filedata = ['shipment_id' => $shipment_id, 'stop_id' => 0, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 2, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'createdby' => $driver_id, 'filesize' => $imageSize, 'hash' => $newUuid];
                $res = $this->db->insert("tb_pod_uploads", $filedata);
                $file_upload_flag = true;
                $id = $this->db->insert_id();
                /* store in status also */
                $stsdata = array('shipment_id' => $shipment_id, 'stop_id' => 0,'order_id'=>$ordid, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id' => 5, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => 1, 'reason' => 'Out Of Border', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'createdon' => $curdt);
                $res = $this->db->insert("tb_stop_status", $stsdata);
                $gethrs = $this->db->query(
                    "SELECT c.cntry_hrs
                    FROM tbl_country_master AS c, tb_users AS u
                    WHERE c.country_code = u.country_code AND u.id = ? AND c.status = 1
                    LIMIT 1",
                    [$uid]
                );
                $hrs = $gethrs->row()->cntry_hrs;
                $postdata = array(
                    "shipment_id" => $shipment_id,
                    "trip_id" => $trip_id,
                    "driver_id" => $driver_id,
                    "order_id" => $order_id,
                    "file_name" => $fileName,
                    "file_type" => $imgtype,
                    'pod_type' => 3,
                    'user_id' => $user_id,
                    "latitude" => $latitude,
                    "longitude" => $longitude,
                    "curtz" => $curtz,
                    "hrs" => $hrs
                );
                /* send to customes doc status to roadlog */
                $sts = $this->statusintigration->roadlogcustomsdocstatus($postdata);
                /* send to customes doc notify mail */
                if ($fileName != "") {
                    $sendcustomes = $this->sendcustomesnotify($postdata);
                }
                $response = (array("status" => "1", "data" => array()));
            }
        }
        echo json_encode($response);
    }

    public function sendcustomesnotify($post) {
        $shipment_id = isset($post["user_id"]) ? $post["shipment_id"] : '';
        $user_id = isset($post["user_id"]) ? $post["user_id"] : '';
        $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : '';
        $trip_id = isset($post["trip_id"]) ? $post["trip_id"] : '';
        $order_id = isset($post["order_id"]) ? $post["order_id"] : '';
        if ($user_id != "" && $driver_id != "" && $trip_id != "") {
            $getusermail = $this->db->select("name,emailid,company_code,cc_mails")->get_where("tb_users", array("id" => $user_id, "status" => "Active"), 1, 0);
            if ($getusermail->num_rows() > 0) {
                $cmpcode = $getusermail->row()->company_code;
                if ($cmpcode == "SGKN" || $cmpcode == "MYKN") {
                    $receivemail = $getusermail->row()->cc_mails;
                    $receivename = $getusermail->row()->name;
                    if ($receivemail == "") {
                        $receivemail = $getusermail->row()->emailid;
                    }
                } else {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                }
                $orddata = $this->db->query(
                    "SELECT * FROM tb_orders WHERE order_id = ? AND shift_id = ? LIMIT 1",
                    [$order_id, $shipment_id]
                );
                if ($orddata->num_rows() > 0) {
                    $orddata1 = $orddata->row_array();
                    $data['order_id'] = $orddata1['order_id'];
                    $customer_id = $orddata1['customer_id'];
                    $custname = $custemail = "";
                    $customer = $this->db->query(
                        "SELECT name, email_id FROM tb_customers WHERE id = ? AND email_id != '' AND status = 1 LIMIT 1",
                        [$customer_id]
                    );
                    if ($customer->num_rows() > 0) {
                        $custname = $customer->row()->name;
                        $custemail = $customer->row()->email_id;
                    }
                    $this->load->library('email');
                    $data['orderref'] = "";
                    $ordref = $this->db->select("ref_value")->get_where("tb_order_references", array("order_id" => $order_id, "reference_id" => "DQ"), 1, 0);
                    if ($ordref->num_rows() > 0) {
                        $data['orderref'] = $ordref->row()->ref_value;
                    }
                    $data['order'] = $orddata1;
                    $data['page_title'] = "Cross Border Shipment";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->to($receivemail, $receivename);

                    if ($custname != "") {
                        $this->email->bcc($custemail, $custname);
                    }
                    $data['subject'] = "Customs Cleareance Completed at Border for Shipment #" . $order_id;
                    $this->email->subject("svkonekt::Customs Cleareance Completed at Border for Shipment #" . $order_id);
                    $this->email->set_mailtype("html");
                    $data['receivename'] = "Team";
                    $body = $this->load->view('mail_forms/crossborder', $data, true);
                    $this->email->message($body);
                    $epodpath = sprintf('%s/poduploads/%s', '/var/www/', ($fileName ?? ''));
                    $this->email->attach($epodpath);
                    $response = array("status" => 1, "data" => "Success");
                }
            }
        }
    }

    public function shipmentstoppods() {
        $response = array("status" => 0, "data" => "Not Found");
        $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
        $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
        $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : '';
        $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
        if ($shift_id > 0 && $stop_id > 0) {
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            $escapedCurtz = $this->db->escape($curtz);
            $whr = array("shipment_id" => $shift_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "status" => 1);
            $qry = $this->db->select("id, doc_type, stop_type, imgpath, hash, latitude, longitude, convertToClientTZ(createdon, {$escapedCurtz}) AS createdon")->get_where("tb_pod_uploads", $whr);
            if ($qry->num_rows() > 0) {
                $resdata = array();
                foreach ($qry->result() as $res) {
                    $docurl = base_url() . 'downloadEpod/safelink/' . $res->hash. '.epod';
                    $doctype = "Others";
                    if ($res->doc_type == "3" && $res->stop_type == "P") {
                        $doctype = "POP";
                    } else if ($res->doc_type == "3" && $res->stop_type == "D") {
                        $doctype = "POD";
                    } else if ($res->doc_type == "1") {
                        $doctype = "Signature";
                    }
                    $resdata[] = array("id" => $res->id, "doc_type" => $doctype, "url" => $docurl, "latitude" => $res->latitude, "longitude" => $res->longitude, "createdon" => strtotime($res->createdon));
                }
                $response = array("status" => 1, "data" => $resdata);
            }
        }
        echo json_encode($response);
    }

    public function removestoppod() {
        $response = array("status" => 0, "data" => "Not Found");
        $id = isset($_POST["id"]) ? $_POST["id"] : '';
        $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
        $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
        $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : '';
        $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
        if ($id > 0) {
            $whr = array("id" => $id, "status" => 1);
            $qry = $this->db->select("id")->get_where("tb_pod_uploads", $whr);
            if ($qry->num_rows() > 0) {
                $resdata = array("status" => 0);
                $upd = $this->db->where($whr)->update("tb_pod_uploads", $resdata);
                $response = array("status" => 1, "data" => "Removed Successfully");
            }
        }
        echo json_encode($response);
    }

    public function uoms() {
        $response = array("status" => 0, "data" => "Not Found");
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        if ($user_id > 0) {
            $data[] = array("id" => '11', "name" => "Pallet");
            $data[] = array("id" => '16', "name" => "PCs");
            $data[] = array("id" => '15', "name" => "Boxes");
            $data[] = array("id" => '13', "name" => "Shipment");
            $response = array("status" => 1, "data" => $data);
        }
        echo json_encode($response);
    }

    public function customers() {
        // log_message("error", "-- customers Input --" . json_encode($_POST));
        $response = array("status" => 0, "data" => "Not Found");
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $escapedCidname = $this->db->escape_like_str($cidname);
            $qry = $this->db->query(
                "SELECT id, name, code FROM tb_customers WHERE (name LIKE ? OR code LIKE ?) AND status = 1",
                ["%{$escapedCidname}%", "%{$escapedCidname}%"]);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = array("id" => $res->id, "name" => $res->name, "cid" => $res->code);
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    public function parties() {
        $response = array("status" => 0, "data" => "Not Found");
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $escapedCidname = $this->db->escape_like_str($cidname);
            $qry = $this->db->query(
                "SELECT id, name, mobile
                FROM tbl_party_master
                WHERE name != 'Carrier' AND (name LIKE ? OR mobile LIKE ?) AND user_id = ? AND status = 1",
                ["%{$escapedCidname}%", "%{$escapedCidname}%", $user_id]
            );
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = array("id" => $res->id, "name" => $res->name, "cid" => $res->mobile);
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    public function refnums() {
        $response = array("status" => 0, "data" => "Not Found");
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $escapedCidname = $this->db->escape_like_str($cidname);
            $qry = $this->db->query(
                "SELECT id, name, description FROM tb_reference_master WHERE name LIKE ? AND status = 1",
                ["%{$escapedCidname}%"]
            );
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = array("id" => $res->id, "name" => $res->description, "cid" => $res->name);
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    function getUserTimeZone($uid, $cmpcode) {
        $getqry = $this->db->query(
            "SELECT country_code, cntry_timezone, cntry_hrs, currency, phone_code
            FROM tbl_country_master
            WHERE (country_code = ? OR country_name = ?) AND status = 1
            LIMIT 1",
            [$cmpcode, $cmpcode]
        );
        $res = array("currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG", "phone_code" => "65");
        if ($getqry->num_rows() > 0) {
            $res = array("currency" => $getqry->row()->currency, "timezone" => $getqry->row()->cntry_timezone, "hrs" => $getqry->row()->cntry_hrs, 'country' => $getqry->row()->country_code, 'phone_code' => $getqry->row()->phone_code);
        }
        return $res;
    }

    public function drivercollection() {
//        log_message('error', json_encode($_POST) . '--- AT FIRST LINE');
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $imei = isset($_POST['imei']) ? $_POST['imei'] : "";

        if (isset($_POST)) {
            if (isset($_POST['data'])) {
                $post = json_decode($_POST['data']);
                $data = (array) $post;
//                log_message("error", "---response data---" . json_encode($data));
                $cust_id = isset($data['customer_id']) ? $data['customer_id'] : "";
//                log_message('error', "giver customer is is===" . $cust_id);
                $pickup_partyid = isset($data['pickup_pary_id']) ? $data['pickup_pary_id'] : "";
                $drop_partyid = isset($data['delivery_pary_id']) ? $data['delivery_pary_id'] : "";
                if ($pickup_partyid == "") {
                    $pickup_partyid = $cust_id;
                }
                if ($drop_partyid == "") {
                    $drop_partyid = $cust_id;
                }
                if ($driver_id > 0 && $user_id > 0 && $cust_id != "") {
                    $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                    $uoms = isset($data['uoms']) ? $data['uoms'] : array();
                    $references = isset($data['references']) ? $data['references'] : array();
                    $pickupAddressLine1 = $data['pickup']->formatted_address;
                    $pickcity = $data['pickup']->name;
                    $plat = $data['pickup']->geometry->location->lat;
                    $plng = $data['pickup']->geometry->location->lng;
                    $addrs = (array) $data['pickup']->address_components;
                    $parea = $pickupCity = $pstate = $pickupCountry = $pickupPin = "";
                    foreach ($addrs as $res1) {
                        if ($res1->types[0] == "locality") {
                            $parea = $res1->long_name;
                        }
                        if ($res1->types[0] == "administrative_area_level_2") {
                            $pickupCity = $res1->long_name;
                        }
                        if ($res1->types[0] == "administrative_area_level_1") {
                            $pstate = $res1->long_name;
                        }
                        if ($res1->types[0] == "country") {
                            $pickupCountry = $res1->long_name;
                        }
                        if ($res1->types[0] == "postal_code") {
                            $pickupPin = $res1->long_name;
                        }
                    }
                    if ($pickupCity == "") {
                        $pickupCity = $parea;
                    }
                    $dropAddressLine1 = $data['destination']->formatted_address;
                    $dropcity = $data['destination']->name;
                    $dlat = $data['destination']->geometry->location->lat;
                    $dlng = $data['destination']->geometry->location->lng;
                    $daddrs = (array) $data['destination']->address_components;
                    $darea = $dropCity = $dstate = $dropCountry = $dropPin = "";
                    foreach ($daddrs as $dres) {
                        if ($dres->types[0] == "locality") {
                            $darea = $dres->long_name;
                        }
                        if ($dres->types[0] == "administrative_area_level_2") {
                            $dropCity = $dres->long_name;
                        }
                        if ($dres->types[0] == "administrative_area_level_1") {
                            $dstate = $dres->long_name;
                        }
                        if ($dres->types[0] == "country") {
                            $dropCountry = $dres->long_name;
                        }
                        if ($dres->types[0] == "postal_code") {
                            $dropPin = $dres->long_name;
                        }
                    }
                    if ($dropCity == "") {
                        $dropCity = $darea;
                    }
                    if ($pickupAddressLine1 != "" && $dropAddressLine1 != "") {
                        /* $logdate = date('Y-m-d H:i:s');
                          $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz); */
                        $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */
                        $pickupDate = $dropDate = $curdt;
                        $chkdist = distancemetrixship($plat, $plng, $dlat, $dlng);
                        if ($chkdist['duration'] > 0) {
                            $duration = $chkdist['duration'];
                            $tm = strtotime($curdt);
                            $dropDate = date("Y-m-d H:i:s", $tm + $duration);
                        }
                        $vendor_id = $vehicle_id = "";
                        $quantity = $valueOfGoods = 0;
                        $shipmentOption = "LTL";
                        foreach ($uoms as $cnt) {
                            $cnt = (array) $cnt;
                            if ($cnt['value'] > 0) {
                                $quantity += $cnt['value'];
                            }
                        }
                        $weight = $volume = 1;
                        $custinfo = $this->db->select("name,phone,code,location,email_id,company_code")->get_where("tb_customers", array("id" => $cust_id), 1, 0);
//                        log_message("error", $this->db->last_query());
                        $cmpname = $custinfo->row()->name;
                        $consigneeName = $custinfo->row()->name;
                        $consigneeCode = $custinfo->row()->code;
                        $customer_area = $custinfo->row()->location;
                        $consigneeEmail = $custinfo->row()->email_id;
                        $consigneePhone = $custinfo->row()->phone;
                        $pickupCompany = $dropCompany = $cmpname;
                        $company_code = $custinfo->row()->company_code;
                        $vendorchk = $this->db->select("vehicle_id")->get_where("tbl_assigned_drivers", array("driver_id" => $driver_id, "status" => 1), 1, 0);
                        if ($vendorchk->num_rows() > 0) {
                            $vehicle_id = $vendorchk->row()->vehicle_id;
                            $tbltrucks = $this->db->select("vendor_id")->get_where("tb_vendor_vehicles", array("vehicle_id" => $vehicle_id, "status" => 1), 1, 0);
                            if ($tbltrucks->num_rows() > 0) {
                                $vendor_id = $tbltrucks->row()->vendor_id;
                            }
                        } else {
                            $vendorchk = $this->db->select("vehicle_id")->get_where("tb_vehicles_drivers", array("driver_id" => $driver_id, "status" => 1), 1, 0);
                            if ($vendorchk->num_rows() > 0) {
                                $vehicle_id = $vendorchk->row()->vehicle_id;
                                $tbltrucks = $this->db->select("vendor_id")->get_where("tb_vendor_vehicles", array("vehicle_id" => $vehicle_id, "status" => 1), 1, 0);
                                if ($tbltrucks->num_rows() > 0) {
                                    $vendor_id = $tbltrucks->row()->vendor_id;
                                }
                            }
                        }
                        if ($vendor_id != "" && $vehicle_id != "") {
                            $vehicle_type = "Truck";
                            $vehinfo = $this->db->query(
                                "SELECT t.trucktype
                                FROM tb_trucktypes AS t, tb_trucks_data AS d
                                WHERE t.id = d.truck_type AND d.id = ?
                                LIMIT 1",
                                [$vehicle_id]
                            );
                            if ($vehinfo->num_rows() > 0) {
                                $vehicle_type = $vehinfo->row()->trucktype;
                            }
                            $year = date('y');
                            $week = date('W');
                            $coun_sess = $company_code;
                            $count_code = substr($coun_sess, 0, 2);
                            $seq_num = 000001;
                            $user = $this->db->select("id,country_code")->get_where("tb_users", array("id" => $user_id), 1, 0)->row_array();
                            $tz = $this->getUserTimeZone($user['id'], $user['country_code']);
                            $country_code = $tz['phone_code'];
                            $product = $branch_code = $freight_term = $freight_termname = $logicalreceiver = $physicalreceiver = $physicalsender = $logicalsender = "";
                            $modeoftransport = 1;
                            $rcentship = $this->db->query(
                                "SELECT shipid, domainname, company_code, branch_code,
                                product, freight_term, freight_termname, logicalreceiver, physicalreceiver,
                                physicalsender, logicalsender, modeoftransport
                                FROM tb_shipments
                                WHERE company_code = ?
                                ORDER BY id DESC
                                LIMIT 1",
                                [$company_code]
                            );
                            if ($rcentship->num_rows() > 0) {
                                $product = $rcentship->row()->product;
                                $branch_code = $rcentship->row()->branch_code;
                                $freight_term = $rcentship->row()->freight_term;
                                $freight_termname = $rcentship->row()->freight_termname;
                                $logicalreceiver = $rcentship->row()->logicalreceiver;
                                $physicalreceiver = $rcentship->row()->physicalreceiver;
                                $physicalsender = $rcentship->row()->physicalsender;
                                $logicalsender = $rcentship->row()->logicalsender;
                                $modeoftransport = $rcentship->row()->modeoftransport;
                            }
                            $ordchk = $this->db->select("id,order_id")->order_by('id', 'DESC')->get_where("tb_orders", array("user_id" => $user_id), 1, 0);
                            if ($ordchk->num_rows() > 0) {
                                $order_id = ($ordchk->row()->id + 1);
                                $order_nm = $ordchk->row()->order_id;
                                $seq_num = substr($order_nm, -6);
                                $week_order_number = $order_nm;
                                $country_codelength = strlen($country_code);
                                $wcount = $country_codelength + 2;
                                $previous_weeknumber = mb_substr($week_order_number, $wcount, 2);
                                $idlength = strlen($order_id);
                                $ycount = $wcount + 2;
                                $previous_ordernumber = mb_substr($week_order_number, $ycount, 5);
                                $id = ltrim($previous_ordernumber, 0);
                                if ($previous_weeknumber < $week) {
                                    $id = '0001';
                                } else {
                                    $i_id = $id;
                                    $i_id++;
                                    $idlength = strlen($i_id);
                                    if ($idlength == '1') {
                                        $id = "000" . $i_id;
                                    } else if ($idlength == '2') {
                                        $id = "00" . $i_id;
                                    } else if ($idlength == '3') {
                                        $id = "0" . $i_id;
                                    } else if ($idlength == '4') {
                                        $id = $i_id;
                                    } else {
                                        $id = $i_id;
                                    }
                                }
                                $ord = $country_code . $year . $week . $id;
                            } else {
                                $i_id = 1;
                                $id = '000' . $i_id;
                                $ord = $country_code . $year . $week . $id;
                            }
                            $shiptxn = "T" . $country_code . $week . $year . $seq_num;
                            $ttansmode = "Full Truck Load";
                            $chkshmt = $this->db->select("id")->get_where("tb_shipments", array("shipid" => $shiptxn), 1, 0);
                            if ($chkshmt->num_rows() == 0) {
                                $shipdatains = array('shipid' => $shiptxn, 'txnid' => $shiptxn, 'trucktype' => $ttansmode, 'product' => $product, 'pickupcnt' => 1, 'dropcnt' => 1, 'unitspec' => 1, 'insertusr' => $cust_id, 'carrier' => $vendor_id, 'insertuserdate' => $curdt, 'enddate' => $dropDate, 'insdate' => $curdt, 'upddate' => $dropDate, 'reason' => 'SHIPMENT', 'purpose' => 'SEND INTEGRATION', 'ship_object' => 'SHIPMENT', 'logdate' => $curdt, 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt, 'transport_mode' => $shipmentOption, 'txncode' => $ord, 'domainname' => $branch_code, 'company_code' => $company_code, 'branch_code' => $branch_code, 'freight_term' => $freight_term, 'freight_termname' => $freight_termname, 'logicalreceiver' => $logicalreceiver, 'physicalreceiver' => $physicalreceiver, 'physicalsender' => $physicalsender, 'logicalsender' => $logicalsender, 'modeoftransport' => $modeoftransport);
                                $sship_id = $this->common->insertTableData('tb_shipments', $shipdatains);
                            } else {
                                $sship_id = $chkshmt->row()->id;
                            }
                            if ($sship_id > 0) {
                                $orddata = array('order_id' => $ord, 'pickup_datetime' => $pickupDate, 'pickup_endtime' => $pickupDate, 'delivery_datetime' => $dropDate, 'drop_endtime' => $dropDate, 'pickup_company' => $pickupCompany, 'delivery_company' => $dropCompany, 'pickup_country' => $pickupCountry, 'delivery_country' => $dropCountry, 'pickup_city' => $pickupCity, 'delivery_city' => $dropCity, 'pickup_pincode' => $pickupPin, 'delivery_pincode' => $dropPin, 'pickup_address1' => $pickupAddressLine1, 'delivery_address1' => $dropAddressLine1, 'quantity' => $quantity, 'weight' => $weight, 'volume' => $volume, 'goods_value' => $valueOfGoods, 'transport_mode' => $shipmentOption, 'dedicated_vehicle' => 0, 'vehicle_type' => $vehicle_type, 'user_id' => $user_id, 'customer_id' => $cust_id, 'vendor_id' => $vendor_id, 'customer_name' => $consigneeName, 'customer_code' => $consigneeCode, 'customer_area' => $customer_area, 'customer_phone' => $consigneePhone, 'customer_email' => $consigneeEmail, 'vendor_name' => "", 'vendor_code' => "", 'vendor_area' => "", 'vendor_phone' => "", 'vendor_email' => "", 'plat' => $plat, 'plng' => $plng, 'dlat' => $dlat, 'dlng' => $dlng, 'product' => $product, 'shipment_id' => $sship_id, 'pickup_custid' => $cust_id, 'pickup_partyid' => $pickup_partyid, 'drop_custid' => $cust_id, 'drop_partyid' => $drop_partyid, 'status' => 2, 'updatedon' => $curdt, "created_source" => 1, "shipmentid" => $shiptxn, 'logicalreceiver' => $logicalreceiver, 'physicalreceiver' => $physicalreceiver, 'physicalsender' => $physicalsender, 'logicalsender' => $logicalsender, 'modeoftransport' => $modeoftransport);
                                $ord_id = $this->common->insertTableData("tb_orders", $orddata);
                                /* insert into cargo types and insert into cargo details */
                                $volume = 1;
                                $stackable = 0;
                                if (count($uoms) > 0) {
                                    foreach ($uoms as $ct) {
                                        $ct = (array) $ct;
                                        if ($ct['value'] != "") {
                                            $cargo_whr = array('cargo_type' => $ct['name'], 'quantity' => $quantity, 'length' => $weight, 'length_unit' => 'M', 'width' => $weight, 'width_unit' => 'M', 'height' => $weight, 'height_unit' => 'M', 'weight' => $weight, 'weight_unit' => 'Kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'stackable' => $stackable);
                                            $cargo_ins = array('cargo_type' => $ct['name'], 'goods_description' => $ct['name'], 'quantity' => $quantity, 'length' => $weight, 'length_unit' => 'M', 'width' => $weight, 'width_unit' => 'M', 'height' => $weight, 'height_unit' => 'M', 'weight' => $weight, 'weight_unit' => 'Kg', 'volume' => $volume, 'volume_unit' => 'cbm', 'stackable' => $stackable, 'createdby' => $user_id, 'createdon' => $curdt);
                                            $checkparty = $this->db->select("id")->get_where("tb_cargo_details", $cargo_whr, 1, 0);
                                            if ($checkparty->num_rows() == 0) {
                                                $cargo_id = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
                                            } else {
                                                $cargo_id = $checkparty->row()->id;
                                            }
                                            $ins = array('cargo_type' => $ct['name'], 'order_id' => $ord_id, 'status' => 1, 'createdon' => $curdt);
                                            $cargotype = $this->common->insertTableData("tb_order_cargotypes", $ins);
                                            $cargodata = array('order_id' => $ord_id, 'cargo_id' => $cargo_id, 'handling_unit' => $ct['id'], 'length' => $weight, 'width' => $weight, 'height' => $weight, 'weight' => $weight, 'quantity' => $quantity, 'status' => 1, 'createdon' => $curdt);
                                            $ordcargo_id = $this->common->insertTableData("tb_order_cargodetails", $cargodata);
                                            /* $qrcode = $this->generateQRCodes($cargo_id,$cargodata); */
                                        }
                                    }
                                }
                                /* insert order references */
                                if (count($references) > 0) {
                                    foreach ($references as $ref) {
                                        if ($ref != null) {
                                            /* log_message("error","Refence details".json_encode($ref)); */
                                            $ref = (array) $ref;
                                            if ($ref['value'] != "" && $ref['reference_id'] != "") {
                                                $ins = array('order_id' => $ord_id, 'reference_id' => $ref['reference_id'], 'ref_value' => $ref['value'], 'status' => 1, 'createdon' => $curdt);
                                                $refins = $this->common->insertTableData("tb_order_references", $ins);
                                            }
                                        }
                                    }
                                }
                                $shipperparty_id = 1;
                                $consignee_party_id = 3;
                                $chkparty = $this->common->gettblrowdata(array("name" => "Shipper", "user_id" => $user_id, "status" => 1), "id", "tbl_party_types", 0, 0);
                                if (count($chkparty) > 0) {
                                    $shipperparty_id = $chkparty['id'];
                                }
                                $chkparty = $this->common->gettblrowdata(array("name" => "Consignee", "user_id" => $user_id, "status" => 1), "id", "tbl_party_types", 0, 0);
                                if (count($chkparty) > 0) {
                                    $consignee_party_id = $chkparty['id'];
                                }
                                $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $pickup_partyid, 'party_type' => $shipperparty_id), 1, 0);
                                if ($checkparty->num_rows() == 0) {
                                    $partyarr = array('order_id' => $ord_id, 'order_number' => $ord, 'party_id' => $pickup_partyid, 'party_type' => $shipperparty_id, 'status' => 1, 'createdon' => $curdt);
                                    $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                                }
                                $checkparty = $this->db->select("id")->get_where("tb_order_parties", array('order_id' => $ord_id, 'party_id' => $drop_partyid, 'party_type' => $consignee_party_id), 1, 0);
                                if ($checkparty->num_rows() == 0) {
                                    $partyarr = array('order_id' => $ord_id, 'order_number' => $ord, 'party_id' => $drop_partyid, 'party_type' => $consignee_party_id, 'status' => 1, 'createdon' => $curdt);
                                    $ins = $this->common->insertTableData("tb_order_parties", $partyarr);
                                }
                                $checkshipment = $this->db->select("id")->get_where("tb_shifts", array('shipmentid' => $shiptxn, "status" => 1), 1, 0);
                                if ($checkshipment->num_rows() == 0) {
                                    $shipment = array('user_id' => $user_id, 'stime' => date("H:i", strtotime($curdt)), 'etime' => date("H:i", strtotime($dropDate)), 'splace' => $pickupAddressLine1, 'slat' => $plat, 'slng' => $plng, 'eplace' => $dropAddressLine1, 'elat' => $dlat, 'elng' => $dlng, 'scity' => $pickupCity, 'dcity' => $dropCity, 'zone_id' => 1, 'empshift_start' => date("H:i", strtotime($curdt)), 'empshift_end' => date("H:i", strtotime($dropDate)), 'trip_type' => 0, 'startdate' => $curdt, 'enddate' => $dropDate, 'shipment_name' => 1, 'shipmentid' => $shiptxn, 'shipment_id' => $sship_id, 'customer_id' => $cust_id, 'transport_mode' => $shipmentOption, 'vendor_id' => $vendor_id, 'carrier_type' => 0, 'txnid' => $ord, 'weight' => $weight, 'volume' => $volume, 'units' => count($uoms), 'domainname' => $branch_code, 'vehicle_type' => $vehicle_type, 'company_code' => $company_code, 'branch_code' => $branch_code, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                                    $ship_id = $this->common->insertTableData("tb_shifts", $shipment);
                                    /* update order table */
                                    $upddt = array("shift_id" => $ship_id);
                                    $updwhr = array("id" => $ord_id);
                                    $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                                    $stopleg1_id = $stopleg2_id = "";
                                    $chkstoplegs = $this->db->select("id")->get_where("tb_shiporder_stops", array('stopname' => $pickupAddressLine1, 'stopcity' => $pickupCity, 'shipment_id' => $ship_id, 'txncode' => $ord, 'stoptype' => 'P'), 1, 0);
                                    if ($chkstoplegs->num_rows() == 0) {
                                        $shiporder = array('stopname' => $pickupAddressLine1, 'plat' => $plat, 'plng' => $plng, 'stopcity' => $pickupCity, 'address' => $pickupAddressLine1, 'stoptype' => 'P', 'stopstatus' => 0, 'shipment_id' => $ship_id, 'ordernumber' => 1, 'startdate' => $curdt, 'enddate' => $curdt, 'weight' => $weight, 'volume' => $volume, 'shipmentstopid' => 0, 'serviceprovider' => "LMV", 'ship_units' => count($uoms), 'txncode' => $ord, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                                        $stopleg1_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                                    }
                                    $chkstoplegs1 = $this->db->select("id")->get_where("tb_shiporder_stops", array('stopname' => $dropAddressLine1, 'stopcity' => $dropCity, 'shipment_id' => $ship_id, 'txncode' => $ord, 'stoptype' => 'D'), 1, 0);
                                    if ($chkstoplegs1->num_rows() == 0) {
                                        $shiporder = array('stopname' => $dropAddressLine1, 'plat' => $dlat, 'plng' => $dlng, 'stopcity' => $dropCity, 'address' => $dropAddressLine1, 'stoptype' => 'D', 'stopstatus' => 0, 'shipment_id' => $ship_id, 'ordernumber' => 2, 'startdate' => $dropDate, 'enddate' => $dropDate, 'weight' => $weight, 'volume' => $volume, 'shipmentstopid' => 0, 'serviceprovider' => "LMV", 'ship_units' => count($uoms), 'txncode' => $ord, 'status' => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                                        $stopleg2_id = $this->common->insertTableData("tb_shiporder_stops", $shiporder);
                                    }
                                    if ($stopleg1_id != "" && $stopleg2_id != "") {
                                        $chkemp = $this->db->select("id")->get_where("tb_employee", array('assoc_id' => $ord, 'order_id' => $ord, 'shift_id' => $ship_id, 'stop_id' => $stopleg1_id, 'drop_stopid' => $stopleg2_id), 1, 0);
                                        if ($chkemp->num_rows() == 0) {
                                            $stops = array('assoc_id' => $ord, 'pickup' => $pickupAddressLine1, 'plat' => $plat, 'plng' => $plng, 'drop' => $dropAddressLine1, 'dlat' => $dlat, 'dlng' => $dlng, 'pickup_city' => $pickupCity, 'drop_city' => $dropCity, 'pickup_datetime' => $curdt, 'drop_datetime' => $dropDate, 'name' => 'Goods', 'phone' => "", 'address' => $pickupAddressLine1, 'user_id' => $user_id, 'password' => RandomString::generate(10), 'status' => 1, 'createdon' => $curdt, 'updatedon' => $curdt, 'material_id' => 0, 'capacity' => $quantity, 'information' => "", 'shipment_weight' => $weight, 'shipment_volume' => $volume, 'ship_type' => 'P', 'customer_id' => $cust_id, 'vendor_id' => $vendor_id, 'shipment_id' => $sship_id, 'startdate' => $curdt, 'enddate' => $dropDate, 'shift_id' => $ship_id, 'stop_order' => 1, 'drop_order' => 2, 'basic_stop' => 1, 'stop_id' => $stopleg1_id, 'drop_stopid' => $stopleg2_id, 'order_id' => $ord, 'pkgitemid' => 'Goods', 'no_of_pkgs' => count($uoms), 'domainname' => $branch_code, "accepted" => 1);
                                            $stop_id = $this->common->insertTableData("tb_employee", $stops);
                                        }
                                        /* assign to carrier */
                                        $veharr = array("user_id" => $user_id, "shft_id" => $ship_id, "carrier_id" => $vendor_id, "vehicle_id" => $vehicle_id);
                                        $chkveh = $this->db->select("id")->get_where("tb_shft_veh", $veharr, 1, 0);
                                        if ($chkveh->num_rows() == 0) {
                                            $insveh = array("user_id" => $user_id, "shft_id" => $ship_id, "carrier_id" => $vendor_id, "vehicle_id" => $vehicle_id, "register_number" => "", "status" => 1, 'created_on' => $curdt, 'updated_on' => $curdt);
                                            $shipvehid = $this->common->insertTableData("tb_shft_veh", $insveh);
                                        } else {
                                            $shipvehid = $chkveh->row()->id;
                                            $updveh = array("status" => 1, 'updated_on' => $curdt);
                                            $upd = $this->db->where($veharr)->update("tb_shft_veh", $updveh);
                                        }
                                        /* assign to priority stops */
                                        $veharr = array("user_id" => $user_id, "shft_veh_id" => $shipvehid);
                                        $chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp", $veharr, 1, 0);
                                        if ($chkveh->num_rows() == 0) {
                                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array("shift_id" => $ship_id));
                                            if ($getemp->num_rows() > 0) {
                                                $pri = 1;
                                                foreach ($getemp->result() as $gt) {
                                                    $insveh1 = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                                    $pri++;
                                                }
                                            }
                                        } else {
                                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array("shift_id" => $ship_id));
                                            if ($getemp->num_rows() > 0) {
                                                $pri = 1;
                                                foreach ($getemp->result() as $gt) {
                                                    $veharr = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id);
                                                    $chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp", $veharr, 1, 0);
                                                    if ($chkveh->num_rows() == 0) {
                                                        $insveh1 = array("user_id" => $user_id, "shft_veh_id" => $shipvehid, "emp_id" => $gt->id, "priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'created_on' => $curdt, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                                        $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                                    } else {
                                                        $veharr11 = array("id" => $chkveh->row()->id);
                                                        $updveh1 = array("priority" => $pri, "pickup_time" => $gt->pickup_datetime, 'updated_on' => $curdt, "status" => 1, "drop_time" => $gt->drop_datetime);
                                                        $upd = $this->db->where($veharr11)->update("tb_shft_veh_emp", $updveh1);
                                                    }
                                                    $pri++;
                                                }
                                            }
                                        }
                                        /* update status */
                                        $chk = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $ship_id, "status_id" => 9), 1, 0);
                                        if ($chk->num_rows() == 0) {
                                            $ins = array("shipment_id" => $ship_id,'order_id'=>$ord_id, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => "", "trip_id" => 0, "status_id" => 9, "status_code" => "0100", "status" => 1, "reason" => "Coming from E-Booking", "createdon" => $curdt);
                                            $insqry = $this->db->insert("tb_stop_status", $ins);
                                        }
                                        /* accept shipment */
                                        $chktrip = $this->db->select("id")->get_where("tb_trips", array("shift_id" => $ship_id, "vehicle_id" => $vehicle_id, "driver_id" => $driver_id), 1, 0);
                                        if ($chktrip->num_rows() == 0) {
                                            $tripsdata = array("shift_id" => $ship_id, "vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "stime" => $curdt, "start_imei" => $imei, "splace" => $pickupAddressLine1, "created_on" => $curdt, "updated_on" => $curdt, "status" => 1);
                                            $tid = $this->common->insertTableData("tb_trips", $tripsdata);
                                        } else {
                                            $tid = $chktrip->row()->id;
                                        }
                                        /* update order table */
                                        $upddt = array("trip_id" => $tid);
                                        $updwhr = array("id" => $ord_id);
                                        $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                                        $hrs = $tz['hrs'];
                                        $postdata = array(
                                            "shipment_id" => $ship_id,
                                            "trip_id" => $tid,
                                            "driver_id" => $driver_id,
                                            "order_id" => $ord,
                                            "stop_id" => $stopleg1_id,
                                            "latitude" => $plat,
                                            "longitude" => $plng,
                                            "curtz" => $curtz,
                                            "hrs" => $hrs
                                        );
                                        /* $sts = $this->statusintigration->shipmentconfirm($postdata); */
                                        /* send to roadlog */
                                        $sts = $this->statusintigration->roadlogshipmentconfirm($postdata);
                                        /* status update */
                                        $chqry = $this->db->select("id")->get_where("tb_stop_status", array("shipment_id" => $ship_id, "stop_id" => 0, "stop_detail_id" => 0, "trip_id" => $tid, "status_id" => 10), 1, 0);
                                        if ($chqry->num_rows() == 0) {
                                            $insarry = array("shipment_id" => $ship_id,"order_id"=>$ord_id, "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => '', "trip_id" => $tid, "status_id" => 10, "latitude" => $plat, "longitude" => $plng, "status" => 1, "status_code" => "0212", "reason" => "From Mobile", "vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "createdon" => $curdt);
                                            $ins = $this->db->insert("tb_stop_status", $insarry);
                                        }
                                        $res = $d = array();
                                        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', array('status' => 1))->result_array();
                                        $d['id'] = $tid;
                                        $d['shift_id'] = $ship_id;
                                        $d['user_id'] = $user_id;
                                        $d['driver_id'] = $driver_id;
                                        $d['vehicle_id'] = $vehicle_id;
                                        $d['shipweight'] = $quantity;
                                        $d['imei'] = $imei;
                                        $d['stime'] = date("H:i", strtotime($curdt));
                                        $d['etime'] = date("H:i", strtotime($dropDate));
                                        $d['trip_type'] = 0;
                                        $d['startdate'] = $curdt;
                                        $d['enddate'] = $dropDate;
                                        $d["saddress"] = $pickupAddressLine1;
                                        $d["daddress"] = $dropAddressLine1;
                                        $pod = $signature = "";
                                        $d["splace"] = $pickupCity;
                                        $d["eplace"] = $dropCity;
                                        $d["scity"] = $pickupCity;
                                        $d["dcity"] = $dropCity;
                                        $d["slat"] = $plat;
                                        $d["slng"] = $plng;
                                        $d["elat"] = $dlat;
                                        $d["elng"] = $dlng;
                                        $d["shipmentid"] = $shiptxn;
                                        $d["shift_veh_id"] = $shipvehid;
                                        $d['astatus'] = 0;
                                        $d['sno'] = 1;
                                        $d['distance'] = $chkdist['disttext'];
                                        $d['duration'] = round((($chkdist['duration'] / 40) * 60), 2) . " min";
                                        $d['startdate'] = strtotime($curdt);
                                        $d['enddate'] = strtotime($dropDate);
                                        $d['pod'] = $pod;
                                        $d['signature'] = $signature;
                                        $res['trips'] = $d;
                                        $response = array("status" => 1, "data" => $res);
                                    } else {
                                        $response = array("status" => 0, "data" => "Source/Destination Locations Are Wrong");
                                    }
                                } else {
                                    $response = array("status" => 0, "data" => "Already exists!");
                                }
                            } else {
                                $response = array("status" => 0, "data" => "Shipment Already exists!");
                            }
                        } else {
                            $response = array("status" => 0, "data" => "No vehicle assigned to you");
                        }
                    } else {
                        $response = array("status" => 0, "data" => "Please enter proper locations");
                    }
                } else {
                    $response = array("status" => 0, "data" => "Enter Customer Name");
                }
            }
        }
        // log_message("error", "drivercoll_res" . json_encode($response));
        echo json_encode($response);
    }

    public function getQuantities() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";
        /* log_message("error", "getQuantities " . json_encode($_POST)); */
        if (isset($_POST)) {
            $data = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query(
                    "SELECT o.id
                    FROM tb_orders AS o, tb_shiporder_stops AS s
                    WHERE o.shift_id = s.shipment_id AND s.id = ? AND o.shift_id = ? AND s.shipment_id = ?
                    GROUP BY o.id",
                    [$stop_id, $shift_id, $shift_id]
                );
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query(
                            "SELECT e.id, e.unit_name, SUM(o.quantity) AS quantity
                            FROM tbl_shipunit_types AS e, tb_order_cargodetails AS o
                            WHERE e.id = o.handling_unit AND o.order_id = ?
                            GROUP BY e.id",
                            [$res->id]
                        );
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $whr = array("stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
                                $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                                if ($updates->num_rows() > 0) {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => $updates->row()->scanned_quantity);
                                } else {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => 0);
                                }
                            }
                        }
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    public function getQuantitiesMultiple() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";
        /* log_message("error", "getQuantities " . json_encode($_POST)); */
        if (isset($_POST)) {
            $data = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query(
                    "SELECT o.id
                    FROM tb_orders AS o, tb_shiporder_stops AS s
                    WHERE o.shift_id = s.shipment_id AND s.id = ? AND o.shift_id = ? AND s.shipment_id = ?
                    GROUP BY o.id",
                    [$stop_id, $shift_id, $shift_id]
                );
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query(
                            "SELECT e.id, e.unit_name, SUM(o.quantity) AS quantity, o.stop_detail_id
                            FROM tbl_shipunit_types AS e, tb_order_cargodetails AS o
                            WHERE e.id = o.handling_unit AND o.order_id = ?
                            GROUP BY e.id",
                            [$res->id]
                        );
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {

                                $whr = array("stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
                                $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                                if ($updates->num_rows() > 0) {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => $updates->row()->scanned_quantity);
                                } else {
                                    $data[] = array("cargo_type_id" => $res1->id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => 0);
                                }
                            }
                        }
                    }
                }
                $response = array("status" => 1, "data" => $data);
            }
        }
        echo json_encode($response);
    }

    public function setQuantities() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";
        $cargos_types1 = isset($_POST['cargos_types']) ? json_decode($_POST['cargos_types']) : array();

        // log_message("error", "setQuantities " . json_encode($_POST));
        // file_put_contents('setquantities_quantites.txt',json_encode($_POST));

        if (isset($_POST)) {
            $quantities = array();
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query(
                    "SELECT o.id
                    FROM tb_orders AS o, tb_shiporder_stops AS s
                    WHERE o.shift_id = s.shipment_id AND s.id = ? AND o.shift_id = ? AND s.shipment_id = ?
                    GROUP BY o.id",
                    [$stop_id, $shift_id, $shift_id]
                );
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query(
                            "SELECT e.id, SUM(o.quantity) AS quantity
                            FROM tbl_shipunit_types AS e, tb_order_cargodetails AS o
                            WHERE e.id = o.handling_unit AND o.order_id = ?
                            GROUP BY e.id",
                            [$res->id]
                        );
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $quantities[$res1->id] = $res1->quantity;
                            }
                        }
                    }
                }
            }else{
                // log_message("error","-setQuantities-"."not happen");
            }
            if (!is_array($cargos_types1)) {
                $cargos_types = array();
                /* $cargos_types = json_encode($cargos_types); */
            } else {
                $cargos_types = $cargos_types1;
            }
            $whr = array("driver_id" => $driver_id, "user_id" => $user_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id);
            $total_accepted_quantity = 0;
            if (!empty($cargos_types)) {
                foreach ($cargos_types as $cargo) {
                    $data = [];
                    $data = $whr;
                    $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                    if ($updates->num_rows() > 0) {
                        $data["cargo_type_id"] = $cargo->cargo_type_id;
                        $data["scanned_quantity"] = $cargo->scanned_quantity;
                        $data["quantity"] = @$quantities[$cargo->cargo_type_id];
                        $upd = $this->db->where($whr)->update("tb_cargo_driver_updates", $data);
                    } else {
                        $data["cargo_type_id"] = $cargo->cargo_type_id;
                        $data["scanned_quantity"] = $cargo->scanned_quantity;
                        $data["quantity"] = $quantities[$cargo->cargo_type_id];
                        $ins = $this->db->insert("tb_cargo_driver_updates", $data);
                    }
                }
            }
            $quantity = $this->db->query(
                "SELECT SUM(scanned_quantity) AS quantity
                FROM tb_cargo_driver_updates
                WHERE shift_id = ? AND stop_id = ? AND status = 1",
                [$shift_id, $stop_id]
            );
            if ($quantity->num_rows() > 0) {
                $upd = $this->db->where(array("shipment_id" => $shift_id, "id" => $stop_id))->update("tb_shiporder_stops", array("ship_units" => $quantity->row()->quantity));
            }
            $response = array("status" => 1);
        }
        echo json_encode($response);
    }

    public function generateQRCodes($cargo_id, $cargodata) {
        $this->load->library('barcode');
        $handling_unit = $cargodata["handling_unit"];
        $quantity = $cargodata["quantity"];
        $data = [];
        $data["order_cargo_details_id"] = $cargo_id;
        $data["handling_unit"] = $handling_unit;
        $data["quantity"] = $quantity;
        $data["path"] = $this->barcode->generate(json_encode(array("cargo_id" => $handling_unit, "quantity" => $quantity)));
        $ins = $this->db->insert("tb_order_cargo_qrdetails", $data);
    }

    public function updatepassword() {
        $response = array("status" => 0, "data" => "Not Found");
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $newpassword = isset($_POST['newpassword']) ? $_POST['newpassword'] : "";
        if (isset($_POST)) {
            if ($driver_id > 0 && $user_id > 0 && $newpassword != "") {
                $chk = $this->db->select("id")->get_where("tb_truck_drivers", array("id" => $driver_id), 1, 0);
                if ($chk->num_rows() > 0) {
                    $pwd = password_hash($newpassword, PASSWORD_DEFAULT);
                    $upd = array("password" => $pwd);
                    $updqry = $this->db->set($upd)->where(array("id" => $driver_id))->update("tb_truck_drivers");
                    $response = array("status" => 1);
                }
            }
        }
        echo json_encode($response);
    }

    public function bookorderquote() {
        $response = array("status" => 0, "data" => "Something went wrong!");
        if (isset($_POST)) {
            /* $post = json_decode($_POST['data']);
              $data = (array)$post; */
            $post = $_POST;
            $cust_id = isset($post['cust_id']) ? $post['cust_id'] : '';
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $orderid = isset($post['order_id']) ? $post['order_id'] : '';
            $response = array("status" => 1, "data" => array("status" => "Booking Complete", "order_id" => $orderid));
        }
        echo json_encode($response);
    }

    public function panicAlert() {
        $response = array("status" => 0, "data" => null);
        if (isset($_POST)) {
            $post = $_POST;
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $driver_id = isset($post['driver_id']) ? $post['driver_id'] : '';
            $vehicle_id = isset($post['vehicle_id']) ? $post['vehicle_id'] : '';
            $trip_id = isset($post['trip_id']) ? $post['trip_id'] : '';
            $lat = isset($post['latitude']) ? $post['latitude'] : '';
            $lng = isset($post['longitude']) ? $post['longitude'] : '';
            $clicked_on = isset($post['clicked_on']) ? $post['clicked_on'] : '';
            $clicked_on = date("Y-m-d H:i:s", strtotime($clicked_on));
            $data = [];
            $data["user_id"] = $user_id;
            $data["driver_id"] = $driver_id;
            $data["trip_id"] = $trip_id;
            $data["lat"] = $lat;
            $data["lng"] = $lng;
            $data["clicked_on"] = $clicked_on;
            $data["vehicle_id"] = $vehicle_id;
            $data['shift_id'] = $data['splace'] = $data['stime'] = $data['eplace'] = $data['etime'] = $data['shipmentid'] = "";
            if ($trip_id == "") {
                $trip_id = 0;
            }
            $chkshift = $this->db->query(
                "SELECT s.id, s.splace, s.stime, s.eplace, s.etime, s.shipmentid
                FROM tb_shifts AS s, tb_trips AS t
                WHERE s.id = t.shift_id AND t.id = ?
                LIMIT 1",
                [$trip_id]
            );
            if ($chkshift->num_rows() > 0) {
                $data['shift_id'] = $chkshift->row()->id;
                $data['splace'] = $chkshift->row()->splace;
                $data['stime'] = $chkshift->row()->stime;
                $data['eplace'] = $chkshift->row()->eplace;
                $data['etime'] = $chkshift->row()->etime;
                $data['shipmentid'] = $chkshift->row()->shipmentid;
            }
            $data['driver_name'] = $data['contact_num'] = $data['register_number'] = "";
            $drivers = $this->db->select("name,contact_num")->where("id", $driver_id)->get("tb_truck_drivers");
            if ($drivers->num_rows() > 0) {
                $data['driver_name'] = $drivers->row()->name;
                $data['contact_num'] = $drivers->row()->contact_num;
            }
            $vehicle = $this->db->select("register_number")->where("id", $vehicle_id)->get("tb_trucks_data");
            if ($vehicle->num_rows() > 0) {
                $data['register_number'] = $vehicle->row()->register_number;
            }
            $exists = $this->db->where(array("driver_id" => $driver_id, "status" => 1))->get("tb_panic_alerts");
            if ($exists->num_rows() > 0) {
                $data["updated_by"] = $user_id;
                $upd = $this->db->where(array("id" => $exists->row()->id))->update("tb_panic_alerts", $data);
            } else {
                $data["created_by"] = $user_id;
                $ins = $this->db->insert("tb_panic_alerts", $data);
            }
            $this->sendPanicMail($data);
            $response = array("status" => 1, "data" => null, "message" => "Success");
        }
        echo json_encode($response);
    }

    private function sendPanicMail($data = []) {
        if (!empty($data)) {
            $user_id = $data["user_id"];
            $users = $this->db->select("name,emailid")->get_where("tb_users", array("id" => $user_id), 1, 0);
            if ($users->num_rows() > 0) {
                $data["email"] = $email = $users->row()->emailid;
                $data["name"] = $users->row()->name;
                if ($data['register_number'] != "") {
                    if ($data['driver_name'] != "" && $data['contact_num'] != "") {
                        $data["driver_name"] = $data['driver_name'];
                        $data["driver_mobile"] = $data['contact_num'];
                        $trip_id = $data["trip_id"];
                        if ($data['shift_id'] != "") {
                            $data["eplace"] = $data['eplace'];
                            $data["splace"] = $data['splace'];
                            $data["shipment_id"] = $data['shipmentid'];
                            $this->load->library('email');
                            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                            $this->email->to($data["email"], $data["name"]);
                            $this->email->subject("svkonekt::Panic button triggered on " . $data['register_number']);
                            $this->email->set_mailtype("html");
                            $content = $this->load->view("mail_forms/panic_alert", $data, true);
                            $this->email->message($content);
                        }
                    }
                }
            }
        }
    }

    function getpayload() {
        $ency_key = $this->input->post('ency_key');
        echo json_encode(array(
            "status" => 1,
            "response" => array('shipment_id' => 'OTHPNATH00000008')
        ));
    }

    /*
     *  use as service for mobile web application to get secure link.
     *  Method : POST
     *  @param ship_id
     *  return json
     */

    public function getsecureLink() {
        $ship_id = $this->input->post("ship_id", true);
        // log_message("Error","---secure link shipment id---".$ship_id);
        $expDate = strtotime('+10 days');
        $jwt_claim = ["sub" => $ship_id, "exp" => $expDate];

        $this->load->helper("jwt");

        $get_jwt = generate_jwt($jwt_claim);
        // log_message("error","---secure linke ---".$get_jwt.'----');
        $link_id = base_url() . "driverapp/" . $get_jwt;
        if ($link_id != "") {
            echo json_encode(array("status" => "1", "secure_link" => $link_id));
        } else {
            echo json_encode(array("status" => "0", "secure_link" => $link_id));
        }
    }

    /*
     *    Purpose : To Get order Parties details Based on order id
     *
     *    @param order_id integer  this is order id
     *    return  json
     */

    public function order_partys_details() {
        $order_id = $this->input->post('order_id');
        $response = array("status" => "0", "response" => array());
        if (is_numeric($order_id) && $order_id > 0) {
            $response_data = $this->db->query(
                "SELECT party_id, party_type,
                (SELECT tpt.name
                    FROM tbl_party_types AS tpt
                    WHERE tpt.id = party_type AND status = 1
                    LIMIT 1) AS party_type_name,
                (SELECT CONCAT(tpm.name, '::', tpm.mobile, '::', tpm.email)
                    FROM tbl_party_master AS tpm
                    WHERE tpm.id = party_id AND status = 1
                    LIMIT 1) AS party_details
                FROM tb_order_parties
                WHERE order_id = ?
                LIMIT 2",
                [$order_id]
            )->result_array();
            if (sizeof($response_data) > 0) {
                $response = array("status" => "1", "response" => $response_data);
            }
        }
        echo json_encode($response);
    }

    /*
     *    Purpose : To sent mail
     *
     *    @param email string receiver mail
     *    @param subject string email_subject
     *    $param body text/html email_body
     *    return  json
     */


    function send_mail() {
        // load helper
        // $this->load->helper('Notifytrigger');
        $email = $this->input->post('email');
        $username = $this->input->post('email');
        $subject = $this->input->post('subject');
        $body = $this->input->post('body');
        $data['emailid'] = $email;
        $data['username'] = $username;
        $data['subject'] = $subject;
        $data['body'] = $body;
        // log_message("error","---------Send Mail Call----------");
        // sent mail
        if ($this->sendstatusmail($data)) {
            // log_message("error","---------Send Mail Call Successs----------");
            echo  json_encode(array('status' => '1', 'message' => 'Mail sent Successfully.'));
        } else {
            // log_message("error","---------Send Mail Call fail----------");
            echo json_encode(array('status' => '0', 'message' => 'Opps! Something is went wrong.'));
        }
    }



    public function sendstatusmail($data){
        $this->load->library('email');
        // log_message("error","---------Senstatusmail step-1----------");
        // initial config
        $config['mailtype'] = 'html';
        $config['charset'] = 'iso-8859-1';
        $config['wordwrap'] = FALSE;
        $config['validate'] = TRUE;
        $config['newline'] = "\r\n";
        // log_message("error","....Email Data...".json_encode($data));
        $this->email->initialize($config);
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to($data['emailid'], $data['username']);
        $this->email->subject($data['subject']);
        $this->email->message($data['body']);
        if(!$this->email->send()){
            // echo "Mail Failed";
            // log_message("error","Email error");
            return false;
        } else {
            // echo "Successfully Sent Mail";
            // log_message("error","Email Success");
            return true;
        }
        // return true;
    }



        /*
     *  Purpose : To Save Deviation Details.
     *  $param status_type int
     *  $param reason string
     *  $param comment string
     *  $param deviation_picture  file
     *  return json
     */

    function save_deviation_info(){
        $data['status_type']=$this->input->post('status_type');
        $data['reason']=$this->input->post('reason');
        $data['comment']=$this->input->post('comment');
        $data['shift_id'] = $this->input->post('shift_id');
        $data['stop_id'] = $this->input->post('stop_id');
        $data['trip_id'] = $this->input->post('trip_id');
        $data['stop_detail_id'] = $this->input->post('stop_detail_id');
        $data['stop_type'] = $this->input->post('stop_type');
        $data['driver_id'] = $this->input->post('driver_id');
        $data['shift_veh_id'] = $this->input->post('shift_veh_id');

        if(strlen($data['reason'])<5){
             $response =array("status"=>'0',"message"=>'Reason must contain atleast 5 characters');
             echo json_encode($response);
             return;
        }

        if(!(is_numeric($data['shift_id']) && is_numeric($data['stop_id']) && is_numeric($data['trip_id']) && is_numeric($data['stop_detail_id']))){
             $response =array("status"=>'0',"message"=>'Please provide valid details');
             echo json_encode($response);
             return;
        }

        if (isset($_FILES)) {
            $fileName1 = $this->input->post('shift_id').'_'.$this->input->post('trip_id').'_'.$this->input->post('stop_id').'_'.$this->input->post('stop_detail_id').'_'.$this->input->post('stop_type').'_'.uniqid().'_'.time().'.jpg';

            if (isset($_FILES['deviation_picture']['name'])) {
                $config = array(
                    'upload_path' => './assets/deviationuploads/',
                    'allowed_types' => 'jpg|jpeg|png',
                    'overwrite' => TRUE,
                    'file_name' => $fileName1,
                    'remove_spaces' => TRUE,
                    'detect_mime' => TRUE,
                    'mod_mime_fix' => TRUE,
                    'max_size' => 2048,
                    'file_ext_tolower' => TRUE
                );
                $file_ext = @strtolower(end(explode('.', $_FILES['deviation_picture']['name'])));
            }
            $expensions = array("jpeg", "jpg", "png");
            if (in_array($file_ext, $expensions) === false) {
                $response = array("status" => 0, "data" => "Image Format Not Allowed");
            } else {
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    if ($this->upload->do_upload('deviation_picture')) {
                        $imgname = $this->upload->data();
                        $imgtype = $imgname['image_type'];
                        $fileName = $imgname['file_name'];
                        $data['image_path']=$fileName1;
                        // $response = array("status" => 1, "data" => "Document Uploaded Successfully!");
                    } else {
                        $errors = $this->upload->display_errors();
                        // $response = array("status" => 0, "data" => $errors);
                    }
            }
        }
        // log_message("error",'---------Deviation list ---------------'.json_encode($data).'---------------------');
       $res = $this->common->insertTableData("tb_deviations_details", $data);
       if($res>0){
            $response =array("status"=>'1',"message"=>'Deviation details saved succesfully.');
       }
       echo json_encode($response);
     }

    function get_danger_goods_details(){
        $danger_goods_order_id = $this->input->post('danger_goods_order_id');
        $danger_goods_order_id  = '42889';
        if(is_numeric($danger_goods_order_id) && $danger_goods_order_id >0){
            $response_data = $this->db->query(
                "SELECT * FROM tb_order_dg_goods WHERE order_id = ? LIMIT 1",
                [$danger_goods_order_id]
            )->result_array();
            if (sizeof($response_data) > 0) {
                $response = array("status" => "1", "response" => $response_data);
            }
        }else{
                $response = array("status" => "1", "response" => array());
        }
        echo json_encode($response);
        return;
     }
}
