<?php

use App\ShipmentStops\GetShipmentStopsService;
use App\ShipmentStops\PrepareShipmentStopResult;
use App\ShipmentStops\PreprocessPostData;
use App\ShiftsData\TbStopStatusFields\Status;
use App\ShiftsData\TbStopStatusFields\StatusId;
use App\ShiftsData\TbStopStatusFields\StopType;

class Driverapiv3getshipmentstops extends CI_Controller
{
    public function getshipmentstops()
    {
        list($shift_id, $curtz) = PreprocessPostData::preprocessPostData();
        $query = GetShipmentStopsService::getStops($curtz ?? "", $shift_id ?? 0, $this->db);

        if ($query->num_rows() === 0) {
            echo json_encode(["status" => 0, "data" => "Not Found"]);
            return;
        }

        $result = [];
        $i = 0;
        $prevsts = "N";

        foreach ($query->result() as $res) {
            $stop_id = $res->id;
            $emp = $this->db->query(
                "SELECT id,order_id FROM tb_employee WHERE stop_id=? AND shift_id = ? AND status=? LIMIT 1",
                [$stop_id, $shift_id, 1]
            );

            if ($emp->num_rows() > 0) {
                if ($prevsts == "C") {
                    $status = $prevsts = "S";
                } else {
                    $status = "N";
                }

                $detailsid = $emp->row()->id;

                $gateoutWhere = [
                    "stop_id" => $stop_id,
                    "shipment_id" => $shift_id,
                    "status_id" => StatusId::GATEOUT,
                    "status" => Status::ACTIVE,
                    "stop_type" => $res->stoptype,
                    "stop_detail_id" => $detailsid
                ];

                $gateoutDetails = $this->db->select('id')->where($gateoutWhere)->get("tb_stop_status");

                if ($gateoutDetails->num_rows() > 0) {
                    $status = $prevsts = "C";
                } else {
                    $whr = ["stop_id" => $stop_id, "shipment_id" => $shift_id];
                    $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                    if ($statuses->num_rows() > 0) {
                        $status = $prevsts = "S";
                    }
                }

                if ($status == "N" && $i == 0) {
                    $status = "S";
                }

                $result[] = PrepareShipmentStopResult::prepareShipmentStopResult($res, $status, [$emp->row()->order_id], []);
            } else {
                $emp = $this->db->query(
                    "SELECT id,order_id FROM tb_employee WHERE drop_stopid = ? AND shift_id = ? AND status = ? LIMIT 1",
                    [$stop_id, $shift_id, 1]
                );

                if ($emp->num_rows() > 0) {
                    if ($prevsts == "C") {
                        $status = $prevsts = "S";
                    } else {
                        $status = "N";
                    }

                    $detailsid = $emp->row()->id;

                    $gateoutWhere = [
                        "stop_id" => $stop_id,
                        "shipment_id" => $shift_id,
                        "status_id" => StatusId::PICKUP_DONE_OR_DELIVERY_DONE,
                        "status" => Status::ACTIVE,
                        "stop_type" => StopType::DROP,
                        "stop_detail_id" => $detailsid
                    ];

                    $gateoutDetails = $this->db->select('id')->where($gateoutWhere)->get("tb_stop_status");

                    if ($gateoutDetails->num_rows() > 0) {
                        $status = $prevsts = "C";
                    } else {
                        $whr = ["stop_id" => $stop_id, "shipment_id" => $shift_id];
                        $statuses = $this->db->select('id')->where($whr)->get("tb_stop_status");
                        if ($statuses->num_rows() > 0) {
                            $status = $prevsts = "S";
                        }
                    }

                    if ($status == "N" && $i == 0) {
                        $status = "S";
                    }

                    $result[] = PrepareShipmentStopResult::prepareShipmentStopResult($res, $status, [$emp->row()->order_id], []);
                }
            }
            $i++;
        }

        echo json_encode(["status" => 1, "data" => $result]);
    }
}
