<?php

defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');

use App\ApiRequest\DataPreprocessing\BadRequestException;
use App\ApiRequest\DataPreprocessing\MethodNotAllowedException;
use App\ApiRequest\DataPreprocessing\NoDataFoundException;
use App\ApiRequest\DataPreprocessing\PostTimezoneFilter;
use App\ApiRequest\DataPreprocessing\TimezoneNotSpecifiedException;
use App\ApiRequest\GetPartyInformation;
use App\ApiRequest\Printable;
use App\ApiRequest\SendDocumentGateOut;
use App\ApiRequest\StopUnitsPartiallyPicked;
use App\DriverCollection\DriverCollection;
use App\EventsQueue\AbstractEventController;
use App\Mobile\V1\Trips\MakeTripObject;
use App\MobileEvents\MobileEvent;
use App\MobileEvents\Payload\Builder\UploadCustomsPayloadBuilder;
use App\MobileEvents\Payload\Factory\AbortTripPayloadFactory;
use App\MobileEvents\Payload\Factory\AssignDriverPayloadFactory;
use App\MobileEvents\Payload\Factory\CloseTripPayloadFactory;
use App\MobileEvents\Payload\Factory\CloseTripSummaryPayloadFactory;
use App\MobileEvents\Payload\Factory\DriverCollectionPayloadFactory;
use App\MobileEvents\Payload\Factory\MilestoneUpdatePayloadFactory;
use App\MobileEvents\Payload\Factory\PanicAlertPayloadFactory;
use App\MobileEvents\Payload\Factory\PodUploadsPayloadFactory;
use App\MobileEvents\Payload\Factory\RejectTripPayloadFactory;
use App\MobileEvents\Payload\Factory\RescheduleTripPayloadFactory;
use App\MobileEvents\Payload\Factory\SignatureUploadsPayloadFactory;
use App\MobileEvents\Payload\Factory\StartMultipleShipmentsPayloadFactory;
use App\MobileEvents\Payload\Factory\StartTripPayloadFactory;
use App\MobileEvents\Payload\Factory\StopStatusUpdatePayloadFactory;
use App\MobileEvents\Payload\RemovePodPayload;
use App\PodUploads\CheckSignatureAndPodTrait;
use App\PodUploads\MakePod\Address;
use App\PodUploads\MakePod\Measurements;
use App\PodUploads\MakePod\PodData;
use App\ShiftsData\AddressesFromShiftTrait;
use App\ShiftsData\CountPickupDropGateins;
use App\ShiftsData\ExtractShiporderStopsTrait;
use App\ShiftsData\GetDocumentStatusAndStopsData;
use App\Trip\Models\DriverTripList;
use App\Trip\Services\DriverShipmentsService;
use Mpdf\MpdfException;

class Driverapiv5 extends AbstractEventController
{
    use CheckSignatureAndPodTrait;
    use AddressesFromShiftTrait;
    use ExtractShiporderStopsTrait;
    use CountPickupDropGateins;

    const DEFAULT_HOURS = '+2.30';
    private const LIMIT = 5;

    public function __construct()
    {
        parent::__construct();
        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper(['date','thirdparty_helper']);
        $this->load->model(['common', 'cabmodel', 'DeliveryDocumentModel','OtmBookingModel']);
        $this->load->library(['uuid', 'shippeostatusintigration', 'svkonektquote', 'statusintigration', 'sendfirebase', 'smsnotifier', 'commonpodedi', 'standard_document_execution','standard_status_execution', 'Altovaordercreation']);
        $this->load->helper("log_helper");
    }

    public function index()
    {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }

    public function driverLogin()
    {
        ob_start();
        $response = ["status" => 0, "message" => "Not Found"];
        //log_message("error","Innn:".json_encode($_POST));
        if (isset($_POST)) {
            $mobile = $_POST["mobile"] ?? '';
            $pwd = $_POST["password"] ?? '';
            $gcmId = $_POST["token"] ?? '';
            $imei = $_POST["imei"] ?? '';
            //auth_helper.php
            $pwd = decryptAES256($pwd);
            //$pwd = decryptPassword($pwd);
            if ($mobile != "") {
                $whr = ["d.contact_num" => $mobile, "d.status" => "Active"];
                $this->db->select('d.*,u.country_code,u.mobile_no,u.status_datetime_type,u.default_currency as currency');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                $driversCount = $sql->num_rows();
                $queryResult = $sql->num_rows() > 0 ? $sql->row_array() : [];
                $encryptedPassword = $queryResult['password'] ?? "";
                if ($driversCount > 0 && $this->checkDriverPassword($pwd, $encryptedPassword)) {
                    $this->common->insertTableData("tb_driver_login_logs", ["mobile" => $mobile, "password" => $pwd, "imei" => $imei, "status" => $driversCount]);
                    $data = $sql->row_array();
                    $id = $data["id"];
                    $qry = $this->db->query("SELECT t.id,t.register_number from tbl_assigned_drivers a, tb_trucks_data t, tb_truck_drivers d where a.driver_id=$id AND t.id=a.vehicle_id AND a.status=1 AND d.status='Active' AND d.id=a.driver_id AND t.status='Active' ORDER BY a.id DESC LIMIT 1");
                    $veh = $veh_id = "";
                    if ($qry->num_rows() > 0) {
                        $veh = $qry->row()->register_number;
                        $veh_id = $qry->row()->id;
                    }

                    if ($gcmId != "") {
                        $this->common->updatetbledata("tb_truck_drivers", ["gcm_id" => $gcmId], ["id" => $id]);
                    }

                    $defaultTimezone = "Asia/Singapore";
                    $countryMaster = $this->common->gettblrowdata(["country_code" => $data['country_code']], "cntry_timezone", "tbl_country_master", 0, 0);
                    if (count($countryMaster) > 0) {
                        $defaultTimezone = $countryMaster['cntry_timezone'];
                    }
                    $statusDateTimeType = $data['status_datetime_type'];
                    $data['status_datetime_type'] = $statusDateTimeType == "" ? '0' : $statusDateTimeType;
                    $data['imei'] = $imei;
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = 0;
                    $data['timezone'] = $defaultTimezone;
                    $data['border_type'] = 0;
                    $response = ["status" => 1, "data" => $data];
                }
            }
        }
        ob_end_clean();
        echo json_encode(Printable::printable($response));
    }

    private function checkDriverPassword(string $password, string $hashedPassword): bool
    {
        if ($password == "" || $hashedPassword == "") {
            return false;
        }
        if (password_verify($password, $hashedPassword)) {
            return true;
        } else {
            return false;
        }
    }

    public function crossborderchange()
    {
        ob_start();
        $response = [];
        $response = ["status" => 0, "message" => "Not Found"];
        if (isset($_POST)) {
            $prev_admin_area = isset($_POST["prev_admin_area"]) ? $_POST["prev_admin_area"] : '';
            $prev_country_code = isset($_POST["prev_country_code"]) ? $_POST["prev_country_code"] : '';
            $admin_area = isset($_POST["admin_area"]) ? $_POST["admin_area"] : '';
            $country_code = isset($_POST["country_code"]) ? $_POST["country_code"] : '';
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : '';
            $driver_id = isset($_POST["driver_id"]) ? $_POST["driver_id"] : '';
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : '';
            $prev_latitude = isset($_POST["prev_latitude"]) ? $_POST["prev_latitude"] : '';
            $prev_longitude = isset($_POST["prev_longitude"]) ? $_POST["prev_longitude"] : '';
            $latitude = isset($_POST["latitude"]) ? $_POST["latitude"] : '';
            $longitude = isset($_POST["longitude"]) ? $_POST["longitude"] : '';
            if ($user_id != "" && $driver_id != "" && $trip_id != "") {
                $arr = ['trip_id' => $trip_id, 'driver_id' => $driver_id, 'user_id' => $user_id, 'prev_admin_area' => $prev_admin_area, 'prev_country_code' => $prev_country_code, 'prev_latitude' => $prev_latitude, 'prev_longitude' => $prev_longitude, 'admin_area' => $admin_area, 'country_code' => $country_code, 'latitude' => $latitude, 'longitude' => $longitude];
                $ins = $this->db->insert("tb_crossed_borders", $arr);
                $getusermail = $this->db->select("name,emailid,company_code,cc_mails")->get_where("tb_users", ["id" => $user_id, "status" => "Active"], 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $cmpcode = $getusermail->row()->company_code;
                    if (checkAccessConditions('RELATED_2_SG_MY', $cmpcode)) {
                        $receivemail = $getusermail->row()->cc_mails;
                        $receivename = $getusermail->row()->name;
                        if ($receivemail == "") {
                            $receivemail = $getusermail->row()->emailid;
                        }
                    } else {
                        $receivemail = $getusermail->row()->emailid;
                        $receivename = $getusermail->row()->name;
                    }
                    $orddata = $this->db->query("SELECT * FROM tb_orders WHERE trip_id=$trip_id AND trip_sts=0 LIMIT 1");
                    if ($orddata->num_rows() > 0) {
                        $data['order'] = $orddata->row_array();
                        $data['order_id'] =  $data['order']['order_id'];
                        $customer_id = $data['order']['customer_id'];
                        $custname = $custemail = "";
                        $customer = $this->db->query("SELECT name,email_id FROM tb_customers WHERE id=$customer_id AND email_id != '' AND status=1 LIMIT 1");
                        if ($customer->num_rows() > 0) {
                            $custname = $customer->row()->name;
                            $custemail = $customer->row()->email_id;
                        }
                        $this->load->library('email');
                        $ordid = $data['order']['id'];
                        $data['orderref'] = "";
                        $ordref = $this->db->select("ref_value")->get_where("tb_order_references", ["order_id" => $ordid, "reference_id" => "DQ"], 1, 0);
                        if ($ordref->num_rows() > 0) {
                            $data['orderref'] = $ordref->row()->ref_value;
                        }
                        $data['exit_area'] = $prev_admin_area . ", " . $prev_country_code;
                        $data['entry_area'] = $admin_area . ", " . $country_code;
                        $data['page_title'] = "Cross Border Shipment";
                        $data['receivemail'] = $receivemail;
                        $data['receivename'] = $receivename;
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);
                        if ($custname != "") {
                            $this->email->bcc($custemail, $custname);
                        }
                        $this->email->subject("svkonekt::Cross Border for Shipment #" . $order_id);
                        $this->email->set_mailtype("html");
                        $data['receivename'] = "Team";
                        $body = $this->load->view('mail_forms/crossborder', $data, true);
                        $this->email->message($body);

                        if(!$this->email->send()){
                           //log_message("error",$this->email->print_debugger());
                        }

                        $this->email->clear(true);

                        $response = ["status" => 1, "message" => "Success"];
                    }
                }
            }
        }
        ob_end_clean();
        echo json_encode(Printable::printable($response));
    }

    public function getDriverData()
    {
        ob_start();
        $response = ["status" => 0, "message" => "Not Found"];
        if (isset($_POST)) {
            $id = $_POST["id"] ?? '';
            $gcmId = $_POST["gcm_id"] ?? '';

            if (!empty($id)) {
                $whr = ["d.id" => $id, "d.status" => "Active"];
                $this->db->select('d.*,u.mobile_no');
                $this->db->from('tb_truck_drivers d');
                $this->db->join('tb_users u', 'd.user_id=u.id', 'INNER');
                $this->db->where($whr);
                $this->db->limit(1);
                $sql = $this->db->get();
                if ($sql->num_rows() > 0) {
                    $data = $sql->row_array();
                    $data['trip_id'] = 0;
                    $data['border_type'] = 0;
                    if ($gcmId != "") {
                        $this->db->where("id", $id)->update("tb_truck_drivers", ["gcm_id" => $gcmId]);
                    }
                    $activeTrips = $this->db->query("SELECT t.id, t.vehicle_id, v.register_number, s.border_type
                        FROM tb_trips t
                        JOIN tb_shifts s ON s.id = t.shift_id
                        JOIN tb_stop_status ss ON (ss.trip_id = t.id AND ss.status_id = 2 AND ss.stop_type = 'P')
                        JOIN tbl_assigned_drivers ad ON (ad.driver_id = t.driver_id AND ad.status = 1)
                        JOIN tb_trucks_data v ON v.id = ad.vehicle_id
                        WHERE t.status = 1 AND t.driver_id = ?
                        GROUP BY t.id
                        ORDER BY ss.createdon DESC
                        LIMIT 1", [$id]);
                        
                    if ($activeTrips->num_rows() > 0) {
                        $data['vehicle'] = $activeTrips->row()->register_number;
                        $data['vehicle_id'] = $activeTrips->row()->vehicle_id;
                        $data['trip_id'] = $activeTrips->row()->id;
                        $data['border_type'] = $activeTrips->row()->border_type;
                    }
                    $response = ["status" => 1, "data" => $data];
                }
            }
        }
        ob_end_clean();
        echo json_encode(Printable::printable($response));
    }

    public function startTrip()
    {
        ob_start();

        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        if (isset($_POST)) {
            if (isset($_POST['data'])) {
                $post = json_decode($_POST['data']);
                $shift_id = $data["shift_id"] = $post->shift_id ?? '';
                $data["vehicle_id"] = $post->vehicle_id ?? '';
                $data["trip_type"] = $post->trip_type ?? 0;
                $data["driver_id"] = $post->driver_id ?? '';
                $data["splace"] = $post->splace ?? '';
                $data["eplace"] = $post->eplace ?? '';
                $data["start_reading"] = $post->odemeter ?? '0';
                $latitude = $post->latitude ?? '';
                $longitude = $post->longitude ?? '';
                $imei = $post->imei ?? '';

                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $curdt = date('Y-m-d H:i:s');
                $data["stime"] = $data["created_on"] = $curdt;
                $chkqry = $this->db->select('id')
                    ->get_where('tb_truck_drivers', [
                        'id' => $data['driver_id'],
                        'status' => 'Active'
                    ])->num_rows();

                if ($chkqry > 0 && $data["shift_id"] != "") {
                    $chk = $this->db->select("id")->get_where("tb_trips", ["shift_id" => $data["shift_id"]], 1, 0);
                    if ($chk->num_rows() == 0) {
                        $data["start_imei"] = $imei;
                        $ins = $this->db->insert("tb_trips", $data);
                        $id = $this->db->insert_id();
                        /* update orders table */
                        $ordwhr = ["shift_id" => $data["shift_id"]];
                        $ordset = ["trip_id" => $id];
                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_employee");
                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                        $ins = $this->db->insert("tb_trip_drivers", ["driver_id" => $data["driver_id"], "trip_id" => $id, "createdon" => $data["created_on"]]);
                        $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(["shift_id" => $data["shift_id"]])->get("tb_employee");
                        if ($shift->num_rows() > 0) {
                            $uid = $shift->row()->user_id;
                            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                            if ($gethrs->num_rows() > 0) {
                                $hrs = $gethrs->row()->cntry_hrs;
                            } else {
                                $hrs = self::DEFAULT_HOURS;
                            }
                            $created_source = "";
                            $ord_id = 0;
                            $get_createdsrce = $this->db->query("SELECT id,created_source FROM tb_orders WHERE order_id='" . $shift->row()->order_id . "' LIMIT 1");
                            if ($get_createdsrce->num_rows() > 0) {
                                $created_source = $get_createdsrce->row()->created_source;
                                $ord_id = $get_createdsrce->row()->id;
                            }
                            $payload = StartTripPayloadFactory::create($created_source, $ord_id, $data["vehicle_id"], $data["driver_id"], $shift_id, $id, $latitude, $longitude, $uid, $curdt, $curtz, $hrs);
                            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_START_TRIP, $payload));
                        }
                        if ($id > 0) {
                            $empdata = array();
                            $empdata["trip_id"] = $id;
                            $response = ["status" => 1, "data" => [$empdata]];
                        } else {
                            $response = ["status" => 0, "message" => "Failed to Start"];
                        }
                    } else {
                        $empdata = [];
                        $empdata["trip_id"] = $chk->row()->id;
                        $response = ["status" => 1, "data" => [$empdata]];
                    }
                } else {
                    $response = ["status" => 3, "message" => "Please re-login to continue"];
                }
            }
        }
        ob_end_clean();
        echo json_encode(Printable::printable($response));
    }

    public function startMultipleShipments()
    {
        ob_start();
        $message = "Insufficient Input Data";
        $errorCount = 0;
        $response = ["status" => 0, "message" => $message];
        if (isset($_POST)) {
            $post = (object)$_POST;
            $data["driver_id"] = $post->driver_id ?? '';
            $shipmentsJSON = $post->shipments ?? '';
            $imei = $post->imei ?? '';
            $latitude = $post->latitude ?? '';
            $longitude = $post->longitude ?? '';
            $shipments = json_decode($shipmentsJSON);
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            if (!empty($shipments)) {
                $legsCount = $this->notStartedShipmentLegsCount($shipments);
                if ($legsCount == count($shipments)) {
                    foreach ($shipments as $shipmentArray) {
                        $shipment = (object)$shipmentArray;
                        $shift_id = $data["shift_id"] = $shipment->shift_id ?? '';
                        $data["vehicle_id"] = $shipment->vehicle_id ?? '';
                        $data["trip_type"] = $shipment->trip_type ?? 0;
                        $data["splace"] = $shipment->splace ?? '';
                        $data["eplace"] = $shipment->eplace ?? '';
                        $data["start_reading"] = $shipment->odemeter ?? '0';
                        $curdt = date('Y-m-d H:i:s');
                        $data["stime"] = $data["created_on"] = $curdt;
                        $chkqry = $this->db->select("id")
                            ->get_where("tb_truck_drivers", [
                                'id' => $data['driver_id'],
                                'status' => 'Active'])
                            ->num_rows();
                        if ($chkqry > 0) {
                            $isShipmentAccepted = $this->common->gettblrowdata(["shipment_id"=>$data["shift_id"], "status" => 1, "status_code" => "SV0120"],"id","tb_stop_status",0,0);
                            
                            if (!empty($isShipmentAccepted)) {
                                $errorCount++;
                            } else {
                                $chkVehicleId = $this->common->gettbldataorderby(["shft_id"=>$data["shift_id"],"status" => 1],"vehicle_id","tb_shft_veh","updated_on","DESC");
                                $vehicleId = $chkVehicleId[0]["vehicle_id"] ?? 0;
                                $chkDriverId = $this->common->gettbldataorderby(["vehicle_id"=>$vehicleId,"driver_id" => $data['driver_id'], "status"=>1],"driver_id","tbl_assigned_drivers","updated_on","DESC");
                                if (!empty($chkDriverId)) {
                                    /*commented code for stop duplicate shifts */
                                    $chk = $this->db->select("id")->get_where("tb_trips", ["shift_id" => $data["shift_id"], "driver_id" => $data["driver_id"], "vehicle_id" => $data["vehicle_id"]], 1, 0);
                                    if ($chk->num_rows() == 0) {
                                        $data["start_imei"] = $imei;
                                        $ins = $this->db->insert("tb_trips", $data);
                                        $id = $this->db->insert_id();
                                        /* update orders table */
                                        $ordwhr = ["shift_id" => $data["shift_id"]];
                                        $ordset = ["trip_id" => $id];
                                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_employee");
                                        $upd = $this->db->set($ordset)->where($ordwhr)->update("tb_orders");
                                        $ins = $this->db->insert("tb_trip_drivers", ["driver_id" => $data["driver_id"], "trip_id" => $id, "imei" => $imei, "createdon" => $data["created_on"]]);
                                        $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(["shift_id" => $data["shift_id"]])->get("tb_employee");
                                        if ($shift->num_rows() > 0) {
                                            $uid = $shift->row()->user_id;
                                            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                                            $hrs = $gethrs->num_rows() > 0 ? $gethrs->row()->cntry_hrs : self::DEFAULT_HOURS;
                                            $created_source = "";
                                            $ord_id = 0;
                                            $orderResults = $this->db->query("SELECT id,user_id,created_source FROM tb_orders WHERE order_id='" . $shift->row()->order_id . "' LIMIT 1");
                                            if ($orderResults->num_rows() > 0) {
                                                $created_source = $orderResults->row()->created_source;
                                                $ord_id = $orderResults->row()->id;
                                            }
                                            $chqry = $this->db->select("id")->get_where("tb_stop_status", ["shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "trip_id" => $id, "status_id" => 273], 1, 0);
                                            
                                            if ($chqry->num_rows() == 0) {
                                                $emps = $this->db->where(["shift_id" => $shift_id, 'status' => "1"])->get("tb_employee");
                                                foreach ($emps->result() as $emp) {
                                                    $orders = $this->db->where(["order_id" => $emp->order_id])->get("tb_orders");
                                                    if ($orders->num_rows() > 0) {
                                                        $stopStatusData = ["shipment_id" => $data["shift_id"], "stop_id" => 0, "stop_detail_id" => 0, "stop_type" => '', "trip_id" => $id, "status_id" => 273, "status" => 1, "latitude" => $latitude, "longitude" => $longitude, "status_code" => "SV0120", "reason" => "From Mobile", "vehicle_id" => $data["vehicle_id"], "driver_id" => $data["driver_id"], "createdon" => $curdt, "order_id" => $orders->row()->id];
                                                        $ins = $this->db->insert("tb_stop_status", $stopStatusData);
                                                        
                                                        $checkStatus = "RELATED_2_" . $orders->row()->company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
                                                        if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $orders->row()->company_code) && checkAccessConditions($checkStatus, 'SV0120')) {
                                                            $this->load->library('notifytrigger');
                                                            $this->notifytrigger->sendNotificationToConsignee($orders->row()->id, 'SV0120');
                                                        }
                                                        if (checkAccessConditions('WECHAT_COUNTRY', $orders->row()->company_code))
                                                        {
                                                            $this->load->library('Wechat');
                                                            $this->wechat->orderId = $emp->order_id;
                                                            $response = $this->wechat->sendNotificationsToWeChat();
                                                        }
                                                        $shippeoTriggerData = $data;
                                                        $shippeoTriggerData['order']['order_id'] = $orders->row()->order_id;
                                                        $shippeoTriggerData['order']['id'] = $orders->row()->id;
                                                        $shippeoTriggerData['order']['company_code'] = $orders->row()->company_code;
                                                        $shippeoTriggerData['order']['branch_code'] = $orders->row()->branch_code;
                                                        $shippeoTriggerData['info']['created_source'] = $created_source;
                                                        $shippeoTriggerData['info']['trip_id'] = $id;
                                                        $shippeoTriggerData['info']['latitude'] = $latitude;
                                                        $shippeoTriggerData['info']['longitude'] = $longitude;
                                                        $shippeoTriggerData['info']['curtz'] = $curtz;
                                                        $shippeoTriggerData['info']['hrs'] = $hrs;
                                                        $shippeoTriggerData['info']['orduser_id'] = $uid;
                                                        $this->shippeoStatusEventTrigger($shippeoTriggerData);
                                                        try {
                                                            $statusPayload = [
                                                                "trip" => $id,
                                                                "ship" => $data["shift_id"],
                                                                "ord_id" => $orders->row()->id,
                                                                "orderid" => $orders->row()->order_id,
                                                                "stopid" => 0,
                                                                "stopdetailid" => 0,
                                                                "vehicle_id" => $data["vehicle_id"],
                                                                "driver_id" => $data["driver_id"],
                                                                "stop_type" => "P",
                                                                "timezone" => $this->session->userdata("timezone"),
                                                                "sts_date" => $curdt,
                                                                "status_code" => "SV0120"
                                                            ];
                                                            $domainDetails = $this->OtmBookingModel->getDomain($orders->row()->id);
                                                            if (!empty($domainDetails)) {
                                                                $extOrderId = $domainDetails[0]['external_order_id'];
                                                                $domainName = $domainDetails[0]['ref_value'];
                                                                $domainCreatedSource = $domainDetails[0]['created_source'];
                                                                if($domainName<>"") {
                                                                    $otmRequest = [
                                                                        'glogDate' => date("Ymdhis"),
                                                                        'externalOrderId' => $extOrderId,
                                                                        'orderStatusDateTime' => $curdt,
                                                                        'domainName' => $domainName,
                                                                        'createdSource'=> $created_source ? $created_source :  $domainCreatedSource,
                                                                        'timeZone' =>$curtz ?? "",
                                                                        'orderStatusCode' => "SV0120",
                                                                    ];
                                                                    $output = sendOTMStatus($otmRequest); 
                                                                }
                                                            }
                                                            $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                                                            $this->altovaordercreation->sendOrderToAltova($orders->row()->order_id, "SV0120");
                                                        } catch (Exception $ex) {
                                                            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                                                        }
                                                    }
                                                }
                                            }
                                            $payload = StartMultipleShipmentsPayloadFactory::create($created_source, $ord_id, $data["vehicle_id"], $data["driver_id"], $shift_id, $id, $latitude, $longitude, $uid, $curdt, $curtz, $hrs);
                                            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_START_MULTIPLE_SHIPMENTS, $payload));
                                            if ($id > 0) {
                                                $empdata = [];
                                                $empdata["trip_id"] = $id;
                                                $response = ["status" => 1, "data" => [$empdata]];
                                            }
                                        }

                                        // Use OpenBoxes API to sent accept status, validation is inside function itself
                                        $this->load->helper(["edivalidation", 'customerconfigedi']);
                                        $this->load->library('OpenboxStatusAccept');
                                        $this->openboxstatusaccept->pushStatusXml($id);
                                    } else {
                                        $empdata = [];
                                        $empdata["trip_id"] = $chk->row()->id;
                                        $response = ["status" => 1, "data" => [$empdata]];
                                    }

                                }
                                else {
                                    $response = ["status" => 4, "message" => "Shipment is assigned to other Driver"];
                                }
                            }
                        } else {
                            $response = ["status" => 3, "message" => "Please re-login to continue"];
                        }
                    }

                } else {
                    $response = ["status" => 0, "message" => "One of the Shipment has the another Leg. With out closing that shipment orders this trip is started"];
                }
            }
        }
        if ($errorCount > 0) {
            $response = ["status" => 2, "message" => "Shipment is already accepted by other Driver"];
        }
        ob_end_clean();
        log_message("error","1133333:".json_encode($response));
        echo json_encode(Printable::printable($response));
    }

    public function sendTripAlert($trip = null, $curtz = null)
    {
        $result = [];
        if ($trip != null) {
            $q = $this->db->query("select employee_id from tb_trip_employee where trip_id=$trip");
            $emps = [];
            if ($q->num_rows() > 0) {
                foreach ($q->result() as $qr) {
                    array_push($emps, $qr->employee_id);
                }
            }
            $result = $this->sendFirstAlert($trip, $emps, $curtz);
        }
        return $result;
    }

    public function sendFirstAlert($trip = null, $emps = [], $curtz = null)
    {
        $result = [];
        $tt = $this->db->query("select t.driver_id,t.vehicle_id,sv.id,sv.register_number from tb_trips t,tb_shft_veh sv where t.id=$trip and sv.vehicle_id=t.vehicle_id and sv.shft_id=t.shift_id and sv.status=1 order by sv.id desc limit 1");
        if ($tt->num_rows() > 0) {
            $t = $tt->row();
            $driver = $t->driver_id;
            $vehicle_id = $t->vehicle_id;
            $shft_veh_id = $t->id;
            $reg = $t->register_number;
            if (count($emps) == 0) {
                $arr = ["shft_veh_id" => $shft_veh_id, "status" => 1];
                $sql2 = $this->db->select("priority,user_id")->group_by("priority")->order_by("priority", "asc")->get_where("tb_shft_veh_emp", $arr, 1, 0);
            } else {
                $sql2 = $this->db->select("priority,user_id")->where("shft_veh_id", $shft_veh_id)->where("status", 1)->where_not_in("emp_id", $emps)->group_by("priority")->order_by("priority", "asc")->limit(1)->get("tb_shft_veh_emp");
            }
            if ($sql2->num_rows() > 0) {
                $chksent = $this->db->select('id')->get_where('tb_tripfirst_alerts', ['trip_id' => $trip])->num_rows();
                $user_id = $sql2->row()->user_id;
                if ($chksent == 0) {
                    $this->db->select('d.contact_num');
                    $this->db->from('tb_truck_drivers d');
                    $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
                    $this->db->where('t.id', $trip);
                    $this->db->limit(1);
                    $drivermobile = $this->db->get();
                    $drivernum = "";
                    if ($drivermobile->num_rows() > 0) {
                        $drivernum = $drivermobile->row()->contact_num;
                    }
                    $link = $this->getLink($driver, $trip);
                    $msql1 = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1";
                    $mquery = $this->db->query($msql1);
                    $ecnt = $mquery->num_rows();
                    if ($ecnt > 0) {
                        $sntdata = ['trip_id' => $trip, 'module' => 'Truck Auto Arrival Alert Once', 'message' => $drivernum, 'sent_count' => $ecnt];
                        $sendres = $this->db->insert('tb_tripfirst_alerts', $sntdata);
                        foreach ($mquery->result() as $rw) {
                            $result['sms_data'][] = $this->sendBulkAlert($trip, $rw->emp_id, $rw->phone, $rw->name, $drivernum, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
                $sql1 = "select s.emp_id,e.name,e.pickup,e.drop,e.phone,e.plat,e.plng,e.dlat,e.dlng from tb_shft_veh_emp s,tb_employee e where s.shft_veh_id=$shft_veh_id and s.status='1' and e.id=s.emp_id and e.status=1 and priority=" . $sql2->row()->priority;
                $query = $this->db->query($sql1);
                if ($query->num_rows() > 0) {
                    $link = $this->getLink($driver, $trip);
                    foreach ($query->result() as $emps) {
                        $res = $this->db->select('id')->get_where("tb_trip_alerts", ["trip_id" => $trip, "emp_id" => $emps->emp_id])->num_rows();
                        if ($res == 0) {
                            $distance = $this->getDist($vehicle_id, $emps->plat, $emps->plng);
                            $result['pickup_data'][] = $this->sendAlert($trip, $emps->emp_id, $emps->phone, $emps->name, $distance, $reg, $link, $user_id, $curtz);
                        }
                    }
                }
            }
        }
        return $result;
    }

    public function getLink($driver, $trip)
    {
        $link1 = base_url() . "cab/track/" . encryptIt($driver, $trip);
        return $link1;
    }

    public function getDist($vehicle_id, $lat, $lng)
    {
        $rr = ['0', '0'];
        $imei1 = $this->db->select("latitude,longitude")->get_where("tb_trucks_data", ['id' => $vehicle_id], 1, 0);
        if ($imei1->num_rows() > 0) {
            $mbl = $imei1->row();
            if ($lat > 0 && $lng > 0 && $mbl->latitude > 0 && $mbl->longitude > 0) {
                $d = [];
            }
            $dist = distancemetrixship($lat, $lng, $mbl->latitude ?? null, $mbl->longitude ?? null);
            $d['distance'] = $dist['disttext'];
            $d['duration'] = $dist['duratext'];
            $rr[0] = $d['distance'];
            $rr[1] = $d['duration'];
        }
        return $rr;
    }

    public function sendBulkAlert($trip, $emp, $mobile, $name, $drivernum, $veh, $link, $user_id, $curtz)
    {
        $result = [];
        if ($drivernum != "") {
            $drivernum = "(" . $drivernum . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }
        $logdate = date('Y-m-d H:i:s');
        /*$getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);
        $senddate = $getactual['datetime'];*/
        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " is started now,track your truck by " . $link;
        $smsdata = ["sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $logdate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0];
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = [
            "mobile" => $mobile,
            "message" => $message,
            "id" => $sentid
        ];
        $fire_ret = @$this->sendfirebase->sendSinglePush(["title" => "Truck Auto Arrival Alert Once", "message" => $message, "emp_id" => $emp, 'type' => 'Driver']);
        /*$sendack = $this->smsnotifier->driverarrivalsms($smsdata);*/
        return $result;
    }

    public function sendAlert($trip, $emp, $mobile, $name, $distance, $veh, $link, $user_id, $curtz)
    {
        $result = [];
        $this->db->select('d.contact_num');
        $this->db->from('tb_truck_drivers d');
        $this->db->join('tb_trips t', 'd.id=t.driver_id', 'INNER');
        $this->db->where('t.id', $trip);
        $this->db->limit(1);
        $drivermobile = $this->db->get();
        $drivernum = "";
        if ($drivermobile->num_rows() > 0) {
            $drivernum = "(" . $drivermobile->row()->contact_num . ")";
        }
        if ($curtz == "") {
            $curtz = date_default_timezone_get();
        }
        /*$logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);*/
        $senddate = date('Y-m-d H:i:s');
        $message = "Dear Customer,Your shipment ($name) in truck $veh " . $drivernum . " will be reached in " . $distance[1] . ", it is in distance " . $distance[0] . ",track your truck by " . $link;
        $smsdata = ["sent_to" => $mobile, "module" => "Truck Auto Arrival Alert Once", "user_id" => $user_id, "message" => $message, "emp_id" => $emp, "trip_id" => $trip, 'callcenter' => 0, 'sent_on' => $senddate, 'latitude' => 0, 'longitude' => 0, 'register_number' => "", 'alert_reason' => 'sent from driver mobile', 'response' => '', 'status' => 0];
        $ins = $this->db->insert("tbl_sms_logs", $smsdata);
        $sentid = $this->db->insert_id();
        $result = [
            "mobile" => $mobile,
            "message" => $message,
            "id" => $sentid
        ];
        if ($user_id == "") {
            $user_id = 0;
        }
        $datas = [
            "emp_id" => $emp,
            "trip_id" => $trip,
            "mobile" => $mobile,
            "message" => $message,
            "user_id" => $user_id,
            "created_on" => $senddate,
        ];
        $ins = $this->db->insert("tb_trip_alerts", $datas);
        $fire_ret = @$this->sendfirebase->sendSinglePush(["title" => "Truck Auto Arrival Alert", "message" => $message, "emp_id" => $emp, 'type' => 'Driver']);
        /*$sendack = $this->smsnotifier->driverarrivalsms($smsdata);*/
        return $result;
    }

    public function closeTrip()
    {
        ob_start();
        if ($_POST) {
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"] = $_POST["trip_id"];
            if ($data["id"] != "") {
                $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
                $trip_id = $data["id"] = trim($data["id"]);
                $gettrip = $this->db->select("shift_id")->get_where("tb_trips", [
                    "id" => $data["id"],
                    "status" => 1
                ], 1, 0);
                if ($gettrip->num_rows() > 0) {
                    if ( checkTripEligibleForClose($data["id"]) === 0) {
                        echo json_encode(Printable::printable(["status" => "0", "message" => "Failed to Close, Please deliver remaining shipments of this trip"]));
                    } else {
                        $shiftid = $gettrip->row()->shift_id;
                        $end_imei = $_POST["imei"] ?? ' ';
                        $end_reading = $_POST["odometer"] ?? '0';
                        $latitude = $_POST["latitude"] ?? '';
                        $longitude = $_POST["longitude"] ?? '';
                        $shipment_id = $_POST["shipment_id"] ?? $shiftid;

                        if ($shipment_id == "") {
                            $shipment_id = $shiftid;
                        }

                        $availableOrders = [];
                        $checkOrderStops = $this->db->query("
                            SELECT order_id, user_id
                            FROM tb_employee
                            WHERE shift_id = ?
                              AND status = 1
                        ", [$shipment_id]);

                        if ($checkOrderStops->num_rows() > 0) {
                            $availableOrders = $checkOrderStops->result_array();
                        }
                        $driver_id = $data["driver_id"];
                        $vehicle_id = "";
                        $assigned_drivers = $this->db->select("vehicle_id")
                            ->where([
                                "status" => "1",
                                "driver_id" => $driver_id
                            ])
                            ->get("tbl_assigned_drivers");

                        if ($assigned_drivers->num_rows() > 0) {
                            $vehicle_id = $assigned_drivers->row()->vehicle_id;
                        }

                        $orderData = [
                            "trip_id" => $trip_id,
                            "curtz" => $curtz,
                            "shipment_id" => $shipment_id,
                            "end_imei" => $end_imei,
                            "end_reading" => $end_reading,
                            "dlat" => $latitude,
                            "dlng" => $longitude,
                            "driver_id" => $data["driver_id"],
                            "vehicle_id" => $vehicle_id
                        ];
                        /* check trip is multi leg or not */
                        $checkMultiLegs = $this->common->gettblrowdata([
                            'id' => $shipment_id,
                            'status' => 1,
                            'shift_leg_id >' => 0
                        ],"id","tb_shifts",0,0);
                        
                        if (!empty($checkMultiLegs)) {
                            $tripResponse = $this->updateCrossBroderOrders($availableOrders, $orderData);
                        } else {
                            $tripResponse = $this->updateMultiOrdersTrip($availableOrders, $orderData);
                        }

                        if (!empty($tripResponse)) {
                            if (!empty($availableOrders)) {
                                $userId = $availableOrders[0]['user_id'] ?? 0;
                                $getHours = $this->db->query("
                                    SELECT c.cntry_hrs
                                    FROM tbl_country_master c, tb_users u
                                    WHERE c.country_code = u.country_code
                                      AND u.id= ?
                                      AND c.status = 1
                                    LIMIT 1", [$userId]);
                                if ($getHours->num_rows() > 0) {
                                    $hrs = $getHours->row()->cntry_hrs;
                                } else {
                                    $hrs = self::DEFAULT_HOURS;
                                }

                                $companyCodeForOrder = $this->common->gettblrowdata(["order_id" => $tripResponse['order_id']], "company_code", "tb_orders", 0, 0);
                                $companyCode = $companyCodeForOrder['company_code'] ?? '';

                                $payload = CloseTripPayloadFactory::create(
                                    StopUnitsPartiallyPicked::isStopUnitsPartiallyPicked($this->db, $shipment_id),
                                    $shipment_id, $trip_id, $data['driver_id'], $tripResponse['order_id'],
                                    $latitude, $longitude, $curtz, $hrs, $companyCode,  new \DateTime()
                                );
                                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_CLOSE_TRIP, $payload));

                                $curdt = date('Y-m-d H:i:s');
                                $driver_id = $data["driver_id"];
                                $vehicle_id = "";
                                $assigned_drivers = $this->db->select("vehicle_id")
                                    ->where([
                                            "status" => "1",
                                            "driver_id" => $driver_id]
                                    )->get("tbl_assigned_drivers");
                                if ($assigned_drivers->num_rows() > 0) {
                                    $vehicle_id = $assigned_drivers->row()->vehicle_id;
                                }
                                $available_orders = $this->db->query("
                                    SELECT e.order_id
                                    FROM tb_employee e
                                    WHERE e.shift_id = ?
                                      AND e.status = 1", [$shiftid]);

                                if ($available_orders->num_rows() > 0) {
                                    foreach ($available_orders->result() as $row) {
                                        $selcted_order_id = $row->order_id;
                                        $orders = $this->db->where([
                                            "order_id" => $selcted_order_id
                                        ])->get("tb_orders");
                                        $selected_order = '';
                                        if ($orders->num_rows() > 0) {
                                            $selected_order = $orders->row()->id;
                                        }
                                        $tb_stop_status = [
                                            "order_id" => $selected_order,
                                            "shipment_id" => $shiftid,
                                            "stop_id" => 0,
                                            "stop_detail_id" => 0,
                                            "stop_type" => "",
                                            "trip_id" => $trip_id,
                                            "status_id" => 299,
                                            "latitude" => $latitude,
                                            "longitude" => $longitude,
                                            "loc_name" => null,
                                            "status_code" => "SV0610",
                                            "status" => 1,
                                            "reason" => "From Mobile",
                                            "vehicle_id" => $vehicle_id,
                                            "driver_id" => $driver_id,
                                            "sentknlogin" => 0,
                                            "createdon" => $curdt,
                                            "updatedon" => $curdt,
                                        ];
                                        $checkOrderStatus = $this->common->gettblrowdata(["order_id" => $selected_order,
                                            "shipment_id" => $shiftid,"status_code" => "SV0610", "status" => 1], "id", "tb_stop_status", 0, 0);
                                            
                                        if (empty($checkOrderStatus)) {
                                            $this->db->insert("tb_stop_status", $tb_stop_status);
                                            
                                        }
                                        if (strlen($selcted_order_id) > 0) {
                                            $active_shifts = $this->db->query("
                                                SELECT s.*
                                                FROM tb_shifts s
                                                LEFT JOIN tb_employee e
                                                    ON e.order_id = ?
                                                WHERE s.id = e.shift_id
                                                  AND e.status = 1
                                                  AND s.status = 1", [$selcted_order_id]);
                                                
                                            if ($active_shifts->num_rows() == 0) {
                                                $this->db->where([
                                                    "order_id" => $selcted_order_id
                                                ])->update("tb_orders", ["trip_sts" => '1']);

                                                $shipmentstatus = 0;
                                                $getships = $this->db->select("shift_leg_id")
                                                    ->get_where("tb_shifts", [
                                                        "id" => $shiftid
                                                    ], 1, 0);

                                                if ($getships->num_rows() > 0) {
                                                    $shift_leg_id = $getships->row()->shift_leg_id;
                                                    $getshipsstatusRes = $this->db->query("
                                                        SELECT id, status
                                                        FROM tb_shifts
                                                        WHERE shift_leg_id = ?
                                                    ", [$shift_leg_id]);

                                                    if ($getshipsstatusRes->num_rows() > 0) {
                                                        foreach ($getshipsstatusRes->result() as $shipsstatus) {
                                                            if ($shipsstatus->status == 0) {
                                                                $shipmentstatus++;
                                                            }
                                                        }
                                                    }

                                                    if ($getshipsstatusRes->num_rows() == $shipmentstatus) {
                                                        $this->db->where([
                                                            "id" => $shift_leg_id
                                                        ])->update("tb_shifts", ["status" => '0']);
                                                    }
                                                }
                                                
                                            }
                                        }
                                        try {
                                            $statusPayload = [
                                                "trip" => $trip_id,
                                                "ship" => $shiftid,
                                                "ord_id" => $selected_order,
                                                "orderid" => $selcted_order_id,
                                                "stopid" => 0,
                                                "stopdetailid" => 0,
                                                "vehicle_id" => $vehicle_id,
                                                "driver_id" => $driver_id,
                                                "stop_type" => "D",
                                                "timezone" => "",
                                                "sts_date" => $curdt,
                                                "status_code" => "SV0610"
                                            ];
                                            $domainDetails = $this->OtmBookingModel->getDomain($selcted_order_id);
                                            if (!empty($domainDetails)) {
                                                $extOrderId = $domainDetails[0]['external_order_id'];
                                                $domainName = $domainDetails[0]['ref_value'];
                                                $domainCreatedSource = $domainDetails[0]['created_source'];
                                                if($domainName<>"") {
                                                    $otmRequest = [
                                                        'glogDate' => date("Ymdhis"),
                                                        'externalOrderId' => $extOrderId,
                                                        'orderStatusDateTime' => $curdt,
                                                        'domainName' => $domainName,
                                                        'createdSource'=> $created_source ? $created_source :  $domainCreatedSource,
                                                        'timeZone' =>$curtz ?? "",
                                                        'orderStatusCode' => "SV0120",
                                                    ];
                                                    $output = sendOTMStatus($otmRequest); 
                                                }
                                            }
                                            $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                                            $this->altovaordercreation->sendOrderToAltova($selected_order, "SV0610");
                                        } catch (Exception $ex) {
                                            log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                                        }
                                    }
                                }

                                ob_end_clean();
                                echo json_encode(
                                    Printable::printable(["status" => "1", "message" => "Closed Successfully"])
                                );
                            } else {
                                echo json_encode(
                                    Printable::printable(["status" => "0", "message" => "Failed to Close, No orders available"])
                                );
                            }
                        } else {
                            echo json_encode(Printable::printable(["status" => "0", "message" => "Failed to Close"]));
                        }
                    }
                } else {
                    echo json_encode(Printable::printable(["status" => "0", "message" => "Failed to Close, No active trip found"]));
                }
            } else {
                echo json_encode(Printable::printable(["status" => "0", "message" => "Failed to Close, Trip id doesn't exist"]));
            }
        } else {
            echo json_encode(Printable::printable(["status" => "0", "message" => "Insufficient Input Data"]));
        }
    }

    private function updateMultiOrdersTrip($availableOrders, $orderData)
    {
        $tripResponse = [];
        $curdt = date('Y-m-d H:i:s');
        $shipmentData = [
            "status" => 0,
            "updated_on" => $curdt
        ];
        $shipmentIdData = [
            "id" => $orderData['shipment_id']
        ];
        $this->db->where($shipmentIdData)->update("tb_shifts", $shipmentData);
        $tripIdData = [
            "id" => $orderData['trip_id']
        ];
        $tripData = [
            "status" => 0,
            "dlat" => $orderData['dlat'],
            "dlng" => $orderData['dlng']
        ];

        $this->db->where($tripIdData)->update("tb_trips", $tripData);
        foreach($availableOrders as $row){
            $orderNumber = $row['order_id'];
            $tripResponse['order_id'] = $row['order_id'];
            $orders = $this->db->select("id")->get_where("tb_orders", [
                "order_id" => $orderNumber,
                "trip_sts" => 0
            ], 1, 0);
            if ($orders->num_rows() > 0) {
                $selected_order = $orders->row()->id;
                $this->db->where([
                    "id" => $selected_order
                ])->update("tb_orders", ["trip_sts" => 1]);
                $tb_stop_status = [
                    "order_id" => $selected_order,
                    "shipment_id" => $orderData['shipment_id'],
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => "",
                    "trip_id" => $orderData['trip_id'],
                    "status_id" => 299,
                    "latitude" => $orderData['dlat'],
                    "longitude" => $orderData['dlng'],
                    "loc_name" => null,
                    "status_code" => "SV0610",
                    "status" => 1,
                    "reason" => "From Mobile",
                    "vehicle_id" => $orderData['vehicle_id'],
                    "driver_id" => $orderData['driver_id'],
                    "sentknlogin" => 0,
                    "createdon" => $curdt,
                    "updatedon" => $curdt,
                ];
                $checkOrderStatus = $this->common->gettblrowdata(["order_id" => $selected_order, "status_code" => "SV0610", "status" => 1], "id", "tb_stop_status", 0, 0);
                if (empty($checkOrderStatus)) {
                    $this->db->insert("tb_stop_status", $tb_stop_status);
                }
            }
        }
        try {
            $payload = CloseTripSummaryPayloadFactory::create($orderData['trip_id'], $orderData['curtz']);
            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_CLOSE_TRIP_GENERATE_SUMMARY, $payload));
        } catch (Exception $exception) {
            log_message("error", $exception->getMessage());
            echo json_encode(Printable::printable([
                "status" => "0",
                "message" => "Trip was closed but summary was not generated."
            ]));
        }
        return $tripResponse;
    }

    private function getRecentOrderTrip($shipmentid ,$tripid)
    {
        $orderResponse = [];
        $statusQuery = $this->db->query("SELECT s.order_id, o.id
            FROM tb_stop_status s, tb_orders o
            WHERE s.order_id = o.id
              AND s.shipment_id = ?
              AND s.trip_id = ?
              AND o.trip_sts = 0
            ORDER BY s.createdon DESC
            LIMIT 1",
            [$shipmentid, $tripid]
        );
        
        if($statusQuery->num_rows()>0){
            $orderResponse['id'] = $statusQuery->row()->id;
            $orderResponse['order_id'] = $statusQuery->row()->order_id;
        }
        return $orderResponse;
    }

    private function updateCrossBroderOrders($availableOrders,$orderData): array
    {
        $curdt = date('Y-m-d H:i:s');
        $tripResponse = [];
        $shipmentData = [
            "status" => 0,
            "updated_on" => $curdt
        ];
        $shipmentIdData = [
            "id" => $orderData['shipment_id']
        ];
        $this->db->where($shipmentIdData)->update("tb_shifts", $shipmentData);
        $tripIdData = [
            "id" => $orderData['trip_id']
        ];
        $tripData = [
            "status" => 0,
            "dlat" => $orderData['dlat'],
            "dlng" => $orderData['dlng']
        ];
        $updateTrip = $this->db->where($tripIdData)->update("tb_trips", $tripData);

        if (!$updateTrip) {
            return [];
        }

        foreach ($availableOrders as $row) {
            $orderNumber = $row['order_id'];
            $tripResponse['order_id'] = $row['order_id'];
            $active_shifts = $this->db->query("SELECT s.id
                FROM tb_shifts s
                LEFT JOIN tb_employee e ON e.order_id = ?
                WHERE s.id = e.shift_id
                  AND e.status = 1
                  AND s.status = 1",
                [$orderNumber]
            );

            if ($active_shifts->num_rows() == 0) {
                $shipmentstatus = 0;
                $getships = $this->db->select("shift_leg_id")->get_where("tb_shifts", [
                    "id" => $orderData['shipment_id'],
                    "shift_leg_id !=" => 0
                ], 1, 0);
                
                if ($getships->num_rows() > 0) {
                    $shift_leg_id = $getships->row()->shift_leg_id;
                    $getshipsstatusRes = $this->db->query("SELECT id, status
                        FROM tb_shifts
                        WHERE shift_leg_id = ?",
                        [$shift_leg_id]
                    );
                    
                    $statusResults = $getshipsstatusRes->num_rows();
                    if ($statusResults > 0) {
                        foreach ($getshipsstatusRes->result() as $shipsstatus) {
                            if ($shipsstatus->status == 0) {
                                $shipmentstatus++;
                            }
                        }
                    }
                    if ($statusResults == $shipmentstatus) {
                        $this->db->where(["id" => $shift_leg_id])->update("tb_shifts", ["status" => 0]);
                    }
                }
            }
        }

        try {
            $payload = CloseTripSummaryPayloadFactory::create($orderData['trip_id'], $orderData['curtz']);
            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_CLOSE_TRIP_GENERATE_SUMMARY, $payload));
        } catch (Exception $exception) {
            log_message("error", $exception->getMessage());
            echo json_encode(Printable::printable([
                "status" => "0",
                "message" => "Trip was closed but summary was not generated."
            ]));
        }

        return $tripResponse;
    }

    public function closeTripfromweb()
    {
        ob_start();
        if ($_POST) {
            $doneby = $this->session->userdata("user_id");
            /*log_message('error', "close_statusweb ".$doneby." ".json_encode($_POST));*/
            $data1 = $data = [];
            $data["driver_id"] = $_POST["driver_id"];
            $data["id"] = $_POST["trip_id"];
            $curtz = date_default_timezone_get();
            if ($curtz == "") {
                $curtz = "Asia/Singapore";
            }
            $chk = $this->db->select("shift_id,vehicle_id,plat,plng")->get_where("tb_trips", ["id" => $data["id"], "status" => 1], 1, 0);
            if ($chk->num_rows() > 0) {
                $trip_id = $data["id"] = trim($data["id"]);
                $logdate = date('Y-m-d H:i:s');
                $vehicle_id = $chk->row()->vehicle_id;
                $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                $curdt = $getactual['datetime'];
                $shipment_id = $chk->row()->shift_id;
                if ($shipment_id > 0) {
                    $upd = $this->db->where(["id" => $shipment_id])->update("tb_shifts", ["status" => '0', "updated_on" => $curdt]);
                    $upd = $this->db->where(["shift_id" => $shipment_id])->update("tb_orders", ["trip_sts" => '1']);
                }
                $data1["end_imei"] = isset($_POST["imei"]) ? $_POST["imei"] : ' ';
                $data1["end_reading"] = isset($_POST["odometer"]) ? $_POST["odometer"] : '';
                $data1["etime"] = $data1["updated_on"] = $curdt;
                $trucks_query = $this->db->query("select latitude,longitude from tb_trucks_data WHERE id=$vehicle_id LIMIT 1");
                $data1["status"] = '0';
                $data1["dlat"] = $chk->row()->plat;
                $data1["dlng"] = $chk->row()->plng;
                if ($trucks_query->num_rows() > 0) {
                    if ($trucks_query->row()->latitude != "") {
                        $data1["dlat"] = $trucks_query->row()->latitude;
                        $data1["dlng"] = $trucks_query->row()->longitude;
                    }
                }
                $res = $this->db->where($data)->update("tb_trips", $data1);
                $send = $this->generatewebsummary($data["id"], $curtz);
                $shift = $this->db->select('user_id,order_id')->order_by('id', 'DESC')->where(["shift_id" => $shipment_id, 'ship_type' => 'P'])->get("tb_employee")->row();
                $uid = $shift->user_id;
                $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                if ($gethrs->num_rows() > 0) {
                    $hrs = $gethrs->row()->cntry_hrs;
                } else {
                    $hrs = self::DEFAULT_HOURS;
                }
                $postdata = [
                    "shipment_id" => $shipment_id,
                    "trip_id" => $data["id"],
                    "driver_id" => $data["driver_id"],
                    "stop_id" => '',
                    "order_id" => $shift->order_id,
                    "latitude" => "",
                    "longitude" => "",
                    "curtz" => $curtz,
                    "hrs" => $hrs,
                ];
                $stop_closed = StopUnitsPartiallyPicked::isStopUnitsPartiallyPicked($this->db, $shipment_id);
                if ($stop_closed) {
                    /*$sts = $this->statusintigration->shipmentdeliveredpartially($postdata);*/
                    /*send to roadlog*/
                    $sts = $this->statusintigration->roadlogshipmenttripdeliverpartial($postdata);
                } else {
                    /*$sts = $this->statusintigration->shipmentdelivered($postdata);*/
                    /*send to roadlog*/
                    $sts = $this->statusintigration->roadlogshipmenttripdelivered($postdata);
                }
                
                $curdt = date('Y-m-d H:i:s');
                $driver_id = $data["driver_id"];
                $vehicle_id = "";
                $assigned_drivers = $this->db->select("vehicle_id")->where(["status" => "1", "driver_id" => $driver_id])->get("tbl_assigned_drivers");
                if ($assigned_drivers->num_rows() > 0) {
                    $vehicle_id = $assigned_drivers->row()->vehicle_id;
                }
                $available_orders = $this->db->query("SELECT e.order_id FROM tb_employee e WHERE e.shift_id=$shipment_id AND e.status=1");
                if ($available_orders->num_rows() > 0) {
                    foreach ($available_orders->result() as $row) {
                        $selcted_order_id = $row->order_id;
                        $orders = $this->db->where(["order_id" => $selcted_order_id])->get("tb_orders");
                        $selected_order = '';
                        if ($orders->num_rows() > 0) {
                            $selected_order = $orders->row()->id;
                        }
                        $tb_stop_status = [
                            "order_id" => $selected_order,
                            "shipment_id" => $shipment_id,
                            "stop_id" => 0,
                            "stop_detail_id" => 0,
                            "stop_type" => "",
                            "trip_id" => $trip_id,
                            "status_id" => 299,
                            "latitude" => "",
                            "longitude" => "",
                            "loc_name" => null,
                            "status_code" => "SV0610",
                            "status" => 1,
                            "reason" => "From Admin",
                            "vehicle_id" => $vehicle_id,
                            "driver_id" => $driver_id,
                            "sentknlogin" => 0,
                            "createdon" => $curdt,
                            "updatedon" => $curdt,
                        ];
                        $this->db->insert("tb_stop_status", $tb_stop_status);
                        if (strlen($selcted_order_id) > 0) {
                            $domainDetails = $this->OtmBookingModel->getDomain($selcted_order_id);
                           
                            if (!empty($domainDetails)) {
                                $extOrderId = $domainDetails[0]['external_order_id'];
                                $domainName = $domainDetails[0]['ref_value'];
                                $domainCreatedSource = $domainDetails[0]['created_source'];
                                if($domainName != ""){
                                    $otmRequest = [
                                        'glogDate' => date("Ymdhis"),
                                        'externalOrderId' => $extOrderId,
                                        'orderStatusDateTime' => $curdt,
                                        'domainName' => $domainName,
                                        'createdSource'=> $created_source ? $created_source :  $domainCreatedSource,
                                        'timeZone' =>$curtz ?? "",
                                        'orderStatusCode' => "SV0610",
                                    ];
                                   
                                    $output = sendOTMStatus($otmRequest);
                                }
                            }
                            $active_shifts = $this->db->query("SELECT s.* FROM tb_shifts s LEFT JOIN tb_employee e ON e.order_id = " . $selcted_order_id . " WHERE s.id = e.shift_id AND e.status=1 AND s.status=1");
                            
                            if ($active_shifts->num_rows() == 0) {
                                $this->db->where(["order_id" => $selcted_order_id])->update("tb_orders", ["trip_sts" => '1']);

                                
                                $shipmentstatus = 0;
                                $getships = $this->db->select("shift_leg_id")->get_where("tb_shifts", ["id" => $shipment_id], 1, 0);
                                
                                if ($getships->num_rows() > 0) {
                                    $shift_leg_id = $getships->row()->shift_leg_id;
                                    $getshipsstatus = "SELECT id,status FROM tb_shifts WHERE shift_leg_id='$shift_leg_id' ";
                                    
                                    $getshipsstatusRes = $this->db->query($getshipsstatus);
                                    if ($getshipsstatusRes->num_rows() > 0) {
                                        foreach ($getshipsstatusRes->result() as $shipsstatus) {
                                            if ($shipsstatus->status == 0) {
                                                $shipmentstatus++;
                                            }
                                        }
                                    }
                                    if ($getshipsstatusRes->num_rows() == $shipmentstatus) {
                                        $upd = $this->db->where(["id" => $shift_leg_id])->update("tb_shifts", ["status" => '0']);
                                    }
                                }
                                
                            }
                        }
                    }
                }
            }
        }
        redirect("dashboard/livecabdetails");
    }

    public function checkLatLng($emp)
    {
        $sql = $this->db->select("plat,plng")->get_where("tb_employee", ["id" => $emp], 1, 0);
        if ($sql->num_rows() > 0) {
            $res = $sql->row();
            if ($res->plat == "" || $res->plng == "") {
                return "true";
            } else {
                return "false";
            }
        } else {
            return "false";
        }
    }

    public function generatewebsummary($tripid = null, $curtz = null)
    {
        if ($tripid != "") {
            $dist = $trip_type = $totalemp = $uid = 0;
            if ($curtz == "") {
                $curtz = date_default_timezone_get();
            }
            $logdate = date('Y-m-d H:i:s');
            $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
            $curdt = $getactual['datetime'];
            $reg = "";
            $sql = $this->db->query("SELECT shift_id,vehicle_id,driver_id,convertToClientTZ(stime,'" . $curtz . "') as stime,convertToClientTZ(etime,'" . $curtz . "') as etime,etime as tetime, start_imei, end_imei, start_reading, end_reading,trip_type,plat,plng,dlat,dlng FROM tb_trips WHERE id=$tripid AND status=0 LIMIT 1");
            if ($sql->num_rows() > 0) {
                $data = [];
                $data['driver_name'] = $data['driver_num'] = "";
                $data["tripinfo"] = $sql->row();
                $shift = $sql->row()->shift_id;
                $sql1 = $this->db->query("SELECT user_id,stime as setime,convertToClientTZ(startdate,'" . $curtz . "') as startdate, convertToClientTZ(enddate,'" . $curtz . "') as enddate,splace,eplace FROM tb_shifts WHERE id=" . $shift . " LIMIT 1");
                
                $data["trip"] = $sql1->row();
                $order_id = "";
                $emp1 = $this->db->query("select e.name,convertToClientTZ(te.stime,'" . $curtz . "') as in_time,te.status as emp_status,te.driver_late,te.emp_late,te.absent_reason,m.material,e.shipment_volume,e.shipment_weight,e.order_id from tb_employee e,tb_trip_employee te,tb_materials m WHERE te.employee_id=e.id AND m.id=e.material_id AND te.trip_id=" . $tripid);
                if ($emp1->num_rows() > 0) {
                    $order_id = $emp1->row()->order_id;
                }
                if ($order_id == "") {
                    $order = $this->db->query("select order_id from tb_employee WHERE shift_id=" . $shift . " LIMIT 1");
                    if ($order->num_rows() > 0) {
                        $order_id = $order->row()->order_id;
                    }
                }
                $emp = $this->db->query("SELECT IFNULL(SUM(IF(e.status='1',1,0)),0) AS attcnt, count(e.employee_id) AS totcnt FROM  tb_trip_employee e WHERE e.trip_id=" . $tripid);
                $start = $sql->row()->stime;
                $end = $sql->row()->etime;
                $imei = $sql->row()->start_imei;
                $eimei = $sql->row()->end_imei;
                $driverid = $sql->row()->driver_id;
                $vehicleid = $sql->row()->vehicle_id;
                $stime = $sql1->row()->startdate;
                $etime = $sql1->row()->enddate;
                $uid = $sql1->row()->user_id;
                $odometer_start = trim($sql->row()->start_reading);
                $odometer_end = trim($sql->row()->end_reading);
                $trip_type = $sql->row()->trip_type;
                $vendor_id = 0;
                $trucks_query = $this->db->query("select truck_capacity,register_number,vendor_id,truck_weight,truck_volume from tb_trucks_data WHERE id=$vehicleid LIMIT 1");
                $cab_capacity = $truck_weight = $truck_volume = 0;
                if ($trucks_query->num_rows() > 0) {
                    $cab_capacity = $trucks_query->row()->truck_capacity;
                    $reg = $trucks_query->row()->register_number;
                    $vendor_id = $trucks_query->row()->vendor_id;
                    $truck_weight = $trucks_query->row()->truck_weight;
                    $truck_volume = $trucks_query->row()->truck_volume;
                }
                if ($cab_capacity == "") {
                    $cab_capacity = 0;
                }
                $regg = $this->db->query("select name,contact_num,vendor_id from tb_truck_drivers WHERE id=$driverid LIMIT 1");
                if ($regg->num_rows() > 0) {
                    $data['driver_name'] = $regg->row()->name;
                    $data['driver_num'] = $regg->row()->contact_num;
                    $vnid = $regg->row()->vendor_id;
                    if ($vendor_id == 0 && $vnid != 0) {
                        $vendor_id = $vnid;
                    }
                }
                // if($order_id != ""){
                //     $upd = $this->db->where(array("order_id"=>$order_id))->update("tb_orders",array("trip_sts"=>'1'));
                // }else{
                //     $upd = $this->db->where(array("trip_id"=>$tripid))->update("tb_orders",array("trip_sts"=>'1'));
                // }

                $sql2 = $this->db->query("select latitude,longitude,convertToClientTZ(`timestamp`,'" . $curtz . "') as timestamp FROM tb_rtdrive_locations WHERE mobileimei='" . $imei . "' and timestamp<='$end' and timestamp>='$start' order by timestamp asc");
                $flag = 0;
                $lat = $lng = 0;
                $wflag = 0;
                $dist = 0;
                if ($sql2->num_rows() > 0) {
                    foreach ($sql2->result() as $row) {
                        if ($flag == 0) {
                            $flag = 1;
                        } else {
                            $a = calculateDistance12($lat, $lng, $row->latitude, $row->longitude);
                            $dist = $dist + $a;
                        }
                        $lat = $row->latitude;
                        $lng = $row->longitude;
                    }
                }
                $attendemp = 0;
                $totalemp = getempcount($tripid);
                if ($emp->num_rows() > 0) {
                    $attendemp = $emp->row()->attcnt;
                }
                $data["noofemp"] = $totalemp;
                $driver_late = 0.00;
                $setime = date("Y-m-d H:i:s", strtotime($sql1->row()->setime));
                $tetime = date("Y-m-d H:i:s", strtotime(date("H:i:s", strtotime($sql->row()->tetime))));
                $to_time = strtotime($setime);
                $from_time = strtotime($tetime);
                if ($from_time > $to_time) {
                    $driver_late = round(abs($from_time - $to_time) / 60, 2);
                }
                $arr = ['trip_id' => $tripid, 'vehicle_id' => $vehicleid, 'driver_id' => $driverid, 'vendor_id' => $vendor_id, 'trip_distance' => $dist, 'no_of_emp' => $totalemp, 'attended_emp' => $attendemp, 'start_imei' => $imei, 'end_imei' => $eimei, 'start_time' => $stime, 'end_time' => $etime, 'user_id' => $uid, 'cab_capacity' => $cab_capacity, 'trip_status' => 1, 'trip_type' => $trip_type, 'ship_delay' => $driver_late, 'createdon' => $curdt];
                $chktrip = $this->db->select("id")->get_where("tb_trip_summary", ["trip_id" => $tripid], 1, 0);
                if ($chktrip->num_rows() == 0) {
                    $res = $this->db->insert("tb_trip_summary", $arr);
                }
                $data["trip_id"] = $tripid;
                $shifttime = 0;
                if ($trip_type != 2) {
                    $shti = $sql1->row()->startdate;
                    $shifttime = date('H:i A', strtotime($shti));
                } else {
                    $shifttime = "Empty";
                }
                $data["driver_late"] = $driver_late;
                $data["empshifttime"] = $shifttime;
                $data["distance"] = $dist;
                $data["stime"] = $stime;
                $data["etime"] = $etime;
                $data["simei"] = $imei;
                $data["eimei"] = $eimei;
                if ($odometer_end == "") {
                    $odometer_end = 0;
                }
                if ($odometer_start == "") {
                    $odometer_start = 0;
                }
                $data["odometer"] = ($odometer_end - $odometer_start);
                $data["page_title"] = "Trip Report";
                $data["capacity"] = $cab_capacity;
                $data["employees"] = $emp1;
                $data["trip_type"] = $trip_type;
                $data["register_number"] = $reg;
                $data["truck_weight"] = $truck_weight;
                $data["truck_volume"] = $truck_volume;
                $data["ep"] = "";
                $getusermail = $this->db->select("name,emailid,cc_mails,address")->get_where("tb_users", ["id" => $uid, "emailid !=" => ""], 1, 0);
                if ($getusermail->num_rows() > 0) {
                    $receivemail = $getusermail->row()->emailid;
                    $receivename = $getusermail->row()->name;
                    $receivecc = $getusermail->row()->cc_mails;
                    $data["ep"] = $getusermail->row()->address;
                    $insertdata = @[
                        'trip_id' => $tripid,
                        'shift_id' => $shift,
                        'splace' => $data["trip"]->splace,
                        'eplace' => $data["trip"]->eplace,
                        'stime' => $stime,
                        'etime' => $etime,
                        'capacity' => $cab_capacity,
                        'simei' => $data['simei'],
                        'eimei' => $data['eimei'],
                        'totcnt' => $totalemp,
                        'attcnt' => $attendemp,
                        'distance' => $data['distance'],
                        'odometer' => $data['odometer'],
                        'driver_late' => $data['driver_late'],
                        'receivemail' => $receivemail,
                        'receivename' => $receivename,
                        'user_id' => $uid,
                        'createdon' => $curdt
                    ];
                    $repotmaildata = $this->db->insert('tb_trips_mails', $insertdata);
                    $this->load->library('email');
                    $this->email->to($receivemail, $receivename);
                    if ($receivecc != "") {
                        $this->email->cc($receivecc);
                    }
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    if ($trip_type == 1) {
                        $this->email->subject('svkonekt: Return Trip Status');
                    } elseif ($trip_type == 2) {
                        $this->email->subject('svkonekt: Empty Trip Status');
                    } else {
                        $this->email->subject('svkonekt: Trip Status');
                    }
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/basicreport', $data, true);
                    $this->email->message($body);
                    $sendmail = $this->email->send();
                }
            }
        }
    }

    public function savePickup($emp, $lat, $lng)
    {
        $data = [];
        $data["plat"] = $lat;
        $data["plng"] = $lng;
        $loc = getLocationName($lat, $lng);
        if (strlen($loc) > 0) {
            $type = 'P';
            $emptype = $this->db->select('ship_type')->get_where('tb_employee', ['id' => $emp], 1, 0);
            if ($emptype->num_rows() > 0) {
                $type = $emptype->row()->ship_type;
            }
            if ($type == 'P') {
                $data["pickup"] = $data["address"] = $loc;
            } else {
                $data["dlat"] = $lat;
                $data["dlng"] = $lng;
                $data['drop'] = $data["address"] = $loc;
            }
        }
        $res = $this->db->where("id", $emp)->update("tb_employee", $data);
    }

    /**
     * @throws TimezoneNotSpecifiedException
     * @throws Exception
     */
    public function poduploads()
    {
        ob_start();
        $response = ["status" => 0, "data" => "Upload Failed!"];
        
        if (!isset($_POST) || empty($_POST)) {
            throw new BadRequestException("POST data should not be empty");
        }
       
        if (isset($_POST)) {
            $latitude = $_POST['latitude'] ?? '';
            $longitude = $_POST['longitude'] ?? '';
            $status_id = $_POST['status_id'] ?? '';
            $trip_id = $_POST['trip_id'] ?? '';
            $shipment_id = $_POST['shipment_id'] ?? '';
            $stop_id = $_POST['stop_id'] ?? '';
            $stop_detail_id = $_POST['stop_detail_id'] ?? '';
            $stop_detail_type = $_POST['stop_detail_type'] ?? '';
            $driver_id = $_POST['driver_id'] ?? '';
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? '');
            $vehicle_id = $_POST['vehicle_id'] ?? '';
            $language =$_POST['lang'] ?? 'es';
            $curdt = date('Y-m-d H:i:s'); /*$getactual['datetime'];*/
            $pdfName = $fileName = "";
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = [
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => '*',
                        'overwrite' => true,
                    ];
                    $fileNameParts = explode('.', $_FILES['file_name']['name']);
                    $file_ext = @strtolower(end($fileNameParts));
                    $expensions = ["jpeg", "jpg", "png", "gif", "pdf"];
                    if (in_array($file_ext, $expensions) === false) {
                        $response = ["status" => 0, "data" => "Image Format Not Allowed"];
                    } else {
                        $this->load->library('upload', $config);
                        $this->upload->initialize($config);
                        if ($this->upload->do_upload('file_name')) {
                            $imgname = $this->upload->data();
                            $imgtype = $imgname['image_type'];
                            $fileName = $imgname['file_name'];
                            $response = ["status" => 1, "data" => "Document Uploaded Successfully!"];
                            
                            try {
                                $filePath = $imgname['full_path'];
                                $fileData = file_get_contents($filePath);
                                $base64String = base64_encode($fileData);
                                //log_message('debug', 'Base64 Encoded Image (First 500 chars): ' . substr($base64Image, 0, 500));
                            } catch (Exception $ex) {
                                    log_message('error', 'Error encoding image to base64: ' . $ex->getMessage());
                            }                            
                        } else {
                            $errors = $this->upload->display_errors();
                            $response = ["status" => 0, "data" => $errors];
                        }
                        if ($fileName != "") {
                            $stptype = $pstptype = "P";
                            $txncode = "";
                            $ordid = 0;
                            $legsorder_id = $companyCode = $branchCode = "";
                            $countryCode = "65" ;
                            if ($stop_id != "") {
                                $chkstype = $this->db->select("stoptype,txncode")->get_where("tb_shiporder_stops", ["id" => $stop_id, "status" => 1], 1, 0);
                                if ($chkstype->num_rows() > 0) {
                                    if ($chkstype->row()->stoptype == "D") {
                                        $stptype = $pstptype = $chkstype->row()->stoptype;
                                    }
                                    $txncode = $chkstype->row()->txncode;
                                }
                            }
                            $uid = 0;
                            $ord_whr = $created_source = "";
                            if ($stop_id != "") {
                                $ord_whr = " AND (e.stop_id=" . $stop_id . " OR e.drop_stopid=" . $stop_id . ") ";
                            }
                            if ($stop_detail_id != "") {
                                $ord_whr = " AND e.id=" . $stop_detail_id;
                            }
                            $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id,o.shipmentid,o.created_source,o.company_code,o.branch_code FROM tb_orders o,tb_employee e WHERE o.order_id=e.order_id AND e.shift_id='" . $shipment_id . "' AND e.status=1 $ord_whr LIMIT 1");
                            if ($chkord->num_rows() > 0) {
                                $ordid = $chkord->row()->id;
                                $legsorder_id = $chkord->row()->order_id;
                                $created_source = $chkord->row()->created_source;
                                $companyCode = $chkord->row()->company_code;
                                $branchCode = $chkord->row()->branch_code;
                                $uid = $chkord->row()->user_id;
                                if ($txncode == "") {
                                    $txncode = $chkord->row()->shipmentid;
                                }
                            }
                            $status_name = "";
                            if ($stptype == "P" && $status_id == "3") {
                                $chkdoctype = $this->common->gettblrowdata(["type_name" => "PUP", "status" => 1], "id", "tb_document_types", 0, 0);
                                if (count($chkdoctype) > 0) {
                                    $status_id = $chkdoctype['id'];
                                    $status_name = "PUP";
                                }
                            }

                            if (empty($stop_detail_id)) {
                                $stop_detail_id = null;
                            }

                            $imageSize = filesize(NEW_POD_PATH . $fileName);
                            $newUuid = $this->uuid->v4();
                            $filedata = ['stop_id' => $stop_id, "shipment_id" => $shipment_id, 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_id, 'imgpath' => $fileName, 'stop_detail_id' => $stop_detail_id, 'stop_type' => $stptype, 'user_id' => $uid, 'createdby' => $driver_id, 'order_id' => $ordid, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                            $podinsid = $this->common->insertTableData("tb_pod_uploads", $filedata);
                            
                            if($stptype == 'P' && $status_id == '278')
                            {
                                $otmDocType='APACPUP';
                            }
                            else if($stptype == 'P' && $status_id == '274')
                            {
                                $otmDocType='APACPUPESIGN';
                            }
                            else if($stptype == 'D' && $status_id == '281')
                            {
                                $otmDocType='APACPOD';
                            }
                            else if($stptype == 'D' && $status_id == '279')
                            {
                                $otmDocType='APACPODESIGN';
                            }
                            
                            $docTypeCnt = $this->common->getCount(
                                    ['order_id' => $ordid, 'doc_type' => $status_id, 'status' => 1],
                                    'tb_pod_uploads'
                                );
                            if($docTypeCnt>1){
                                $otmDocType = $otmDocType . "-" . ($docTypeCnt - 1);
                            }
                            
                            $domainDetails = $this->OtmBookingModel->getDomain($ordid);
                        	if (!empty($domainDetails)) {
                        		$extOrderId = $domainDetails[0]['external_order_id'];
                        		$domainName = $domainDetails[0]['ref_value'];
                                $domainCreatedSource = $domainDetails[0]['created_source'];
                                if($domainName<>"")
                                {
                                    $otmRequest = [
                                        'glogDate' => date("Ymdhis"),
                                        'externalOrderId' => $extOrderId,
                                        'domainName' => $domainName,
                                        'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                        'timeZone' => $curtz ?? "",
                                        'base64String' => $base64String ?? "",
                                        'docType' => $otmDocType ?? ""
                                    ];
                                            
                                    $output = sendOTMDocuments($otmRequest);
                                }
                        	}
                            if ($stop_id == "") {
                                $stop = $this->db->select('id,stoptype,txncode')->order_by('ordernumber', 'ASC')->get_where("tb_shiporder_stops", ["shipment_id" => $shipment_id], 1, 0)->row();
                                $txncode = $stop->txncode;
                                $stop_id = $stop->id;
                                $stptype = $stop->stoptype;
                            }
                            $cnt = $this->db->select('id')->get_where('tb_pod_uploads', ['trip_id' => $trip_id])->num_rows();
                            if ($cnt == 0) {
                                $cntstr = "001";
                            } else {
                                $cntstr = "00" . $cnt;
                                if ($cnt > 9) {
                                    $cntstr = "0" . $cnt;
                                }
                            }
                            $gethrs = $this->db->query("SELECT c.cntry_hrs,c.country_code FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                            if ($gethrs->num_rows() > 0) {
                                $hrs = $gethrs->row()->cntry_hrs ?? self::DEFAULT_HOURS;
                                $countryCode = $gethrs->row()->country_code ?? "65";
                            }
                            $this->load->model('completedordersmodel');
                            $getOrderDetails = $this->completedordersmodel->getOrderDetailsWithLatLngs($ordid);
                            $orderCreatedSource = $getOrderDetails['createdSource'] ?? 0;
                            if ($orderCreatedSource == '299') {
                                $this->statusintigration->sendPodToKnlogin($status_id, $ordid,1);
                            }
                            $imgtype = $imgtype ?? 'png';
                            $payload = PodUploadsPayloadFactory::create(
                                $created_source,
                                $ordid,
                                $vehicle_id,
                                $driver_id,
                                $shipment_id,
                                $trip_id,
                                $latitude,
                                $longitude,
                                $uid,
                                $curdt,
                                $curtz,
                                $hrs,
                                $stop_id,
                                $legsorder_id,
                                $txncode,
                                $cntstr,
                                $status_id,
                                $pstptype,
                                $status_name,
                                $fileName,
                                $imgtype
                            );
                            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_UPLOAD_POD, $payload));
                            if ($stptype === "D" && $status_id == "1") {
                                $chkord = $this->db->query("SELECT
                                    o.id,o.order_id,o.external_order_id,o.pickup_company, o.delivery_company, o.pickup_country, o.delivery_country, o.pickup_city, o.delivery_city,
                                    o.pickup_pincode, o.delivery_pincode, o.pickup_address1, o.pickup_address2, o.delivery_address1, o.delivery_address2, o.company_code
                                    FROM tb_orders o WHERE o.id = ? LIMIT 1", [$ordid]
                                );

                                $this->load->model('Order');
                                /**
                                 * @var Order $orderModel
                                 */
                                $orderModel = $this->Order;
                                $row = $chkord->row();
                                $orderId = $row->order_id;
                                $externalOrderId = $row->external_order_id;
                                $pickupCompany = $row->pickup_company;
                                $deliveryCompany = $row->delivery_company;
                                $pickupCountry = $row->pickup_country;
                                $deliveryCountry = $row->delivery_country;
                                $pickupCity = $row->pickup_city;
                                $deliveryCity = $row->delivery_city;
                                ### https://en.wikipedia.org/wiki/Postal_Index_Number
                                $pickupPincode = $row->pickup_pincode;
                                $deliveryPincode = $row->delivery_pincode;
                                $pickupAddress1 = $row->pickup_address1;
                                $pickupAddress2 = $row->pickup_address2;
                                $deliveryAddress1 = $row->delivery_address1;
                                $deliveryAddress2 = $row->delivery_address2;
                                $pickupAddress = empty($pickupAddress2) ? $pickupAddress1 : $pickupAddress1 . "\n" . $pickupAddress2;
                                $deliveryAddress = empty($deliveryAddress2) ? $deliveryAddress1 : $deliveryAddress1 . "\n" . $deliveryAddress2;
                                $measurements = $orderModel->getTotalMeasurementData($ordid);
                                $companyCode = $row->company_code ?? '';

                                if (empty($stop_detail_id)) {
                                    $stop_detail_id = null;
                                }

                                $trip = MakeTripObject::makeTripObject(
                                    $shipment_id, $trip_id, $driver_id, $this->db, $curtz, ''
                                );

                                $comments = [];
                                $stops = $trip->getStops();
                                if (count($stops) === 2) {
                                    foreach ($stops[0]->getActions() as $action) {
                                        if ($action->getType() === 'pickup') {
                                            $pickupAction = $action;
                                        }
                                    }
                                    foreach ($stops[1]->getActions() as $action) {
                                        if ($action->getType() === 'delivery') {
                                            $deliveryAction = $action;
                                            $comments[] = $deliveryAction->getDetails()->getComment();
                                        }
                                    }
                                }

                                if (isset($pickupAction)) {
                                    $pickupDateTime = new \DateTime($pickupAction->getDateTime());
                                } else {
                                    $pickupDateTime = null;
                                }
                                if (isset($deliveryAction)) {
                                    $deliveryDateTime = new \DateTime($deliveryAction->getDateTime());
                                } else {
                                    $deliveryDateTime = null;
                                }

                                $podData = new PodData(
                                    new Address($pickupCompany, $pickupAddress, $pickupCity, '', $pickupCountry, $pickupPincode),
                                    new Address($deliveryCompany,$deliveryAddress, $deliveryCity, '', $deliveryCountry, $deliveryPincode),
                                    $pickupDateTime,
                                    $deliveryDateTime,
                                    $orderId,
                                    $externalOrderId ?? '',
                                    NEW_POD_PATH . $fileName,
                                    $newUuid,
                                    implode("<br />", $comments),
                                    new Measurements(($measurements['quantity'] ?? 1), ($measurements['volume'] ?? 0.01), ($measurements['weight'] ?? 1)),
                                    $curtz,
                                    $companyCode
                                );
                                $payload = SignatureUploadsPayloadFactory::create(
                                    $created_source,
                                    $ordid,
                                    $vehicle_id,
                                    $driver_id,
                                    $shipment_id,
                                    $trip_id,
                                    $latitude,
                                    $longitude,
                                    $uid,
                                    $curdt,
                                    $curtz,
                                    $hrs,
                                    $stop_id,
                                    $legsorder_id,
                                    $txncode,
                                    $cntstr,
                                    $status_id,
                                    $pstptype,
                                    $status_name,
                                    $fileName,
                                    $imgtype,
                                    $podData,
                                    $stop_detail_id
                                );
                                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_UPLOAD_SIGNATURE, $payload));

                            }
                            try {
                                $documentData = [
                                    "order_id" => $ordid,
                                    "ord_id" => $legsorder_id,
                                    'country_code' => $countryCode,
                                    'company_code' => $companyCode,
                                    'branch_code' => $branchCode,
                                    'shipment_id' => $shipment_id,
                                    'trip_id' => $trip_id,
                                    'stop_id' => $stop_id,
                                    'doc_type' => $imgtype,
                                    'userid' => $uid,
                                    'filename' => $fileName
                                ];
                                $this->standard_document_execution->sendStandardDocumentXMLtoAltova($documentData);
                            } catch (Exception $ex) {
                                log_message("error", "Some Problem occured!, While Sending Order Documentto Altova " . $ex->getMessage());
                            }
                            if (!empty($trip_id) && !empty($driver_id)) {
                                $langTranslation = ['en' => 'english', 'en_US' => 'english_us', 'zh' => 'chinese', 'fr' => 'french', 'hi' => 'hindi', 'ms' => 'malay', 'ru' => 'russian', 'tl' => 'tamil', 'th' => 'thailand', 'ur' => 'urdu', 'vi' => 'vietnamese'];
                                $siteLanguage = $langTranslation[$language] ?? 'english';
                                $this->load->helper('language');
                                $this->lang->load('message_lang', $siteLanguage);
                                $PODData = $this->common->gettbldata(["trip_id" => $trip_id, "shipment_id" => $shipment_id, "status" => 1], "stop_type", "tb_pod_uploads", 0, 0);
                                foreach ($PODData as $eachRow) {
                                    $stopType[] = $eachRow["stop_type"];
                                }
                                if (in_array("P", $stopType)) {
                                    $message = $this->lang->language['origin_pupupload_gateout'];
                                }
                                if (in_array("D", $stopType)) {
                                    $message = $this->lang->language['podupload_gateout'];
                                }
                                $res = $this->shipmentDetails($trip_id, $shipment_id, $driver_id, $ordid, $curtz);
                                $messageData = json_encode(["msg" => $message, "info" => $res, "type" => 2], JSON_UNESCAPED_UNICODE);
                                $this->load->library('sendfirebase');
                                $fire_res = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driver_id, 'type' => 'Driver']);
                            }

                        }
                    }
                    
                   
                }
            }
        }

        ob_end_clean();
        
        echo json_encode(Printable::printable($response));
    }

    public function saveAsPdf($image = '')
    {
        $file = NEW_POD_PATH . $image;
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        $name = pathinfo($file, PATHINFO_FILENAME);
        $pdf = new FPDF();
        $pdf->AddPage();
        $ext = "";
        if (strtolower($ext) == "png") {
            $ext = "PNG";
        } else {
            if (strtolower($ext) == "jpg") {
                $ext = "JPG";
            } else {
                if (strtolower($ext) == "jpeg") {
                    $ext = "JPEG";
                } else {
                    if (strtolower($ext) == "gif") {
                        $ext = "GIF";
                    }
                }
            }
        }
        if (!file_exists(NEW_POD_PATH)) {
            mkdir(NEW_POD_PATH, 0710, true);
        }
        $pdf->Image($file, 10, 10, 190, 0, $ext);
        $pdf->Output(NEW_POD_PATH . $name . ".pdf", 'F');
        return $name . ".pdf";
    }

    public function stopsstatuses()
    {
        $response = ["status" => 0, "message" => "Something went wrong!"];
        $data = ['status' => 1];
        $result['yes'] = $result['no'] = [];
        $res = $this->db->select('id,status_name,status_type')->order_by('id', 'ASC')->get_where("tb_status_master", $data);
        if ($res->num_rows() > 0) {
            foreach ($res->result() as $r) {
                if ($r->status_type == 'yes') {
                    $result['yes'][] = ['id' => $r->id, 'status_name' => $r->status_name];
                } else {
                    $result['no'][] = ['id' => $r->id, 'status_name' => $r->status_name];
                }
            }
            $response = ["status" => 1, "data" => $result];
        } else {
            $response = ["status" => 0, "message" => "Something went wrong,please try again!"];
        }
        //log_message("error","11111:".json_encode($response));
        echo json_encode(Printable::printable($response));
    }

    public function shipdashboard()
    {
        $response = ["status" => 0, "message" => "Something went wrong!"];
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        if ($driver_id > 0) {
            $acc_whr = ['driver_id' => $driver_id, 'status' => 1];
            $com_whr = ['driver_id' => $driver_id, 'status' => 0];
            $rej_whr = ['driver_id' => $driver_id, 'status' => 2];
            $accepted = $this->db->select('id')->get_where('tb_trips', $acc_whr)->num_rows();
            if ($accepted > 0) {
                $accepted = $this->db->query("SELECT t.id FROM tb_trips t WHERE t.driver_id=$driver_id AND t.status=1")->num_rows();
            }
            $rejected = $this->db->select('id')->get_where('tb_trips', $rej_whr)->num_rows();
            $completed = $this->db->select('id')->get_where('tb_trips', $com_whr)->num_rows();
            $data = ['accepted' => $accepted, 'rejected' => $rejected, 'completed' => $completed];
            $response = ["status" => 1, "data" => $data];
        } else {
            $response = ["status" => 0, "message" => "Something went wrong,please try again!"];
        }
        //log_message("error","66666:".json_encode($response));
        echo json_encode(Printable::printable($response));
    }

    public function getshipments(): void
    {
        ob_start();

        /* null-new, 0-accepted , 1-in-transit, 2-completed */
        $driverId = $this->db->escape_str($_POST["driver_id"] ?? "");
        $imei = $this->db->escape_str($_POST["imei"] ?? "");

        /* For $type == 2, only completed shipments should be returned */
        $type = $this->db->escape_str($_POST["type"] ?? "");
        $returnCompleted = $this->db->escape_str($_POST["type"]) == "2";
        $search = $this->db->escape_str($_POST["search"] ?? "");

        if ($driverId == '' && $imei == '') {
            echo json_encode(Printable::printable(["status" => 0, "message" => "Not Found!"]));
            ob_end_clean();

            return;
        }

        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
        $curtzEscaped = $this->db->escape_str($curtz);

        $whr = ["id" => $driverId, "status" => "Active"];
        $getUserId = $this->db->select("id, user_id")->get_where("tb_truck_drivers", $whr, 1, 0);
        $uid = $getUserId ? ($getUserId->row()->user_id ?? 0) : 0;

        if (!isset($_POST["pman"]) || ($_POST["pman"] != '2')) {
            $this->db->where(["driver_id" => $driverId])->update("tbl_assigned_drivers", ["imei" => $imei]);
        }

        $offset = intval($_POST['offset'] ?? 0);

        $shipments = (new DriverShipmentsService(new DriverTripList()))->getShipments($offset, $driverId, $uid, $curtzEscaped, $returnCompleted, $search);
        $response = $this->createShipmentsResponseArray($shipments, $type, $driverId);

        ob_end_clean();
        //log_message("error","22222:".json_encode($response));
        echo json_encode(Printable::printable($response));
    }

    public function getorderdetailsbyshipment()
    {
        $data = [];
        $response = ["status" => 0, "data" => $data];
        if (isset($_POST)) {
            $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : 0;
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            if ($shift_id == "") {
                $shift_id = 0;
            }
            if ($shift_id != 0) {
                $getdetails = $this->common->gettbldata(['shift_id' => $shift_id], 'id', 'tb_orders', 0, 0);
                if (!empty($getdetails)) {
                    foreach ($getdetails as $res) {
                        $order_id = $res['id'];

                        $cargos_ref = $this->db->query("SELECT c.cargo_type,c.length_unit,c.width_unit,c.height_unit,c.volweight_uom,c.weight_unit,c.volume_unit,o.id as cargo_id,o.order_id as order_id,o.length,o.width,o.height,o.weight,o.volumetric_weight,o.ldm,o.volume,o.quantity,o.scanned_quantity,o.cargo_content,o.buyer_part,o.qr_code FROM tb_cargo_details c,tb_order_cargodetails o WHERE o.order_id ='" . $order_id . "' AND o.cargo_id =c.id");
                        if ($cargos_ref->num_rows() > 0) {
                            foreach ($cargos_ref->result() as $row) {
                                $scanned_quantity = $row->scanned_quantity;
                                if ($scanned_quantity == "") {
                                    $scanned_quantity = '0';
                                } else {
                                    $scanned_quantity = round($scanned_quantity);
                                }
                                $data[] = [
                                    'cargo_type' => $row->cargo_type,
                                    'cargo_content' => $row->cargo_content,
                                    'length' => $row->length,
                                    'length_unit' => $row->length_unit,
                                    'width' => $row->width,
                                    'width_unit' => $row->width_unit,
                                    'height' => $row->height,
                                    'height_unit' => $row->height_unit,
                                    'volumetric_weight' => $row->volumetric_weight,
                                    'volweight_uom' => $row->volweight_uom,
                                    'ldm' => $row->ldm,
                                    'volume' => $row->volume,
                                    'volume_unit' => $row->volume_unit,
                                    'cargo_id' => $row->cargo_id,
                                    'buyer_part' => $row->buyer_part,
                                    'qr_code' => $row->qr_code,
                                    'actual_quantity' => round($row->quantity),
                                    'scanned_quantity' => $scanned_quantity,
                                    'order_id' => $row->order_id
                                ];
                            }
                        }
                    }
                }
                $response = ["status" => 1, "data" => $data];
            } else {
                $response = ["status" => 0, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        //log_message("error","33333:".json_encode($response));
        echo json_encode($response);
    }

    public function sendResultQuantities()
    {
        $data = [];
        $response = ["status" => 0, "data" => ['No Data']];
        if (isset($_POST)) {
            $postdata = $_POST;
            if (!empty($postdata)) {
                foreach ($postdata as $dec) {
                    $post_data = (array)json_decode($dec, true);
                    foreach ($post_data as $pdata) {
                        $order_id = isset($pdata['order_id']) ? $pdata['order_id'] : "0";
                        $cargo_id = isset($pdata['cargo_id']) ? $pdata['cargo_id'] : "0";
                        $scanned_quantity = isset($pdata['updated_scanned_quantity']) ? $pdata['updated_scanned_quantity'] : "0";
                        if ($order_id == "") {
                            $order_id = 0;
                        }
                        if ($cargo_id == "") {
                            $cargo_id = 0;
                        }
                        if ($scanned_quantity == "") {
                            $scanned_quantity = 0;
                        }
                        if ($order_id != "0" && $cargo_id != "0" && $scanned_quantity != "0") {
                            $cargoeslist = $this->common->gettblrowdata(['id' => $cargo_id, 'order_id' => $order_id, 'status' => '1'], 'id', 'tb_order_cargodetails', 0, 0);

                            if (!empty($cargoeslist)) {
                                $upddt = ['scanned_quantity' => $scanned_quantity];
                                $upd = $this->common->updatetbledata("tb_order_cargodetails", $upddt, ['id' => $cargo_id]);
                            }
                        }
                    }
                }
                $response = ["status" => 1, "data" => ['Success']];
            } else {
                $response = ["status" => 0, "data" => ['No Data']];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function checkprvstopstatus()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        if (isset($_POST)) {
            $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : "";
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : "";
            $previous_stop = isset($_POST["previous_stop"]) ? $_POST["previous_stop"] : "";
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            if ($stop_id != "") {
                if ($previous_stop != "") {
                    $chkdet = $this->db->query("select id from tb_stop_status where shipment_id=$shift_id AND stop_id=$previous_stop AND status_id=1");
                    
                    if ($chkdet->num_rows() == 0) {
                        $response = ["status" => 1, "data" => 0];
                    } else {
                        $response = ["status" => 1, "data" => 1];
                    }
                } else {
                    $response = ["status" => 1, "data" => 1];
                }
            }
        }
        $response = Printable::printable($response);
        //log_message("error","77777:".json_encode($response));
        echo json_encode($response);
    }

    public function setShipstopStatus()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException($_SERVER['REQUEST_METHOD'] . " method is not allowed.");
        }
        if (!isset($_POST) || empty($_POST)) {
            throw new BadRequestException("POST data should not be empty.");
        }
        $postdata = [];
        $checkTripCloseStatus = 0;
        $response = ["status" => 0, "message" => "Insufficient Input Data", "trip_close_status"=>$checkTripCloseStatus];
        ob_start();
        if (isset($_POST)) {
            $data = [];
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            $latitude = $_POST["latitude"] ?? '';
            $longitude = $_POST["longitude"] ?? '';
            $data["trip_id"] = $_POST["trip_id"] ?? '';
            $shipment_id = $_POST["shipment_id"] ?? '0';
            $stop_id = $_POST["stop_id"] ?? '0';
            $stop_type = $_POST["stop_type"] ?? '';
            $driver_id = $_POST["driver_id"] ?? '';
            $data["employee_id"] = $employee_id = $_POST["employee_id"] ?? '';
            $status_type = $_POST["status_type"] ?? '';
            $status_datetime = $_POST["status_datetime"] ?? '';
            $milestoneTypeId = $_POST["status"] ?? '';
            $comment = $_POST['comment'] ?? '';
            $language = $_POST["lang"] ?? 'es';
            $curdt = date('Y-m-d H:i:s');
            $legsorder_id = "";
            $created_source = "";
            $ord_id = $uid = 0;
            $company_code = $branch_code = "";
            $shiftLegId = $this->common->gettblrowdata(["id" => $shipment_id, "status" => 1],"shift_leg_id","tb_shifts",0,0);
            
            if($shiftLegId["shift_leg_id"]>0){
                $getCreatedsrce = $this->common->gettblrowdata(["shift_id" => $shiftLegId["shift_leg_id"]],"id,order_id,created_source,user_id,company_code,branch_code","tb_orders",0,0);
                if(!empty( $getCreatedsrce)) {
                    $created_source = $getCreatedsrce["created_source"];
                    $branch_code = $getCreatedsrce["branch_code"];
                    $company_code = $getCreatedsrce["company_code"];
                    $ord_id = $getCreatedsrce["id"];
                    $uid = $getCreatedsrce["user_id"];
                    $legsorder_id = $getCreatedsrce["order_id"];
                }
            } else {
                $get_createdsrce = $this->db->query("SELECT id,order_id,created_source,user_id,company_code,branch_code FROM tb_orders WHERE shift_id= ? LIMIT 1", [$shipment_id]);
                if ($get_createdsrce->num_rows() > 0) {
                    $created_source = $get_createdsrce->row()->created_source;
                    $branch_code = $get_createdsrce->row()->branch_code;
                    $company_code = $get_createdsrce->row()->company_code;
                    $ord_id = $get_createdsrce->row()->id;
                    $uid = $get_createdsrce->row()->user_id;
                    $legsorder_id = $get_createdsrce->row()->order_id;
                }
            }
            $emp_rec = $this->db->query("select order_id from tb_employee where id='" . $employee_id . "' LIMIT 1");
            if ($emp_rec->num_rows() > 0) {
                $orders = $this->db->where(["order_id" => $emp_rec->row()->order_id])->get("tb_orders");
                if ($orders->num_rows() > 0) {
                    $ord_id = $orders->row()->id;
                }
            }
            if (isset($_FILES)) {
                if (isset($_FILES['file_name']['name'])) {
                    $config = [
                        'upload_path' => NEW_POD_PATH,
                        'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                        'overwrite' => true,
                    ];
                    $file_name = $_FILES['file_name']['name'];
                    $fileNameParts = explode('.', $_FILES['file_name']['name']);
                    $file_ext = @strtolower(end($fileNameParts));
                    $expensions = ["jpeg", "jpg", "png", "gif", "pdf"];
                    if (in_array($file_ext, $expensions) !== false) {
                        if ($file_ext == "pdf") {
                            $imgtype = "pdf";
                            $this->load->library('upload', $config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $imgtype = $imgname['image_type'];
                                $fileName = $imgname['file_name'];
                            }
                        } else {
                            $fileName = date('dmyhis') . '' . $file_name;
                            $filePath = NEW_POD_PATH . $fileName;
                            $imgsize = getimagesize($_FILES['file_name']['tmp_name']);
                            $top_width = $imgsize[0];
                            $top_height = $imgsize[1];
                            $quality = 100;
                            if ($file_ext == "png") {
                                $top = imagecreatefrompng($_FILES['file_name']['tmp_name']);
                                $imgtype = "png";
                            } else {
                                $top = imagecreatefromjpeg($_FILES['file_name']['tmp_name']);
                                if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                    $imgtype = "jpeg";
                                } else {
                                    $imgtype = $file_ext;
                                }
                            }
                            header('Content-Type: image/jpeg');
                            imagejpeg($top, $filePath, $quality);
                            imagedestroy($top);
                        }
                        
                        try {
                            $filePath = $imgname['full_path'];
                            $fileData = file_get_contents($filePath);
                            $base64String = base64_encode($fileData);
                            ////log_message('debug', 'Base64 Encoded Image (First 500 chars): ' . substr($base64Image, 0, 500));
                        } catch (Exception $ex) {
                            log_message('error', 'Error encoding image to base64: ' . $ex->getMessage());
                        }                        
                        if ($stop_type == "") {
                            $stop_type = "P";
                        }
                        $ordid = $ord_id;
                        if ($stop_id != "") {
                            if ($created_source == "5" && $stop_type == "P" && $status_type == "275") {
                                $chkdoctype = $this->common->gettblrowdata(["type_name" => "PUP", "status" => 1], "id", "tb_document_types", 0, 0);
                                if (count($chkdoctype) > 0) {
                                    $status_type = $chkdoctype['id'];
                                    $stop_type = "P";
                                }
                            } else {
                                $chkstype = $this->db->select("stoptype")->get_where("tb_shiporder_stops", ["id" => $stop_id, "stoptype" => "D"], 1, 0);
                                if ($chkstype->num_rows() > 0) {
                                    $stop_type = $chkstype->row()->stoptype;
                                }
                            }
                        }
                        $imageSize = filesize(NEW_POD_PATH . $fileName);
                        $newUuid = $this->uuid->v4();
                        $filedata = ['shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => $status_type, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                        $this->db->insert("tb_pod_uploads", $filedata);
                        
                        if($stop_type == 'P' && $status_type == '278')
                        {
                            $otmDocType='APACPUP';
                        }
                        else if($stop_type == 'P' && $status_type == '274')
                        {
                            $otmDocType='APACPUPESIGN';
                        }
                        else if($stop_type == 'D' && $status_type == '281')
                        {
                            $otmDocType='APACPOD';
                        }
                        else if($stop_type == 'D' && $status_type == '279')
                        {
                            $otmDocType='APACPODESIGN';
                        }    
                        
                        $docTypeCnt = $this->common->getCount(
                                    ['order_id' => $ordid, 'doc_type' => $status_type, 'status' => 1],
                                    'tb_pod_uploads'
                                );
                        if($docTypeCnt>1){
                            $otmDocType = $otmDocType . "-" . ($docTypeCnt - 1);
                        }
                        
                        $domainDetails = $this->OtmBookingModel->getDomain($ordid);
                        if (!empty($domainDetails)) {
                        	$extOrderId = $domainDetails[0]['external_order_id'];
                        	$domainName = $domainDetails[0]['ref_value'];
                            $domainCreatedSource = $domainDetails[0]['created_source'];
                            if($domainName<>"")
                            {
                                $otmRequest = [
                                    'glogDate' => date("Ymdhis"),
                                    'externalOrderId' => $extOrderId,
                                    'domainName' => $domainName,
                                    'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                    'timeZone' => $curtz ?? "",
                                    'base64String' => $base64String ?? "",
                                    'docType' => $otmDocType ?? ""
                                ];
                                            
                                $output = sendOTMDocuments($otmRequest);
                            }
                        }
                        $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                        $hrs = $gethrs->num_rows() > 0 ? $gethrs->row()->cntry_hrs : self::DEFAULT_HOURS;
                        $postdata = [];
                        if ($created_source == 9) {
                            $postdata['user_id'] = $uid;
                            $postdata['hrs'] = $hrs;
                            $postdata['ord_id'] = $ordid;
                            $postdata['status_code'] = '3060';
                            $this->svkonektquote->getstatusresponse($postdata);
                        }
                    }
                }
            }
            if ($data["employee_id"] != "" && $data["trip_id"] != "") {
                $vehicle = $driver = 0;
                $checkintrans = $this->db->select("id,vehicle_id,driver_id")->get_where("tb_trips", ['id' => $data["trip_id"]], 1, 0);
                if ($checkintrans->num_rows() > 0) {
                    $this->db->set(['transit_status' => 1])->where(['id' => $data["trip_id"]])->update("tb_trips");
                    $vehicle = $checkintrans->row()->vehicle_id;
                    $driver = $checkintrans->row()->driver_id;
                }
                $tdata['employee_id'] = $data['employee_id'];
                $tdata['trip_id'] = $data['trip_id'];
                $tdata['stop_id'] = $stop_id;
                $data["status"] = $status_type;
                $data["absent_reason"] = $stsreason = $data["pd_status"] = $milestoneTypeId;
                $data["stime"] = $data["created_on"] = $data["check_in"] = $curdt;
                $notests = 0;
                $stscode = "SV0130";
                if ($stsreason == 274 && $stop_type == "P") {
                    $stscode = "SV0130";
                    $notests = 2;
                }
                if ($stsreason == 279 && $stop_type == "D") {
                    $stscode = "SV0310";
                    $notests = 2;
                }
                if ($stsreason == 275 && $stop_type == "P") {
                    $stscode = "SV0140";
                    $notests = 3;
                }
                if ($stsreason == 281 && $stop_type == "D") {
                    $stscode = "SV0510";
                    $notests = 3;
                }
                if ($stsreason == 285 && $stop_type == "P") {
                    $stscode = "SV0131";
                    $notests = 1;
                }
                if ($stsreason == 280 && $stop_type == "D") {
                    $stscode = "SV0410";
                    $notests = 5;
                }
                if ($stsreason == 278) {
                    $stscode = "SV0230";
                    $notests = 4;
                }

                // OpenBox integration - customer vlaidation is inside a function
                if ($stscode != "SV0120") {
                    $this->load->helper(["edivalidation", 'customerconfigedi']);
                    $this->load->library('openbox_status_execution');
                    $this->openbox_status_execution->pushStatusExecutionXml([
                        "status" => $stscode,
                        "order_row_id" => $ord_id,
                        "trip_id" => $data["trip_id"],
                        "date_time" => $curdt,
                        "lat" => $latitude,
                        "long" => $longitude
                    ]);
                }

                $chksts = ['shipment_id' => $shipment_id, 'stop_id' => $stop_id, 'stop_detail_id' => $data["employee_id"], 'stop_type' => $stop_type, 'trip_id' => $data["trip_id"], 'status_id' => $stsreason, 'status' => $data["status"]];
                $checksts = $this->db->select("id")->get_where("tb_stop_status", $chksts, 1, 0);
                
                if ($checksts->num_rows() > 0) {
                    $updstsarr = ['latitude' => $latitude, 'longitude' => $longitude, 'comment' => $comment];
                    $stswhr = ['id' => $checksts->row()->id];
                    $upd = $this->db->where($stswhr)->update('tb_stop_status', $updstsarr);
                } else {
                    $curdt1 = $curdt;
                    if ($status_datetime != "") {
                        $stsdt = date("Y-m-d H:i:s", strtotime($status_datetime));
                        $getactual = getdatetimebytimezone(DFLT_TZ, $stsdt, $curtz);
                        $curdt1 = $getactual['datetime'];
                    }
                    $data1 = [
                        'shipment_id' => $shipment_id,
                        'stop_id' => $stop_id,
                        'stop_detail_id' => $data["employee_id"],
                        'stop_type' => $stop_type,
                        'trip_id' => $data["trip_id"],
                        'status_id' => $stsreason,
                        'latitude' => $latitude,
                        'longitude' => $longitude,
                        'status' => $data["status"],
                        'status_code' => $stscode,
                        "reason" => "From Mobile",
                        'vehicle_id' => $vehicle,
                        'driver_id' => $driver,
                        'createdon' => $curdt1,
                        'order_id' => $ord_id,
                        'comment' => $comment,
                    ];
                    $insrt = $this->db->insert('tb_stop_status', $data1);
                    $checkStatus = "RELATED_2_" . $company_code . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $company_code) && checkAccessConditions($checkStatus, $stscode)) {
                        $this->load->library('notifytrigger');
                        $this->notifytrigger->sendNotificationToConsignee($ord_id, $stscode);
                    }

                    if (checkAccessConditions('WECHAT_COUNTRY', $company_code) && $stscode === "SV0120" && $legsorder_id) {
                        $this->load->library('Wechat');
                        $this->wechat->orderId = $legsorder_id;
                        $response = $this->wechat->sendNotificationsToWeChat();
                    }
                }
                if ($legsorder_id == "") {
                    $shift = $this->db->query("select order_id,user_id from tb_employee where (stop_id=$stop_id OR drop_stopid=$stop_id) LIMIT 1");
                    if ($shift->num_rows() > 0) {
                        $ord_id = $legsorder_id = $shift->row()->order_id;
                        $uid = $shift->row()->user_id;
                    }
                }
                try {
                    $statusPayload = [
                        "trip" => $data["trip_id"],
                        "ship" => $shipment_id,
                        "ord_id" => $ord_id,
                        "orderid" => $legsorder_id,
                        "stopid" => $stop_id,
                        "stopdetailid" => $data["employee_id"],
                        "vehicle_id" => $vehicle,
                        "driver_id" => $driver,
                        "stop_type" => $stop_type,
                        "timezone" => "",
                        "sts_date" => $curdt1 ?? "",
                        "status_code" => $stscode
                    ];
                   
                    $domainDetails = $this->OtmBookingModel->getDomain($ord_id);
                   
            		if (!empty($domainDetails)) {
            			$extOrderId = $domainDetails[0]['external_order_id'];
            			$domainName = $domainDetails[0]['ref_value'];
                        $domainCreatedSource = $domainDetails[0]['created_source'];
                        
                        if($domainName != ""){
                            $otmRequest = [
                                'glogDate' => date("Ymdhis"),
                                'externalOrderId' => $extOrderId,
                                'orderStatusDateTime' => $curdt1,
                                'domainName' => $domainName,
                                'createdSource'=> $created_source ? $created_source :  $domainCreatedSource,
                                'timeZone' =>$curtz ?? "",
                                'orderStatusCode' => $stscode,
                            ];
                           
                            $output = sendOTMStatus($otmRequest);
                        }
            		}
                    $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                    $this->altovaordercreation->sendOrderToAltova($ord_id, $stscode);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                }
                $hrs = $this->dispatchEventMilestoneStatus($data["trip_id"], $uid, $created_source, $ord_id, $vehicle, $driver_id, $shipment_id, $latitude, $longitude, $curtz, $stop_id, $legsorder_id, $stsreason, $stop_type, $comment);
                if ($created_source == 18) {
                    $postdata = [
                        "shipment_id" =>  $shipment_id,
                        "trip_id" => $data["trip_id"],
                        "driver_id" => $driver_id,
                        "stop_id" => '',
                        "order_id" => $legsorder_id,
                        "latitude" => $latitude,
                        "longitude" => $longitude,
                        "stop_type" => '',
                        "vehicle_id" => $vehicle,
                        "curtz" => $curtz,
                        "hrs" => $hrs,
                        "status_code" => "SV0120",
                        "ord_id" => $ord_id,
                    ];

                    //                    log_error('shippeoStatusEvent => '.json_encode($postdata,128));
                    //                    $this->shippeoStatusEvent($ord_id, $postdata, $curtz, $stsreason, $stop_type, $vehicle, $company_code, $branch_code, $uid);
                }
                /* Here send driver action status send to otm */
                $checkTripCloseStatus = checkTripEligibleForClose($data["trip_id"]);
                $sql = $this->db->select("id")->get_where("tb_trip_employee", $tdata, 1, 0);
                if ($sql->num_rows() > 0) {
                    $id = $sql->row()->id;
                    if ($data["status"] == 1 &&  in_array($stsreason, [280, 285])) {
                        $empdt = ['status' => 1, 'absent_reason' => 'Closed', 'pd_status' => 'Closed', 'updated_on' => $curdt];
                        $upd = $this->db->where(['id' => $id])->update('tb_trip_employee', $empdt);
                    }
                    $response = ["status" => 1, "trip_close_status"=>$checkTripCloseStatus, "data" => [["trip_employee_id" => $id]], "sms_data" => [], "pickup_data" => []];
                } else {
                    if ($data['status'] == '1') {
                        $chkltlng = $this->checkLatLng($data["employee_id"]);
                        if ($chkltlng == "true") {
                            $lat = $latitude;
                            $lng = $longitude;
                            $this->savePickup($data["employee_id"], $lat, $lng);
                        }
                    }
                    if ((in_array($stsreason, [280, 285]) && $data["status"] == 1) || ($data["status"] == 0)) {
                        if (in_array($stsreason, [280, 285])) {
                            $data['absent_reason'] = 'Closed';
                        } elseif ($stsreason == 0) {
                            $data['absent_reason'] = 'Cancelled';
                        }
                        $data["stop_id"] = $stop_id;
                        $res = $this->db->insert("tb_trip_employee", $data);
                        $id = $this->db->insert_id();
                        $smsdata = [];
                        if ($id > 0) {
                            $response = ["status" => 1, "trip_close_status"=>$checkTripCloseStatus, "data" => [["trip_employee_id" => $id]], "sms_data" => [], "pickup_data" => []];
                            if ($data["status"] == 1) {
                                $result = [];
                                $result = $this->sendTripAlert($data["trip_id"], $curtz);
                                if (!empty($result)) {
                                    if (isset($result['sms_data'])) {
                                        $smsdata = $result['sms_data'];
                                    }
                                    if (isset($result['pickup_data'])) {
                                        $pickdata = $result['pickup_data'];
                                    }
                                    $response = ["status" => 1, "trip_close_status"=>$checkTripCloseStatus, "data" => [["trip_employee_id" => $id]], "sms_data" => $smsdata, "pickup_data" => $pickdata];
                                }
                            }
                            $response = ["status" => 1, "trip_close_status"=>$checkTripCloseStatus, "message" => "Updated Status!"];
                        } else {
                            $response = ["status" => 0, "trip_close_status"=>$checkTripCloseStatus, "message" => "Failed to Set Shipment Status"];
                        }
                    } else {
                        $response = ["status" => 1, "trip_close_status"=>$checkTripCloseStatus, "message" => "Updated Status!"];
                    }
                }
                SendDocumentGateOut::sendshipstatusnotify($postdata, $notests, $this);
            }
            if ($data['trip_id'] && $driver_id && !empty($data['trip_id']) && !empty($driver_id)) {
                $langTranslation = ['en' => 'english', 'en_US' => 'english_us', 'zh' => 'chinese', 'fr' => 'french', 'hi' => 'hindi', 'ms' => 'malay', 'ru' => 'russian', 'tl' => 'tamil', 'th' => 'thailand', 'ur' => 'urdu', 'vi' => 'vietnamese'];
                $siteLanguage = $langTranslation[$language] ?? 'english';
                $this->load->helper('language');
                $this->lang->load('message_lang', $siteLanguage);
                if ($stop_type == 'P' && $milestoneTypeId == 274) {
                    $message = $this->lang->language['origin_gatein_pickup'];
                }
                if ($stop_type == 'P' && $milestoneTypeId == 285) {
                    $message = $this->lang->language['origin_pickup_pupupload'];
                }
                if ($stop_type == 'P' && $milestoneTypeId == 275) {
                    $message = $this->lang->language['origin_gateout_intransit'];
                }
                if ($milestoneTypeId == 278) {
                    $message = $this->lang->language['intransit_destination_gatein'];
                }
                if ($stop_type == 'D' && $milestoneTypeId == 279) {
                    $message = $this->lang->language['gatein_delivery'];
                }
                if ($stop_type == 'D' && $milestoneTypeId == 280) {
                    $message = $this->lang->language['delivery_podupload'];
                }
                if ($stop_type == 'D' && $milestoneTypeId == 281) {
                    $message = $this->lang->language['gateout_close'];
                }
                
                $tripID = $data['trip_id'];
                $res = $this->shipmentDetails($tripID, $shipment_id, $driver_id, $ord_id, $curtz);
                $messageData = json_encode(["msg" => $message, "info" => $res, "type" => 2], JSON_UNESCAPED_UNICODE);
                $this->load->library('sendfirebase');
                $fire_res = $this->sendfirebase->sendSinglePush(["title" => "Kuehne+Nagel", "message" => $messageData, "emp_id" => $driver_id, 'type' => 'Driver']);
            }
            if (($created_source == 5) && in_array( $stscode, ['0200', '0220', '0500', '3000'])) {
                $this->load->library('notifytrigger');
                $this->notifytrigger->orderStatusNotification($legsorder_id, $stscode, $curdt1 ?? $curdt);
            }
        }

        $response = Printable::printable($response);
        ob_end_clean();
        //log_message("error","44444:".json_encode($response));
        echo json_encode($response);
    }

    public function sendepodstatusnotify($postdata)
    {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $fileName = $postdata['file_name'];
        $chkcust = $this->db->query("SELECT o.*,c.name FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.order_id='" . $order_id . "' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $cust_id = $orddata['customer_id'];
            $user_id = $orddata['user_id'];
            $cust_name = $orddata['name'];
            $company_code = $orddata['company_code'];
            $branch_code = $orddata['branch_code'];
            $chkref = "XSR";
            $whrin = " AND reference_id in('XSR','SD') ";
            $chkordtypeqry = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid $whrin AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1");
            $refval = $refvalue = "";
            $iofeof = "EOF";
            if ($chkordtypeqry->num_rows() > 1) {
                foreach ($chkordtypeqry->result() as $oref) {
                    if ($oref->reference_id == "XSR") {
                        $refvalue = $oref->ref_value;
                    }
                    if ($oref->reference_id == "SD" && $oref->ref_value == "2") {
                        $iofeof = "IOF";
                    }
                }

                $chkparty = "SELECT party_id,partycontact_id,customer_id,email_note,emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                $query = $this->db->query($chkparty);
                if ($query->num_rows() > 0) {
                    $this->load->library('email');
                    foreach ($query->result() as $pmails) {
                        $receivename = $pmails->party_name;
                        $receivemail = $pmails->emailid;
                        $data['order'] = $orddata;
                        $data['page_title'] = "Booking ePOD";
                        $data['receivemail'] = $receivemail;
                        $data['receivename'] = $receivename;

                        $sub = $refvalue . "#746#" . $iofeof;
                        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                        $this->email->to($receivemail, $receivename);

                        $this->email->subject($sub);
                        $this->email->set_mailtype("html");
                        $body = $this->load->view('mail_forms/bookepod', $data, true);
                        $this->email->message($body);
                        $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                        $this->email->attach($epodpath);

                        if(!$this->email->send()){
                            log_message("error",$this->email->print_debugger());
                        }

                        $this->email->clear(true);
                    }
                }
            }
        }
    }

    public function sendepodstatusnotifyadmin($postdata)
    {
        $order_id = $postdata['order_id'];
        $ship_id = $postdata['shipment_id'];
        $trip_id = $postdata['trip_id'];
        $stop_id = $postdata['stop_id'];
        $fileName = $postdata['file_name'];
        $chkcust = $this->db->query("SELECT * FROM tb_orders WHERE order_id='" . $order_id . "' LIMIT 1");
        if ($chkcust->num_rows() > 0) {
            $orddata = $chkcust->row_array();
            $ordid = $orddata['id'];
            $user_id = $orddata['user_id'];
            $getusermail = $this->db->select("name,company_code,cc_mails")->get_where("tb_users", ["id" => $user_id, "status" => "Active", "cc_mails !=" => ""], 1, 0);
            if ($getusermail->num_rows() > 0) {
                $cmpcode = $getusermail->row()->company_code;
                if (checkAccessConditions('RELATED_2_SG_MY', $cmpcode)) {
                    $receivemail = $getusermail->row()->cc_mails;
                    $receivename = $getusermail->row()->name;
                    $this->load->library('email');
                    $data['order'] = $orddata;
                    $data['page_title'] = "Booking ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
                    $this->email->to($receivemail, $receivename);

                    $this->email->subject("svkonekt::Booking ePOD for #" . $order_id);
                    $this->email->set_mailtype("html");
                    $body = $this->load->view('mail_forms/bookepod', $data, true);
                    $this->email->message($body);
                    $epodpath = sprintf('%s/poduploads/%s', '/var/www/', $fileName);
                    $this->email->attach($epodpath);

                    if(!$this->email->send()){
                        log_message("error",$this->email->print_debugger());
                    }

                    $this->email->clear(true);
                }
            }
        }
    }

    public function getshipstatuses()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        if (isset($_POST)) {
            $trip_id = isset($_POST["trip_id"]) ? $_POST["trip_id"] : "";
            $shipment_id = isset($_POST["shipment_id"]) ? $_POST["shipment_id"] : "";
            $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : null;
            $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : null;
            if ($trip_id != "") {
                $documentStatus = GetDocumentStatusAndStopsData::getDocumentStatus(
                    $trip_id,
                    $stop_id,
                    $stop_detail_id,
                    $this->db
                );
                $stopsData = GetDocumentStatusAndStopsData::getStopsData(
                    $trip_id,
                    $stop_id,
                    $stop_detail_id,
                    $shipment_id,
                    $this->db
                );
                $response = ["status" => 1, "data" => $stopsData, 'docstatus' => $documentStatus];
            }
        }
        $response = Printable::printable($response);
        //log_message("error","55555:".json_encode($response));
        echo json_encode($response);
    }

    public function setShipReject()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $data = [];
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);

            $curdt = date('Y-m-d H:i:s');
            $trip_id = $post->trip_id ?? 0;
            $latitude = $post->latitude ?? '';
            $longitude = $post->logitude ?? ($post->longitude ?? '');
            $reason = $post->reason ?? '';
            $type = $post->type ?? '1';
            $vehicle_id = $post->vehicle_id ?? '';
            $driver_id = $post->driver_id ?? '';
            $shipment_id = $post->shipment_id ?? '';
            $status = 6;
            $statuscode = "0213";
            if ($shipment_id != "" && $driver_id > 0) {
                $ordinfo = $this->db->select("id,order_id,user_id,created_source")->get_where("tb_orders", ["shift_id" => $shipment_id], 1, 0);
                if ($ordinfo->num_rows() > 0) {
                    $order_id = $ordinfo->row()->id;
                    $ordid = $ordinfo->row()->order_id;
                    $uid = $ordinfo->row()->user_id;
                    $created_source = $ordinfo->row()->created_source;
                } else {
                    $order_id = 0;
                    $ordid = "";
                    $uid = 1;
                    $created_source = "";
                }
                if ($type == '1') {
                    /*type 1 will never come, because this operation is heppen before trip starts only*/
                    $chktrip = $this->db->select('id')->get_where('tb_trips', ['id' => $trip_id, 'status !=' => 0]);
                    if ($chktrip->num_rows() > 0) {
                        $whr = ['id' => $trip_id];
                        $set = ['status' => 2, 'updated_on' => $curdt];
                        $upd = $this->db->set($set)->where($whr)->update('tb_trips');
                    }
                    $addstatus = ['order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt];
                }
                if ($type == '0') {
                    if ($trip_id == "") {
                        $trip_id = 0;
                    }
                    $addstatus = ['order_id' => $order_id, 'shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => $status, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 0, 'createdon' => $curdt];
                }
                $this->db->where(["shft_id" => $shipment_id])->update("tb_shft_veh", ["status" => "0"]);
                $qry = $this->db->insert('tb_stop_status', $addstatus);

                $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
                $hrs = $gethrs->num_rows() > 0 ? $gethrs->row()->cntry_hrs : '+2.30';

                $payload = RejectTripPayloadFactory::create($created_source, $ordid, $vehicle_id, $driver_id, $shipment_id, $trip_id, $latitude, $longitude, $uid, $curdt, $curtz, $hrs);
                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_REJECT_TRIP, $payload));
                $response = ["status" => 1, "message" => "Updated"];
            }
        }

        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function setshipAbort()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }
        if (empty($_POST)) {
            throw new BadRequestException("POST data should not be empty.");
        }

        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
        $curdt = date('Y-m-d H:i:s');
        $latitude = $_POST['latitude'] ?? '';
        $longitude = $_POST["longitude"] ?? '';
        $shipment_id = $_POST["shipment_id"] ?? '0';
        $trip_id = $_POST["trip_id"] ?? 0;
        $driver_id = $_POST["driver_id"] ?? '0';
        $vehicle_id = $_POST["vehicle_id"] ?? '0';
        $reason = $_POST["reason"] ?? '';
        $podinsid = 0;
        $chkord = $this->db->query(
            "SELECT o.id, o.order_id, o.user_id, o.created_source
            FROM tb_orders o
            WHERE o.shift_id = ?
            LIMIT 1",
            [$shipment_id]
        );
        if ($chkord->num_rows() > 0) {
            $ordid = $chkord->row()->id;
            $legsorder_id = $chkord->row()->order_id;
            $created_source = $chkord->row()->created_source ?? '';
            $uid = $chkord->row()->user_id;
        } else {
            $ordid = 0;
            $legsorder_id = "";
            $uid = 5;
            $created_source = "";
        }
        if (isset($_FILES)) {
            if (isset($_FILES['photo']['name'])) {
                $config = [
                    'upload_path' => NEW_POD_PATH,
                    'allowed_types' => 'jpg|gif|png|pdf',
                    'overwrite' => true,
                ];
                $this->load->library('upload', $config);
                if ($this->upload->do_upload('photo')) {
                    $imgname = $this->upload->data();
                    $fileName = $imgname['file_name'];
                    $created_source = "";
                    $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id,o.created_source FROM tb_orders o WHERE o.shift_id='" . $shipment_id . "' LIMIT 1");
                    if ($chkord->num_rows() > 0) {
                        $ordid = $chkord->row()->id;
                        $legsorder_id = $chkord->row()->order_id;
                        $created_source = $chkord->row()->created_source;
                        $uid = $chkord->row()->user_id;
                    }
                    $imageSize = filesize(NEW_POD_PATH . $fileName);
                    $newUuid = $this->uuid->v4();
                    $filedata = ['trip_id' => $trip_id, 'shipment_id' => $shipment_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 3, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'createdby' => $driver_id, 'status' => 1, 'createdon' => $curdt, 'filesize' => $imageSize, 'hash' => $newUuid];
                    $this->db->insert("tb_pod_uploads", $filedata);
                    
                    $docTypeCnt = $this->common->getCount(
                                    ['order_id' => $ordid, 'doc_type' => 3, 'status' => 1],
                                    'tb_pod_uploads'
                                );
                    if($docTypeCnt>1){
                        $otmDocType = "APACPOD" . "-" . ($docTypeCnt - 1);
                    }else
                    {
                        $otmDocType = "APACPOD";
                    }
                        
                    $domainDetails = $this->OtmBookingModel->getDomain($ordid);
                    if (!empty($domainDetails)) {
                        $extOrderId = $domainDetails[0]['external_order_id'];
                        $domainName = $domainDetails[0]['ref_value'];
                        $domainCreatedSource = $domainDetails[0]['created_source'];
                        if($domainName<>"")
                        {
                            $otmRequest = [
                                'glogDate' => date("Ymdhis"),
                                'externalOrderId' => $extOrderId,
                                'domainName' => $domainName,
                                'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                'timeZone' => $curtz ?? "",
                                'base64String' => $base64String ?? "",
                                'docType' => $otmDocType ?? ""
                            ];
                                            
                            $output = sendOTMDocuments($otmRequest);
                        }
                    }
                    $podinsid = $this->db->insert_id();
                }
            }
        }
        if ($ordid > 0) {
            if ($podinsid !== 0) {
                $this->db->where(array("id" => $podinsid))->update("tb_pod_uploads", array("order_id" => $ordid));
            }
            $statuscode = "0217";
            $addstatus = ['order_id' => $ordid, 'shipment_id' => $shipment_id, 'stop_id' => 0, 'trip_id' => $trip_id, 'status_id' => 6, 'latitude' => $latitude, 'longitude' => $longitude, 'status_code' => $statuscode, 'reason' => $reason, 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'status' => 1, 'createdon' => $curdt];
            $qry = $this->db->insert('tb_stop_status', $addstatus);

            if ($qry) {
                $this->db->where('id', $shipment_id)->limit(1);
                $this->db->update('tb_shifts', ['aborted' => 1]);
            }

            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=? AND c.status=1 LIMIT 1",[$uid]);
            if ($gethrs->num_rows() > 0) {
                $hrs = $gethrs->row()->cntry_hrs;
            } else {
                $hrs = self::DEFAULT_HOURS;
            }
            $payload = AbortTripPayloadFactory::create($created_source, $ordid, $legsorder_id, $vehicle_id, $driver_id, $shipment_id, $trip_id, $latitude, $longitude, $uid, $curdt, $curtz, $hrs);
            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_ABORT_TRIP, $payload));
        }
        $response = ["status" => 1, "message" => "Updated"];

        echo json_encode(Printable::printable($response));
    }

    public function rescheduleShift()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        if (isset($_POST)) {
            $post = json_decode($_POST['data']);
            $shift_id = $post->shift_id ?? "";
            $vehicle_id = $post->vehicle_id ?? "";
            $driver_id = $post->driver_id ?? "";
            $user_id = $post->user_id ?? "";
            $splace = $post->splace ?? "";
            $eplace = $post->eplace ?? "";
            $reschedule_date = $post->reschedule_date ?? "";
            $reason = $post->reason ?? "";
            $check = $post->check ?? "";
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            if (strlen($reschedule_date) > 0 && strlen($shift_id) > 0 && strlen($vehicle_id) > 0 && strlen($user_id) > 0) {
                $vendor = $this->db->query("SELECT v.email FROM tb_trucks_data vv LEFT JOIN tb_vendors v ON v.id=vv.vendor_id WHERE vv.status='1' AND vv.id=$vehicle_id AND v.email != ''");
                $user = $this->db->query("SELECT name,emailid FROM tb_users WHERE id=$user_id ")->row();
                $driver = $this->db->query("SELECT name,contact_num FROM tb_truck_drivers WHERE id=$driver_id")->row();
                $shift = $this->db->select("convertToClientTZ(startdate,'" . $curtz . "') as startdate,shipmentid")->where(["id" => $shift_id])->get("tb_shifts")->row();
                
                if ($vendor->num_rows() > 0) {
                    $payload = RescheduleTripPayloadFactory::create($vendor->email, $vendor->name, $user->emailid, $user->name, $shift->shipmentid, $shift->startdate, $splace, $eplace, $driver->name, $driver->contact_num, $check, $reschedule_date, $reason);
                    $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_RESCHEDULE_TRIP, $payload));
                }

                $response = (["status" => "1", "message" => "Status updated successfully!"]);
            } else {
                $response = (["status" => "0", "message" => "Invalid input parameters!"]);
            }
        } else {
            $response = (["status" => "0", "message" => "Invalid input parameters!"]);
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function stopdetailsaccept()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException($_SERVER['REQUEST_METHOD'] . " method is not allowed.");
        }
        if (!isset($_POST) || empty($_POST)) {
            throw new BadRequestException("POST data should not be empty.");
        }

        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);

        //initials
        $post = $_POST;
        $uid = 0;
        $hrs = "Z";

        $post["latitude"] = isset($post["latitude"]) ? ((float)$post["latitude"] ?? 0.0) : 0.0;
        $post["longitude"] = isset($post["longitude"]) ? ((float)$post["longitude"] ?? 0.0) : 0.0;
        $post["shipment_stop_details"] = json_decode($post["shipment_stop_details"] ?? '[]');
        $post["shift_id"] = isset($post["shift_id"]) ? ((int)$post["shift_id"] ?? 0) : 0;
        $post["stop_id"] = isset($post["stop_id"]) ? ((int)$post["stop_id"] ?? 0) : 0;
        $post["driver_id"] = isset($post["driver_id"]) ? ((int)$post["driver_id"] ?? 0) : 0;

        $latitude = $post["latitude"];
        $longitude = $post["longitude"];
        $shipment_stop_details = $post["shipment_stop_details"];
        $shift_id = $post["shift_id"];
        $stop_id = $post["stop_id"];
        $driver_id = $post["driver_id"];

        $trip_id = null;
        $vehicle_id = null;

        $stopDetailsExists = $this->db->from('tb_employee')
            ->where("shift_id", $shift_id)
            ->where('status', 1)
            ->count_all_results();

        if (!$stopDetailsExists) {
            throw new BadRequestException("Stop details not found");
        }

        $detailsExists = $this->db->query('SELECT ad.driver_id
            FROM tb_shft_veh sv
                INNER JOIN tbl_assigned_drivers ad
                    ON sv.vehicle_id = ad.vehicle_id
            WHERE sv.shft_id = ?
            AND ad.status = 1',
            [$shift_id]
        );

        if (!$detailsExists->num_rows()) {
            throw new BadRequestException("Driver not found");
        }

        if ($driver_id != $detailsExists->row_array()['driver_id']) {
            throw new BadRequestException("Driver Id is invalid");
        }

        $this->db->query("UPDATE `tb_employee` e set e.accepted = 0 where e.shift_id= '" . $shift_id . "' AND e.status=1 AND e.stop_id='" . $stop_id . "'");

        if (is_array($shipment_stop_details)) {
            foreach ($shipment_stop_details as $stop_detail_id) {
                $this->db->query("UPDATE tb_employee set accepted = 1 WHERE id = '" . $stop_detail_id . "'");
            }
        }

        $trip = $this->db->query("SELECT id,vehicle_id from tb_trips where shift_id ='" . $shift_id . "' AND status = 1");

        if ($trip->num_rows()) {
            $trip_id = $trip->row()->id;
            $vehicle_id = $trip->row()->vehicle_id;
        }

        if ($trip_id) {
            $this->db->query("DELETE from tb_trip_employee where trip_id = '" . $trip_id . "'");

            //get stop details
            $emp = $this->db->query("
                                    SELECT e.id,stop_id
                                    FROM tb_employee e
                                        JOIN tb_shft_veh_emp sve ON sve.emp_id = e.id AND sve.status = '1'
                                        JOIN tb_shft_veh sv ON sv.id = sve.shft_veh_id AND sv.status = '1'
                                        JOIN tb_shifts s ON s.id = sv.shft_id AND s.status = '1'
                                    WHERE (e.accepted is null or e.accepted = '' or e.accepted = '0') AND s.id = " . $shift_id);

            foreach ($emp->result() as $stopDetailResult) {
                $te["trip_id"] = $trip_id;
                $te["stop_id"] = $stopDetailResult->stop_id;
                $te["employee_id"] = $stopDetailResult->id;
                $te["status"] = "0";
                $te["absent_reason"] = "Driver Rejected";
                $this->db->insert("tb_trip_employee", $te);
            }
        }

        $stops = $this->db->select('id')->where(array("shipment_id" => $shift_id, "status" => "1"))->get("tb_shiporder_stops");

        foreach ($stops->result() as $row) {
            $stp_id = $row->id;

            $shift = $this->db->query("select user_id,order_id from tb_employee where shift_id='" . $shift_id . "' AND (stop_id = '" . $stp_id . "' OR drop_stopid = '" . $stp_id . "') AND status=1");
            $numrws = $shift->num_rows();

            if ($numrws) {
                $ordid = $shift->row()->order_id;

                if (!$uid) {
                    $uid = $shift->row()->user_id;
                    $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id='" . $uid . "' AND c.status=1 LIMIT 1");

                    if ($gethrs->num_rows() > 0) {
                        $hrs = $gethrs->row()->cntry_hrs;
                    } else {
                        $hrs = self::DEFAULT_HOURS;
                    }
                }

                $allAccepted = false;
                $act_det = $this->db->select('id')->where(array("shift_id" => $shift_id, "status" => "1", "accepted" => "1"))->where("(stop_id = " . $stp_id . " or drop_stopid = " . $stp_id . ")")->get("tb_employee");

                if ($numrws == $act_det->num_rows()) {
                    $allAccepted = true;
                }

                $payload = StopStatusUpdatePayloadFactory::create($ordid, $vehicle_id ?? '', $driver_id ?? '', $shift_id ?? '', $trip_id ?? '', $latitude, $longitude, $uid, $allAccepted, $stp_id, $curtz, $hrs);
                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_STOP_STATUS_UPDATE, $payload));
            }
        }

        $response = ["status" => 1, "data" => $post];
        $response = Printable::printable($response);
        //log_message("error","99999:::".json_encode($response));
        echo json_encode($response);
    }

    public function getvehicledrivers()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        $post = [];
        if (isset($_POST)) {
            $data = [];
            $post = $_POST;
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            if ($vehicle_id != "") {
                $qry = "SELECT d.id,d.name,d.contact_num FROM tb_vehicles_drivers v,tb_truck_drivers d WHERE v.driver_id=d.id AND d.status='Active' AND v.status=1 AND v.vehicle_id=$vehicle_id AND v.driver_id !=$driver_id";
                $query = $this->db->query($qry);
                if ($query->num_rows() > 0) {
                    foreach ($query->result() as $res) {
                        $data[] = ['id' => $res->id, 'name' => $res->name, 'mobile' => $res->contact_num];
                    }
                }
                $response = ["status" => 1, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function assigndriver()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }
        $response = ["status" => 0, "data" => []];
        if (isset($_POST))  {
            $post = $_POST;
            $driver_id = $post["driver_id"] ?? 0;
            $vehicle_id = $post["vehicle_id"] ?? 0;
            $assigningDriver = $post["assigned_driver_id"] ?? 0;
            $trip_id = $post["trip_id"] ?? 0;

            $curdt = date('Y-m-d H:i:s');
            if (empty($assigningDriver)) {
                throw new MethodNotAllowedException("Assigned driver cannot be empty");
            } else {
                $driver = $this->db->select('name,contact_num,user_id')->get_where("tb_truck_drivers", array("id" => $assigningDriver), 1, 0);
                if ($driver->num_rows() == 0) {
                    throw new MethodNotAllowedException("Assigned driver not found");
                } else {
                    $name = $driver->row()->name;
                    $mobile_no = $driver->row()->contact_num;
                    $user_id = $driver->row()->user_id;
                    if ($user_id) {
                        $this->db->where(["id" => $trip_id])->update("tb_trips", ["driver_id" => $assigningDriver]);
                        $this->db->insert("tb_trip_drivers", ["driver_id" => $assigningDriver, "trip_id" => $trip_id, "createdon" => $curdt]);
                        $this->db->where(["vehicle_id" => $vehicle_id, "driver_id" => $driver_id, "status" => "1"])->update("tbl_assigned_drivers", ["status" => 0]);
                        $chk = $this->db->select('id')->get_where('tbl_assigned_drivers', array("vehicle_id" => $vehicle_id, "driver_id" => $assigningDriver), 1, 0);
                        if ($chk->num_rows() > 0) {
                            $existid = $chk->row()->id;
                            $this->db->where(["id" => $existid])->update("tbl_assigned_drivers", ["user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "from_time" => $curdt, "to_time" => $curdt]);
                        } else {
                            $this->db->insert("tbl_assigned_drivers", ["vehicle_id" => $vehicle_id, "driver_id" => $assigningDriver, "user_id" => $user_id, "mobile_no" => $mobile_no, "status" => 1, "created_on" => $curdt, "from_time" => $curdt, "to_time" => $curdt]);
                        }
                        $veh = $this->db->select('register_number')->get_where('tb_trucks_data', ['id' => $vehicle_id], 1, 0)->row()->register_number;
                        $message = "Dear " . $name . ",You are assigned to " . $veh . ", please login to do the shipping";

                        $payload = AssignDriverPayloadFactory::create($message, $assigningDriver);
                        $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_ASSIGN_DRIVER, $payload));
                        $response = ["status" => 1, "data" => []];
                    }
                }
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function getpickupshipunit()
    {
        $response = ["status" => 0, "message" => "Insufficient Input Data"];
        $post = [];
        if (isset($_POST)) {
            $data = [];

            $post = $_POST;
            $driver_id = isset($post["driver_id"]) ? $post["driver_id"] : 0;
            $vehicle_id = isset($post["vehicle_id"]) ? $post["vehicle_id"] : 0;
            $trip_id = isset($post["trip_id"]) ? $post["trip_id"] : 0;
            $shift_id = isset($post["shift_id"]) ? $post["shift_id"] : 0;
            $stop_id = isset($post["stop_id"]) ? $post["stop_id"] : 0;
            $ship_units = isset($post["ship_units"]) ? $post["ship_units"] : 0;
            if ($trip_id != "" && $stop_id != "") {
                $upd = $this->db->where(["shipment_id" => $shift_id, "id" => $stop_id])->update("tb_shiporder_stops", ["ship_units" => $ship_units]);
                $response = ["status" => 1, "data" => $post];
            }
        }
        $response = Printable::printable($response);
        //log_message("error","122222:".json_encode($response));
        echo json_encode($response);
    }

    public function setdriverfeedback()
    {
        $response = ["status" => 0, "message" => "Something went wrong!"];
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : 0;
        $ship_id = isset($_POST['shipment_id']) ? $_POST['shipment_id'] : '';
        $feedback = isset($_POST['feedback']) ? $_POST['feedback'] : '';
        $rating = isset($_POST['rating']) ? $_POST['rating'] : 3;

        $curdt = date('Y-m-d H:i:s');

        if ($driver_id != "" && $feedback != "") {
            $arr = ['trip_id' => $trip_id, 'ship_id' => $ship_id, 'stop_id' => $stop_id, 'stop_detail_id' => $stop_id, 'noted_by' => $driver_id, 'user_type' => 0, 'feedback' => $feedback, 'feedback_type' => $rating, 'status' => 1, 'created_on' => $curdt];
            $ins = $this->db->insert("tb_trip_feebacks", $arr);
            $response = ["status" => 1, "message" => "Success"];
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function uploadcostomes()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }
        if (empty($_POST)) {
            throw new BadRequestException("POST data should not be empty.");
        }
        $response = ["status" => 0, "message" => "Something went wrong!"];
        $trip_id = $_POST['trip_id'] ?? 0;
        $user_id = $_POST['user_id'] ?? 0;
        $driver_id = $_POST['driver_id'] ?? 0;
        $latitude = $_POST['latitude'] ?? 0;
        $longitude = $_POST['longitude'] ?? 0;
        if ($trip_id != "" && $user_id != "") {
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);

            $curdt = date('Y-m-d H:i:s');
            $imgtype = $fileName = "";

            if (isset($_FILES)) {
                foreach ($_FILES as $k => $FILE) {
                    if (isset($FILE['name'])) {
                        $config = array(
                            'upload_path' => NEW_POD_PATH,
                            'allowed_types' => 'jpeg|jpg|gif|png|pdf|JPEG|JPG|PNG',
                            'overwrite' => true,
                        );
                        $file_name = $FILE['name'];
                        $fileNameParts = explode('.', $FILE['name']);
                        $file_ext = @strtolower(end($fileNameParts));
                        $expensions = ["jpeg", "jpg", "png", "gif", "pdf"];
                        if (in_array($file_ext, $expensions) !== false) {
                            if (in_array($file_ext, ["pdf", "gif"])) {
                                $imgtype = "pdf";
                                $this->load->library('upload', $config);
                                $ff = 'file_name' . $k;
                                if ($this->upload->do_upload($ff)) {
                                    $imgname = $this->upload->data();
                                    $imgtype = $imgname['image_type'];
                                    $fileName = $imgname['file_name'];
                                }
                            } else {
                                $fileName = date('dmyhis') . '' . $file_name;
                                $filePath = NEW_POD_PATH . $fileName;
                                $quality = 100;
                                if ($file_ext == "png") {
                                    $top = imagecreatefrompng($FILE['tmp_name']);
                                    $imgtype = "png";
                                } else {
                                    $top = imagecreatefromjpeg($FILE['tmp_name']);
                                    if ($file_ext == "jpg" || $file_ext == "jpeg") {
                                        $imgtype = "jpeg";
                                    } else {
                                        $imgtype = $file_ext;
                                    }
                                }
                                header('Content-Type: image/jpeg');
                                imagejpeg($top, $filePath, $quality);
                                imagedestroy($top);
                            }
                        }
                    }
                }
            }
            $chk = $this->db->select('shift_id,vehicle_id')->get_where('tb_trips', array('id' => $trip_id), 1, 0);
            $shipment_id = $vehicle_id = 0;
            if ($chk->num_rows() > 0) {
                $shipment_id = $chk->row()->shift_id;
                $vehicle_id = $chk->row()->vehicle_id;
            }
            $ordid = $order_id = 0;
            $uid = 5;
            $created_source = "";
            if ($shipment_id > 0) {
                $chkord = $this->db->query("SELECT o.id,o.order_id,o.user_id,o.created_source FROM tb_orders o WHERE o.shift_id='" . $shipment_id . "' LIMIT 1");
                if ($chkord->num_rows() > 0) {
                    $ordid = $chkord->row()->id;
                    $order_id = $chkord->row()->order_id;
                    $created_source = $chkord->row()->created_source;
                    $uid = $chkord->row()->user_id;
                }
            }
            $imageSize = filesize(NEW_POD_PATH.$fileName);
            $newUuid = $this->uuid->v4();
            $filedata = ['shipment_id' => $shipment_id, 'stop_id' => 0, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'latitude' => $latitude, 'longitude' => $longitude, 'doc_type' => 2, 'imgpath' => $fileName, 'order_id' => $ordid, 'user_id' => $uid, 'status' => 1, 'createdon' => $curdt, 'createdby' => $driver_id, 'filesize' => $imageSize, 'hash' => $newUuid];
            $this->db->insert("tb_pod_uploads", $filedata);
            
            $docTypeCnt = $this->common->getCount(
                                    ['order_id' => $ordid, 'doc_type' => 2, 'status' => 1],
                                    'tb_pod_uploads'
                                );
            if($docTypeCnt>1){
                $otmDocType = "APACOTHERS" . "-" . ($docTypeCnt - 1);
            }else
            {
                $otmDocType = "APACOTHERS";
            }
            
            $domainDetails = $this->OtmBookingModel->getDomain($ordid);
            if (!empty($domainDetails)) {
                $extOrderId = $domainDetails[0]['external_order_id'];
                $domainName = $domainDetails[0]['ref_value'];
                $domainCreatedSource = $domainDetails[0]['created_source'];
                if($domainName<>"")
                {
                    $otmRequest = [
                        'glogDate' => date("Ymdhis"),
                        'externalOrderId' => $extOrderId,
                        'domainName' => $domainName,
                        'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                        'timeZone' => $curtz ?? "",
                        'base64String' => $base64String ?? "",
                        'docType' => $otmDocType ?? ""
                    ];
                                            
                    $output = sendOTMDocuments($otmRequest);
                }
            }
            /*store in status also */
            $stsdata = ['shipment_id' => $shipment_id, 'stop_id' => 0, 'stop_detail_id' => 0, 'stop_type' => 'D', 'trip_id' => $trip_id, 'status_id' => 5, 'latitude' => $latitude, 'longitude' => $longitude, 'status' => 1, 'reason' => 'Out Of Border', 'vehicle_id' => $vehicle_id, 'driver_id' => $driver_id, 'createdon' => $curdt, 'status_code' => ''];
            $this->db->insert("tb_stop_status", $stsdata);
            $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=$uid AND c.status=1 LIMIT 1");
            $hrs = $gethrs->num_rows() > 0 ? $gethrs->row()->cntry_hrs : self::DEFAULT_HOURS;
            try {
                $payload = (new UploadCustomsPayloadBuilder())
                    ->trip($shipment_id, $trip_id, $driver_id, $order_id)
                    ->document($fileName, $imgtype)
                    ->position($latitude, $longitude)
                    ->uploadCustomsPayload(3, $curtz, $hrs, $created_source, $ordid, $user_id)
                    ->build();
                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_UPLOAD_CUSTOMS, $payload));
                $response = ["status" => "1", "data" => []];
            } catch (Exception $ex) {
                $response = ["status" => "0", "message" => "Invalid payload received"];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function shipmentstoppods()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $shift_id = isset($_POST["shift_id"]) ? $_POST["shift_id"] : '';
        $stop_id = isset($_POST["stop_id"]) ? $_POST["stop_id"] : '';
        $stop_detail_id = isset($_POST["stop_detail_id"]) ? $_POST["stop_detail_id"] : '';
        $trip = isset($_POST["trip_id"]) ? $_POST["trip_id"] : 0;
        if ($shift_id > 0 && $stop_id > 0) {
            $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);
            $whr = ["shipment_id" => $shift_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "status" => 1];
            $qry = $this->db->select("id,doc_type,stop_type,imgpath,hash,latitude,longitude,convertToClientTZ(createdon,'" . $curtz . "') as createdon")->get_where("tb_pod_uploads", $whr);
            if ($qry->num_rows() > 0) {
                $resdata = [];
                foreach ($qry->result() as $res) {
                    $docurl = base_url() . 'downloadEpod/safelink/' . $res->hash. '.epod';
                    $doctype = "Others";
                    if ($res->doc_type == "3" && $res->stop_type == "P") {
                        $doctype = "POP";
                    } else {
                        if ($res->doc_type == "3" && $res->stop_type == "D") {
                            $doctype = "POD";
                        } else {
                            if ($res->doc_type == "1") {
                                $doctype = "Signature";
                            }
                        }
                    }
                    $resdata[] = ["id" => $res->id, "doc_type" => $doctype, "url" => $docurl, "latitude" => $res->latitude, "longitude" => $res->longitude, "createdon" => strtotime($res->createdon)];
                }
                $response = ["status" => 1, "data" => $resdata];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function removestoppod()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }
        $id = $_POST["id"] ?? '';
        if (empty($id)) {
            throw new NoDataFoundException("Document ID not received.");
        } else {
            $where = ["id" => $id, "status" => 1];
            $uploads = $this->db->select("id,order_id,doc_type,imgpath")->get_where("tb_pod_uploads", $where);
            if ($uploads->num_rows() == 0) {
                throw new NoDataFoundException("No document found.");
            } else {
                $this->db->where($where)->update("tb_pod_uploads", ["status" => 0]);
                $order_id = $uploads->row()->order_id;
                $doc_type = $uploads->row()->doc_type;
                $filePath = $uploads->row()->imgpath;
                $payload = new RemovePodPayload($order_id, $filePath, $doc_type, "Remove");
                $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_REMOVE_POD, $payload));
                $response = ["status" => 1, "message" => "Removed Successfully"];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function uoms()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        if ($user_id > 0) {
            $data[] = ["id" => '11', "name" => "Pallet"];
            $data[] = ["id" => '16', "name" => "PCs"];
            $data[] = ["id" => '15', "name" => "Boxes"];
            $data[] = ["id" => '13', "name" => "Shipment"];
            $response = ["status" => 1, "data" => $data];
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function customers()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $sql = "SELECT id,name,code FROM tb_customers WHERE (name LIKE '%" . $cidname . "%' OR code LIKE '%" . $cidname . "%') AND status=1";
            $qry = $this->db->query($sql);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = ["id" => $res->id, "name" => $res->name, "cid" => $res->code];
                }
                $response = ["status" => 1, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function parties()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $sql = "SELECT id,name,mobile,address,location_id,state,country FROM tbl_party_master WHERE name != 'Carrier' AND (name LIKE '%" . $cidname . "%' OR mobile LIKE '%" . $cidname . "%') AND user_id=$user_id AND status=1";
            $qry = $this->db->query($sql);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = [
                        "id" => $res->id,
                        "name" => $res->name,
                        "cid" => $res->mobile,
                        "address" => $res->address,
                        "location_id" => $res->location_id,
                        "state" => $res->state,
                        "country" => $res->country
                    ];
                }
                $response = ["status" => 1, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function refnums()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $cidname = isset($_POST['name']) ? $_POST['name'] : "";
        if ($user_id > 0 && $cidname != "") {
            $sql = "SELECT id,name,description FROM tb_reference_master WHERE name LIKE '%" . $cidname . "%' AND status=1";
            $qry = $this->db->query($sql);
            if ($qry->num_rows() > 0) {
                foreach ($qry->result() as $res) {
                    $data[] = ["id" => $res->id, "name" => $res->description, "cid" => $res->name];
                }
                $response = ["status" => 1, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function drivercollection()
    {
        ob_start();

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }

        $driver_id = $_POST['driver_id'] ?? 0;
        $user_id = $_POST['user_id'] ?? 0;
        $imei = $_POST['imei'] ?? '';

        $curtz = PostTimezoneFilter::getCurtz($_POST['timezone'] ?? null);

        if (empty($_POST['data'])) {
            throw new BadRequestException("Insufficient Input Data");
        }
        $data = json_decode($_POST['data'], true);
        if (!isset($data['customer_id']) || $data['customer_id'] == '' || empty($driver_id) || empty($user_id)) {
            throw new BadRequestException("Insufficient Input Data");
        }

        $driverCollection = new DriverCollection($this);
        $result = $driverCollection->create($data, $driver_id, $user_id, $imei);

        $created_source = "";
        $uid = 0;
        $ord_id = 0;

        $createdSource = $this->db->query(
            "SELECT id, user_id, created_source
                FROM tb_orders
                WHERE shift_id = ? LIMIT 1",
            [$result['data']['trips']['shift_id']]
        );

        if ($createdSource->num_rows() > 0) {
            $created_source = $createdSource->row()->created_source;
            $ord_id = $createdSource->row()->id;
            $uid = $createdSource->row()->user_id;
        }

        try {
            $payload = DriverCollectionPayloadFactory::create(
                $created_source,
                $ord_id,
                $result['data']['orderSequence'],
                $result['data']['stopLegId'],
                $result['data']['trips']['vehicle_id'],
                $result['data']['trips']['driver_id'],
                $result['data']['trips']['shift_id'],
                $result['data']['trips']['id'],
                $result['data']['trips']['slat'],
                $result['data']['trips']['slng'],
                $uid,
                $curtz,
                $result['data']['hrs']
            );
            $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_DRIVER_COLLECTION, $payload));
        } catch (Exception $ex) {
            throw new BadRequestException("Shipment created but event processing failed!");
        }

        $response = Printable::printable([
            'status' => 1,
            'data'   => [
                'trips' => $result['data']['trips']
            ]
        ]);

        ob_end_clean();

        echo json_encode($response);
    }

    public function getQuantities()
    {
       ////log_message("error","Innn:");
        $response = ["status" => 0, "message" => "Not Found"];
        log_message("error","post::".json_encode($_POST));
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";

        if (isset($_POST)) {
            $data = [];
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query("SElECT o.id FROM tb_orders o,tb_shiporder_stops s WHERE o.shift_id=s.shipment_id AND s.id='$stop_id' AND o.shift_id='$shift_id' AND s.shipment_id='$shift_id' and o.order_id in ($order_id) GROUP BY o.id");
               log_message("error","qry::".$this->db->last_query());
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $qry1 = $this->db->query("SElECT e.id,e.unit_name,sum(o.quantity) as quantity, o.handling_unit as cargoId, o.cargo_id FROM tbl_shipunit_types e,tb_order_cargodetails o WHERE e.id=o.handling_unit and o.order_id='$res->id' and o.status=1 GROUP BY o.cargo_id");
                       log_message("error","cargoData:".$this->db->last_query());
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $whr = ["stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id, "cargo_type_id" => $res1->cargo_id];
                                $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                                if ($updates->num_rows() > 0) {
                                    $data[] = ["cargo_type_id" => $res1->cargo_id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => $updates->row()->scanned_quantity];
                                } else {
                                    $data[] = ["cargo_type_id" => $res1->cargo_id, "cargo_type" => $res1->unit_name, "quantity" => $res1->quantity, "scanned_quantity" => 0];
                                }
                            }
                        }
                    }
                }
                $response = ["status" => 1, "data" => $data];
            }
        }
        $response = Printable::printable($response);
        log_message("error","Response::".json_encode($response));
        echo json_encode($response);
    }

    public function setQuantities()
    {
       //log_message("error","Innn111:");
        $response = ["status" => 0, "message" => "Not Found"];
        //log_message("error","post111::".json_encode($_POST));
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $stop_id = isset($_POST['stop_id']) ? $_POST['stop_id'] : "";
        $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
        $stop_detail_id = isset($_POST['stop_detail_id']) ? $_POST['stop_detail_id'] : "";
        $shift_veh_id = isset($_POST['shift_veh_id']) ? $_POST['shift_veh_id'] : "";
        $shift_id = isset($_POST['shift_id']) ? $_POST['shift_id'] : "";
        $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : "";
        $cargos_types1 = isset($_POST['cargos_types']) ? json_decode($_POST['cargos_types'],true) : [];
        
        $orderId = 0;
        //log_message("error","cargos_types1::".json_encode($cargos_types1));

        file_put_contents('setQuantities.txt', json_encode($_POST));
        if (isset($_POST)) {
            $quantities = [];
            if ($shift_id > 0 && $stop_id > 0 && $trip_id != "") {
                $qry = $this->db->query("SElECT o.id FROM tb_orders o,tb_shiporder_stops s WHERE o.shift_id=s.shipment_id AND s.id='$stop_id' AND o.shift_id='$shift_id' and o.order_id='$order_id' AND s.shipment_id='$shift_id' GROUP BY o.id");
                //log_message("error","qry111::".$this->db->last_query());
                if ($qry->num_rows() > 0) {
                    foreach ($qry->result() as $res) {
                        $orderId = $res->id;
                        $qry1 = $this->db->query("SElECT e.id,sum(o.quantity) as quantity FROM tbl_shipunit_types e,tb_order_cargodetails o WHERE e.id=o.handling_unit AND o.order_id='$res->id' GROUP BY e.id");
                       //log_message("error","cargoData222:".$this->db->last_query());
                        if ($qry1->num_rows() > 0) {
                            foreach ($qry1->result() as $res1) {
                                $quantities[$res1->id] = $res1->quantity;
                            }
                        }
                    }
                }
            }
            if (!is_array($cargos_types1)) {
                $cargos_types = [];
            } else {
                $cargos_types = $cargos_types1;
            }
            //log_message("error","cargos_types::".json_encode($cargos_types));
            
            $total_accepted_quantity = 0;
            if (!empty($cargos_types)) {
                foreach ($cargos_types as $cargo) {
                    $data = [];
                    $whr = ["driver_id" => $driver_id, "user_id" => $user_id, "stop_id" => $stop_id, "stop_detail_id" => $stop_detail_id, "shift_id" => $shift_id, "trip_id" => $trip_id, "cargo_type_id" => $cargo['cargo_type_id']];
                    $data = $whr;
                    $updates = $this->db->get_where("tb_cargo_driver_updates", $whr);
                   //log_message("error","cargoData333:".$this->db->last_query());
                   //log_message("error","cargo:".json_encode($cargo));
                   //log_message("error","111:".$cargo['cargo_type_id']);
                   //log_message("error","222:".$cargo['scanned_quantity']);
                   //log_message("error","333:".$cargo['quantity']);
                    
                    if ($updates->num_rows() > 0) {
                        $data["cargo_type_id"] = $cargo['cargo_type_id'];
                        $data["scanned_quantity"] = $cargo['scanned_quantity'];
                        $data["quantity"] = $cargo['quantity'];
                        $upd = $this->db->where($whr)->update("tb_cargo_driver_updates", $data);
                        $upd1 = $this->db->where(["order_id" => $orderId, "cargo_id" => $cargo['cargo_type_id']])->update("tb_order_cargodetails", ["scanned_quantity" => $cargo['scanned_quantity']]);
                       //log_message("error","OrderQry11:".$this->db->last_query());
                    } else {
                        $data["cargo_type_id"] = $cargo['cargo_type_id'];
                        $data["scanned_quantity"] = $cargo['scanned_quantity'];
                        $data["quantity"] = $cargo['quantity'];
                        $ins = $this->db->insert("tb_cargo_driver_updates", $data);
                        $upd1 = $this->db->where(["order_id" => $orderId, "cargo_id" => $cargo['cargo_type_id']])->update("tb_order_cargodetails", ["scanned_quantity" => $cargo['scanned_quantity']]);
                       //log_message("error","OrderQry:".$this->db->last_query());
                    }
                }
            }
            $quantity = $this->db->query("SELECT sum(scanned_quantity) as quantity FROM tb_cargo_driver_updates WHERE shift_id = '$shift_id' AND stop_id = '$stop_id' AND status = '1'");
            //log_message("error","cargoData444:".$this->db->last_query());
            if ($quantity->num_rows() > 0) {
                $upd = $this->db->where(["shipment_id" => $shift_id, "id" => $stop_id])->update("tb_shiporder_stops", ["ship_units" => $quantity->row()->quantity]);
               //log_message("error","cargoData555:".$this->db->last_query());
            }
            $response = ["status" => 1];
        }
        $response = Printable::printable($response);
        //log_message("error","Response1111::".json_encode($response));
        echo json_encode($response);
    }

    public function generateQRCodes($cargo_id, $cargodata)
    {
        $this->load->library('barcode');
        $handling_unit = $cargodata["handling_unit"];
        $quantity = $cargodata["quantity"];
        $data = [];
        $data["order_cargo_details_id"] = $cargo_id;
        $data["handling_unit"] = $handling_unit;
        $data["quantity"] = $quantity;
        $data["path"] = $this->barcode->generate(json_encode(["cargo_id" => $handling_unit, "quantity" => $quantity]));
        $ins = $this->db->insert("tb_order_cargo_qrdetails", $data);
    }

    public function updatepassword()
    {
        $response = ["status" => 0, "message" => "Not Found"];
        $driver_id = isset($_POST['driver_id']) ? $_POST['driver_id'] : 0;
        $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
        $newpassword = isset($_POST['newpassword']) ? $_POST['newpassword'] : "";
        if (isset($_POST)) {
            if ($driver_id > 0 && $user_id > 0 && $newpassword != "") {
                $chk = $this->db->select("id")->get_where("tb_truck_drivers", ["id" => $driver_id], 1, 0);
                if ($chk->num_rows() > 0) {
                    $pwd = password_hash($newpassword, PASSWORD_DEFAULT);
                    $upd = ["password" => $pwd];
                    $updqry = $this->db->set($upd)->where(["id" => $driver_id])->update("tb_truck_drivers");
                    $response = ["status" => 1];
                }
            }
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function bookorderquote()
    {
        $response = ["status" => 0, "message" => "Something went wrong!"];
        if (isset($_POST)) {
            /*$post = json_decode($_POST['data']);
            $data = (array)$post;*/
            $post = $_POST;
            $cust_id = isset($post['cust_id']) ? $post['cust_id'] : '';
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $orderid = isset($post['order_id']) ? $post['order_id'] : '';
            $response = ["status" => 1, "data" => ["status" => "Booking Complete", "order_id" => $orderid]];
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function panicAlert()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            throw new MethodNotAllowedException("Not allowed to use " . $_SERVER['REQUEST_METHOD'] . " in here.");
        }
        $userId = $_POST['user_id'] ?? 0;
        $getUsers = $this->common->gettblrowdata(["id" => $userId], "country_code", "tb_users", 0, 0);
        if (empty($getUsers)) {
            throw new BadRequestException("InCountryCode not found for User");
        }

        $driverId = $_POST['driver_id'] ?? 0;
        $tripId = $_POST['trip_id'] ?? 0;
        if (empty($driverId) || empty($tripId)) {
            throw new BadRequestException("DriverId or TripId empty");
        }

        $vehicleId = $_POST['vehicle_id'] ?? 0;

        $checkShift = $this->db->query(
            "SELECT s.id,s.splace,s.stime,s.eplace,s.etime,s.shipmentid
                FROM tb_shifts s,tb_trips t
                WHERE s.id=t.shift_id AND t.id=? AND s.status='1' AND t.status='1' LIMIT 1",
            [$tripId]
        );
        
        if ($checkShift->num_rows() == 0) {
            throw new BadRequestException("No trip found with provided input");
        }
        $data = [
            "user_id" => $userId,
            "driver_id" => $driverId,
            "trip_id" => $tripId,
            "lat" => $_POST['latitude'] ?? '',
            "lng" => $_POST['longitude'] ?? '',
            "clicked_on" => date("Y-m-d H:i:s", strtotime($_POST['clicked_on'] ?? '')),
            "vehicle_id" => $vehicleId,
            "shift_id" => $checkShift->row()->id,
            "splace" => $checkShift->row()->splace,
            "stime" => $checkShift->row()->stime,
            "eplace" => $checkShift->row()->eplace,
            "etime" => $checkShift->row()->etime,
            "shipmentid" => $checkShift->row()->shipmentid,
            "driver_name" => "",
            "contact_num" => "",
            "register_number" => ""
        ];
        $drivers = $this->db->select("name,contact_num")->where("id", $driverId)->get(
            "tb_truck_drivers"
        );
        if ($drivers->num_rows() > 0) {
            $data['driver_name'] = $drivers->row()->name;
            $data['driver_mobile'] = $drivers->row()->contact_num;
        }
        $vehicles = $this->db->select("register_number")->where("id", $vehicleId)->get(
            "tb_trucks_data"
        );
        if ($vehicles->num_rows() > 0) {
            $data['register_number'] = $vehicles->row()->register_number;
        }
        $existingAlerts = $this->db->where(["driver_id" => $driverId, "status" => 1])->get("tb_panic_alerts");
        if ($existingAlerts->num_rows() > 0) {
            $data["updated_by"] = $userId;
            $this->db->where(["id" => $existingAlerts->row()->id])->update("tb_panic_alerts", $data);
        } else {
            $data["created_by"] = $userId;
            $this->db->insert("tb_panic_alerts", $data);
        }
        $this->processPanicAlertEmail($getUsers['country_code'], $data);
        $response = ["status" => 1, "data" => null, "message" => "Success"];

        $response = Printable::printable($response);
        echo json_encode($response);
    }

    private function processPanicAlertEmail($country_code, array $data): void
    {
        if (!in_array($country_code, ['TH', 'VN'])) {
            if (!empty($data['register_number']) && !empty($data['driver_name']) && !empty($data['driver_mobile']) && !empty($data['shift_id'])) {
                $users = $this->db->select("name,emailid")->get_where("tb_users", ["id" => $data["user_id"]], 1, 0);
                if ($users->num_rows() != 0 && !empty($users->row()->emailid)) {
                    $payload = PanicAlertPayloadFactory::create(
                        $users->row()->name,
                        $users->row()->emailid,
                        $data['register_number'],
                        $data['lat'],
                        $data['lng'],
                        $data['driver_name'],
                        $data['driver_mobile'],
                        $data["shipmentid"],
                        $data['splace'],
                        $data['eplace']
                    );
                    $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_PANIC_ALERT, $payload));
                }
            }
        }
    }

    public function getdrivervehforswap()
    {
        $response = ["status" => 0, "data" => null];

        if (isset($_POST)) {
            $post = $_POST;
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $driver_id = isset($post['driver_id']) ? $post['driver_id'] : '';
            $vehicle_id = isset($post['vehicle_id']) ? $post['vehicle_id'] : '';
            $trip_id = isset($post['trip_id']) ? $post['trip_id'] : '';
            $lat = isset($post['latitude']) ? $post['latitude'] : '';
            $lng = isset($post['longitude']) ? $post['longitude'] : '';

            $data = $result = [];

            if ($driver_id != "" && $vehicle_id != "" && $user_id != "") {
                $data["user_id"] = $user_id;
                $data["driver_id"] = $driver_id;
                $data["trip_id"] = $trip_id;
                $data["lat"] = $lat;
                $data["lng"] = $lng;
                $data["vehicle_id"] = $vehicle_id;
                $chkveh = $this->db->query("SELECT t.id,t.register_number FROM tb_truck_drivers v INNER JOIN tb_vehicles_drivers d ON d.driver_id=v.id INNER JOIN tb_trucks_data t ON t.id=d.vehicle_id WHERE d.vehicle_id!=$vehicle_id AND v.user_id=$user_id AND t.user_id=$user_id AND v.status=1 AND d.status=1 AND t.status='Active' GROUP BY t.id,t.register_number ORDER BY t.register_number ASC");
                if ($chkveh->num_rows() > 0) {
                    foreach ($chkveh->result_array() as $row) {
                        $active_trips = $this->common->gettblrowdata(["vehicle_id" => $row['id'], "status" => 1], "id",
                            "tb_trips", 0, 0);
                        if (count($active_trips) == 0) {
                            $result[] = $row;
                        }
                    }
                }

                $response = ["status" => 1, "data" => $result, "message" => "Success"];
            }
        }

        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function getdriverswapvehicle()
    {
        $response = ["status" => 0, "data" => null];
        if (isset($_POST)) {
            $post = $_POST;
            $user_id = isset($post['user_id']) ? $post['user_id'] : '';
            $driver_id = isset($post['driver_id']) ? $post['driver_id'] : '';
            $vehicle_id = isset($post['vehicle_id']) ? $post['vehicle_id'] : '';
            $newvehicle_id = isset($post['newvehicle_id']) ? $post['newvehicle_id'] : '';
            $trip_id = isset($post['trip_id']) ? $post['trip_id'] : '';
            $lat = isset($post['latitude']) ? $post['latitude'] : '';
            $lng = isset($post['longitude']) ? $post['longitude'] : '';
            $imei = isset($post['imei']) ? $post['imei'] : '';
            $data = [];
            $resp = "Already swapped!";
            $status_res = "0";
            if ($driver_id != "") {
                $data["driver_id"] = $driver_id;
                $data["trip_id"] = $trip_id;
                $data["vehicle_id"] = $newvehicle_id;
                $data["imei"] = $imei;
                $whr = ["trip_id" => $trip_id, "vehicle_id" => $vehicle_id, "status" => 1];
                $chktrip = $this->common->gettblrowdata($whr, "id", "tb_trip_vehicles", 0, 0);
                if (count($chktrip) == 0) {
                    $ins = $this->common->insertTableData("tb_trip_vehicles", $data);
                }
                $records = $this->common->gettblrowdata(["id" => $trip_id], "shift_id", "tb_trips", 0, 0);
                if (count($records) > 0) {
                    $shift_id = $records["shift_id"];
                    $whr = ["id" => $newvehicle_id];
                    $newregister_number = $this->common->gettblrowdata($whr, "register_number", "tb_trucks_data", 0, 0);
                    if (count($newregister_number) > 0) {
                        $newregisternumber = $newregister_number['register_number'];
                        $this->common->updatetbledata("tb_shft_veh", ["register_number" => $newregisternumber, "vehicle_id" => $newvehicle_id], ["shft_id" => $shift_id, "vehicle_id" => $vehicle_id, "status" => 1]);
                    }
                    $vehdriver = 0;
                    $whr = ["vehicle_id" => $newvehicle_id, "status" => 1];
                    $newvehassignchk = $this->common->gettblrowdata($whr, "id,driver_id", "tbl_assigned_drivers", 0, 0);
                    $newdriver_id = 0;
                    if (count($newvehassignchk) > 0) {
                        $vehdriver = $newvehassignchk['id'];
                        $newdriver_id = $newvehassignchk['driver_id'];
                    } else {
                        $whr = ["vehicle_id" => $newvehicle_id, "status" => 1];
                        $newvehassignchk1 = $this->common->gettblrowdata($whr, "id,driver_id", "tb_vehicles_drivers", 0, 0);
                        if (count($newvehassignchk1) > 0) {
                            $newdriver_id = $newvehassignchk1['driver_id'];
                        }
                    }
                    if ($newdriver_id > 0) {
                        $tripwhr = ["vehicle_id" => $newvehicle_id, "status" => 1];
                        $tripveh = $this->common->gettblrowdata($tripwhr, "id", "tb_trips", 0, 0);
                        if (count($tripveh) == 0) {
                            if ($vehdriver == 0) {
                                $imei = $mobileno = "";
                                $vehwhr = ["id" => $newdriver_id];
                                $vehchk = $this->common->gettblrowdata($vehwhr, "id,contact_num", "tb_truck_drivers", 0, 0);
                                if (count($vehchk) > 0) {
                                    $mobileno = $vehchk['contact_num'] ?? '';
                                }
                                $insarr = ["vehicle_id" => $newvehicle_id, "user_id" => $user_id, "driver_id" => $newdriver_id, "mobile_no" => $mobileno, "imei" => $imei, "status" => 1];
                                $this->common->insertTableData("tbl_assigned_drivers", $insarr);
                            }
                            $updset1 = ["driver_id" => $newdriver_id, "vehicle_id" => $newvehicle_id];
                            $updwhr1 = ["id" => $trip_id];
                            $this->common->updatetbledata("tb_trips", $updset1, $updwhr1);
                            $resp = "Success";
                            $status_res = "1";
                        } else {
                            $status_res = "0";
                            $resp = "Selected vehicle already having an active trip, so you cannot swap with this vehcile!";
                        }
                    }
                }
            }
            $response = ["status" => $status_res, "data" => $resp, "message" => "Success"];
        }
        $response = Printable::printable($response);
        echo json_encode($response);
    }

    public function sendnotify($action, $orderid, $attach = null)
    {
        /*log_message('error','Mobile Driver Api V2 Called');*/
        if (!empty($orderid)) {
            $this->load->library('notifytrigger');
            if ($attach != null) {
                $info['attachment'] = $attach;
            }
            $info['page_title'] = 'Booking Notification';

            $orderinfo = $this->common->gettblrowdata(['id' => $orderid], 'id,order_id', 'tb_orders', 0, 0);
            if (count($orderinfo) > 0) {
                $info['order_id'] = $orderinfo['id'];
                $info['orderid'] = $bookingId = $orderinfo['order_id'];
                $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $info['action'] = $action;
                $info['cargos'] = $this->common->gettbldata(['order_id' => $info['order_id']], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $sendnote = $this->notifytrigger->sendordernotify($info);
            }
        }
    }

    /**
     * @param array $result
     * @param string $type
     * @param string $driver
     * @return array
     */
    private function createShipmentsResponseArray(array $result, string $type, string $driver): array
    {
        $res = [];
        $shipmentIds = [];
        $res['trips'] = [];
        $i = 0;

        $res['doc_types'] = $this->db->select('id,type_name')->get_where('tb_document_types', ['status' => 1])->result_array();

        foreach ($result as $shiftData) {
            $pod = "";
            $signature = "";
            $createdSource = $shiftData['created_source'] ?? 0;
            if ($createdSource == 18) {
                $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $shiftData['order_id'], 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
                $shiftData['kn_tracking_no'] = $getTrackingNumber['ref_value'] ?? "";
            }
            $shiftData['shipweight'] = 0;
            $targetShiftIds = [$shiftData['shift_id']];
            $shipmentIds[] = $shiftData['shipmentid'];

            if (!empty($shiftData["shift_leg_id"])) {
                $targetShiftIds[] = $shiftData['shift_leg_id'];
            }

            unset($shiftData["shift_leg_id"]);

            if ($shiftData["order_id"] === null) {
                unset($shiftData["order_id"]);
            }

            [$stopscount, $dstop, $sstop, $shiftData] = $this->extractShipOrderStopsWithIds($shiftData);
            $shiftData['source'] = $shiftData['destination'] = $shiftData['source_party'] = $shiftData['dest_party'] = "";

            /* get shipper and consignee parties to get full address */
            if ((int)$stopscount === 2) {
                $partyaddr = GetPartyInformation::getPartyInfoByOrderId($shiftData['order_id'], $this->db);
            } else {
                $stopsarr = [
                    'sstop' => $sstop,
                    'dstop' => $dstop,
                    'shipment_id' => $shiftData['shift_id'],
                    'cmpcode' => $shiftData['company_code']
                ];

                $partyaddr = GetPartyInformation::getPartyAddrByOrdStops($stopsarr, $i, $this->db);
            }

            if (!empty($partyaddr)) {
                if (!empty($partyaddr['source'])) {
                    $shiftData['source'] = $partyaddr['source'];
                    $shiftData['source_party'] = $partyaddr['source_party'];
                }
                if (!empty($partyaddr['destination'])) {
                    $shiftData['destination'] = $partyaddr['destination'];
                    $shiftData['dest_party'] = $partyaddr['dest_party'];
                }
            }

            [$pickup, $drop] = $this->addressesFromShift($shiftData);
            $shiftData["splace"] = ucfirst(strtolower($pickup));
            $shiftData["eplace"] = ucfirst(strtolower($drop));
            $shiftData["scity"]  = ucfirst(strtolower($shiftData["scity"]));
            $shiftData["dcity"]  = ucfirst(strtolower($shiftData["dcity"]));
            $shiftData["delivery_datetime"]  = date("d-m-Y h:i A",strtotime($shiftData["delivery_datetime"] ?? ""));
            if ($type == "") {
                if ($shiftData['id'] == "") {
                    $shiftData['astatus'] = '';

                    $trip = $this->db->query("
                                SELECT id,transit_status
                                FROM tb_trips
                                WHERE driver_id=? AND shift_id=?
                                AND status=1 ORDER BY id DESC LIMIT 1", [$driver, $shiftData["shift_id"]]);

                    if ($trip->num_rows() > 0) {
                        $shiftData['astatus'] = 0;

                        if ($trip->row()->transit_status == 1) {
                            $shiftData['astatus'] = 1;
                        }

                        $shiftData["id"] = $trip->row()->id;
                    }
                } else {
                    [$signature, $pod] = $this->checkSignatureAndPod($shiftData);
                }

                $dist = distancemetrixship($shiftData['slat'] ?? null, $shiftData['slng'] ?? null, $shiftData['elat'] ?? null, $shiftData['elng'] ?? null);

                $shiftData['distance'] = !empty($dist['disttext']) ? $dist['disttext'] : '-';
                $shiftData['duration'] = !empty($dist['duratext']) ? $dist['duratext'] : '-';
                $shiftData['startdate'] = strtotime($shiftData['startdate']);
                $shiftData['enddate'] = strtotime($shiftData['enddate']);
                $shiftData['pod'] = $pod;
                $shiftData['signature'] = $signature;
                $res['trips'][] = $shiftData;

                $i++;
            } else {
                [$signature, $pod] = $this->checkSignatureAndPod($shiftData);
                $dist = distancemetrixship($shiftData['slat'] ?? null, $shiftData['slng'] ?? null, $shiftData['elat'] ?? null, $shiftData['elng'] ?? null);

                $shiftData['distance'] = $dist['disttext'];
                $shiftData['duration'] = $dist['duratext'];
                $shiftData['startdate'] = strtotime($shiftData['startdate']);
                $shiftData['enddate'] = strtotime($shiftData['enddate']);

                if (!isset($shiftData['astatus']) || $shiftData['astatus'] === '-1') {
                    $shiftData['astatus'] = '';
                }

                $shiftData['pod'] = $pod;
                $shiftData['signature'] = $signature;
                $res['trips'][] = $shiftData;
            }
        }

        $res = $this->calculateShipmentWeight($res, $shipmentIds);

        return ["status" => 1, "data" => $res];
    }

    /**
     * @param $shipments
     * @return int
     */
    private function notStartedShipmentLegsCount($shipments): int
    {
        $legsCount = 0;
        foreach ($shipments as $shipmentArray) {
            $shipment = (object)$shipmentArray;
            $shift_id = $shipment->shift_id ?? '';
            $chkshifts = $this->db->select("shift_leg_id")->get_where("tb_shifts", ["id" => $shift_id], 1, 0);
            
            $shift_leg_id = $chkshifts->row()->shift_leg_id;
            if ($shift_leg_id == 0) {
                $legsCount++;
            } else {
                $orderstatus = 0;
                $orderqry = "SELECT tbe.order_id,tr.id FROM tb_employee tbe left outer join tb_orders tr on tbe.order_id=tr.order_id WHERE tbe.shift_id='" . $shift_id . "'";
                $orderqryId = $this->db->query($orderqry);
                if ($orderqryId->num_rows() > 0) {
                    foreach ($orderqryId->result() as $res) {
                        $leg_ord_no = $res->order_id;
                        $legordno = $res->id;
                        $legstatus = 0;
                        $ordershiftsqry = "SELECT shift_id FROM tb_employee tbe LEFT OUTER JOIN tb_shifts ts ON tbe.shift_id=ts.`id` WHERE tbe.order_id='" . $leg_ord_no . "' AND ts.`shift_leg_id`!=0  AND ts.`id`<'$shift_id' ORDER BY ts.`id` ASC";
                       
                        $ordershifts = $this->db->query($ordershiftsqry);
                        if ($ordershifts->num_rows() > 0) {
                            foreach ($ordershifts->result() as $res) {
                                $ord_shift_id = $res->shift_id;
                                $ordershiftsstatusqry = "SELECT * FROM tb_stop_status WHERE order_id='" . $legordno . "' AND `shipment_id`='" . $ord_shift_id . "' AND `stop_type`='D' AND `status_id`='3'";
                                
                                $ordershiftsstatus = $this->db->query($ordershiftsstatusqry);
                                if ($ordershiftsstatus->num_rows() > 0) {
                                    $legstatus++;
                                }
                            }
                            if ($legstatus == $ordershifts->num_rows()) {
                                $orderstatus++;
                            }
                        } else {
                            $orderstatus++;
                        }
                    }
                }
                if ($orderstatus == $orderqryId->num_rows()) {
                    $legsCount++;
                }
            }
        }
        return $legsCount;
    }

    private function shippeoStatusEventTrigger(array $data): void
    {
        if ($data['info']['created_source'] == 18) {
            $postdata = [
                "shipment_id" => $data["shift_id"],
                "trip_id" => $data['info']['trip_id'],
                "driver_id" => $data["driver_id"],
                "stop_id" => '',
                "order_id" => $data['order']['order_id'],
                "latitude" => $data['info']['latitude'],
                "longitude" => $data['info']['longitude'],
                "stop_type" => '',
                "vehicle_id" => $data["vehicle_id"],
                "curtz" => $data['info']['curtz'],
                "hrs" => $data['info']['hrs'],
                "status_code" => "SV0120",
                "ord_id" => $data['order']['id'] ?? "",
            ];
            $this->shippeoStatusEvent($data['order']['id'], $postdata, $data['info']['curtz'], '273', '', $data["vehicle_id"], $data['order']['company_code'], $data['order']['branch_code'], $data['info']['orduser_id']);
        }
    }
    private function shippeoStatusEvent(string $ord_id, array $postdata, string $curtz, string $stid, string $stype, string $vehicle_id, string $company_code, string $branch_code, string $lgusrid): void
    {
        $edi_reference = $this->shippeostatusintigration->is_shippeo_order($ord_id, $company_code, $branch_code);
       
        if ($edi_reference != 0) {
            $this->shippeostatusintigration->shippeo_event_call($ord_id, $postdata, $curtz, $stid, $stype, $vehicle_id, $edi_reference, $company_code, $branch_code, $lgusrid);
        }
    }

    private function calculateShipmentWeight(array $res, array $shipmentIds): array
    {
        if (empty($shipmentIds)) {
            return $res;
        }

        $shipmentWeight = $this->db->query('SELECT SUM(cargo.weight) as weight, o.shipmentid
            FROM tb_order_cargodetails cargo
            JOIN tb_orders o ON cargo.order_id = o.id
            WHERE cargo.status = 1
                AND o.shipmentid IN ?
            GROUP BY o.shipmentid', [$shipmentIds]);

        if ($shipmentWeight === false) {
            return $res;
        }

        $shipmentWeight = $shipmentWeight->result_array();

        foreach ($res['trips'] as $key => $trip) {
            foreach ($shipmentWeight as $singleShipmentWeight) {
                if ($singleShipmentWeight['shipmentid'] === $trip['shipmentid']) {
                    $res['trips'][$key]['shipweight'] = $singleShipmentWeight['weight'];
                }
            }
        }

        return $res;
    }

    /**
     * @param $trip_id
     * @param int $uid
     * @param string $created_source
     * @param int $ord_id
     * @param int $vehicle
     * @param $driver_id
     * @param $shipment_id
     * @param $latitude
     * @param $longitude
     * @param string $curtz
     * @param $stop_id
     * @param string $legsorder_id
     * @param $stsreason
     * @param $stop_type
     * @param $comment
     * @return string
     */
    private function dispatchEventMilestoneStatus($trip_id, int $uid, string $created_source, int $ord_id, int $vehicle, $driver_id, $shipment_id, $latitude, $longitude, string $curtz, $stop_id, string $legsorder_id, $stsreason, $stop_type, $comment): string
    {
        log_error('dispatchEventMilestoneStatus => '.json_encode(
                [
                    'trip_id' => $trip_id,
                    'uid' => $uid,
                    'created_source' => $created_source,
                    'ord_id' => $ord_id,
                    'vehicle' => $vehicle,
                    'driver_id' => $driver_id,
                    'shipment_id' => $shipment_id,
                    'latitude' => $latitude,
                    'longitude' => $longitude,
                    'curtz' => $curtz,
                    'stop_id' => $stop_id,
                    'legsorder_id' => $legsorder_id,
                    'stsreason' => $stsreason,
                    'stop_type' => $stop_type,
                    'comment' => $comment,
                ],
                128)
        );

        $cnt = $this->db->select('id')->get_where('tb_pod_uploads', ['trip_id' => $trip_id])->num_rows();
        if ($cnt == 0) {
            $cntstr = "001";
        } else {
            $cntstr = "00" . $cnt;
            if ($cnt > 9) {
                $cntstr = "0" . $cnt;
            }
        }
        $gethrs = $this->db->query("SELECT cntry_hrs FROM tbl_country_master c,tb_users u WHERE c.country_code=u.country_code AND u.id=? AND c.status=1 LIMIT 1", [$uid]);
        $hrs = $gethrs->num_rows() > 0 ? $gethrs->row()->cntry_hrs : self::DEFAULT_HOURS;

        $payload = MilestoneUpdatePayloadFactory::create(
            $created_source,
            $ord_id,
            $vehicle,
            $driver_id,
            $shipment_id,
            $trip_id,
            $latitude,
            $longitude,
            $uid,
            $curtz,
            $hrs,
            $stop_id,
            $legsorder_id,
            $cntstr,
            $stsreason,
            $stop_type,
            $comment
        );
        $this->eventDispatcher->dispatch(new MobileEvent(MobileEvent::EVENT_MILESTONE_STATUS, $payload));
        return $hrs;
    }
    private function shipmentDetails(
        int $tripID,
        int $shipment_id,
        int $driver_id,
        int $orderId,
        $curtz
    ): array {
        $tripID = $tripID;
        $shiftID = $shipment_id;
        $driverID = $driver_id;
        $curtzEscaped = $this->db->escape_str($curtz);
        $shiftLegId = $this->common->gettblrowdata(["id" => $shipment_id, "status" => 1],"shift_leg_id","tb_shifts",0,0);
        
        if($shiftLegId["shift_leg_id"]>0) {
            $orderData = $this->common->gettblrowdata(["trip_id" => $tripID, "shift_id" =>$shiftLegId["shift_leg_id"], "id" => $orderId], "id,order_id,created_source,delivery_datetime,shipmentid", "tb_orders", 0, 0);
            $info['order_id'] = $orderData['id'];
            $info['booking_id'] = $orderData['order_id'];
            $info['created_source'] = $orderData['created_source'];
            $info['shipmentid'] = $orderData['shipmentid'];
            $info['delivery_datetime'] = date("d-m-Y h:i A", strtotime($orderData['delivery_datetime']));
        }
        $orderData = $this->common->gettblrowdata(["trip_id" => $tripID, "shift_id" => $shiftID, "id" => $orderId], "id,order_id,created_source,delivery_datetime,shipmentid", "tb_orders", 0, 0);
        $info['order_id'] = $orderData['id'];
        $info['booking_id'] = $orderData['order_id'];
        $info['created_source'] = $orderData['created_source'];
        $info['shipmentid'] = $orderData['shipmentid'];
        $info['delivery_datetime'] = date("d-m-Y h:i A", strtotime($orderData['delivery_datetime']));
        if ($info['created_source'] == 18) {
            $getTrackingNumber = $this->common->gettblrowdata(["order_id" => $info['order_id'], 'reference_id' => 'AWB', 'status' => '1'], "ref_value", "tb_order_references", 0, 0);
            $info['kn_tracking_no'] = $getTrackingNumber['ref_value'] ?? "";
        } else {
            $info['kn_tracking_no'] = "";
        }
        $shipmentData = $this->common->gettblrowdata(["id" => $shiftID, "status" => 1], "id,slat,slng,elat,elng,trip_type,convertToClientTZ(startdate,'" . $curtzEscaped . "') as startdate,convertToClientTZ(enddate,'" . $curtzEscaped . "') as enddate,splace,eplace,scity,dcity,company_code,border_type,shift_leg_id", "tb_shifts", 0, 0);
        
        $info['shift_id'] = $shipmentData['id'];
        $info['trip_type'] = $shipmentData['trip_type'];
        $info['startdate'] = (string)$shipmentData['startdate'];
        $info['enddate'] = (string)$shipmentData['enddate'];
        $info['splace'] = $shipmentData['splace'];
        $info['eplace'] = $shipmentData['eplace'];
        $info['scity'] = $shipmentData['scity'];
        $info['dcity'] = $shipmentData['dcity'];
        $info['company_code'] = $shipmentData['company_code'];
        $info['border_type'] = $shipmentData['border_type'];
        $info['shift_leg_id'] = $shipmentData['shift_leg_id'];
        $vehicleData = $this->common->gettblrowdata(["shft_id" => $shiftID, "status" => 1], "id,vehicle_id", "tb_shft_veh", 0, 0);
        $info['shift_veh_id'] = $vehicleData['id'];
        $info['vehicle_id'] = $vehicleData['vehicle_id'];
        $transitStatus = $this->common->gettblrowdata(["shift_id" => $shiftID, "driver_id" => $driverID, "status" => 1], "transit_status", "tb_trips", 0, 0);
        $info['astatus'] = $transitStatus['transit_status'];
        $info['id'] = "$tripID";
        $info['driver_id'] = "$driverID";
        [$stopscount, $dstop, $sstop, $info] = $this->extractShipOrderStopsWithIds($info);
        $info['source'] = $info['destination'] = $info['source_party'] = $info['dest_party'] = "";

        /* get shipper and consignee parties to get full address */
        $i = 0;
        if ((int)$stopscount === 2) {
            $partyaddr = GetPartyInformation::getPartyInfoByOrderId($info['order_id'], $this->db);
        } else {
            $stopsarr = [
                'sstop' => $sstop,
                'dstop' => $dstop,
                'shipment_id' => $info['shift_id'],
                'cmpcode' => $info['company_code']
            ];

            $partyaddr = GetPartyInformation::getPartyAddrByOrdStops($stopsarr, $i, $this->db);
        }

        if (!empty($partyaddr)) {
            if (!empty($partyaddr['source'])) {
                $info['source'] = $partyaddr['source'];
                $info['source_party'] = $partyaddr['source_party'];
            }
            if (!empty($partyaddr['destination'])) {
                $info['destination'] = $partyaddr['destination'];
                $info['dest_party'] = $partyaddr['dest_party'];
            }
        }

        [$pickup, $drop] = $this->addressesFromShift($info);
        $info["splace"] = ucfirst(strtolower($pickup));
        $info["eplace"] = ucfirst(strtolower($drop));
        $info["scity"] = ucfirst(strtolower($info["scity"]));
        $info["dcity"] = ucfirst(strtolower($info["dcity"]));
        [$signature, $pod] = $this->checkSignatureAndPod($info);

        $dist = distancemetrixship($shipmentData['slat'] ?? null, $shipmentData['slng'] ?? null, $shipmentData['elat'] ?? null, $shipmentData['elng'] ?? null);

        $info['distance'] = !empty($dist['disttext']) ? $dist['disttext'] : '-';
        $info['duration'] = !empty($dist['duratext']) ? $dist['duratext'] : '-';
        $info['startdate'] = strtotime($info['startdate']);
        $info['enddate'] = strtotime($info['enddate']);
        $info['pod'] = $pod;
        $info['signature'] = $signature;
        $info['shipweight'] = 0;
        $res['trips'][] = $info;
        $shipmentIDs = [$info['shipmentid']];
        $res = $this->calculateShipmentWeight($res, $shipmentIDs);
        //log_message("error","88888:".json_encode($res));
        return $res;
    }
}
