<?php

if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

require_once APPPATH . 'libraries/Sendsms.php';
require_once APPPATH . 'third_party/fpdf/fpdf.php';

use App\Generators\RandomString;
use App\Integrations\Salog\ePod\AbstractXMLData;
use App\Integrations\Salog\ePod\IntegrationService;
use App\Order\Constants\OrderSources;
use App\PodUploads\Constants\DocumentType;
use phpseclib\Net\SFTP;
use App\ApiRequest\SendDocumentGateOut;
/**
 * Driver App V3 For Exclusively to France - Macadam
 *
 * @property CI_Loader load
 * @property common common
 * @property CI_DB_query_builder db
 * @property Driverappv3model drivermodel
 * @property CI_Input input
 * @property CI_Session session
 * @property CI_Upload upload
 * @author Venkatesh Medisetti <venkatesh.m@returntrucks.com>
 * @date 04th Nov 2020
 */
class Driverappv3 extends CI_Controller
{
    private const  KNLOGIN_EPOD_PATH = "/pub/inbound/D3/FO";
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['common' => 'common', 'Driverappv3model' => 'drivermodel','Roadlogtosalogmodel' => 'Roadlogtosalogmodel','completedordersmodel','DeliveryDocumentModel','OtmBookingModel']);
        $this->load->helper(['jwt', 'generic', 'log', 'user_language','thirdparty_helper']);
        $this->load->library(['uuid', 'commonpodedi', 'sendpodtoknservice', 'roadlogsalogdocument', 'standard_document_execution','statusintigration','standard_status_execution','Altovaordercreation']);

        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }

        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');

        date_default_timezone_set(DFLT_TZ);

        self::setBrowserLang($this);
        define("SECURE_LINK_DRIVER_REGISTRATION_ALLOWED_COUNTRIES", ['CNKN', 'TWKN']);
        define(
            "SECURE_LINK_IN_TRANS_SHARE_LOCATION_ALLOWED_COUNTRIES",
            ['CNKN', 'TWKN', 'SGKN', 'MYKN', 'THKN', 'VNKN', 'IDKN', 'IDNKN', 'PHKN', 'HKKN']
        );
    }

    private static function setBrowserLang(CI_Controller $CI): void
    {
        $clientLangHeader = $CI->input->get_request_header('Accept-Language'); // get and explode client request header
        log_info('Client browser lang_headers ' . json_encode($clientLangHeader, JSON_PRETTY_PRINT));

        $detectedBrowserLang = browsersLanguageDetection($clientLangHeader);
        log_info('final Lang to returned :: ' . $detectedBrowserLang);
        if (!$CI->session->has_userdata('site_lang')) {
            // set language to driverApp if not selected any language in APP side
            $CI->session->set_userdata('site_lang', $detectedBrowserLang);
        }
    }

    public function index(string $token = ''): void
    {
        if (!$token) {
            redirect('driverlogin', 'refresh');
        }
        $token = urldecode($token);
        $tokenValidation = self::get_driver_secure_link($token);

        switch (true) {
            case !$tokenValidation['status']:
                $data = [
                    'body_content' => 'driverappv3/error_occured',
                    'response' => $tokenValidation['response']
                ];
                break;
            case ($tokenValidation['response']['shipment_id'] && !$this->drivermodel->checkTripCancellation(
                    $tokenValidation['response']['shipment_id']
                )):
                $data = [
                    'body_content' => 'driverappv3/error_occured',
                    'response' => ['code' => 400, 'error' => 'cancelled', 'error_message' => 'trip_cancelled']
                ];
                break;
            case ($tokenValidation['response']['shipment_id'] &&
                !$this->drivermodel->getTripDriverDetails($tokenValidation['response']['shipment_id'])):
                $data = [
                    'body_content' => 'driverappv3/error_occured',
                    'response' => ['code' => 400, 'error' => 'invalid', 'error_message' => 'Not able to access trip'],
                ];
                break;
            default :
                $data = ['token' => $token];
                $this->session->set_userdata('secure_token_link', 'driverappv3/' . $token);
        }
        $this->load->view("driverappv3/index", $data);
    }

    private static function validateJsonDecode(string $jsonStringifyData, $mandatoryFields): array
    {
        $errors = [];
        $decodedData = json_decode($jsonStringifyData, true);
        if ($decodedData === null) {
            // json_decode() return null if the json cannot be decoded or if the encoded data is deeper than the nesting limit.
            $errors[] = 'Unable to decode JSON \'' . $jsonStringifyData . '\': ' . json_last_error_msg(
                ); // json_last_error_msg() contains information about the error generated by last call to json_decode
        }

        if (!$errors) {
            // Now it is time to check that decoded data are OK according to requirement
            if (!is_array($decodedData)) {
                $errors[] = 'Data must be an array';
            }
            if (!$errors) {
                if (!empty($mandatoryFields)) {
                    foreach ($mandatoryFields as $mandatoryField) {
                        if (!isset($decodedData[$mandatoryField])) {
                            $errors[] = '<b>' . $mandatoryField . '</b> must not be empty'; // do not forget to use i18n for error messages!
                        }
                    }
                }
            }
        }

        if ($errors) {
            set_status_header(400, 'BAD REQUEST');
            self::log_errors(... $errors);
            return ['status' => 0, 'error_status' => 1, 'data' => $errors];
        }
        return $decodedData;
    }

    private static function log_errors(string...$errors)
    {
        foreach ($errors as $error) {
            log_error($error);
        }
    }

    public function setshipstopstatus_multiple(): void
    {
        if ($this->session->userdata('is_login') == '') {
            redirect('driverlogin', 'refresh');
        }

        $global_post = $_POST;
        $errors = $this->validate_setshipstopstatus_multiple_data();
        if ($errors) {
            echo json_encode(['status' => 0, 'data' => $errors]);
            return;
        }
        $status = $this->input->post('status', true);
        $status_type = $this->input->post('status_type', true);
        $earlyShipmentId = $this->input->post('earlyShipmentId') ?? '';
        $earlyStatusId = $this->input->post('earlyStatusId') ?? '';
        $earlyStatusType = $this->input->post('earlyStatusType') ?? '';
        if($earlyShipmentId != ""){
            $errors = $this->validateCrossBorderEarlyLegStatus(['shipmentId'=>$earlyShipmentId,'statusId'=>$earlyStatusId,'stopType'=>$earlyStatusType]);
            if ($errors != "") {
                echo json_encode(['status' => 0, 'data' => $errors]);
                return;
            }
        }

        //Common data to store in ETN start
        $req_data_var = $status_type == 'P' ? 'pickup_data' : 'drop_data';
        $req_data_mandatory = [
            'status_type',
            'employee_id',
            'order_id',
            'trip_id',
            'shipment_id',
            'stop_type',
            'stop_id',
            'driver_id',
            'stop_detail_type',
            'stop_detail_id'
        ];
        $req_data = $this->validateJsonDecode(
            html_entity_decode($this->input->post($req_data_var, true)),
            $req_data_mandatory
        );
        if (!empty($req_data) && isset($req_data['error_status']) && $req_data['error_status'] === 1) {
            echo json_encode($req_data);

            return;
        }
        //Common data to store in ETN end

        // macadam XML data required fields check;
        $macadam_data_mandatory_fields = ['order_id', 'assoc_id', 'tracking_ref', 'ref_value_kn_office', 'order_city'];
        $macadam_data_input = $this->validateJsonDecode(
            html_entity_decode($this->input->post('macadam_data', true)),
            $macadam_data_mandatory_fields
        );
        if (!empty($macadam_data_input) && isset($macadam_data_input['error_status']) && $macadam_data_input['error_status'] === 1) {
            echo json_encode($macadam_data_input);

            return;
        }
        // macadam XML data required fields end;

        // macadam Picture data required fields Start;
        $macadam_pic_pod_mandatory_fields = ['stptype', 'ins_id', 'img_store_type'];
        $post_macadam_d3_data = html_entity_decode($this->input->post('macadam_d3_data', true));
        $macadam_d3_data_input = [];
        if ($post_macadam_d3_data) {
            $macadam_d3_data_input = $this->validateJsonDecode(
                $post_macadam_d3_data,
                $macadam_pic_pod_mandatory_fields
            );
            if (!empty($macadam_d3_data_input) && isset($macadam_d3_data_input['error_status']) && $macadam_d3_data_input['error_status'] === 1) {
                echo json_encode($macadam_d3_data_input);

                return;
            }
        }
        // macadam Picture data required fields End;

        // macadam POD data required fields Start;
        $post_macadam_d3_POD_data = html_entity_decode($this->input->post('macadam_d3_POD_data', true));
        $macadam_d3_POD_data_input = [];
        if ($post_macadam_d3_POD_data) {
            $macadam_d3_POD_data_input = $this->validateJsonDecode(
                $post_macadam_d3_POD_data,
                $macadam_pic_pod_mandatory_fields
            );
            if (is_array(
                    $macadam_d3_POD_data_input
                ) && isset($macadam_d3_POD_data_input['status']) && $macadam_d3_POD_data_input['status'] === 0) {
                echo json_encode($macadam_d3_POD_data_input);

                return;
            }
        }
        // macadam Picture data required fields End;


        $req_data['status'] = $status;
        $req_data['macadam_data'] = $macadam_data_input;
        $req_data['macadam_d3_data'] = $macadam_d3_data_input;
        $req_data['macadam_d3_POD_data'] = $macadam_d3_POD_data_input;

        $req_data['status_stage'] = $this->input->post('status_stage', true);
        $req_data['status_type'] = $this->input->post('status_type', true);
        $req_data['comment'] = $this->input->post('comment', true);     // optional
        $req_data['missing_qty'] = $this->input->post('missing_qty', true); // optional
        $req_data['client_timezone_offset'] = $this->input->post('client_timezone_offset', true);
        $req_data['timezone'] = get_offset_time_abbr($req_data['client_timezone_offset']) ?: $this->session->userdata(
            'timezone'
        );
        $stop_details_id = $req_data['employee_id'];
        if (is_array($stop_details_id) && !is_numeric($req_data['employee_id'])) {
            $response = '';
            $stop_details_id_size__ = (!empty($stop_details_id)) ? count($stop_details_id) : 0;
            for ($i = 0; $i < $stop_details_id_size__; $i++) {
                $req_data['employee_id'] = $stop_details_id[$i];
                $_POST = $req_data;
                $response = $this->setShipstopStatus($req_data);
                $_POST = $global_post;
            }
        } else {
            $_POST = $req_data;
            $response = $this->setShipstopStatus($req_data);
        }

        $datetimex = getdatetimebytimezone($req_data['timezone'], date('Y-m-d H:i:s'), DFLT_TZ)['datetime'];
        $response['return_time'] = date('H:i d/m/y', strtotime($datetimex));
        $img_ids[] = !empty($req_data['macadam_d3_data']) ? $req_data['macadam_d3_data']['ins_id'] : '';
        $img_ids[] = !empty($req_data['macadam_d3_POD_data']) ? $req_data['macadam_d3_POD_data']['ins_id'] : '';

        $img_ids = cleanArray($img_ids);
        if (!empty($img_ids)) {
            $select = "CONCAT('downloadEpod/safelink/', hash,'.epod') as img_url";
            $response['img_urls'] = $this->common->gettbldata_where_in(
                ['status' => 1],
                ['col' => 'id', 'arr' => $img_ids],
                $select,
                'tb_pod_uploads',
                0,
                0
            );
        }
        echo json_encode($response, JSON_PRETTY_PRINT);
    }

    public function shipment_details_access($shift_id = '', $trip_id = '', $shift_veh_id = '', $astatus = '')
    {
        $timezone = $this->session->userdata('timezone');
        $driver_id = $this->session->userdata('id');

        $setshipstopstatus_atpickup = [
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        ];
        $setshipstopstatus_atdrop = [
            'trip_id' => $trip_id,
            'shipment_id' => $shift_id,
            'driver_id' => $driver_id,
            'employee_id' => $driver_id
        ];

        $getshipmentstops = '';
        if ($shift_id != '' && $trip_id != '' && $shift_veh_id != '' && $timezone != '') {
            $getShipmentStopsInput = [
                "shift_id" => $shift_id,
                "trip_id" => $trip_id,
                "shift_veh_id" => $shift_veh_id,
                "timezone" => $timezone
            ];
            $getshipmentstops = $this->getshipmentstops($getShipmentStopsInput);
        }

        $status = $getshipmentstops == "" ? 0 : $getshipmentstops->status;
        //  redirect no data found.
        if ($status != 1) {
            log_debug('driver shipment list if block');
            redirect('drivershipment_list', 'refresh');
        }
        // set pre required data for view.
        $pickup = $destination = [];
        $shipmentstops = $getshipmentstops->data;
        $shipments_stops_count = !is_array($shipmentstops) ? 0 : sizeof($shipmentstops);

        $stop_id = 0;
        $stop_details_id = 0;
        $data['is_destination_reached'] = "0";  // to know weather atleast one destination is reached based on this we need to show close shipment is status view
        $data['is_danger_goods'] = "0";  // to know weather atleast one cargo is dg or not
        $data['danger_goods_order_id'] = "0";  // to know weather atleast one cargo is dg or not

        // below two variables are used to  decide wheather all destinations are reached or not.
        for ($i = 0; $i < $shipments_stops_count; $i++) {
            $stop_point = (object)$shipmentstops[$i];
            $shipment_stop_id = $stop_point->id;
            $ship_type = $stop_point->ship_type;
            $orderRowId = $stop_point->orderRowId;

            if ($ship_type == "P") {
                $setshipstopstatus_atpickup['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atpickup['stop_type'] = $ship_type;
            } else {
                $setshipstopstatus_atdrop['stop_id'] = $shipment_stop_id;
                $setshipstopstatus_atdrop['stop_type'] = $ship_type;
            }

            if ($stop_id == '') {
                $stop_id = $shipment_stop_id;
            }
            $status = $stop_point->status;
            $shiftLegId = 0;
            $checkCrossBorderTrip = $this->common->gettblrowdata("id ='".$shift_id."' AND shift_leg_id >0","shift_leg_id","tb_shifts",0,0);
            if(!empty($checkCrossBorderTrip)){
                $shiftLegId = $checkCrossBorderTrip['shift_leg_id'];
            }
            // Get shipment Stop Details based on shipment stop ids
            $shipmentStopDetails = [
                "shift_id" => $shift_id,
                "trip_id" => $trip_id,
                "shift_veh_id" => $shift_veh_id,
                "timezone" => $timezone,
                "stop_sts" => $status,
                "stop_id" => $shipment_stop_id,
                "shiftLegId" => $shiftLegId,
                "orderRowId" => $orderRowId,
            ];
            $shipmentstopdetails = $this->shipmentstopdetails($shipmentStopDetails);
            if ($shipmentstopdetails['status'] == 1) {
                $shipmentstopdetails_list = $shipmentstopdetails['data'];
                $shipmentstopdetails_data_count = (!empty($shipmentstopdetails_list)) ? sizeof(
                    $shipmentstopdetails_list
                ) : 0;
                for ($j = 0; $j < $shipmentstopdetails_data_count; $j++) {
                    $shipmentstopdetails_data = (object)$shipmentstopdetails_list[$j];
                    $ship_type = $shipmentstopdetails_data->ship_type;
                    $stop_details_id = $shipmentstopdetails_data->id;
                    $dg_goods = $shipmentstopdetails_data->dg_goods;
                    if ($dg_goods == "1") {
                        $t_cg_ord_id = $shipmentstopdetails_data->tb_order_cargodetails_orderid;
                        $data['is_danger_goods'] = "1";

                        $data['dg_goods_arr'][$t_cg_ord_id]['danger_goods_data'] = $this->get_danger_goods_details(
                            (int)$t_cg_ord_id
                        );
                    }

                    // push stop id for next page usage
                    $shipmentstopdetails_data->stop_id = $shipment_stop_id;
                    $map_lat_lang_p = $map_lat_lang_d = '';
                    if ($ship_type == "P") {
                        // Shipment Pickup block
                        $startdate = $shipmentstopdetails_data->startdate;            // early picktime
                        $pickup_late_datetime = $shipmentstopdetails_data->pickup_late_datetime; // late pickup time

                        if (isset($map_lat_lang) && $map_lat_lang == '') {
                            $map_lat_lang_p = 'saddr=' . $shipmentstopdetails_data->plat . ',' . $shipmentstopdetails_data->plng;
                        }
                        $setshipstopstatus_atpickup['latitude'] = $shipmentstopdetails_data->plat;
                        $setshipstopstatus_atpickup['longitude'] = $shipmentstopdetails_data->plng;

                        $data['soure_name'] = $shipmentstopdetails_data->pickup;
                        $data['pickup_pincode'] = substr($shipmentstopdetails_data->pickup_pincode, 0, 2);
                        $pickup[] = $shipmentstopdetails_data;
                    } else {
                        // Shipment Delivery Block

                        $enddate = $shipmentstopdetails_data->enddate;            // early drop time
                        $drop_late_datetime = $shipmentstopdetails_data->drop_late_datetime; // late drop time
                        $map_lat_lang_d = '&daddr=' . $shipmentstopdetails_data->dlat . ',' . $shipmentstopdetails_data->dlng;

                        $setshipstopstatus_atdrop['latitude'] = $shipmentstopdetails_data->dlat;
                        $setshipstopstatus_atdrop['longitude'] = $shipmentstopdetails_data->dlng;

                        $data['destination_name'] = $shipmentstopdetails_data->drop;
//                        $data['destination_date'] = date('d M', $enddate) . ',' . date('h:i A', $enddate) . ' - ' . date('d M', $drop_late_datetime) . ',' . date('h:i A', $drop_late_datetime);
                        $data['delivery_pincode'] = substr($shipmentstopdetails_data->delivery_pincode, 0, 2);
                        $data['end_points'] = $this->common->gettblrowdata(
                            ['shipid' => $shipmentstopdetails_data->shipmentid],
                            'source,destination',
                            'tb_shipments',
                            0,
                            0
                        );

                        $destination[] = $shipmentstopdetails_data;
                    }
                }
            }
        }


        $data['shipstopsstatus_atdrop'] = $setshipstopstatus_atdrop;
        $data['shipstopsstatus_atpickup'] = $setshipstopstatus_atpickup;

        $data['status_view_params'] = "$trip_id/$shift_id/$stop_id/$stop_details_id";

        $date_compare = function ($a, $b) {
            return strtotime($a->startdate) - strtotime($b->startdate);
        };

        usort($pickup, $date_compare);
        usort($destination, $date_compare);

        $data['pickup'] = $pickup;
        $data['destination'] = $destination;
        $data['map_view_lat_lng'] = 'http://maps.google.com/maps?' . $map_lat_lang_p . $map_lat_lang_d;
        $data['astatus'] = $astatus;
        $data['client_timezone_offset'] = $_GET['timeOffset'] ?? 2 * 60 * 60;
        $data['isDST'] = $_GET['isDST'] ?? true;
        $data['shiftLegId'] = $shiftLegId;
        if($shiftLegId>0){
            $getLegLocations = $this->drivermodel->getCrossBorderLegsLocation($shift_id);
            if(!empty($getLegLocations)){
                $data['legPickupLocations'] = $getLegLocations['P'];
                $data['legDeliveryLocations'] = $getLegLocations['D'];
            }
            $data['cargo_details'] = $this->drivermodel->getCargoDetailsByShiftId($shiftLegId);
        }else{
            $data['cargo_details'] = $this->drivermodel->getCargoDetailsByShiftId($shift_id);
        }
        $this->load->view('driverappv3/shipment_details_secure_view', $data);
    }

    public function get_secure_view()
    {
        $token = trim($this->input->post('token', true));

        $response = ['status' => '0', 'message' => 'Something went wrong', 'response' => []];
        try {
            if (!$token) {
                log_debug('JWT token is undefined');
                $response = ['status' => '0', 'response' => []];
            } else {
                $complete_url = $this->getpayloadinfo($token);

                switch ($complete_url) {
                    case 'driver':
                        log_debug('Driver must accept the trip before using the link');
                        $response = [
                            'status' => '2',
                            'message' => 'Please ask driver to accept the trip.',
                            'response' => [],
                        ];
                        break;
                    case 'cancelled':
                        log_debug('Trip has been cancelled');
                        $response = ['status' => '2', 'message' => 'Trip has been cancelled', 'response' => []];
                        break;

                    case '':
                        log_debug('Invalid JWT token \'' . $token . '\'');
                        $response = ['status' => '0', 'response' => []];
                        break;

                    default:
                        log_debug('JWT token is valid');
                        $response = ['status' => '1', 'response' => ['url' => $complete_url]];
                }
            }
        } catch (Exception $e) {
            log_error($response . ' -- ' . $e->getMessage() . '--' . $e->getLine() . ' -- ' . $e->getFile());
        }

        echo json_encode($response);
    }

    private function getpayloadinfo(string $token): string
    {
        log_debug('JWT token is \'' . $token . '\'');

        $complete_url = '';
        $payload = self::get_driver_secure_link($token);
        $response = $payload['response'];
        if ($payload['status'] == "1" && isset($response['shipment_id']) && $response['shipment_id'] != '') {
            $row = $this->drivermodel->shipmentTripInfo($response['shipment_id']);
            if (!empty($row) && $row['active_status'] == 0) {
                return 'cancelled';
            }
            if (isset($row['driver_id']) && $row['driver_id'] == '0') {
                return 'driver';
            }

            if (isset($row['shift_id']) && isset($row['trip_id']) && isset($row['shift_veh_id'])) {
                log_debug('Error Message @1325 => got');
                $shift_id = $row['shift_id'];
                $trip_id = $row['trip_id'];
                $shift_veh_id = $row['shift_veh_id'];
                $astatus = $row['astatus'];
                $driver_id = $row['driver_id'];

                if (!($shift_id != '' && $trip_id != '' && $shift_veh_id != '' && $astatus != '' && $driver_id != '')) {
                    return $complete_url;
                }
                // Dynamic
                $row = $this->common->gettblrowdata(
                    ['id' => $driver_id],
                    'password,contact_num as mobile',
                    'tb_truck_drivers',
                    0,
                    0
                );

                $accept = [
                    'shift_id' => $shift_id,
                    'driver_id' => $driver_id,
                    'trip_id' => $trip_id,
                    'vehicle_id' => $shift_veh_id,
                    'trip_type' => 0,
                ];
                $this->driver_accept($accept); //TODO Need to write try catch
                $driver_data = $this->driverLogin(["mobile" => $row['mobile'], "password" => $row['password']]);

                if ($driver_data['status'] != 1) {
                    log_debug('invalid driver details. @362');
                    redirect('driverlogin', 'refresh'); //TODO need to redirect error page
                }
                $driver_data_obj = (object)$driver_data['data'];
                $session_imei = !($driver_data_obj->imei != "" && is_numeric(
                        $driver_data_obj->imei
                    ) && $driver_data_obj->imei > 0) ? $row['mobile'] : $driver_data_obj->imei;
                $this->session->set_userdata(['is_login' => "1", 'imei' => $session_imei]);

                $session_data_after_auto_login = [
                    'id' => $driver_data_obj->id,
                    'name' => $driver_data_obj->name,
                    'vendor_id' => $driver_data_obj->vendor_id,
                    'mobile_no' => $driver_data_obj->mobile_no,
                    'vehicle' => $driver_data_obj->vehicle,
                    'vehicle_id' => $driver_data_obj->vehicle_id,
                    'trip_id' => $driver_data_obj->trip_id,
                    'timezone' => $driver_data_obj->timezone,
                ];
                $this->session->set_userdata($session_data_after_auto_login);

                log_debug('final step');
                $complete_url = base_url("drivershipment_details_accessv3/$shift_id/$trip_id/$shift_veh_id/$astatus");
            }
        }

        return $complete_url;
    }

    private function driver_accept(array $data = []): array
    {
        if (!empty($data)) {
            $where = [
                "shipment_id" => $data["shift_id"],
                "trip_id" => $data['trip_id'],
                "status_id" => 273
            ];

            $chqry = $this->common->gettblrowdata($where, 'id', 'tb_stop_status', 0, 0);
            if (empty($chqry)) {
                $insarry = [
                    "shipment_id" => $data["shift_id"],
                    "stop_id" => 0,
                    "stop_detail_id" => 0,
                    "stop_type" => '',
                    "trip_id" => $data['trip_id'],
                    "status_id" => 273,
                    "latitude" => '',
                    "longitude" => '',
                    "status" => 1,
                    "status_code" => "SV0120",
                    "reason" => "auto acceptance",
                    "vehicle_id" => $data["vehicle_id"],
                    "driver_id" => $data["driver_id"],
                    "createdon" => date('Y-m-d H:i:s')
                ];

                $ins = $this->common->insertTableData("tb_stop_status", $insarry);
                if ($ins) {
                    return ['status' => 1, 'message' => 'driver accepted'];
                } else {
                    log_error('driver acceptance insertion fail:' . $this->db->last_query());
                }
            }
        }

        return [];
    }

    private static function get_driver_secure_link(string $token): array
    {
        $tokenValidation = validate_jwt($token);

        switch ($tokenValidation["code"]) {
            case 200:
                return ["status" => 1, "response" => ["shipment_id" => $tokenValidation["token"]["sub"]]];
            default:
                return ["status" => 0, "response" => $tokenValidation];
        }
    }

    public function change_site_language(): void
    {
        $res_f = ["status" => 0, "response" => "Please do valid selection"];
        $language = trim($this->input->post('language', true));
        if (strlen($language) > 0 && $language != '') {
            $this->session->set_userdata('site_lang', $language);
            $res_f = ["status" => 1, "response" => "Language changed successfully..."];
        }

        echo json_encode($res_f);
    }

    public function danger_goods_description(): void
    {
        $data['response'] = ["status" => 0];
        if (is_numeric($this->input->post('danger_goods_order_id'))) {
            $_POST = ['danger_goods_order_id' => $this->input->post('danger_goods_order_id', true)];
            $data['response'] = $this->get_danger_goods_details();
        }

        $this->load->view('driverappv2/danger_goods', $data);
    }

    private function driverLogin(array $post = []): array
    {
        $response = ["status" => 0, "data" => "Not Found"];
        if (!empty($post)) {
            $mobile = $post["mobile"] ?? '';
            $gcm_id = $post["token"] ?? '';

            if ($mobile != "") {
                $data = $this->drivermodel->driverLoginByToken($mobile);
                if (!empty($data)) {
                    $id = $data["id"];
                    $imei_k = "";
                    $truckDriverData = $this->drivermodel->truckDriverData($id);
                    $veh = $veh_id = "";

                    if (!empty($truckDriverData)) {
                        $veh = $truckDriverData->register_number;
                        $veh_id = $truckDriverData->id;
                    }

                    if ($gcm_id) {
                        $updset["gcm_id"] = $gcm_id;
                    }

                    if (!empty($updset)) {
                        $this->common->updatetbledata("tb_truck_drivers", $updset, ["id" => $id]);
                    }

                    $countrytimezone = DFLT_TZ;

                    $chkcntry = $this->common->gettblrowdata(
                        ["country_code" => $data['country_code']],
                        "cntry_timezone",
                        "tbl_country_master",
                        0,
                        0
                    );
                    if (!empty($chkcntry)) {
                        $countrytimezone = $chkcntry['cntry_timezone'];
                    }
                    $data['imei'] = $imei_k;
                    $data['vehicle'] = $veh;
                    $data['vehicle_id'] = $veh_id;
                    $data['trip_id'] = "";
                    $data['timezone'] = $countrytimezone;
                    $data['border_type'] = 0;

                    $response = ["status" => 1, "data" => $data];
                } else {
                    $response = ["status" => 0, "data" => "Not Found"];
                }
            } else {
                $response = ["status" => 0, "data" => "Not Found"];
            }
        }

        return $response;
    }

    private function getshipmentstops(array $getShipmentStopsInput): object
    {
        if (!empty($getShipmentStopsInput)) {
            $shft_veh_id = $getShipmentStopsInput["shift_veh_id"] ?? "";
            $shft_id = $getShipmentStopsInput["shift_id"] ?? "";

            if ($shft_veh_id != "" && $shft_id != "") {
                $curtz = $_POST['timezone'] ?? DFLT_TZ;
                $result = [];
                $i = 0;
                $prevsts = "N";

                $shiporderStopsData = $this->drivermodel->shiporderStops($curtz, $shft_id);

                if (!empty($shiporderStopsData)) {
                    foreach ($shiporderStopsData as $res) {
                        $stop_id = $res->id;
                        $emp = $this->drivermodel->employeeData($stop_id, $shft_id, 'stop_id');

                        if (!empty($emp)) {
                            $stop_type = $res->stoptype;
                        } else {
                            $emp = $this->drivermodel->employeeData($stop_id, $shft_id, 'drop_stopid');
                            $stop_type = 'D';
                        }
                        $order_id = $emp['order_id'] ?? "";
                        if($order_id != ""){
                            $getOrderRowId = $this->drivermodel->getOrderRowIdByBookingId($order_id);
                        }
                        $orderRowId = $getOrderRowId['id'] ?? 0;
                        $status = $prevsts == "C" ? $prevsts = "S" : "N";
                        $whr = [
                            "order_id" => $orderRowId,
                            "shipment_id" => $shft_id,
                            "status_id" => 1,
                            "status" => 1,
                            "stop_type" => $stop_type,
                        ];

                        $gateout_details = $this->common->gettblrowdata($whr, 'id', 'tb_stop_status', 0, 0);
                        if (!empty($gateout_details)) {
                            $status = $prevsts = "C";
                        } else {
                            $whr = ["order_id" => $orderRowId, "shipment_id" => $shft_id];
                            $statuses = $this->common->gettblrowdata($whr, 'id', 'tb_stop_status', 0, 0);
                            if (!empty($statuses)) {
                                $status = $prevsts = "S";
                            }
                        }

                        $stopname = "";
                        if (strlen($res->stopcity) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopcity)) . " - ";
                        }
                        if (strlen($res->stopname) > 0) {
                            $stopname .= ucfirst(str_replace("_", " ", $res->stopname));
                        }
                        if ($status == "N" && $i == 0) {
                            $status = "S";
                        }
                        $result[] = [
                            'id' => $stop_id,
                            'name' => $stopname,
                            'plat' => $res->plat,
                            'plng' => $res->plng,
                            'ship_type' => $res->stoptype,
                            'shipment_weight' => $res->weight,
                            'shipment_volume' => $res->volume,
                            'startdate' => strtotime($res->startdate),
                            'enddate' => strtotime($res->enddate),
                            'priority' => $res->ordernumber,
                            'status' => $status,
                            'order_id' => $order_id,
                            'orderRowId'=>$orderRowId
                        ];
                        $i++;
                    }

                    $res_f = ["status" => 1, "data" => $result];
                } else {
                    $res_f = ["status" => 0, "data" => "Not Found"];
                }
            } else {
                $res_f = ["status" => 0, "data" => "Insufficient Input Data"];
            }
        } else {
            $res_f = ["status" => 0, "data" => "Insufficient Input Data"];
        }
        return (object)$res_f;
    }

    private function shipmentstopdetails(array $shipmentStopDetails, int $type = 0): array
    {
        if (!empty($shipmentStopDetails)) {
            $shft_veh_id = $shipmentStopDetails["shift_veh_id"] ?? '';
            $shift_id = $shipmentStopDetails["shift_id"] ?? '';
            $stop_id = $shipmentStopDetails["stop_id"] ?? '';
            $trip = $shipmentStopDetails["trip_id"] ?? 0;
            $shiftLegId = $shipmentStopDetails["shiftLegId"] ?? 0;
            $stop_sts = $shipmentStopDetails["stop_sts"] ?? "N";
            $curtz = $shipmentStopDetails['timezone'] ?: DFLT_TZ;
            $orderRowId = $shipmentStopDetails["orderRowId"] ?? 0;
            date_default_timezone_set($this->session->userdata('timezone'));
            if ($shft_veh_id > 0) {
                if($shiftLegId >0){
                    $pickupAndDropShipmentsData = $this->drivermodel->getCrossBorderShipments($curtz, $shift_id, $stop_id, $type);
                }else{
                    $pickupAndDropShipmentsData = $this->drivermodel->getShipments($curtz, $shift_id, $stop_id, $type);
                }
                $result = [];
                if (!empty($pickupAndDropShipmentsData)) {
                    $k = $sts = 0;
                    foreach ($pickupAndDropShipmentsData as $res) {
                        if ($res->ship_type == 'P') {
                            $stopId = $res->stop_id;
                        } else {
                            $stopId = $res->drop_stopid;
                        }
                        $allstatus['274'] = $allstatus['275'] = $allstatus['278'] = $allstatus['279'] = $allstatus['280'] = $allstatus['281'] = $allstatus['285'] = $allstatus['286'] = 0;
                        $allstatus_dates = ['274' => 0, '275' => 0, '278' => 0, '279' => 0, '280' => 0, '281' => 0, '285' => 0, '286' => 0];
                        $status = 'N';
                        $statusid = '0';
                        $check_in = $reason = '';
                        $whr = ['stop_id' => $stopId];
                        $custname = $res->customer_name;
                        $custmobi = $res->custphone;
                        $getsts = $this->drivermodel->getstopstatus($whr, $curtz);
                        if($shiftLegId >0){
                            if($res->order_id != ""){
                                $getOrderRowId = $this->drivermodel->getOrderRowIdByBookingId($res->order_id);
                            }
                            $res->tb_orders_id = $getOrderRowId['id'] ?? $res->tb_orders_id;
                            $res->pickup_company = $getOrderRowId['pickup_company'] ?? $res->pickup_company;
                            $res->pickup_city = $getOrderRowId['pickup_city'] ?? $res->pickup_city;
                            $res->pickup_country = $getOrderRowId['pickup_country'] ?? $res->pickup_country;
                            $res->pickup_address1 = $getOrderRowId['pickup_address1'] ?? $res->pickup_address1;
                            $res->pickup_address2 = $getOrderRowId['pickup_address2'] ?? $res->pickup_address2;
                            $res->pickup_pincode = $getOrderRowId['pickup_pincode'] ?? $res->pickup_pincode;
                            $res->delivery_country = $getOrderRowId['delivery_country'] ?? $res->delivery_country;
                            $res->delivery_company = $getOrderRowId['delivery_company'] ?? $res->delivery_company;
                            $res->delivery_city = $getOrderRowId['delivery_city'] ?? $res->delivery_city;
                            $res->delivery_address1 = $getOrderRowId['delivery_address1'] ?? $res->delivery_address1;
                            $res->delivery_address2 = $getOrderRowId['delivery_address2'] ?? $res->delivery_address2;
                            $res->delivery_pincode = $getOrderRowId['delivery_pincode'] ?? $res->delivery_pincode;
                            $res->company_code = $getOrderRowId['company_code'] ?? $res->company_code;
                            $res->shipmentid = $getOrderRowId['shipmentid'] ?? $res->shipmentid;
                            $res->created_source = $getOrderRowId['created_source'] ?? $res->created_source;
                        }
                        if (!empty($getsts)) {
                            $status = $getsts['name'];
                            $statusid = $getsts['status_id'];
                            $check_in = strtotime($getsts['createdon']);
                            $reason = $getsts['name'];
                        }

                        $stop_detail_id = $res->id;
                        $sts = $sts == 2 ? 1 : 0;
                        $anystatus = $has_pod = 0;

                        $where_a = [
                            'shipment_id' => $shift_id,
                            'stop_id' => $stop_id,
                            'stop_detail_id' => $stop_detail_id
                        ];

                        $chkpodsign = $this->common->gettbldata($where_a, '*', 'tb_pod_uploads', 0, 0);
                        $pod_uploads_info = [];

                        if (!empty($chkpodsign)) {
                            $chkpodsign_res = (object)$chkpodsign[0];
                            $pod_uploads_info = $chkpodsign;
                            $anystatus = 1;
                            $allstatus['286'] = 1;
                            $allstatus_dates['286'] = $chkpodsign_res->createdon;
                            $has_pod = 1;
                        }

                        if ($trip > 0) {
                            $chk1 = $this->common->gettbldata(
                                [
                                    "shipment_id" => $shift_id,
                                    'stop_id' => $stopId,
                                    'trip_id' => $trip,
                                    'stop_detail_id' => $res->id
                                ],
                                'id,stop_type',
                                'tb_stop_status',
                                0,
                                0
                            );

                            if (!empty($chk1)) {
                                $sts = 1;
                                $cr = array_column($chk1, 'stop_type');
                                $where = [
                                    'shipment_id' => $shift_id,
                                    'stop_id' => $stopId,
                                    'trip_id' => $trip,
                                    'stop_detail_id' => $res->id
                                ];

                                if (in_array('D', $cr)) {
                                    $where_in = ['col' => 'doc_type', 'arr' => [1, 3]];
                                    $chkdoc = $this->common->gettbldata_where_in(
                                        $where,
                                        $where_in,
                                        'id,doc_type',
                                        'tb_pod_uploads'
                                    );

                                    if (!empty($chkdoc)) {
                                        $sts = 2;
                                    }
                                } elseif (in_array('P', $cr)) {
                                    $where['status_id'] = 4;
                                    $chk2 = $this->common->gettblrowdata($where, 'id', 'tb_stop_status', 0, 0);
                                    if (!empty($chk2)) {
                                        $sts = 2;
                                    }
                                }
                            }

                            $whrc = [
                                'shipment_id' => $shift_id,
                                'order_id' => $res->tb_orders_id,
                                'stop_type' => $res->ship_type
                            ];

                            $chk11 = $this->common->gettbldata(
                                $whrc,
                                'id,status_id, status_stage, createdon',
                                'tb_stop_status',
                                0,
                                0
                            );

                            $status_stages_a = array_filter(array_column($chk11, 'status_stage'));
                            $status_counts = $status_stages_a ? array_count_values($status_stages_a) : [];

                            if (!empty($chk11)) {
                                if ($sts != 2) {
                                    $sts = 1;
                                }

                                foreach ($chk11 as $chr) {
                                    switch ($chr['status_id']) {
                                        case 274:
                                        case 275:
                                        case 279:
                                        case 281:
                                        case 278:
                                        case 285:
                                        case 280:
                                            $allstatus[$chr['status_id']] = 1;
                                            $allstatus_dates[$chr['status_id']] = [
                                                'status_stage' => str_replace(
                                                    '_',
                                                    ' ',
                                                    $chr['status_stage']
                                                ),
                                                'date' => $chr['createdon']
                                            ];
                                            break;
                                        case 286:
                                            $allstatus[1] = 1;
                                            $allstatus_dates[1] = [
                                                'status_stage' => str_replace(
                                                    '_',
                                                    ' ',
                                                    $chr['status_stage']
                                                ),
                                                'date' => $chr['createdon']
                                            ];
                                        break;
                                    }
                                }
                            }
                        }

                        $material = $res->material_name ?: $res->name;

                        if ($sts != 0) {
                            $k = 1;
                        }

                        $order_ref_data = $this->common->gettbldata(
                            ["order_id" => $res->tb_orders_id, 'ref_value != ' => ''],
                            'ref_belongs_to,reference_id,ref_value',
                            'tb_order_references',
                            0,
                            0
                        );

                        $result[] = [
                            'id' => $res->id,
                            'name' => $res->name,
                            'assoc_id' => $res->assoc_id,
                            'pickup_address_f' => $res->pickup_address1 . ', ' . $res->pickup_address2,
                            'delivery_address_f' => $res->delivery_address1 . ', ' . $res->delivery_address2,
                            'pickup' => reduce_comma(
                                $res->pickup_pincode . ', ' . $res->pickup_city . ', ' . $res->pickup_country
                            ),
                            'drop' => reduce_comma(
                                $res->delivery_pincode . ', ' . $res->delivery_city . ', ' . $res->delivery_country
                            ),
                            'pickup_company' => $res->pickup_company,
                            'delivery_company' => $res->delivery_company,
                            'phone' => $res->phone,
                            'plat' => $res->plat,
                            'plng' => $res->plng,
                            'dlat' => $res->dlat,
                            'dlng' => $res->dlng,
                            'capacity' => $res->capacity,
                            'ship_type' => $res->ship_type,
                            'shipmentid' => $res->shipmentid,
                            'shipment_weight' => $res->shipment_weight,
                            'weight_unit' => $res->weight_unit,
                            'cargo_content' => $res->cargo_content,
                            'shipment_volume' => $res->shipment_volume,
                            'startdate' => date('F d, Y - H:i', strtotime($res->startdate)),
                            'enddate' => date('F d, Y - H:i', strtotime($res->enddate)),
                            'priority' => $res->priority,
                            'status' => $status,
                            'status_id' => $statusid,
                            'check_in' => $check_in,
                            'reason' => $reason,
                            'milestone' => $sts,
                            'exists_status' => $anystatus,
                            'material' => $material,
                            'order_id' => $res->order_id,
                            "accepted" => $res->accepted,
                            'customer' => $custname,
                            'customerphone' => $custmobi,
                            "allstatus" => $allstatus,
                            "allstatus_dates" => $allstatus_dates,
                            "has_pod" => $has_pod,
                            'service_id' => $res->service_id,
                            'service_name' => $res->service_name,
                            'dg_goods' => $res->dg_goods,
                            'goods_description' => $res->goods_description,
                            'purchase_order' => $res->purchase_order,
                            'pickup_late_datetime' => date('M d, Y - H:i', strtotime($res->pickup_late_datetime)),
                            'drop_late_datetime' => date('M d, Y - H:i', strtotime($res->drop_late_datetime)),
                            'tb_orders_id' => $res->tb_orders_id,
                            'cargo_type' => $res->cargo_type,
                            'ldm' => (floatval($res->ldm) > 0) ? floatval($res->ldm) . ' ' . $res->ldm_uom : '',

                            'pod_uploads_info' => $pod_uploads_info,

                            'handling_unit' => $res->handling_unit,
                            'length' => $res->length,
                            'length_unit' => $res->length_unit,
                            'width' => $res->width,
                            'width_unit' => $res->width_unit,
                            'height' => $res->height,
                            'height_unit' => $res->height_unit,
                            'quantity' => $res->quantity,
                            'quantity_type' => $res->quantity_type,
                            'stackable' => $res->stackable,
                            'grounded' => $res->grounded,
                            'splittable' => $res->splittable,

                            'pickup_pincode' => $res->pickup_pincode,
                            'delivery_pincode' => $res->delivery_pincode,
                            'cargo_id' => $res->cargo_id,
                            'pickup_datetime' => date('M d, Y - H:i',strtotime($res->pickup_datetime)),
                            'drop_datetime' => date('M d, Y - H:i',strtotime($res->drop_datetime)),
                            'tb_order_cargodetails_orderid' => $res->tb_order_cargodetails_orderid,
                            'created_source' => $res->created_source,
                            'company_code' => $res->company_code,
                            'order_ref_data' => (object)$order_ref_data,
                            'share_location_count' => (int)($status_counts['IN_TRANSIT'] ?? 0),
                            'shiftLegId'=>$shiftLegId,
                        ];
                    }

                    if ($stop_sts == "S" && $k == 1) {
                        if (count($result) > 0) {
                            $ms = array_column($result, 'milestone');
                            array_multisort($ms, SORT_DESC, $result);
                        }
                    } elseif ($stop_sts == "S" && $k == 0) {
                        if (count($result) > 0) {
                            $result[0]['milestone'] = 1;
                        }
                    }

                    $res_f = ["status" => 1, "data" => $result];
                } else {
                    $res_f = ["status" => 0, "data" => "Not Found"];
                }
            } else {
                $res_f = ["status" => 0, "data" => "Insufficient Input Data"];
            }
        } else {
            $res_f = ["status" => 0, "data" => "Insufficient Input Data"];
        }

        return $res_f;
    }

    private function setShipstopStatus(array $shipstopStatusData = []): array
    {
        $response = ["status" => 0, "data" => "Insufficient Input Data"];

        if (isset($shipstopStatusData)) {
            $data = [];
            $latitude = $shipstopStatusData['latitude'] ?? '';
            $longitude = $shipstopStatusData['longitude'] ?? '';
            $data["trip_id"] = $shipstopStatusData['trip_id'] ?? '';
            $shipment_id = $shipstopStatusData['shipment_id'] ?? '0';
            $stop_id = $shipstopStatusData['stop_id'] ?? '0';
            $tb_order_id = $shipstopStatusData['order_id'] ?? '0';
            $data["employee_id"] = $shipstopStatusData['employee_id'] ?? '';
            $stop_type = $shipstopStatusData['stop_type'] ?? '';
            $status_type = $shipstopStatusData['status_type'] ?? '';
            $comment = $shipstopStatusData['comment'] ?? '';
            $missing_qty = $shipstopStatusData['missing_qty'] ?? '';
            $macadam_data = $shipstopStatusData['macadam_data'];
            $macadam_d3_data_inp = $shipstopStatusData['macadam_d3_data'];
            $macadam_d3_POD_data = $shipstopStatusData['macadam_d3_POD_data'];
            $status_stage = $shipstopStatusData['status_stage'];
            
            date_default_timezone_set('UTC');

            $curdt = date('Y-m-d H:i:s'); /* $getactual['datetime']; */

            if ($data["employee_id"] != "" && $data["trip_id"] != "") {
                $vehicle = $driver = 0;
                $checkintrans = (object)$this->common->gettblrowdata(
                    ['id' => $data["trip_id"]],
                    'id,vehicle_id,driver_id',
                    'tb_trips',
                    0,
                    0
                );
                if (!empty($checkintrans)) {
                    $this->common->updatetbledata('tb_trips', ['transit_status' => 1], ['id' => $data["trip_id"]]);
                    $vehicle = $checkintrans->vehicle_id;
                    $driver = $checkintrans->driver_id;
                }

                $data["status"] = 1;
                $data["absent_reason"] = $stsreason = $data["pd_status"] = $shipstopStatusData["status"] ?? '';
                $data["stime"] = $data["created_on"] = $data["check_in"] = $curdt;

                switch (true) {
                    case ($stsreason == 274 && $stop_type == "P"):
                        $stscode = "SV0130"; // PICKUP_GATE_IN
                        break;
                    case ($stsreason == 279 && $stop_type == "D"):
                        $stscode = "SV0310"; // DELIVERY_GATE_IN
                        break;
                    case ($stsreason == 275 && $stop_type == "P"):
                        $stscode = "SV0140"; // PICKUP_GATE_OUT
                        break;
                    case ($stsreason == 281 && $stop_type == "D"):
                        $stscode = "SV0510"; // DELIVERY_GATE_OUT					$notests = 3;
                        break;
                    case ($stsreason == 285 && $stop_type == "P"):
                        $stscode = "SV0131"; //  PICKUP_done
                        break;
                    case ($stsreason == 280 && $stop_type == "D"):
                        $stscode = "SV0410"; //  DROP_done
                        break;
                    case ($stsreason == 278):
                        $stscode = "SV0230"; //  IN-TRANSIT
                        break;
                    case ($stsreason == 13 && $stop_type == "P"):
                        $stscode = "0501";  // eTN status -> FNKN Status codes -> PK_NOT_DONE
                        break;
                    case ($stsreason == 12 && $stop_type == "P"):
                    case ($stsreason == 12 && $stop_type == "D"):
                        $stscode = "0502"; // eTN status -> FNKN Status codes -> PK_Damage // eTN status -> FNKN Status codes -> D_Damage
                        break;
                    case ($stsreason == 13 && $stop_type == "D"):
                        $stscode = "0503"; // eTN status -> FNKN Status codes -> D_Short
                        break;
                    case ($stsreason == 14 && $stop_type == "D"):
                        $stscode = "0504";  // eTN status -> FNKN Status codes -> d_NOT_DONE
                        break;
                    case ($stsreason == 15 && $stop_type == "D"):
                        $stscode = "0505";  // eTN status -> FNKN Status codes -> D_Refused
                        break;
                    default:
                        $stscode = "SV0130";
                }

                $chksts = [
                    'shipment_id' => $shipment_id,
                    'stop_id' => $stop_id,
                    'stop_detail_id' => $data["employee_id"],
                    'stop_type' => $stop_type,
                    'trip_id' => $data["trip_id"],
                    'status_id' => $stsreason,
                    'status' => $data["status"]
                ];

                $checksts = $this->common->gettblrowdata($chksts, 'id', 'tb_stop_status', 0, 0);
                if (!empty($checksts) && "SV0230" !== $stscode) {
                    $this->common->updatetbledata(
                        'tb_stop_status',
                        [
                            'latitude' => $latitude,
                            'longitude' => $longitude,
                            'updatedon' => date('Y-m-d H:i:s'),
                            'comment' => $comment,
                        ],
                        ['id' => $checksts['id']]
                    );
                } else {
                    $data1 = [
                        'shipment_id' => $shipment_id,
                        'stop_id' => $stop_id,
                        'order_id' => $tb_order_id,
                        'stop_detail_id' => $data["employee_id"],
                        'stop_type' => $stop_type,
                        'trip_id' => $data["trip_id"],
                        //Pickup(done => 1, damaged => 12, not-done => 13), delivery ( done => 1, damaged => 12, not-done=> 13, short=> 14, refuse=>15)
                        //These status_ids are related to mention in the mass_status update eTN detects only delivery and pick done status only
                        'status_id' => in_array($stsreason, [12, 13, 14, 15]) ? 1 : $stsreason,
                        'latitude' => $latitude,
                        'longitude' => $longitude,
                        'status' => $data["status"],
                        'status_code' => $stscode,
                        "reason" => "From Secure Link",
                        "comment" => $comment,
                        'vehicle_id' => $vehicle,
                        'driver_id' => $driver,
                        'createdon' => $curdt,
                        'status_stage' => $status_stage
                    ];
                    $this->common->insertTableData('tb_stop_status', $data1);
                    $getCompanyCode = $this->common->gettblrowdata(['id' => $tb_order_id], "company_code,created_source", "tb_orders", 0, 0);
                    $companyCode = $getCompanyCode['company_code'] ?? "";
                    $createdSource = $getCompanyCode['created_source'] ?? "";
                    $checkStatus = "RELATED_2_" . $companyCode . "_CONSIGNEE_NOTIFICATION_STATUSES";
                    if (checkAccessConditions('RELATED_2_CONSIGNEE_NOTIFICATION', $companyCode) && checkAccessConditions($checkStatus, $stscode)) {
                        $this->load->library('notifytrigger');
                        $this->notifytrigger->sendNotificationToConsignee($tb_order_id, $stscode);
                    }
                }
                 try {
                    $statusPayload = [
                        "trip" => $data["trip_id"],
                        "ship" => $shipment_id,
                        "ord_id" => $tb_order_id,
                        "orderid" => $macadam_data['order_id'],
                        "stopid" => $stop_id,
                        "stopdetailid" => $data["employee_id"],
                        "vehicle_id" => $vehicle,
                        "driver_id" => $driver,
                        "stop_type" => $stop_type,
                        "timezone" => $this->session->userdata("timezone"),
                        "sts_date" => $curdt,
                        "status_code" => $stscode
                    ];
                    $domainDetails = $this->OtmBookingModel->getDomain($tb_order_id);
            		if (!empty($domainDetails)) {
            			$extOrderId = $domainDetails[0]['external_order_id'];
            			$domainName = $domainDetails[0]['ref_value'];
                        $domainCreatedSource = $domainDetails[0]['created_source'];
                        if($domainName<>"")
                        {
                           $otmRequest = [
                                'glogDate' => date("Ymdhis"),
                                'externalOrderId' => $extOrderId,
                                'orderStatusDateTime' => $curdt,
                                'domainName' => $domainName,
                                'createdSource'=> $createdSource ? $createdSource :  $domainCreatedSource,
                                'timeZone' =>$this->session->userdata("timezone") ?? "",
                                'orderStatusCode' => $stscode,
                            ];
                            $output = sendOTMStatus($otmRequest); 
                       }
            		}
                    //log_message("error", "Secure link Status " . $stscode);
                    $this->standard_status_execution->sendStandardXMLtoAltova($statusPayload);
                    $this->altovaordercreation->sendOrderToAltova($tb_order_id, $stscode);
                } catch (Exception $ex) {
                    log_message("error", "Some Problem occured!, While Sending Order Status to Altova " . $ex->getMessage());
                }

                if (in_array($stscode, ['0500', '2300'])) {
                    $this->SendNotificationMailFromSecureLink($stscode == "0500" ? "P" : "D", $status_stage, $tb_order_id);
                }
                $this->common->updatetbledata(
                    'tb_trucks_data',
                    [
                        'latitude' => $latitude,
                        'longitude' => $longitude,
                        'trailer_latitude' => $latitude,
                        'trailer_longitude' => $longitude,
                        'updatedon' => $curdt
                    ],
                    ['id' => $vehicle]
                );

                try {
                    $order_data = $this->common->gettblrowdata(
                        ['order_id' => $macadam_data['order_id']],
                        '*',
                        'tb_orders',
                        0,
                        0
                    );
                    $rlgRefVal = $this->common->gettblrowdata(['order_id' => $order_data['id'], 'reference_id' => 'RLG'], 'id,reference_id,ref_value', 'tb_order_references', 0, 0);
                    /*check SALog order and the send updated status and ePOD to SALog */
                    if ($order_data['created_source'] == 5 || $order_data['created_source'] == 11) {
                        $company_code = $order_data['company_code'];
                        $currenTimezone = $this->session->userdata("timezone");
                        $currentTimezoneHours = "Z";
                        $userInfo = $this->common->gettblrowdata(
                            ['company_code' => $company_code],
                            'country_code',
                            'tb_users',
                            0,
                            0
                        );
                        if (!empty($userInfo)) {
                            $countryInfo = $this->common->gettblrowdata(
                                ['country_code' => $userInfo['country_code']],
                                'cntry_timezone,cntry_hrs',
                                'tbl_country_master',
                                0,
                                0
                            );
                            if (!empty($countryInfo)) {
                                $currenTimezone = $countryInfo['cntry_timezone'];
                                $currentTimezoneHours = $countryInfo['cntry_hrs'];
                            }
                        }
                        $postdata = [
                            "shipment_id" => $shipment_id,
                            "trip_id" => $data["trip_id"],
                            "driver_id" => $driver,
                            "stop_id" => $stop_id,
                            "order_id" => $macadam_data['order_id'],
                            "latitude" => $latitude,
                            "longitude" => $longitude,
                            "stop_type" => $stop_type,
                            "vehicle_id" => $vehicle,
                            "ord_id" => $order_data['id'],
                            "status_code" => $stscode,
                            "web" => $curdt,
                            "curtz" => $currenTimezone,
                            "hrs" => $currentTimezoneHours
                        ];
                        if ($status_stage == "PICKUP_OK" && $order_data['created_source'] == 5) {
                            $sendnotify = $this->sendEPOPGateoutNotify($postdata);
                        }
                        if ($status_stage == "DELIVERED") {
                            $sendnotify = $this->sendEPODGateoutNotify($postdata);
                        }

                        if (in_array($stscode, ["0500", "2300", "3000"])) {
                            $this->load->library("statusintigration");
                            log_error('Salog data before send xml ' . json_encode($postdata, JSON_PRETTY_PRINT));
                            $sts = $this->statusintigration->salogshipmentstatus($postdata);
                        }
                        /* send ePODs to SALog, getting these methods from Driverapiv5 controller (on 09-09-2021) as high priority */
                    }
                    /*if ($order_data['created_source'] == 18 || (count($rlgRefVal) > 0)) {
                        $macadam_data['physicalreceiver'] = $order_data['physicalreceiver'];
                        $macadam_data['logicalreceiver'] = $order_data['logicalreceiver'];
                        $macadam_data['physicalsender'] = $order_data['physicalsender'];
                        $macadam_data['logicalsender'] = $order_data['logicalsender'];
                        $macadam_data['pickup_city'] = $order_data['pickup_city'];
                        $macadam_data['delivery_city'] = $order_data['delivery_city'];
                        $macadam_data['branch_code'] = $order_data['branch_code'];
                        $macadam_data['company_code'] = $order_data['company_code'];
                        $macadam_data['user_id'] = $order_data['user_id'];
                        $macadam_data['created_source'] = $order_data['created_source'] = 18;
                        $macadam_data['tracking_ref'] =  (count($rlgRefVal) > 0) ? $rlgRefVal['ref_value'] :  $macadam_data['tracking_ref'];

                        $macadam_data['stop_type'] = $stop_type;
                        $status_stage = $shipstopStatusData['status_stage'];

                        if ($missing_qty) {
                            $macadam_data['missing_qty'] = $missing_qty;

                            $data_x = [
                                'order_id' => $order_data['id'],
                                'reference_id' => 'ORD_DEL_MISS_QTY',
                                'ref_value' => $missing_qty,
                                'status' => 1,
                                'createdon' => date('Y-m-d H:i:s'),
                                'updatedon' => date('Y-m-d H:i:s'),
                            ];
                            $this->common->insertTableData('tb_order_references', $data_x);
                        }

                        $reference_id = $status_type == 'P' ? 'ODR_POP_COMNT' : 'ODR_POD_COMNT';
                        if ($comment) {
                            $macadam_data['remark'] = $comment;

                            $data_x = [
                                'order_id' => $order_data['id'],
                                'reference_id' => $reference_id,
                                'ref_value' => $comment,
                                'status' => 1,
                                'createdon' => date('Y-m-d H:i:s'),
                                'updatedon' => date('Y-m-d H:i:s'),
                            ];
                            $this->common->insertTableData('tb_order_references', $data_x);
                        }

                        if (!empty($macadam_d3_data_inp)) {
                            if ($macadam_d3_data_inp['ins_id'] > 0) {
                                $p_img_up_data = $this->common->gettblrowdata(
                                    ['id' => $macadam_d3_data_inp['ins_id']],
                                    'imgpath,stop_type',
                                    'tb_pod_uploads',
                                    0,
                                    0
                                );
                            }
                            $upload_type = 'Picture';
                            $picture_id = $macadam_d3_data_inp['ins_id'];



                            $macadam_data['upload_type'] = $upload_type;
                            if (isset($p_img_up_data) && !empty($p_img_up_data)) {
                                $getDocumentType = $this->common->checkDocumentSentType($macadam_data['tracking_ref']);
                                if ($getDocumentType == 1) {
                                    $macadam_d3_data = [
                                        "physical_receiver" => $order_data['physicalreceiver'],
                                        "logical_receiver" => $order_data['logicalreceiver'],
                                        "physical_sender" => $order_data['physicalsender'],
                                        "logical_sender" => $order_data['logicalsender'],
                                        "order_id" => $macadam_data['tracking_ref'],
                                        "assoc_id" => $macadam_data['assoc_id'],
                                        "ref_value_kn_office" => $macadam_data['ref_value_kn_office'],
                                        "upload_type" => $macadam_data['upload_type'],
                                        "file_path" => NEW_POD_PATH . $p_img_up_data['imgpath'],
                                        "branch_code" => $macadam_data['branch_code'],
                                        "company_code" => $macadam_data['company_code'],
                                        "user_id" => $macadam_data['user_id'],
                                        "created_source" => $macadam_data['created_source'],
                                    ];
                                    $macadam_d3_data_inp['ins_id'] = macadam_d3_dms($macadam_d3_data);
                                } else {
                                    $roadlogData = $this->common->getRoadlogOrderDetails($order_data['id']);
                                    /*if ($macadam_data['stop_type'] == "P") {
                                        $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $this);
                                    }
                                    if ($macadam_data['stop_type'] == "D") {
                                        $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $this);
                                    }---------------
                                }
                            }
                        }
                        if ($status_stage == "PICKUP_OK" && $order_data['created_source'] == 18) {
                           // log_message('error', 'Secure Link Roadlog PUP Triggerd to SAlog');
                            $orderReferenceCount = $this->Roadlogtosalogmodel->getOrderReferenceCount($order_data['id']);
                            //log_message('error', 'Secure Link Roadlog PUP Reference Count' . $orderReferenceCount);
                            if ($orderReferenceCount > 1) {
                                $slogData = [
                                    'order_id' => $order_data['id'],
                                    'shipment_id' => $order_data['shift_id'],
                                ];
                                $this->roadlogsalogdocument->sendDocumentToSlog($slogData);
                            }
                        }

                        if (isset($document_id)) {
                            $macadam_data['document_id'] = $macadam_d3_data_inp['ins_id'];
                        }
                        if (isset($picture_id)) {
                            $macadam_data['picture_id'] = $macadam_d3_data_inp['ins_id'];
                        }

                        if (!empty($macadam_d3_POD_data)) {
                            log_debug('Macadam raw POD data => ' . json_encode($macadam_d3_POD_data, JSON_PRETTY_PRINT));
                            if ($macadam_d3_POD_data['ins_id'] > 0) {
                                $p_img_up_data = $this->common->gettblrowdata(
                                    ['id' => $macadam_d3_POD_data['ins_id']],
                                    'imgpath,stop_type,receiver_name',
                                    'tb_pod_uploads',
                                    0,
                                    0
                                );
                            }
                            if ($macadam_d3_POD_data['stptype'] == 'D') {
                                $upload_type = $macadam_d3_POD_data['img_store_type'];
                            }
                            $macadam_data['upload_type'] = $upload_type;
                            if (isset($p_img_up_data) && !empty($p_img_up_data)) {
                                $getDocumentType = $this->common->checkDocumentSentType($macadam_data['tracking_ref']);
                                if ($getDocumentType == 1) {
                                $macadam_d3_data = [
                                    "physical_receiver" => $order_data['physicalreceiver'],
                                    "logical_receiver" => $order_data['logicalreceiver'],
                                    "physical_sender" => $order_data['physicalsender'],
                                    "logical_sender" => $order_data['logicalsender'],
                                    "order_id" => $macadam_data['tracking_ref'],
                                    "assoc_id" => $macadam_data['assoc_id'],
                                    "upload_type" => $macadam_data['upload_type'],
                                    "ref_value_kn_office" => $macadam_data['ref_value_kn_office'],
                                    "file_path" => NEW_POD_PATH . $p_img_up_data['imgpath'],
                                    "branch_code" => $macadam_data['branch_code'],
                                    "company_code" => $macadam_data['company_code'],
                                    "user_id" => $macadam_data['user_id'],
                                    "created_source" => $macadam_data['created_source'],
                                ];
                                $doc_id = macadam_d3_dms($macadam_d3_data);
                                } else {
                                    $roadlogData = $this->common->getRoadlogOrderDetails($order_data['id']);
                                    /*if ($macadam_data['stop_type'] == "P") {
                                        $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $this);
                                    }
                                    if ($macadam_data['stop_type'] == "D") {
                                        $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $this);
                                    }----------------
                                }

                                if ($macadam_d3_POD_data['img_store_type'] == 'POD') {
                                    $macadam_data['document_id'] = $doc_id;
                                    $macadam_data['pod_signee'] = $p_img_up_data['receiver_name'];
                                } elseif ($macadam_d3_POD_data['img_store_type'] == 'PIC') {
                                    $macadam_data['picture_id'] = $doc_id;
                                } else {
                                    $macadam_data['picture_id'] = $doc_id;
                                }
                            }
                        }

                        log_debug('macadam data before send xml => ' . json_encode($macadam_data, JSON_PRETTY_PRINT));
                        try {
                            macadam_status_send($macadam_data, $status_stage);
                        } catch (Exception $exception) {
                            log_error('Error Message exception occurred in macadam_status_send' . $exception->getMessage());

                            return ["status" => 0, "data" => "Failed : " . $exception->getMessage()];
                        }
                    } else {
                        $macadam_data['physicalreceiver'] = $order_data['physicalreceiver'];
                        $macadam_data['logicalreceiver'] = $order_data['logicalreceiver'];
                        $macadam_data['physicalsender'] = $order_data['physicalsender'];
                        $macadam_data['logicalsender'] = $order_data['logicalsender'];
                        $macadam_data['pickup_city'] = $order_data['pickup_city'];
                        $macadam_data['delivery_city'] = $order_data['delivery_city'];
                        $macadam_data['branch_code'] = $order_data['branch_code'];
                        $macadam_data['company_code'] = $order_data['company_code'];
                        $macadam_data['user_id'] = $order_data['user_id'];
                        $macadam_data['created_source'] = $order_data['created_source'];

                        $macadam_data['stop_type'] = $stop_type;
                        $status_stage = $shipstopStatusData['status_stage'];

                        if ($missing_qty) {
                            $macadam_data['missing_qty'] = $missing_qty;

                            $data_x = [
                                'order_id' => $order_data['id'],
                                'reference_id' => 'ORD_DEL_MISS_QTY',
                                'ref_value' => $missing_qty,
                                'status' => 1,
                                'createdon' => date('Y-m-d H:i:s'),
                                'updatedon' => date('Y-m-d H:i:s'),
                            ];
                            $this->common->insertTableData('tb_order_references', $data_x);
                        }

                        $reference_id = $status_type == 'P' ? 'ODR_POP_COMNT' : 'ODR_POD_COMNT';
                        if ($comment) {
                            $macadam_data['remark'] = $comment;

                            $data_x = [
                                'order_id' => $order_data['id'],
                                'reference_id' => $reference_id,
                                'ref_value' => $comment,
                                'status' => 1,
                                'createdon' => date('Y-m-d H:i:s'),
                                'updatedon' => date('Y-m-d H:i:s'),
                            ];
                            $this->common->insertTableData('tb_order_references', $data_x);
                        }

                        if (!empty($macadam_d3_data_inp)) {
                            if ($macadam_d3_data_inp['ins_id'] > 0) {
                                $p_img_up_data = $this->common->gettblrowdata(
                                    ['id' => $macadam_d3_data_inp['ins_id']],
                                    'imgpath,stop_type',
                                    'tb_pod_uploads',
                                    0,
                                    0
                                );
                            }
                            $upload_type = 'Picture';
                            $picture_id = $macadam_d3_data_inp['ins_id'];


                            $macadam_data['upload_type'] = $upload_type;
                            if (isset($p_img_up_data) && !empty($p_img_up_data)) {
                                $getDocumentType = $this->common->checkDocumentSentType($macadam_data['tracking_ref']);
                                if ($getDocumentType == 1) {
                                    $macadam_d3_data = [
                                        "physical_receiver" => $order_data['physicalreceiver'],
                                        "logical_receiver" => $order_data['logicalreceiver'],
                                        "physical_sender" => $order_data['physicalsender'],
                                        "logical_sender" => $order_data['logicalsender'],
                                        "order_id" => $macadam_data['tracking_ref'],
                                        "assoc_id" => $macadam_data['assoc_id'],
                                        "ref_value_kn_office" => $macadam_data['ref_value_kn_office'],
                                        "upload_type" => $macadam_data['upload_type'],
                                        "file_path" => NEW_POD_PATH . $p_img_up_data['imgpath'],
                                        "branch_code" => $macadam_data['branch_code'],
                                        "company_code" => $macadam_data['company_code'],
                                        "user_id" => $macadam_data['user_id'],
                                        "created_source" => $macadam_data['created_source'],
                                    ];
                                    $macadam_d3_data_inp['ins_id'] = macadam_d3_dms($macadam_d3_data);
                                } else {
                                    $roadlogData = $this->common->getRoadlogOrderDetails($order_data['id']);
                                    /*if ($macadam_data['stop_type'] == "P") {
                                        $pupStatus = SendDocumentGateOut::sendepopgateoutnotify($roadlogData, $this);
                                    }
                                    if ($macadam_data['stop_type'] == "D") {
                                        $podStatus = SendDocumentGateOut::sendepodgateoutnotify($roadlogData, $this);
                                    }---------------
                                }
                            }
                        }
                        if ($status_stage == "PICKUP_OK" && $order_data['created_source'] == 18) {
                            //log_message('error', 'Secure Link Roadlog PUP Triggerd to SAlog');
                            $orderReferenceCount = $this->Roadlogtosalogmodel->getOrderReferenceCount($order_data['id']);
                            //log_message('error', 'Secure Link Roadlog PUP Reference Count' . $orderReferenceCount);
                            if ($orderReferenceCount > 1) {
                                $slogData = [
                                    'order_id' => $order_data['id'],
                                    'shipment_id' => $order_data['shift_id'],
                                ];
                                $this->roadlogsalogdocument->sendDocumentToSlog($slogData);
                            }
                        }

                        if (isset($document_id)) {
                            $macadam_data['document_id'] = $macadam_d3_data_inp['ins_id'];
                        }
                        if (isset($picture_id)) {
                            $macadam_data['picture_id'] = $macadam_d3_data_inp['ins_id'];
                        }

                        if (!empty($macadam_d3_POD_data)) {
                            log_debug('Macadam raw POD data => ' . json_encode($macadam_d3_POD_data, JSON_PRETTY_PRINT));
                            if ($macadam_d3_POD_data['ins_id'] > 0) {
                                $p_img_up_data = $this->common->gettblrowdata(
                                    ['id' => $macadam_d3_POD_data['ins_id']],
                                    'imgpath,stop_type,receiver_name',
                                    'tb_pod_uploads',
                                    0,
                                    0
                                );
                            }
                            if ($macadam_d3_POD_data['stptype'] == 'D') {
                                $upload_type = $macadam_d3_POD_data['img_store_type'];
                            }
                            $macadam_data['upload_type'] = $upload_type;
                            if (isset($p_img_up_data) && !empty($p_img_up_data)) {
                                $macadam_d3_data = [
                                    "physical_receiver" => $order_data['physicalreceiver'],
                                    "logical_receiver" => $order_data['logicalreceiver'],
                                    "physical_sender" => $order_data['physicalsender'],
                                    "logical_sender" => $order_data['logicalsender'],
                                    "order_id" => $macadam_data['tracking_ref'],
                                    "assoc_id" => $macadam_data['assoc_id'],
                                    "upload_type" => $macadam_data['upload_type'],
                                    "ref_value_kn_office" => $macadam_data['ref_value_kn_office'],
                                    "file_path" => NEW_POD_PATH . $p_img_up_data['imgpath'],
                                    "branch_code" => $macadam_data['branch_code'],
                                    "company_code" => $macadam_data['company_code'],
                                    "user_id" => $macadam_data['user_id'],
                                    "created_source" => $macadam_data['created_source'],
                                ];
                                $doc_id = macadam_d3_dms($macadam_d3_data);
                                if ($macadam_d3_POD_data['img_store_type'] == 'POD') {
                                    $macadam_data['document_id'] = $doc_id;
                                    $macadam_data['pod_signee'] = $p_img_up_data['receiver_name'];
                                } elseif ($macadam_d3_POD_data['img_store_type'] == 'PIC') {
                                    $macadam_data['picture_id'] = $doc_id;
                                } else {
                                    $macadam_data['picture_id'] = $doc_id;
                                }
                            }
                        }

                        log_debug('macadam data before send xml => ' . json_encode($macadam_data, JSON_PRETTY_PRINT));
                        try {
                            macadam_status_send($macadam_data, $status_stage);
                        } catch (Exception $exception) {
                            log_error('Error Message exception occurred in macadam_status_send' . $exception->getMessage());

                            return ["status" => 0, "data" => "Failed : " . $exception->getMessage()];
                        }
                    }*/
                } catch (Exception $e) {
                    log_error('Error Message expction occured ' . $e->getMessage());
                }

                /* Here send driver action status send to otm */
                $tdata = [
                    'employee_id' => $data['employee_id'],
                    'trip_id' => $data['trip_id'],
                    'stop_id' => $stop_id,
                ];
                $trip_employee = $this->common->gettblrowdata($tdata, 'id', 'tb_trip_employee', 0, 0);
                if (!empty($trip_employee)) {
                    $id = $trip_employee['id'];
                    if ($data["status"] == 1 && ($stsreason == 285 || $stsreason == 280)) {
                        $empdt = [
                            'status' => 1,
                            'absent_reason' => 'Closed',
                            'pd_status' => 'Closed',
                            'updated_on' => $curdt
                        ];
                        $this->common->updatetbledata('tb_trip_employee', $empdt, ['id' => $id]);
                    }
                    $response = ["status" => 1, "data" => ["trip_employee_id" => $id]];
                } else {
                    if ((($stsreason == 285 || $stsreason == 280) && $data["status"] == 1) || ($data["status"] == 0)) {
                        if ($stsreason == 285 || $stsreason == 280) {
                            $data['absent_reason'] = 'Closed';
                        } elseif ($stsreason == 0) {
                            $data['absent_reason'] = 'Cancelled';
                        }
                        $data["stop_id"] = $stop_id;
                        $id = $this->common->insertTableData("tb_trip_employee", $data);
                        $response = $id ? ["status" => 1, "data" => "Updated Status!"] : [
                            "status" => 0,
                            "data" => "Failed to Set Shipment Status"
                        ];
                    } else {
                        $response = ["status" => 1, "data" => "Updated Status!"];
                    }
                }

                if ($stop_type === "D" && $stscode === "SV0510") {
                    $this->load->library('UpdateTripOrderCloseStatus');
                    $this->updatetriporderclosestatus->orderId = $tb_order_id;
                    $this->updatetriporderclosestatus->tripId = $data["trip_id"];
                    $this->updatetriporderclosestatus->shipmentId = $shipment_id;
                    $this->updatetriporderclosestatus->vehicleId = $vehicle;
                    $this->updatetriporderclosestatus->driverId = $driver;
                    $this->updatetriporderclosestatus->triggerShipmentClose();

                }
                if ((($order_data['created_source'] ?? '') == 5) && in_array($stscode, ['SV0200', 'SV0220', 'SV0131', 'SV0510'])) {
                    $getLocalTime = getdatetimebytimezone($this->session->userdata("timezone"),$curdt,DFLT_TZ)['datetime'];
                    $this->load->library('notifytrigger');
                    $this->notifytrigger->orderStatusNotification($macadam_data['order_id'], $stscode, $getLocalTime);
                }
            }
        }

        return $response;
    }

    private function SendNotificationMailFromSecureLink(string $stopType, string $statusMessage, int $orderId)
    {
        if (!empty($orderId)) {
            $this->load->library('notifytrigger');
            $data['page_title'] = 'Booking Notification';
            $data['subject'] = 'Booking Notification';
            $data['order_id'] = $orderId;
            $action = "pickup_note";
            $data['securelink'] = 1;
            $checkPodUploads = ['stop_type'=>'P','doc_type'=>'4','order_id'=>$orderId,'status'=>'1'];
            if ($stopType == "D") {
                $action = "delivery_note";
                $checkPodUploads = ['stop_type'=>'D','doc_type'=>'3','order_id'=>$orderId,'status'=>'1'];
            }
            $data['action'] = $action;
            $getOrderDetails = $this->common->gettblrowdata(['id' => $orderId], 'order_id,user_id', 'tb_orders', 0, 0);
            if (!empty($getOrderDetails)) {
                $data['orderid'] = $bookingId = $getOrderDetails['order_id'];
                $userId = $getOrderDetails['user_id'];
                $getUserDetails = $this->common->gettblrowdata(['id' => $userId], 'name', 'tb_users', 0, 0);
                $data['username'] = $getUserDetails['name'];
                $getPodUploads = $this->common->gettblrowdata($checkPodUploads, 'imgpath', 'tb_pod_uploads', 0, 0);
                if(!empty($getPodUploads)){
                    $filePath = $getPodUploads['imgpath'];
                    if(!empty($filePath)){
                        $data['attachment'] = sprintf('%s/poduploads/%s', '/var/www/', $filePath);
                    }
                }
                $data['statusMessage'] = $statusMessage;
                $data['cargos'] = $this->common->gettbldata(['order_id' => $orderId], 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
                $data['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $data, true);
                $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $data['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $this->notifytrigger->sendordernotify($data);
            }
        }
    }

    private function get_danger_goods_details(int $dg_goods_id = 0): object
    {
        $danger_goods_order_id = $dg_goods_id ?: $this->input->post('danger_goods_order_id', true);
        $response = ["status" => 0, "response" => []];
        if (is_numeric($danger_goods_order_id) && $danger_goods_order_id > 0) {
            $response_data = $this->common->gettbldata(
                ['order_id' => $danger_goods_order_id],
                '*',
                'tb_order_dg_goods',
                0,
                0,
                true
            );
            if (!empty($response_data)) {
                $response = ["status" => 1, "response" => $response_data];
            }
        }

        return (object)$response;
    }   

    public function poduploads(): void
        {
            $response = ["status" => 0, "data" => "Upload Failed!"];
            if (isset($_POST)) {
                $validation_response = $this->valdiation_poduploads_data();
                if ($validation_response) {
                    echo json_encode(["status" => 0, "data" => $validation_response]);
    
                    return;
                }
                $latitude = $this->input->post('latitude', true) ?? null;
                $longitude = $this->input->post('longitude', true) ?? null;
                $trip_id = $this->input->post('trip_id', true);
                $shipment_id = $this->input->post('shipment_id', true);
                $stop_id = $this->input->post('stop_id', true);
                $ordid = $this->input->post('order_id', true);
                $stop_detail_id = $this->input->post('stop_detail_id', true);
                $driver_id = $this->input->post('driver_id', true);
                $img_store_type = $this->input->post('img_store_type', true) ?? '';
                $rev_sign = $this->input->post('rev_sign', true) ?? '';
                $prefix_file_name = strtoupper(substr($img_store_type, 0, 3));
                $status_stage = isset($_POST['status_stage']) ? $this->input->post(
                        'status_stage',
                        true
                    ) . '_' . $prefix_file_name : '';
                $doc_type = $this->input->post('doc_type', true);
                $curdt = date('Y-m-d H:i:s');
                $fileName = "";
    
                if (isset($_FILES)) {
                    log_debug('Uploaded _FILES content => ' . json_encode($_FILES, JSON_PRETTY_PRINT));
                    if (isset($_FILES['file_name']['name'])) {
                        $file_name = str_replace(" ","",$_FILES['file_name']['name']);
                        $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
    
                        $config = [
                            'upload_path' => NEW_POD_PATH,
                            'allowed_types' => '*',
                            'overwrite' => true,
                            'file_name' => strtoupper(uniqid($prefix_file_name . '_')) . '_' . $file_name,
                        ];
    
                        $extensions = ["jpeg", "jpg", "png", "bmp", "pdf", "tif"];
    
                        if (in_array($file_ext, $extensions) === false) {
                            $response = ["status" => 0, "data" => "Image Format Not Allowed"];
                        } else {
                            $this->load->library('upload', $config);
                            $this->upload->initialize($config);
                            if ($this->upload->do_upload('file_name')) {
                                $imgname = $this->upload->data();
                                $fileName = $imgname['file_name'];
                                $response = ["status" => 1, "data" => "Document Uploaded Successfully!"];
                                
                                try {
                                    $filePath = $imgname['full_path'];
                                    $fileData = file_get_contents($filePath);
                                    $base64String = base64_encode($fileData);
                                    //log_message('debug', 'Base64 Encoded Image (First 500 chars): ' . substr($base64Image, 0, 500));
                                } catch (Exception $ex) {
                                    log_message('error', 'Error encoding image to base64: ' . $ex->getMessage());
                                }
                            } else {
                                $errors = $this->upload->display_errors();
                                $response = ["status" => 0, "data" => $errors];
                            }
                            $stptype = "P";
                            if ($fileName && $stop_id) {
                                $chkstype = (object)$this->drivermodel->gettblrowdata(
                                    ["id" => $stop_id, "status" => 1],
                                    "stoptype,txncode",
                                    'tb_shiporder_stops',
                                    0,
                                    0
                                );
                                if (!empty($chkstype)) {
                                    if ($chkstype->stoptype == "D") {
                                        $stptype = $chkstype->stoptype;
                                    }
                                }
    
                                $getUserId = $this->common->gettblrowdata(['id'=>$shipment_id],"user_id","tb_shifts",0,0);
                                $uid = $getUserId['user_id'] ?? 0;
                                $imageSize = filesize(NEW_POD_PATH.$fileName);
                                $newUuid = $this->uuid->v4();
                                $filedata = [
                                    'stop_id' => $stop_id,
                                    "shipment_id" => $shipment_id,
                                    'trip_id' => $trip_id,
                                    'latitude' => $latitude,
                                    'longitude' => $longitude,
                                    'doc_type' => $doc_type, //$status_id,
                                    'imgpath' => $fileName,
                                    'stop_detail_id' => $stop_detail_id,
                                    'stop_type' => $stptype,
                                    'user_id' => $uid,
                                    'createdby' => $driver_id,
                                    'order_id' => $ordid,
                                    'status' => 1,
                                    'createdon' => $curdt,
                                    'receiver_name' => $rev_sign,
                                    'status_code' => $status_stage,
                                    'hash' => $newUuid,
                                    'filesize' => $imageSize
                                ];
    
                                $where_pod_uploads = [
                                    'trip_id' => $trip_id,
                                    'stop_type' => $stptype,
                                    'order_id' => $ordid,
                                    'status' => 1,
                                    'status_code' => $status_stage
                                ];
                                $POD_uploads_existed = $this->common->gettblrowdata(
                                    $where_pod_uploads,
                                    '*',
                                    'tb_pod_uploads',
                                    0,
                                    0
                                );
                                
                                if($stptype == 'P' && $doc_type == '4')
                                {
                                    $otmDocType='APACPUP';
                                }
                                else if($stptype == 'P' && $doc_type == '1')
                                {
                                    $otmDocType='APACPUPESIGN';
                                }
                                else if($stptype == 'D' && $doc_type == '3')
                                {
                                    $otmDocType='APACPOD';
                                }
                                else if($stptype == 'D' && $doc_type == '1')
                                {
                                    $otmDocType='APACPODESIGN';
                                }
                                else
                                {
                                    $otmDocType='APACOTHERS';
                                }
    
                                if (empty($POD_uploads_existed)) {
                                    $pod_id = $this->drivermodel->insertTableData('tb_pod_uploads', $filedata);
                                    $response = ["status" => 1, "data" => "Document Uploaded Successfully!"];
                                } else {
                                    $pod_id = $POD_uploads_existed['id'];
                                    $updatePOD = $this->common->updatetbledata(
                                        'tb_pod_uploads',
                                        $filedata,
                                        ['id' => $pod_id]
                                    );
                                    $response = ['status' => 1, 'data' => 'Document Replaced Successfully'];
                                    if (!self::unlinkFile(NEW_POD_PATH . '/' . $POD_uploads_existed['imgpath'])) {
                                        $response = ['status' => 1, 'data' => 'Remove old file failed'];
                                    }
                                }
                                
                                $docTypeCnt = $this->common->getCount(
                                    ['order_id' => $ordid, 'doc_type' => $doc_type, 'status' => 1],
                                    'tb_pod_uploads'
                                );
                                if($docTypeCnt>1){
                                    $otmDocType = $otmDocType . "-" . ($docTypeCnt - 1);
                                }
                                
                                $curtz = $this->session->userdata("usr_tzone")['timezone'];
                                $domainDetails = $this->OtmBookingModel->getDomain($ordid);
                        		if (!empty($domainDetails)) {
                        			$extOrderId = $domainDetails[0]['external_order_id'];
                        			$domainName = $domainDetails[0]['ref_value'];
                                    $domainCreatedSource = $domainDetails[0]['created_source'];
                                    if($domainName<>"")
                                    {
                                        $otmRequest = [
                                            'glogDate' => date("Ymdhis"),
                                            'externalOrderId' => $extOrderId,
                                            'domainName' => $domainName,
                                            'createdSource'=> $createdsource ? $createdsource :  $domainCreatedSource,
                                            'timeZone' => $curtz ?? "",
                                            'base64String' => $base64String ?? "",
                                            'docType' => $otmDocType ?? ""
                                        ];
                                            
                                        $output = sendOTMDocuments($otmRequest);
                                   }
                        		}
    
                                /*if ($this->commonpodedi->checkDocumentType($doc_type)) {
                                    $this->commonpodedi->sendpodoutboundxml($ordid, $fileName, $doc_type);
                                }*/
                                $getOrderDetails = $this->completedordersmodel->getOrderDetailsWithLatLngs($ordid);
                                $orderCreatedSource = $getOrderDetails['createdSource'] ?? 0;
                                /*if ($orderCreatedSource == '11') {
                                    $this->statusintigration->sendPodToKnlogin($doc_type, $ordid,1);
                                }*/
                                $order = $this->common->gettblrowdata(['id' => $ordid], 'order_id, created_source,company_code,branch_code', 'tb_orders', 0, 0);
                                $createdsource = $order['created_source'] ?? '';
                                $orderNumber = $order['order_id'] ?? '';
                                $companyCode = $order['company_code'] ?? '';
                                $branchCode = $order['branch_code'] ?? '';
    
                                /*if ($createdsource == OrderSources::SALOG) {
                                    $salogXmlData = AbstractXMLData::getDataProvider($doc_type);
                                    $salogePodIntegrationService = new IntegrationService();
                                    $salogePodIntegrationService->sendePod(
                                        $salogXmlData->getData($shipment_id, $trip_id, $stop_id, $orderNumber, $ordid, $latitude, $longitude),
                                        $salogXmlData->getOrderType()
                                    );
                                }*/
                                try {
                                    $getCountryCode = $this->common->gettblrowdata(['user_id' => $uid], 'country_code', 'tbl_country_master', 0, 0);
                                    $countryCode = $getCountryCode['country_code'] ?? '65';
                                    $documentData = [
                                        "order_id" => $ordid,
                                        "ord_id" => $orderNumber,
                                        'country_code' => $countryCode,
                                        'company_code' => $companyCode,
                                        'branch_code' => $branchCode,
                                        'shipment_id' => $shipment_id,
                                        'trip_id' => $trip_id,
                                        'stop_id' => $stop_id,
                                        'doc_type' => $doc_type,
                                        'userid' => $uid,
                                        'filename' => $fileName
                                    ];
                                    //$this->standard_document_execution->sendStandardDocumentXMLtoAltova($documentData);
                                } catch (Exception $ex) {
                                    log_message("error", "Some Problem occured!, While Sending Order Documentto Altova " . $ex->getMessage());
                                }
    
                                $res_data = [
                                    'stptype' => $stptype,
                                    'ins_id' => $pod_id,
                                    'img_store_type' => $prefix_file_name,
                                ];
                                $response["res"] = $res_data;
                            }
                        }
                    }
                }
            }
            echo json_encode($response);
        }

    public function clearTripData(int $trip_id): void
    {
        $upData = [
            "order_id" => 0,
            "shipment_id" => 0,
            "stop_id" => 0,
            "stop_detail_id" => 0,
            "trip_id" => 0,
            "status" => 0,
        ];
        $this->common->updatetbledata('tb_stop_status', $upData, ['trip_id' => $trip_id]);
        $this->common->updatetbledata('tb_pod_uploads', $upData, ['trip_id' => $trip_id]);
        echo 'cleared this trip => ' . $trip_id;
    }

    private static function unlinkFile(string $filePath): bool
    {
        if (!@unlink($filePath)) {
            if (file_exists($filePath)) {
                log_error('Unable to delete file \'' . $filePath . '\'');

                return false;
            }
        }

        return true;
    }

    private function validate_setshipstopstatus_multiple_data(): string
    {
        $error_message = '';
        switch (true) {
            case $this->input->post('status') == null:
                $error_message = 'Status is undefined.';
                break;
            case $this->input->post('status_type') == null:
                $error_message = 'Status type is undefined.';
                break;
            case $this->input->post('status_stage') == null:
                $error_message = 'Status stage is undefined.';
                break;
            case $this->input->post('client_timezone_offset') == null:
                $error_message = 'client timezone offset value is undefined.';
                break;
        }

        return $error_message;
    }

    private function validateCrossBorderEarlyLegStatus(array $data): string
    {
        $errorMessage = '';
        $shipmentId = $data['shipmentId'];
        $statusId = $data['statusId'];
        $stopType = $data['stopType'];
        $getShiftId = $this->common->gettblrowdata(['shipmentId' => $shipmentId], "id", "tb_shifts", 0, 0);
        if(empty($getShiftId)) {
            return $errorMessage;
        }
        $shiftRowId = $getShiftId['id'];
        $checkStatus = $this->common->gettblrowdata(['shipment_id' => $shiftRowId, 'status_id' => $statusId, 'status' => '1', 'stop_type' => $stopType], "id", "tb_stop_status", 0, 0);
        if(empty($checkStatus)){
            $errorMessage = 'Please update GateOut Status for '.$shipmentId;
        }
        return $errorMessage;
    }

    private function valdiation_poduploads_data(): string
    {
        $error_message = '';
        switch (true) {
            case $this->input->post('trip_id') == null:
                $error_message = 'Trip id is undefined.';
                break;
            case $this->input->post('shipment_id') == null:
                $error_message = 'Shipment id is undefined.';
                break;
            case $this->input->post('stop_id') == null:
                $error_message = 'Stop id is undefined.';
                break;
            case $this->input->post('stop_detail_id') == null:
                $error_message = 'stop detail id is undefined.';
                break;
            case $this->input->post('driver_id') == null:
                $error_message = 'driver id value is undefined.';
                break;
            case $this->input->post('img_store_type') == null:
                $error_message = 'img store type value is undefined.';
                break;
            case $this->input->post('status_stage') == null:
                $error_message = 'client timezone offset value is undefined.';
                break;
        }

        return $error_message;
    }

    private function validateDriverRegistrationData(): string
    {
        $error_message = '';
        switch (true) {
            case $this->input->post('driver_name') === null:
                $error_message = 'Driver name is undefined.';
                break;
            case $this->input->post('mobile_number') === null:
                $error_message = 'Mobile number is undefined.';
                break;
            case $this->input->post('truck_reg_number') === null:
                $error_message = 'Truck registration number is undefined.';
                break;
        }
        log_error(PHP_EOL . $error_message);
        return $error_message;
    }

    /**
     * @throws JsonException
     */
    public function save_driver_data(): void
    {
        if ($this->session->userdata('is_login') === '') {
            redirect('driverlogin', 'refresh');
        }

        $errors = $this->validateDriverRegistrationData();
        if ($errors) {
            echo json_encode(['status' => 0, 'data' => $errors], JSON_THROW_ON_ERROR);
            return;
        }
        $driverName = $this->input->post('driver_name', true);
        $mobileNumber = $this->input->post('mobile_number', true);
        $truckRegNum = $this->input->post('truck_reg_number', true);
        $shipmentId = $this->input->post('shipment_id', true);
        $countryCode = $this->input->post('country_code', true);
        $deviceUUID = $this->input->post('device_uuid', true);
        $deviceInfo = $this->input->post('device_info', true);

        $checkDriverExists = $this->check_driver_registration($shipmentId, $deviceUUID, true);
        if ($checkDriverExists['status'] === 0) {
            echo json_encode($checkDriverExists, JSON_THROW_ON_ERROR);
            return;
        }

        $tripDriverDetails = $this->drivermodel->getTripDriverDetails($shipmentId);
        if (!$tripDriverDetails) {
            echo json_encode(["status" => 0, "message" => "Failed : No trip data found"], JSON_THROW_ON_ERROR);
            return;
        }

        $tripData = $tripDriverDetails['tripData'];

        $secureLinkDriverData = [
            'driver_device_uuid' => $deviceUUID,
            'driver_name' => $driverName,
            'driver_contact_number' => $mobileNumber,
            'driver_truck_reg_number' => $truckRegNum,
            'driver_lat' => null,
            'driver_lng' => null,
            'ip_address' => $this->input->ip_address(),
            'status' => 1,
            'shipment_id' => $shipmentId,
            'trip_id' => $tripData->trip_id,
            'country' => $countryCode,
            'device_info' => $deviceInfo,
        ];
        $insID = $this->common->insertTableData('tb_securelink_drivers', $secureLinkDriverData);
        echo json_encode([
                             "status" => 1,
                             "data" => [
                                 "service_link_driver_id" => $insID,
                                 "driver_device_uuid" => $deviceUUID,
                             ],
                             "message" => "Driver data saved",
                         ], JSON_THROW_ON_ERROR);
    }

    /**
     * @throws JsonException
     */
    public function check_driver_registration(string $shipmentId, string $deviceUUID, bool $returnType = false): array
    {
        $tripDriverDetails = $this->drivermodel->getTripDriverDetails($shipmentId);
        $existedDriverDeviceCount = false;
        if ($tripDriverDetails) {
            $tripData = $tripDriverDetails['tripData'];
            $existedDriverDeviceCount = $this->drivermodel->checkDriverDeviceExisted(
                $deviceUUID,
                $shipmentId,
                $tripData->trip_id
            );
        }
        $res = $existedDriverDeviceCount ? [
            "status" => 0,
            "message" => "Driver already exists",
        ] : [
            "status" => 1,
            "message" => "Driver need to register",
        ];
        if (!$returnType) {
            echo json_encode($res, JSON_THROW_ON_ERROR);
        }
        return $res;
    }

    /*
     * send PUP notify
     */
    public function sendEPOPGateoutNotify($postdata)
    {
        /*check SDT Ref*/
        $sdtref = getsdtreforder($postdata['ord_id']);
        if ($sdtref == "PUP" || $sdtref == "") {
            $ship_id = $postdata['shipment_id'];
            $ord_id = $postdata['ord_id'];
            $curtz = $this->db->escape($postdata['curtz']);
            $chkcust = $this->db->query(
                "SELECT o.id,o.order_id,o.customer_id,o.user_id,o.pickup_address1,o.delivery_address1,c.name,c.gcm_id,
                c.company_code, c.branch_code,c.phone,c.code FROM tb_orders o,tb_customers c WHERE
                o.customer_id=c.id AND o.id= ?  LIMIT 1",[$ord_id]);
            if ($chkcust->num_rows() > 0) {
                $ordid = $chkcust->row()->id;
                $user_id = $chkcust->row()->user_id;
                $company_code = $chkcust->row()->company_code;
                $branch_code = $chkcust->row()->branch_code;
                $custcid = $chkcust->row()->phone;
                $custcode = $chkcust->row()->code;
                $pickaddr = $chkcust->row()->pickup_address1;
                $deliveryaddr = $chkcust->row()->delivery_address1;
                $order_id = $chkcust->row()->order_id;
                $chkdocs = $this->db->query(
                    "SELECT ts.id,ts.latitude,ts.longitude,ts.stop_id,ts.stop_type,ts.createdby,convertToClientTZ(ts.createdon," . $curtz . ") as createdon,ts.imgpath,ts.hash,'" . $order_id . "' as order_id,dt.type_name as type_name from tb_pod_uploads ts,tb_document_types dt WHERE ts.order_id = ? AND dt.id=ts.doc_type AND dt.type_name=? AND ts.status=? GROUP BY ts.id ORDER BY ts.createdon ASC",[$ordid,'PUP',1]
                );
                if ($chkdocs->num_rows() > 0) {
                    $data['order'] = [
                        "order_id" => $order_id,
                        "pickup_address1" => $pickaddr,
                        "delivery_address1" => $deliveryaddr
                    ];
                    $data['userid'] = $user_id;
                    $epodpath = "./assets/trippods/RL" . $order_id . ".pdf";
                    $data["pod"] = $chkdocs;
                    /* get all order references in single row*/
                    $data["orderref"] = $this->common->getallorderreferences($ordid);
                    $refvalue = $orderDepartmentCode = "";
                    /*get department code for this order*/
                    $departmentCode = $this->common->gettblrowdata(
                        ['order_row_id' => $ordid],
                        "department_code",
                        "tb_order_details",
                        0,
                        0
                    );
                    if (!empty($departmentCode)) {
                        $orderDepartmentCode = $departmentCode['department_code'];
                    }
                    $data['pickup_datetime'] = "";
                    $data['delivery_datetime'] = "";
                    $stops = $this->db->query(
                        "SELECT ss.stop_type,ss.status_id,ss.latitude,
                        ss.longitude,convertToClientTZ(ss.createdon," . $curtz . ") as createdon,
                        sm.status_name from tb_stop_status ss LEFT JOIN tb_status_master sm
                        ON sm.id=ss.status_id WHERE ss.shipment_id= ?  AND ss.status=?
                        ORDER BY ss.createdon ASC",[$ship_id,1]
                    );
                    if ($stops->num_rows() > 0) {
                        foreach ($stops->result() as $sres) {
                            if ($sres->status_id == "274" && $sres->stop_type == "P") {
                                $data['pickup_datetime'] = $sres->createdon;
                            }
                            if ($sres->status_id == "279" && $sres->stop_type == "D") {
                                $data['delivery_datetime'] = $sres->createdon;
                            }
                        }
                    }
                    $this->load->library('m_pdf');
                    $html = $this->load->view('settings/bulkepod', $data, true);
                    $chk = @$this->m_pdf->pdf->WriteHTML($html);
                    $chk = @$this->m_pdf->pdf->Output($epodpath, "F");
                    $unique_id = "RL" . $order_id . "." . date("Ymd") . "." . date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    /* SALog JPL*/
                    $chkordtypeqry1 = $this->db->query(
                        "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1"
                    );
                    $bn = $inn = $iv = $dq = $cmp = $brn = "";
                    if ($chkordtypeqry1->num_rows() > 1) {
                        foreach ($chkordtypeqry1->result() as $oref1) {
                            if ($oref1->reference_id == "BN") {
                                $bn = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "INN") {
                                $inn = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "XSR") {
                                $refvalue = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "DQ") {
                                if (strlen($oref1->ref_value) < 11 && (strpos($oref1->ref_value, 'O') === false)) {
                                    $dq = $oref1->ref_value;
                                }

                            }
                            if ($oref1->reference_id == "CMP") {
                                $cmp = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "BRN") {
                                $brn = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "XSR") {
                                $refvalue = $oref1->ref_value;
                            }
                        }
                    }
                    if ($cmp == "") {
                        $cmp = $company_code;
                    }
                    if ($brn == "") {
                        $brn = $branch_code;
                    }
                    $countrycode = substr($company_code, 0, -2);
                    $randomstr = RandomString::generate(10);
                    $jplData = [
                        "country" => $cmp,
                        "branch" => $brn,
                        "order_id" => $order_id,
                        "time" => date("hi"),
                        "unique_id" => $unique_id,
                        "date" => date("d.m.Y"),
                        "pages" => $pages,
                        "xsr" => $refvalue,
                        "sd" => $orderDepartmentCode,
                        "bn" => $bn,
                        "inn" => $inn,
                        "iv" => $iv,
                        "dq" => $dq,
                        "custcid" => $custcid,
                        "custcode" => $custcode,
                        "countrycode" => $countrycode,
                        "randomstr" => $randomstr,
                        "doctype" => 171
                    ];
                    $jplFilePath = $this->saveSalogJPF($jplData);
                    $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                    $storeftippdf = $this->uploadSalogKNFile($epodpath);
                }
            }
        }
    }

    /*
     * Save salog JPF
     */
    public function saveSalogJPF($jplData)
    {
        $content = $this->load->view("jpl_salogtemplate", $jplData, true);
        $order_id = $jplData["order_id"];
        $file_path = "./assets/jpl_files/RL$order_id.jpl";
        $fp = fopen($file_path, "wb");
        fwrite($fp, $content);
        fclose($fp);
        return $file_path;
    }

    /*
     * Upload salog file
     */
    public function uploadSalogKNFile($localfile)
    {
        $remotefile = basename($localfile);
        /*log_message("error","$remotefile file uploaded to KN FTP");*/
        $sftp_url = SALOG_FTP;
        $username = SALOG_FTP_USER;
        $password = SALOG_FTP_PWD;
        $folder_name = "/pub/inbound/D3/IF";
        try {
            $sftp = new SFTP($sftp_url);
            if (!$sftp->login($username, $password)) {
                /*throw new \Exception('Cannot login into your server !');*/
                unset($sftp);
                log_message("error", "Cannot login into your SALOG MTF Test server !");
            } else {
                $sftp->chdir($folder_name);
                $sftp->put($folder_name . "/" . $remotefile, $localfile, SFTP::SOURCE_LOCAL_FILE);
                unset($sftp);
                return true;
            }
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, SALOG MTF Test server, Please Try Again Later.");
        }
    }

    /*
     * send POD Gate out notify
     */
    public function sendEPODGateoutNotify($postdata)
    {
        $sdtref = getsdtreforder($postdata['ord_id']);
        if ($sdtref == "DEL" || $sdtref == "") {
            $ship_id = $postdata['shipment_id'];
            $ord_id = $postdata['ord_id'];
            $curtz = $this->db->escape($postdata['curtz']);
            $chkcust = $this->db->query(
                "SELECT o.id,o.order_id,o.pickup_address1,o.delivery_address1,o.user_id,o.company_code,o.branch_code,o.created_source,c.phone,c.code FROM tb_orders o,tb_customers c WHERE o.customer_id=c.id AND o.id=? LIMIT 1",[$ord_id]
            );
            if ($chkcust->num_rows() > 0) {
                $orddata = $chkcust->row_array();
                $ordid = $orddata['id'];
                $order_id = $orddata['order_id'];
                $user_id = $orddata['user_id'];
                $company_code = $orddata['company_code'];
                $branch_code = $orddata['branch_code'];
                $createdsource = $orddata['created_source'];
                $custcid = $orddata['phone'];
                $custcode = $orddata['code'];
                $chkadminusr = $this->db->query(
                    "SELECT name,emailid,cc_mails FROM tb_users WHERE id=$user_id AND emailid!='' LIMIT 1"
                );
                if ($chkadminusr->num_rows() > 0) {
                    $this->load->library('email');
                    $receivename = $chkadminusr->row()->name;
                    $receivemail = $chkadminusr->row()->emailid;
                    $ccmail = array();
                    if ($chkadminusr->row()->cc_mails != "") {
                        $ccmail[] = $chkadminusr->row()->cc_mails;
                    }
                    $data['order'] = $orddata;
                    $data['userid'] = $user_id;
                    $epodpath = "./assets/trippods/RL" . $order_id . ".pdf";
                    if ($createdsource == 5) {
                        $data["pod"] = $this->db->query(
                            "SELECT ts.id,ts.latitude,ts.longitude,
                            ts.stop_id,ts.stop_type,ts.createdby,
                            convertToClientTZ(ts.createdon," . $curtz . ") as createdon, ts.imgpath,ts.hash,
                             e.address, e.pickup, e.drop,e.order_id,dt.type_name as type_name from tb_pod_uploads ts LEFT JOIN
                             tb_employee e ON e.id = ts.stop_detail_id INNER JOIN tb_document_types dt ON dt.id=ts.doc_type WHERE
                             ts.order_id = ? AND dt.type_name <> ? AND ts.status=?
                             GROUP BY ts.id ORDER BY ts.createdon ASC",[$ordid,"PUP",1]
                        );
                    } else {
                        $data["pod"] = $ordpods = $this->db->query(
                            "SELECT ts.id,ts.latitude,
                            ts.longitude,ts.stop_id,ts.stop_type,'POD' as type_name,ts.createdby,
                            convertToClientTZ(ts.createdon," . $curtz . ") as createdon, ts.imgpath,ts.hash,
                             e.address,e.pickup,e.drop,e.order_id from tb_pod_uploads ts LEFT JOIN
                             tb_employee e ON e.id = ts.stop_detail_id WHERE
                             ts.order_id = ? AND ts.stop_type='D' AND ts.status=?
                             GROUP BY ts.id ORDER BY ts.createdon ASC",[$ordid,1]
                        );
                        if ($ordpods->num_rows() == 0) {
                            $data["pod"] = $this->db->query(
                                "SELECT ts.id,ts.latitude,ts.longitude,
                                ts.stop_id,ts.stop_type,'POD' as type_name,ts.createdby,
                                convertToClientTZ(ts.createdon," . $curtz . ") as createdon,
                                 ts.imgpath,ts.hash, e.address,e.pickup,e.drop,e.order_id from tb_pod_uploads ts
                                  LEFT JOIN tb_employee e ON e.id = ts.stop_detail_id WHERE
                                  ts.shipment_id = ? AND ts.stop_type='D' AND
                                  ts.status=? GROUP BY ts.id ORDER BY ts.createdon ASC",[$ship_id,1]
                            );
                        }
                    }
                    $data["orderref"] = $this->common->getallorderreferences($ordid);
                    $this->load->library('m_pdf');
                    if (checkAccessConditions('CHANGE_EPOD_EMAIL_SUBJECT_WITH_DQ_PO', $company_code)) {
                        $checkOrderReferences = $this->common->getOrderDQPOReferences($ordid);
                        $subReference = "";
                        foreach ($checkOrderReferences as $orderReference) {
                            $subReference .= " " . $orderReference->ref_value;
                        }
                        $sub = "Svkonekt::Shipment ePOD & Milestone Status #" . $subReference . " ";
                    } else {
                        $sub = "Svkonekt::Shipment ePOD & Milestone Status #" . $order_id . " ";
                    }

                    $data['page_title'] = "Trip ePOD";
                    $data['receivemail'] = $receivemail;
                    $data['receivename'] = $receivename;
                    $chkref = "XSR";
                    $refvalue = $newsub = $orderDepartmentCode = "";
                    $iofeof = "EOF";
                    $chkordtypeqry1 = $this->db->query(
                        "SELECT reference_id,ref_value FROM tb_order_references WHERE order_id=$ordid AND ref_value!='' GROUP BY reference_id HAVING count(reference_id)>=1"
                    );
                    $bn = $inn = $iv = $dq = $cmp = $brn = "";
                    if ($chkordtypeqry1->num_rows() > 1) {
                        foreach ($chkordtypeqry1->result() as $oref1) {
                            if ($oref1->reference_id == "BN") {
                                $bn = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "INN") {
                                $inn = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "XSR") {
                                $refvalue = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "SD" && $oref1->ref_value == "2") {
                                $iofeof = "IOF";
                            }
                            if ($oref1->reference_id == "DQ") {
                                if (strlen($oref1->ref_value) < 11 && (strpos($oref1->ref_value, 'O') === false)) {
                                    $dq = $oref1->ref_value;
                                }
                            }
                            if ($oref1->reference_id == "CMP") {
                                $cmp = $oref1->ref_value;
                            }
                            if ($oref1->reference_id == "BRN") {
                                $brn = $oref1->ref_value;
                            }
                        }
                    }
                    /*get department code for this order*/
                    $departmentCode = $this->common->gettblrowdata(
                        ['order_row_id' => $ordid],
                        "department_code",
                        "tb_order_details",
                        0,
                        0
                    );
                    if (!empty($departmentCode)) {
                        $orderDepartmentCode = $departmentCode['department_code'];
                    }
                    $data['stops'] = [];
                    $data['pickup_datetime'] = "";
                    $data['delivery_datetime'] = "";
                    $stops = $this->db->query(
                        "SELECT ss.stop_type,ss.status_id,ss.latitude,
                        ss.longitude,convertToClientTZ(ss.createdon," . $curtz . ") as createdon,
                         sm.status_name, t.register_number,d.name from tb_stop_status ss LEFT JOIN
                         tb_status_master sm ON sm.id=ss.status_id LEFT JOIN tb_trucks_data t ON
                         ss.vehicle_id=t.id LEFT JOIN tb_truck_drivers d ON ss.driver_id=d.id WHERE
                         ss.shipment_id=? AND ss.status=? ORDER BY ss.createdon ASC",[$ship_id,1]
                    );
                    if ($stops->num_rows() > 0) {
                        foreach ($stops->result() as $sres) {
                            $stsname = $sres->status_name;
                            if ($sres->status_id == "274" && $sres->stop_type == "P") {
                                $stsname = "Pickup Gate In";
                            }
                            if ($sres->status_id == "285" && $sres->stop_type == "P") {
                                $data['pickup_datetime'] = $sres->createdon;
                                $stsname = "Pickup Done";
                            }
                            if ($sres->status_id == "275" && $sres->stop_type == "P") {
                                $stsname = "Pickup Gate Out";
                            }
                            if ($sres->status_id == "279" && $sres->stop_type == "D") {
                                $stsname = "Delivery Gate In";
                            }
                            if ($sres->status_id == "280" && $sres->stop_type == "D") {
                                $data['delivery_datetime'] = $sres->createdon;
                                $stsname = "Delivery Done";
                            }
                            if ($sres->status_id == "281" && $sres->stop_type == "D") {
                                $stsname = "Delivery Gate Out";
                            }
                            $locname = "";
                            if ($sres->latitude != "") {
                                $locname = getLocationName($sres->latitude, $sres->longitude);
                            }
                            $data["stops"][] = [
                                "datetime" => $sres->createdon,
                                "status" => $stsname,
                                "truck_no" => $sres->register_number,
                                "driver" => $sres->name,
                                "location" => $locname
                            ];
                        }
                    }
                    $html = $this->load->view('settings/bulkepod', $data, true);
                    $chk = $this->m_pdf->pdf->WriteHTML($html);
                    $chk = $this->m_pdf->pdf->Output($epodpath, "F");
                    $unique_id = "RL" . $order_id . "." . date("Ymd") . "." . date("his");
                    $pagescnt = $this->m_pdf->pdf->pages;
                    $pages = count($pagescnt);
                    if ($createdsource == 5) { /* SALog JPL*/
                        if ($cmp == "") {
                            $cmp = $company_code;
                        }
                        if ($brn == "") {
                            $brn = $branch_code;
                        }
                        $countrycode = substr($company_code, 0, -2);
                        $randomstr = RandomString::generate(10);
                        $jplData = [
                            "country" => $cmp,
                            "branch" => $brn,
                            "order_id" => $order_id,
                            "time" => date("hi"),
                            "unique_id" => $unique_id,
                            "date" => date("d.m.Y"),
                            "pages" => $pages,
                            "xsr" => $refvalue,
                            "sd" => $orderDepartmentCode,
                            "bn" => $bn,
                            "inn" => $inn,
                            "iv" => $iv,
                            "dq" => $dq,
                            "custcid" => $custcid,
                            "custcode" => $custcode,
                            "countrycode" => $countrycode,
                            "randomstr" => $randomstr,
                            "doctype" => 746
                        ];
                        $jplFilePath = $this->saveSalogJPF($jplData);
                        $storeftipjpl = $this->uploadSalogKNFile($jplFilePath);
                        $storeftippdf = $this->uploadSalogKNFile($epodpath);
                    } else {
                        /*send ePOD to KNLogin*/
                        $jplData = [
                            "country" => substr($company_code, 0, -2),
                            "branch" => substr($branch_code, 2),
                            "order_id" => $order_id,
                            "time" => date("hi"),
                            "unique_id" => $unique_id,
                            "date" => date("d.m.Y"),
                            "pages" => $pages
                        ];
                        $jplFilePath = $this->sendpodtoknservice->saveJPF($jplData);
                        $this->sendpodtoknservice->uploadKNFile($jplFilePath);
                        $this->sendpodtoknservice->uploadKNFile($epodpath);

                        $data['mailtype'] = "ePOD";
                        if ($refvalue != "") {
                            $newsub = $refvalue . "#746#" . $iofeof;
                            $sub .= $chkref . ":" . $refvalue . "#746#" . $iofeof . "";
                            $chkparty = "SELECT emailid,party_name FROM tb_contact_notifys WHERE status=1 AND (pod_note=1 OR all_note=1) GROUP BY emailid";
                            $query = $this->db->query($chkparty);
                            if ($query->num_rows() > 0) {
                                foreach ($query->result() as $pmails) {
                                    $ccmail[] = $pmails->emailid;
                                }
                            }
                        }
                        if ($newsub == "") {
                            $newsub = $sub;
                        }
                        $this->email->from('svkonekt@kuehne-nagel.com', 'Svkonekt');
                        $this->email->to($receivemail, $receivename);
                        if (!empty($ccmail)) {
                            $ccmail = array_unique($ccmail);
                            $cc_mail = implode(", ", $ccmail);
                            $cc_mail = '"' . $cc_mail . '"';
                            $this->email->cc($cc_mail);
                        }
                        $this->email->subject($newsub);
                        $this->email->set_mailtype("html");
                        $body = $this->load->view('mail_forms/deliveredshipment', $data, true);
                        $fileName = "RL" . $order_id . ".pdf";
                        $epodpath = sprintf('%s/assets/trippods/%s', FCPATH, $fileName);
                        $this->email->message($body);
                        $this->email->attach($epodpath);

                        if(!$this->email->send()){
                            log_message("error",$this->email->print_debugger());
                        }

                        $this->email->clear(true);
                    }
                }
            }
        }
    }

}
