<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class ELOGOTMSTSRWB extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(['log', 'user_language','user']);
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }

        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }

        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Pragma: no-cache');
        self::setBrowserLang($this);
    }
    private static function setBrowserLang(CI_Controller $CI): void
    {
        $clientLangHeader = $CI->input->get_request_header('Accept-Language');
        log_info('Client browser lang_headers ' . json_encode($clientLangHeader, JSON_PRETTY_PRINT));
        $detectedBrowserLang = browsersLanguageDetection($clientLangHeader);
        log_info('final Lang to returned :: ' . $detectedBrowserLang);
        if (!$CI->session->has_userdata('site_lang')) {
            $CI->session->set_userdata('site_lang', $detectedBrowserLang);
        }
    }
    public function index(): void
    {
        $orderId = $this->input->get('id');
        if ($orderId) {
            $parts = explode('.', $orderId);
            if (count($parts) > 0) {
                $domain = $parts[0];
                $usernamePassword = $this->db->select("url,username, password")->from("int_cred")->where(["domain" => $domain, "object" => "Cloud_Order"])->limit(1)->get();
                log_message('error', 'Num Rows: ' . $usernamePassword->num_rows());
                if ($usernamePassword->num_rows() > 0) {
                    $row = $usernamePassword->row();
                    $otmUrl = $row->url;
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                    

                }
            } else {
                log_message("error", "No dot found in the orderId.");
            }
            //log_message("error", "orderId:".$orderId);
        $url = $otmUrl. ($orderId);
        
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic ' . base64_encode($otmUserName . ':' . $otmPassword)
            ),
        ));
        $response = curl_exec($curl);
        
        curl_close($curl);
        if ($response === false || !($data = json_decode($response, true))) {
            $this->session->set_flashdata('error', 'Failed to fetch data from API');
        } else {
            $this->session->set_userdata('api_response', $data);
            if (isset($data['OrderRelease'])) {
                $statusValues = [];
                if (isset($data['OrderRelease']['orderReleaseStatus'])) {
                    foreach ($data['OrderRelease']['orderReleaseStatus'] as $status) {
                        $statusValue = explode(".", $status['orderReleaseStatusBeanData']['statusValueGid']);
                        $statusValues[] = end($statusValue);
                    }
                    $data['statusValues'] = $statusValues;
                    $this->session->set_userdata('statusValues', $statusValues);
                }
            }
            $this->load->view('ELOGOTMSTSRWB', $data);
        }
        } else {
            log_message("error", "No orderId provided.");
            $this->load->view('ELOGOTMSTSRWB', true);
        }
    }
    
    public function fetchDataFromAPI() : void
    {
        $input = $this->input->get('orderId');
       
        $orderId = null;
        if (strpos($input, 'http') === 0 || strpos($input, 'https') === 0) {
            $urlParts = parse_url($input);
            parse_str($urlParts['query'], $queryParams);
            $orderId = $queryParams['id'] ?? null;
            $baseUrl = $urlParts['scheme'] . '://' . $urlParts['host'] . $urlParts['path'];
            $url = $baseUrl . '?id=' . urlencode($orderId);
            log_message("error", "Parsed URL from input: " . $url);
        } else {
            $orderId = $input;
            $url =  OTM_RELEASEXID_URL. ($orderId);
            log_message("error", " URL for direct orderId: " . $url);
        }
        
        
    
        if ($orderId) {
            log_message("error", "orderId: " . $orderId);
            $parts = explode('.', $orderId);
            log_message("error", "parts: " . json_encode($parts));
            log_message("error", "count: " . count($parts));
            if (count($parts) > 1) {
                $domain = implode('/', array_slice($parts, 0, -1));
                $orderIdPart = $parts[count($parts) - 1];
                log_message("error", "domain: " . $domain);
                 log_message("error", " orderIdPart: " . $orderIdPart);
                $usernamePassword = $this->db->select("username, password")->from("int_cred")->where(["domain" => $domain, "object" => "Cloud_Order"])->limit(1)->get();
                
                if ($usernamePassword->num_rows() > 0) {
                    $row = $usernamePassword->row();
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
            

                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                } else {
                    log_message("error", "No credentials found for domain: " . $domain);
                    return;
                }
            } else {
                log_message("error", "Invalid orderId format.");
                return;
            }
           
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic ' . base64_encode($otmUserName . ':' . $otmPassword)
                ),
            ));
    
            $response = curl_exec($curl);
            $err = curl_error($curl);
            
            curl_close($curl);
            
            
            
    
            if ($response === false || !($data = json_decode($response, true))) {
                
                $this->session->set_flashdata('error', 'Failed to fetch data from API');
                
            } else {
                $this->session->set_userdata('api_response', $data);
               $sourceLocation = null;
                $sourceLink = $data['sourceLocation']['links'][1]['href'] ?? null; // canonical link

                if ($sourceLink) {
                    $ch = curl_init();
                    curl_setopt_array($ch, [
                        CURLOPT_URL => $sourceLink,
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_HTTPHEADER => [
                            'Authorization: Basic ' . base64_encode("$otmUserName:$otmPassword")
                        ],
                    ]);
                    $locResponse = curl_exec($ch);
                    curl_close($ch);

                    $locData = json_decode($locResponse, true);
                    if ($locData) {
                        $sourceLocation = $locData['locationName'] ?? '';
                        if (!empty($locData['city'])) {
                            $sourceLocation .= ', ' . $locData['city'];
                        }
                    }
                }

                    $destLocation = '';
                    $destLink = $data['destinationLocation']['links'][1]['href'] ?? null;
                 if ($destLink) {
                    $ch = curl_init();
                    curl_setopt_array($ch, [
                        CURLOPT_URL => $destLink,
                        CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_HTTPHEADER => ['Authorization: Basic ' . base64_encode("$otmUserName:$otmPassword")],
                        ]);
                        $destResponse = curl_exec($ch);
                        curl_close($ch);

                        $destData = json_decode($destResponse, true);
                        if ($destData) {
                            $destLocation = $destData['locationName'] ?? '';
                            if (!empty($destData['city'])) $destLocation .= ', ' . $destData['city'];
                        }
                    }


                if (isset($data['OrderRelease'])) {
                    $statusValues = [];
                    if (isset($data['OrderRelease']['orderReleaseStatus'])) {
                        foreach ($data['OrderRelease']['orderReleaseStatus'] as $status) {
                            $statusValue = explode(".", $status['orderReleaseStatusBeanData']['statusValueGid']);
                            $statusValues[] = end($statusValue);
                        }
                        $data['statusValues'] = $statusValues;
                        $this->session->set_userdata('statusValues', $statusValues);
                    }
                }
                
                    echo json_encode([
                        'orderData' => $data,
                        'sourceLocation' => $sourceLocation,
                        'destLocation' => $destLocation
                    ]);
    
            }
                } else {
                    log_message("error", "No orderId provided.");
                }
    }
    public function generateStatusXml() : void 
    {
       
        $requestData = json_decode(file_get_contents('php://input'), true);
       
        // Extract required data from $requestData
        if (empty($requestData['status'])) {
       
        echo "No status provided";
        return;
        }
        $status = $requestData['status'];
        
        $statusCodes =['ORG_GATEIN' => '0490','ORG_PICKUP' => '0500','ORG_GATEOUT' =>'1080','DEST_GATEIN' => '4300','DEST_DELIVERED' => '3000','DEST_GATEOUT' =>'2320'];
        $statusXid = isset($statusCodes[$status]) ? $statusCodes[$status] : '';
        
        $api_response = $_SESSION['api_response'];
        $domainName = $api_response['domainName'] ?? '';
        $orderReleaseXid = $api_response['orderReleaseXid'] ?? '';
        // $orderReleaseGid = $orderRelease['orderReleaseGid'] ?? '';
        $orderReleaseTypeGid = $api_response['orderReleaseTypeGid'] ?? ''; 
        if (!empty($api_response)) {
            // Order release exists
            $orderReleaseXid = $api_response['orderReleaseXid'];
        } else {
            // Handle non-existent case
            log_message('error', "Order release does NOT exist: $orderReleaseXid");
        }
       
        // if (isset($api_response['OrderRelease'])) {
        //     $orderRelease = $api_response['OrderRelease'];
        //     log_message('error', 'api_response: ' . print_r($api_response, true));

            // if (!empty($orderRelease['domainName'])) {
            //  log_message('error', 'OrderRelease domainName: ' . $orderRelease['domainName']);
                $parts = explode('/', $domainName);
                $rootDomain = $parts[0];
                $usernamePassword = $this->db->select("url, username, password")->from("int_cred")->where(["domain" =>  $domainName, "object" => "Cloud_Event"])->limit(1)->get();
                log_message('error', 'SQL Query: ' . $this->db->last_query());
                if($usernamePassword->num_rows() > 0 ) {
                    $row = $usernamePassword->row();
                    log_message('error', 'Fetched credentials: ' . print_r($row, true));
                    $otmUrl = $row->url;
                    $otmUserName = $row->username;
                    $otmPassword = $row->password;
                    //$otmPassword = decryptCryptoLibPassword($otmPassword);
                }
            // }   
        // }
        $date =  Date("Ymdhis");
        $timeZone = getTimeZoneFromIpAddress();
        $timeZoneObj = new DateTimeZone($timeZone);
        $now = new DateTime("now", $timeZoneObj);
        $offset = $now->getOffset() / 3600; // Get offset in hours
        // Format offset to ±HH:MM
        $offsetString = sprintf("%+03d:00", $offset);
        $xml = '<otm:Transmission xmlns:otm="http://xmlns.oracle.com/apps/otm/transmission/v6.4" xmlns:gtm="http://xmlns.oracle.com/apps/gtm/transmission/v6.4">';
        $xml .= '<otm:TransmissionHeader>';
        $xml .= '<otm:Version>6.5.2.1-20231208</otm:Version>';
        $xml .= '<otm:TransmissionCreateDt>';
        $xml .= '<otm:GLogDate>' . $date . '</otm:GLogDate>';
        $xml .= '<otm:TZId>' . $timeZone . '</otm:TZId>';
        $xml .= '<otm:TZOffset>' . $offsetString . '</otm:TZOffset>';
        $xml .= '</otm:TransmissionCreateDt>';
        $xml .= '<otm:TransactionCount>1</otm:TransactionCount>';
        $xml .= '<otm:SenderHostName>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</otm:SenderHostName>';
        $xml .= '<otm:SenderSystemID>https://otmgtm-test-knotmc.otmgtm.eu-frankfurt-1.ocs.oraclecloud.com</otm:SenderSystemID>';
        $xml .= '<otm:UserName>'. $otmUserName .'</otm:UserName>';
        $xml .= '<otm:Password>'. $otmPassword .'</otm:Password>';
        $xml .= '<otm:SenderTransmissionNo>' . 'E' . $date . '</otm:SenderTransmissionNo>';
        $xml .= '<otm:ReferenceTransmissionNo>1</otm:ReferenceTransmissionNo>';
        $xml .= '</otm:TransmissionHeader>';
        $xml .= '<otm:TransmissionBody>';
        $xml .= '<otm:GLogXMLElement>';
        $xml .= '<otm:TransactionHeader>';
        $xml .= '<otm:SenderTransactionId>' . 'E' . $date . '</otm:SenderTransactionId>';
        $xml .= '</otm:TransactionHeader>';
        $xml .= '<otm:TransOrderStatus>';
        $xml .= '<otm:ReleaseGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $domainName . '</otm:DomainName>';
        $xml .= '<otm:Xid>' . $orderReleaseXid . '</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:ReleaseGid>';
        $xml .= '<otm:StatusLevel>ORDER</otm:StatusLevel>';
        $xml .= '<otm:OrderRefnum>';
        $xml .= '<otm:OrderRefnumQualifierGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>GLOG</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:OrderRefnumQualifierGid>';
        $xml .= '<otm:OrderRefnumValue>' . $orderReleaseTypeGid . '</otm:OrderRefnumValue>';
        $xml .= '</otm:OrderRefnum>';
        $xml .= '<otm:StatusCodeGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $rootDomain . '</otm:DomainName>';
        $xml .= '<otm:Xid>' . $statusXid .'</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:StatusCodeGid>';
        $xml .= '<otm:StatusReasonCodeGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:DomainName>' . $rootDomain . '</otm:DomainName>';
        $xml .= '<otm:Xid>1000</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:StatusReasonCodeGid>';
        $xml .= '<otm:TimeZoneGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>Local</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:TimeZoneGid>';
        $xml .= '<otm:EventDt>';
        $xml .= '<otm:GLogDate>' . $date . '</otm:GLogDate>';
        $xml .= '<otm:TZId>' . $timeZone . '</otm:TZId>';
        $xml .= '<otm:TZOffset>' . $offsetString . '</otm:TZOffset>';
        $xml .= '</otm:EventDt>';
        $xml .= '<otm:ResponsiblePartyGid>';
        $xml .= '<otm:Gid>';
        $xml .= '<otm:Xid>CARRIER</otm:Xid>';
        $xml .= '</otm:Gid>';
        $xml .= '</otm:ResponsiblePartyGid>';
        $xml .= '<otm:ReportingUser>APAC/DEMOA.BSCYADAV</otm:ReportingUser>';
        $xml .= '</otm:TransOrderStatus>';
        $xml .= '</otm:GLogXMLElement>';
        $xml .= '</otm:TransmissionBody>';
        $xml .= '</otm:Transmission>';
      
            
        $ch = curl_init();
         log_message("error", "otmUrl.".$otmUrl);
        curl_setopt($ch, CURLOPT_URL, $otmUrl);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $xml);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: text/xml'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, $otmUserName . ':' . $otmPassword);
        $response = curl_exec($ch);
        if ($response === false) {
            log_message('error', 'cURL error: ' . curl_error($ch));
        } else {
            log_message('error', 'Response from server: ' . $response);
        }
        curl_close($ch);
        echo  $response;
        
    }
    
    function encryptCryptoLibPassword($pwd="CHANGEME0125")
    {
        require_once './application/third_party/cryptolib-php/src/CryptoLib.php';
        $encryption = new \MrShan0\CryptoLib\CryptoLib();
        $pwd        = $encryption->encryptPlainTextWithRandomIV($pwd, ENCRYPTION_KEY);
        echo $pwd;
    }
}
