<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Editransactions extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("Editransactionsmodel");
        if (!checkUrlAccessForUser('EDITRANSACTIONS')) {
            redirect("Forbiddenaccess");
        }
    }
    /**
     * Get EDI transactions list
     * @change    Australia
     * @return    array (EDI transactions list)
     */
    public function index()
    {
        $data = $whr = $wher = $getdata = $get_data = $res_data = $object_types = array();
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');

        $data["page_title"] = "EDI Transaction";
        $data["sub_title"] = $this->lang->line('general_search');
        $data["services"] = array();
        $post = $this->input->post();
        $whr = array();
        if (!empty($post)) {

            if (isset($post['obj_type']) && $post['obj_type'] != "") {
                $wher['ee.edi_id'] = (int) $post['obj_type'];
            }
            if (isset($post['status']) && $post['status'] != "") {
                $wher['ee.status'] = (int) $post['status'];
            }
            if (isset($post['txn_obj_id']) && $post['txn_obj_id'] != "") {
                $whr['ee.txn_obj_id'] = (string) $post['txn_obj_id'];
            }

            if (isset($post['from_date']) && $post['from_date'] != "") {
                $fromdate1 = date('Y-m-d', strtotime($post['from_date']));
                $wher["ee.created_on >="] = $fromdate1;
            }
            if (isset($post['to_date']) && $post['to_date'] != "") {
                $todate1 = date('Y-m-d', strtotime($post['to_date']));
                $wher["ee.created_on <="] = $todate1 . ' 23:59:59';
            }
            $country_userids    = $this->session->userdata("country_user_ids");
            $getdata = $this->Editransactionsmodel->getedidata($wher, $whr, $country_userids, $company_code, $user_id);

        }

        $object_types = [];
        if ("AUKN" === $company_code) {
            $obj_type_whr = ['company_code' => $company_code, 'status' => 1];
            $object_types = $this->Editransactionsmodel->getobjectnames($obj_type_whr);
        }elseif ("RUKN" === $company_code) {
            $ruEdiNames = ['BiteTransit','Vozovoz','RUExpress','Skif'];
            $object_types =  $this->common->gettbldata_where_in(['status' => 1], ["col" => "edi_name", "arr" => $ruEdiNames], 'id,edi_name', 'tb_edi_types');
        } else {
            $object_types = $this->common->gettbldata(['status' => 1], 'id,edi_name', 'tb_edi_types', 10000, 0);
        }

        $data['object_types'] = $object_types ?? [];
        $data['getdata'] = $getdata;
        $data['company_code'] = $company_code;

        $this->newtemplate->dashboard("editransactions/index", $data);
    }


    public function getbounddata()
    {
        $post = $this->input->post();
        $id = isset($post['id']) ? $post['id'] : 0;
        $type = isset($post['type']) ? $post['type'] : 0;
        $select = ($type == 1) ? 'edi_request' : 'edi_response';
        $where = array(
            'id' => $id
        );
        $getdata = $this->common->gettblrowdata($where, $select, 'tb_etn_edi_transactions', 0, 0);
        echo $getdata[$select];
    }
}
