<?php defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');
class Employeeapi extends CI_Controller
{    
    public function __construct()
    {
        parent::__construct();
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400'); /*cache for 1 day*/
        }
        /* Access-Control headers are received during OPTIONS requests*/
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }

        }
        // decoding the json array
        $post = json_decode(file_get_contents("php://input"), true);
        //Codiginite helpers
        $this->load->helper('date');
        $this->load->model('cabmodel');
        $this->load->library('sendfirebase');
    }
    public function index()
    {
        //$this->load->view('welcome_message');
        echo "Welcome to Track247 Android services";
        //echo "getServices<br>";
        $data['user'] = "";
    }
    public function employeeLogin()
    {
        $response = [];
        $response = ["status" => 0, "data" => "Not Found"];
        if ($_POST) {
            $mobile = isset($_POST["mobile"]) ? $_POST["mobile"] : '';
            $pwd    = isset($_POST["password"]) ? $_POST["password"] : '';
            $gcm_id = isset($_POST["token"]) ? $_POST["token"] : '';
            if ($mobile != "" && $pwd != "") {
                $password = password_hash($pwd, PASSWORD_DEFAULT);
                $whr1     = ["phone" => $mobile, "password" => $_POST["password"], "status" => "1"];
                $sql      = $this->db->get_where("tb_employee", $whr1, 1, 0);
                //echo $this->db->last_query();
                $insdata = ["mobile" => $mobile, "password" => $_POST["password"], "status" => $sql->num_rows()];
                $res     = $this->db->insert("tb_employee_login_logs", $insdata);
                if ($sql->num_rows() > 0) {
                    $id = $sql->row()->id;
                    $this->db->where("id", $id)->update("tb_employee", ["gcm_id" => $gcm_id, "updatedon" => date("Y-m-d H:i:s")]);
                    $response = ["status" => 1, "data" => $sql->row_array()];
                } else {
                    $response = ["status" => 0, "data" => "Not Found"];
                }
            } else {
                $response = ["status" => 0, "data" => "Not Found"];
            }
        }
        echo json_encode($response);
    }
    public function updateGCM()
    {
        $response = [
            "status" => 0,
            "data"   => "Not Found",
        ];
        $emp_id = isset($_POST["emp_id"]) ? $_POST["emp_id"] : "";
        $token  = isset($_POST["token"]) ? $_POST["token"] : "";
        if ($emp_id != "" && $token != "") {
            $this->db->where("id", $emp_id)->update("tb_employee", ["gcm_id" => $token]);
            $response = [
                "status" => 1,
                "data"   => "Sucessfully Changed!",
            ];
        } else {
            $response = [
                "status" => 0,
                "data"   => "Invalid Input",
            ];
        }
        echo json_encode($response);
    }
    public function getShifts()
    {
        $response = [
            "status" => 0,
            "data"   => "Not Found",
        ];
        //print_r($_POST);
        if ($_POST) {
            $user_id = isset($_POST["user_id"]) ? $_POST["user_id"] : '';
            $id      = isset($_POST["id"]) ? $_POST["id"] : '';
            // log_message('error',"id:".$user_id);
            $ep = geteplacebyid($user_id);
            if ($id != "") {
                $res = $this->db->query("SELECT c.id as shft_id,c.empshift_start as stime,c.empshift_end as etime,a.shft_veh_id,a.priority,a.pickup_time,b.register_number,b.vehicle_id,c.trip_type,IFNULL((SELECT id FROM tb_trips WHERE vehicle_id=b.vehicle_id and shift_id=c.id AND status='1' ORDER BY id DESC LIMIT 1),'0') AS tstatus FROM tb_shft_veh_emp a INNER JOIN tb_shft_veh b ON a.shft_veh_id=b.id INNER JOIN tb_shifts c ON b.shft_id=c.id WHERE c.status=1 and a.status=1 and b.status=1 and c.user_id=$user_id and a.emp_id=$id");
                //echo $this->db->last_query();
                $result = [];
                $dt     = [];
                if ($res->num_rows() > 0) {
                    foreach ($res->result() as $rw) {
                        $chkinsts = $this->db->query("SELECT id,status from tb_emp_daily_status where shift_id=$rw->shft_id and emp_id=$id and shiftdate='" . date("Y-m-d") . "' LIMIT 1");
                        if ($chkinsts->num_rows() > 0) {
                            $sts = $chkinsts->row()->status;
                            if ($sts == 1) {
                                $dt = [
                                    'shft_id'         => $rw->shft_id,
                                    'stime'           => $rw->stime,
                                    'etime'           => $rw->etime,
                                    'shft_veh_id'     => $rw->shft_veh_id,
                                    'priority'        => $rw->priority,
                                    'pickup_time'     => $rw->pickup_time,
                                    'register_number' => $rw->register_number,
                                    'vehicle_id'      => $rw->vehicle_id,
                                    'trip_type'       => $rw->trip_type,
                                    'tstatus'         => $rw->tstatus,
                                ];
                                array_push($result, $dt);
                            }
                        } else {
                            $dt = [
                                'shft_id'         => $rw->shft_id,
                                'stime'           => $rw->stime,
                                'etime'           => $rw->etime,
                                'shft_veh_id'     => $rw->shft_veh_id,
                                'priority'        => $rw->priority,
                                'pickup_time'     => $rw->pickup_time,
                                'register_number' => $rw->register_number,
                                'vehicle_id'      => $rw->vehicle_id,
                                'trip_type'       => $rw->trip_type,
                                'tstatus'         => $rw->tstatus,
                            ];
                            array_push($result, $dt);
                        }
                    }
                }
                $res = [];
                if (count($result) > 0) {
                    foreach ($result as $d) {
                        /*print_r($d);
						exit;*/
                        $parse[4] = $parse[5] = "";
                        $splace   = getsplacebyvehfull($d["shft_id"], $d["vehicle_id"]);
                        if ($d["trip_type"] == 1) {
                            $d["eplace"] = isset($splace->splace) ? $splace->splace : '';
                            $d["elat"]   = isset($splace->plat) ? $splace->plat : '';
                            $d["elng"]   = isset($splace->plng) ? $splace->plng : '';
                            $d["splace"] = isset($ep) ? $ep : '';
                            $d["slat"]   = isset($parse[4]) ? $parse[4] : '';
                            $d["slng"]   = isset($parse[5]) ? $parse[5] : '';
                        } else
                        if ($d["trip_type"] == 0) {
                            $d["splace"] = isset($splace->splace) ? $splace->splace : '';
                            $d["slat"]   = isset($splace->plat) ? $splace->plat : '';
                            $d["slng"]   = isset($splace->plng) ? $splace->plng : '';
                            $d["eplace"] = isset($ep) ? $ep : '';
                            $d["elat"]   = isset($parse[4]) ? $parse[4] : '';
                            $d["elng"]   = isset($parse[5]) ? $parse[5] : '';
                        } else {
                            $d["splace"] = isset($splace->splace) ? $splace->splace : '';
                            $d["slat"]   = isset($splace->plat) ? $splace->plat : '';
                            $d["slng"]   = isset($splace->plng) ? $splace->plng : '';
                            $d["eplace"] = isset($ep) ? $ep : '';
                            $d["elat"]   = isset($parse[4]) ? $parse[4] : '';
                            $d["elng"]   = isset($parse[5]) ? $parse[5] : '';
                        }
                        $r             = distancemetrixship($d['slat'], $d['slng'], $d['elat'], $d['elng']);
                        $d['distance'] = $r['disttext'];
                        $d['duration'] = $r['duratext'];
                        $res[]         = $d;
                    }
                    $response = [
                        "status" => 1,
                        "data"   => $res,
                    ];
                } else {
                    $response = [
                        "status" => 0,
                        "data"   => "Not Found",
                    ];
                }
            } else {
                $response = [
                    "status" => 0,
                    "data"   => "Not Found!",
                ];
            }
        }
        echo json_encode($response);
    }
    public function getcabmaplink()
    {
        $response = ["status" => 0, "data" => "Not Found!"];
        if (isset($_POST)) {
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : '';
            if ($trip_id != "") {
                $trips = $ci->db->query("select t.id as tripid,t.vehicle_id,d.id as driverid,d.name,d.contact_num from tb_trips t,tb_truck_drivers d where t.driver_id=d.id and t.id=$trip_id and t.status=1 LIMIT 1");
                if ($trips->num_rows() > 0) {
                    $t     = $trips->row();
                    $link1 = base_url() . "cab/track/" . encryptIt($t->driverid, $t->tripid);
                    /*$this->load->library('googleshortener');
					$link=$this->googleshortener->shorten($link1);*/
                    $response = ["status" => 1, "data" => $link1];
                }
            }
        }
        echo json_encode($response);
    }
    public function getabsentreason()
    {
        $response = ["status" => 0, "data" => "Something went wrong!"];
        $curdate  = date("Y-m-d H:i:s");
        if (isset($_POST)) {
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : '';
            $emp_id  = isset($_POST['emp_id']) ? $_POST['emp_id'] : '';
            $reason  = isset($_POST['reason']) ? $_POST['reason'] : '';
            if ($trip_id != "" && $emp_id != "") {
                $trips = $this->db->query("select d.id from tb_trips t,tb_trip_employee d where t.id=d.trip_id AND t.id=$trip_id AND d.employee_id=$emp_id AND t.status=1 LIMIT 1");
                /*log_message("error",$this->db->last_query());*/
                if ($trips->num_rows() > 0) {
                    $t      = $trips->row();
                    $setarr = ["absent_reason" => $reason, "updated_on" => $curdate, "status" => "0"];
                    $whrarr = ["id" => $t->id, "employee_id" => $emp_id];
                    $res    = $this->db->set($setarr)->where($whrarr)->update("tb_trip_employee");
                } else {
                    $data = ["employee_id" => $emp_id, "trip_id" => $trip_id, "status" => "0", "stime" => $curdate, "check_in" => $curdate, "created_on" => $curdate, "absent_reason" => $reason];
                    $this->db->insert("tb_trip_employee", $data);
                }
                $response = ["status" => 1, "data" => "Status Updated Successfully!"];
            }
        }
        echo json_encode($response);
    }
    public function getLiveLocation()
    {
        /*$_POST = 307;*/
        $response = ["status" => 0, "data" => "Something went wrong!"];
        if (isset($_POST)) {
            $trip_id = isset($_POST['trip']) ? $_POST['trip'] : '';
            $emp_id  = isset($_POST['emp_id']) ? $_POST['emp_id'] : '';
            if ($trip_id != "" && $emp_id != "") {
                $this->db->select("l.mobileimei,l.timestamp,l.latitude,l.longitude,l.bearing,t.vehicle_id,d.contact_num,d.name,IFNULL((SELECT status FROM tb_trip_employee WHERE trip_id=t.id and employee_id='$emp_id' LIMIT 1),2) as attend");
                $this->db->from("tb_rtdrive_locations l");
                $this->db->join("tb_trips t", "l.mobileimei=t.start_imei", "INNER");
                $this->db->join("tb_truck_drivers d", "t.driver_id=d.id", "");
                $this->db->where("t.id", $trip_id);
                $this->db->order_by("l.timestamp", "DESC");
                $this->db->limit(1);
                $locs = $this->db->get();
                if ($locs->num_rows() > 0) {
                    $arr      = $locs->row_array();
                    $response = ["status" => 1, "data" => $arr];
                }
            }
        }
        echo json_encode($response);
    }
    public function getempsosdata()
    {
        $curdate  = date("Y-m-d H:i:s");
        $response = ["status" => 0, "data" => "Something went wrong!"];
        if (isset($_POST)) {
            //log_message('error',json_encode($_POST));
            $trip_id = isset($_POST['trip_id']) ? $_POST['trip_id'] : '';
            $emp_id  = isset($_POST['emp_id']) ? $_POST['emp_id'] : '';
            $reason  = isset($_POST['reason']) ? $_POST['reason'] : '';
            $vehicle = isset($_POST['vehicle']) ? $_POST['vehicle'] : '';
            $lat     = isset($_POST['lat']) ? $_POST['lat'] : '';
            $lng     = isset($_POST['lng']) ? $_POST['lng'] : '';
            if ($trip_id != "" && $emp_id != "") {
                $curlocation = "";
                if ($lat != "" && $lng != "") {
                    $data['curlocation'] = getCabLocationName($lat, $lng);
                }
                $uid = 0;
                // send sos message
                $driverdetails = $this->db->query("select d.name,d.contact_num,d.user_id from tb_trips t,tb_truck_drivers d where t.driver_id=d.id AND t.id='$trip_id' ORDER BY t.id DESC LIMIT 1");
                $empdetails    = $this->db->query("select e.name as empname,e.phone,e.user_id,t.splace,t.eplace,s.empshift_start stime,s.empshift_end as etime from tb_shifts s,tb_employee e,tb_shft_veh sv,tb_shft_veh_emp ve,tb_trips t where s.id=sv.shft_id and sv.id=ve.shft_veh_id AND e.id='$emp_id' and t.id=$trip_id ORDER BY e.id DESC LIMIT 1");
                /*log_message("error",$this->db->last_query());*/
                if ($empdetails->num_rows() > 0 && $driverdetails->num_rows() > 0) {
                    $edetails = $data['edetails'] = $empdetails->row();
                    $ddetails = $data['ddetails'] = $driverdetails->row();
                    $uid      = $ddetails->user_id;
                    $this->load->library('smsnotifier');
                    $message    = "SOS Alert from Employee:" . $edetails->empname . "(" . $edetails->phone . ") on " . $curdate . " Driver :" . $ddetails->name . "(" . $ddetails->contact_num . " , " . $vehicle . ") Alert:" . $reason . "";
                    $soscontact = $this->db->get_where("tb_emp_sos_contacts", ["emp_id" => $emp_id], 1, 0);
                    $mobile     = "";
                    if ($soscontact->num_rows() > 0) {
                        if ($soscontact->row()->contact_num1 != "") {
                            $mobile  = $soscontact->row()->contact_num1;
                            $smsdata = ['mobile' => $mobile, 'module' => "SOS Alert", 'user_id' => 0, 'message' => $message, 'trip_id' => $trip_id, 'emp_id' => $emp_id, 'latitude' => $lat, 'longitude' => $lng, 'register_number' => $vehicle, 'alert_reason' => $reason, 'status' => 1, 'createdon' => $curdate];
                            $sendack = $this->smsnotifier->driverarrivalsms($smsdata);
                        }
                        if ($soscontact->row()->contact_num2 != "") {
                            $mobile  = $soscontact->row()->contact_num2;
                            $smsdata = ['mobile' => $mobile, 'module' => "SOS Alert", 'user_id' => 0, 'message' => $message, 'trip_id' => $trip_id, 'emp_id' => $emp_id, 'latitude' => $lat, 'longitude' => $lng, 'register_number' => $vehicle, 'alert_reason' => $reason, 'status' => 1, 'createdon' => $curdate];
                            $sendack = $this->smsnotifier->driverarrivalsms($smsdata);
                        }
                        if ($soscontact->row()->contact_num3 != "") {
                            $mobile  = $soscontact->row()->contact_num3;
                            $smsdata = ['mobile' => $mobile, 'module' => "SOS Alert", 'user_id' => 0, 'message' => $message, 'trip_id' => $trip_id, 'emp_id' => $emp_id, 'latitude' => $lat, 'longitude' => $lng, 'register_number' => $vehicle, 'alert_reason' => $reason, 'status' => 1, 'createdon' => $curdate];
                            $sendack = $this->smsnotifier->driverarrivalsms($smsdata);
                        }
                    }
                    if ($mobile == "") {
                        $custid  = $edetails->user_id;
                        $u       = $this->db->select('mobile_no')->get_where("tb_users", ["id" => $custid], 1, 0);
                        $mobile  = $u->row()->mobile_no;
                        $smsdata = ['mobile' => $mobile, 'module' => "SOS Alert", 'user_id' => 0, 'message' => $message, 'trip_id' => $trip_id, 'emp_id' => $emp_id, 'latitude' => $lat, 'longitude' => $lng, 'register_number' => $vehicle, 'alert_reason' => $reason, 'status' => 1, 'createdon' => $curdate];
                        $sendack = $this->smsnotifier->driverarrivalsms($smsdata);
                    }
                    /*$smsdata=array();*/
                    $this->load->library('email');
                    /*$getusermail = $this->db->select("name,emailid")->get_where("tb_users",array("id"=>$uid,"emailid !="=>""),1,0);
					if($getusermail->num_rows() > 0){
						$receivemail = $getusermail->row()->emailid;
						$receivename = $getusermail->row()->name;
					}else{
						$receivemail = 'naresh.p@inspiredge.in';
						$receivename = 'Naresh P';
					}
					$this->email->to($receivemail,$receivename);*/
                    $data['page_title'] = "SOS Alert";
                    $data['vehicle']    = $vehicle;
                    $data['reason']     = isset($reason) ? $reason : "";
                    $sosmsg             = "SOS Alert from Employee:" . $edetails->empname . " on " . $curdate;
                    /*if($uid=='18145')
				    	$this->email->to('naresh.p@inspiredge.in','Naresh P');
				    else if($uid=='2')*/
                    $getusermail = $this->db->select("name,emailid")->get_where("tb_users", ["id" => $uid], 1, 0);
                    if ($getusermail->num_rows() > 0) {
                        $receivemail = $getusermail->row()->emailid;
                        $receivename = $getusermail->row()->name;
                    } /*else{
						$receivemail = 'kambhamramachandra@gmail.com';
						$receivename = 'RCREDDY K';
					}*/
                    $this->email->to($receivemail, $receivename);
                    $this->email->from('svkonekt@kuehne-nagel.com', 'Svkonekt');
                    $this->email->subject($sosmsg);
                    $this->email->set_mailtype('html');
                    $body = $this->load->view('mail_forms/sosalertmail', $data, true);
                    $this->email->message($body);
                    $this->email->send();
                }
                $response = ["status" => 1, "data" => "Status sent!"];
            }
        }
        echo json_encode($response);
    }
    public function getreasons()
    {
        $response = ["status" => 0, "data" => "Something went wrong!"];
        $data     = $this->db->select('id,name')->get_where('tb_emp_absent_reason', ['status' => 1]);
        if ($data->num_rows() > 0) {
            $response = ["status" => 1, "data" => $data->result_array()];
        }
        echo json_encode($response);
    }
    public function testmsg()
    {
        //for sending single user firebse message
        echo $this->sendfirebase->sendSinglePush(["title" => "Test", "message" => "Mesage", "emp_id" => 71, 'type' => 'Customer']);
        //for sending all trip employee firebse message
        echo $this->sendfirebase->sendMultiplePush(["title" => "Test", "message" => "Mesage", "trip_id" => 546, 'type' => 'Customer']);
    }
    public function getNotifications()
    {
        $response = ["status" => 0, "data" => "Something went wrong!"];
        $emp_id   = isset($_POST['id']) ? $_POST['id'] : '';
        if ($emp_id != "") {
            $sql = $this->db->where(["emp_id" => $emp_id, "status" => "1"])->order_by("created_on", "desc")->get("tb_firebase_notifications");
            if ($sql->num_rows() > 0) {
                $response = ["status" => 1, "data" => $sql->result_array()];
            } else {
                $response = ["status" => 0, "data" => "No data Found!"];
            }
        }
        echo json_encode($response);
    }
    public function setNotificationStatus()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '';
        if ($id != "") {
            $this->db->query("update tb_firebase_notifications set status='0' where id=$id");
        }
    }
    public function setAllNotificationStatus()
    {
        $user_id = isset($_POST['id']) ? $_POST['id'] : '';
        if ($user_id != "") {
            $this->db->query("update tb_firebase_notifications set status='0' where emp_id=$user_id");
        }
    }
    public function setMyStatus()
    {
        $response    = ["status" => 0, "data" => "Something went wrong!"];
        $emp_id      = isset($_POST['emp_id']) ? $_POST['emp_id'] : '';
        $shft_veh_id = isset($_POST['shft_veh_id']) ? $_POST['shft_veh_id'] : '';
        $status      = isset($_POST['status']) ? $_POST['status'] : '';
        if ($emp_id != "" && $shft_veh_id != "") {
            $sql = $this->db->query("select e.id from tb_emp_daily_status e,tb_shft_veh v where v.status='1' and v.id=$shft_veh_id and e.shift_id=v.shft_id and e.emp_id=$emp_id and shiftdate='" . date("Y-m-d") . "'");
            if ($sql->num_rows() > 0) {
                $id = $sql->row()->id;
                $this->db->query("update tb_emp_daily_status set status='0',absent_reason='$status',updatedon='" . date("Y-m-d H:i:s") . "' where id=$id");
            } else {
                $this->db->query("update tb_shft_veh_emp set status=0 where shft_veh_id=$shft_veh_id and emp_id=$emp_id and status=1");
            }
            //log_message("error",$this->db->last_query());
            $response = ["status" => 1, "data" => "Updated Sucessfully!"];
        } else {
            $response = ["status" => 0, "data" => "Inavlid Input!"];
        }
        echo json_encode($response);
    }
}
