<?php if (!defined('BASEPATH')) {

	exit('No direct script access allowed');

}
class Etmreport extends CI_Controller {
	public function __construct() {
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
        if (!checkUrlAccessForUser('ETMREPORT')) {
            redirect("Forbiddenaccess");
        }
	}
	public function index(){

		$data["page_title"]="Main Reports";
		$data["sub_title"]="Reports";
		$data["from"]=date("Y-m-d",strtotime("-7 day", strtotime(date("Y-m-d"))));
		$data["to"]=date("Y-m-d");
		$uid = $this->session->userdata("user_id");
		$data["vehicle"]=array();
		$sql1 = "";
		if($this->session->userdata("business_type")=="Carrier"){
            $uid = $this->session->userdata("id");
            $sql="select sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.vendor_id=".$uid." ";
			$wsql="select CONCAT(YEAR(ts.createdon), '/', WEEK(ts.createdon)) AS week_name,
	       YEAR(ts.createdon) as wy, WEEK(ts.createdon) as ww,sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.vendor_id=".$uid." ";
	       	$msql="select CONCAT(YEAR(ts.createdon), '/', MONTH(ts.createdon)) AS month_name,
	       YEAR(ts.createdon) as wy, MONTH(ts.createdon) as ww,sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.vendor_id=".$uid." ";
        }else {
            $sql="select sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.user_id=".$uid." ";
			$wsql="select CONCAT(YEAR(ts.createdon), '/', WEEK(ts.createdon)) AS week_name,
	       YEAR(ts.createdon) as wy, WEEK(ts.createdon) as ww,sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.user_id=".$uid." ";
	       	$msql="select CONCAT(YEAR(ts.createdon), '/', MONTH(ts.createdon)) AS month_name,
	       YEAR(ts.createdon) as wy, MONTH(ts.createdon) as ww,sum(ts.trip_distance) as distance,td.register_number,DATE(ts.createdon) as date from tb_trip_summary ts,tb_trucks_data td where ts.user_id=".$uid." ";
        }

		if($_GET){
			$data["from"]=$_GET["from"];
			$data["to"]=$_GET["to"];
			$data["vehicle"]=isset($_GET["vehicle"])?$_GET["vehicle"]:array();
			if(strlen($data["from"])>0){
				$sql1.="and DATE(ts.createdon)>='".date("Y-m-d",strtotime($data["from"]))."' ";
			}
			if(strlen($data["to"])>0){
				$sql1.="and DATE(ts.createdon)<='".date("Y-m-d",strtotime($data["to"]))."' ";
			}
			if(count($data["vehicle"])>0){
				$d=implode(",",$data['vehicle']);
				$sql1.="and ts.vehicle_id in (".$d.")"." ";
			}
		}else{
			$sql1.="and DATE(ts.createdon)>='".date("Y-m-d",strtotime($data["from"]))."' ";
			$sql1.="and DATE(ts.createdon)<='".date("Y-m-d",strtotime($data["to"]))."' ";
		}
		$sql12 ="and td.id=ts.vehicle_id GROUP BY DATE(ts.createdon),vehicle_id ORDER BY ts.id DESC";
		$sqlw1 ="and td.id=ts.vehicle_id GROUP BY week_name,vehicle_id";
		$sqlm1 ="and td.id=ts.vehicle_id GROUP BY month_name,vehicle_id";
		$sql .= $sql1;
		$sql .= $sql12;
		/*echo $sql;*/
		$data["vehicles"]=$this->db->where("register_number!='DUMMYVEHICLE'")->where("vendor_id",$uid)->where("status","Active")->get("tb_trucks_data");
		/*$data["reports"]=$this->db->query($sql);*/
		$data["vehicles"]=$this->db->where("register_number!='DUMMYVEHICLE'")->where("vendor_id",$uid)->get("tb_trucks_data");
		$wsql .= $sql1;
		$wsql .= $sqlw1;
		$wsql .= " ORDER BY YEAR(ts.createdon) ASC, WEEK(ts.createdon) ASC";

		$msql .= $sql1;
		$msql .= $sqlm1;
		$msql .= " ORDER BY YEAR(ts.createdon) ASC, MONTH(ts.createdon) ASC";
		$data["reports"]=$this->db->query($sql);
		$data["wreports"]=$this->db->query($wsql);
		$data["mreports"]=$this->db->query($msql);
		$data["from"]=date("m/d/Y",strtotime($data["from"]));
		$data["to"]=date("m/d/Y",strtotime($data["to"]));
		$this->settemplate->dashboard('etmreport/report',$data);

	}
    
    public function speed()
    {
        $data["page_title"] = "Speed Reports";
        $uid = $this->session->userdata('user_id');
        $carrierquery = "select id,name from tb_vendors WHERE status=1 AND user_id= ? ";
        $data["carriers"] = $this->db->query($carrierquery, [$uid]);

        $driverquery = "SELECT d.id,tvv.imei,d.name,tvv.vendor_id AS carrier_id FROM tb_vendors tv
                        LEFT JOIN tb_trucks_data tvv ON tvv.`vendor_id`=tv.id
                        LEFT JOIN `tb_vehicles_drivers` tvd ON tvv.id = tvd.vehicle_id
                        LEFT JOIN tb_truck_drivers d ON tvd.driver_id = d.id
                        WHERE tv.user_id= ?  AND tvv.status= ? AND tvv.imei IS NOT NULL AND tvv.imei!= ?
                        GROUP BY d.id, carrier_id
                        ORDER BY carrier_id";

        $data["drivers"] = $this->db->query($driverquery, [$uid, 1, '']);

        $this->settemplate->dashboard('speedReports', $data);
    }

    public function speedgraph()
    {
        $data["page_title"] = "Speedometer Graph";
        $uid = $this->session->userdata('user_id');
        $carrierquery = "select id,name from tb_vendors WHERE status=1 AND user_id= ? ";
        $data["carriers"] = $this->db->query($carrierquery, [$uid]);

        $driverquery = "SELECT d.id,tvv.imei,d.name,tvv.vendor_id AS carrier_id,register_number
                            FROM tb_vendors tv
                            LEFT JOIN tb_trucks_data tvv ON tvv.`vendor_id`=tv.id
                            LEFT JOIN `tb_vehicles_drivers` tvd ON tvv.id = tvd.vehicle_id
                            LEFT JOIN tb_truck_drivers d ON tvd.driver_id = d.id
                            WHERE tv.user_id= ?  AND tvv.status= ? AND tvv.imei IS NOT NULL AND tvv.imei!= ?
                            GROUP BY d.id, carrier_id
                            ORDER BY carrier_id";

        $data["drivers"] = $this->db->query($driverquery, [$uid, 1, '']);

        $this->settemplate->dashboard('speedgraph', $data);
    }

    public function speedData()
    {
        $input = $this->input->post();
        $imei = $this->input->post("driver");
        $dates = explode("-", $input["daterangepicker"]);
        $from = date("Y-m-d H:i:s", strtotime($dates[0]));
        $to = date("Y-m-d H:i:s", strtotime($dates[1]));
        $query = "SELECT *,id,TIMESTAMP, latitude, longitude, speed as max_speed FROM `tb_rtdrive_locations`";
        $query .= " WHERE mobileimei = ?";
        $query .= " AND `timestamp` < ?";
        $query .= " AND `timestamp` >= ?";
        $query .= " AND `Speed` != 0";
        $query .= " group by (`timestamp`) ORDER BY `tb_rtdrive_locations`.`timestamp` DESC";
        $result = $this->db->query($query, [$imei, $to, $from]);
        echo json_encode($result->result_array());
    }

    public function getSpeedData()
    {
        $input = $this->input->post();
        $imei = $this->input->post("driver");
        $veh = explode("_", $imei);
        $imei = $veh[0];
        $vehicle = $veh[1];
        $dates = explode("-", $input["daterangepicker"]);
        $from = date("Y-m-d H:i:s", strtotime($dates[0]));
        $to = date("Y-m-d H:i:s", strtotime($dates[1]));
        $diff = strtotime($dates[1]) - strtotime($dates[0]);
        $diffDays = ($diff / (60 * 60 * 24));
        if ($diffDays <= 1) {
            $sql = "SELECT *,max(speed) as max_speed FROM `tb_rtdrive_locations`";
            $sql .= " WHERE mobileimei = ?";
            $sql .= " AND `timestamp` < ?";
            $sql .= " AND `timestamp` >= ?";
            $sql .= " group by MINUTE(`timestamp`) order by `timestamp` desc";
            $result = $this->db->query($sql, [$imei, $to, $from]);
        } else {
            $sql = "SELECT *,MAX(speed) AS max_speed FROM `tb_rtdrive_locations` WHERE speed IN
                   (SELECT MAX(speed) AS speed FROM `tb_rtdrive_locations` WHERE  mobileimei = ?
                AND `timestamp` <  ?
                AND `timestamp` >= ? GROUP BY DATE(`timestamp`))
                AND  mobileimei =  ?
                AND `timestamp` <  ?
                AND `timestamp` >= ?
				GROUP BY DATE(`timestamp`)
				ORDER BY `timestamp` DESC";
            $result = $this->db->query($sql, [$imei, $to, $from, $imei, $to, $from]);
        }
        $latitude = [];
        $longitude = [];
        $speed = [];
        $max_speed = [];
        $mobileimei = [];
        $timestamp = [];
        $avgtime = [];
        $i = 0;

        if ($result->num_rows() > 0) {
            foreach ($result->result_array() as $key => $res) {
                $latitude[] = $res['latitude'] . "," . $res['longitude'];
                $longitude[] = $res['longitude'];
                $speed[] = $res['speed'];
                $max_speed[] = $res['max_speed'];
                $mobileimei[] = $res['mobileimei'];
                $timestamp[] = $res['timestamp'];
                $avgtime[] = $i;
                $i++;
            }
        }
        echo json_encode([
            "latitude" => $latitude,
            "longitude" => $longitude,
            "speed" => $speed,
            "max_speed" => $max_speed,
            "mobileimei" => $vehicle,
            "timestamp" => $timestamp,
            "avgtime" => $avgtime,
        ]);
    }
}
