<?php
defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');
class Etnxdocapi extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        require_once APPPATH . 'libraries/Sendsms.php';
        require_once APPPATH . 'third_party/fpdf/fpdf.php';
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper('date');
        $this->load->model('cabmodel');
        $this->load->model('common');
        $this->load->library('smsnotifier');
        $this->load->library('sendfirebase');
        $this->load->library("statusintigration");
        $this->load->library("shippeostatusintigration");
    }
    public function index()
    {
        echo "Welcome to Svkonekt Android services";
        $data['user'] = "";
    }

    public function getorderdetailsfromamzedi(){
        $data = $order_details = array();
        $response = array("status" => 0, "data" => $data);
        $total_quantity = $total_volume = $total_weight = 0;
        if(isset($_POST)){
            $user_id = isset($_POST['user_id']) ? $_POST['user_id'] : 0;
            if($user_id != "" && $user_id != '0'){
                $getorderdetails = $this->common->gettbldata(array('user_id'=>$user_id,'trip_sts'=>'0'),'id,order_id,pickup_datetime,delivery_datetime,pickup_country,delivery_country,pickup_city,delivery_city','tb_orders',0,0);
                if(!empty($getorderdetails)){
                    foreach($getorderdetails as $res){
                        $getordercargocount= $this->db->query("SELECT sum(weight) as total_weight,sum(volume) as total_volume,sum(quantity) as total_quantity FROM tb_order_cargodetails WHERE order_id='" . $res['id'] . "' AND status ='1'");
                        if($getordercargocount->num_rows() >0){
                            $total_quantity = $getordercargocount->row()->total_quantity;
                            $total_volume = $getordercargocount->row()->total_volume;
                            $total_weight = $getordercargocount->row()->total_weight;
                        }
                        $recent_status = 0;
                        $pickup_date = $res['pickup_datetime'];
                        if($pickup_date != ""){
                            $pickup_date = strtotime($pickup_date);
                        }
                        $delivery_date = $res['delivery_datetime'];
                        if($delivery_date != ""){
                            $delivery_date = strtotime($delivery_date);
                        }
                       /* $getrecentorderstatus = $this->db->query("SElECT status_code FROM tb_stop_status WHERE order_id ='".$res['id']."' ORDER BY id DESC");
                        if($getrecentorderstatus->num_rows() >0){
                            $recent_status = $getrecentorderstatus->row()->status_code;
                        }*/
                        $order_details[] = array('order_row_id'=>$res['id'],'order_id'=>$res['order_id'],'pickup_city'=>$res['pickup_city'],'delivery_city'=>$res['delivery_city'],'total_quantity'=>round($total_quantity),'total_volume'=>$total_volume,'total_weight'=>$total_weight,'pickup_date'=>$pickup_date,'delivery_date'=>$delivery_date,'delivery_country'=>$res['delivery_country'],'pickup_country'=>$res['pickup_country']);
                    }
                }
            }
            $response = array("status" => 1, "data" => $order_details);
        }
        $response = $this->printable($response);
        echo json_encode($response);
    }

    public function printable($array){
        $ret=[];
        foreach($array as $key=>$value){
            if(is_array($value)){
                $ret[$key] = $this->printable($value);
            }else{
                if(!isset($value) || $value==null){
                    $value = "";
                }
                $ret[$key] = "$value";
            }
        }
        return $ret;
    }
    public function getcargoslist_fromorder(){
        $data= array('status'=>'0','data'=>array());
        $cargos = array();
        if(isset($_POST)){
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            if($order_id == ""){
                $order_id = 0;
            }
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            if($pallet_id == ""){
                $pallet_id = 0;
            }
            if($order_id != "0"){
                if($pallet_id != "0"){
                    $checkpallet = $this->db->query("SElECT id,quantity,scanned_quantity,quantity_type,qr_code FROM tb_order_cargodetails WHERE id='".$pallet_id."' AND order_id='".$order_id."' AND pallet_name IS NOT NULL AND pallet_close ='1' AND status ='1'");
                    if($checkpallet->num_rows() >0){
                        $scannedquantity = $checkpallet->row()->scanned_quantity;
                        $total_quantity = $checkpallet->row()->quantity;
                        if($scannedquantity == ""){
                            $scannedquantity = '0';
                        }else{
                            $scannedquantity= round($scannedquantity);
                        }
                        $getcargos = $this->db->query("SElECT id,cargo_id,quantity,scanned_quantity,quantity_type,qr_code FROM tb_order_cargodetails WHERE order_id ='".$order_id."' AND pallet_name IS NULL AND status='1'");
                        if($getcargos->num_rows() >0){
                            foreach ($getcargos->result() as $res) {
                                $scanned_quantity = $res->scanned_quantity;
                                $cargo_id = $res->cargo_id;
                                $cargo_type = $res->quantity_type;
                                $qr_code = $res->qr_code;
                                if($cargo_type == ""){
                                    $getcargotype = $this->db->select("cargo_type")->get_where("tb_cargo_details",array('id'=>$cargo_id,'status'=>'1'));
                                    if($getcargotype->num_rows() >0){
                                        $cargo_type = $getcargotype->row()->cargo_type;
                                    }
                                }
                                if($scanned_quantity == ""){
                                    $scanned_quantity = '0';
                                }else{
                                    $scanned_quantity= round($scanned_quantity);
                                }
                                $allocated_quantity = '0';
                                $getallocatedquantity = $this->db->select("sum(quantity) as quantity")->get_where("tb_inner_cargo",array('cargo_id'=>$cargo_id,'pallet_id'=>$pallet_id));
                                //echo $this->db->last_query();
                                if($getallocatedquantity->num_rows() >0){
                                    $allocated_quantity =  "".$getallocatedquantity->row()->quantity;
                                    $allocated_quantity = trim($allocated_quantity);
                                    if(strlen($allocated_quantity) == 0){
                                        $allocated_quantity = '0';
                                    }
                                }
                                $cargos[] = array('id'=>$res->id,'scanned_quantity'=>$scanned_quantity,'cargo_type'=>$cargo_type,'qr_code'=>$res->qr_code,'total_quantity'=>round($res->quantity),'allocated_quantity'=>$allocated_quantity);
                            }
                        }
                       /* $getpalletslist = $this->db->query("SElECT id,cargo_type,quantity,scanned_quantity,qr_code FROM tb_inner_cargo WHERE pallet_id ='".$pallet_id."'");
                        if($getpalletslist->num_rows() >0){
                            foreach ($getpalletslist->result() as $row) {
                                $innerscannedquantity = $getpalletslist->row()->scanned_quantity;
                                $total_quantity = $checkpallet->row()->quantity;
                                if($innerscannedquantity == ""){
                                    $innerscannedquantity = '0';
                                }else{
                                    $innerscannedquantity= round($innerscannedquantity);
                                }
                                $cargos[] = array('id'=>$pallet_id,'inner_id'=>$row->id,'scanned_quantity'=>$innerscannedquantity,'cargo_type'=>$row->cargo_type,'qr_code'=>$row->qr_code,'total_quantity'=>round($row->quantity),'allocated_quantity'=>$row->quantity);
                            }
                        }*/

                    }
                }else{
                    $getcargos = $this->db->query("SElECT id,cargo_id,quantity,scanned_quantity,quantity_type,qr_code FROM tb_order_cargodetails WHERE order_id ='".$order_id."' AND pallet_name IS NULL AND status='1'");
                    if($getcargos->num_rows() >0){
                        foreach ($getcargos->result() as $res) {
                            $scanned_quantity = $res->scanned_quantity;
                            $cargo_id = $res->cargo_id;
                            $cargo_type = $res->quantity_type;
                            if($cargo_type == ""){
                                $getcargotype = $this->db->select("cargo_type")->get_where("tb_cargo_details",array('id'=>$cargo_id,'status'=>'1'));
                                if($getcargotype->num_rows() >0){
                                    $cargo_type = $getcargotype->row()->cargo_type;
                                }
                            }
                            if($scanned_quantity == ""){
                                $scanned_quantity = '0';
                            }else{
                                $scanned_quantity= round($scanned_quantity);
                            }
                            $cargos[] = array('id'=>$res->id,'scanned_quantity'=>$scanned_quantity,'cargo_type'=>$cargo_type,'qr_code'=>$res->qr_code,'total_quantity'=>round($res->quantity),'allocated_quantity'=>'0');
                        }
                    }
                }

            }else{
                $message = "No Request Data";
            }
        }
       $data= array('status'=>'1','data'=>$cargos);
        $data = $this->printable($data);
        echo json_encode($data);

    }

    public function login()
    {
        $data = ['status' => '0'];
        $response = [];
        $msg = "Please enter login details";
        if (isset($_POST)) {
            $post = $this->input->post();
            $mobile_no = $post['mobile_no'] ?? "";
            $password = $post['password'] ?? "";
            if (!in_array("", [$mobile_no, $response])) {
                $allUsersData = $this->common->gettbldata("mobile_no ='" . $mobile_no . "' AND mobile_no != 'appadmin' AND status ='Active'", "id,country_code,password,company_indv_name,business_type,company_code,branch_code,map_type", "tb_users", 0, 0);
                foreach ($allUsersData as $eachRow) {
                    $usersData[$eachRow['id']] = $eachRow;
                }
                $userRowId = $this->checkUserPassword($password, $allUsersData);
                if ($userRowId > 0) {
                    $userData = $usersData[$userRowId];
                    $response = ['user_id' => $userData['id'], 'name' => $userData['company_indv_name'], 'company_code' => $userData['company_code'], 'branch_code' => $userData['branch_code']];
                    $msg = "Login Success";
                    $data = ['status' => '1', 'data' => $response, 'message' => $msg];
                } else {
                    $msg = "User doesn't exist";
                    $data = ['status' => '0', 'message' => $msg];
                }
            } else {
                $data = ['status' => '0', 'message' => "Mobile number or password cannot be empty!"];
            }
        } else {
            $data = ['status' => '0', 'message' => "No input data received!"];
        }

        $data = $this->printable($data);
        echo json_encode($data);
    }

    private function checkUserPassword(string $password, array $userData): int
    {
        if(empty($userData)){
            return 0;
        }
        foreach ($userData as $eachRow) {
            $rowId = $eachRow['id'];
            $encryptedPassword = $eachRow['password'];
            if (password_verify($password, $encryptedPassword)) {
                return $rowId;
            }
        }
        return 0;
    }

    public function getpalletslist_fororder(){
        $data = array('status'=>'0');
        $result = array();
        if(isset($_POST)){
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            if($order_id == ""){
                $order_id = 0;
            }
            if($order_id != 0){
                $getpalletname = $this->db->query("SElECT id,pallet_name FROM tb_order_cargodetails WHERE order_id='".$order_id."' AND pallet_name IS NOT NULL AND pallet_close ='1' ORDER BY id DESC");
                if($getpalletname->num_rows() >0){
                    foreach ($getpalletname->result() as $res) {
                        $result[] = array('pallet_name'=>$res->pallet_name,'pallet_id'=>$res->id,'order_id'=>$order_id);
                    }
                }
            }
            $data = array('status'=>'1','data'=>$result);
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function savepalletcargo_fororder(){
        $pallets = $singlepallet = array();
        $data = array('status'=>'0','data'=>array());
        if(isset($_POST)){
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "";
            $pallet_name = isset($_POST['pallet_name']) ? $_POST['pallet_name'] : "";
            if($order_id == ""){
                $order_id = 0;
            }
            $cdate = date('Y-m-d H:i:s');
            $user_id = 1;
            if($order_id != "0"){
                $getuserid = $this->db->select("user_id")->get_where("tb_orders",array('id'=>$order_id));
                if($getuserid->num_rows() >0){
                    $user_id = $getuserid->row()->user_id;
                }
                $handling_unit =  1;
                if($pallet_name != ""){
                    $pallet_name .= " - ".date("Y/m/d H:i A");
                    $chk_handling_unit = $this->db->select("id")->get_where("tbl_shipunit_types",array('unit_name'=>$pallet_name,'status'=>'1'));
                    if($chk_handling_unit->num_rows()>0){
                        $handling_unit = $chk_handling_unit->row()->id;
                    }else{
                        $handling_insarr = array('unit_name'=>$pallet_name,'description'=>$pallet_name,'user_id'=>$user_id,'status'=>'1','created_at'=>$cdate);
                        $this->db->insert("tbl_shipunit_types",$handling_insarr);
                        $handling_unit = $this->db->insert_id();
                    }
                    $cargo_ins = array('cargo_type'=>$pallet_name,'handling_unit'=>$handling_unit,'length'=>'0','width'=>'0','height'=>'0','weight'=>'0','volumetric_weight'=>'0','ldm'=>'0','volume'=>'0','quantity'=>'0','status'=>'1','createdby'=>$user_id,'createdon'=>$cdate);
                    $inscargo = $this->db->insert("tb_cargo_details",$cargo_ins);
                    $cargo_id = $this->db->insert_id();
                    $chkexistsornot = $this->db->select("id")->get_where("tb_order_cargodetails",array('pallet_name'=>$pallet_name,'order_id'=>$order_id,'status'=>'1'));
                    if($chkexistsornot->num_rows() == 0){
                        $ins = array('order_id'=>$order_id,'handling_unit'=>$handling_unit,'cargo_id'=>$cargo_id,'length'=>'0','width'=>'0','height'=>'0','weight'=>'0','volumetric_weight'=>'0','ldm'=>'0','volume'=>'0','quantity'=>'0','pallet_name'=>$pallet_name,'pallet_close'=>'1','status'=>'1','createdon'=>$cdate);
                        $ins_pallet = $this->db->insert("tb_order_cargodetails",$ins);
                        $pallet_id = $this->db->insert_id();
                        $singlepallet = array('pallet_name'=>$pallet_name,'pallet_id'=>$pallet_id,'order_id'=>$order_id);
                        $getallpallets = $this->db->query("SElECT id,pallet_name FROM tb_order_cargodetails WHERE id != '".$pallet_id."' AND order_id='".$order_id."' AND pallet_name IS NOT NULL AND pallet_close ='1' ORDER BY id DESC");
                        if($getallpallets->num_rows() >0){
                            foreach ($getallpallets->result() as $res) {
                                $pallets[] = array('pallet_name'=>$res->pallet_name,'pallet_id'=>$res->id,'order_id'=>$order_id);
                            }
                        }
                        $result = array('pallets'=>$pallets,'pallet'=>$singlepallet);
                        $data = array('status'=>'1','data'=>$result);
                    }else{
                        $data = array('status'=>'0','message'=>"Pallet Name already exists!");
                    }
                }else{
                    $data = array('status'=>'0','message'=>"Pallet Name Should not be empty!");
                }

            }else{
                $data = array('status'=>'0','message'=>"Order ID should not be 0!");
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }

    public function submit_pallet(){

        $data = array('status'=>'0','data'=>array());
        $cdate = date('Y-m-d H:i:s');
        if(isset($_POST)){
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            $cargoes = isset($_POST['cargoes']) ? $_POST['cargoes'] : array();
            if($order_id == ""){
                $order_id = 0;
            }
            if($pallet_id == ""){
                $pallet_id = 0;
            }
            $cargo_detail_id = 0;
            if($order_id != "0" && $pallet_id != "0"){
                $postcargo = (Array)json_decode($cargoes,true);
                $user_id = 1;
                $getuserid = $this->db->select("user_id")->get_where("tb_orders",array('id'=>$order_id));
                if($getuserid->num_rows() >0){
                    $user_id = $getuserid->row()->user_id;
                }
                $getpallet_cargo_id = $this->db->select("cargo_id")->get_where("tb_order_cargodetails",array('id'=>$pallet_id,'status'=>'1'));
                // if($getpallet_cargo_id->num_rows() >0){
                //     $cargo_detail_id = $getpallet_cargo_id->row()->cargo_id;
                // }
                if(!empty($postcargo)){
                    foreach ($postcargo as $row) {
                        $cargo_row_id = $row['id'];
                        $allocated_quantity = $row['allocated_quantity'];
                        $cargo_type = $row['cargo_type'];
                        $qr_code = $row['qr_code'];
                        $scanned_quantity = $row['scanned_quantity'];
                        $total_quantity = $row['total_quantity'];
                        $getcargodetails = $this->db->select("cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,cargo_content,qr_code")->get_where("tb_order_cargodetails",array('id'=>$cargo_row_id,'order_id'=>$order_id,'status'=>'1'));
                        if($getcargodetails->num_rows() >0){
                            $cargo_detail_id = $getcargodetails->row()->cargo_id;
                            $length_unit = "m";
                            $width_unit = "m";
                            $height_unit = "m";
                            $volweight_uom = $getcargodetails->row()->volweight_uom;
                            $qr_code = $getcargodetails->row()->qr_code;
                            $weight_unit = "kg";
                            $volume_unit = "cbm";
                            $quantity_type = $getcargodetails->row()->quantity_type;
                            if($cargo_row_id != "" && $cargo_row_id != "0"){
                                $getdimensions = $this->db->select("cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit")->get_where("tb_cargo_details",array('id'=>$cargo_row_id,'status'=>'1'));
                                if($getdimensions->num_rows() >0){
                                    $length_unit = $getdimensions->row()->length_unit;
                                    $width_unit = $getdimensions->row()->width_unit;
                                    $height_unit = $getdimensions->row()->height_unit;
                                    $volweight_uom = $getdimensions->row()->volweight_uom;
                                    $weight_unit = $getdimensions->row()->weight_unit;
                                    $volume_unit = $getdimensions->row()->volume_unit;
                                    if($quantity_type == ""){
                                        $quantity_type= $getdimensions->row()->cargo_type;
                                    }
                                }
                            }
                            $handling_unit = $getcargodetails->row()->handling_unit;
                            $length = $getcargodetails->row()->length;
                            $width = $getcargodetails->row()->width;
                            $height = $getcargodetails->row()->height;
                            $weight = $getcargodetails->row()->weight;
                            $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                            $ldm = $getcargodetails->row()->ldm;
                            $volume = $getcargodetails->row()->volume;
                            $total_quantity = $getcargodetails->row()->quantity;
                            $cargo_content = $getcargodetails->row()->cargo_content;
                            if($quantity_type == ""){
                                $quantity_type = 'CTN';
                            }
                            $inner_cargo = array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$pallet_id,'cargo_type'=>$quantity_type,'goods_description'=>$cargo_content,'quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity,'length'=>$length,'length_unit'=>$length_unit,'width'=>$width,'width_unit'=>$width_unit,'height'=>$height,'height_unit'=>$height_unit,'weight'=>$weight,'weight_unit'=>$weight_unit,'volume'=>$volume,'volume_unit'=>$volume_unit,'stackable'=>'0','qr_code'=>$qr_code,'status'=>'1','createdby'=>$user_id,'createdon'=>$cdate);
                            $checkInnerCargo = $this->db->where(array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$pallet_id,'status'=>'1'))->get("tb_inner_cargo");
                            if($checkInnerCargo->num_rows()>0){
                                $this->db->where(array("id"=>$checkInnerCargo->row()->id))->update("tb_inner_cargo",$inner_cargo);
                            }else{
                                $inner_qry = $this->db->insert("tb_inner_cargo",$inner_cargo);
                            }

                            if($total_quantity == $scanned_quantity){
                                $this->db->where(array('id'=>$cargo_row_id))->update("tb_order_cargodetails",array('scanned_quantity'=>$scanned_quantity,'status'=>'0'));
                            }else{
                                $this->db->where(array('id'=>$cargo_row_id))->update("tb_order_cargodetails",array('scanned_quantity'=>$scanned_quantity));
                            }
                        }
                    }
                    $data = array('status'=>'1','message'=>'Success');
                }else{
                    $data = array('status'=>'0','message'=>'Cargos Should not be empty!');
                }
            }else{
                $data = array('status'=>'0','message'=>'Order and Pallet Should not be 0!');
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);

    }

    public function close_pallet(){
        $data = array('status'=>'0','data'=>array());
        $cdate = date('Y-m-d H:i:s');
        if(isset($_POST)){
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            $cargoes = isset($_POST['cargoes']) ? $_POST['cargoes'] : array();
            if($order_id == ""){
                $order_id = 0;
            }
            if($pallet_id == ""){
                $pallet_id = 0;
            }
            if($order_id != "0" && $pallet_id != "0"){
                $postcargo = (Array)json_decode($cargoes,true);
                $user_id = 1;
                $getuserid = $this->db->select("user_id")->get_where("tb_orders",array('id'=>$order_id));
                if($getuserid->num_rows() >0){
                    $user_id = $getuserid->row()->user_id;
                }
                $getpallet_cargo_id = $this->db->select("cargo_id")->get_where("tb_order_cargodetails",array('id'=>$pallet_id,'status'=>'1'));
                if($getpallet_cargo_id->num_rows() >0){
                    $cargo_detail_id = $getpallet_cargo_id->row()->cargo_id;
                }
                foreach ($postcargo as $row) {
                    $cargo_row_id = $row['id'];
                    $allocated_quantity = $row['allocated_quantity'];
                    $cargo_type = $row['cargo_type'];
                    $qr_code = $row['qr_code'];
                    $scanned_quantity = $row['scanned_quantity'];
                    $total_quantity = $row['total_quantity'];
                    $getcargodetails = $this->db->select("cargo_id,handling_unit,length,width,height,weight,volumetric_weight,volweight_uom,ldm,volume,quantity,quantity_type,cargo_content,qr_code")->get_where("tb_order_cargodetails",array('id'=>$cargo_row_id,'order_id'=>$order_id,'status'=>'1'));
                    if($getcargodetails->num_rows() >0){
                        /*$cargo_detail_id = $getcargodetails->row()->cargo_id;*/
                        $length_unit = "m";
                        $width_unit = "m";
                        $height_unit = "m";
                        $volweight_uom = $getcargodetails->row()->volweight_uom;
                        $qr_code = $getcargodetails->row()->qr_code;
                        $weight_unit = "kg";
                        $volume_unit = "cbm";
                        $quantity_type = $getcargodetails->row()->quantity_type;
                        if($cargo_row_id != "" && $cargo_row_id != "0"){
                            $getdimensions = $this->db->select("cargo_type,length_unit,width_unit,height_unit,volweight_uom,weight_unit,volume_unit")->get_where("tb_cargo_details",array('id'=>$cargo_row_id,'status'=>'1'));
                            if($getdimensions->num_rows() >0){
                                $length_unit = $getdimensions->row()->length_unit;
                                $width_unit = $getdimensions->row()->width_unit;
                                $height_unit = $getdimensions->row()->height_unit;
                                $volweight_uom = $getdimensions->row()->volweight_uom;
                                $weight_unit = $getdimensions->row()->weight_unit;
                                $volume_unit = $getdimensions->row()->volume_unit;
                                if($quantity_type == ""){
                                    $quantity_type= $getdimensions->row()->cargo_type;
                                }
                            }
                        }
                        $handling_unit = $getcargodetails->row()->handling_unit;
                        $length = $getcargodetails->row()->length;
                        $width = $getcargodetails->row()->width;
                        $height = $getcargodetails->row()->height;
                        $weight = $getcargodetails->row()->weight;
                        $volumetric_weight = $getcargodetails->row()->volumetric_weight;
                        $ldm = $getcargodetails->row()->ldm;
                        $volume = $getcargodetails->row()->volume;
                        $total_quantity = $getcargodetails->row()->quantity;
                        $cargo_content = $getcargodetails->row()->cargo_content;
                        if($quantity_type == ""){
                            $quantity_type = 'CTN';
                        }
                        $inner_cargo = array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$pallet_id,'cargo_type'=>$quantity_type,'goods_description'=>$cargo_content,'quantity'=>$allocated_quantity,'scanned_quantity'=>$allocated_quantity,'length'=>$length,'length_unit'=>$length_unit,'width'=>$width,'width_unit'=>$width_unit,'height'=>$height,'height_unit'=>$height_unit,'weight'=>$weight,'weight_unit'=>$weight_unit,'volume'=>$volume,'volume_unit'=>$volume_unit,'stackable'=>'0','qr_code'=>$qr_code,'status'=>'1','createdby'=>$user_id,'createdon'=>$cdate);
                        $checkInnerCargo = $this->db->where(array('cargo_id'=>$cargo_detail_id,'pallet_id'=>$pallet_id,'status'=>'1'))->get("tb_inner_cargo");
                        if($checkInnerCargo->num_rows()>0){
                            $this->db->where(array("id"=>$checkInnerCargo->row()->id))->update("tb_inner_cargo",$inner_cargo);
                        }else{
                            $inner_qry = $this->db->insert("tb_inner_cargo",$inner_cargo);
                        }
                        if($total_quantity == $scanned_quantity){
                            $this->db->where(array('id'=>$cargo_row_id))->update("tb_order_cargodetails",array('scanned_quantity'=>$scanned_quantity,'status'=>'0'));
                        }else{
                            $this->db->where(array('id'=>$cargo_row_id))->update("tb_order_cargodetails",array('scanned_quantity'=>$scanned_quantity));
                        }
                    }
                }
                $upd_pallet = $this->db->where(array('id'=>$pallet_id))->update("tb_order_cargodetails",array('pallet_close'=>'0'));
                $data = array('status'=>'1','message'=>'Success');
            }else{
                $data = array('status'=>'0','message'=>'Order and Pallet Should not be 0!');
            }
        }
        $data = $this->printable($data);
        echo json_encode($data);
    }
    /* public function close_pallet(){
        $data = array('status'=>'0','data'=>array());
        if(isset($_POST)){
            log_message("error","closepallet_withcargos ".json_encode($this->input->post()));
            $order_id = isset($_POST['order_id']) ? $_POST['order_id'] : "0";
            $pallet_id = isset($_POST['pallet_id']) ? $_POST['pallet_id'] : "0";
            if($order_id == ""){
                $order_id = 0;
            }
            if($pallet_id == ""){
                $pallet_id = 0;
            }
        }
    }*/

}
