<?php

class Extrshorders extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library("Edi_logger");
    }

    public function index()
    {
        ini_set('max_execution_time', 300);
        $postData = file_get_contents('php://input');
        if (empty($postData)) {
            echo "Please Send Proper XML";
            return;
        }
        try {
            $postXMLData = json_decode(json_encode(simplexml_load_string($postData, "SimpleXMLElement", LIBXML_NOCDATA)), true, 512, JSON_THROW_ON_ERROR);
            $this->edi_logger->setEdi_request($postData);
            $this->sendExtrshOrderToAltova($postData);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While Receiving Stardard Status XML From Carrier  " . $ex->getMessage());
        } finally {
            $this->edi_logger->setEdi_type(1);
            $this->edi_logger->setTxn_obj_id(0);
            $this->edi_logger->setUser_id(0);
            $this->edi_logger->setCompany_code("");
            $this->edi_logger->setBranch_code("");
            $this->edi_logger->setTransaction_id(time());
            $this->edi_logger->setEdi_id("47");
            $this->edi_logger->setEdi_name('KNRLGEXTRSH');
            $this->edi_logger->setBounded_type(1);
            $this->edi_logger->setEdi_format_type('XML');
            $this->edi_logger->setStatus(1);
            $this->edi_logger->setEdi_response("Success");
            $this->edi_logger->setObj_type_name('KNRLGEXTRSH');
            $this->edi_logger->saveToEdiLogs();
        }
        echo "Success";
    }

    private function sendExtrshOrderToAltova(string $postData): string
    {
        try {
            $curl = curl_init();
            curl_setopt_array($curl, [
                CURLOPT_URL => EXTRSH_ORDER_ALTOVA_URL,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $postData,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json'
                ],
            ]);
            $response = curl_exec($curl);
            curl_close($curl);
        } catch (Exception $ex) {
            log_message("error", "Some Problem occured!, While sending Extrsh  orders to Altova " . $ex->getMessage());
        }
        return $response ?? "";
    }
}
