<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Fuelsurcharge extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("Knratemodel");
        $this->load->model("Fuelsurchargemodel");
        if (!checkUrlAccessForUser('FUELSURCHARGE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data = array();
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('fuel_surcharge');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["getdata"] = array();
        $post = $this->input->post();
        if ($company_code == "RUKN") {
            $wher = array(
                's.status' => 1, 's.company_code' => $company_code
            );
        } else {
            $wher = array(
                's.status' => 1, 's.user_id' => $user_id
            );
        }

        $whr = array();
        if (!empty($post)) {
            if (isset($post['company_code']) && $post['company_code'] != "") {
                $whr['s.company_code'] = $post['company_code'];
            }
            if (isset($post['branch_code']) && $post['branch_code'] != "") {
                $whr['s.branch_code'] = $post['branch_code'];
            }
            if (isset($post['faf_id']) && $post['faf_id'] != "") {
                $whr['s.faf_id'] = $post['faf_id'];
            }
            if (isset($post['faf_name']) && $post['faf_name'] != "") {
                $whr['s.faf_name'] = $post['faf_name'];
            }

            if (isset($post['from_date']) && $post['from_date'] != "") {
                $post['from_date'] = date('Y-m-d', strtotime($post['from_date']));
                $wher["DATE_FORMAT(s.created_on,'%Y-%m-%d') >="] = $post['from_date'];
            }
            if (isset($post['to_date']) && $post['to_date'] != "") {
                $post['to_date'] = date('Y-m-d', strtotime($post['to_date']));
                $wher["DATE_FORMAT(s.created_on,'%Y-%m-%d') <="] = $post['to_date'];
            }
        }
        $data["getdata"] = $this->Fuelsurchargemodel->getgeneraldata($wher, $whr);
      /*   log_message('error',$this->db->last_query());  */
        $this->newtemplate->dashboard("fuelsurcharge/index", $data);
    }

    public function add()
    {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data["page_title"] = $this->lang->line('fuel_surcharge');
        $data["sub_title"] = $this->lang->line('general_add');

        $data['currencies'] = $this->Knratemodel->getcurrency();
        /* log_message('error',$this->db->last_query()); */
        $data['currencies'][] = array('currency' => "PLN");
        //$this->newtemplate->dashboard("fuelsurcharge/add", $data);
        $this->load->view("fuelsurcharge/add", $data);
    }

    public function savesheet($id = NULL)
    {

        if (!empty($this->input->post())) {
            $data=array();
            $ins_data = array(
                'from_date' => date("Y-m-d", strtotime($this->input->post('from_date', true))),
                'to_date' => date("Y-m-d", strtotime($this->input->post('to_date', true))),

            );
            $currency = $this->input->post('currency', true);
            $amount = $this->input->post('amount', true);
            $percentage = $this->input->post('percentage', true);
            if($amount=="" || empty($amount)){
                $amount=0;
            }
            if($percentage=="" || empty($percentage)){
                $percentage=0;
            }
            if(empty($currency)){
                $currency="";
            }
            $ins_data['amount'] = $amount;
            $ins_data['percentage'] = $percentage;
            $ins_data['currency'] = $currency;
            if (empty($id)) {
                $ins_data['status'] = 1;
                $ins_data['created_on'] =  $ins_data['updated_on'] =date('Y-m-d H:i:s');
                $post = $this->input->post();
                $list_id = isset($post['surcharge_id']) ? $post['surcharge_id'] : "";
                if (!empty($list_id)) {
                    $ins_data['fuel_surcharge_id'] = $list_id;
                }
                $data['id'] = $this->common->insertTableData("tb_fuel_surcharge_sheet", $ins_data);
            } else {
                $whr = array('id' => $id);
                $this->common->updatetbledata("tb_fuel_surcharge_sheet", $ins_data, $whr);
                $data['id'] = $id;

            }
            echo json_encode($data);
        }
    }

    public function getsheetdata()
    {
        $fuelsur_list_id = $this->input->post('fuelsur_list_id', true);
        $ids = isset($fuelsur_list_id) ? $fuelsur_list_id : "";
        $data = array();
        if ($ids != "") {
            $where = array('status' => 1);
            $get_data = $this->Fuelsurchargemodel->getsheetdata($ids, $where);
            foreach ($get_data as $res) {
                $from_date = date("d-m-Y", strtotime($res['from_date']));
                $to_date = date("d-m-Y", strtotime($res['to_date']));
                if ($res['percentage'] == "0") {
                    $res['percentage'] = "";
                }
                if ($res['amount'] == "0") {
                    $res['amount'] = "";
                }

                $info = array('id' => $res['id'], 'from_date' => $from_date, 'to_date' => $to_date, 'amount' => htmlentities($res['amount'], ENT_QUOTES), 'currency' => htmlentities($res['currency'], ENT_QUOTES), 'percentage' => htmlentities($res['percentage'], ENT_QUOTES),);
                $info = htmlentities(json_encode($info));
                $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default' onclick='rowEdit(this," . $info . ");' ><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletesheet(" . $res['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";

                $data[] = array(
                    'from_date' =>  $from_date,
                    'to_date' => $to_date,
                    'amount' => $res['amount'],
                    'currency' => $res['currency'],
                    'percentage' => $res['percentage'],
                    'action' => $action
                );
            }
        }
        echo json_encode($data);
    }

    public function deletesheet()
    {

        $id = $this->input->post('id', true);
        $data = array();
        if (!empty($id)) {
            $whr = array('id' => $id);
            $ins_data['status'] = 0;
            $this->common->updatetbledata("tb_fuel_surcharge_sheet", $ins_data, $whr);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function savegeneralinfo($id = NULL)
    {

        $data = array();
        $user_id = $this->session->userdata('user_id');
        $ins_data = array(
            'faf_name' =>  $this->input->post('faf_name', true),
            'description' => $this->input->post('desc', true),
            'company_code' => $this->input->post('company_code', true),
            'branch_code' => $this->input->post('branch_code', true),
        );
        $customer_id = $this->input->post('customerid', true);
        $vendor_id = $this->input->post('vendorid', true);
        $tariff_type = $this->input->post('tariff_type', true);
        if($customer_id==""){
            $customer_id=0;
        }
        if($vendor_id==""){
            $vendor_id=0;
        }
        /*if(!empty($customer_id) || !empty($vendor_id)){
            $ins_data['tariff_type'] = $tariff_type;
        }else{
            $ins_data['tariff_type'] ="";
        }*/
        $ins_data['tariff_type'] = $tariff_type;
        $ins_data['customer_id'] = $customer_id;
        $ins_data['carrier_id'] = $vendor_id;

        $fuelsur_list_id = $this->input->post('fuelsur_list_id', true);
        if (empty($id)) {
            $ins_data['faf_id'] = $this->idgeneration();
            $ins_data['status'] = 1;
            $ins_data['user_id'] = $user_id;
           // $ins_data['user_id1'] = $user_id;
            $ins_data['created_on'] =  $ins_data['updated_on'] =date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData("tb_fuel_surcharge", $ins_data);
            if (!empty($data['id'])) {
                $ids = isset($fuelsur_list_id) ? $fuelsur_list_id : "";
                if ($ids != "") {
                    $ids1 = explode(',', $ids);
                    for ($i = 0; $i < count($ids1); $i++) {
                        $data1 = array('fuel_surcharge_id' => $data['id']);
                        $table = 'tb_fuel_surcharge_sheet';
                        $whr = array('id' => $ids1[$i]);
                        $result1 = $this->common->updatetbledata($table, $data1, $whr);
                    }
                }
            }
        } else {
            $whr = array('id' => $id);
            $ins_data['status'] = 1;
            $this->common->updatetbledata("tb_fuel_surcharge", $ins_data, $whr);
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    public function idgeneration()
    {
        $year = date('y');
        $week = date('W');
        $gen_id = 0;
        $res = $this->Knratemodel->getlastid(array(), 'faf_id', 'tb_fuel_surcharge', 'id');
        if (!empty($res)) {
            $get_id = $res['faf_id'];
            $len_of_get_id = strlen($get_id);
            if ($len_of_get_id > 7) {

                /**
                 * get previous week number  from faf id
                 */
                $previous_weeknumber = substr($get_id, 4, 2);
                /**
                 * get last number from faf id
                 */
                $get_id_num= substr($get_id, 6);
                $get_id_num = ltrim($get_id_num, 0);
                /**
                 * comparing previous week and present week
                 */
                if ($previous_weeknumber < $week) {
                    $id = '0001';
                } else {
                    $id = $get_id_num;
                    $id++;
                    $id_length = strlen($id);
                    if ($id_length == '1') {
                        $id = "000" . $id;
                    } else if ($id_length == '2') {
                        $id = "00" . $id;
                    } else if ($id_length == '3') {
                        $id = "0" . $id;
                    }  else {
                        $id = $id;
                    }
                }
            } else {
                $id = '0001';
            }
            /**
             * id generation
             */
            $gen_id = "FS" . $year . $week . $id;
            $chk = $this->common->gettblrowdata(array('faf_id' => $gen_id), 'faf_id', 'tb_fuel_surcharge', 0, 0);
             /**
             *  if id exists in DB, generate one more time
             */
            if (!empty($chk)) {
                $id++;
                $id_length = strlen($id);
                if ($id_length == '1') {
                    $id = "000" . $id;
                } else if ($id_length == '2') {
                    $id = "00" . $id;
                } else if ($id_length == '3') {
                    $id = "0" . $id;
                }
                $gen_id = "FS" . $year . $week . $id;
            } else {
                $gen_id = $gen_id;
            }
        } else {
            $id = 1;
            $id = '000' . $id;
            $gen_id = "FS" . $year . $week . $id;
        }
        return $gen_id;
    }

    public function checkname()
    {
        $post = $this->input->post();

        $id = isset($post['id']) ? $post['id'] : "";
        $name = isset($post['name']) ? $post['name'] : "";
        $where = array();
        $company_code = isset($post['company_code']) ? $post['company_code'] : "";
        $branch_code = isset($post['branch_code']) ? $post['branch_code'] : "";
        if ($company_code == 'RUKN') {
            $where = array(
                'faf_name' => $name,
                'company_code' => $company_code,
                'status' => 1,
            );
        } else {
            $where = array(
                'faf_name' => $name,
                'company_code' => $company_code,
                'branch_code' => $branch_code,
                'status' => 1
            );
        }
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'faf_name', 'tb_fuel_surcharge', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function view($id)
    {
        $data['ids'] = array();
        $data["page_title"] = $this->lang->line('fuel_surcharge');
        $data["sub_title"] = $this->lang->line('general_view');
        $where = array('s.id' => $id, 's.status' => 1);
        $whr = array();
        $data["view_data"] = $this->Fuelsurchargemodel->getgeneraldata($where, $whr, 1);
        //$this->newtemplate->dashboard("fuelsurcharge/view", $data);
        $this->load->view("fuelsurcharge/view", $data);
    }

    public function viewsheetdata()
    {
        $fuelsur_list_id = $this->input->post('fuelsur_list_id', true);
        $data = array();
        if ($fuelsur_list_id != "") {
            $sheet_whr = array('status' => 1, 'fuel_surcharge_id' => $fuelsur_list_id);
            $get_data = $this->common->gettbldata($sheet_whr, '*', 'tb_fuel_surcharge_sheet', 0, 0);
            foreach ($get_data as $res) {
                $from_date = date("d-m-Y", strtotime($res['from_date']));
                $to_date = date("d-m-Y", strtotime($res['to_date']));
                if ($res['percentage'] == "0") {
                    $res['percentage'] = "";
                }
                if ($res['amount'] == "0") {
                    $res['amount'] = "";
                }

                $data[] = array(
                    'from_date' =>  $from_date,
                    'to_date' => $to_date,
                    'amount' => !empty($res['amount']) ? $res['amount'] : "",
                    'currency' => $res['currency'],
                    'percentage' => !empty($res['percentage']) ? $res['percentage'] : "",
                    'action' => ""
                );
            }
        }
        echo json_encode($data);
    }

    public function edit($id)
    {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data["page_title"] = $this->lang->line('fuel_surcharge');
        $data["sub_title"] = $this->lang->line('general_add');

        $data['currencies'] = $this->Knratemodel->getcurrency();
        $data['currencies'][] = array('currency' => "PLN");
        $where = array('s.id' => $id, 's.status' => 1);
        $whr = array();
        $data["edit_data"] = $this->Fuelsurchargemodel->getgeneraldata($where, $whr, 1);
        //$this->newtemplate->dashboard("fuelsurcharge/edit", $data);
        $this->load->view("fuelsurcharge/edit", $data);
    }

    public function editgetsheetdata()
    {
        $fuelsur_list_id = $this->input->post('fuelsur_id', true);
        $data = array();
        if ($fuelsur_list_id != "") {
            $sheet_whr = array('status' => 1, 'fuel_surcharge_id' => $fuelsur_list_id);
            $get_data = $this->common->gettbldata($sheet_whr, '*', 'tb_fuel_surcharge_sheet', 0, 0);
            foreach ($get_data as $res) {
                $from_date = date("d-m-Y", strtotime($res['from_date']));
                $to_date = date("d-m-Y", strtotime($res['to_date']));
                if ($res['percentage'] == "0") {
                    $res['percentage'] = "";
                }
                if ($res['amount'] == "0") {
                    $res['amount'] = "";
                }

                $info = array('id' => $res['id'], 'from_date' => $from_date, 'to_date' => $to_date, 'amount' => htmlentities($res['amount'], ENT_QUOTES), 'currency' => htmlentities($res['currency'], ENT_QUOTES), 'percentage' => htmlentities($res['percentage'], ENT_QUOTES),);
                $info = htmlentities(json_encode($info));
                $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default' onclick='rowEdit(this," . $info . ");' ><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletesheet(" . $res['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";

                $data[] = array(
                    'from_date' =>  $from_date,
                    'to_date' => $to_date,
                    'amount' => !empty($res['amount']) ? $res['amount'] : "",
                    'currency' => $res['currency'],
                    'percentage' => !empty($res['percentage']) ? $res['percentage'] : "",
                    'action' => $action
                );
            }
        }
        echo json_encode($data);
    }

    public function delete($id)
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_fuel_surcharge');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }
}
