<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require './vendor/autoload.php';

/**
 *
 * @property CI_Loader $load
 * @property Common $common
 * @property CI_Session $session
 * @property CI_DB_mysqli_driver $db
 * @property CI_Lang $lang
 */
class Gdocs extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model("common");
    }

    public function index()
    {
        $this->getFiles();
        $data["page_title"] = "Import";
        $data["sub_title"] = "Google Spreadsheets";
        $this->newtemplate->dashboard('gdocs/list_docs', $data);
    }

    public function selectFile($value = '')
    {
        redirect("gdocs");
    }

    public function contact_admin()
    {
        $isAdmin = $_GET["isAdmin"] ?? "";
        if ($isAdmin) {
            $this->getClient(true);
        } else {
            show_error(
                "An Error Was Encountered during Google docs authorization, Contact Administator to resolve this issue",
                401,
                $heading = 'An Error Was Encountered'
            );
        }
    }

    public function getClientInstance()
    {
        $client = new Google_Client();
        $client->setApplicationName('Google Sheets API for Svkonekt');
        $client->setScopes([
                               "https://www.googleapis.com/auth/drive",
                               "https://www.googleapis.com/auth/drive.file",
                               "https://www.googleapis.com/auth/spreadsheets"
                           ]);
        $client->setAuthConfig(GDOCS_CREDENTIALS);
        $client->setAccessType('offline');
        $client->setPrompt('select_account consent');
        $client->setApprovalPrompt('auto');
        $client->setRedirectUri(base_url('gdocs/callback'));
        return $client;
    }

    public function callback()
    {
        $credentialsPath = "./assets/gdocs/client_secrets/token.json";
        if (isset($_GET["code"])) {
            $authCode = $_GET["code"];
            $client = $this->getClientInstance();
            // Exchange authorization code for an access token.
            $accessToken = $client->fetchAccessTokenWithAuthCode($authCode);
            $client->setAccessToken($accessToken);

            if (!file_exists(dirname($credentialsPath))) {
                mkdir(dirname($credentialsPath), 0700, true);
            }
            file_put_contents($credentialsPath, json_encode($accessToken));
            $actual_link = $this->session->userdata("REDIRECT_URL");
            $this->session->unset_userdata("REDIRECT_URL");
            redirect($actual_link);
        } else {
            $actual_link = $this->session->userdata("REDIRECT_URL");
            echo "<h3>Request authorization failed.</h3><h4><a href='$actual_link'>Click here</a> to redirect back to home page";
        }
    }

    public function getClient($isAdmin = false)
    {
        $credentialsPath = "./assets/gdocs/client_secrets/token.json";
        $client = $this->getClientInstance();

        if (file_exists($credentialsPath)) {
            $accessToken = json_decode(file_get_contents($credentialsPath), true);
            $client->setAccessToken($accessToken);
        }

        // If there is no previous token or it's expired.
        if ($client->isAccessTokenExpired()) {
            // Refresh the token if possible, else fetch a new one.
            if ($client->getRefreshToken()) {
                $client->fetchAccessTokenWithRefreshToken($client->getRefreshToken());
                if (!file_exists(dirname($credentialsPath))) {
                    mkdir(dirname($credentialsPath), 0700, true);
                }
                file_put_contents($credentialsPath, json_encode($client->getAccessToken()));
            } else {
                // Request authorization from the user.
                $authUrl = $client->createAuthUrl();
                $actual_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                if (!$this->session->has_userdata("REDIRECT_URL")) {
                    $this->session->set_userdata("REDIRECT_URL", $actual_link);
                }
                if ($isAdmin) {
                    redirect($authUrl);
                } else {
                    redirect("gdocs/contact_admin");
                }
            }
        }

        return $client;
    }

    public function getFiles()
    {
        return $this->getFilesByName();
    }

    public function getFilesByName($name = "")
    {
        // Get the API client and construct the service object.
        $client = $this->getClient();
        $service = new Google_Service_Drive($client);
        // Print the names and IDs for up to 100 files.
        $search = "mimeType='application/vnd.google-apps.spreadsheet'";
        if (strlen($name) > 0) {
            $search = "mimeType='application/vnd.google-apps.spreadsheet' and name contains '" . $name . "'";
        }
        $optParams = [
            'q' => $search,
            'pageSize' => 10,
            'fields' => 'files(id, name)'
        ];
        $results = $service->files->listFiles($optParams);
        if (count($results->getFiles()) == 0) {
            return [];
        } else {
            $arr = [];
            foreach ($results->getFiles() as $file) {
                $arr[] = ["name" => $file->getName(), "id" => $file->getId()];
            }
            return $arr;
        }
    }

    public function getDocContents($spreadsheetId = "")
    {
        if (strlen(trim($spreadsheetId)) > 0) {
            $client = $this->getClient();
            $sheets = new Google_Service_Sheets($client);

            $range = 'A:Z';
            $rows = $sheets->spreadsheets_values->get($spreadsheetId, $range, ['majorDimension' => 'ROWS']);
            //echo json_encode($rows['values']);
            if ($this->processExcel($rows['values'])) {
                echo json_encode(["status" => 1]);
            } else {
                echo json_encode(["status" => 0, "message" => "Invalid document received!"]);
            }
        } else {
            echo json_encode(["status" => 0, "message" => "No document received!"]);
        }
    }

    public function getDocContents2($spreadsheetId = "")
    {
        $all_sheets = [];
        if (strlen(trim($spreadsheetId)) > 0) {
            $client = $this->getClient();
            $service = new Google_Service_Sheets($client);
            $spreadSheet = $service->spreadsheets->get($spreadsheetId);
            $sheets = $spreadSheet->getSheets();

            foreach ($sheets as $sheet) {
                $sheets[] = $sheet->properties;//->sheetId;
                $sheet_name = $sheet->properties->title;
                $range = "'" . $sheet_name . "'!A:Z";
                $rows = $service->spreadsheets_values->get($spreadsheetId, $range, ['majorDimension' => 'ROWS']);
                $all_sheets[$sheet_name] = $rows['values'];
            }
            $this->updateCellBackground($spreadsheetId, 0, 0, 1, 0, 1);
        }
        return $all_sheets;
    }

    public function submitDocument()
    {
        $customer_id = $this->input->post("customer_id");
        $sheet_type = $this->input->post("sheet_type");
        $docs = $this->getFilesByName($customer_id . "_" . $sheet_type);
        if (count($docs) > 0) {
            $doc = $docs[0];
            $createord = [];
            $contents = $this->getDocContents2($doc["id"]);
            if (!empty($contents)) {
                foreach ($contents as $res) {
                    if (count($res) > 2) {
                        $createord = $this->createorder($res);
                    }
                }
                echo json_encode(["status" => 1, "message" => "Success"]);
            } else {
                echo json_encode(["status" => 0, "message" => "No data in documents!"]);
            }
        } else {
            echo json_encode(["status" => 0, "message" => "No document received!"]);
        }
    }

    public function createorder($res)
    {
        $response = [];
        if (count($res) > 0) {
            $cdate = date("Y-m-d H:i:s");
            $enddate = date('Y-m-d H:i:s', strtotime("+1 day"));
            $user_id = $this->session->userdata('user_id');
            $company_code = $this->session->userdata("company_code");
            $branch_code = $this->session->userdata("branch_code");
            $country_code = $this->session->userdata("usr_tzone")['phone_code'];
            $cntry = $this->session->userdata("usr_tzone")['country'];
            $shipperparty_id = 1;
            $consignee_party_id = 3;
            $carrier_type_id = 2;
            $chkparty = $this->common->gettblrowdata(
                ["name" => "Shipper", "user_id" => $this->db->escape($user_id), "status" => 1],
                "id",
                "tbl_party_types",
                0,
                0
            );
            if (count($chkparty) > 0) {
                $shipperparty_id = $chkparty['id'];
            }
            $chkparty = $this->common->gettblrowdata(
                ["name" => "Consignee", "user_id" => $this->db->escape($user_id), "status" => 1],
                "id",
                "tbl_party_types",
                0,
                0
            );
            if (count($chkparty) > 0) {
                $consignee_party_id = $chkparty['id'];
            }
            $chkparty = $this->common->gettblrowdata(
                ["name" => "Carrier", "user_id" => $this->db->escape($user_id), "status" => 1],
                "id",
                "tbl_party_types",
                0,
                0
            );
            if (count($chkparty) > 0) {
                $carrier_type_id = $chkparty['id'];
            }
            foreach ($res as $ord) {
                if ($ord[0] != "") {
                    if (strpos($ord[0], "Delivery Note") === false) {
                        $shipment_id = trim($ord[0]);
                        $modeof_trasnport = trim($ord[1]);
                        $order_type = trim($ord[2]);
                        $product = trim($ord[3]);
                        $carrierid = isset($ord[24]) ? trim($ord[24]) : "";
                        if ($product == "KN Asia Direct" && $modeof_trasnport == "Full truck load") {
                            $service = "FTL";
                        } elseif ($product == "KN Pharma Chain" && $modeof_trasnport == "Less than Truck load") {
                            $service = "LTL";
                        } else {
                            $service = "FTL";
                        }
                        $pickup_custid = trim($ord[4]);
                        $pickupcustid = trim($ord[5]);
                        $pickup_name = "Default";
                        $pickup_street = "Default";
                        $pickup_city = "Default";
                        $pickup_state = "Default";
                        $pickup_country = "Default";
                        $pickup_pincode = "Default";
                        $e_pickup = trim($ord[6]);
                        $l_pickup = trim($ord[7]);
                        $pickup_phone = trim($ord[8]);
                        if ($pickup_phone == "") {
                            $pickup_phone = $pickupcustid;
                        }
                        $pickup_email = trim($ord[9]);
                        $drop_id = trim($ord[10]);
                        $drop_name = "Default";
                        $drop_street = "Default";
                        $drop_city = "Default";
                        $drop_state = "Default";
                        $drop_country = "Default";
                        $drop_pincode = "Default";
                        $e_delivery = trim($ord[11]);
                        $l_delivery = trim($ord[12]);
                        $drop_phone = isset($ord[13]) ? trim($ord[13]) : "";
                        if ($drop_phone == "") {
                            $drop_phone = $drop_id;
                        }
                        $drop_email = isset($ord[14]) ? trim($ord[14]) : "";
                        $incoterm = "DAP";
                        $cargo_type = isset($ord[15]) ? trim($ord[15]) : "";
                        $goods_desc = isset($ord[16]) ? trim($ord[16]) : "";
                        $quantity = isset($ord[17]) ? trim($ord[17]) : "";
                        if ($quantity == "") {
                            $quantity = 1;
                        }
                        $length = isset($ord[18]) ? trim($ord[18]) : "";
                        $width = isset($ord[19]) ? trim($ord[19]) : 1;
                        $height = isset($ord[20]) ? trim($ord[20]) : 1;
                        $weight = isset($ord[21]) ? trim($ord[21]) : 1;
                        $volume = isset($ord[22]) ? trim($ord[22]) : 1;
                        if ($height == "" || !is_numeric($height)) {
                            $height = 1;
                        }
                        if ($width == "" || !is_numeric($width)) {
                            $width = 1;
                        }
                        if ($weight == "" || !is_numeric($weight)) {
                            $weight = 1;
                        }
                        if ($volume == "" || !is_numeric($volume)) {
                            $volume = 1;
                        }
                        $stackable = 0;
                        $stackable1 = isset($ord[23]) ? trim($ord[23]) : "Off";
                        if ($shipment_id != "" && $modeof_trasnport != "" && $pickup_custid != "") {
                            /* check customer */
                            $chkcust = $this->common->gettblrowdata(
                                ["code" => $this->db->escape($pickup_custid)],
                                "id",
                                "tb_customers",
                                0,
                                0
                            );
                            if (count($chkcust) > 0) {
                                $customer_id = $chkcust['id'];
                            } else {
                                $pwd = password_hash($pickup_custid, PASSWORD_DEFAULT);
                                $cusrarr = [
                                    "name" => "KN Customer",
                                    "phone" => $this->db->escape($pickup_custid),
                                    "code" => $this->db->escape($pickup_custid),
                                    "country" => $this->db->escape($cntry),
                                    "location" => $this->db->escape($pickup_custid),
                                    "email_id" => $this->db->escape($pickup_custid),
                                    "password" => $this->db->escape($pwd),
                                    "user_id" => $this->db->escape($user_id),
                                    "status" => 1,
                                    "company_code" => $this->db->escape($company_code),
                                    "branch_code" => $this->db->escape($branch_code),
                                    "createdon" => $this->db->escape($cdate)
                                ];
                                $customer_id = $this->common->insertTableData("tb_customers", $cusrarr);
                            }
                            $tid = $tname = "";
                            $gettrasnportmode = $this->common->gettblrowdata(
                                " (code LIKE " . $this->db->escape($modeof_trasnport) .
                                " OR name LIKE " . $this->db->escape($modeof_trasnport) . ") ",
                                "id,name",
                                "tb_transportmode",
                                0,
                                0
                            );
                            if (count($gettrasnportmode) > 0) {
                                $tid = $gettrasnportmode['id'];
                                $tname = $gettrasnportmode['name'];
                            }
                            $ship_arr = [
                                'shipid' => $this->db->escape($shipment_id),
                                'txnid' => $this->db->escape($shipment_id),
                                'trucktype' => $this->db->escape($tname),
                                'pickupcnt' => '1',
                                'dropcnt' => '1',
                                'unitspec' => 1,
                                'insertusr' => $this->db->escape($pickup_custid),
                                'carrier' => '0',
                                'insertuserdate' => $this->db->escape($cdate),
                                'enddate' => $this->db->escape($enddate),
                                'insdate' => $this->db->escape($cdate),
                                'upddate' => $this->db->escape($cdate),
                                'reason' => 'SHIPMENT',
                                'purpose' => 'SEND INTEGRATION',
                                'ship_object' => 'SHIPMENT',
                                'logdate' => $this->db->escape($cdate),
                                'transport_mode' => $this->db->escape($modeof_trasnport),
                                'domainname' => $this->db->escape($branch_code),
                                'company_code' => $this->db->escape($company_code),
                                'branch_code' => $this->db->escape($branch_code),
                                'product' => $this->db->escape($product),
                                'freight_term' => '60',
                                'freight_termname' => 'Free of Charge',
                                'incoterm' => $this->db->escape($incoterm),
                                'modeoftransport' => $this->db->escape($tid)
                            ];
                            $chk_shipid = $this->common->gettblrowdata(
                                ["shipid" => $this->db->escape($shipment_id)],
                                "id",
                                "tb_shipments",
                                0,
                                0
                            );
                            if (count($chk_shipid) > 0) {
                                $ship_row_id = $chk_shipid['id'];
                                $upd = $this->common->updatetbledata(
                                    "tb_shipments",
                                    $ship_arr,
                                    ['id' => $this->db->escape($ship_row_id)]
                                );
                            } else {
                                $ship_arr['createdon'] = $this->db->escape($cdate);
                                $ship_row_id = $this->common->insertTableData("tb_shipments", $ship_arr);
                            }
                            if ($e_pickup != "") {
                                $e_pickup = date("Y-m-d H:i:s", strtotime($e_pickup));
                            } else {
                                $e_pickup = $cdate;
                            }
                            if ($l_pickup != "") {
                                $l_pickup = date("Y-m-d H:i:s", strtotime($l_pickup));
                            } else {
                                $l_pickup = $cdate;
                            }
                            if ($e_delivery != "") {
                                $e_delivery = date("Y-m-d H:i:s", strtotime($e_delivery));
                            } else {
                                $e_delivery = $cdate;
                            }
                            if ($l_delivery != "") {
                                $l_delivery = date("Y-m-d H:i:s", strtotime($l_delivery));
                            } else {
                                $l_delivery = $cdate;
                            }
                            $goods_value = 0.00;
                            /* check shipper */
                            if ($pickupcustid == "") {
                                $pickupcustid = $country_code . mt_rand();
                                $updarr = [
                                    "party_type_id" => $this->db->escape($shipperparty_id),
                                    "name" => $this->db->escape($pickup_name),
                                    "email" => $this->db->escape($pickup_email),
                                    "mobile" => $this->db->escape($pickup_phone),
                                    "location_id" => $this->db->escape($pickup_city),
                                    "street" => $this->db->escape($pickup_street),
                                    "state" => $this->db->escape($pickup_state),
                                    "address" => $this->db->escape($pickup_street),
                                    "pincode" => $this->db->escape($pickup_pincode),
                                    "country" => $this->db->escape($pickup_country),
                                    "user_id" => $this->db->escape($user_id),
                                    "code" => $this->db->escape($pickupcustid),
                                    "company_code" => $this->db->escape($company_code),
                                    "branch_code" => $this->db->escape($branch_code),
                                    "customer_code" => $this->db->escape($pickup_custid),
                                    "status" => 1,
                                    "created_on" => $this->db->escape($cdate)
                                ];
                                $order_shipper_id = $this->common->insertTableData("tbl_party_master", $updarr);
                            } else {
                                $chkshiper = $this->common->gettblrowdata(
                                    ["code" => $this->db->escape($pickupcustid)],
                                    "id,name,email,mobile,location_id, address,country,state,pincode,street",
                                    "tbl_party_master",
                                    0,
                                    0
                                );
                                if (count($chkshiper) > 0) {
                                    $order_shipper_id = $chkshiper['id'];
                                    $pickup_name = $chkshiper['name'];
                                    $pickup_street = $chkshiper['street'];
                                    $pickup_city = $chkshiper['location_id'];
                                    $pickup_state = $chkshiper['state'];
                                    $pickup_country = $chkshiper['country'];
                                    $pickup_pincode = $chkshiper['pincode'];
                                    $pickup_phone = $chkshiper['mobile'];
                                    $pickup_email = $chkshiper['email'];
                                } else {
                                    $updarr = [
                                        "party_type_id" => $this->db->escape($shipperparty_id),
                                        "name" => $this->db->escape($pickup_name),
                                        "email" => $this->db->escape($pickup_email),
                                        "mobile" => $this->db->escape($pickup_phone),
                                        "location_id" => $this->db->escape($pickup_city),
                                        "street" => $this->db->escape($pickup_street),
                                        "state" => $this->db->escape($pickup_state),
                                        "address" => $this->db->escape($pickup_street),
                                        "pincode" => $this->db->escape($pickup_pincode),
                                        "country" => $this->db->escape($pickup_country),
                                        "user_id" => $this->db->escape($user_id),
                                        "code" => $this->db->escape($pickupcustid),
                                        "company_code" => $this->db->escape($company_code),
                                        "branch_code" => $this->db->escape($branch_code),
                                        "customer_code" => $this->db->escape($pickup_custid),
                                        "status" => 1,
                                        "created_on" => $this->db->escape($cdate)
                                    ];
                                    $order_shipper_id = $this->common->insertTableData("tbl_party_master", $updarr);
                                }
                            }
                            /* check consignee */
                            if ($drop_id == "") {
                                $drop_id = $country_code . mt_rand();
                                $updarr = [
                                    "party_type_id" => $this->db->escape($consignee_party_id),
                                    "name" => $this->db->escape($drop_name),
                                    "email" => $this->db->escape($drop_email),
                                    "mobile" => $this->db->escape($drop_phone),
                                    "location_id" => $this->db->escape($drop_city),
                                    "street" => $this->db->escape($drop_street),
                                    "state" => $this->db->escape($drop_state),
                                    "address" => $this->db->escape($drop_street),
                                    "pincode" => $this->db->escape($drop_pincode),
                                    "country" => $this->db->escape($drop_country),
                                    "user_id" => $this->db->escape($user_id),
                                    "code" => $this->db->escape($drop_id),
                                    "company_code" => $this->db->escape($company_code),
                                    "branch_code" => $this->db->escape($branch_code),
                                    "customer_code" => $this->db->escape($pickup_custid),
                                    "status" => 1,
                                    "created_on" => $this->db->escape($cdate)
                                ];
                                $consignee_id = $this->common->insertTableData("tbl_party_master", $updarr);
                            } else {
                                $chkconsignee = $this->common->gettblrowdata(
                                    ["code" => $this->db->escape($drop_id)],
                                    "id,name,email,mobile,location_id, address,country,state,pincode,street",
                                    "tbl_party_master",
                                    0,
                                    0
                                );
                                if (count($chkconsignee) > 0) {
                                    $consignee_id = $chkconsignee['id'];
                                    $drop_name = $chkconsignee['name'];
                                    $drop_street = $chkconsignee['street'];
                                    $drop_city = $chkconsignee['location_id'];
                                    $drop_state = $chkconsignee['state'];
                                    $drop_country = $chkconsignee['country'];
                                    $drop_pincode = $chkconsignee['pincode'];
                                    $drop_phone = $chkconsignee['mobile'];
                                    $drop_email = $chkconsignee['email'];
                                } else {
                                    $updarr = [
                                        "party_type_id" => $this->db->escape($consignee_party_id),
                                        "name" => $this->db->escape($drop_name),
                                        "email" => $this->db->escape($drop_email),
                                        "mobile" => $this->db->escape($drop_phone),
                                        "location_id" => $this->db->escape($drop_city),
                                        "street" => $this->db->escape($drop_street),
                                        "state" => $this->db->escape($drop_state),
                                        "address" => $this->db->escape($drop_street),
                                        "pincode" => $this->db->escape($drop_pincode),
                                        "country" => $this->db->escape($drop_country),
                                        "user_id" => $this->db->escape($user_id),
                                        "code" => $this->db->escape($drop_id),
                                        "company_code" => $this->db->escape($company_code),
                                        "branch_code" => $this->db->escape($branch_code),
                                        "customer_code" => $this->db->escape($pickup_custid),
                                        "status" => 1,
                                        "created_on" => $this->db->escape($cdate)
                                    ];
                                    $consignee_id = $this->common->insertTableData("tbl_party_master", $updarr);
                                }
                            }
                            if ($carrierid != "") {
                                $carrierchk = $this->common->gettblrowdata(
                                    " (mobile=" . $this->db->escape($carrierid) .
                                    " OR code=" . $this->db->escape($carrierid) . ") ",
                                    "id,name,mobile,location,address,country,pincode,code",
                                    "tb_vendors",
                                    0,
                                    0
                                );
                                if (count($carrierchk) > 0) {
                                    $carrier_id = $carrierchk['id'];
                                } else {
                                    $updarr = [
                                        "name" => $this->db->escape($carrierid),
                                        "mobile" => $this->db->escape($carrierid),
                                        "location" => $this->db->escape($drop_city),
                                        "address" => $this->db->escape($drop_street),
                                        "pincode" => $this->db->escape($drop_pincode),
                                        "country" => $this->db->escape($drop_country),
                                        "user_id" => $this->db->escape($user_id),
                                        "code" => $this->db->escape($drop_id),
                                        "company_code" => $this->db->escape($company_code),
                                        "branch_code" => $this->db->escape($branch_code),
                                        "offering_type" => 'FTL',
                                        "effective_date" => $this->db->escape($cdate),
                                        "expiry_date" => $this->db->escape($cdate),
                                        "service_name" => 'FTL',
                                        'custid' => $this->db->escape($carrierid),
                                        'partyid' => $this->db->escape($carrierid),
                                        "status" => 1,
                                        "created_on" => $this->db->escape($cdate)
                                    ];
                                    $carrier_id = $this->common->insertTableData("tb_vendors", $updarr);
                                }
                                $carrier = $this->common->gettblrowdata(
                                    ["code" => $this->db->escape($carrierid)],
                                    "id,name,email,mobile,location_id, address,country,state,pincode,street",
                                    "tbl_party_master",
                                    0,
                                    0
                                );
                                if (count($carrier) > 0) {
                                    $carrier_party = $carrier['id'];
                                } else {
                                    $updarr = [
                                        "party_type_id" => $this->db->escape($carrier_type_id),
                                        "name" => $this->db->escape($carrierid),
                                        "mobile" => $this->db->escape($carrierid),
                                        "location_id" => $this->db->escape($drop_city),
                                        "street" => $this->db->escape($drop_street),
                                        "state" => $this->db->escape($drop_state),
                                        "address" => $this->db->escape($drop_street),
                                        "pincode" => $this->db->escape($drop_pincode),
                                        "country" => $this->db->escape($drop_country),
                                        "user_id" => $this->db->escape($user_id),
                                        "code" => $this->db->escape($carrierid),
                                        "company_code" => $this->db->escape($company_code),
                                        "branch_code" => $this->db->escape($branch_code),
                                        "customer_code" => $this->db->escape($pickup_custid),
                                        "status" => 1,
                                        "created_on" => $this->db->escape($cdate)
                                    ];
                                    $carrier_party = $this->common->insertTableData("tbl_party_master", $updarr);
                                }
                            }
                            $data = [];
                            $add1 = implode(",", [$pickup_street, $pickup_city, $pickup_country, $pickup_pincode]);
                            $add2 = implode(",", [$drop_street, $drop_city, $drop_country, $drop_pincode]);
                            $data = getlatlngsbyplace($add1);
                            $lat1 = @$data[0];
                            $lng1 = @$data[1];
                            $data = [];
                            $data = getlatlngsbyplace($add2);
                            $lat2 = @$data[0];
                            $lng2 = @$data[1];
                            $ins = [
                                'shipment_id' => $this->db->escape($ship_row_id),
                                'customer_id' => $this->db->escape($customer_id),
                                'product' => $this->db->escape($product),
                                'pickup_datetime' => $this->db->escape($e_pickup),
                                'delivery_datetime' => $this->db->escape($e_delivery),
                                'pickup_endtime' => $this->db->escape($l_pickup),
                                'drop_endtime' => $this->db->escape($l_delivery),
                                'goods_value' => $this->db->escape($goods_value),
                                'company_code' => $this->db->escape($company_code),
                                'branch_code' => $this->db->escape($branch_code),
                                'createdon' => $this->db->escape($cdate),
                                'drop_custid' => $this->db->escape($drop_id),
                                'drop_partyid' => $this->db->escape($drop_id),
                                'user_id' => $this->db->escape($user_id),
                                'pickup_custid' => $this->db->escape($pickupcustid),
                                'pickup_partyid' => $this->db->escape($pickupcustid),
                                'pickup_country' => $this->db->escape($pickup_country),
                                'pickup_city' => $this->db->escape($pickup_city),
                                'pickup_pincode' => $this->db->escape($pickup_pincode),
                                'pickup_company' => $this->db->escape($pickup_name),
                                'pickup_address1' => $this->db->escape($pickup_street),
                                'pickup_address2' => $this->db->escape($pickup_state),
                                'delivery_country' => $this->db->escape($drop_country),
                                'delivery_city' => $this->db->escape($drop_city),
                                'delivery_pincode' => $this->db->escape($drop_pincode),
                                'delivery_company' => $this->db->escape($drop_name),
                                'delivery_address1' => $this->db->escape($drop_street),
                                'delivery_address2' => $this->db->escape($drop_state),
                                'is_created' => '1',
                                'plat' => $this->db->escape($lat1),
                                'plng' => $this->db->escape($lng1),
                                'dlat' => $this->db->escape($lat2),
                                'dlng' => $this->db->escape($lng2),
                                'transport_mode' => $this->db->escape($service),
                                'modeoftransport' => $this->db->escape($tid),
                                'created_source' => '2'
                            ];
                            if ($carrier_id != "") {
                                $ins['vendor_id'] = $this->db->escape($carrier_id);
                            }
                            $chkord = $this->common->gettblrowdata(
                                [
                                    'shipment_id' => $this->db->escape($ship_row_id),
                                    'customer_id' => $this->db->escape($customer_id)
                                ],
                                "id,order_id",
                                "tb_orders",
                                0,
                                0
                            );
                            if (count($chkord) > 0) {
                                $order_id = $chkord['id'];
                                $booking_id = $chkord['order_id'];
                                $upd = $this->common->updatetbledata(
                                    "tb_orders",
                                    $ins,
                                    ['id' => $this->db->escape($order_id)]
                                );
                            } else {
                                $order_id = $this->common->insertTableData("tb_orders", $ins);
                                /* auto generate booking id*/
                                $booking_id = $this->generateorderid($order_id, $country_code);
                                $upd = $this->common->updatetbledata(
                                    "tb_orders",
                                    ['order_id' => $this->db->escape($booking_id)],
                                    ['id' => $this->db->escape($order_id)]
                                );
                            }
                            /*add order details*/
                            $details = [
                                'service' => $this->db->escape($service),
                                'delivery_term' => "",
                                'incoterm' => $this->db->escape($incoterm),
                                'purchase_order' => "",
                                'notify_party' => $this->db->escape($pickupcustid),
                                'department_code' => "",
                                'temperature_control' => '0',
                                'valorance_insurance' => '0',
                                'high_cargo_value' => '0',
                                'customs_required' => '0',
                                'order_row_id' => $this->db->escape($order_id),
                                'order_id' => $this->db->escape($booking_id),
                                'createdon' => $this->db->escape($cdate),
                                'shipper_id' => $this->db->escape($order_shipper_id),
                                'order_type' => $this->db->escape($order_type)
                            ];
                            $orddetail = $this->common->insertTableData("tb_order_details", $details);
                            /*add order party address details*/
                            $shipper_address = [
                                'order_id' => $this->db->escape($order_id),
                                'party_master_id' => $this->db->escape($order_shipper_id),
                                'location_id' => $this->db->escape($pickup_city),
                                'street' => $this->db->escape($pickup_street),
                                'state' => $this->db->escape($pickup_state),
                                'address' => $this->db->escape($pickup_street),
                                'pincode' => $this->db->escape($pickup_pincode),
                                'country' => $this->db->escape($pickup_country),
                                'user_id' => $this->db->escape($user_id)
                            ];
                            $chk_shipperaddress = $this->common->gettblrowdata(
                                [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_master_id' => $this->db->escape($order_shipper_id),
                                    'status' => '1'
                                ],
                                "id",
                                "tbl_orderparty_address",
                                0,
                                0
                            );
                            if (count($chk_shipperaddress) > 0) {
                                $shipperadd_id = $chk_shipperaddress['id'];
                                $upd_add = $this->common->updatetbledata(
                                    "tbl_orderparty_address",
                                    $shipper_address,
                                    ['id' => $this->db->escape($shipperadd_id)]
                                );
                            } else {
                                $shipper_address['createdon'] = $this->db->escape($cdate);
                                $shipperadd_id = $this->common->insertTableData(
                                    "tbl_orderparty_address",
                                    $shipper_address
                                );
                            }
                            $delivery_address = [
                                'order_id' => $this->db->escape($order_id),
                                'party_master_id' => $this->db->escape($consignee_id),
                                'location_id' => $this->db->escape($drop_city),
                                'street' => $this->db->escape($drop_street),
                                'state' => $this->db->escape($drop_state),
                                'address' => $this->db->escape($drop_street),
                                'pincode' => $this->db->escape($drop_pincode),
                                'country' => $this->db->escape($drop_country),
                                'user_id' => $this->db->escape($user_id)
                            ];
                            $chk_deliveryaddress = $this->common->gettblrowdata(
                                [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_master_id' => $this->db->escape($consignee_id),
                                    'status' => '1'
                                ],
                                "id",
                                "tbl_orderparty_address",
                                0,
                                0
                            );
                            if (count($chk_deliveryaddress) > 0) {
                                $dropadd_id = $chk_deliveryaddress['id'];
                                $upd_add = $this->common->updatetbledata(
                                    "tbl_orderparty_address",
                                    $delivery_address,
                                    ['id' => $this->db->escape($dropadd_id)]
                                );
                            } else {
                                $delivery_address['createdon'] = $this->db->escape($cdate);
                                $dropadd_id = $this->common->insertTableData(
                                    "tbl_orderparty_address",
                                    $delivery_address
                                );
                            }

                            if ($stackable1 == "On") {
                                $stackable = 1;
                            }
                            /*add shipment unit details*/
                            $unitspec = "1";
                            $this->common->updatetbledata(
                                "tb_shipments",
                                [
                                    'unitspec' => $this->db->escape($unitspec),
                                    'txncode' => $this->db->escape($booking_id)
                                ],
                                ['id' => $this->db->escape($ship_row_id)]
                            );
                            /*add cargo details*/
                            if ($cargo_type != "") {
                                $cargo_ins = [
                                    'cargo_type' => $this->db->escape($cargo_type),
                                    'goods_description' => $this->db->escape($goods_desc),
                                    'quantity' => $this->db->escape($quantity),
                                    'length' => $this->db->escape($length),
                                    'length_unit' => 'M',
                                    'width' => $this->db->escape($width),
                                    'width_unit' => 'M',
                                    'height' => $this->db->escape($height),
                                    'height_unit' => 'M',
                                    'weight' => $this->db->escape($weight),
                                    'weight_unit' => 'Kg',
                                    'volume' => $this->db->escape($volume),
                                    'volume_unit' => 'cbm',
                                    'stackable' => $this->db->escape($stackable),
                                    'createdby' => $this->db->escape($user_id),
                                    'createdon' => $this->db->escape($cdate)
                                ];
                                $cargo_id = $this->common->insertTableData("tb_cargo_details", $cargo_ins);
                                /*add order cargo details*/
                                $gethandling_unit = $this->common->gettblrowdata(
                                    ["unit_name" => $this->db->escape($cargo_type)],
                                    "id",
                                    "tbl_shipunit_types",
                                    0,
                                    0
                                );
                                $handling_unit = "";
                                if (count($gethandling_unit) > 0) {
                                    $handling_unit = $gethandling_unit['id'];
                                } else {
                                    $handlingunit_ar = [
                                        'unit_name' => $this->db->escape($cargo_type),
                                        'user_id' => $this->db->escape($user_id),
                                        'created_at' => $this->db->escape($cdate),
                                        'status' => '1'
                                    ];
                                    $handling_unit = $this->common->insertTableData(
                                        "tbl_shipunit_types",
                                        $handlingunit_ar
                                    );
                                }
                                $ordcoragos = [
                                    'order_id' => $this->db->escape($order_id),
                                    'cargo_id' => $this->db->escape($cargo_id),
                                    'status' => '1',
                                    'createdon' => $this->db->escape($cdate),
                                    'length' => $this->db->escape($length),
                                    'width' => $this->db->escape($width),
                                    'height' => $this->db->escape($height),
                                    'weight' => $this->db->escape($weight),
                                    'volume' => $this->db->escape($volume),
                                    'quantity' => $this->db->escape($quantity),
                                    'cargo_content' => $this->db->escape($goods_desc),
                                    'handling_unit' => $this->db->escape($handling_unit)
                                ];
                                $this->common->insertTableData('tb_order_cargodetails', $ordcoragos);
                            }
                            /*update order uom*/
                            $uomord = [
                                'volume' => $this->db->escape($volume),
                                'weight' => $this->db->escape($weight),
                                'quantity' => $this->db->escape($quantity)
                            ];
                            $this->common->updatetbledata(
                                "tb_orders",
                                $uomord,
                                ['id' => $this->db->escape($order_id)]
                            );
                            /*add order references*/
                            if ($shipment_id != "") {
                                $ins_ref = [
                                    'order_id' => $this->db->escape($order_id),
                                    'reference_id' => 'DQ',
                                    'ref_value' => $this->db->escape($shipment_id),
                                    'createdon' => $this->db->escape($cdate)
                                ];
                                $this->common->insertTableData('tb_order_references', $ins_ref);
                            }
                            /*add order parties*/
                            $chkqry = $this->common->gettblrowdata(
                                [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($order_shipper_id)
                                ],
                                "id",
                                "tb_order_parties",
                                0,
                                0
                            );
                            if (count($chkqry) == 0) {
                                $party = [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($order_shipper_id),
                                    'status' => '1',
                                    'createdon' => $this->db->escape($cdate),
                                    'party_type' => $this->db->escape($shipperparty_id),
                                    'order_number' => $this->db->escape($booking_id)
                                ];
                                $this->common->insertTableData("tb_order_parties", $party);
                            }
                            $chkqry = $this->common->gettblrowdata(
                                [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($consignee_id)
                                ],
                                "id",
                                "tb_order_parties",
                                0,
                                0
                            );
                            if (count($chkqry) == 0) {
                                $party = [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($consignee_id),
                                    'status' => '1',
                                    'createdon' => $this->db->escape($cdate),
                                    'party_type' => $this->db->escape($consignee_party_id),
                                    'order_number' => $this->db->escape($booking_id)
                                ];
                                $this->common->insertTableData("tb_order_parties", $party);
                            }
                            $chkqry = $this->common->gettblrowdata(
                                [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($carrier_party)
                                ],
                                "id",
                                "tb_order_parties",
                                0,
                                0
                            );
                            if (count($chkqry) == 0) {
                                $party = [
                                    'order_id' => $this->db->escape($order_id),
                                    'party_id' => $this->db->escape($carrier_party),
                                    'status' => '1',
                                    'createdon' => $this->db->escape($cdate),
                                    'party_type' => $this->db->escape($carrier_type_id),
                                    'order_number' => $this->db->escape($booking_id)
                                ];
                                $this->common->insertTableData("tb_order_parties", $party);
                            }
                            $response[] = ["status" => 1, "message" => "Success"];
                            if ($carrier_id != "") {
                                $this->tripcreate(
                                    $carrier_id,
                                    $user_id,
                                    $order_id,
                                    $booking_id,
                                    $company_code,
                                    $branch_code
                                );
                            }
                        } else {
                            $response[] = ["status" => 0, "message" => $ord];
                        }
                    }
                }
            }
        }
        return $response;
    }

    public function getUserTimeZone($uid, $cmpcode)
    {
        $this->db->select(
            'country_code, cntry_timezone, cntry_hrs, currency'
        );
        $this->db->from('tbl_country_master');
        $this->db->where(
            '(country_code = ' . $this->db->escape($cmpcode) . ' OR country_name = ' . $this->db->escape($cmpcode) . ')'
        );
        $this->db->where('status', 1);
        $this->db->limit(1);
        $getqry = $this->db->get();

        $res = ["currency" => "SGD", "timezone" => "Asia/Singapore", "hrs" => "+08.00", "country" => "SG"];
        if ($getqry->num_rows() > 0) {
            $res = [
                "currency" => $getqry->row()->currency,
                "timezone" => $getqry->row()->cntry_timezone,
                "hrs" => $getqry->row()->cntry_hrs,
                'country' => $getqry->row()->country_code
            ];
        }
        return $res;
    }

    public function tripcreate($vendor_id, $userid, $order_id, $ordid, $company_code, $branch_code)
    {
        $response = 0;
        $user = $this->db->select("id,country_code")->get_where(
            "tb_users",
            ["id" => $this->db->escape($userid)],
            1,
            0
        )->row_array();
        $tz = $this->getUserTimeZone($user['id'], $user['country_code']);
        $curtz = $tz['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        $curdt = date('Y-m-d H:i:s');
        $country_code = substr($company_code, 0, 2);
        $year = date('y');
        $week = date('W');
        $seq_num = substr($ordid, -6);
        $shipid = "T" . $country_code . $week . $year . $seq_num;
        $txnid = $ordid;
        $vehicle_type = "";
        if ($vendor_id > 0 && $order_id > 0) {
            $sid = $order_id;
            $where = ["id" => $this->db->escape($order_id)];
            $select = "*";
            $table = "tb_orders";
            $order = $this->common->gettblrowdata($where, $select, $table, 0, 0);
            if (count($order) > 0) {
                $shift_idchk = $order['shift_id'];
                if ($shift_idchk == 0) {
                    $pickup = $order['pickup_address1'];
                    if ($pickup == "") {
                        $pickup = $order['pickup_city'];
                    }
                    $delivery = $order['delivery_address1'];
                    if ($delivery == "") {
                        $delivery = $order['delivery_city'];
                    }
                    $address = $dropaddr = "";
                    if ($order['pickup_address1'] != "") {
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ($order['pickup_company'] != "") {
                        $address .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ($order['pickup_country'] != "") {
                        $address .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ($order['pickup_city'] != "") {
                        $address .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ($order['pickup_pincode'] != "") {
                        $address .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    $plat = $order['plat'];
                    $plng = $order['plng'];
                    $dlat = $order['dlat'];
                    $dlng = $order['dlng'];
                    $where = ["shipmentid" => $this->db->escape($shipid)];
                    $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                    $table = "tb_shifts";
                    $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($shipment) == 0) {
                        $curdt = $logdate;
                        $splace = $order['pickup_address1'];
                        $eplace = $order['delivery_address1'];
                        $pickup_city = $order['pickup_city'];
                        $delivery_city = $order['delivery_city'];
                        $customer_id = $order['customer_id'];
                        $transport_mode = $order['transport_mode'];
                        $weight = $order['weight'];
                        $volume = $order['volume'];
                        $txnid = $shipid;
                        $vehicle_type = $order['vehicle_type'];
                        $startdate = $order['pickup_datetime'];
                        $starttime = date('H:i', strtotime($startdate));
                        $enddate = $order['delivery_datetime'];
                        $endtime = date('H:i', strtotime($enddate));
                        $getactual = getdatetimebytimezone(DFLT_TZ, $enddate, $curtz);
                        $enddate = $getactual['datetime'];
                        $insarr = [
                            'user_id' => $this->db->escape($userid),
                            'stime' => $this->db->escape($starttime),
                            'etime' => $this->db->escape($endtime),
                            'splace' => $this->db->escape($order['pickup_city']),
                            'slat' => $this->db->escape($plat),
                            'slng' => $this->db->escape($plng),
                            'eplace' => $this->db->escape($order['delivery_city']),
                            'elat' => $this->db->escape($dlat),
                            'elng' => $this->db->escape($dlng),
                            'scity' => $this->db->escape($order['pickup_city']),
                            'dcity' => $this->db->escape($order['delivery_city']),
                            'zone_id' => 1,
                            'empshift_start' => $this->db->escape($starttime),
                            'empshift_end' => $this->db->escape($endtime),
                            'trip_type' => 0,
                            'startdate' => $this->db->escape($startdate),
                            'enddate' => $this->db->escape($enddate),
                            'shipment_name' => $this->db->escape($order['product']),
                            'shipment_id' => $this->db->escape($txnid),
                            'transport_mode' => $this->db->escape($transport_mode),
                            'customer_id' => $this->db->escape($customer_id),
                            'vendor_id' => $this->db->escape($vendor_id),
                            'carrier_type' => 0,
                            'shipmentid' => $this->db->escape($shipid),
                            'txnid' => $this->db->escape($txnid),
                            'weight' => $this->db->escape($weight),
                            'volume' => $this->db->escape($volume),
                            'units' => $this->db->escape($order['quantity']),
                            'domainname' => 'INFD',
                            'vehicle_type' => $this->db->escape($vehicle_type),
                            'company_code' => $this->db->escape($order['company_code']),
                            'branch_code' => $this->db->escape($order['branch_code']),
                            'status' => 1
                        ];
                        $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                    } else {
                        $ship_id = $shipment['id'];
                    }
                    /*update order table*/
                    $upddt = [
                        'vendor_id' => $this->db->escape($vendor_id),
                        'shift_id' => $this->db->escape($ship_id),
                        "shipmentid" => $this->db->escape($shipid),
                        'status' => 2
                    ];
                    $updwhr = ["id" => $this->db->escape($order_id)];
                    $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                    $capacity = $order['weight'];
                    if ($capacity == "") {
                        $capacity = "0";
                    }
                    /*insert stops records */
                    $where = [
                        "shipment_id" => $this->db->escape($ship_id),
                        "stopcity" => $this->db->escape($order['pickup_city']),
                        "stoptype" => "P"
                    ];
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = [
                            'stopname' => $this->db->escape($order['pickup_city']),
                            'plat' => $this->db->escape($plat),
                            'plng' => $this->db->escape($plng),
                            'stopcity' => $this->db->escape($order['pickup_city']),
                            'address' => $this->db->escape($address),
                            'stoptype' => 'P',
                            'stopstatus' => 0,
                            'shipment_id' => $this->db->escape($ship_id),
                            'ordernumber' => 1,
                            'startdate' => $this->db->escape($order['pickup_datetime']),
                            'enddate' => $this->db->escape($order['pickup_endtime']),
                            'weight' => $this->db->escape($order['weight']),
                            'volume' => $this->db->escape($order['volume']),
                            'shipmentstopid' => 0,
                            'ship_units' => $this->db->escape($order['quantity']),
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $this->db->escape($curdt)
                        ];
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $pickupstop_id = $this->db->insert_id();
                    } else {
                        $pickupstop_id = $chkstop['id'];
                    }
                    $where = [
                        "shipment_id" => $this->db->escape($ship_id),
                        "stopcity" => $this->db->escape($order['delivery_city']),
                        "stoptype" => "D"
                    ];
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = [
                            'stopname' => $this->db->escape($order['delivery_city']),
                            'plat' => $this->db->escape($dlat),
                            'plng' => $this->db->escape($dlng),
                            'stopcity' => $this->db->escape($order['delivery_city']),
                            'address' => $this->db->escape($dropaddr),
                            'stoptype' => 'D',
                            'stopstatus' => 0,
                            'shipment_id' => $this->db->escape($ship_id),
                            'ordernumber' => 2,
                            'startdate' => $this->db->escape($order['delivery_datetime']),
                            'enddate' => $this->db->escape($order['drop_endtime']),
                            'weight' => $this->db->escape($order['weight']),
                            'volume' => $this->db->escape($order['volume']),
                            'shipmentstopid' => 0,
                            'ship_units' => $this->db->escape($order['quantity']),
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $this->db->escape($curdt)
                        ];
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $dropstop_id = $this->db->insert_id();
                    } else {
                        $dropstop_id = $chkstop['id'];
                    }
                    /*add pickupstop and drop stop id into details/tb_employee table */
                    $insarr = [
                        'assoc_id' => $this->db->escape($shipid),
                        'pickup' => $this->db->escape($pickup),
                        'plat' => $this->db->escape($plat),
                        'plng' => $this->db->escape($plng),
                        'drop' => $this->db->escape($delivery),
                        'dlat' => $this->db->escape($dlat),
                        'dlng' => $this->db->escape($dlng),
                        'pickup_city' => $this->db->escape($order['pickup_city']),
                        'drop_city' => $this->db->escape($order['delivery_city']),
                        'pickup_datetime' => $this->db->escape($order['pickup_datetime']),
                        'drop_datetime' => $this->db->escape($order['delivery_datetime']),
                        'name' => 'Boxes',
                        'phone' => $this->db->escape($order['customer_phone']),
                        'address' => $this->db->escape($address),
                        'emailid' => $this->db->escape($order['customer_email']),
                        'user_id' => $this->db->escape($userid),
                        'status' => 1,
                        'createdon' => $this->db->escape($curdt),
                        'material_id' => 0,
                        'capacity' => $this->db->escape($capacity),
                        'information' => $this->db->escape($order['customer_comments']),
                        'shipment_weight' => $this->db->escape($order['weight']),
                        'shipment_volume' => $this->db->escape($order['volume']),
                        'ship_type' => 'P',
                        'customer_id' => $this->db->escape($order['customer_id']),
                        'vendor_id' => $this->db->escape($vendor_id),
                        'shipment_id' => 0,
                        'startdate' => $this->db->escape($order['pickup_datetime']),
                        'enddate' => $this->db->escape($order['delivery_datetime']),
                        'shift_id' => $this->db->escape($ship_id),
                        'stop_order' => 1,
                        'drop_order' => 0,
                        'basic_stop' => 0,
                        'stop_id' => $this->db->escape($pickupstop_id),
                        'drop_stopid' => $this->db->escape($dropstop_id),
                        'order_id' => $this->db->escape($order['order_id']),
                        'pkgitemid' => 'BOXES',
                        'no_of_pkgs' => $this->db->escape($order['quantity']),
                        'domainname' => 'INFD'
                    ];
                    $where = [
                        'stop_id' => $this->db->escape($pickupstop_id),
                        'drop_stopid' => $this->db->escape($dropstop_id),
                        'order_id' => $this->db->escape($order['order_id']),
                        'shift_id' => $this->db->escape($ship_id)
                    ];
                    $select = "id";
                    $table = "tb_employee";
                    $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                    } else {
                        $detail_id = $chkemp['id'];
                        $upddetail_id = $this->common->updatetbledata(
                            "tb_employee",
                            $insarr,
                            ["id" => $this->db->escape($detail_id)]
                        );
                    }

                    $this->db->select(
                        'oc.id, oc.quantity, oc.width, oc.height, oc.length, oc.weight, im.unit_name'
                    );
                    $this->db->from('tb_order_cargodetails oc, tbl_shipunit_types im');
                    $this->db->where('oc.order_id', $sid);
                    $this->db->where('im.id = oc.handling_unit');
                    $this->db->where('oc.status', '1');
                    $stops_units = $this->db->get();

                    if ($stops_units->num_rows() > 1) {
                        $odata = $stops_units->row();
                        $upd = $this->common->updatetbledata(
                            "tb_order_cargodetails",
                            ["stop_detail_id" => $this->db->escape($detail_id)],
                            ['id' => $this->db->escape($odata->id)]
                        );
                    }
                    $vehicle_id = $driver_id = "";
                    $chk1 = $this->db->select("id")->get_where(
                        "tb_shft_veh",
                        ["shft_id" => $this->db->escape($ship_id)],
                        1,
                        0
                    );
                    if ($chk1->num_rows() > 0) {
                        $shftvehid = $chk1->row()->id;
                        $chk = $this->db->select("id")->get_where(
                            "tb_shft_veh_emp",
                            ["shft_veh_id" => $this->db->escape($shftvehid), "status" => 1],
                            1,
                            0
                        );
                        if ($chk->num_rows() == 0) {
                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where(
                                "tb_employee",
                                ["shift_id" => $this->db->escape($ship_id)]
                            );
                            if ($getemp->num_rows() > 0) {
                                $pri = 1;
                                foreach ($getemp->result() as $gt) {
                                    $insveh1 = [
                                        "user_id" => $this->db->escape($userid),
                                        "shft_veh_id" => $this->db->escape($shftvehid),
                                        "emp_id" => $this->db->escape($gt->id),
                                        "priority" => $this->db->escape($pri),
                                        "pickup_time" => $this->db->escape($gt->pickup_datetime),
                                        'created_on' => $this->db->escape($curdt),
                                        'updated_on' => $this->db->escape($curdt),
                                        "status" => 1,
                                        "drop_time" => $this->db->escape($gt->drop_datetime)
                                    ];
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    $pri++;
                                }
                            }
                        } else {
                            $chkemp = $this->db->select("id")->get_where(
                                "tb_shft_veh_emp",
                                [
                                    "shft_veh_id" => $this->db->escape($shftvehid),
                                    "emp_id" => $this->db->escape($detail_id),
                                    "status" => 1
                                ],
                                1,
                                0
                            );
                            if ($chkemp->num_rows() == 0) {
                                $insveh1 = [
                                    "user_id" => $this->db->escape($userid),
                                    "shft_veh_id" => $this->db->escape($shftvehid),
                                    "emp_id" => $this->db->escape($detail_id),
                                    "priority" => 3,
                                    "pickup_time" => $this->db->escape($order['pickup_datetime']),
                                    'created_on' => $this->db->escape($curdt),
                                    'updated_on' => $this->db->escape($curdt),
                                    "status" => 1,
                                    "drop_time" => $this->db->escape($order['delivery_datetime'])
                                ];
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                            }
                        }
                    } else {
                        $rand = mt_rand(1111111111, 9999999999);
                        $chkdriver = $this->db->select("id")->get_where(
                            "tb_truck_drivers",
                            [
                                "vendor_id" => $this->db->escape($vendor_id),
                                "status" => "Active"
                            ],
                            1,
                            0
                        );
                        if ($chkdriver->num_rows() > 0) {
                            $driver_id = $chkdriver->row()->id;
                        } else {
                            $driver = [
                                'name' => $this->db->escape($rand),
                                'password' => 'TVRJek5EVTI=',
                                'contact_num' => $this->db->escape($rand),
                                'age' => 0,
                                'driving_since' => '0',
                                'driving_licence_num' => '',
                                'company_code' => $this->db->escape($company_code),
                                'branch_code' => $this->db->escape($branch_code),
                                'city' => $this->db->escape($order['pickup_city']),
                                'createdon' => $this->db->escape($curdt),
                                'updatedon' => $this->db->escape($curdt),
                                'createdby' => $this->db->escape($userid),
                                'updatedby' => $this->db->escape($userid),
                                'user_id' => $this->db->escape($userid),
                                'vendor_id' => $this->db->escape($vendor_id),
                                'status' => 'Active'
                            ];
                            $driver_id = $this->common->insertTableData("tb_truck_drivers", $driver);
                        }
                        $vehnumchk = "SVK" . mt_rand(22222222, 99999999);
                        $chkdrive = $this->db->select("id,vehicle_id")->get_where(
                            "tb_vehicles_drivers",
                            [
                                "driver_id" => $this->db->escape($driver_id),
                                "status" => 1
                            ],
                            1,
                            0
                        );
                        if ($chkdrive->num_rows() > 0) {
                            $vehicleid = $chkdrive->row()->vehicle_id;
                            $chkvveh = $this->db->select("id")->get_where(
                                "tb_vendor_vehicles",
                                [
                                    "vendor_id" => $this->db->escape($vendor_id),
                                    "vehicle_id" => $this->db->escape($vehicleid)
                                ],
                                1,
                                0
                            );
                            if ($chkvveh->num_rows() > 0) {
                                $upd = $this->db->where(["vehicle_id" => $this->db->escape($vehicleid)])->update(
                                    "tb_vendor_vehicles",
                                    ["status" => "0"]
                                );
                                $upd = $this->db->where(["id" => $this->db->escape($chkvveh->row()->id)])->update(
                                    "tb_vendor_vehicles",
                                    ["status" => "1"]
                                );
                            } else {
                                $arr1 = [
                                    'vendor_id' => $this->db->escape($vendor_id),
                                    'vehicle_id' => $this->db->escape($vehicleid),
                                    'status' => "1"
                                ];
                                $ins = $this->common->insertTableData("tb_vendor_vehicles", $arr1);
                            }
                        } else {
                            $this->db->select('vehicle_id');
                            $this->db->from('tb_vendor_vehicles');
                            $this->db->where('vendor_id', $vendor_id);
                            $this->db->where('status', 1);
                            $subQuery = $this->db->get()->result_array();

                            $this->db->select('id, register_number');
                            $this->db->from('tb_trucks_data');
                            $this->db->where_not_in('id', $subQuery);
                            $this->db->where('user_id', $userid);
                            $this->db->where('status', 'Active');
                            $this->db->limit(1);
                            $chk = $this->db->get();

                            if ($chk->num_rows() > 0) {
                                $vehicleid = $chk->row()->id;
                                $vehnumchk = $chk->row()->register_number;
                            } else {
                                $arr = [
                                    'truck_number' => $this->db->escape($driver_id),
                                    'length' => "100",
                                    'breadth' => "100",
                                    'truck_capacity' => "100",
                                    'truck_type' => "1",
                                    'available_type' => "",
                                    'description' => "",
                                    'register_number' => $this->db->escape($vehnumchk),
                                    'insurence' => "Yes",
                                    'insuredby' => "",
                                    'insurestart' => $this->db->escape($curdt),
                                    'insureexp' => $this->db->escape($curdt),
                                    'route' => $this->db->escape($rand),
                                    'user_id' => $this->db->escape($userid),
                                    'vendor_id' => $this->db->escape($vendor_id),
                                    'createdby' => "0",
                                    'updatedby' => "0",
                                    'status' => 'Active',
                                    'createdon' => $this->db->escape($curdt),
                                    'updatedon' => $this->db->escape($curdt)
                                ];
                                $vehicleid = $this->common->insertTableData("tb_trucks_data", $arr);
                            }
                        }
                    }
                    if ($vehicle_id != "" && $driver_id != "") {
                        $chk = $this->db->select("id,driver_id,status")->order_by("id", "DESC")->get_where(
                            "tb_vehicles_drivers",
                            ["vehicle_id" => $this->db->escape($vehicle_id)]
                        );
                        if ($chk->num_rows() > 0) {
                            if ($driver_id == $chk->row()->driver_id) {
                                $upd = $this->db->where(["id" => $this->db->escape($chk->row()->id)])->update(
                                    "tb_vehicles_drivers",
                                    ["status" => 1]
                                );
                            } else {
                                $arr = [
                                    'vehicle_id' => $this->db->escape($vehicle_id),
                                    'driver_id' => $this->db->escape($driver_id),
                                    'imei' => "",
                                    'status' => 1,
                                    'createdon' => $this->db->escape($curdt),
                                    'updatedon' => $this->db->escape($curdt)
                                ];
                                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                            }
                        } else {
                            $arr = [
                                'vehicle_id' => $this->db->escape($vehicle_id),
                                'driver_id' => $this->db->escape($driver_id),
                                'imei' => "",
                                'status' => 1,
                                'createdon' => $this->db->escape($curdt),
                                'updatedon' => $this->db->escape($curdt)
                            ];
                            $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                        }
                        $chk11 = $this->db->select("id")->get_where(
                            "tbl_assigned_drivers",
                            [
                                "driver_id" => $this->db->escape($driver_id),
                                "vehicle_id" => $this->db->escape($vehicle_id)
                            ],
                            1,
                            0
                        );
                        if ($chk11->num_rows() > 0) {
                            $upd = $this->db->where(["id" => $this->db->escape($chk11->row()->id)])->update(
                                "tbl_assigned_drivers",
                                [
                                    "status" => "1",
                                    'updated_on' => $this->db->escape($curdt)
                                ]
                            );
                        } else {
                            $chk111 = $this->db->select("id")->get_where(
                                "tbl_assigned_drivers",
                                [
                                    "driver_id <>" => $this->db->escape($driver_id),
                                    "vehicle_id" => $this->db->escape($vehicle_id),
                                    "status" => 1
                                ],
                                1,
                                0
                            );
                            if ($chk111->num_rows() == 0) {
                                $ins = $this->common->insertTableData(
                                    "tbl_assigned_drivers",
                                    [
                                        "vehicle_id" => $this->db->escape($vehicle_id),
                                        "user_id" => $this->db->escape($userid),
                                        "driver_id" => $this->db->escape($driver_id),
                                        "mobile_no" => $this->db->escape($driver_id),
                                        "imei" => $this->db->escape($imei ?? ''),
                                        "from_time" => $this->db->escape($curdt),
                                        "to_time" => $this->db->escape($curdt),
                                        "status" => "1",
                                        'created_on' => $this->db->escape($curdt)
                                    ]
                                );
                            } else {
                                $upd = $this->db->where(["id" => $this->db->escape($chk111->row()->id)])->update(
                                    "tbl_assigned_drivers",
                                    [
                                        "driver_id" => $this->db->escape($driver_id),
                                        'updated_on' => $this->db->escape($curdt)
                                    ]
                                );
                            }
                        }
                    }
                    $response = 1;
                    /* update status */
                    $chk = $this->db->select("id")->get_where(
                        "tb_stop_status",
                        ["shipment_id" => $this->db->escape($ship_id), "status_id" => 9],
                        1,
                        0
                    );
                    if ($chk->num_rows() == 0) {
                        $ins = [
                            "shipment_id" => $this->db->escape($ship_id),
                            "stop_id" => 0,
                            "stop_detail_id" => 0,
                            "order_id" => $this->db->escape($order_id),
                            "stop_type" => "",
                            "trip_id" => 0,
                            "status_id" => 9,
                            "status" => 1,
                            "status_code" => "0100",
                            "reason" => "Coming from E-Booking",
                            "createdon" => $this->db->escape($curdt)
                        ];
                        $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                    }
                }
            }
        }
        return $response;
    }

    public function generateorderid($order_id, $country_code)
    {
        $year = date('y');
        $week = date('W');
        $this->db->select('order_id');
        $this->db->from('tb_orders');
        $this->db->where('id <', $order_id);
        $this->db->like('order_id', $country_code);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $getpreviousrecord = $this->db->get();

        if ($getpreviousrecord->num_rows() > 0) {
            $week_order_number = $getpreviousrecord->row()->order_id;
            $country_codelength = strlen($country_code);
            $wcount = $country_codelength + 2;
            $previous_weeknumber = mb_substr($week_order_number, $wcount, 2);
            $idlength = strlen($order_id);
            $ycount = $wcount + 2;
            $previous_ordernumber = mb_substr($week_order_number, $ycount, 5);
            $id = ltrim($previous_ordernumber, 0);
            if ($previous_weeknumber < $week) {
                $id = '0001';
            } else {
                $i_id = $id;
                $i_id++;
                $idlength = strlen($i_id);
                if ($idlength == '1') {
                    $id = "000" . $i_id;
                } elseif ($idlength == '2') {
                    $id = "00" . $i_id;
                } elseif ($idlength == '3') {
                    $id = "0" . $i_id;
                } elseif ($idlength == '4') {
                    $id = $i_id;
                } else {
                    $id = $i_id;
                }
            }
            $booking_id = $country_code . $year . $week . $id;

            $this->db->select('order_id');
            $this->db->from('tb_orders');
            $this->db->where('order_id', $booking_id);
            $chk = $this->db->get();

            if ($chk->num_rows() > 0) {
                $iid = $id;
                $iid++;
                $booking_id = $country_code . $year . $week . $iid;
            } else {
                $booking_id = $booking_id;
            }
        } else {
            $i_id = 1;
            $id = '000' . $i_id;
            $booking_id = $country_code . $year . $week . $id;
        }
        return $booking_id;
    }

    public function updateCellBackground(
        $spreadsheetId = "",
        $sheetNum = 0,
        $startRowIndex = 0,
        $endRowIndex = 0,
        $startColumnIndex = 0,
        $endColumnIndex = 0,
        $hexColor = "#152c55"
    ) {
        $client = $this->getClient();
        $service = new Google_Service_Sheets($client);

        // get sheetId of sheet with index 0
        $sheetId = $service->spreadsheets->get($spreadsheetId);
        $sheetId = $sheetId->sheets[$sheetNum]->properties->sheetId;

        list($r, $g, $b) = sscanf($hexColor, "#%02x%02x%02x");

        // define range
        $myRange = [
            'sheetId' => $sheetId, // IMPORTANT: sheetId IS NOT the sheets index but its actual ID
            'startRowIndex' => $startRowIndex,
            'endRowIndex' => $endRowIndex,
            'startColumnIndex' => $startColumnIndex, // can be omitted because default is 0
            'endColumnIndex' => $endColumnIndex,
        ];

        // define the formatting, change background colour and bold text
        $format = [
            'backgroundColor' => [
                'red' => $r,
                'green' => $g,
                'blue' => $b,
                'alpha' => 1,
            ],
            'textFormat' => [
                'bold' => true
            ]
        ];

        // build request
        $requests = [
            new Google_Service_Sheets_Request([
                                                  'repeatCell' => [
                                                      'fields' => 'userEnteredFormat.backgroundColor, userEnteredFormat.textFormat.bold',
                                                      'range' => $myRange,
                                                      'cell' => [
                                                          'userEnteredFormat' => $format,
                                                      ],
                                                  ],
                                              ])
        ];

        // add request to batchUpdate
        $batchUpdateRequest = new Google_Service_Sheets_BatchUpdateSpreadsheetRequest([
                                                                                          'requests' => $requests
                                                                                      ]);

        // run batchUpdate
        $result = $service->spreadsheets->batchUpdate($spreadsheetId, $batchUpdateRequest);
    }

    public function processExcel($data)
    {
        return true;
    }
}
