<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
require_once APPPATH . "/third_party/PHPExcel.php";

class GenerateNZConsigneeMailsLogs extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->companyCode = $this->session->userdata('company_code');
        $this->userRoleId = $this->session->userdata('user_role_id');
        if (!checkAccessConditions('CHECK_CONSIGNEE_MAIL_LOGS', $this->companyCode)) {
            $allowConsigneeMailLogs = 1;
            if ($this->userRoleId == '4') {
                $allowConsigneeMailLogs = 0;
                if (checkAccessConditions('RELATED_2_NZCONSIGNEE_MAILS', $this->session->userdata('customer_code'))) {
                    $allowConsigneeMailLogs = 1;
                }
            }
            if ($allowConsigneeMailLogs === 0) {
                redirect("Forbiddenaccess");
            }
        }
        $this->load->model("common");
    }

    public function index()
    {
        $post = $this->input->post(null, true);
        $data['page_title'] = $this->lang->line('menu_nzconsignemails');
        $data['sub_title'] = $this->lang->line('menu_nzconsignemails');
        if (!empty($post)) {
            $data['postData'] = $post;
            $fromDate = $post['fromDate'] ?: date('Y-m-d');
            $toDate = $post['toDate'] ?: date('Y-m-d');
            $module = $this->companyCode . "_ConsigneeMail";
            $where = "module= '" . $module . "' AND status ='1'";
            if ($fromDate !== "" && $toDate !== "") {
                $where .= " AND DATE(sent_on) >= '" . $fromDate . "' AND DATE(sent_on) <= '" . $toDate . "'";
            }
            if ($this->userRoleId == '4') {
                $customerId = $this->session->userdata("cust_id");
                if ($this->session->userdata('sub_cust')) {
                    $subCustomers = $this->session->userdata('sub_cust');
                    if (!empty($subCustomers)) {
                        array_push($subCustomers, $customerId);
                    } else {
                        $subCustomers = [$customerId];
                    }
                } else {
                    $subCustomers = [$customerId];
                }
                if (!empty($subCustomers)) {
                    $allCustomerCodes = [];
                    $getCustomerCodes = $this->common->gettbldata("id IN ('" . implode("','", $subCustomers) . "') AND company_code = '" . $this->companyCode . "' AND status = 1", 'code', 'tb_customers', 0, 0);
                    foreach ($getCustomerCodes as $eachCode) {
                        $allCustomerCodes[] = $eachCode['code'];
                    }
                    if (!empty($allCustomerCodes)) {
                        $where .= " AND customer_code  IN ('" . implode("','", $allCustomerCodes) . "')";
                    }
                }
            }
            $data['nzMailsData'] = $this->common->gettbldata($where, '*', 'tb_email_log', 0, 0);
        }
        $this->newtemplate->dashboard('nzmaildata', $data ?? []);
    }

    public function downloadExcel(string $fromDate = '', string $toDate = ''): void
    {
        if ($fromDate === "" && $toDate === "") {
            echo "Please Enter from and to dates to download Excel";
        } else {
            $where = "module= 'Nz Consignee Mail' AND status ='1'";
            if ($fromDate !== "" && $toDate !== "") {
                $where .= " AND DATE(sent_on) >= '" . $fromDate . "' AND DATE(sent_on) <= '" . $toDate . "'";
            }
            if ($fromDate !== "" && $toDate === "") {
                $where .= " AND DATE(sent_on) = '" . $fromDate . "'";
            }
            $getNZMails = $this->common->gettbldata($where, '*', 'tb_email_log', 0, 0);
            echo $this->db->last_query();
            if (empty($getNZMails)) {
                echo "No Mails send";
            } else {
                $this->excelSheetData($getNZMails);
            }
        }
    }

    private function excelSheetData(array $data): void
    {
        $styleArray = [
            'font' => [
                'bold' => true,
                'color' => ['rgb' => 'FFFFFF'],
                'size' => 10,
                'name' => 'Verdana',
            ]
        ];
        $objPHPExcel = new PHPExcel();
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()
            ->getStyle('A1:G1')
            ->applyFromArray(
                [
                    'fill' => [
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'color' => ['rgb' => '0c3b81']
                    ]
                ]
            );
        $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'S.No');
        $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Sent To');
        $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Sent From');
        $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Email Status');
        $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Sent Date');
        $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Subject');
        $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Message');
        $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
        $objPHPExcel->getActiveSheet()->getStyle('G1')->getAlignment()->setWrapText(true);
        $rowCount = 2;
        $id = 1;
        if (!empty($data)) {
            foreach ($data as $result) {
                $objPHPExcel->getActiveSheet()->SetCellValue('A' . $rowCount, $id);
                $objPHPExcel->getActiveSheet()->SetCellValue('B' . $rowCount, $result['sent_to']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C' . $rowCount, $result['sent_from']);
                $emailStatus = $result['email_status'];
                $statusMessage = "Fail";
                if ($emailStatus > 0) {
                    $statusMessage = "Success";
                }
                $objPHPExcel->getActiveSheet()->SetCellValue('D' . $rowCount, $statusMessage);
                $objPHPExcel->getActiveSheet()->SetCellValue('E' . $rowCount, date('Y-m-d', strtotime($result['sent_on'])));
                $objPHPExcel->getActiveSheet()->SetCellValue('F' . $rowCount, $result['subject']);
                $message = str_replace("<br>", "\n", $result['message']);
                $objPHPExcel->getActiveSheet()->getStyle('G')->getAlignment()->setWrapText(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->SetCellValue('G' . $rowCount, $message);
                $rowCount++;
                $id++;
            }
        }
        $fileName = 'NzConsigneeMailLogs' . "_" . date("Ymdhis") . '.xlsx';
        @ob_end_clean();
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $fileName . '"');
        header('Cache-Control: max-age=0');
        $objWriter = new PHPExcel_Writer_Excel2007($objPHPExcel);
        $objWriter->save('php://output');
    }
}

?>
