<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Geoprovince extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->library('form_validation');
        $this->load->model(["common", "Geoprovincemodel"]);
        if (!checkUrlAccessForUser('GEOPROVINCE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index(): void
    {
        $data["page_title"] = $this->lang->line('province_code');
        $data["sub_title"] = $this->lang->line('general_search');
        $post = $this->input->post(null, true);
        $where = $whr = $where1 = [];
        if (isset($post['searchsubmit']) && $post['searchsubmit'] == "Search") {
            $provinceId = $this->input->post('provinceId');
            $provinceName = $this->input->post('provinceName');
            $provinceIsoCode = $this->input->post('provinceIsoCode');
            if (isset($provinceId) && $provinceId != "") {
                $where['tp.province_id'] = $provinceId;
            }
            if (isset($provinceName) && $provinceName != "") {
                $where['tp.province_name'] = $provinceName;
            }
            if (isset($provinceIsoCode) && $provinceIsoCode != "") {
                $where['tp.province_iso_code'] = $provinceIsoCode;
            }
            $data['geoprovinceList'] = $this->Geoprovincemodel->getsearchdata($whr, $where);
            $this->newtemplate->dashboard("geoprovince/index", $data);
        } elseif (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $provinceId = $this->input->post('provinceId');
            $provinceName = $this->input->post('provinceName');
            $provinceIsoCode = $this->input->post('provinceIsoCode');
            $countryName = $this->input->post('countryName');
            $companyCode = $this->input->post('companyCode');
            $branchCode = $this->input->post('branchCode');
            $status = $this->input->post('status');
            if (isset($provinceId) && $provinceId != "") {
                $where1['tp.province_id'] = $provinceId;
            }
            if (isset($provinceName) && $provinceName != "") {
                $where1['tp.province_name'] = $provinceName;
            }
            if (isset($provinceIsoCode) && $provinceIsoCode != "") {
                $where1['tp.province_iso_code'] = $provinceIsoCode;
            }
            if (isset($countryName) && $countryName != "") {
                $where1['cm.country_name'] = $countryName;
            }
            if (isset($companyCode) && $companyCode != "") {
                $where1['tp.company_code'] = $companyCode;
            }
            if (isset($branchCode) && $branchCode != "") {
                $where1['tp.branch_code'] = $branchCode;
            }
            if (isset($status) && $status != "") {
                $where1['tp.status'] = $status;
                unset($whr['tp.status']);
            }
            $data['geoprovinceList'] = $this->Geoprovincemodel->getsearchdata($whr, $where1);
            $this->newtemplate->dashboard("geoprovince/index", $data);
        } else {
            $data['geoprovinceList'] = $this->Geoprovincemodel->getsearchdata($whr, $where);
            $this->newtemplate->dashboard("geoprovince/index", $data);
        }
    }

    public function add(): void
    {
        $whr = $whr1 = [];
        $countryName = $this->Geoprovincemodel->selectlist('country_code,country_name', 'tbl_country_master', $whr, 'country_name');
        $data['countryName'] = $countryName;
        $companyCode = $this->Geoprovincemodel->selectlist('id,company_code', 'tb_company_master', $whr1, 'company_code');
        $data['companyCode'] = $companyCode;
        $data["page_title"] = $this->lang->line('province_code');
        $data["sub_title"] = $this->lang->line('general_add');
        $this->newtemplate->dashboard("geoprovince/add", $data);
    }

    public function save(): void
    {
        $post = $this->input->post(null, true);
        extract($post);
        $provinceId = $provinceId ?? "";
        $provinceName = $provinceName ?? "";
        $provinceIsoCode = $provinceIsoCode ?? "";
        $countryCode = $countryName ?? "";
        $companyCode = $companyCode ?? "";
        $branchCode = $branchCode ?? "";
        $data = [
            'province_id' => $provinceId,
            'province_name' => $provinceName,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'province_iso_code' => $provinceIsoCode,
            'country_code' => $countryCode,
            'created_by' => $this->session->userdata('user_id'),
            'status' => 1
        ];
        $result = $this->common->insertTableData('tb_geo_provinces', $data);
        echo json_encode($result);
    }

    public function view($id): void
    {
        $data["page_title"] = $this->lang->line('province_code');
        $data["sub_title"] = $this->lang->line('general_view');
        $data['geoPro'] = $this->Geoprovincemodel->viewdata($id);
        $this->newtemplate->dashboard('geoprovince/view', $data);
    }

    public function edit($id): void
    {
        $data["page_title"] = $this->lang->line('province_code');
        $data["sub_title"] = $this->lang->line('general_edit');
        $whr = $whr1 = $whr2 = [];
        $countryName = $this->Geoprovincemodel->selectlist('country_code,country_name', 'tbl_country_master', $whr, 'country_name');
        $data['countryName'] = $countryName;
        $companyCode = $this->Geoprovincemodel->selectlist('id,company_code', 'tb_company_master', $whr1, 'company_code');
        $data['companyCode'] = $companyCode;
        $branchCode = $this->Geoprovincemodel->selectlist('id,branch_code', 'tb_branch_master', $whr2, 'branch_code');
        $data['branchCode'] = $branchCode;
        $data['geoPro'] = $this->Geoprovincemodel->editdata($id);
        $this->newtemplate->dashboard("geoprovince/edit", $data);
    }

    public function update(): void
    {
        $id = $this->input->post('id', true);
        if (isset($id)) {
            $post = $this->input->post(null, true);
            extract($post);
            $provinceId = $provinceId ?? "";
            $provinceName = $provinceName ?? "";
            $provinceIsoCode = $provinceIsoCode ?? "";
            $countryCode = $countryName ?? "";
            $companyCode = $companyCode ?? "";
            $branchCode = $branchCode ?? "";
            $status = $status ?? 0;
            $data = [
                'province_id' => $provinceId,
                'province_name' => $provinceName,
                'company_code' => $companyCode,
                'branch_code' => $branchCode,
                'province_iso_code' => $provinceIsoCode,
                'country_code' => $countryCode,
                'updated_by' => $this->session->userdata('user_id'),
                'status' => $status
            ];
            $whr = [
                'id' => $id
            ];
            $result = $this->common->updatetbledata('tb_geo_provinces', $data, $whr);
            echo json_encode($result);
        }
    }

    public function delete($id): void
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_geo_provinces');
            echo $result ? 1 : 0;
        }
    }

    public function checkData(): void
    {
        $post = $this->input->post(null, true);
        $provinceIsoCode = $post['province_iso_code'] ?? "";
        $id = $post['id'] ?? "";
        $provinceName = $post['province_name'] ?? "";
        $companyCode = $post['company_code'] ?? "";
        $branchCode = $post['branch_code'] ?? "";
        $where = [
            'province_iso_code' =>  $provinceIsoCode,
            'province_name' => $provinceName,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'status' => 1
        ];

        if ($id) {
            $where['id !='] = $id;
        }
        $result = $this->common->gettblrowdata($where, 'province_name', 'tb_geo_provinces', 0, 0);
        echo empty($result) ? 2 : 1;
    }

    public function fetchBranchCode(): void
    {
        $post = $this->input->post(null, true);
        $companyCode = $post['company_code'] ?? "";
        $getBranchCode = $this->Geoprovincemodel->selectBranchCodes($companyCode);
        $option = '';
        foreach ($getBranchCode as $row) {
            $option .= '<option value="' . $row['branch_code'] . '">' . $row['branch_code'] . '</option>';
        }
        $result['branches'] = $option;
        echo json_encode($result);
    }

    public function getRandomId(): void
    {
        $lastGenId = $this->Geoprovincemodel->generateRandomId();
        $generatedId = "GP" . Date('y') . date("W") . $lastGenId;
        $result['generatedId'] = $generatedId;
        echo json_encode($result);
    }

}

