<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Geotier extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();

    if ($this->session->userdata('user_id') == "") {
      redirect("login");
    }

    $this->load->model("common");
    $this->load->helper("generic");
    if (! isset($_SESSION['XL_MAX_COLS']) && ! isset($_SESSION['XL_MAX_ROWS'])) {
      $this->session->set_userdata('XL_MAX_COLS', 80);
      $this->session->set_userdata('XL_MAX_ROWS', 200);
    }
    $this->load->model("KNrategeotiermodel");
      if (!checkUrlAccessForUser('GEOTIER')) {
          redirect("Forbiddenaccess");
      }
  }

  public function index()
  {
    $data['list']       = "";
    $data['services']   = [];
    $data["sub_title"]  = $this->lang->line('general_search');
    $data["page_title"] = $this->lang->line('geo_tier');

    $where['company_code'] = $this->session->userdata('company_code');
    $where['status']       = 1;
    $select                = "*";
    $whr                   = [];
    $where1                = [
      'status'       => 1,
      'company_code' => $this->session->userdata('company_code')
    ];
    $data['veh_type']      = $this->common->gettbldata($where1, 'id, trucktype', 'tb_trucktypes', 0, 0);

    if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == 'search') {
      $from_date = $this->input->post('from_date');
      if ($from_date != '') {
        $from_date = date('Y-m-d', strtotime($from_date));
      }
      $to_date = $this->input->post('to_date');
      if ($to_date != '') {
        $to_date = date('Y-m-d', strtotime($to_date));
      }
      $tier_id = $this->input->post('tier_id');
      if ($tier_id != '') {
        $this->db->like('geo_tier_id', $tier_id);
      }
      if (! ($from_date == '' && $to_date == '')) {
        if (! ($from_date != '' && $to_date != '')) {
          $date_ = ($from_date == '') ? $to_date : $from_date;
          $this->db->where(['date(createdon)' => $date_]);
        }
      }
      if ($from_date != '' && $to_date != '') {
        $this->db->where("date(`createdon`) BETWEEN '$from_date' AND '$to_date'");
      }
      $company_code = $this->input->post('company_code');
      if ($company_code != '') {
        $this->db->like('company_code', $company_code);
        unset($where['company_code']);
      }
      $this->db->where($where);
      $this->db->from('tb_geo_tier');
      $data['list'] = $this->db->select('*')->get()->result_array();
    } elseif (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "adv_search") {
      $tier_id      = $this->input->post('tier_id');
      $company_code = $this->input->post('company_code');
      $tier_name    = $this->input->post('tier_name');
      $branch_code  = $this->input->post('branch_code');
      $vehicle_type = $this->input->post('vehicle_type');
      if ($tier_id != '') {
        $whr['geo_tier_id'] = $tier_id;
      }
      if ($company_code != '') {
        $whr['company_code'] = $company_code;
      }
      if ($tier_name != '') {
        $whr['geo_tier_name'] = $tier_name;
      }
      if ($branch_code != '') {
        $whr['branch_code'] = $branch_code;
      }
      $data["list"] = $this->get_data($select, $where, $whr);
    } else {
      $data["list"] = $this->common->gettbldata($where, '*', 'tb_geo_tier', 0, 0);
    }
    $this->newtemplate->dashboard("geotier/index", $data);
  }

  public function add()
  {
    $company_code         = $this->session->userdata('company_code');
    $branch_code          = $this->session->userdata('branch_code');
    $user_id              = $this->session->userdata('user_id');
    $data['company_code'] = $company_code;
    $data['branch_code']  = $branch_code;
    $data['user_id']      = $user_id;
    $where                = ['status' => 1];
    $data['geo_master']   = $this->common->gettbldata($where, 'id,name', 'tb_geo_master', 0, 0);
    $data["page_title"]   = $this->lang->line('geo_tier');
    $data["sub_title"]    = $this->lang->line('general_add');
    $res                  = $this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
    if ($res->num_rows() > 0) {
      foreach ($res->result() as $cur) {
        $data['currencies'][] = $cur->currency;
      }
    }
    $where1           = [
      'status'       => 1,
      'company_code' => $company_code
    ];
    $data['veh_type'] = $this->common->gettbldata($where1, '`id`, `trucktype`', 'tb_trucktypes', 0, 0);
    //$this->newtemplate->dashboard("geotier/add", $data);
    $this->load->view("geotier/add", $data);
  }

  public function edit($id)
  {
    ini_set('memory_limit', '3072M');

    $company_code         = $this->session->userdata('company_code');
    $branch_code          = $this->session->userdata('branch_code');
    $user_id              = $this->session->userdata('user_id');
    $data['company_code'] = $company_code;
    $data['branch_code']  = $branch_code;
    $data['user_id']      = $user_id;
    $where                = [
      'status' => 1
    ];
    $data['geo_master']   = $this->common->gettbldata($where, 'id,name', 'tb_geo_master', 0, 0);
    $data["page_title"]   = $this->lang->line('geo_tier');
    $data["sub_title"]    = $this->lang->line('general_edit');
    $res                  = $this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
    if ($res->num_rows() > 0) {
      foreach ($res->result() as $cur) {
        $data['currencies'][] = $cur->currency;
      }
    }
    $where1                   = [
      'status'       => 1,
      'company_code' => $company_code
    ];
    $data['veh_type']         = $this->common->gettbldata($where1, '`id`, `trucktype`', 'tb_trucktypes', 0, 0);
    $where2                   = ['id' => $id];
    $data['edit_data']        = $this->common->gettblrowdata($where2, '*', 'tb_geo_tier', 0, 0);
    $data['knratetier_sheet'] = $this->KNrategeotiermodel->get_table_data_with_orderby('*', 'tb_geo_tier_sheet', ['geo_tier_id' => $data['edit_data']['id'], 'status' => '1'], 'id,uom1_minimum,uom1_min,uom1_max ASC');

    $min_max_array        = [];
    $uom1_min_max_row_gen = [];
    $uom2_header_index    = 1;
    $row_seq              = 0;
    $knratetier_sheet     = $data['knratetier_sheet'];
    for ($i = 0; $i < sizeof($knratetier_sheet); $i++) {
      if ($i == 0) {
        $temp_list = $knratetier_sheet;
        for ($k = 0; $k < sizeof($temp_list); $k++) {
          $uom2_min  = $temp_list[$k]['uom1_min'];
          $uom2_max  = $temp_list[$k]['uom1_max'];
          $sep_point = $uom2_min . '_' . $uom2_max;
          if (! in_array($sep_point, $min_max_array)) {
            array_push($min_max_array, $sep_point);
            $uom2_header_index = $uom2_header_index + 1;
          }
        }
      }
      $uom1_min            = $knratetier_sheet[$i]['geo_from'];
      $uom1_max            = $knratetier_sheet[$i]['geo_to'];
      $sep_of_uom1_min_max = $uom1_min . '__' . $uom1_max;
      if (! in_array($sep_of_uom1_min_max, $uom1_min_max_row_gen)) {
        array_push($uom1_min_max_row_gen, $sep_of_uom1_min_max);
        $row_seq = $row_seq + 1;
      }
    }

    $col_count = $uom2_header_index;
    $this->session->set_userdata('XL_MAX_COLS', $col_count);
    $this->session->set_userdata('XL_MAX_ROWS', $row_seq);
    //$this->newtemplate->dashboard("geotier/edit", $data);
    $this->load->view("geotier/edit", $data);
  }


  public function view($id)
  {
    ini_set('memory_limit', '3072M');
    $company_code         = $this->session->userdata('company_code');
    $branch_code          = $this->session->userdata('branch_code');
    $user_id              = $this->session->userdata('user_id');
    $data['company_code'] = $company_code;
    $data['branch_code']  = $branch_code;
    $data['user_id']      = $user_id;
    $where                = ['status' => 1];
    $data["page_title"]   = $this->lang->line('geo_tier');
    $data["sub_title"]    = $this->lang->line('general_view');

    $where2                         = ['id' => $id];
    $data['edit_data']              = $this->common->gettblrowdata($where2, '*', 'tb_geo_tier', 0, 0);
    $where1                         = ['id' => $data['edit_data']['vehicle_type']];
    $data['veh_type']               = $this->common->gettblrowdata($where1, '`id`, `trucktype`', 'tb_trucktypes', 0, 0);
    $data['edit_data']['trucktype'] = isset($data['veh_type']['trucktype']) ? $data['veh_type']['trucktype'] : "";

    $data['knratetier_sheet'] = $this->KNrategeotiermodel->get_table_data_with_orderby('*', 'tb_geo_tier_sheet', ['geo_tier_id' => $data['edit_data']['id'], 'status' => '1'], 'id,uom1_minimum,uom1_min,uom1_max ASC');
    //$this->newtemplate->dashboard("geotier/view", $data);
    $this->load->view("geotier/view", $data);
  }


  public function exchangeidgen()
  {
    $year   = date('y');
    $week   = date('W');
    $gen_id = 0;
    $res    = $this->db->query("SELECT geo_tier_id FROM tb_geo_tier ORDER BY id DESC LIMIT 1");
    if ($res->num_rows() > 0) {
      $get_id   = $res->row()->geo_tier_id;
      $get_id_c = strlen($get_id);
      if ($get_id_c > 7) {
        $previous_weeknumber = substr($get_id, 4, 2);
        $get_id1             = substr($get_id, 6);
        $get_id2             = ltrim($get_id1, 0);
        if ($previous_weeknumber < $week) {
          $id1 = '0001';
        } else {
          $i_id = $get_id2;
          $i_id++;
          $idlength = strlen($i_id);
          if ($idlength == '1') {
            $id1 = "000" . $i_id;
          } elseif ($idlength == '2') {
            $id1 = "00" . $i_id;
          } elseif ($idlength == '3') {
            $id1 = "0" . $i_id;
          } elseif ($idlength == '4') {
            $id1 = $i_id;
          } else {
            $id1 = $i_id;
          }
        }
      } else {
        $id1 = '0001';
      }

      $gen_id = "GT" . $year . $week . $id1;
      $chk    = $this->db->query("select geo_tier_id FROM tb_geo_tier WHERE geo_tier_id='" . $gen_id . "'");
      if ($chk->num_rows() > 0) {
        $iid = $id1;
        $iid++;
        $ii_d      = $iid;
        $id_length = strlen($iid);
        if ($id_length == '1') {
          $ii_d = "000" . $iid;
        } elseif ($id_length == '2') {
          $ii_d = "00" . $iid;
        } elseif ($id_length == '3') {
          $ii_d = "0" . $iid;
        } elseif ($id_length == '4') {
          $ii_d = $iid;
        } else {
          $ii_d = $iid;
        }
        $gen_id = "GT" . $year . $week . $ii_d;
      } else {
        $gen_id = $gen_id;
      }
    } else {
      $i_id   = 1;
      $id1    = '000' . $i_id;
      $gen_id = "GT" . $year . $week . $id1;
    }

    return $gen_id;
  }

  public function tierinsert()
  {
    $user_id       = $this->session->userdata('user_id');
    $geo_tier_id   = $this->exchangeidgen();
    $tier_name     = $this->input->post('tier_name');
    $uom1          = $this->input->post('uom1');
    $uom1_m        = $this->input->post('uom1_m');
    $company_code  = $this->input->post('company_code');
    $curr          = $this->input->post('curr');
    $branch_code   = $this->input->post('branch_code');
    $mr_cost       = $this->input->post('mr_cost');
    $flat          = $this->input->post('flat');
    $vehicle_type  = $this->input->post('vehicle_type');
    $geo_hierarchy = $this->input->post('geo_hierarchy');
    if ($company_code == '') {
      $company_code = $this->session->userdata('company_code');
    }
    if ($branch_code == '') {
      $branch_code = $this->session->userdata('branch_code');
    }
    $tier = [
      'geo_tier_id'   => $geo_tier_id,
      'geo_tier_name' => trim($tier_name) ?: '',
      'company_code'  => isset($company_code) ? $company_code : "",
      'branch_code'   => isset($branch_code) ? $branch_code : "",
      'uom1'          => isset($uom1) ? $uom1 : "",
      'unit_measure1' => isset($uom1_m) ? $uom1_m : "",
      'currency'      => isset($curr) ? $curr : "",
      'vehicle_type'  => isset($vehicle_type) ? $vehicle_type : 0,
      'geo_hierarchy' => isset($geo_hierarchy) ? strtoupper($geo_hierarchy) : 0,
      'marginal_cost' => isset($mr_cost) ? ($mr_cost == 'on') ? '1' : '0' : '0',
      'flat'          => isset($flat) ? ($flat == 'on') ? '1' : '0' : '0',
      'user_id'       => isset($user_id) ? $user_id : 0,
      'status'        => 1
    ];
    if ($this->common->insertTableData('tb_geo_tier', $tier)) {
      $rate_tier_last_inserted_id = $this->db->insert_id();
      $min_max_prices             = [];
      for ($y = 1; $y <= 10; $y++) {
        for ($i = 1; $i <= 11; $i++) {
          $uom2_min = $uom2_max = $minimum = "";
          $uom1_min = $this->input->post('uom1_' . $y . '_min');
          $uom1_max = $this->input->post('uom1_' . $y . '_max');
          $uom1_min = trim($uom1_min);
          $uom1_max = trim($uom1_max);
          if ($i == 1) {
            $minimum = $this->input->post('minimum_1');
          } else {
            $uom2_min = $this->input->post('uom2_min_c' . $i);
            $uom2_max = $this->input->post('uom2_max_c' . $i);
          }
          $cost = $this->input->post('result_r' . $y . '_c' . $i);

          $minimum = (is_numeric($minimum) && $minimum > 0) ? $minimum : 0.001;
          if (($uom2_max > $uom2_min) && is_numeric($uom2_min) && is_numeric($uom2_max) && $uom1_min != "" && $uom1_max != "") {
            $min_max_prices[] = [
              "geo_from"     => trim($uom1_min),
              'geo_to'       => trim($uom1_max),
              'uom1_min'     => $uom2_min,
              'uom1_max'     => $uom2_max,
              "uom1_minimum" => 0,
              'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0,
              'geo_tier_id'  => $rate_tier_last_inserted_id,
              'user_id'      => $user_id,
              'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
            ];
          }
          if (is_numeric($minimum) && ($i == 1) && ! is_null($uom1_min) && ! is_null($uom1_max) && $uom1_min != "" && $uom1_max != "") {
            $min_max_prices[] = [
              "geo_from"     => trim($uom1_min),
              'geo_to'       => trim($uom1_max),
              'uom1_min'     => 0,
              'uom1_max'     => 0,
              "uom1_minimum" => $minimum,
              'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0.001,
              'geo_tier_id'  => $rate_tier_last_inserted_id,
              'user_id'      => $user_id,
              'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
            ];
          }
        }
      }

      if (sizeof($min_max_prices) > 0) {
        $this->db->insert_batch('tb_geo_tier_sheet', $min_max_prices);
        log_message('error', "table data:" . json_encode($min_max_prices));
      }
    }

    echo json_encode(
      [
        "status"  => 1,
        "message" => "Records added successfully"
      ]
    );
  }


  public function geotierupdate()
  {
    ini_set('max_execution_time', 1000);
    ini_set('memory_limit', '3072M');
    $XL_MAX_COLS = $this->session->userdata('XL_MAX_COLS');
    $XL_MAX_ROWS = $this->session->userdata('XL_MAX_ROWS');
    $user_id       = $this->session->userdata('user_id');
    $geo_tier_id   = $this->exchangeidgen();
    $tier_name     = $this->input->post('tier_name');
    $uom1          = $this->input->post('uom1');
    $uom1_m        = $this->input->post('uom1_m');
    $company_code  = $this->input->post('company_code');
    $curr          = $this->input->post('curr');
    $branch_code   = $this->input->post('branch_code');
    $mr_cost       = $this->input->post('mr_cost');
    $flat          = $this->input->post('flat');
    $vehicle_type  = $this->input->post('vehicle_type');
    $geo_hierarchy = $this->input->post('geo_hierarchy');
    $g_id          = $this->input->post('g_id');
    $ext_cols      = $this->input->post('ext_cols');
    $ext_rows      = $this->input->post('ext_rows');

    if ($company_code == '') {
      $company_code = $this->session->userdata('company_code');
    }
    if ($branch_code == '') {
      $branch_code = $this->session->userdata('branch_code');
    }
    $tier = [
      'geo_tier_name' => trim($tier_name) ?: '',
      'company_code'  => isset($company_code) ? $company_code : "",
      'branch_code'   => isset($branch_code) ? $branch_code : "",
      'uom1'          => isset($uom1) ? $uom1 : "",
      'unit_measure1' => isset($uom1_m) ? $uom1_m : "",
      'currency'      => isset($curr) ? $curr : "",
      'vehicle_type'  => isset($vehicle_type) ? $vehicle_type : 0,
      'geo_hierarchy' => isset($geo_hierarchy) ? strtoupper($geo_hierarchy) : 0,
      'marginal_cost' => isset($mr_cost) ? ($mr_cost == 'on') ? '1' : '0' : '0',
      'flat'          => isset($flat) ? ($flat == 'on') ? '1' : '0' : '0',
      'user_id'       => isset($user_id) ? $user_id : 0,
      'status'        => 1
    ];
    if ($this->common->updatetbledata('tb_geo_tier', $tier, ['id' => $g_id])) {
      $xlMaxCols = $XL_MAX_COLS;
      $xlMaxRows = $XL_MAX_ROWS;
      $min_max_prices = $up_sheet = [];
      for ($y = 1; $y <= $xlMaxRows + $ext_rows; $y++) {
        for ($i = 1; $i <= $xlMaxCols + $ext_cols + 1; $i++) {
          $uom2_min = $uom2_max = $minimum = "";
          $uom1_min = $this->input->post('uom1_' . $y . '_min');
          $uom1_max = $this->input->post('uom1_' . $y . '_max');
          $uom1_min = trim($uom1_min);
          $uom1_max = trim($uom1_max);
          if ($i == 1) {
            $minimum = $this->input->post('minimum_1');
          } else {
            $uom2_min = $this->input->post('uom2_min_c' . $i);
            $uom2_max = $this->input->post('uom2_max_c' . $i);
          }
          $cost      = $this->input->post('result_r' . $y . '_c' . $i);
          $hidden_id = $this->input->post('result_r' . $y . '_c' . $i . '_hidden_id');
          
          $minimum = (is_numeric($minimum) && $minimum > 0) ? $minimum : 0.001;
          if (is_numeric($hidden_id) && $hidden_id > 0) {
            if (($i == 1)) {
              $main_ind   = [
                "id"           => $hidden_id,
                "geo_from"     => trim($uom1_min),
                'geo_to'       => trim($uom1_max),
                'uom1_min'     => 0,
                'uom1_max'     => 0,
                "uom1_minimum" => $minimum,
                'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0.001,
                'user_id'      => $user_id,
                'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
              ];
              $up_sheet[] = $main_ind;
            } else {
              // edit.
              $up_sheet[] = [
                "id"           => $hidden_id,
                "geo_from"     => trim($uom1_min),
                'geo_to'       => trim($uom1_max),
                'uom1_min'     => $uom2_min,
                'uom1_max'     => $uom2_max,
                "uom1_minimum" => 0,
                'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0,
                'user_id'      => $user_id,
                'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
              ];
            }
          } else {
            if (($uom2_max > $uom2_min) && is_numeric($uom2_min) && is_numeric($uom2_max) && $uom1_min != "" && $uom1_max != "") {
              $min_max_prices[] = [
                "geo_from"     => trim($uom1_min),
                'geo_to'       => trim($uom1_max),
                'uom1_min'     => $uom2_min,
                'uom1_max'     => $uom2_max,
                "uom1_minimum" => 0,
                'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0,
                'geo_tier_id'  => $g_id,
                'user_id'      => $user_id,
                'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
              ];
            }
            if (is_numeric($minimum) && ($i == 1) && ! is_null($uom1_min) && ! is_null($uom1_max) && $uom1_min != "" && $uom1_max != "") {
             
              $min_max_prices[] = [
                "geo_from"     => trim($uom1_min),
                'geo_to'       => trim($uom1_max),
                'uom1_min'     => 0,
                'uom1_max'     => 0,
                "uom1_minimum" => $minimum,
                'cost'         => (is_numeric($cost) && $cost > 0) ? $cost : 0.001,
                'geo_tier_id'  => $g_id,
                'user_id'      => $user_id,
                'cost_type'    => (is_numeric($cost) && $cost > 0) ? 'entered' : 'default'
              ];
            }
          }
        }
      }
      if (! empty($up_sheet)) {
        log_message('error', 'Error Message 532 update' . json_encode($up_sheet, 128));
        $this->db->update_batch('tb_geo_tier_sheet', $up_sheet, 'id');
      }
      if (sizeof($min_max_prices) > 0) {
        log_message('error', 'Error Message 540 ins' . json_encode($min_max_prices, 128));

        $this->db->insert_batch('tb_geo_tier_sheet', $min_max_prices);
      }
    }

    echo json_encode(
      [
        "status"  => 1,
        "message" => "Records added successfully"
      ]
    );
  }


  function get_min_max_records_count()
  {
    $min_max_prices = [];
    for ($y = 1; $y <= 10; $y++) {
      for ($i = 1; $i <= 11; $i++) {
        $minimum  = $uom2_min = $uom2_max = "";
        $uom1_min = $this->input->post('uom1_' . $y . '_min');
        $uom1_max = $this->input->post('uom1_' . $y . '_max');
        if ($i == 1) {
          $minimum = $this->input->post('minimum_1');
        } else {
          $uom2_min = $this->input->post('uom2_min_c' . $i);
          $uom2_max = $this->input->post('uom2_max_c' . $i);
        }
        $cost = $this->input->post('result_r' . $y . '_c' . $i);
        if ($uom1_min != "" && $uom1_max != "" && is_numeric($uom2_min) && is_numeric($uom2_max) && is_numeric($cost)) {
          $min_max_prices[] = [

            "uom1_min" => $uom1_min,
            'uom1_max' => $uom1_max,
            'uom2_min' => $uom2_min,
            'uom2_max' => $uom2_max,
            'cost'     => $cost
          ];
        }
        if (is_numeric($minimum) && ($i == 1) && $uom1_min != "" && $uom1_max != "" && is_numeric($cost)) {
          $min_max_prices[] = [
            "geo_from"        => $uom1_min,
            'geo_to'          => $uom1_max,
            "billing_minimum" => $minimum,
            'cost'            => $cost
          ];
        }
      }
    }

    echo sizeof($min_max_prices) > 0 ? 2 : 1;
  }


  public function checkname()
  {
    $post         = $this->input->post();
    $id           = isset($post['id']) ? $post['id'] : "";
    $tier_name    = isset($post['tier_name']) ? $post['tier_name'] : 0;
    $company_code = isset($post['company_code']) ? $post['company_code'] : "";
    $where        = [
      'geo_tier_name' => $tier_name,
      'company_code'  => $company_code
    ];
    if ($id) {
      $where['id !='] = $id;
    }
    $get_data = $this->common->gettblrowdata($where, 'geo_tier_name', 'tb_geo_tier', 0, 0);
    echo empty($get_data) ? 2 : 1;
  }

  public function generate_drop_down()
  {
    $type = $this->input->post('type');
    $this->load->helper('drop_down_helper');
    $response = get_measurement_units($type, 'SELECT');
    echo $response;
  }

  public function delete($id)
  {
    $result = $this->common->updatetbledata('tb_geo_tier', ['status' => 0], ['id' => $id]);
    echo $result ? 1 : 0;
  }

  public function get_data($select, $where, $whr)
  {
    $this->db->select($select);
    $this->db->where($where);
    $this->db->like($whr);
    $this->db->from('tb_geo_tier');
    $this->db->order_by('id', 'DESC');
    $res = $this->db->get();

    return $res->result_array();
  }

  public function getNewRow()
  {
    $row_id  = $this->input->post('row_id');
    $no_cols = $this->input->post('no_cols');
    $data    = ['row_id' => $row_id, 'no_cols' => $no_cols];
    $this->load->view('geotier/new_row', $data);
  }
  public function deletegeotier(): void
  {
	  if($_SERVER['REQUEST_METHOD'] === 'POST') {
		  $deleterecorids = implode(",",$this->input->post('deleteids'));
		  $query = $this->db->query("delete from tb_geo_tier WHERE id IN ($deleterecorids)");
		  $query2 = $this->db->query("delete from tb_geo_tier_sheet WHERE geo_tier_id IN ($deleterecorids)");
		  echo ($query && $query2) ? "success" : "failed";
	  }
  }
}
