<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
class Getintouch extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        header('Access-Control-Allow-Origin: *');
    }

    public function moonshot()
    {
        $response = $this->output
            ->set_content_type('application/json')
            ->set_status_header(400);

        if ($this->input->method() !== 'post') {
            return $response->set_output(
                json_encode([
                    'status' => 'error',
                    'message' => 'Incorrect request method. Only POST allowed.'
                ])
            );
        }

        $requiredFields = [
            'firstName' => 'first_name',
            'lastName' => 'last_name',
            'email' => 'email',
            'industry' => 'industry',
            'country' => 'country',
            'company' => 'company',
            'jobTitle' => 'job_title',
            'type' => 'type'
        ];

        $post = $this->input->post(null, true);

        // Check if all required fields are present.
        $errors = [];
        foreach ($requiredFields as $postField => $dbColumn) {
            if (!in_array($postField, array_keys($post))) {
                $errors[] = $postField;
            } elseif (empty($post[$postField])) {
                $errors[] = $postField;
            } elseif ($postField === 'type') {
                if (!in_array($post[$postField], ['MS_Early_Access', 'MS_download'])) {
                    $errors[] = $postField;
                }
            }
        }

        if (!empty($errors)) {
            return $response->set_output(
                json_encode([
                    'status' => 'error',
                    'message' => 'Some required fields are missing (' . implode(', ', $errors) . ').'
                ])
            );
        }

        // Populate $data array with correct columns and values.
        $data = [];
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';

        foreach ($requiredFields as $key => $value) {
            $data[$value] = $post[$key];
        }

        $this->db->insert("tb_etn_alerts", $data);

        $this->sendEmail($data, 'contact.visibility@kuehne-nagel.com');

        return $response->set_status_header(200);
    }

    /**
     * Send out an alert email
     *
     * @param array $data
     * @return bool
     */
    private function sendAlertEmail(array $data, $receiver = null): bool
    {
        $emails = $this->db->where(["country_code" => $data['country'], "status" => "1"])->get("tb_etn_alert_settings");
        if ($emails->num_rows() === 0) {
            return false;
        }

        foreach ($emails->result() as $email) {
            if (empty($email->email_id)) {
                continue;
            }

            $this->sendEmail($data, $email->email_id);
        }

        return true;
    }

    private function sendEmail($data, $email): void
    {
        $hasPhone = $post['phone'] ?? $post['mobileNumber'] ?? false;

        $message = "Dear admin,<br>" .
            "A new user is tried to contact us, here are the details<br>" .
            "<table>" .
            "<tr>" .
            "<th>First name</th>" .
            "<th>Last name</th>" .
            "<th>Email</th>" .
            ($hasPhone ? "<th>Phone</th>" : "").
            "<th>Company</th>" .
            "<th>Country</th>" .
            "<th>Message</th>" .
            "</tr>" .
            "<tr>" .
            "<td>" . $data["first_name"] . "</td>" .
            "<td>" . $data["last_name"] . "</td>" .
            "<td>" . $data["email"] . "</td>" .
            ($hasPhone ? "<td>".$hasPhone."</td>" : "").
            "<td>" . $data["company"] . "</td>" .
            "<td>" . $data["country"] . "</td>" .
            "<td>" . $data["message"] . "</td>" .
            "</tr>" .
            "</table>" .
            "<br>" .
            "Thanks,<br>" .
            "Svkonekt";
        $this->load->library('email');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to($email);
        $this->email->set_mailtype("html");
        $this->email->subject('Svkonekt | New user tried to contact us');
        $this->email->message($message);
        $this->email->send();
    }

    public function contact_us_save()
    {
        $post = $this->input->post(null, true);
        $data["first_name"] = isset($post["firstName"]) ? $post["firstName"] : "";
        $data["last_name"] = isset($post["lastName"]) ? $post["lastName"] : "";
        $data["email"] = isset($post["email"]) ? $post["email"] : "";
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';
        $data["company"] = isset($post["company"]) ? $post["company"] : "";
        $data["job_title"] = isset($post["jobTitle"]) ? $post["jobTitle"] : "";
        $data["industry"] = isset($post["industry"]) ? $post["industry"] : "";
        $data["country"] = isset($post["country"]) ? $post["country"] : "";
        $data["message"] = isset($post["message"]) ? $post["message"] : "";
        $data["subscribe"] = isset($post["subscribe"]) ? $post["subscribe"] : "";
        $data["type"] = "contact_us";
        $ins = $this->db->insert("tb_etn_alerts",$data);

        $this->sendAlertEmail($data);
    }

    public function demo_save() {
        $post = $this->input->post(null, true);
        $data["first_name"] = isset($post["firstName"]) ? $post["firstName"] : "";
        $data["last_name"] = isset($post["lastName"]) ? $post["lastName"] : "";
        $data["email"] = isset($post["email"]) ? $post["email"] : "";
        $data["industry"] = isset($post["industry"]) ? $post["industry"] : "";
        $data["country"] = isset($post["country"]) ? $post["country"] : "";
        $data["message"] = isset($post["message"]) ? $post["message"] : "";
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';
        $data["company"] = isset($post["company"]) ? $post["company"] : "";
        $data["job_title"] = isset($post["jobTitle"]) ? $post["jobTitle"] : "";
        $data["type"] = "demo";
        $data["subscribe"] = isset($post["subscribe"]) ? $post["subscribe"] : "";
        $ins = $this->db->insert("tb_etn_alerts", $data);

        $this->sendAlertEmail($data);
    }

    public function carrier()
    {
        $post = $this->input->post(null, true);
        $data["first_name"] = isset($post["firstName"]) ? $post["firstName"] : "";
        $data["last_name"] = isset($post["lastName"]) ? $post["lastName"] : "";
        $data["email"] = isset($post["email"]) ? $post["email"] : "";
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';
        $data["country"] = isset($post["country"]) ? $post["country"] : "";
        $data["company"] = isset($post["company"]) ? $post["company"] : "";
        $data["registration_number"] = isset($post["registrationNumber"]) ? $post["registrationNumber"] : "";
        $data["type"] = "carrier";
        $ins = $this->db->insert("tb_etn_alerts", $data);

        $this->sendAlertEmail($data);
    }

    public function ebook_download()
    {
        $post = $this->input->post(null, true);
        $data["first_name"] = isset($post["firstName"]) ? $post["firstName"] : "";
        $data["last_name"] = isset($post["lastName"]) ? $post["lastName"] : "";
        $data["email"] = isset($post["email"]) ? $post["email"] : "";
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';
        $data["company"] = isset($post["company"]) ? $post["company"] : "";
        $data["job_title"] = isset($post["jobTitle"]) ? $post["jobTitle"] : "";
        $data["industry"] = isset($post["industry"]) ? $post["industry"] : "";
        $data["country"] = isset($post["country"]) ? $post["country"] : "";
        $data["message"] = isset($post["message"]) ? $post["message"] : "";
        $data["type"] = "ebook_download";
        $data["subscribe"] = isset($post["subscribe"]) ? $post["subscribe"] : "";
        $ins = $this->db->insert("tb_etn_alerts",$data);
    }

    public function checklist_download() {
        $post = $this->input->post(null, true);
        $data["first_name"] = isset($post["firstName"]) ? $post["firstName"] : "";
        $data["last_name"] = isset($post["lastName"]) ? $post["lastName"] : "";
        $data["email"] = isset($post["email"]) ? $post["email"] : "";
        $data["phone"] = $post['phone'] ?? $post['mobileNumber'] ?? '';
        $data["company"] = isset($post["company"]) ? $post["company"] : "";
        $data["job_title"] = isset($post["jobTitle"]) ? $post["jobTitle"] : "";
        $data["industry"] = isset($post["industry"]) ? $post["industry"] : "";
        $data["country"] = isset($post["country"]) ? $post["country"] : "";
        $data["message"] = isset($post["message"]) ? $post["message"] : "";
        $data["type"] = "checklist_download";
        $data["subscribe"] = isset($post["subscribe"]) ? $post["subscribe"] : "";
        $ins = $this->db->insert("tb_etn_alerts",$data);
    }
}
