<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Class Go99
 *
 * @property Reportmodel $reportmodel
 * @property CI_Input $input
 * @property CI_Loader $load
 * @property CI_DB_mysqli_driver $db
 * @property Settemplate $settemplate
 * @property CI_Router $router
 * @property CI_Session $session
 */
class Go99 extends CI_Controller
{
    private const KPI_TARGET_LOGGED_IN_SINCE = 'kpi_target_logged_in_since';
    private const KPI_TARGET_COUNTRIES = ['AU','CN','ID','IN','MY','NZ','PH','SG','TH','TW','VN','FR','KHKN','PK','UK'];

    public function __construct()
    {
        parent::__construct();
        $this->load->model(['reportmodel', 'common']);
    }

    public function index()
    {
        //Bypass svkonekt login for now. Since we don't want to use that
        if (!$this->isAllowedToAccess()) {
            $this->load->view('kpitargets/login');
            return;
        }

        $data = $this->getTargetMetaInfo(date('Y-01-01'), date('Y-12-31'));

        $data['row_result'] = [];
        $countryTargets = $this->reportmodel->countryalldata(self::KPI_TARGET_COUNTRIES);
        foreach ($countryTargets as $countryTarget) {
            $final_res = $this->getAnnualShipmentTargetProcess($countryTarget);
            $data['row_result'][] = $final_res;
            $data['shipment_count'] += $final_res['row_total'];
        }

        $this->settemplate->dashboardtemp("kpitargets/newshipment_go", $data);
    }

    public function getyeardata()
    {
        if (!$this->isAllowedToAccess()) {
            $this->load->view('kpitargets/login');
            return;
        }
        $year = isset($_POST['year']) ? (int)$_POST['year'] : "";
        $saasOnly = isset($_POST['saas']) ? $_POST['saas'] = '1' : null;

        if ($year == "") {
            $year = date('Y');
        }

        $current_year = date('Y');

        if ($saasOnly === '1') {
            $dataByCountry = $this->reportmodel->dataByCountry($year, [1402]); //(int)1402 is the UNIQLO customer numer
            $dataByCustomer = $this->reportmodel->dataByCustomer($year, [1402]);

            $contents['viewdataCountry'] = $dataByCountry;
            $contents['viewdataCustomer'] = $dataByCustomer;
            $contents['sumCountry'] = $this->sumTotals($dataByCountry);
            $contents['sumCustomer'] = $this->sumTotals($dataByCustomer);
            $contents['sumCountry']['Country'] = '';
            $contents['sumCustomer']['Customer'] = '';
            $contents['year'] = $year;

            echo $this->load->view("kpitargets/yeardata_saas", $contents, TRUE);
        }
        else if ($current_year == $year && $saasOnly === false) {
            $data = $this->getCurrentYearOrdersTargets($year);
            echo $this->load->view("kpitargets/newyeardata", $data, TRUE);
        }
        else {
            $data = $this->getPrevYearOrdersTargets($year);
            if ($year > 2022) {
                echo $this->load->view("kpitargets/newyeardata", $data, true);
            } else {
                echo $this->load->view("kpitargets/yeardata", $data, true);
            }
        }
    }

    /**
     * @param $year
     * @return array
     */
    private function getPrevYearOrdersTargets($year): array
    {
        $startdate = date('Y-m-d', strtotime($year . "-01-01"));
        $endDate   = date('Y-m-d', strtotime($year . "-12-31"));
        $data = $this->getTargetMetaInfo($startdate, $endDate);
        $data['year'] = $year;
        $rrr = [];
        if ($year > 2022) {
            $countryalldata = $this->reportmodel->countryalldata(self::KPI_TARGET_COUNTRIES);
        } else {
            $countryalldata = $this->reportmodel->countryalldata();
        }
        foreach ($countryalldata as $res) {
            $final_res['country_name'] = $res['country_name'];
            $country = $res['country_code'];
            $final_res['country'] = $country;
            $final_res['target'] = $res['annual_shipment_target'];
            $row_total = 0;
            $month = 13;
            for ($i = 1; $i < 13; $i++) {
                $days = '31';
                $start_date = date('Y-m-d', mktime(0, 0, 0, $month - $i, 1, $year));
                $mnth = $month - $i;
                if ($mnth == '2') {
                    $days = '28';
                } else if (in_array($mnth, ['4', '6', '9', '11'])) {
                    $days = '30';
                }
                $end_date = date('Y-m-d', mktime(0, 0, 0, $month - $i, $days, $year));
                $monthsdata = $this->reportmodel->monthdata($start_date, $end_date, $country);
                $final_res[$month - $i] = $monthsdata;
                $row_total = $row_total + $monthsdata;
            }
            $final_res['row_total'] = $row_total;
            $data['shipment_count'] += $final_res['row_total'];
            $rrr[] = $final_res;
        }
        $data['row_result'] = $rrr;

        return $data;

    }

    /**
     * @param $year
     * @return array
     */
    private function getCurrentYearOrdersTargets($year): array
    {
        $startDate = date('Y-m-d', strtotime($year . '-01-01'));
        $endDate = date('Y-m-d', strtotime($year . '-12-31'));
        $data = $this->getTargetMetaInfo($startDate, $endDate);

        $data['year'] = $year;
        $countryTargets = $this->reportmodel->countryalldata(self::KPI_TARGET_COUNTRIES);
        $data['row_result'] = [];
        foreach ($countryTargets as $res) {
            $final_res = $this->getAnnualShipmentTargetProcess($res);
            $data['row_result'][] = $final_res;
            $data['shipment_count'] += $final_res['row_total'];
        }

        return $data;
    }

    /**
     * @param $result
     * @return array
     */
    private function getAnnualShipmentTargetProcess(array $result): array
    {
        if ($result['country_code'] === 'RU') {
            $targetProcess = $this->getRussianAnnualShipmentTargetValue();
//            ['country_name'] => 'РОССИЯ' ['country'] => 'RU' ['target'] => '5000' [9] => 1494 [8] => 4 [7] => 3 [6] => 21 [5] => 0 [4] => 1 [3] => 4050 [2] => 3428 [1] => 2619 [row_total] => 11620
        } else {
            $targetProcess = $this->getGlobalAnnualShipmentTargetValue($result['country_code']);
        }

        return [
            'country_name' => $result['country_name'],
            'country' => $result['country_code'],
            'target' => $result['annual_shipment_target'],
        ] + $targetProcess;
    }

    private function getRussianAnnualShipmentTargetValue(): array
    {
        $target = $this->getGlobalAnnualShipmentTargetValue('RU');
        $target[1] = 2786;
        $target[2] = 3428;
        $target[3] = 3775;
        $target[4] = 3607;
        $target[5] = 2854;
        $target[6] = 3031;
        $target[7] = 3560;
        $target[8] = 3560;

        $target['row_total'] = 0;
        foreach (range(1, 12) as $month) {
            if(!empty($target[$month])) {
                $target['row_total'] += $target[$month];
            }
        }

        return $target;
    }

    private function getGlobalAnnualShipmentTargetValue(string $country): array
    {
        $final_result = [];
        $month = date('n');
        $row_total = 0;
        for ($i = 0; $i < date('n'); $i++) {
            $timestamp = mktime(0, 0, 0, date('n') - $i, 1);
            $start_date = date('Y-m-01', $timestamp);
            $end_date = date('Y-m-t', $timestamp);
            $monthsdata = $this->reportmodel->monthdata($start_date, $end_date, $country);
            $final_result[$month] = $monthsdata;
            $month = $month - 1;
            $row_total = $row_total + $monthsdata;
        }

        $final_result['row_total'] = $row_total;

        return $final_result;
    }

    /**
     * Don't add new user in the list, without approval of Amit Sethi.
     * When you want tot creata a new password, use the default password
     * function of php. With the default password option
     * `password_hash('test', PASSWORD_DEFAULT);`
     *
     */

    private function isAllowedToAccess(): bool
    {
        if ($this->isLoggedInKpi()) {
            return true;
        }
        if ((!$this->input->post('username') || !$this->input->post('password'))) {
            return false;
        }
        $username = strtolower(trim($this->input->post('username')));
        $getPassword = $this->common->gettblrowdata(['user_id' => $username, 'status' => 1], 'password', 'go99_users', 0, 0);
        if (empty($getPassword)) {
            return false;
        }
        $password = $getPassword['password'];
        if (!password_verify($this->input->post('password'), $password)) {
            return false;
        }
        $this->loginKpi();
        return true;
    }

    private function sumTotals(array $dataByCustomer)
    {
        $acc = array_shift($dataByCustomer);
        foreach ($dataByCustomer as $val) {
            foreach ($val as $key => $val) {
                if($key !== 'Customer' && $key !== 'Country') {
                    $acc[$key] += $val;
                }
                else {
                    $acc[$key] = '';
                }
            }
        }
        return $acc;
    }

    /**
     * @param string $startDate
     * @param string $endDate
     * @return string[]
     */
    private function getTargetMetaInfo(string $startDate, string $endDate): array
    {
        return [
            'page_title' => "Svkonekt KPI Targets",
            'sub_title' => "KPI Targets",
            'shipment_count' => 0,
        ];
    }

    private function loginKpi(): void
    {
        $this->session->{self::KPI_TARGET_LOGGED_IN_SINCE} = new DateTime();
    }

    /**
     * @return bool
     */
    private function isLoggedInKpi(): bool
    {
        return $this->session->{self::KPI_TARGET_LOGGED_IN_SINCE} > new DateTime('-15 minutes');
    }
}
