<?php

defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: application/json');

/**
 * @property CI_Loader $load
 * @property Common $common
 * @property CI_Session $session
 * @property CI_DB_mysqli_driver $db
 * @property CI_Lang $lang
 * @property CI_Cache $cache
 */
class Gpstracker extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->driver('cache', ['adapter' => 'apc', 'backup' => 'file']);
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');
        }
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD'])) {
                header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
            }

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS'])) {
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
            }
        }
        $post = json_decode(file_get_contents("php://input"), true);
        $this->load->helper('date');
        $this->load->model(['common','DeliveryDocumentModel']);
    }

    public function trackerdatatest()
    {
        $data = $this->input->post();

        if (isset($data["latitude"])) {
            $tinput = [];
            $tinput["mobileimei"] = $this->db->escape($data['imei']);
            $tinput["timestamp"] = date("Y-m-d H:i:s");
            $tinput["latitude"] = $this->db->escape($data["latitude"]);
            $tinput["longitude"] = $this->db->escape($data["longitude"]);
            $tinput["accuracy"] = $this->db->escape($data["accuracy"]);
            $tinput["bearing"] = $this->db->escape($data["bearing"]);
            $tinput["battery"] = isset($data["battery"]) ? $this->db->escape($data["battery"]) : null;
            $tinput["vehicle_id"] = isset($data["vehicle_id"]) ? $this->db->escape($data["vehicle_id"]) : "0";
            if ($tinput["vehicle_id"] == "") {
                $tinput["vehicle_id"] = "0";
            }
            $tinput["driver_id"] = isset($data["driver_id"]) ? $this->db->escape($data["driver_id"]) : "0";
            if ($tinput["driver_id"] == "") {
                $tinput["driver_id"] = "0";
            }
            $tinput["trip_id"] = isset($data["trip_id"]) ? $this->db->escape($data["trip_id"]) : "0";
            if ($tinput["trip_id"] == "") {
                $tinput["trip_id"] = "0";
            }
            if ($data["speed"] == "") {
                $data["speed"] = 0;
            }
            $tinput["speed"] = $this->db->escape($data["speed"]);
            $this->db->insert("tb_rtdrive_locations", $tinput);
        }
    }

    private function checkRateLimit($data): bool
    {
        if (microtime(true) - $this->cache->get($data['imei']) > 20) {
            $this->cache->save($data['imei'], microtime(true), 120);
            return true;
        }
        return false;
    }

    public function trackerData()
    {
        $input = $this->input->post();
        try {
            if (isset($input["data"])) {
                $data = $input["data"];
                $data = json_decode($data, true);
                if ($this->checkRateLimit($data)) {
                    if (isset($data["latitude"])) {
                        $tinput = $res = [];
                        $logdate = date("Y-m-d H:i:s", $data["time"] / 1000);
                        $tinput["mobileimei"] = $res['mobileimei'] = $data['imei'];
                        $tinput["timestamp"] = $res['timestamp'] = $logdate;
                        $tinput["latitude"] = $data["latitude"];
                        $tinput["longitude"] = $data["longitude"];
                        $tinput["accuracy"] = $data["accuracy"];
                        $tinput["bearing"] = $data["bearing"];
                        $tinput["battery"] = $data["battery"] ?? null;
                        $tinput["vehicle_id"] = $data["vehicle_id"] ?? "0";
                        if ($tinput["vehicle_id"] == "") {
                            $tinput["vehicle_id"] = "0";
                        }
                        $tinput["driver_id"] = $data["driver_id"] ?? "0";
                        if ($tinput["driver_id"] == "") {
                            $tinput["driver_id"] = "0";
                        }
                        $tinput["trip_id"] = $data["trip_id"] ?? "0";
                        if ($tinput["trip_id"] == "") {
                            $tinput["trip_id"] = "0";
                        }
                        if ($data["speed"] == "") {
                            $data["speed"] = 0;
                        }
                        $tinput["speed"] = ($data["speed"] * 3.6);
                        $this->db->insert("tb_rtdrive_locations", $tinput);
                        /*update in vehicle table*/
                        if ($tinput["vehicle_id"] != "") {
                            $vehwhr = ["id" => $tinput["vehicle_id"]];
                            $vehset = [
                                "imei" => $tinput["mobileimei"],
                                "latitude" => $tinput["latitude"],
                                "longitude" => $tinput["longitude"],
                                "speed" => $tinput["speed"],
                                "battery" => $tinput["battery"],
                                "bearing" => $tinput["bearing"],
                                "receivedon" => $tinput['timestamp'],
                            ];
                            $this->db->where($vehwhr)->update("tb_trucks_data", $vehset);
                        }
                        if ($tinput["speed"] > 60) {
                            $tinput['rcvtime'] = $logdate;
                            $this->sendOverSpeed($tinput);
                        }
                        $json_data = ["locationresponse" => $res];
                        $json = json_encode($json_data);
                    } elseif (count($data) > 0) {
                        foreach ($data as $record) {
                            $res = [];
                            $logdate = date("Y-m-d H:i:s", $record["time"] / 1000);
                            $trecord["mobileimei"] = $res['mobileimei'] = $record['imei'];
                            $trecord["timestamp"] = $res["timestamp"] = $logdate;
                            $trecord["latitude"] = $record["latitude"];
                            $trecord["longitude"] = $record["longitude"];
                            $trecord["accuracy"] = $record["accuracy"];
                            $trecord["bearing"] = $record["bearing"];
                            $trecord["battery"] = $record["battery"] ?? null;
                            $trecord["vehicle_id"] = $record["vehicle_id"] ?? "0";
                            if ($trecord["vehicle_id"] == "") {
                                $trecord["vehicle_id"] = "0";
                            }
                            $trecord["driver_id"] = $record["driver_id"] ?? "0";
                            if ($trecord["driver_id"] == "") {
                                $trecord["driver_id"] = "0";
                            }
                            $trecord["trip_id"] = $record["trip_id"] ?? "0";
                            if ($trecord["trip_id"] == "") {
                                $trecord["trip_id"] = "0";
                            }
                            if ($record["speed"] == "") {
                                $record["speed"] = 0;
                            }
                            $trecord["speed"] = ($record["speed"] * 3.6);
                            $q = $this->db->select("latitude,longitude,receivedon")->get_where(
                                "tb_trucks_data",
                                ["id" => $trecord["vehicle_id"]],
                                1,
                                0
                            );
                            $time = $lat = $lng = "";
                            if (isset($trecord['rcvtime'])) {
                                unset($trecord['rcvtime']);
                            }
                            if ($q->num_rows() > 0) {
                                $time = $q->row()->receivedon;
                                $lat = $q->row()->latitude;
                                $lng = $q->row()->longitude;
                                $mt = calculateDistance12(
                                        $lat,
                                        $lng,
                                        $trecord["latitude"],
                                        $trecord["longitude"]
                                    ) * 1000;
                                $diff = round(abs(strtotime($res["timestamp"]) - strtotime($time)), 2);
                                if ($diff * 35 >= $mt) {
                                    $this->db->insert("tb_rtdrive_locations", $trecord);
                                    /*update in vehicle table*/
                                    if ($trecord["vehicle_id"] != "") {
                                        $vehwhr = ["id" => $trecord["vehicle_id"]];
                                        $vehset = [
                                            "imei" => $trecord["mobileimei"],
                                            "latitude" => $trecord["latitude"],
                                            "longitude" => $trecord["longitude"],
                                            "speed" => $trecord["speed"],
                                            "battery" => $trecord["battery"],
                                            "bearing" => $trecord["bearing"],
                                            "receivedon" => $trecord['timestamp'],
                                        ];
                                        $this->db->where($vehwhr)->update("tb_trucks_data", $vehset);
                                    }
                                    if ($trecord["speed"] > 60) {
                                        $trecord['rcvtime'] = $logdate;
                                        $this->sendOverSpeed($trecord);
                                    }
                                    $json_data = ["locationresponse" => $res];
                                    $json = json_encode($json_data);
                                } else {
                                    $json = json_encode([]);
                                }
                            } else {
                                $this->db->insert("tb_rtdrive_locations", $trecord);
                                /*update in vehicle table*/
                                if ($trecord["vehicle_id"] != "") {
                                    $vehwhr = ["id" => $trecord["vehicle_id"]];
                                    $vehset = [
                                        "imei" => $trecord["mobileimei"],
                                        "latitude" => $trecord["latitude"],
                                        "longitude" => $trecord["longitude"],
                                        "speed" => $trecord["speed"],
                                        "battery" => $trecord["battery"],
                                        "bearing" => $trecord["bearing"],
                                        "receivedon" => $trecord['timestamp'],
                                    ];
                                    $this->db->where($vehwhr)->update("tb_trucks_data", $vehset);
                                }
                                if ($trecord["speed"] > 60) {
                                    $trecord['rcvtime'] = $logdate;
                                    $this->sendOverSpeed($trecord);
                                }
                                $json_data = ["locationresponse" => $res];
                                $json = json_encode($json_data);
                            }
                        }
                        echo $json;
                    } else {
                        echo "Not Array";
                    }
                } else {
                    echo "Rate limit exceeded";
                }
            } else {
                echo "Not Array";
            }
        } catch (Exception $e) {
            echo "Not Array";
        }
    }

    public function sendOverSpeed($arrindex)
    {
        if ($arrindex["accuracy"] < 200) {
            $this->db->select("receivedon");
            $this->db->where("mobileimei", $arrindex["mobileimei"]);
            $this->db->from("tb_over_speed");
            $this->db->order_by("receivedon", "desc");
            $this->db->limit("1");
            $prev = $this->db->get();
            $uid = 0;
            $chusr = $this->db->select("user_id")->get_where(
                "tb_trucks_data",
                ["id" => $this->db->escape($arrindex['vehicle_id'])],
                1,
                0
            );
            if ($chusr->num_rows() > 0) {
                $uid = $chusr->row()->user_id;
            }
            if ($prev->num_rows() > 0) {
                $t = $prev->row()->receivedon;
                $d = round(abs(strtotime($arrindex["timestamp"]) - strtotime($t)) / 60, 2);
                $chkqry = $this->db->select("overspeed_interval,speedlimit")->get_where(
                    "tb_alert_settings",
                    [
                        "user_id" => $this->db->escape($uid),
                        "status" => 1
                    ],
                    1,
                    0
                );
                if ($chkqry->num_rows() > 0) {
                    $timeint = $chkqry->row()->overspeed_interval;
                    $speedlimit = $chkqry->row()->speedlimit;
                    if (($d >= $timeint) && ($arrindex['speed'] > $speedlimit)) {
                        $arrindex["receivedon"] = $arrindex["timestamp"];
                        $j = $arrindex["rcvtime"];
                        unset($arrindex["rcvtime"]);
                        unset($arrindex["timestamp"]);
                        $this->db->insert("tb_over_speed", $arrindex);
                        $arrindex['speed_id'] = $this->db->insert_id();
                        $arrindex['rcvtime'] = $j;
                        $this->sendOverSpeedMail($arrindex);
                    }
                }
            } else {
                $chkqry = $this->db->select("overspeed_interval,speedlimit")->get_where(
                    "tb_alert_settings",
                    [
                        "user_id" => $this->db->escape($uid),
                        "status" => 1
                    ],
                    1,
                    0
                );
                if ($chkqry->num_rows() > 0) {
                    $speedlimit = $chkqry->row()->speedlimit;
                    if ($arrindex['speed'] > $speedlimit) {
                        $arrindex["receivedon"] = $arrindex["timestamp"];
                        $j = $arrindex["rcvtime"];
                        unset($arrindex["rcvtime"]);
                        unset($arrindex["timestamp"]);
                        $ins = $this->db->insert("tb_over_speed", $arrindex);
                        $arrindex['speed_id'] = $this->db->insert_id();
                        $arrindex['rcvtime'] = $j;
                        $this->sendOverSpeedMail($arrindex);
                    }
                }
            }
        }
    }

    public function sendOverSpeedMail($arrindex)
    {
        $this->db->select("t.register_number, d.name, d.contact_num, d.user_id");
        $this->db->from("tb_truck_drivers d, tbl_assigned_drivers a, tb_trucks_data t ");
        $this->db->where("a.imei", $arrindex["mobileimei"]);
        $this->db->where("d.status", "Active");
        $this->db->where("a.driver_id = d.id");
        $this->db->where("a.status", 1);
        $this->db->where("t.id = a.vehicle_id");
        $this->db->limit(1);
        $dr = $this->db->get();

        if ($dr->num_rows() > 0) {
            $kms = $arrindex['speed'];
            $row = $dr->row();
            $txt = "";
            $tm = $arrindex['rcvtime'];
            $uid = $row->user_id;
            $tripid = $arrindex['trip_id'] ?? 0;
            $mobileimei = $arrindex['mobileimei'] ?? 0;
            $speed_id = $arrindex['speed_id'] ?? 0;
            if ($tripid == "") {
                $tripid = 0;
            }
            $txt .= "<tr><td>" . $row->name . "</td><td>" . $row->contact_num . "</td><td>" . $row->register_number . "</td><td>" . getLocationname(
                    $arrindex['latitude'],
                    $arrindex['longitude']
                ) . "</td><td>" . $kms . " KM</td><td>" . $tm . "</td></tr>";
            $insdata = [
                'emp_id' => 0,
                'trip_id' => $this->db->escape($tripid),
                'mobile' => $this->db->escape($mobileimei),
                'module' => "Speed",
                'message' => $this->db->escape($txt),
                'user_id' => $this->db->escape($uid),
                'speed_id' => $this->db->escape($speed_id)
            ];
            $inse = $this->db->insert("tb_trip_alerts", $insdata);
            $this->sendOSMail($uid, $txt);
            $orders = $this->common->gettbldata(['trip_id' => $this->db->escape($tripid), 'status' => 1],
                                                'id',
                                                'tb_orders',
                                                0,
                                                0);
            foreach ($orders as $order) {
                $this->sendnotify('speed', $order['id']);
            }
        }
    }

    public function sendOSMail($uid, $txt)
    {
        $this->load->library('email');

        $this->db->select("u.name,a.email_id");
        $this->db->from("tb_users u,tb_alert_settings a");
        $this->db->where("u.id = a.user_id");
        $this->db->where("u.id", $uid);
        $this->db->where("a.email_id !=", "");
        $this->db->where("a.status", 1);
        $getusermail = $this->db->get();

        if ($getusermail->num_rows() > 0) {
            $receivemail = $getusermail->row()->email_id;
            $receivename = $getusermail->row()->name;
            $html = "Dear $receivename,<br><br><br><strong>Vehicle over speed alert</strong><br><br><table border='0'><tr style='background-color: #14A3E1;color: white;'><td>Driver Name</td><td>Driver No</td><td>Vehicle</td><td>Location</td><td>Speed</td><td>Time</td></tr>" . $txt . "</table><br><br>Thanks,<br><b>Svkonekt</b><br>";
            $this->email->to($receivemail, $receivename);
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->subject('Over Speed Alarm');
            $this->email->set_mailtype('html');
            $this->email->message($html);
            $this->email->send();
        }
    }

    public function nightDrive()
    {
        $input = $this->input->post();
        try {
            if (isset($input["data"])) {
                $data = $input["data"];
                $data = json_decode($data, true);
                $curtz = $input['timezone'] ?? "";
                if ($curtz == "") {
                    $curtz = "Asia/Singapore";
                }
                if (isset($data["latitude"])) {
                    $tinput = $res = [];
                    $sysdate = date("Y-m-d H:i:s");
                    $logdate = date("Y-m-d H:i:s", $data["time"] / 1000);
                    $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
                    $curdt = $getactual['datetime'];
                    $tinput["mobileimei"] = $res['mobileimei'] = $this->db->escape($data['imei']);
                    $tinput["timestamp"] = $res['timestamp'] = $curdt;
                    $tinput["latitude"] = $this->db->escape($data["latitude"]);
                    $tinput["longitude"] = $this->db->escape($data["longitude"]);
                    $tinput["accuracy"] = $this->db->escape($data["accuracy"]);
                    $tinput["bearing"] = $this->db->escape($data["bearing"]);
                    $tinput["battery"] = isset($data["battery"]) ? $this->db->escape($data["battery"]) : null;
                    $tinput["vehicle_id"] = isset($data["vehicle_id"]) ? $this->db->escape($data["vehicle_id"]) : 0;
                    if ($data["vehicle_id"] == "") {
                        $data["vehicle_id"] = 0;
                    }
                    $tinput["driver_id"] = isset($data["driver_id"]) ? $this->db->escape($data["driver_id"]) : 0;
                    $tinput["trip_id"] = isset($data["trip_id"]) ? $this->db->escape($data["trip_id"]) : 0;
                    $tinput["speed"] = $this->db->escape($data["speed"]);
                    $ins = $this->db->insert("tb_night_drive", $tinput);
                    $night_id = $this->db->insert_id();
                    $chkbfsend = $this->db->select("created_on")->order_by("created_on", "DESC")->get_where(
                        "tb_trip_alerts",
                        ["trip_id" => $this->db->escape($tinput["trip_id"])],
                        1,
                        0
                    );
                    $cansend = "";
                    if ($chkbfsend->num_rows() > 0) {
                        $cansend = $chkbfsend->row()->created_on;
                    }
                    if ($cansend == "") {
                        $this->db->select("t.register_number,d.name,d.contact_num,d.user_id");
                        $this->db->from("tb_truck_drivers d,tbl_assigned_drivers a, tb_trucks_data t");
                        $this->db->where("d.id", $tinput["driver_id"]);
                        $this->db->where("a.imei", $tinput["mobileimei"]);
                        $this->db->where("d.status", "Active");
                        $this->db->where("a.driver_id = d.id");
                        $this->db->where("a.status", 1);
                        $this->db->where("t.id = a.vehicle_id");
                        $this->db->limit(1);
                        $dr = $this->db->get();

                        if ($dr->num_rows() > 0) {
                            $row = $dr->row();
                            $uid = $row->user_id;
                            $kms = $tinput['speed'];
                            $txt = "";
                            $txt .= "<tr><td>" . $row->name . "</td><td>" . $row->contact_num . "</td><td>" . $row->register_number . "</td><td>" . getLocationname(
                                    $tinput['latitude'],
                                    $tinput['longitude']
                                ) . "</td><td>" . $kms . " KM</td><td>" . $logdate . "</td></tr>";
                            if ($tinput["trip_id"] == "") {
                                $tinput["trip_id"] = 0;
                            }
                            $insdata = [
                                'emp_id' => 0,
                                'trip_id' => $this->db->escape($tinput["trip_id"]),
                                'mobile' => $this->db->escape($tinput["mobileimei"]),
                                'module' => "NightDrive",
                                'message' => $txt,
                                'user_id' => $uid,
                                'speed_id' => $night_id,
                                "created_on" => $sysdate
                            ];
                            $this->db->insert("tb_trip_alerts", $insdata);
                            $this->sendNightDriveMail($uid, $txt);
                        }
                    } else {
                        $this->db->select("t.register_number,d.name,d.contact_num,d.user_id");
                        $this->db->from("tb_truck_drivers d, tbl_assigned_drivers a, tb_trucks_data t");
                        $this->db->where("d.id", $tinput["driver_id"]);
                        $this->db->where("a.imei", $tinput["mobileimei"]);
                        $this->db->where("d.status", "Active");
                        $this->db->where("a.driver_id = d.id");
                        $this->db->where("a.status", 1);
                        $this->db->where("t.id = a.vehicle_id");
                        $this->db->limit(1);
                        $dr = $this->db->get();

                        if ($dr->num_rows() > 0) {
                            $row = $dr->row();
                            $uid = $row->user_id;
                            $chkqry = $this->db->select("nightalert_interval")->get_where(
                                "tb_alert_settings",
                                [
                                    "user_id" => $this->db->escape($uid),
                                    "status" => 1
                                ],
                                1,
                                0
                            );
                            if ($chkqry->num_rows() > 0) {
                                $timeint = $chkqry->row()->nightalert_interval;
                                $start_date = strtotime($cansend);
                                $end_date = strtotime($sysdate);
                                $gapmin = round(abs($end_date - $start_date) / 60);
                                if ($timeint <= $gapmin) {
                                    $kms = $tinput['speed'];
                                    $txt = "";
                                    $txt .= "<tr><td>" . $row->name . "</td><td>" . $row->contact_num . "</td><td>" . $row->register_number . "</td><td>" . getLocationname(
                                            $tinput['latitude'],
                                            $tinput['longitude']
                                        ) . "</td><td>" . $kms . " KM</td><td>" . $logdate . "</td></tr>";
                                    if ($tinput["trip_id"] == "") {
                                        $tinput["trip_id"] = 0;
                                    }
                                    $insdata = [
                                        'emp_id' => 0,
                                        'trip_id' => $this->db->escape($tinput["trip_id"]),
                                        'mobile' => $this->db->escape($tinput["mobileimei"]),
                                        'module' => "NightDrive",
                                        'message' => $txt,
                                        'user_id' => $uid,
                                        'speed_id' => $night_id,
                                        "created_on" => $sysdate
                                    ];
                                    $this->db->insert("tb_trip_alerts", $insdata);
                                    $this->sendNightDriveMail($uid, $txt);
                                }
                            }
                        }
                    }
                    $json_data = ["locationresponse" => $res];
                    $json = json_encode($json_data);
                } else {
                    echo "Not Array";
                }
            } else {
                echo "Not Array";
            }
        } catch (Exception $e) {
            echo "Not Array";
        }
    }

    public function sendNightDriveMail($uid, $txt)
    {
        $this->load->library('email');

        $this->db->select("u.name,a.email_id");
        $this->db->from("tb_users u,tb_alert_settings a");
        $this->db->where("u.id = a.user_id");
        $this->db->where("u.id", $uid);
        $this->db->where("a.email_id !=", "");
        $this->db->where("a.status", 1);
        $getusermail = $this->db->get();

        if ($getusermail->num_rows() > 0) {
            $receivemail = $getusermail->row()->email_id;
            $receivename = $getusermail->row()->name;
            /*$ccmail = $getusermail->row()->cc_mails;*/
            $html = "Dear $receivename,<br><br><br><strong>Night driving alert</strong><br><br><table border='0'><tr style='background-color: #14A3E1;color: white;'><td>Driver Name</td><td>Driver No</td><td>Vehicle</td><td>Location</td><td>Speed</td><td>Time</td></tr>" . $txt . "</table><br><br>Thanks,<br><b>Svkonekt</b><br>";
            $this->email->to($receivemail, $receivename);
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->subject('Night Driving Alert');
            $this->email->set_mailtype('html');
            $this->email->message($html);
            $this->email->send();
        }
    }

    /* Notify Code*/
    public function sendnotify($action, $orderid)
    {
        if (!empty($orderid)) {
            $this->load->library('notifytrigger');
            $info['page_title'] = 'Booking Notification';
            $info['order_id'] = $orderid;
            $info['action'] = $action;
            $orderinfo = $this->common->gettblrowdata(['id' => $this->db->escape($orderid)],
                                                      'order_id',
                                                      'tb_orders',
                                                      0,
                                                      0);
            if (count($orderinfo) > 0) {
                $info['orderid'] = $bookingId = $orderinfo['order_id'];
                $orderDetails = $this->DeliveryDocumentModel->getOrderCustomerName(0, $bookingId);
                $info['subject'] = "Booking ID:" . $bookingId . " Customer Name: " . $orderDetails[$bookingId]['customerName'] . " Delivery Docs: " . $orderDetails[$bookingId]['reference'];
                $info['cargos'] = $this->common->gettbldata(
                    ['order_id' => $this->db->escape($orderid)],
                    'quantity_type,quantity',
                    'tb_order_cargodetails',
                    0,
                    0
                );
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendordernotify($info);
            } else {
                log_message('error', 'No Order data for id : ' . $orderid);
            }
        } else {
            log_message('error', 'Empty Order ');
        }
    }
}
