<?php

defined('BASEPATH') or exit('No direct script access allowed');

require_once APPPATH . "/third_party/PHPExcel.php";
class HongKongDailyReport extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Bufaorderdisplaymodel');
        $this->load->library(['PhpMailerLibrary']);
    }

    public function index()
    {
        $ordersData = $this->Bufaorderdisplaymodel->getOrdersReport();
        if (empty($ordersData)) {
            return false;
        }
        $orderIds = array_column($ordersData, 'id');
        $cargoDetails = $this->Bufaorderdisplaymodel->getCargoDetails($orderIds);
        $fileName = $this->generateExcelReport($ordersData, $cargoDetails);
        if ($fileName != '') {
            return $this->sendMail($fileName);
        }
        return true;
    }

    private function generateExcelReport(array $ordersData, array $cargoDetails): string
    {
        if (!empty($ordersData)) {
            $styleArray = [
                'font' => [
                    'bold' => true,
                    'color' => ['rgb' => 'FFFFFF'],
                    'size' => 10,
                    'name' => 'Verdana'
                ]
            ];
            $cacheMethod = PHPExcel_CachedObjectStorageFactory::cache_to_sqlite;
            $cacheSettings = ['memoryCacheSize' => '512MB'];
            PHPExcel_Settings::setCacheStorageMethod($cacheMethod, $cacheSettings);
            $objPHPExcel = new PHPExcel();
            $objPHPExcel->setActiveSheetIndex(0);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A1:AD1')
                ->applyFromArray(
                    [
                        'fill' => [
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => ['rgb' => '0c3b81']
                        ]
                    ]
                );
            $objPHPExcel->getActiveSheet()->SetCellValue('A1', 'Date');
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('B1', 'Customer');
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('B1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('C1', 'Shipper City(新增)');
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('C1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('D1', 'Factory');
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('D1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('E1', 'Truck Type');
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('F1', 'Time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('F1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('G1', 'Total Package');
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('G1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('H1', 'Order package');
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('H1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('I1', 'HAWB Consignee');
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('I1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('J1', 'HAWB#');
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('J1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('K1', 'Dest.');
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('K1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('L1', 'Dimension');
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('L1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('M1', '大陸 / 香港 車牌');
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('M1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('N1', '香港手提');
            $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('N1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('O1', '司機名稱');
            $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('O1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('P1', '司機身份証號碼');
            $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('P1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Q1', '運輸公司');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('Q1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('R1', '聯系人');
            $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('R1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('S1', '電話');
            $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getStyle('S1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('T1', 'REMARK');
            $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('T1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('U1', 'HANDLE BY');
            $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('U1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('V1', 'Updated ETA');
            $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getStyle('V1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('W1', 'Leave factory time');
            $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('W1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('X1', 'Requested Transport mode');
            $objPHPExcel->getActiveSheet()->getColumnDimension('X')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('X1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Y1', 'Requested Vehicle Type');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('Y1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('Z1', 'Project Name');
            $objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('Z1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AA1', 'Contacts');
            $objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getStyle('AA1')->applyFromArray($styleArray);
            $objPHPExcel->getActiveSheet()->SetCellValue('AB1', 'Local Language Address');
            $objPHPExcel->getActiveSheet()->getColumnDimension('AB')->setWidth(30);
            $objPHPExcel->getActiveSheet()->getStyle('AB1')->applyFromArray($styleArray);
            $activeWorksheet = $objPHPExcel->getActiveSheet();
            $rowCount = 2;
            try {
                $shiftIds = [];
                foreach ($ordersData as $eachOrderData) {
                    $references = explode('?????', $eachOrderData['order_references']);
                    $salogCreatorReference = $destinationReference = $AwbReference = '';
                    $transportModeValue = $vehicleTypeValue = $projectNameValue = $remarkValue  = $contactValue = $localAddressValue  ='';
                    foreach ($references as $eachReference) {
                        $reference = explode(' - ', $eachReference);
                        if (isset($reference[0]) && $reference[0] == 'REM') {
                            $remarksReference = $reference[1];
                            $remarksReferenceData = explode("||",$remarksReference);
                            foreach ($remarksReferenceData as $eachRemark){
                                if (str_contains($eachRemark, 'Transport Mode:')) {
                                    $transportModeValue = trim(str_replace("Transport Mode:", "",$eachRemark));
                                }
                                if (str_contains($eachRemark, 'Vehicle Type:')) {
                                    $vehicleTypeValue = trim(str_replace("Vehicle Type:", "",$eachRemark));
                                }
                                if (str_contains($eachRemark, 'Project Name:')) {
                                    $projectNameValue = trim(str_replace("Project Name:", "",$eachRemark));
                                }
                                if (str_contains($eachRemark, 'Remark:')) {
                                    $remarkValue = trim(str_replace("Remark:", "",$eachRemark));
                                }
                                if (str_contains($eachRemark, 'Contacts:')) {
                                    $contactValue = trim(str_replace("Contacts:", "",$eachRemark));
                                }
                                if (str_contains($eachRemark, 'Local Language Address:')) {
                                    $localAddressValue = trim(str_replace("Local Language Address:", "",$eachRemark));
                                }
                            }
                        }
                        if (isset($reference[0]) && $reference[0] == 'SAC') {
                            $salogCreatorReference = str_replace("@kuehne-nagel.com","",$reference[1]);
                        }
                        if (isset($reference[0]) && $reference[0] == 'SAD') {
                            $destinationReference = $reference[1];
                            if (isset($reference[2])) {
                                $destinationReference .= " - " . $reference[2];
                            }
                        }
                        if (isset($reference[0]) && $reference[0] == 'AWB') {
                            $AwbReference = $reference[1];
                        }
                    }
                    if (in_array($eachOrderData['shift_id'], $shiftIds)) {
                        $eachOrderData['trip_quantity'] = $eachOrderData['register_number'] = $eachOrderData['driver_mobile'] = $eachOrderData['driver_name'] = $eachOrderData['driver_id'] = '';
                    } else {
                        $shiftIds[] = $eachOrderData['shift_id'];
                    }
                    if (isset($cargoDetails[$eachOrderData['id']])) {
                        $eachOrderData['dimensions'] = implode("/",$cargoDetails[$eachOrderData['id']])  ?? '';
                    }
                    $activeWorksheet->SetCellValue('A' . $rowCount, $eachOrderData['early_pickup_date']);
                    $activeWorksheet->SetCellValue('B' . $rowCount, $eachOrderData['customer_name']);
                    $activeWorksheet->SetCellValue('C' . $rowCount, $eachOrderData['pickup_city']);
                    $activeWorksheet->SetCellValue('D' . $rowCount, $eachOrderData['pickup_company']);
                    $activeWorksheet->SetCellValue('E' . $rowCount, $eachOrderData['vehicle_type']);
                    $activeWorksheet->SetCellValue('F' . $rowCount, $eachOrderData['early_pickup_time']);
                    $activeWorksheet->SetCellValue('G' . $rowCount, $eachOrderData['trip_quantity']);
                    $activeWorksheet->SetCellValue('H' . $rowCount, $eachOrderData['quantity']);
                    $activeWorksheet->SetCellValue('I' . $rowCount, '');
                    $activeWorksheet->SetCellValue('J' . $rowCount, $AwbReference);
                    $activeWorksheet->SetCellValue('K' . $rowCount, $destinationReference);
                    $activeWorksheet->SetCellValue('L' . $rowCount, ($eachOrderData['dimensions'] ?? ''));
                    $activeWorksheet->SetCellValue('M' . $rowCount, $eachOrderData['register_number']);
                    $activeWorksheet->SetCellValue('N' . $rowCount, $eachOrderData['driver_mobile']);
                    $activeWorksheet->SetCellValue('O' . $rowCount, $eachOrderData['driver_name']);
                    $activeWorksheet->SetCellValue('P' . $rowCount, $eachOrderData['driver_id']);
                    $activeWorksheet->SetCellValue('Q' . $rowCount, $eachOrderData['carrier_name']);
                    $activeWorksheet->SetCellValue('R' . $rowCount, $eachOrderData['carrier_name']);
                    $activeWorksheet->SetCellValue('S' . $rowCount, $eachOrderData['carrier_mobile']);
                    $activeWorksheet->SetCellValue('T' . $rowCount, $remarkValue);
                    $activeWorksheet->SetCellValue('U' . $rowCount, $salogCreatorReference);
                    $activeWorksheet->SetCellValue('V' . $rowCount, $eachOrderData['status_2400']);
                    $activeWorksheet->SetCellValue('W' . $rowCount, $eachOrderData['pickup_time']);
                    $activeWorksheet->SetCellValue('X' . $rowCount, $transportModeValue);
                    $activeWorksheet->SetCellValue('Y' . $rowCount, $vehicleTypeValue);
                    $activeWorksheet->SetCellValue('Z' . $rowCount, $projectNameValue);
                    $activeWorksheet->SetCellValue('AA' . $rowCount, $contactValue);
                    $activeWorksheet->SetCellValue('AB' . $rowCount, $localAddressValue);
                    $rowCount++;
                }
            } catch (\Throwable $exception) {
                log_message("error", "HongKong report cannot set cell value - " . $exception->getMessage());
            }
          $fileName = 'HongKong_Daily_Report_' . date("dM_H\Hi\M") . '.xlsx';
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
            if (!file_exists('assets/HKDailyReport')) {
                mkdir('assets/HKDailyReport', 0710, true);
            }
            try {
                $objWriter->save(str_replace(__FILE__, 'assets/HKDailyReport/' . $fileName, __FILE__));
                return $fileName;
            } catch (PHPExcel_Writer_Exception $e) {
                log_message("error", "HongKong report PHPExel_Writer_Exception - " . $e->getMessage());
            }
        }
        return '';
    }

    private function sendMail(string $filename): bool
    {
        $subject = "Daily Report - ".date('Y-m-d H\hi\m');
            $message = "Hi Team,<br>";
            $message .= "Attached is the Daily HongKong Report " . "<br><br><br><br>";
            $message .= "Thanks,<br>Support Team,<br>elog360.app/svkonekt_test";
        $attachmentPath = sprintf('%s/assets/HKDailyReport/%s', FCPATH, $filename);
        $status = false;
        try {
            if ($this->phpmailerlibrary->sendmail(HONGKONGREPORT_EMAIL, $subject, $message, [], [$attachmentPath])) {
                $status = true;
            }
        } catch (Exception $e) {
            log_message("error", "HongKong report email failed - " . $e->getMessage());
        }
        return $status;
    }

}
