<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KNCO2M extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(['common', 'customerpiechartmodel']);
        $this->load->library('customeramchartslib');
    }

    public function index()
    {
        $data['page_title'] = $this->lang->line('co2_dashboard');
        $data['sub_title'] = $this->lang->line('emission_overview');
        $userid = $this->session->userdata("user_id");
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');
        $role_id = $this->session->userdata('user_role_id');
        $data['companyCodesList'] = $data['branchCodesList'] = $data['departmentCodeList'] = $searchData = [];
        $data['customersList'] = $this->customerpiechartmodel->getCustomersList($userid, $company_code, $branch_code);
        if ($_POST) {
            $fromDate= $this->input->post('fromdate', true);
            $toDate = $this->input->post('toDate', true);
            $searchData = [
                'fromDate' => !empty($fromDate) ? date('Y-m-d', strtotime($fromDate)) : null,
                'toDate' => !empty($toDate) ? date('Y-m-d', strtotime($toDate)) : null,
                'customerid' => $this->input->post('customerid', true),
            ];
        }
        $data["co2missionata"] = $this->customerpiechartmodel->getCo2missionData($userid, $searchData);
        $emisssionData = $this->customerpiechartmodel->getEmissionchartData($userid, $searchData);
        $data["co2LaneReport"] = $this->customeramchartslib->getLaneWiseReportData($userid, $searchData,$data["co2missionata"]['shipmentcount']);
        log_message("error", "co2LaneReport: ".json_encode($data["co2LaneReport"]));
        foreach ($emisssionData as $emissions) {
            $carbonemission [] = [
                "date" => $emissions['months'],
                "distance" => $emissions['totaldistance'],
                "latitude" => $emissions['Emission']
            ];
        }

        $data["carbonemission"] = $carbonemission ?? [];
        $this->newtemplate->dashboard("knco2report/index", $data);
    }
    
    public function co2data()
    {
        log_message('error', 'came here too');
        $data['page_title'] = $this->lang->line('co2_dashboard');
        $data['sub_title'] = $this->lang->line('emission_overview');
        $userid = $this->session->userdata("user_id");
        $branch_code = $this->session->userdata('branch_code');
        $company_code = $this->session->userdata('company_code');
        $role_id = $this->session->userdata('user_role_id');
        $data['companyCodesList'] = $data['branchCodesList'] = $data['departmentCodeList'] = $searchData = [];
        $data['customersList'] = $this->customerpiechartmodel->getCustomersList($userid, $company_code, $branch_code);
        if ($_POST) {
            $searchData = [
                'fromDate' => date('Y-m-d', strtotime($this->input->post('fromdate', true) ?? "")),
                'toDate' => date('Y-m-d', strtotime($this->input->post('toDate', true) ?? "")),
                'customerid' => $this->input->post('customerid', true),
            ];
        }
        $data["co2missionata"] = $this->customerpiechartmodel->getCo2missionData($userid, $searchData);
        $emisssionData = $this->customerpiechartmodel->getEmissionchartData($userid, $searchData);
        $data["co2LaneReport"] = $this->customeramchartslib->getLaneWiseReportData($userid, $searchData, $data["co2missionata"]['shipmentcount']);
        foreach ($emisssionData as $emissions) {
            $carbonemission[] = [
                "date" => $emissions['months'],
                "distance" => $emissions['totaldistance'],
                "latitude" => $emissions['Emission']
            ];
        }

        $data["carbonemission"] = $carbonemission ?? [];
        $html = $this->load->view("knco2report/index", $data, TRUE);
        echo $html;
    }
}
