<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
//require ('./libs/autoload.php');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class KNCarrierExtract extends CI_Controller {

    public function __Construct() {
        parent::__Construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("KNCarrierExcel");
        $this->load->library('sendemail');
    }

    public function index() {
        $data["page_title"] = $this->lang->line('bpartner_ordtype');

        $where = array();
        $whr = array();
        $company_code = $this->session->userdata('company_code');
        $whr['tt.status'] = 1;

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {
            $name = $this->input->post('name1');

            if (isset($name) && $name != "") {
                $where['tt.type_name'] = $name;
            }
        } elseif (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {
            $department_code = $this->input->post('department_code');
            $customer_name = $this->input->post('customer_name');
            $status = $this->input->post('status');
            if (isset($department_code) && $department_code != "") {
                $where['tt.department_code'] = $department_code;
            }
            if (isset($customer_name) && $customer_name != "") {
                $where['c.name'] = $customer_name;
            }
            if (isset($status) && $status != "") {
                $where['tt.status'] = $status;
                unset($whr['tt.status']);
            }
        }
        $data['order_list'] = $this->KNCarrierExcel->getsearchdata($whr, $where);
        /* log_message('error',$this->db->last_query()); */
        $this->newtemplate->dashboard("excelcreation/index", $data);
    }

    /* Start Excel File Creation and Download */

    public function RussiaGenericCarrierExcel($company_code, $branch_code, $trip_id) {
        $fileName = 'KNCarrierExcel_' . time() . '.xlsx';
        $user_id = $this->session->userdata('user_id');
//        $company_code = $this->session->userdata('company_code');
//        $branch_code = $this->session->userdata('branch_code');
//        $trip_id = 'T07332047160';
        $employeeData = $this->KNCarrierExcel->employeeList($company_code, $branch_code, $trip_id);
        // log_message('error', json_encode($employeeData));


        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->setCellValue('A2', 'Hello World !');
        $sheet->setCellValue('A2', '№');
        $sheet->setCellValue('B2', 'Дата загрузки');
        $sheet->setCellValue('C2', 'Город');
        $sheet->setCellValue('D2', 'Название получателя');
        $sheet->setCellValue('E2', 'ИНН');
        $sheet->setCellValue('F2', 'номер заявки клиента');
        $sheet->setCellValue('G2', 'Контактное лицо, телефон, факс');
        $sheet->setCellValue('H2', 'Доставка по городу');
        $sheet->setCellValue('I2', 'Адрес доставки');
        $sheet->setCellValue('J2', 'Дата Доставки');
        $sheet->setCellValue('K2', 'Время доставки');
        $sheet->setCellValue('L2', 'ПРР');
        $sheet->setCellValue('M2', 'Вес');
        $sheet->setCellValue('N2', 'Объем');
        $sheet->setCellValue('O2', 'Примечания');
        $sheet->setCellValue('P2', 'Возврат ЭР Клиента');

        $rows = 3;
        /* $carrier_mail = array();
          $carrier_name = array(); */
        foreach ($employeeData as $val) {
            // $vas_name = $val['vas_name'];
            $carrier_mail = $val['email'];
            $carrier_name = $val['carrier_name'];
            $order_id = $val['uniq_order_id'];
            $vas_name = $val['vas_id'];
            $actual_vas= $vas_name;

            if ($vas_name == 'LOO') {
                $vasname = 'да';
            } else {
                $vasname = 'нет';
            }

            if ($vas_name == 'DOC') {
                $vasdoc = 'да';
            } else {
                $vasdoc = 'нет';
            }


            $consignee_info = $this->KNCarrierExcel->getConsigneeDetails($order_id);
            $consignee_name = $consignee_info['consignee_name'];
            $consignee_mobile = $consignee_info['consignee_mobile'];
            $consignee_id = $consignee_info['id'];
            $e_cell = '';
            $vat_reg_no = $consignee_info['vat_reg_no'];
            $tax_payer_no = $consignee_info['tax_payer_no'];
            $code = $consignee_info['code'];
            if ($this->search_string_over_consignee($consignee_name)) {
                // get consignee valid details...
                $e_cell = $vat_reg_no;
            }else{
                $e_cell = $vat_reg_no .'& '. $tax_payer_no;
                // $code;
            }

            $sheet->setCellValue('A' . $rows, $val['order_id']);
            $sheet->setCellValue('B' . $rows, $val['pickup_datetime']);
            $sheet->setCellValue('C' . $rows, $val['city']);
            $sheet->setCellValue('D' . $rows, $consignee_name);
            $sheet->setCellValue('E' . $rows, $e_cell);
            $sheet->setCellValue('F' . $rows, $val['purchase_order']);
            $sheet->setCellValue('G' . $rows, $consignee_mobile);
            $sheet->setCellValue('H' . $rows, "да");
            $sheet->setCellValue('I' . $rows, $val['cons_address']);
            $sheet->setCellValue('J' . $rows, $val['delivert_date']);
            $sheet->setCellValue('K' . $rows, $val['delivery_time']);
            $sheet->setCellValue('L' . $rows, $vasname);
            $sheet->setCellValue('M' . $rows, $val['weight']);
            $sheet->setCellValue('N' . $rows, $val['volume']);
            $sheet->setCellValue('O' . $rows, "За сутки до доставки обязательный созвон с получателем.");
            $sheet->setCellValue('P' . $rows, $vasdoc);
            $rows++;
        }
        // $carrier_mail;
        $writer = new Xlsx($spreadsheet);
        $dir = "assets/ru_generic_excel/";
        $this->createdir($dir);
        $writer->save($dir . $fileName);
        header("Content-Type: application/vnd.ms-excel");
        redirect(base_url() . $dir . $fileName);

        if ($trip_id != '' && FALSE) {
            $receivemail = $carrier_mail;
            $receivename = $carrier_name;
            $mailmsg = "PlEASE CHECK TRIP ATTACHEMENT";
            $sub = "KNCarrierExcel";
            $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
            $this->email->to($receivemail, $receivename);
            $this->email->subject($sub);
            $this->email->set_mailtype("html");
            $this->email->message($mailmsg);
            $epodpath = base_url() . $dir . $fileName;
            $this->email->attach($epodpath);

            if(!$this->email->send()){
                log_message("error",$this->email->print_debugger());
                unlink($fileName);
            }

            $this->email->clear(true);
        }
    }

    function GenerateRussiaGenericCarrierExcel($company_code, $branch_code, $Trip, $Action, $Event, $Request) {
        if ($Action = 'EMAIL' && $Event = 'TRIP' && $Request = 'EXCEL' && $Company = 'RUKN') {
            $this->RussiaGenericCarrierExcel($company_code, $branch_code, $Trip);
        }
    }

    function createdir($dir) {
        if (!file_exists($dir)) {
            if (!mkdir($dir, 0755)) {
                log_message('error', 'Folder Creation fail at KNCarrierExtract');
            }
        }
        if (!is_writable($dir)) {
            log_message('error', 'Folder does\'t have proper permissions KNCarrierExtract');
        }
    }

    function search_string_over_consignee($consignee_name) {
        $words = array("ООО", "ЗАО", "АО");
        if (strlen(trim($consignee_name)) > 2) {
            foreach ($words as $word) {
                if (strpos($consignee_name, $word) !== false) {
                    return TRUE;
                }
            }
        }
        return FALSE;
    }

}
