<?php

defined('BASEPATH') or exit('No direct script access allowed');

use App\Models\OrderList\ExcelUpload;

class KNSvkQuickRates extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model(["common", "lanesmodel", "Quickratesmodel", "orderrevenuesmodel"]);
        $this->load->library('quickrateshandler');
    }
    public function index($id = null): void
    {
        if ($id != "") {
            $this->quickRatesData($id);
        } else {
            $this->quickRatesData();
        }
    }

    public function quickRatesData(int $id = null): void
    {
        $data['page_title'] = $this->lang->line('quick_rates');
        $data['sub_title'] = $this->lang->line('create');
        $data['company_code'] = $companyCode = $this->session->userdata('company_code');
        $data['branch_code'] = $branchCode = $this->session->userdata('branch_code');
        $data['user_id'] = $user_id = $this->session->userdata('user_id');
        $data['currency'] = $this->session->userdata("usr_tzone")['currency'];
        $data['chr'] = $this->Quickratesmodel->getChargeCodes();
        $data['tier'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,tier_id,tier_name', 'tb_tier_master', 0, 0);
        $data['geo_tier'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,geo_tier_id,geo_tier_name', ' tb_geo_tier', 0, 0);
        $data['exch_id'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,exchange_rate_id,exchange_rate_name', 'tb_rate_exchange', 0, 0);
        $data['currencies'] = $this->common->gettbldata(['status' => 1], 'currency', 'tbl_country_master', 0, 0);
        $data['lane'] = $this->common->gettbldata(['status' => 1, 'company_code' => $companyCode], 'id,lane_id,lane_name', ' tb_lanes_master', 0, 0);
        if (in_array($id, ExcelUpload::IDS_FOR_UPLOAD)) {
            $excel = new ExcelUpload($id);
            $result = $excel->upload($companyCode);
        }
        $listType = $result['list_types']['list_type'] ?? 0;
        if ($listType == 1) {
                $filenameex = @file_get_contents("assets/ordertemplate/quickRatesExcelData.txt");

            $excelUploadData = json_decode($filenameex);
            if (!empty($excel_uploaddata)) {
                @file_put_contents("assets/ordertemplate/quickRatesExcelData.txt", "");
            }
        }
        $data['listType'] = $listType;
        $data['excelUploadData'] = $excelUploadData ?? [];
        $this->newtemplate->dashboard("quickrates/index", $data);
    }

    public function conversionlist():void
    {
        $type = $this->input->post('type', true);
        $conversionlist = $this->common->gettbldata(['type' => $type, 'status' => 1, "conversion_id !=" => ""], 'id,conversion_id,name', 'tb_knuom_conversion', 0, 0);
        echo json_encode($conversionlist);
    }

    public function laneDetails():void
    {
        $laneId = $this->input->post('lane', true);
        if ($laneId != "") {
            $laneDetails = $this->lanesmodel->getsearchdata(["tl.lane_id" => $laneId], ["tl.status" => 1]);
        }
        echo json_encode($laneDetails ?? []);
    }
    public function checkname():void
    {
        $rateServiceName = $this->input->post('rateServiceName',TRUE);
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');
        if ($rateServiceName != "") {
            $where = [
                'service_name' => $rateServiceName,
                'company_code' => $companyCode,
                'branch_code' => $branchCode
            ];
            $company = $this->common->gettblrowdata($where, 'service_name', 'tb_rate_services', 0, 0);
            echo $company ? '1' : '2';
        }
    }

    public function saverrcharge(int $id = null):void
    {
        $post = $this->input->post(null, true);
        $rr_exch_id = $post['rr_exch_id'] ?? 0;
        $geo_tier_id = $post['geo_tier_id'] ?? 0;
        $tier_id = $post['tier_id'] ?? 0;
        $rr_charge_id = $post['rr_charge_id'] ?? 0;
        $rr_min_amount = trim($post['rr_min_amount']) ?? "0.000000";
        $rr_amount = trim($post['rr_amount']) ?? "0.000000";
        $rr_percentage = $post['rr_percentage'] ?? "";
        $fuel_surcharge = $post['fuel_surcharge'] ?? 0;
        $chargeData = [
            'exchange_rate_id' => $rr_exch_id,
            'rr_charge_type' => $post['charge_type'] ?? null,
            'geo_tier_id' => $geo_tier_id ?? 0,
            'rr_tier_id' => $tier_id ?? 0,
            'rr_charge_id' => $rr_charge_id,
            'charge_basis' => $post['rr_char_basis'] ?? null,
            'min_amount' => $rr_min_amount ?? 0.000000,
            'amount' =>  $rr_amount ?? 0.000000,
            'percentage' => $rr_percentage,
            'fuel_surcharge_id' => $fuel_surcharge,
            'currency' => $post['rr_currency'] ?? null,
            'status' => 1
        ];
        if ($id == null) {
            $chargeData['raterecord_id'] = 0;
            $result = $this->common->insertTableData("tb_raterecord_charges", $chargeData);
            $data = ['rr_chr_id' => $result];
        } else {
            $chargeData['updatedon'] = date('Y-m-d H:i:s');
            $result = $this->common->updatetbledata('tb_raterecord_charges', $chargeData, ['id' => $id]);
            $data = ['rr_chr_id' => $result];
        }
        echo json_encode($data ?? []);
    }

    public function editsaverrcharge(int $id):void
    {
        $post = $this->input->post(null, true);
        $chrdata = [
            'exchange_rate_id' => $post['rr_exch_id'] ?? 0,
            'rr_charge_type' => $post['charge_type'] ?? " ",
            'geo_tier_id' => $post['geo_tier_id'] ?? 0,
            'rr_tier_id' => $post['tier_id'] ?? 0,
            'rr_charge_id' => $post['rr_charge_id'] ?? 0,
            'fuel_surcharge_id' => $post['fuel_surcharge'] ?? "0",
            'charge_basis' => $post['rr_char_basis'] ?? " ",
            'min_amount' => round($post['rr_min_amount'], 6),
            'amount' => round($post['rr_amount'], 6),
            'percentage' => $post['rr_percentage'] ?? 0,
            'currency' => $post['rr_currency'] ?? " ",
            'raterecord_id' => $id ?? 0,
            'status' => 1
        ];
        $data = $this->common->insertTableData("tb_raterecord_charges", $chrdata);
        echo json_encode($data ?? []);
    }

    /* charge details add page */
    public function showchargedetails():void
    {
        $post = $this->input->post(null, true);
        $ids = $post['charge_ids'] ?? "";
        $data = [];
        if ($ids != "") {

            if (!empty($ids)) {
                $getCharges = $this->Quickratesmodel->getChargeIds($ids);

                if (count($getCharges) > 0) {
                    foreach ($getCharges as $Charges) {
                        $charge_code = $fuel_surcharge = $tier_code = $exch_id = $exchid = $geo_tier_id = "";
                        $fuel_surcharge_id = $Charges['fuel_surcharge_id'] ?? 0;
                        if ($fuel_surcharge_id > 0) {
                            $get_surcharge_qry = $this->common->gettblrowdata(['id' => $fuel_surcharge_id, 'status' => '1'], 'faf_id,faf_id,faf_name', 'tb_fuel_surcharge', 0, 0);
                            if (!empty($get_surcharge_qry)) {
                                $fuel_surcharge = $get_surcharge_qry['faf_id'] . "-" . $get_surcharge_qry['faf_name'];
                            }
                        }
                        $data_res = $this->common->gettblrowdata(['id' => $Charges['rr_charge_id']], 'charge_code', 'tb_charge_codes', 0, 0);
                        if (!empty($data_res)) {
                            $charge_code = $data_res['charge_code'];
                        }

                        $data_res_t = $this->common->gettblrowdata(['id' =>  $Charges['rr_tier_id']], 'tier_id', 'tb_tier_master', 0, 0);
                        if (!empty($data_res_t)) {
                            $tier_code = $data_res_t['tier_id'];
                        }
                        $geo_data_res = $this->common->gettblrowdata(['id' =>  $Charges['geo_tier_id']], 'geo_tier_id', 'tb_geo_tier', 0, 0);
                        if (!empty($geo_data_res)) {
                            $geo_tier_id = $geo_data_res['geo_tier_id'];
                        }
                        $chk_e = $this->common->gettbldata(['id' => $Charges['exchange_rate_id']], 'id,exchange_rate_id', 'tb_rate_exchange', 0, 0);
                        if (count($chk_e) > 0) {
                            $exch_id = $chk_e['0']['exchange_rate_id'];
                            $exchid = $chk_e['0']['id'];
                        }
                        $exch_id1 = '"' . $exchid . '"';
                        $charge_code2 = '"' .  $Charges['rr_charge_id'] . '"';
                        $charge_basis = '"' .  $Charges['charge_basis'] . '"';
                        $rr_charge_type = '"' .  $Charges['rr_charge_type'] . '"';
                        $currency = '"' .  $Charges['currency'] . '"';
                        $geo_tier_id1 = '"' . $Charges['geo_tier_id'] . '"';
                        $percentage = '"' .  $Charges['percentage'] . '"';
                        $fuel_surcharge_id = '"' .  $Charges['fuel_surcharge_id'] . '"';

                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcharEdit(this," .  $Charges['id'] . "," . $rr_charge_type . "," . $charge_code2 . "," .  $Charges['rr_tier_id'] . "," . $charge_basis . "," .  $Charges['min_amount'] . "," .  $Charges['amount'] . "," . $currency . "," . $exch_id1 . "," . $geo_tier_id1 . "," . $percentage . "," . $fuel_surcharge_id . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletechrdetail(this," .  $Charges['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowaddCharges(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";

                        $data[] = [
                            'exch_id' => $exch_id,
                            'rr_charge_type' =>  $Charges['rr_charge_type'],
                            'rr_tier_id' => $tier_code,
                            'geo_tier_id' => $geo_tier_id,
                            'rr_charge_id' => $charge_code,
                            'charge_basis' =>  $Charges['charge_basis'],
                            'min_amount' =>  $Charges['min_amount'],
                            'amount' =>  $Charges['amount'],
                            'currency' =>  $Charges['currency'],
                            'percentage' => $fuel_surcharge,
                            'action' => $action
                        ];
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function deletechrdetails():void
    {
        $post = $this->input->post(null, true);
        $id = $post['id'] ?? '0';
        if ($id != '0') {
            $this->common->updatetbledata('tb_raterecord_charges', ["status"=>0],["id" =>$id]);
        }
    }

    public function getamountfromfuelsurcharge():void
    {
        $post = $result = [];
        $post = $this->input->post(null, true);
        $company_code = $this->session->userdata('company_code');
        if (!empty($post)) {
            $tariffType = $post['tariffType'] ?? '';
                if (!empty($tariffType)) {
                    if(!empty($post['vendorProfile'])){
                        $getVendorId = $this->common->gettblrowdata(['vend_profile_id' => $post['vendorProfile']], 'id', 'tb_vendor_profile', 0, 0);
                    }
                    if(!empty($post['customerProfile'])){
                        $getCustomerId = $this->common->gettblrowdata(['cust_profile_id' => $post['customerProfile']], 'id', 'tb_customer_profile', 0, 0);
                    }
                    $customerId = $getCustomerId['id'] ?? '';
                    $vendorId = $getVendorId['id'] ?? '';
                    $tarrif_match = $this->gettarrifmatchedrecords($tariffType, $customerId, $vendorId);
                    $empty_tarrif = $this->getemptytarrifrecords();
                    if (!empty($tarrif_match)) {
                        foreach ($tarrif_match as $row) {
                            if (!empty($result)) {
                                if (!in_array($row['row_id'], $result)) {
                                    $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                                }
                            } else {
                                $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                            }
                        }
                    }
                    if (!empty($empty_tarrif)) {
                        foreach ($empty_tarrif as $row) {
                            if (!empty($result)) {
                                if (!in_array($row['row_id'], $result)) {
                                    $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                                }
                            } else {
                                $result[] = ['row_id' => $row['row_id'], 'faf_id' => $row['faf_id'], 'faf_name' => $row['faf_name']];
                            }
                        }
                    }
            }
        }
        echo json_encode($result);
    }
    public function getemptytarrifrecords():array
    {
        $faf_ids = array();
        $company_code = $this->session->userdata('company_code');
        $whr = " ( tariff_type IS NULL OR tariff_type = '' ) AND company_code LIKE '".$company_code."' AND status ='1'";
        $getempty_surcharge = $this->orderrevenuesmodel->getemptytariffrecords_forfaf($whr);
        if(!empty($getempty_surcharge)){
            foreach ($getempty_surcharge as $res){
                $faf_ids[] = array('row_id'=>$res['id'],'faf_name'=>$res['faf_name'],'faf_id'=>$res['faf_id']);
            }
        }
        return $faf_ids;
    }

    public function gettarrifmatchedrecords(string $tariffType,string $customerId,string $vendorId):array
    {
        $surcharge_customer_id = $surcharge_carrier_id = 0;
        $surcharge_customer_code = $surcharge_carrier_code = "";
        $company_code = $this->session->userdata('company_code');
        $faf_ids = array();
        if($tariffType != ""){
            $get_surcharge_qry = $this->common->gettbldata(array('tariff_type' => $tariffType,'company_code'=>$company_code,'status' =>'1'),'id,faf_id,faf_name,customer_id,carrier_id','tb_fuel_surcharge', 0, 0);
            if(!empty($get_surcharge_qry)){
                foreach ($get_surcharge_qry as $get_surcharge){
                    $surcharge_customer_id = $get_surcharge['customer_id'];
                    $surcharge_carrier_id  = $get_surcharge['carrier_id'];
                    if($tariffType == "SELL"){
                        if($surcharge_customer_id > 0){
                            $getcustomer_code = $this->common->gettblrowdata(array('id' =>$surcharge_customer_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_customers', 0, 0);
                            if(!empty($getcustomer_code)){
                                $surcharge_customer_code = $getcustomer_code['code'];
                            }
                            if($surcharge_customer_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('cp_id' =>$customerId,'profile_id'=>$surcharge_customer_code,'status' =>'1'),'id','tb_customer_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }else if($tariffType == "BUY"){
                        if($surcharge_carrier_id > 0){
                            $getcarrier_code = $this->common->gettblrowdata(array('id' =>$surcharge_carrier_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_vendors', 0, 0);
                            if(!empty($getcarrier_code)){
                                $surcharge_carrier_code = $getcarrier_code['code'];
                            }
                            if($surcharge_carrier_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('vp_id' =>$vendorId,'profile_id'=>$surcharge_carrier_code,'status' =>'1'),'id','tb_vendor_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }
                }
            }
        }
        return $faf_ids;
    }
    public function serviceAndLaneInsert():void
    {
        $userId = $this->session->userdata('user_id');
        $companyCode = $this->session->userdata('company_code');
        $branchCode = $this->session->userdata('branch_code');

        $post = $this->input->post(null, true);
        extract($post);
        $rateServiceName = $serviceName ?? "";
        $serviceType = $serviceType ?? "";
        $offeringType = $this->common->gettblrowdata(['id' => $serviceType], 'transport_mode', 'tb_service_master', 0, 0);
        $product = $product ?? "";
        $laneId = $laneId ?? "";
        $days = $days ?? "";
        $hours = $hours ?? "";
        $minutes = $minutes ?? "";
        $source = $source ?? "";
        $destination = $destination ?? "";
        $lanesId = $lanesId ?? "";
        $effectiveDate = $effectiveDate ?? "";
        $newEffective = date("Y-m-d", strtotime($effectiveDate));
        $expiryDate = $expiryDate ?? "";
        $newExpiry = date("Y-m-d", strtotime($expiryDate));
        $offeringActive = isset($active) ? 1 : 0;
        $offeringQuote = isset($quote) ? 1 : 0;
        $vehicleProfileId = $vehicleProfile ?? "";
        $conversionFactor = $conversionFactor ?? "";
        $tariffType = $tariffType ?? "";
        if ($vehicleProfileId != "") {
            $vehicleProfileDetails = $this->common->gettblrowdata(['veh_profile_id' => $vehicleProfileId], 'id', 'tb_vehicle_profile', 0, 0);
        }
        $customerProfileId = $customerProfile ?? "";
        if ($customerProfileId != "") {
            $customerProfileDetails = $this->common->gettblrowdata(['cust_profile_id' => $customerProfileId], 'id', 'tb_customer_profile', 0, 0);
        }
        $vendorProfileId = $vendorProfile ?? "";
        if ($vendorProfileId != "") {
            $vendorProfileDetails = $this->common->gettblrowdata(['vend_profile_id' => $vendorProfileId], 'id', 'tb_vendor_profile', 0, 0);
        }
        if ($serviceType == "") {
            $serviceType = 0;
        }
        $serviceId = $this->quickrateshandler->seridgen();
        $offeringId = $this->quickrateshandler->genofferid();
        $recordId = $this->quickrateshandler->rateRecordGen();
        $rateServicedata = [
            'service_id' => $serviceId,
            'service_name' => $rateServiceName,
            'service_type' => $serviceType,
            'description' => $rateServiceName,
            'company_code' => $companyCode,
            'branch_code' => $branchCode,
            'source' => $source,
            'destination' => $destination,
            'product' => $product,
            'user_id' => $userId,
            'status' => '1'
        ];
        $result = $this->common->insertTableData("tb_rate_services", $rateServicedata);
        if (!empty($result)) {
            $data1 = [
                'rate_id' => $result ?? null,
                'lane_id' => $lanesId ?? null,
                'rs_lane_days' => $days ?? null,
                'rs_lane_hours' => $hours ?? null,
                'rs_lane_mins' => $minutes ?? null,
                'user_id' => $userId ?? null,
                'status' => '1'
            ];
            $result1 = $this->common->insertTableData("tb_rateservice_lanes", $data1);
            $offeringDataInsertion = [
                'offering_id' => $offeringId,
                'offering_name' => $rateServiceName,
                'offering_type' => $offeringType['transport_mode'] ??"FTL",
                'description' => $rateServiceName,
                'rate_service_id' => $result,
                'lane_id' => $lanesId,
                'effective_date' => $newEffective ?? null,
                'expiry_date' => $newExpiry ?? null,
                'offering_active' => $offeringActive ?? null,
                'offering_quote' => $offeringQuote ?? null,
                'tarrif_type' => $tariffType ?? null,
                'uom_conversion_id' => $conversionFactor ?? 0,
                'veh_profile_id' => $vehicleProfileDetails['id'] ?? 0,
                'cust_profile_id' => $customerProfileDetails['id'] ?? 0,
                'vendor_profile_id' => $vendorProfileDetails['id'] ?? 0,
                'company_code' => $companyCode ?? null,
                'branch_code' => $branchCode ?? null,
                'user_id' => $userId ?? null,
                'status' => '1'
            ];
            $result2 = $this->common->insertTableData("tb_rate_offerings", $offeringDataInsertion);
            if ($result2 > 0) {
                $rateRecordInsert = [
                    'rate_id' => $recordId,
                    'record_name' => $rateServiceName,
                    'description' => $rateServiceName,
                    'offering_id' => $result2,
                    'company_code' => $companyCode ?? null,
                    'branch_code' => $branchCode ?? null,
                    'user_id' => $userId ?? null,
                    'status' => '1'
                ];
                $result3 = $this->common->insertTableData("tb_rate_records", $rateRecordInsert);
                if ($result3 > 0) {
                    $rate_r_charge_ids = explode(',', $rate_r_charge_id);
                    $this->db->where_in('id', $rate_r_charge_ids)->update("tb_raterecord_charges", ['raterecord_id' => $result3]);
                    $ids['serviceId'] = $serviceId;
                    $ids['offeringId'] = $offeringId;
                    $ids['recordId'] = $recordId;
                    echo json_encode($ids);
                }
            }
        }
    }

}


