<?php



if (! defined('BASEPATH')) {

    exit('No direct script access allowed');

}



class KNpalletizer extends CI_Controller

{



    public function __construct()

    {

        parent::__construct();

        if ($this->session->userdata('user_id') == '') {

            redirect('login');

        }

        $this->load->model("common");

        $this->load->model("KNpalletizermodel");
        if (!checkUrlAccessForUser('KNPALLETIZER')) {
            redirect("Forbiddenaccess");
        }

    }



    public function index()

    {

        /*$this->benchmark->mark('code_start');*/

        $data["page_title"] = $data['sub_title'] = "Palletizer";

        $data["services"] = array();

        $whr = array(

            'status' => 1

        );

        $data['pallet_types'] = $this->common->gettbldata($whr, 'id,package_id,name', 'tb_pallet_type', 0, 0);

        $data['pallet_data'] = array();

        $uid = $this->session->userdata("user_id");

        $post = $_POST;

        $data['or_data'] = $data['pl_data'] = $data['trip_data'] = $get_orderdata = $get_palletdata = $get_tripdata = array();

        $searchByOrderId = isset($post['order_id']) && $post['order_id'] != "";

        $searchByContainer = isset($post['container_no']) && $post['container_no'] != "";

        $searchRequested  = isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search";

        if ($searchRequested && ($searchByOrderId || $searchByContainer)) {

            $whr = array();

            $where = array();

            $searchwhr = array();

    		$getctr = array();

            $whr['o.user_id']=$uid;

            if (!empty($post)) {

                if ($searchByOrderId) {

                    $whr['o.order_id'] = $this->db->escape_str($post['order_id']);

                }

                if ($searchByContainer) {

                    $cnno = trim($this->db->escape_str($post['container_no']));

                    $getctr = $this->getcontainerorder($cnno);

                    if(!empty($getctr)){

                        $searchwhr = $getctr;

                    }

                }

                if(!empty($getctr)){

                    if (isset($post['cargo_type']) && $post['cargo_type'] != "") {

                        $where['cargo_type'] = $this->db->escape_str($post['cargo_type']);

                    }

                }

            }

            /*if(isset($where['cargo_type'])){

                if ($where['cargo_type'] != 2) {

                    $whr['ic.cargo_id'] = null;

                }

            }*/

            $where["c.pallet_name"] = "!= null";

            $data['w1'] = $whr;

            $data['w2'] = $where;

           // $orderdata = $this->KNpalletizermodel->getorderdata($whr,$where,$searchwhr);
           $orderdata = $this->KNpalletizermodel->getorderdataForRightBlock($whr,$where,$searchwhr);
          // echo "<pre>";print_r($orderdata);exit;
            if ($orderdata) {

                $i = 1;$existstrip = "";

                foreach ($orderdata as $rdata) {

                    $order_id_ref=$rdata['id'];

                    $ref = $this->db->query('SELECT reference_id,ref_value FROM tb_order_references where order_id="'.$order_id_ref.'" and reference_id IN ("DQ","PQ","CTR") AND status=1 GROUP BY reference_id LIMIT 2');



                    $purchage = $delivey = $container = "";

                    if ($ref->num_rows() > 0) {

                        $refdata = $ref->result_array();

                       // echo "<pre>";print_r($refdata);exit;

                        foreach ($refdata as $ref_data) {

                            if ($ref_data['reference_id'] == "CTR") {

                                $container = $ref_data['ref_value'];

                            } else if ($ref_data['reference_id'] == "DQ") {

                                $delivey = $ref_data['ref_value'];

                            } else if ($ref_data['reference_id'] == "PO") {

                                $purchage = $ref_data['ref_value'];

                            }

                        }

                    }

                    $laneid = $rdata['quantity_type'];

                    if($laneid == ""){

                        $laneid = $i;

                    }

                    if($purchage == ""){

                        $purchage = $rdata['purchase_order'];

                    }

                    if($rdata['pallet_name'] == "" && $rdata['stop_detail_id'] == ""){

                        if(count($get_orderdata) <= 10){

                            $get_orderdata[] = array(

                                'id' => $rdata['id'],

                                'cargo_id' => $rdata['cargo_id'],

                                'order_id' => $rdata['order_id'],

                                'quantity_type' => $laneid,

                                'cargo_type' => $rdata['cargo_type'],

                                'weight' => $rdata['weight'],

                                'weight_unit' => $rdata['weight_unit'],

                                'quantity' => $rdata['quantity'],

                                'volume' => $rdata['volume'],

                                'volume_unit' => $rdata['volume_unit'],

                                'container' => $container,

                                'delivey' => $delivey,

                                'purchage' => $purchage,

                                'pallet_close' => $rdata['pallet_close']

                            );

                        }

                        $i++;

                    }

                    if($rdata['pallet_name'] != ""){

                        $resparr = array();

                        $resparr['id'] = $rdata['cargo_id'];

                        $resparr['pallet_name'] = $rdata['pallet_name'];

                        $resparr['cargo_type'] = $rdata['cargo_type'];

                        $resparr['quantity'] = $rdata['quantity'];

                        $resparr['weight'] = $rdata['weight'];

                        $resparr['volume'] = $rdata['volume'];

                        $resparr['order_id'] = $rdata['order_id'];

                        $resparr['container_num'] = $container;

                        $resparr['purchase_order'] = $purchage;

                        $resparr['stopdetailsid'] = $rdata['stop_detail_id'];

                        $resparr['weight_unit'] = $rdata['weight_unit'];

                        $resparr['volume_unit'] = $rdata['volume_unit'];

                        $resparr['pallet_close'] = $rdata['pallet_close'];

                        $get_palletdata[] = $resparr;

                    }

                    if($rdata['stop_detail_id'] != "" && $rdata['shift_id'] != 0){

                        $resparr = array();

                        if($existstrip != $rdata['shift_id']){

                            $existstrip = $rdata['shift_id'];

                            $tripinfo = $this->db->query("SELECT id,scity,dcity,shipmentid,vendor_id,vehicle_type FROM tb_shifts WHERE id='".$rdata['shift_id']."' AND status=1 LIMIT 1");
//echo "<pre>";print_r($tripinfo);exit;
                            if($tripinfo->num_rows()>0){

                                $res = $tripinfo->row();

                                $resparr['id'] = $res->id;

                                $resparr['trip'] = $res->shipmentid;

                                $resparr['pickup'] = $res->scity;

                                $resparr['delivery'] = $res->dcity;

                                if($resparr['delivery'] == ""){

                                    $resparr['delivery'] = $resparr['pickup'];

                                }

                                $resparr['trucktype'] = $res->vehicle_type;

                                $resparr['carrier_id'] = $vendorid = $res->vendor_id;

                                $resparr['vehicle_id'] = $resparr['driver_id'] = $resparr['vehicle'] = $resparr['driver_name'] = $resparr['carrier_name'] = "NA";



                                $vtypeinfo = $this->db->query("SELECT v.id,v.vehicle_id,v.carrier_id,t.register_number FROM tb_shft_veh v,tb_trucks_data t WHERE v.vehicle_id=t.id AND v.shft_id='".$rdata['shift_id']."' LIMIT 1");

                                if($vtypeinfo->num_rows()>0){

                                    $resparr['vehicle_id'] = $vtypeinfo->row()->vehicle_id;

                                    $resparr['vehicle'] = $vtypeinfo->row()->register_number;

                                    $resparr['carrier_id'] = $vendorid = $vtypeinfo->row()->carrier_id;

                                }

                                $carinfo = $this->db->query("SELECT id,name FROM tb_vendors WHERE id=$vendorid");

                                if($carinfo->num_rows()>0){

                                    $resparr['carrier_name'] = $carinfo->row()->name;

                                }

                                if($resparr['vehicle_id'] != "NA"){

                                    $vehid = $resparr['vehicle_id'];

                                    $drivinfo = $this->db->query("SELECT d.id,d.name FROM tb_truck_drivers d,tbl_assigned_drivers a WHERE d.id=a.driver_id AND a.vehicle_id=$vehid AND a.status=1 LIMIT 1");

                                    if($drivinfo->num_rows()>0){

                                        $resparr['driver_id'] = $drivinfo->row()->id;

                                        $resparr['driver_name'] = $drivinfo->row()->name;

                                    }

                                }

                            }



                            $get_tripdata[] = $resparr;

                        }

                    }

                }

                $data['or_data'] = $get_orderdata;

                $data['pl_data'] = $get_palletdata;

                $data['trip_data'] = $get_tripdata;

            }

        }

        /*$this->benchmark->mark('code_end');*/

        $this->newtemplate->dashboard("KNpalletizer/palletizer", $data);

        /*$this->benchmark->mark('view_end');

        echo $this->benchmark->elapsed_time('code_start', 'code_end')."<br>";

        echo $this->benchmark->elapsed_time('code_end', 'view_end');

        exit;*/

    }



    public function getCargoes(){

        $referenceData='';

        $post = $this->input->post();

        $start = $post["start"];

        $length = $post["length"];

        $order_id = $post["order_id"];

        $container_no = $post["container_no"];

        $cargo_type = $post["cargo_type"];

        $searchByOrderId = isset($post['order_id']) && $post['order_id'] != "";

        $searchByContainer = isset($post['container_no']) && $post['container_no'] != "";

        $get_orderdata = [];

        $totalRecords = 0;

        $draw = $post['draw'];

        $uid = $this->session->userdata("user_id");

        if ($searchByOrderId || $searchByContainer) {

            $whr = array();

            $where = array();

            $searchwhr = array();

            $getctr = array();

            $whr['o.user_id']=$uid;

            if (!empty($post)) {

                if ($searchByOrderId) {

                    $whr['o.order_id'] = $post['order_id'];

                }

                if ($searchByContainer) {

                    $cnno = trim($post['container_no']);

                    $getctr = $this->getcontainerorder($cnno);

                    if(!empty($getctr)){

                        $searchwhr = $getctr;

                    }

                }

                if(!empty($getctr)){

                    if (isset($post['cargo_type']) && $post['cargo_type'] != "") {

                        $where['cargo_type'] = $post['cargo_type'];

                    }

                }

            }

            $data['w1'] = $whr;

            $data['w2'] = $where;

            if(empty($searchwhr)){
                echo '{"draw":1,"iTotalRecords":0,"iTotalDisplayRecords":0,"aaData":[]}';
                exit;
            }

            //Count Query
            $orderdata = $this->KNpalletizermodel->getorderdataForLeftBlock($whr,$where,$searchwhr,'','',1);
            if ($orderdata) {
                $totalRecords =$orderdata[0]['total_count'] ;
            }

            $orderdata = $this->KNpalletizermodel->getorderdataForLeftBlock($whr,$where,$searchwhr,$length,$start);
            if ($orderdata) {
                foreach ($orderdata as $rdata) {
                    $order_id_ref=$rdata['id'];

                    $purchage = $delivey = $container = "";
                    if(isset($rdata['reference_value'])){
                        $referenceData= $rdata['reference_value'];
                    }

                    //echo $referenceData;exit;

                    if($referenceData!=''){
                        $referenceDataArray=explode(';',$referenceData);
                        if(!empty($referenceDataArray) && sizeof($referenceDataArray)>0){
                            foreach($referenceDataArray as $eachRefData){
                                $reqArray=$this->giveReferenceParameters($eachRefData);
                                if ($reqArray['type'] == "CTR") {
                                    $container = $reqArray['value'];
                                } else if ($reqArray['type'] == "DQ") {
                                    $delivey = $reqArray['value'];
                                } else if ($reqArray['type'] == "PO") {
                                    $purchage = $reqArray['value'];
                                }
                            }
                        }
                    }

                    if($purchage == ""){
                        $purchage = $rdata['purchase_order'];
                    }

                    if($rdata['pallet_name'] == "" && $rdata['stop_detail_id'] == ""){
                        $get_orderdata[] = array(

                            '<div class="checkbox checkbox-info">

                                <label> <input type="checkbox" name="chck1" value="'.$rdata['cargo_id'].'"> <span class="cr"><i class="cr-icon fa fa-check"></i></span>

                                </label>

                            </div>',

                            '<ul class="nav nav-tabs">

                                <li class="dropdown tablebtnrleft">

                                    <a class="dropdown-toggle" data-toggle="dropdown" href="#"> <span class="icon  tru-icon-action-setting"></span>

                                    </a>

                                    <ul class="dropdown-menu" role="menu">

                                        <li>

                                            <a href="#" class="dt-view">

                                                <span class="icon tru-icon-view" aria-hidden="true"></span>

                                                '.$this->lang->line('general_view').'

                                            </a>

                                        </li>

                                        <li>

                                            <a href="#" class="dt-view">

                                                <span class="icon tru-icon-edit" aria-hidden="true"></span>

                                                '.$this->lang->line('general_edit').'

                                            </a>

                                        </li>

                                        <li>

                                            <a href="#" class="dt-delete">

                                                <span class="icon tru-icon-delete" aria-hidden="true"></span>

                                                '.$this->lang->line('general_delete').'

                                            </a>

                                        </li>

                                    </ul>

                                </li>

                            </ul>',

                            $rdata['order_id'],

                            $rdata['quantity_type'],

                            $container,

                            $purchage,

                            $rdata['cargo_type'],

                            $rdata['quantity'],

                            $rdata['weight']." ",$rdata['weight_unit'],

                            $rdata['volume']." ",$rdata['volume_unit']

                        );

                    }

                }

            }



        }

        $response = array(

          "draw" => intval($draw),

          "iTotalRecords" => $totalRecords,

          "iTotalDisplayRecords" => $totalRecords,

          "aaData" => $get_orderdata

        );

        echo json_encode($response);

    }

    public function giveReferenceParameters($referenceParam){
        $finalArray=array();
        if(!empty($referenceParam) && $referenceParam!=''){
            $requiredArray=explode('=====',$referenceParam);
            if(!empty($requiredArray) && sizeof($requiredArray)>0){
                $finalArray['type']=trim($requiredArray[0]);
                $finalArray['value']=trim($requiredArray[1]);
            }
        }
        return $finalArray;
    }

    public function getcontainerorder($id){

        $ref1 = $this->db->query("SELECT o.id FROM tb_orders o,tb_order_references r WHERE o.id=r.order_id AND r.ref_value LIKE '%".$id."%' AND o.status!=0 AND r.status=1 AND r.reference_id='CTR'");

        $resp = array();

        if ($ref1->num_rows() > 0) {

            foreach($ref1->result() as $hi){

                $resp[] = $hi->id;

            }

        }

        return $resp;

    }



    public function getorderid()

    {

        $uid = $this->session->userdata('user_id');

        $company_code = $this->session->userdata('company_code');

        $order_id = isset($_POST["order_id"]) ? $_POST["order_id"] : "";

        $data = array();

        if($order_id != ""){

            $get_data = $this->db->query("SELECT order_id FROM  tb_orders  WHERE order_id like '%".$order_id."%' and company_code='".$company_code."'");

            if ($get_data->num_rows() > 0) {

                foreach ($get_data->result() as $get_data_f) {

                    $data[] = $get_data_f->order_id;

                }

            }

        }

        echo json_encode($data);

    }



    public function getpallezerdata(){

        /*$postData = file_get_contents('php://input');

        $posts = str_replace("ids%5B%5D=", "", $postData);

        $cargos = explode("&", $posts);*/

        $cargos = $this->input->post('ids');

        $response = array();

        if(!empty($cargos)){

            $cargodata = array();

            $palletdata = array();

            $cargoids = implode(",", $cargos);

            $orders = array();

            $get_data = $this->db->query("SELECT id,order_id,quantity FROM tb_order_cargodetails WHERE id IN ($cargoids) AND stop_detail_id IS NULL AND status=1");

            if($get_data->num_rows()>0){

                foreach ($get_data->result_array() as $cid) {

                    $cargodata[] = $cid;

                    if(!in_array($cid['order_id'], $orders)){

                        $orders[] = $cid['order_id'];

                    }

                }

            }

            if(count($orders)>0){

                $orderids = implode(",", $orders);

                $pallet_data = $this->db->query("SELECT cd.id,cd.pallet_name,cd.weight,cd.quantity,cd.volume,c.weight_unit,c.volume_unit FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.order_id IN ($orderids) AND cd.pallet_name != '' AND cd.stop_detail_id IS NULL AND cd.pallet_close=1 AND cd.status=1 AND c.status=1");

                if($pallet_data->num_rows()>0){

                    foreach ($pallet_data->result_array() as $pid) {

                        $palletdata[] = $pid;

                    }

                }

            }

            $response = array('cargodata'=>$cargodata,'palletdata'=>$palletdata);

        }

        echo $this->load->view('KNpalletizer/palletassign',$response,true);

    }



    public function closePallets(){

        $cargos = $this->input->post('ids');

        $response = array();

        if(!empty($cargos)){

            $cargodata = array();

            $palletdata = array();

            $cargoids = implode(",", $cargos);



            if(count($cargos)>0){

                $pallet_data = $this->db->query("UPDATE tb_order_cargodetails SET pallet_close = 0 WHERE id IN ($cargoids)");

            }

        }

        echo json_encode(array("statu"=>true));

    }



    public function getpalletid(){

        $pid = $this->input->post("pid");

        $resparr = array();

        if($pid != ""){

            $getqty = $this->db->query("SELECT cd.id,cd.order_id,cd.cargo_id,cd.pallet_name,cd.weight,cd.quantity,cd.volume,cd.cargo_content,cd.qr_code,cd.scanned_quantity,c.cargo_type,c.height,c.width,c.length,c.width_unit,c.length_unit,c.height_unit,c.weight_unit,c.volume_unit FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.id=$pid AND cd.pallet_name != '' AND cd.status=1 AND c.status=1 LIMIT 1");

            if($getqty->num_rows()>0){

                $container_num = "";

                $resparr = $getqty->row_array();

                $ordid = $resparr['order_id'];

                $container = $this->db->select("ref_value")->get_where("tb_order_references",array("order_id"=>$ordid,"reference_id"=>"CTR","status"=>1),1,0);

                if($container->num_rows()>0){

                    $container_num = $container->row()->ref_value;

                }

                $ordinfo = $this->db->query("SELECT o.order_id,d.delivery_note,d.purchase_order FROM tb_orders o,tb_order_details d WHERE o.id=d.order_row_id AND o.id=$ordid AND d.status=1 LIMIT 1");

                if($ordinfo->num_rows()>0){

                    $resparr['order_id'] = $ordinfo->row()->order_id;

                    $resparr['container_num'] = $container_num;

                    $resparr['purchase_order'] = $ordinfo->row()->purchase_order;

                }

            }

        }

        echo json_encode($resparr);

    }



    public function getpalletidbyord(){

        $pid = $this->input->post("pid");

        $resparrary = array();

        if($pid != ""){

            $getqty = $this->db->query("SELECT cd.id,cd.order_id,cd.cargo_id,cd.pallet_name,cd.weight,cd.quantity,cd.volume,cd.cargo_content,cd.qr_code,cd.scanned_quantity,c.cargo_type,c.height,c.width,c.length,c.width_unit,c.length_unit,c.height_unit,c.weight_unit,c.volume_unit,cd.pallet_close FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.order_id=$pid AND (cd.stop_detail_id IS NULL OR cd.stop_detail_id='') AND cd.pallet_name != '' AND cd.status=1 AND c.status=1");

            if($getqty->num_rows()>0){

                $container_num = "";

                $container = $this->db->select("ref_value")->get_where("tb_order_references",array("order_id"=>$pid,"reference_id"=>"CTR","status"=>1),1,0);

                if($container->num_rows()>0){

                    $container_num = $container->row()->ref_value;

                }

                foreach($getqty->result_array() as $op){

                    $resparr = $op;

                    $ordid = $resparr['order_id'];

                    $ordinfo = $this->db->query("SELECT o.order_id,d.delivery_note,d.purchase_order FROM tb_orders o,tb_order_details d WHERE o.id=d.order_row_id AND o.id=$ordid AND d.status=1 LIMIT 1");

                    if($ordinfo->num_rows()>0){

                        $resparr['order_id'] = $ordinfo->row()->order_id;

                        $resparr['container_num'] = $container_num;

                        $resparr['purchase_order'] = $ordinfo->row()->purchase_order;

                    }

                    $resparrary[] = $resparr;

                }

            }

        }

        echo json_encode($resparrary);

    }

    public function gettripid(){

        $tripchk = isset($_POST['tid']) ? $_POST['tid'] : "";

        $resparr = array();

        if($tripchk != ""){

            $tripinfo = $this->db->query("SELECT id,scity,dcity,shipmentid,vendor_id,vehicle_type FROM tb_shifts WHERE id='".$tripchk."' AND status=1 LIMIT 1");

            if($tripinfo->num_rows()>0){

                $res = $tripinfo->row();

                $resparr['id'] = $res->id;

                $resparr['trip'] = $res->shipmentid;

                $resparr['pickup'] = $res->scity;

                $resparr['delivery'] = $res->dcity;

                if($resparr['delivery'] == ""){

                    $resparr['delivery'] = $resparr['pickup'];

                }

                $resparr['trucktype'] = $res->vehicle_type;

                $resparr['carrier_id'] = $vendorid = $res->vendor_id;

                $resparr['vehicle_id'] = $resparr['driver_id'] = $resparr['vehicle'] = $resparr['driver_name'] = $resparr['carrier_name'] = "NA";



                $vtypeinfo = $this->db->query("SELECT v.id,v.vehicle_id,v.carrier_id,t.register_number FROM tb_shft_veh v,tb_trucks_data t WHERE v.vehicle_id=t.id AND v.shft_id='$tripchk' LIMIT 1");

                if($vtypeinfo->num_rows()>0){

                    $resparr['vehicle_id'] = $vtypeinfo->row()->vehicle_id;

                    $resparr['vehicle'] = $vtypeinfo->row()->register_number;

                    $resparr['carrier_id'] = $vendorid = $vtypeinfo->row()->carrier_id;

                }

                $carinfo = $this->db->query("SELECT id,name FROM tb_vendors WHERE id=$vendorid");

                if($carinfo->num_rows()>0){

                    $resparr['carrier_name'] = $carinfo->row()->name;

                }

                if($resparr['vehicle_id'] != "NA"){

                    $vehid = $resparr['vehicle_id'];

                    $drivinfo = $this->db->query("SELECT d.id,d.name FROM tb_truck_drivers d,tbl_assigned_drivers a,tb_shft_veh v WHERE d.id=a.driver_id AND a.vehicle_id=v.vehicle_id AND v.shft_id='$tripchk' AND a.vehicle_id=$vehid AND a.status=1 LIMIT 1");

                    if($drivinfo->num_rows()>0){

                        $resparr['driver_id'] = $drivinfo->row()->id;

                        $resparr['driver_name'] = $drivinfo->row()->name;

                    }

                }

            }

        }

        echo json_encode($resparr);

    }

    public function getpallettripsdata(){

        $pids = $resparrary['pids'] = $this->input->post("ids");

        $resparrary['tripdata'] = array();

        $resparrary['carrierlist'] = $resparrary['vehicletypes'] = array();

        if(!empty($pids)){

            $user_id = $this->session->userdata('user_id');

            $vendor_list = $this->db->select("id,name,code")->get_where("tb_vendors", array('user_id' => $user_id,'status' => 1));

            if ($vendor_list->num_rows() > 0) {

                $resparrary['carrierlist'] = $vendor_list->result_array();

            }

            $vehicletypes = $this->db->select('id,trucktype')->get_where("tb_trucktypes", array("status" => 'Active'),10,0);

            if($vehicletypes->num_rows()>0){

                $resparrary['vehicletypes'] = $vehicletypes->result_array();

            }

            $resparrary['pids'] = $pids;

            $pid = $pids[0];

            $getqty = $this->db->query("SELECT o.id,o.order_id,o.pickup_city,o.pickup_country,o.delivery_city,o.delivery_country,o.shift_id,o.trip_id FROM tb_order_cargodetails cd,tb_orders o WHERE cd.order_id=o.id AND cd.id IN(".implode(',', $pids).") AND o.shift_id!=0 AND o.trip_sts=0 AND o.status!=0");

            if($getqty->num_rows()>0){

                foreach($getqty->result() as $ordin){

                    $resparr1 = $ordin;

                    $order_id = $resparr1->order_id;

                    $tripinfo = $this->db->query("SELECT s.id,s.scity,s.dcity,s.shipmentid,s.vendor_id,s.vehicle_type,e.assoc_id FROM tb_shifts s,tb_employee e WHERE s.id=e.shift_id AND e.order_id='".$order_id."' AND s.status=1 GROUP BY s.id");

                    if($tripinfo->num_rows()>0){

                        foreach($tripinfo->result() as $res){

                            $resparr = array();

                            $resparr['id'] = $ship_id = $res->id;

                            $resparr['trip'] = $res->shipmentid;

                            $resparr['pickup'] = $res->scity;

                            $resparr['delivery'] = $res->dcity;

                            if($resparr['delivery'] == ""){ $resparr['delivery'] = $resparr['pickup']; }

                            $resparr['trucktype'] = $res->vehicle_type;

                            $resparr['carrier_id'] = $vendorid = $res->vendor_id;

                            $resparr['vehicle_id'] = $resparr['driver_id'] = $resparr['vehicle'] = $resparr['driver_name'] = $resparr['carrier_name'] = "";

                            $carinfo = $this->db->query("SELECT id,name FROM tb_vendors WHERE id=$vendorid");

                            if($carinfo->num_rows()>0){

                                $resparr['carrier_name'] = $carinfo->row()->name;

                            }

                            $vtypeinfo = $this->db->query("SELECT v.id,v.vehicle_id,t.register_number FROM tb_shft_veh v,tb_trucks_data t WHERE v.vehicle_id=t.id AND v.shft_id=$ship_id LIMIT 1");

                            if($vtypeinfo->num_rows()>0){

                                $resparr['vehicle_id'] = $vtypeinfo->row()->vehicle_id;

                                $resparr['vehicle'] = $vtypeinfo->row()->register_number;

                            }

                            if($resparr['vehicle_id'] != ""){

                                $vehid = $resparr['vehicle_id'];

                                $drivinfo = $this->db->query("SELECT d.id,d.name FROM tb_truck_drivers d,tbl_assigned_drivers a,tb_shft_veh v WHERE d.id=a.driver_id AND a.vehicle_id=v.vehicle_id AND v.shft_id='$ship_id' AND a.vehicle_id=$vehid AND a.status=1 LIMIT 1");

                                if($drivinfo->num_rows()>0){

                                    $resparr['driver_id'] = $drivinfo->row()->id;

                                    $resparr['driver_name'] = $drivinfo->row()->name;

                                }

                            }

                            $resparrary['tripdata'][] = $resparr;

                        }

                    }

                }

            }

        }

        /*log_message("error","alltripdt".json_encode($resparrary));*/

        echo $this->load->view('KNpalletizer/tripassign',$resparrary,true);



    }



    public function generatepallet(){

        ini_set('max_input_vars', 30000);

        $post = $this->input->post(null,true);

        $uid = $this->session->userdata("user_id");

        $curdt = date('Y-m-d H:i:s');

        $response = '0';

        if(!empty($post)){

            $cargos = $post['cargo_line'];

            $required_qty = $post['required_qty'];

            $act_qty = $post['act_qty'];

            $plchck = isset($post['plchck']) ? $post['plchck'] : "";

            if(count($cargos)>0){

                if($plchck == "" || $plchck == '0'){

                    $cargoid1 = isset($cargos[0]) ? $cargos[0] : 0;

                    if($cargoid1 != "" && $cargoid1 != 0){

                        $getqty = $this->db->query("SELECT cd.*,c.cargo_type,c.height,c.width,c.length,c.width_unit,c.length_unit,c.height_unit,c.weight_unit,c.volume_unit FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.id=$cargoid1 AND cd.status=1 AND c.status=1 LIMIT 1");

                        if($getqty->num_rows()>0){

                            $palletarr = $getqty->row_array();

                            $palletarr['quantity'] = 0;

                            $palletarr['scanned_quantity'] = 0;

                            unset($palletarr['id']);

                            unset($palletarr['cargo_type']);

                            unset($palletarr['width_unit']);

                            unset($palletarr['length_unit']);

                            unset($palletarr['height_unit']);

                            unset($palletarr['weight_unit']);

                            unset($palletarr['volume_unit']);

                            $plchck = $this->common->insertTableData("tb_order_cargodetails",$palletarr);

                            $seq = getNextPalletSeq($palletarr['order_id']);

                            $container_id = "";

                            $conwhr = array('order_id'=>$palletarr['order_id'],'reference_id'=>'CTR','status'=>1);

                            $container = $this->common->gettblrowdata($conwhr,'ref_value','tb_order_references',0,0);

                            if(count($container)>0){

                                $container_id = $container['ref_value'];

                            }

                            $palletarr1 = array();

                            $genpallet_name = date("Md")."-".$container_id."-".$seq;

                            $palletarr1['pallet_name'] = strtoupper($genpallet_name);

                            $chk_handling_unit = $this->db->select("id")->get_where("tbl_shipunit_types",array('unit_name'=>$palletarr1['pallet_name'],'status'=>'1'));

                            if($chk_handling_unit->num_rows()>0){

                                $handling_unit = $chk_handling_unit->row()->id;

                            }else{

                                $handling_insarr = array('unit_name'=>$palletarr1['pallet_name'],'description'=>$palletarr1['pallet_name'],'user_id'=>$uid,'status'=>'1','created_at'=>$curdt);

                                $handling_unit = $this->common->insertTableData("tbl_shipunit_types",$handling_insarr);

                            }

                            $cargo_ins = array('cargo_type'=>$palletarr1['pallet_name'],'handling_unit'=>$handling_unit,'handlingunit_id'=>$handling_unit,'length'=>$getqty->row()->length,'length_unit'=>$getqty->row()->length_unit, 'width'=>$getqty->row()->width, 'width_unit'=>$getqty->row()->width_unit, 'height'=>$getqty->row()->height, 'height_unit'=>$getqty->row()->height_unit, 'weight'=>$getqty->row()->weight, 'weight_unit'=>$getqty->row()->weight_unit, 'volume'=>$getqty->row()->volume, 'volume_unit'=>$getqty->row()->volume_unit,'volumetric_weight'=>'1.00','volweight_uom'=>'M','quantity'=>1,'status'=>'1','createdby'=>$uid,'createdon'=>$curdt);

                            $cargo_id = $this->common->insertTableData("tb_cargo_details",$cargo_ins);

                            $palletarr1['cargo_id'] = $cargo_id;

                            $whr = array("id"=>$plchck);

                            $upd = $this->common->updatetbledata("tb_order_cargodetails",$palletarr1,$whr);

                        }

                    }

                }

                if($plchck != ""){

                    $volume = $weight = 0;

                    for($i=0;$i<count($cargos);$i++){

                        $cargoid = isset($cargos[$i]) ? $cargos[$i] : 0;

                        $actqty = isset($act_qty[$i]) ? $act_qty[$i] : 1;

                        $qty = isset($required_qty[$i]) ? $required_qty[$i] : "";

                        if($qty == 0 || $qty == ""){

                            $qty = $act_qty[$i];

                        }

                        $getqty1 = $this->db->query("SELECT cd.id,cd.cargo_id,cd.pallet_name,cd.weight,cd.quantity,cd.volume,cd.cargo_content,cd.qr_code,cd.scanned_quantity,c.cargo_type,c.height,c.width,c.length,c.width_unit,c.length_unit,c.height_unit,c.weight_unit,c.volume_unit FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.id=$plchck AND cd.pallet_name != '' AND cd.pallet_close=1 AND cd.status=1 AND c.status=1 LIMIT 1");

                        if($getqty1->num_rows()>0){

                            $quantity = $getqty1->row()->quantity;

                            $qty1 = ($qty + $quantity);

                            $volume = ($volume + $getqty1->row()->volume);

                            $weight = ($weight + $getqty1->row()->weight);

                            $set = array("quantity"=>$qty1,"scanned_quantity"=>$qty1,"weight"=>$weight,"volume"=>$volume);

                            $whr = array("id"=>$plchck);

                            $upd = $this->common->updatetbledata("tb_order_cargodetails",$set,$whr);

                            $getqty = $this->db->query("SELECT cd.id,cd.cargo_id,cd.pallet_name,cd.weight,cd.quantity,cd.volume,cd.cargo_content,cd.qr_code,cd.scanned_quantity,c.cargo_type,c.height,c.width,c.length,c.width_unit,c.length_unit,c.height_unit,c.weight_unit,c.volume_unit FROM tb_order_cargodetails cd INNER JOIN tb_cargo_details c on cd.cargo_id=c.id WHERE cd.id=$cargoid AND cd.pallet_name IS NULL AND cd.status=1 AND c.status=1 LIMIT 1");

                            if($getqty->num_rows()>0){

                                if($actqty == $qty){

                                    $set = array("status"=>0);

                                    $whr = array("id"=>$cargoid);

                                    $upd = $this->common->updatetbledata("tb_order_cargodetails",$set,$whr);

                                }else{

                                    $remainqty = ($actqty - $qty);

                                    $set = array("quantity"=>$remainqty);

                                    $whr = array("id"=>$cargoid);

                                    $upd = $this->common->updatetbledata("tb_order_cargodetails",$set,$whr);

                                }

                                $insarr = array('cargo_id'=>$getqty->row()->cargo_id, 'pallet_id'=>$plchck, 'cargo_type'=>$getqty->row()->cargo_type, 'goods_description'=>$getqty->row()->cargo_content, 'quantity'=>$qty, 'scanned_quantity'=>$qty, 'length'=>$getqty->row()->length, 'length_unit'=>$getqty->row()->length_unit, 'width'=>$getqty->row()->width, 'width_unit'=>$getqty->row()->width_unit, 'height'=>$getqty->row()->height, 'height_unit'=>$getqty->row()->height_unit, 'weight'=>$getqty->row()->weight, 'weight_unit'=>$getqty->row()->weight_unit, 'volume'=>$getqty->row()->volume, 'volume_unit'=>$getqty->row()->volume_unit, 'stackable'=>0, 'qr_code'=>$getqty->row()->qr_code, 'status'=>1, 'createdby'=>$uid, 'createdon'=>$curdt);

                                $ins = $this->common->insertTableData("tb_inner_cargo",$insarr);

                            }

                        }

                    }

                    $response = $plchck;

                }

            }

        }

        echo $response;

    }

    /*pallet assign to trip*/

    public function generatetrip(){

        $post = $this->input->post(null,true);


        $uid = $this->session->userdata("user_id");

        $curdt = date('Y-m-d H:i:s');

        $response = '0';

        if(!empty($post)){

            $curtz = $this->session->userdata("usr_tzone")['timezone'];

            $logdate = date('Y-m-d H:i:s');

            $getactual = getdatetimebytimezone(DFLT_TZ,$logdate,$curtz);

            $curdt = $getactual['datetime'];

            $company_code = $this->session->userdata('company_code');

            $branch_code = $this->session->userdata('branch_code');

            $cargos1 = $post['pallet_ids'];

            $cargos = explode(",", $cargos1);

            $tripchk = isset($post['tripchk']) ? $post['tripchk'] : "";

            if(count($cargos)>0){

                $getqty = $this->db->query("SELECT count(id) as pid,order_id,pallet_name,SUM(weight) as cargoweight,SUM(quantity) as cargoquantity,SUM(volume) as cargovolume FROM tb_order_cargodetails WHERE id IN(".implode(',', $cargos).") AND stop_detail_id IS NULL AND status=1");

                if($getqty->num_rows()>0){

                    $quantity = $getqty->row()->cargoquantity;

                    if($quantity == ""){ $quantity = 1; }

                    $volume = $getqty->row()->cargovolume;

                    $weight = $getqty->row()->cargoweight;

                    if($weight == ""){ $weight = 1; }

                    $volume = $getqty->row()->cargovolume;

                    if($volume == ""){ $volume = 0; }

                    $units = $getqty->row()->pid;

                    if($units == ""){ $units = 1; }

                    $order_id = $getqty->row()->order_id;

                    $trip_id = '0';

                    $carrierid= isset($post['carrierid']) ? $post['carrierid'] : "";

                    $vehicle_id = isset($post['tvehnum']) ? $post['tvehnum'] : "";

                    $driver_id = isset($post['tdrivernum']) ? $post['tdrivernum'] : "";

                    $veh_num = isset($post['vehicle_id']) ? $post['vehicle_id'] : "";

                    $tpvehicle_type=isset($post['vehicle_type']) ? $post['vehicle_type'] : 0;

                    $tripinfo = array("id"=>$tripchk,"user_id"=>$uid,"curtz"=>$curtz,"curdt"=>$curdt,"company_code"=>$company_code,"branch_code"=>$branch_code,"order_id"=>$order_id,"weight"=>$weight,"volume"=>$volume,"units"=>$units,"quantity"=>$quantity,"pkgs"=>count($cargos),'pallet_name'=>$getqty->row()->pallet_name,'carrierid'=>$carrierid,"tvehnum"=>$vehicle_id,"vehicle_id"=>$veh_num,"tdrivernum"=>$driver_id,"vehicle_type"=>$tpvehicle_type,"cargos"=>$cargos);

                    if($driver_id == "" && $vehicle_id != ""){

                        $tripinfo = $this->getVehicleAndDriver($tripinfo);

                    }

                    if($driver_id == "" && $vehicle_id == ""){

                        $tripinfo = $this->getVehicleDriverno($tripinfo);

                    }


                    if($tripchk != ""){

                        $tripid = $this->updatetripbyordercargo($tripinfo);

                        if(count($tripid)>0){

                            $trip_id = $tripid['trip_id'];

                            $plorder = $tripid['order_id'];

                            /*update pallet*/

                            if($tripid['stopdetailsid'] != "" && $tripid['stopdetailsid'] != 0){

                                $stopdetailid = $tripid['stopdetailsid'];

                                $upd = $this->db->query("UPDATE tb_order_cargodetails SET order_id='".$plorder."',stop_detail_id='".$stopdetailid."' AND pallet_close='0' WHERE id IN(".implode(',', $cargos).") ");

                            }

                        }

                    }else{

                        if($carrierid != "" || $tpvehicle_type > 0){

                            $tripid = $this->generatetripbyordercargo($tripinfo);

                            if(count($tripid)>0){

                                $trip_id = $tripid['trip_id'];

                                $plorder = $tripid['order_id'];

                                /*update pallet*/

                                if($tripid['stopdetailsid'] != "" && $tripid['stopdetailsid'] != 0){

                                    $stopdetailid = $tripid['stopdetailsid'];

                                    $upd = $this->db->query("UPDATE tb_order_cargodetails SET order_id='".$plorder."',stop_detail_id='".$stopdetailid."' AND pallet_close='0' WHERE id IN(".implode(',', $cargos).") ");

                                }

                            }

                        }

                    }

                    $response = $trip_id;

                }

            }

        }

        echo $response;

    }



    public function getVehicleAndDriver($tripinfo)

    {

        $vendor_id = $tripinfo["carrierid"];

        $vehicle_id = $tripinfo["tvehnum"];

        $driver_id = $tripinfo["tdrivernum"];

        //getting vehicle_id and driver_id from already assined tbl_assigned_drivers table based on vendor_id , even no vehicle is assigned till then simply getting random vehcile and drivers from thet vendors vehcile and driver masters

        if($vehicle_id != "" && $vendor_id != ""){

            $veh_query = $this->db->query("SELECT ad.* FROM tb_trucks_data td JOIN tbl_assigned_drivers ad ON ad.driver_id=td.id WHERE ad.status=1 AND td.status='Active' AND ad.vehicle_id = '$vehicle_id' ORDER BY ad.id DESC LIMIT 1");

            if($veh_query->num_rows()>0){

                $vehcile_id = $veh_query->row()->vehicle_id;

                if(!isNotEmpty($driver_id)){

                    $driver_id = $veh_query->row()->driver_id;

                }

            }else{

                $veh_query = $this->db->query("SELECT ad.* FROM tb_trucks_data td JOIN tbl_assigned_drivers ad ON ad.driver_id=td.id WHERE td.status='Active' AND ad.vehicle_id = '$vehicle_id' ORDER BY ad.id DESC LIMIT 1");

                if($veh_query->num_rows()>0){

                    $upd = $this->db->where(array("id"=>$veh_query->row()->id))->update("tbl_assigned_drivers",array("status"=>1));

                    $vehcile_id = $veh_query->row()->vehicle_id;

                    if(!isNotEmpty($driver_id)){

                        $driver_id = $veh_query->row()->driver_id;

                    }

                }

            }

        }

        $tripinfo["carrierid"] = $vendor_id;

        $tripinfo["tvehnum"] = $vehicle_id;

        $tripinfo["tdrivernum"] = $driver_id;

        return $tripinfo;

    }



    public function getVehicleDriverno($tripinfo)

    {

        $vendor_id = $tripinfo["carrierid"];

        $vehicle_id = $tripinfo["tvehnum"];

        $driver_id = $tripinfo["tdrivernum"];

        //getting vehicle_id and driver_id from already assined tbl_assigned_drivers table based on vendor_id , even no vehicle is assigned till then simply getting random vehcile and drivers from thet vendors vehcile and driver masters

        if($vendor_id != ""){

            $veh_query = $this->db->where(array('status'=>'Active','vendor_id'=>$vendor_id))->get("tb_trucks_data");

            if($veh_query->num_rows()>0){

                $vehicle_id = $veh_query->row()->id;

            }

            $driver_query = $this->db->where(array('status'=>'Active','vendor_id'=>$vendor_id))->get("tb_truck_drivers");

            if($driver_query->num_rows()>0){

                $driver_id = $driver_query->row()->id;

            }else{

                $driver_query = $this->db->where(array('status'=>'Active',"user_id"=>$tripinfo['user_id']))->get("tb_truck_drivers");

                if($driver_query->num_rows()>0){

                    $driver_id = $driver_query->row()->id;

                }

            }

        }

        $tripinfo["carrierid"] = $vendor_id;

        $tripinfo["tvehnum"] = $vehicle_id;

        $tripinfo["tdrivernum"] = $driver_id;

        return $tripinfo;

    }



    public function updatetripbyordercargo($tripinfo){

        $trip_id = $tripinfo['id'];

        $resp['trip_id'] = $trip_id;

        $resp['stopdetailsid'] = "";

        $resp['order_id'] = $tripinfo['order_id'];

        $cargos = $ordinput['cargos'];

        $ship1 = $this->db->select('id,order_id,quantity,weight,volume,shift_id')->order_by('id','DESC')->get_where("tb_orders",array('shift_id'=>$trip_id),1,0);

        if($ship1->num_rows()>0){

            $ship_id = $ship1->row()->shift_id;

            $resp['order_id'] = $order_id = $ship1->row()->id;

            $booking_id =  $ship1->row()->order_id;

            $ordweight = $ship1->row()->weight;

            $ordvolume = $ship1->row()->volume;

            $ordqty = $ship1->row()->quantity;

            $ship = $this->db->query("SELECT s.weight,s.volume,s.units,e.id,e.capacity,e.shipment_weight,e.shipment_volume,e.no_of_pkgs FROM tb_shifts s,tb_employee e WHERE s.id=e.shift_id AND e.shift_id='".$ship_id."' AND e.order_id='".$booking_id."' LIMIT 1");

            if($ship->num_rows()>0){

                $resp['stopdetailsid'] = $ship->row()->id;

                $whr = array("id"=>$ship->row()->shift_id);

                $weight = ($ship->row()->weight + $tripinfo['weight']);

                $volume = ($ship->row()->volume + $tripinfo['volume']);

                $units = ($ship->row()->units + $tripinfo['units']);

                $set = array("weight"=>$weight,"volume"=>$volume,"units"=>$units);

                $update = $this->common->updatetbledata("tb_shifts",$set,$whr);

                $ordweight = ($ordweight + $tripinfo['weight']);

                $ordvolume = ($ordvolume + $tripinfo['volume']);

                $ordqty = ($ordqty + $tripinfo['quantity']);

                $set = array("quantity"=>$ordqty,"weight"=>$ordweight,"volume"=>$ordvolume);

                $update = $this->common->updatetbledata("tb_orders",$set,array("id"=>$order_id));

                $whr = array("id"=>$resp['stopdetailsid']);

                $capacity = $ship->row()->capacity;

                if($capacity == ""){ $capacity = 1;}

                $capacity = ($capacity + $tripinfo['quantity']);

                $shipment_weight = $ship->row()->shipment_weight;

                if($shipment_weight == ""){ $shipment_weight = 1;}

                $shipment_weight = ($shipment_weight + $tripinfo['weight']);

                $shipment_volume = $ship->row()->shipment_volume;

                if($shipment_volume == ""){ $shipment_volume = 0;}

                $shipment_volume = ($shipment_volume + $tripinfo['volume']);

                $no_of_pkgs = $ship->row()->no_of_pkgs;

                if($no_of_pkgs == ""){ $no_of_pkgs =1; }

                $no_of_pkgs = ($no_of_pkgs + $tripinfo['pkgs']);

                $set = array("capacity"=>$capacity,"shipment_weight"=>$shipment_weight,"shipment_volume"=>$shipment_volume,"no_of_pkgs"=>$no_of_pkgs);

                $update = $this->common->updatetbledata("tb_employee",$set,$whr);

                /*add trip pallets*/

                if(count($cargos)>0){

                    foreach($cargos as $cn){

                        if($cn != ""){

                            $insarr = array("shipment_id"=>$ship_id,"pallet_id"=>$cn,"status"=>1,"updatedon"=>$curdt);

                            $chkpallet = $this->db->select('id')->get_where("tb_shipment_pallets",$insarr,1,0);

                            if($chkpallet->num_rows() == 0){

                                $ins = $this->common->insertTableData("tb_shipment_pallets",$insarr);

                            }

                        }

                    }

                }

            }

        }

        return $resp;

    }



    public function generatetripbyordercargo($ordinput){

        $response = array();

        $userid = $ordinput['user_id'];

        $year=date('y');

        $week=date('W');

        $curtz = $ordinput['curtz'];

        $cargos = $ordinput['cargos'];

        $curdt = date('Y-m-d H:i:s');

        $count_code=substr($ordinput['company_code'], 0, 2);

        /* create new sub order under this main order (which is works like if 1 main order palletes into multiple trips then we need to follow main order and suborder rule)*/

        $ordinput['order_id'] = trim($ordinput['order_id']);

        $input['ordid'] = $ordinput['order_id'];

        $where = array("id"=>$input['ordid']);

        $select = "*";

        $table = "tb_orders";

        $order = $this->common->gettblrowdata($where,$select,$table,0,0);

        $suborder = $order;

        $subparent = $suborder['parent_id'];

        $suborder['parent_id'] = $suborder['id'];

        unset($suborder['id']);

        $input['ordid'] = $this->common->insertTableData("tb_orders", $suborder);

        if($input['ordid']>0){

            $genord = array("user_id"=>$userid,"order_id"=>$input['ordid'],"country_code"=>$count_code,"company_code"=>$ordinput['company_code']);

            $booking_id = generatebookingid($genord);

            $upd = $this->common->updatetbledata("tb_orders",array('order_id'=>$booking_id),array('id'=>$input['ordid']));

            /*insert into order_details and parties*/

            $orderdet = $this->common->gettblrowdata(array("order_row_id"=>$ordinput['order_id']),"*","tb_order_details",0,0);

            if(count($orderdet)>0){

                $orderdet['order_row_id'] = $input['ordid'];

                $orderdet['order_id'] = $booking_id;

                unset($orderdet['id']);

                $orddetid =  $this->common->insertTableData("tb_order_details", $orderdet);

            }

            $orderpart = $this->common->gettbldata(array("order_id"=>$ordinput['order_id']),"*","tb_order_parties",0,0);

            if(count($orderpart)>0){

                foreach($orderpart as $opres){

                    $opres['order_id'] = $input['ordid'];

                    $opres['order_number'] = $booking_id;

                    unset($opres['id']);

                    $ordpartid =  $this->common->insertTableData("tb_order_parties", $opres);

                }

            }

            /*update reference number*/

            if($subparent == 0){

                $getref = array('order_id'=>$ordinput['order_id'],'reference_id'=>'CTR');

                $chkref = $this->common->gettblrowdata($getref,"ref_value","tb_order_references",0,0);

                if(count($chkref)>0){

                    $ctrref = $chkref['ref_value'];

                    $addref = array('order_id'=>$input['ordid'],'reference_id'=>'CTR','ref_value'=>$ctrref,'createdon'=>$curdt);

                    $ctrrefid = $this->common->insertTableData('tb_order_references', $addref);

                }

            }else{

                $getref = array('order_id'=>$subparent,'reference_id'=>'CTR');

                $chkref = $this->common->gettblrowdata($getref,"ref_value","tb_order_references",0,0);

                if(count($chkref)>0){

                    $ctrref = $chkref['ref_value'];

                    $addref = array('order_id'=>$input['ordid'],'reference_id'=>'CTR','ref_value'=>$ctrref,'createdon'=>$curdt);

                    $ctrrefid = $this->common->insertTableData('tb_order_references', $addref);

                }

            }

            $seq_num=000001;

            if(count($order)>0){

                $order['order_id'] = $booking_id;

                $order_nm=$order['order_id'];

                $seq_num=substr($order_nm, -6);

            }

            $shipid = "T".$count_code.$week.$year.$seq_num;

            /*trip id creation ends here*/

            $vendor_id=$ordinput['carrierid'];

            $vehicle_id = isset($ordinput['tvehnum']) ? $ordinput['tvehnum'] : "";

            $driver_id = isset($ordinput['tdrivernum']) ? $ordinput['tdrivernum'] : "";

            $tpvehicle_type=isset($ordinput['vehicle_type']) ? $ordinput['vehicle_type'] : 0;

            $vehicle_type = "";

            if($shipid != "" && $vendor_id > 0 && $input['ordid'] > 0){

                if(count($order)>0){

                    $pickup = $order['pickup_address1'];

                    if($pickup == ""){ $pickup = $order['pickup_city']; }

                    $delivery = $order['delivery_address1'];

                    if($delivery == ""){ $delivery = $order['delivery_city']; }

                    $address = $dropaddr = "";

                    if($order['pickup_address1'] != ""){

                        $address .= $order['pickup_address1'];

                        $dropaddr .= $order['delivery_address1'];

                    }

                    if($order['pickup_company'] != ""){

                        $address .= ", ".$order['pickup_company'];

                        $dropaddr .= ", ".$order['delivery_company'];

                    }

                    if($order['pickup_country'] != ""){

                        $address .= ", ".$order['pickup_country'];

                        $dropaddr .= ", ".$order['delivery_country'];

                    }

                    if($order['pickup_city'] != ""){

                        $address .= ", ".$order['pickup_city'];

                        $dropaddr .= ", ".$order['delivery_city'];

                    }

                    if($order['pickup_pincode'] != ""){

                        $address .= ", ".$order['pickup_pincode'];

                        $dropaddr .= ", ".$order['delivery_pincode'];

                    }

                    $plat = $order['plat'];

                    $plng = $order['plng'];

                    $dlat = $order['dlat'];

                    $dlng = $order['dlng'];

                    $where = array("shipmentid"=>$shipid);

                    $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";

                    $table = "tb_shifts";

                    $shipment = $this->common->gettblrowdata($where,$select,$table,0,0);

                    $weight= $ordinput['weight'];

                    $volume= $ordinput['volume'];

                    $capacity = $ordinput['quantity'];

                    if($capacity == ""){ $capacity = "1"; }

                    $pkgs = $ordinput['pkgs'];

                    $pallet_name = $ordinput['pallet_name'];

                    if(count($shipment)==0){

                        $splace = $order['pickup_address1'];

                        $eplace = $order['delivery_address1'];

                        $pickup_city = $order['pickup_city'];

                        $delivery_city = $order['delivery_city'];

                        $customer_id = $order['customer_id'];

                        $transport_mode= $order['transport_mode'];

                        $txnid = $shipid;

                        if($tpvehicle_type!='' && $tpvehicle_type != 0){

                            $vtwhere = array("id"=>$tpvehicle_type);

                            $vtselect = "trucktype";

                            $vttable = "tb_trucktypes";

                            $vtorder = $this->common->gettblrowdata($vtwhere,$vtselect,$vttable,0,0);

                            if(count($vtorder)>0){

                                $vehicle_type = $vtorder['trucktype'];

                            }else{

                                $vehicle_type = $order['vehicle_type'];

                            }

                        }else{

                            $vehicle_type = $order['vehicle_type'];

                        }

                        $startdate = $order['pickup_datetime'];

                        $starttime = date('H:i',strtotime($startdate));

                        $enddate = $order['delivery_datetime'];

                        $endtime = date('H:i',strtotime($enddate));

                        /* $getactual = getdatetimebytimezone(DFLT_TZ,$enddate,$curtz);

                        $enddate = $getactual['datetime'];*/

                        $insarr = array('user_id'=>$userid, 'stime'=>$starttime, 'etime'=>$endtime, 'splace'=>$order['pickup_city'], 'slat'=>$plat, 'slng'=>$plng, 'eplace'=>$order['delivery_city'], 'elat'=>$dlat, 'elng'=>$dlng, 'scity'=>$order['pickup_city'], 'dcity'=>$order['delivery_city'], 'zone_id'=>1, 'empshift_start'=>$starttime, 'empshift_end'=>$endtime, 'trip_type'=>0, 'startdate'=>$startdate, 'enddate'=>$enddate, 'shipment_name'=>$pallet_name, 'shipment_id'=>0, 'transport_mode'=>$transport_mode, 'customer_id'=>$customer_id, 'vendor_id'=>$vendor_id, 'carrier_type'=>0, 'shipmentid'=>$shipid, 'txnid'=>$txnid,'weight'=>$weight, 'volume'=>$volume, 'units'=>$pkgs,'domainname'=>'INFD', 'vehicle_type'=>$vehicle_type,'company_code'=>$order['company_code'],'branch_code'=>$order['branch_code'], 'status'=>1);

                        $ship_id = $this->common->insertTableData("tb_shifts", $insarr);

                    }else{

                        $ship_id = $shipment['id'];

                    }

                    /*update weight n volme*/

                    $set = array("quantity"=>$capacity,"weight"=>$weight,"volume"=>$volume);

                    $update = $this->common->updatetbledata("tb_orders",$set,array("id"=>$input['ordid']));

                    /*add trip pallets*/

                    if(count($cargos)>0){

                        foreach($cargos as $cn){

                            if($cn != ""){

                                $insarr = array("shipment_id"=>$ship_id,"pallet_id"=>$cn,"status"=>1,"updatedon"=>$curdt);

                                $chkpallet = $this->db->select('id')->get_where("tb_shipment_pallets",$insarr,1,0);

                                if($chkpallet->num_rows() == 0){

                                    $ins = $this->common->insertTableData("tb_shipment_pallets",$insarr);

                                }

                            }

                        }

                    }

                    $response['order_id'] = $input['ordid'];

                    $response['trip_id'] = $ship_id;

                    /*update order table*/

                    $upddt = array('vendor_id'=>$vendor_id,'shift_id'=>$ship_id,"shipmentid"=>$shipid,'status'=>2);

                    $updwhr = array("id"=>$input['ordid']);

                    $upd = $this->common->updatetbledata("tb_orders",$upddt,$updwhr);

                    /*$this->ordernotify('trip_create',$input['ordid']);*/

                    /*insert stops records */

                    $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['pickup_city'],"stoptype"=>"P");

                    $select = "id";

                    $table = "tb_shiporder_stops";

                    $chkstop = $this->common->gettblrowdata($where,$select,$table,0,0);

                    if(count($chkstop) == 0){

                        $insarr = array('stopname'=>$order['pickup_city'], 'plat'=>$plat, 'plng'=>$plng, 'stopcity'=>$order['pickup_city'], 'address'=>$address, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['pickup_endtime'], 'weight'=>$weight, 'volume'=>$volume, 'shipmentstopid'=>0, 'ship_units'=>$pkgs, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);

                        $pickupstop_id = $this->common->insertTableData("tb_shiporder_stops",$insarr);

                    }else{

                        $pickupstop_id = $chkstop['id'];

                    }

                    $where = array("shipment_id"=>$ship_id,"stopcity"=>$order['delivery_city'],"stoptype"=>"D");

                    $select = "id";

                    $table = "tb_shiporder_stops";

                    $chkstop1 = $this->common->gettblrowdata($where,$select,$table,0,0);

                    if(count($chkstop1) == 0){

                        $insarr = array('stopname'=>$order['delivery_city'], 'plat'=>$dlat, 'plng'=>$dlng, 'stopcity'=>$order['delivery_city'], 'address'=>$dropaddr, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$order['delivery_datetime'], 'enddate'=>$order['drop_endtime'], 'weight'=>$weight, 'volume'=>$volume, 'shipmentstopid'=>0, 'ship_units'=>$pkgs, 'txncode'=>'NP', 'status'=>1, 'created_on'=>$curdt);

                        $dropstop_id = $this->common->insertTableData("tb_shiporder_stops",$insarr);

                    }else{

                        $dropstop_id = $chkstop1['id'];

                    }

                    /*add pickupstop and drop stop id into details/tb_employee table */

                    $where = array('stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id,'order_id'=>$order['order_id'], 'shift_id'=>$ship_id);

                    $select = "id";

                    $table = "tb_employee";

                    $chkemp = $this->common->gettblrowdata($where,$select,$table,0,0);

                    if(count($chkemp) == 0){

                        $insarr = array('assoc_id'=>$shipid, 'pickup'=>$pickup, 'plat'=>$plat,

                            'plng'=>$plng, 'drop'=>$delivery,'dlat'=>$dlat, 'dlng'=>$dlng, 'pickup_city'=>$order['pickup_city'], 'drop_city'=>$order['delivery_city'], 'pickup_datetime'=>$order['pickup_datetime'], 'drop_datetime'=>$order['delivery_datetime'], 'name'=>'Boxes', 'phone'=>$order['customer_phone'], 'address'=>$address,'emailid'=>$order['customer_email'], 'user_id'=>$userid, 'status'=>1, 'createdon'=>$curdt, 'material_id'=>0, 'capacity'=>$capacity, 'information'=>$order['customer_comments'], 'shipment_weight'=>$weight, 'shipment_volume'=>$volume, 'ship_type'=>'P', 'customer_id'=>$order['customer_id'], 'vendor_id'=>$vendor_id, 'shipment_id'=>0, 'startdate'=>$order['pickup_datetime'], 'enddate'=>$order['delivery_datetime'], 'shift_id'=>$ship_id, 'stop_order'=>1, 'drop_order'=>0, 'basic_stop'=>0, 'stop_id'=>$pickupstop_id, 'drop_stopid'=>$dropstop_id, 'order_id'=>$order['order_id'],'pkgitemid'=>$pallet_name, 'no_of_pkgs'=>$pkgs, 'domainname'=>'INFD');

                        $detail_id = $this->common->insertTableData("tb_employee",$insarr);

                    }else{

                        $detail_id = $chkemp['id'];

                    }

                    $response['stopdetailsid'] = $detail_id;

                    $chk1 = $this->db->select("id")->get_where("tb_shft_veh",array("shft_id"=>$ship_id,"status"=>1),1,0);

                    if($chk1->num_rows() > 0){

                        $shftvehid = $chk1->row()->id;

                        $chk = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"status"=>1),1,0);

                        if($chk->num_rows() == 0){

                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));

                            if($getemp->num_rows()>0){

                                $pri = 1;

                                foreach($getemp->result() as $gt){

                                    $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);

                                    $ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);

                                    $pri++;

                                }

                            }

                        }else{

                            $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp",array("shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"status"=>1),1,0);

                            if($chkemp->num_rows() == 0){

                                $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$detail_id,"priority"=>3,"pickup_time"=>$order['pickup_datetime'], 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$order['delivery_datetime']);

                                $ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);

                            }

                        }

                    }else{

                        if($vehicle_id != ""){

                            $veh_num = isset($ordinput['vehicle_id']) ? $ordinput['vehicle_id'] : "";

                            $arr = array('user_id'=>$userid, 'route_id'=>0, 'shft_id'=>$ship_id, 'carrier_id'=>$vendor_id, 'vehicle_id'=>$vehicle_id, 'register_number'=>$veh_num, 'created_on'=>$curdt,'updated_on'=>$curdt, 'status'=>1);

                            $shftvehid = $this->common->insertTableData("tb_shft_veh",$arr);

                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));

                            if($getemp->num_rows()>0){

                                $pri = 1;

                                foreach($getemp->result() as $gt){

                                    $insveh1 = array("user_id"=>$userid,"shft_veh_id"=>$shftvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);

                                    $ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);

                                    $pri++;

                                }

                            }

                            if($driver_id == ""){

                                $dchk = $this->db->select("id,driver_id")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicle_id,"status"=>1),1,0);

                                if($dchk->num_rows()>0){

                                    $driver_id = $dchk->row()->driver_id;

                                }

                            }

                        }

                    }

                    if($vehicle_id != "" && $driver_id != ""){

                        $chk = $this->db->select("id,driver_id,status")->order_by("id","DESC")->get_where("tb_vehicles_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id));

                        if($chk->num_rows()>0){

                            $vrr = $chk->row()->driver_id;

                            $upd = $this->db->where(array("id"=>$vrr))->update("tb_vehicles_drivers",array("status"=>1));

                        }else{

                            $arr = array('vehicle_id'=>$vehicle_id,'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);

                            $ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);

                        }

                        $chk11 = $this->db->select("id")->order_by("id","DESC")->get_where("tbl_assigned_drivers",array("driver_id"=>$driver_id,"vehicle_id"=>$vehicle_id),1,0);

                        if($chk11->num_rows()>0){

                            $upd = $this->db->where(array("vehicle_id"=>$vehicle_id))->update("tbl_assigned_drivers",array("status"=>"0",'updated_on'=>$curdt));

                            $upd = $this->db->where(array("id"=>$chk11->row()->id))->update("tbl_assigned_drivers",array("status"=>"1",'updated_on'=>$curdt));

                        }else{

                           /* $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers",array("driver_id <>"=>$driver_id,"vehicle_id"=>$vehicle_id,"status"=>1),1,0);

                            if($chk111->num_rows() == 0){ */

                                $driv = $this->db->select('id,contact_num')->get_where("tb_truck_drivers",array('id'=>$driver_id),1,0);

                                $contact_num = $driver_id;

                                $imei = $driver_id;

                                if($driv->num_rows()>0){

                                    $contact_num = $driv->row()->contact_num;

                                    $imei = $driv->row()->imei;

                                }

                                $upd = $this->db->where(array("vehicle_id"=>$vehicle_id))->update("tbl_assigned_drivers",array("status"=>0,'updated_on'=>$curdt));

                                $insarr = array("vehicle_id"=>$vehicle_id,"user_id"=>$userid,"driver_id"=>$driver_id,"mobile_no"=>$contact_num,"imei"=>$imei,"from_time"=>$curdt,"to_time"=>$curdt,"status"=>"1",'created_on'=>$curdt);

                                $ins = $this->common->insertTableData("tbl_assigned_drivers",$insarr);

                        }

                    }

                    /* update status */

                    $chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$ship_id,"status_id"=>9),1,0);

                    if($chk->num_rows() == 0){

                        $curdt1 = $ordinput['curdt'];

                        $ins = array("shipment_id"=>$ship_id,"stop_id"=>0,"order_id"=>$input['ordid'],"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status"=>1,"status_code"=>"0100","reason"=>"Coming from E-Booking","createdon"=>$curdt1);

                        $insqry = $this->common->insertTableData("tb_stop_status",$ins);

                    }

                }

            }

        }

        return $response;

    }



    public function pallezergen()

    {

        $data = $ins_sheet = array();

        $volume = $pallet_volume = $j = $purchase = $delivey = $order_id_ref =$order_num= $weight=$weight_unit=$quantity_type=$quantity= $volume_unit= $cargo_length=$cargo_length_unit= $cargo_width= $cargo_width_unit= $cargo_height= $cargo_height_unit=$pallet_volume= $pallet_width= $pallet_width_unit= $pallet_height=$pallet_height_unit=$pallet_length=$pallet_length_unit="";

        $cargoid = isset($_POST["cargoid"]) ? $_POST["cargoid"] : "";

        $pallet_type = isset($_POST["pallet_type"]) ? $_POST["pallet_type"] : "";

        $get_data = $this->db->query("SELECT o.id,o.order_id,cd.quantity_type,cd.length,cd.width,cd.height,cd.weight,cd.quantity,cd.volume,c.width_unit,c.length_unit,c.weight_unit,c.volume_unit,c.height_unit FROM tb_order_cargodetails cd LEFT JOIN tb_cargo_details c on cd.cargo_id=c.id LEFT JOIN tb_orders o on cd.order_id=o.id WHERE cd.id='$cargoid' AND cd.status=1");

        if ($get_data->num_rows() > 0) {

            foreach ($get_data->result() as $get_data_c) {

                $volume = $get_data_c->volume;

                $order_id_ref = $get_data_c->id;

                $order_num = $get_data_c->order_id;

                $weight = $get_data_c->weight;

                $weight_unit = $get_data_c->weight_unit;

                $quantity_type = $get_data_c->quantity_type;

                $quantity = $get_data_c->quantity;

                $volume = $get_data_c->volume;

                $volume_unit = $get_data_c->volume_unit;

                $cargo_length = $get_data_c->length;

                $cargo_length_unit = $get_data_c->length_unit;

                $cargo_width = $get_data_c->width;

                $cargo_width_unit = $get_data_c->width_unit;

                $cargo_height = $get_data_c->height;

                $cargo_height_unit = $get_data_c->height_unit;

                $ref = $this->db->query('SELECT reference_id,ref_value FROM tb_order_references where order_id="' . $order_id_ref . '" and reference_id IN ("DQ","PQ") AND status=1 LIMIT 2');

                $purchase = $delivey = "";

                if ($ref->num_rows() > 0) {

                    $refdata = $ref->result_array();

                    foreach ($refdata as $ref_data) {

                        if ($ref_data['reference_id'] == "DQ") {

                            $delivey = $ref_data['ref_value'];

                        } else if ($ref_data['reference_id'] == "PQ") {

                            $purchase = $ref_data['ref_value'];

                        }

                    }

                }

            }

        }

        if($pallet_type != ""){

            $res = $this->db->query("SELECT `id`,  `length`, `length_unit`,width,width_unit,`height`, `height_unit`, `weight`, `weight_unit`, `volume`, `volume_unit` FROM tb_pallet_type WHERE status=1 and id='$pallet_type'");

            if ($res->num_rows() > 0) {

                foreach ($res->result() as $get_pallet) {

                    $pallet_volume = $get_pallet->volume;

                    $pallet_width = $get_pallet->width;

                    $pallet_width_unit = $get_pallet->width_unit;

                    $pallet_height = $get_pallet->height;

                    $pallet_height_unit = $get_pallet->height_unit;

                    $pallet_length = $get_pallet->length;

                    $pallet_length_unit = $get_pallet->length_unit;

                }

            }

        }

        if ($cargo_height_unit != "" && $cargo_height_unit != "Cm") {

            $cargo_height = $this->converterLWH($cargo_height_unit, $cargo_height);

        }

        if ($cargo_width_unit != "" && $cargo_width_unit != "Cm") {

            $cargo_width = $this->converterLWH($cargo_width_unit, $cargo_width);

        }

        if ($cargo_length_unit != "" && $cargo_length_unit != "Cm") {

            $cargo_length = $this->converterLWH($cargo_length_unit, $cargo_length);

        }

        if ($pallet_length_unit != "" && $pallet_length_unit != "Cm") {

            $pallet_length = $this->converterLWH($pallet_length_unit, $pallet_length);

        }

        if ($pallet_height_unit != "" && $pallet_height_unit != "Cm") {

            $pallet_height = $this->converterLWH($pallet_height_unit, $pallet_height);

        }

        if ($pallet_width_unit != "" && $pallet_width_unit != "Cm") {

            $pallet_width = $this->converterLWH($pallet_width_unit, $pallet_width);

        }

        if ($cargo_height != "" && $cargo_width != "" && $cargo_length != "" && $pallet_height != "" && $pallet_width != "" && $pallet_length != "")

		{

            if ($cargo_height > 0 && $cargo_width > 0 && $cargo_length > 0 && $pallet_height > 0 && $pallet_width > 0 && $pallet_length > 0)

			 {

                if (($cargo_height <= $pallet_height) && ($cargo_width <= $pallet_width) && ($cargo_length <= $pallet_length))

				{

                    if ($volume != "" && $pallet_volume != "")

					{

                        $j = 1;

                        $weight1 = $weight / $volume;

                        $pack_vol = $volume / $quantity;

                        if ($pack_vol <= $pallet_volume)

						{

							$c_length=$this->compareLWH($cargo_length,$pallet_length);

							$c_width=$this->compareLWH($cargo_width,$pallet_width);

							$c_height=$this->compareLWH($cargo_height,$pallet_height);

							$get_carton_val=$c_length*$c_width*$c_height;

                            $set_pallet_volume=$get_carton_val*$pack_vol;

                            if($set_pallet_volume>=$volume){

                                $ins_sheet[] = array(

                                    'order_num' => $order_id_ref,

                                    'order_id' => $order_num,

                                    'delivey_note' => $delivey,

                                    'purchase_order' => $purchase,

                                    'package_type' => 'Pallet',

                                    'quantity' => 1,

                                    'weight' => $weight,

                                    'weight_unit' => $weight_unit,

                                    'volume' => $volume,

                                    'volume_unit' => $volume_unit,

                                    'status' => 1

                                );

							}else{

                                for ($i = $pallet_volume; $volume > 0; $volume -= $set_pallet_volume)

                                {

                                    $j ++;

                                    $a = $volume;

                                    $get_volume = $set_pallet_volume;

                                    if ($a < $get_volume) {

                                        $get_volume = $a;

                                    }

							        $get_weight = $weight1 * $get_volume;

                                    $ins_sheet[] = array(

                                        'order_num' => $order_id_ref,

                                        'order_id' => $order_num,

                                        'delivey_note' => $delivey,

                                        'purchase_order' => $purchase,

                                        'package_type' => 'Pallet',

                                        'quantity' => 1,

                                        'weight' => $get_weight,

                                        'weight_unit' => $weight_unit,

                                        'volume' => $get_volume,

                                        'volume_unit' => $volume_unit,

                                        'status' => 1

                                    );

                                }

						    }

                        }else{

							$data['msg'][]="Cargo caton dimension exceeds by pallet dimensions";

							/*log_message('error', "Cargo caton dimension exceeds by pallet dimensions");*/

						}

                    }else{

						$data['msg'][] ="cargo volume or  pallet volume is null";

						/*log_message('error', "cargo volume or  pallet volume is null ");*/

					}

                } else {

					$data['msg'][]="cargo dimension exceeds by pallet dimensions";

                   /*log_message('error', "cargo dimension exceeds by pallet dimensions");*/

                }

            }else{

				$data['msg'][]="cargo data or  pallet data is null or 0";

				/*log_message('error', "cargo data or  pallet data is null or 0 ");*/

			}

        }else{

			$data['msg'][]="cargo data or  pallet data is null ";

			/*log_message('error', "cargo data or  pallet data is null ");*/

		}

        if (! empty($ins_sheet)) {

            $whr = array();

            $this->db->set(array('status'=>0))->where($whr)->update('tb_pallet_distribution');

            $this->db->insert_batch('tb_pallet_distribution', $ins_sheet);

			$data['msg'][]="pallet Generated successfully completed";

        }

        echo json_encode($data);

    }



    public function converterLWH($units, $val_data)

    {

        $final_data = 0;

        if ($units == "M") {

            $final_data = $val_data * 100;

        } else if ($units == "Inches") {

            $final_data = $val_data * 2.54;

        }

        return $final_data;

    }



    public function compareLWH($c_data, $p_data)

    {

		$j=0;

		for($i=$c_data;$p_data>=$i;$i+=$c_data){

			$j++;

		}

        return $j;

    }



    public function pallezerMultigen(){

		$data = $ins_sheet =$get_data=$order_data= $sdata=$get_r_data=$data_lwh_array=array();

        $volume = $pallet_volume = $j = $purchase = $delivey = $order_id_ref =$order_num= $weight=$weight_unit=$quantity_type=$quantity= $volume_unit= $cargo_length=$cargo_length_unit= $cargo_width= $cargo_width_unit= $cargo_height= $cargo_height_unit=$pallet_volume=$pallet_width=$pallet_width_unit= $pallet_height=$pallet_height_unit=$pallet_length=$pallet_length_unit="";

        $cargoid = isset($_POST["cargoid"]) ? $_POST["cargoid"] :"";

        $pallet_type = isset($_POST["pallet_type"]) ? $_POST["pallet_type"] : "";

		$cargo_id =  implode(',', $cargoid);

		$cargo_id = trim($cargo_id, "'");

		$res = $this->db->query("SELECT `id`,  `length`, `length_unit`,width,width_unit,`height`, `height_unit`, `weight`, `weight_unit`, `volume`, `volume_unit` FROM tb_pallet_type WHERE status=1 and id='$pallet_type'");

        if ($res->num_rows() > 0) {

            foreach ($res->result() as $get_pallet) {

                $pallet_volume = $get_pallet->volume;

                $pallet_width = $get_pallet->width;

                $pallet_width_unit = $get_pallet->width_unit;

                $pallet_height = $get_pallet->height;

                $pallet_height_unit = $get_pallet->height_unit;

                $pallet_length = $get_pallet->length;

                $pallet_length_unit = $get_pallet->length_unit;

            }

        }

        /* Pallet DATA */

        if ($pallet_length_unit != "" && $pallet_length_unit != "Cm") {

            $pallet_length = $this->converterLWH($pallet_length_unit, $pallet_length);

        }

        if ($pallet_height_unit != "" && $pallet_height_unit != "Cm") {

            $pallet_height = $this->converterLWH($pallet_height_unit, $pallet_height);

        }

        if ($pallet_width_unit != "" && $pallet_width_unit != "Cm") {

            $pallet_width = $this->converterLWH($pallet_width_unit, $pallet_width);

        }

        $data_lwh_array[]=array($pallet_length,$pallet_height,$pallet_width);

        $get_data = $this->db->query("SELECT o.id,o.order_id,cd.quantity_type,cd.length,cd.width,cd.height,cd.weight,cd.quantity,cd.volume,c.width_unit,c.length_unit,c.weight_unit,c.volume_unit,c.height_unit, (cd.width*cd.height*cd.length) as volume_pak FROM tb_order_cargodetails cd LEFT JOIN tb_cargo_details c on cd.cargo_id=c.id LEFT JOIN tb_orders o on cd.order_id=o.id WHERE cd.id IN ($cargo_id) ORDER BY volume_pak DESC ");

        if ($get_data->num_rows() > 0) {

            foreach ($get_data->result() as $get_data_c) {

                $volume = $get_data_c->volume;

                $order_id_ref= $get_data_c->id;

                $ref = $this->db->query('SELECT reference_id,ref_value FROM tb_order_references where status=1 and order_id="' . $order_id_ref . '" and reference_id IN ("DQ","PQ")');

                $purchase = $delivey = "";

                $ref_data=array();

                if ($ref->num_rows() > 0) {

                    $refdata = $ref->result_array();

                    foreach ($refdata as $ref_data) {

                        if ($ref_data['reference_id'] == "DQ") {

                            $delivey = $ref_data['ref_value'];

                        } else if ($ref_data['reference_id'] == "PQ") {

                            $purchase = $ref_data['ref_value'];

                        }

                    }

                }

                $get_r_data[]=array('volume'=>$get_data_c->volume,'order_id_ref'=>$get_data_c->id,'order_num'=>$get_data_c->order_id,'weight'=>$get_data_c->weight,'weight_unit'=>$get_data_c->weight_unit,'quantity_type'=>$get_data_c->quantity_type,'quantity'=>$get_data_c->quantity,'volume_unit'=>$get_data_c->volume_unit,'cargo_length'=>$get_data_c->length,'cargo_length_unit'=>$get_data_c->length_unit,'cargo_width'=>$get_data_c->width,'cargo_width_unit'=>$get_data_c->width_unit,'cargo_height'=>$get_data_c->height,'cargo_height_unit'=>$get_data_c->height_unit,'purchase'=>$purchase,'delivey'=>$delivey);

                if ($get_data_c->height_unit != "" && $get_data_c->height_unit != "Cm") {

                    $cargo_height = $this->converterLWH($get_data_c->height_unit, $get_data_c->height);

                }

                if ($get_data_c->width_unit != "" && $get_data_c->width_unit != "Cm") {

                    $cargo_width = $this->converterLWH($get_data_c->width_unit, $get_data_c->width);

                }

                if ($get_data_c->length_unit != "" && $get_data_c->length_unit != "Cm") {

                    $cargo_length = $this->converterLWH($get_data_c->length_unit, $get_data_c->length);

                }

                if ($cargo_height != "" && $cargo_width != "" && $cargo_length != "" && $pallet_height != "" && $pallet_width != "" && $pallet_length != "")

                {

                    if ($cargo_height > 0 && $cargo_width > 0 && $cargo_length > 0 && $pallet_height > 0 && $pallet_width > 0 && $pallet_length > 0)

                    {

                        if (($cargo_height <= $pallet_height) && ($cargo_width <= $pallet_width) && ($cargo_length <= $pallet_length))

                        {

                            if ($volume != "" && $pallet_volume != "")

                            {
                                $data_lwh_array[]=array($cargo_height,$cargo_width,$cargo_length);
                            }
                        }
                    }
                }
            }
    	}
	}
}

?>
