<?php

defined('BASEPATH') or exit('No direct script access allowed');

class KNrateconversionfactor extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("Knratemodel");
        if (!checkUrlAccessForUser('KNRATECONVERSIONFACTOR')) {
            redirect("Forbiddenaccess");
        }
    }

    /* conversion factor list page */

    public function index() {
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('conversion_factor');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["list"] = array();
        if ($company_code == "RUKN") {
            $where['uo.company_code'] = $company_code;
        } else {
            $where['uo.user_id'] = $user_id;
        }
        $cn = substr($company_code, 0, 2);
        $where['uo.status'] = 1;
        $select = "uo.*,cs.name as cus_name";
        $whr = array();
        $str = "";
        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == 'search') {
            $country = $this->input->post('country', TRUE);
            $billing_uom = $this->input->post('base_uom', TRUE);
            $uom_conversion_id = $this->input->post('uom_conversion_id', TRUE);
            $tariff_type = $this->input->post('tariff_type', TRUE);

            if ($country != '') {
                $cntry = $this->Knratemodel->getcountrybyname(array("country_name" => $country, "status" => 1));
                if (count($cntry) > 0) {
                    $where['uo.country'] = $cntry['country_code'];
                    $str = $cntry['country_name'];
                }
            }
            if ($billing_uom != '') {
                $whr['uo.base_uom'] = $billing_uom;
            }

            if ($uom_conversion_id != '') {
                $whr['uo.conversion_id'] = $uom_conversion_id;
            }

            if ($tariff_type != '' && $tariff_type !='SELECT') {
                $whr['uo.type'] = $tariff_type;
            }
        }
        if (isset($_POST['adv_searchsubmit']) && $_POST['adv_searchsubmit'] == 'Search') {
            $country = $this->input->post('country', TRUE);
            $billing_uom = $this->input->post('adv_base_uom', TRUE);
            $uom_conversion_id = $this->input->post('adv_uom_conversion_id', TRUE);
            $tariff_type = $this->input->post('adv_tariff_type', TRUE);

            if ($country != '') {
                $cntry = $this->Knratemodel->getcountrybyname(array("country_name" => $country, "status" => 1));
                if (count($cntry) > 0) {
                    $where['uo.country'] = $cntry['country_code'];
                    $str = $cntry['country_name'];
                }
            }
            if ($billing_uom != '') {
                $whr['uo.base_uom'] = $billing_uom;
            }

            if ($uom_conversion_id != '') {
                $whr['uo.conversion_id'] = $uom_conversion_id;
            }

            if ($tariff_type != '' && $tariff_type !='SELECT') {
                $whr['uo.type'] = $tariff_type;
            }
        }
        $getConversionData = $this->Knratemodel->getConversionData($select, $where, $whr, $str);
        if (!empty($getConversionData)) {
            $data["list"] = $getConversionData;
        }
        //$data["list"]=$this->get_data($select,$where,$whr);
        /* log_message('error', $this->db->last_query()); */

        $this->newtemplate->dashboard("KNrateconversionfactor/index", $data);
    }

    public function add() {
        $data['currencies'] = array();
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $where = array(
            'status' => 1
        );
        $data['country'] = $this->Knratemodel->getcountry();
        $data['currency'] = $_SESSION['usr_tzone']['currency'];
        $data["page_title"] = $this->lang->line('conversion_factor');
        $data["sub_title"] = $this->lang->line('general_add');

        //$this->newtemplate->dashboard("KNrateconversionfactor/add", $data);
        $this->load->view("KNrateconversionfactor/add", $data);
    }

    public function insert($id = null) {
        $result = "";

        $user_id = $this->session->userdata('user_id');
        $branch_code = $this->session->userdata('branch_code');
        $post = $this->input->post();
        $insdata['user_id'] = $user_id;
        $insdata['branch_code'] = $branch_code;
        $insdata['company_code'] = isset($post['company_code']) ? $post['company_code'] : "";

        $insdata['name'] = isset($post['name']) ? $post['name'] : "";
        $insdata['country'] = isset($post['country']) ? $post['country'] : "";
        $insdata['base_uom'] = isset($post['billing_uom']) ? $post['billing_uom'] : "";
        $insdata['customer_id'] = isset($post['customerid']) ? $post['customerid'] : 0;
        if (empty($insdata['customer_id'])) {
            $insdata['customer_id'] = 0;
        }


        $insdata['carrier_id'] = isset($post['vendorid']) ? $post['vendorid'] : 0;
        $vendor_in_id = isset($post['vendor_id']) ? $post['vendor_id'] : 0;
        if (((empty($vendor_in_id)) || empty($insdata['carrier_id'])) || $insdata['carrier_id'] == "") {
            $insdata['carrier_id'] = 0;
        }
        $insdata['Type'] = isset($post['tariff_type']) ? trim($post['tariff_type']) : "";
        $customer_in_id = isset($post['customer_id']) ? $post['customer_id'] : 0;

        if ($insdata['Type'] == "BUY" || empty($customer_in_id)) {
            $insdata['customer_id'] = 0;
        }

        $insdata['uom_type1'] = isset($post['uom1']) ? $post['uom1'] : "";
        $insdata['uom1'] = isset($post['uom1_m']) ? $post['uom1_m'] : "";
        $insdata['uom1_conversion'] = isset($post['uom1_rate']) ? $post['uom1_rate'] : 0;
        $insdata['uom1_conversion'] = str_replace(',', '.', $insdata['uom1_conversion']);

        $insdata['uom_type2'] = isset($post['uom2']) ? $post['uom2'] : "";
        $insdata['uom2'] = isset($post['uom2_m']) ? $post['uom2_m'] : "";
        $insdata['uom2_conversion'] = isset($post['uom2_rate']) ? $post['uom2_rate'] : 0;
        $insdata['uom2_conversion'] = str_replace(',', '.', $insdata['uom2_conversion']);

        $uom_type3 = isset($post['uom3']) ? $post['uom3'] : "";
        $uom3 = isset($post['uom3_m']) ? $post['uom3_m'] : "";
        $insdata['uom3_conversion'] = isset($post['uom3_rate']) ? $post['uom3_rate'] : 0;
        if (empty($insdata['uom3_conversion'])) {
            $insdata['uom3_conversion'] = 0;
        } else {
            $insdata['uom3_conversion'] = str_replace(',', '.', $insdata['uom3_conversion']);
        }
        if ($uom_type3 == "SELECT") {
            $uom_type3 = "";
        }
        if ($uom3 == "SELECT") {
            $uom3 = "";
        }
        $insdata['uom_type3'] = $uom_type3;

        $insdata['uom3'] = $uom3;
        $uom_type4 = isset($post['uom4']) ? $post['uom4'] : "";
        $uom4 = isset($post['uom4_m']) ? $post['uom4_m'] : "";
        $insdata['uom4_conversion'] = isset($post['uom4_rate']) ? $post['uom4_rate'] : 0;
        if (empty($insdata['uom4_conversion'])) {
            $insdata['uom4_conversion'] = 0;
        } else {
            $insdata['uom4_conversion'] = str_replace(',', '.', $insdata['uom4_conversion']);
        }
        if ($uom_type4 == "SELECT") {
            $uom_type4 = "";
        }
        if ($uom4 == "SELECT") {
            $uom4 = "";
        }
        $insdata['uom_type4'] = $uom_type4;
        $insdata['uom4'] = $uom4;
        if ($id == null) {
            $insdata['conversion_id'] = $this->idgen();
            $insdata['createdon'] = date("Y-m-d h:i:s");
            $result = $this->common->insertTableData('tb_knuom_conversion', $insdata);
        } else {
            $insdata['updatedon'] = date("Y-m-d h:i:s");
            $where = array('id' => $id);
            $result = $this->common->updatetbledata('tb_knuom_conversion', $insdata, $where);
        }



        /*  log_message('error',json_encode($this->input->post()));
          log_message('error',json_encode($insdata)); */
        //echo json_encode($result);
        redirect('KNrateconversionfactor');
    }

    public function idgen() {
        $gen_id = 0;
        $year = date('y');
        $week = date('W');
        $res = $this->db->query("SELECT conversion_id FROM tb_knuom_conversion ORDER BY id DESC LIMIT 1");
        if ($res->num_rows() > 0) {
            $get_id = $res->row()->conversion_id;
            $get_id_c = strlen($get_id);
            if ($get_id_c > 7) {

                $previous_weeknumber = substr($get_id, 4, 2);
                $get_id1 = substr($get_id, 6);
                $get_id2 = ltrim($get_id1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_id2;
                    $i_id ++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $gen_id = "CF" . $year . $week . $id1;
            $chk = $this->db->query("select conversion_id FROM tb_knuom_conversion WHERE conversion_id='" . $gen_id . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $gen_id = "CF" . $year . $week . $ii_d;
            } else {
                $gen_id = $gen_id;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $gen_id = "CF" . $year . $week . $id1;
        }

        return $gen_id;
    }

    public function edit($id) {
        $company_code = $this->session->userdata('company_code');
        $data["page_title"] = $this->lang->line('conversion_factor');
        $data["sub_title"] = $this->lang->line('general_edit');
        $user_id = $this->session->userdata('user_id');
        $where = array('uo.id' => $id);
        $select = "uo.*,cs.name as cus_name,cs.code as cid,v.code as vendor_code,v.name as vendor_name";
        $whr = array();
        $data["edit_list"] = array();
        $list = $this->Knratemodel->getConversionData($select, $where, $whr);
        foreach ($list as $get_list) {
            $data["edit_list"] = $get_list;
        }
        $data['country'] = $this->Knratemodel->getcountry();
        //print_r($data);
        /*   log_message('error',json_encode($data["edit_list"])); */
        //$this->newtemplate->dashboard("KNrateconversionfactor/edit", $data);
        $this->load->view("KNrateconversionfactor/edit", $data);
    }

    public function view($id) {
        $company_code = $this->session->userdata('company_code');
        $data["page_title"] = $this->lang->line('conversion_factor');
        $data["sub_title"] = $this->lang->line('general_edit');
        $user_id = $this->session->userdata('user_id');
        $where = array('uo.id' => $id);
        $select = "uo.*,cs.name as cus_name,cs.code as cid,v.name as vendor_name";
        $whr = array();
        $data["edit_list"] = array();
        $list = $this->Knratemodel->getConversionData($select, $where, $whr);
        foreach ($list as $get_list) {
            $data["edit_list"] = $get_list;
        }
        /* $data['country']=$this->Knratemodel->getcountry(); */
        //print_r($data);
        //$this->newtemplate->dashboard("KNrateconversionfactor/view", $data);
        $this->load->view("KNrateconversionfactor/view", $data);
    }

    public function getCustomerslist() {
        $result = $where = array();
        $select = 'id,cid,code,name,phone,company_code,branch_code';
        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');

        if ($company_code == "RUKN") {
            $where = array('status' => 1, 'code !=' => null, 'company_code' => $company_code);
        } else {
            $where = array('status' => 1, 'code !=' => null, 'user_id' => $uid);
            //$where = array('status'=>1,'cid !='=> null);
        }
        if ($this->input->post('cid')) {
            $where['code'] = $this->input->post('cid');
        }
        if ($this->input->post('term')) {
            $like['code'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $this->load->model('mastersmodel');
        $chkqry = $this->mastersmodel->getsearchdata($like, $where, $select, 'tb_customers');
        /*  log_message('error',"Query data:".$this->db->last_query()); */
        if (count($chkqry) > 0) {
            foreach ($chkqry as $res) {
                $check = "<input type='radio' name='listcustomer' id='listcustomer_" . $res['id'] . "' class='listcustomer' onchange='selectcustomer(" . $res['id'] . ")' value='" . $res['code'] . "'>";
                $result[] = array('check' => $check, 'cid' => $res['cid'], 'code' => $res['code'], 'name' => $res['name'], 'company_code' => $res['company_code'], 'branch_code' => $res['branch_code']);
            }
        }
        /* log_message('error',"cus data:". json_encode($result)); */
        echo json_encode($result);
    }

    public function getVendorslist() {

        $result = $where = array();
        $select = 'id,code,name,mobile,company_code,branch_code';
        $uid = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');

        if ($company_code == "RUKN") {
            $where = array('status' => 1, 'code !=' => null, 'company_code' => $company_code);
        } else {
            $where = array('status' => 1, 'code !=' => null, 'user_id' => $uid);
            //$where = array('status'=>1,'cid !='=> null);
        }
        if ($this->input->post('code')) {
            $where['code'] = $this->input->post('code');
        }
        if ($this->input->post('term')) {
            $like['code'] = $this->input->post('term');
        } else {
            $like = array();
        }
        $this->load->model('mastersmodel');
        $chkqry = $this->mastersmodel->getsearchdata($like, $where, $select, 'tb_vendors');
        /* log_message('error',"Query data:".$this->db->last_query()); */
        if (count($chkqry) > 0) {
            foreach ($chkqry as $res) {
                $check = "<input type='radio' name='listcustomer' id='listcustomer_" . $res['id'] . "' class='listcustomer' onchange='selectvendor(" . $res['id'] . ")' value='" . $res['code'] . "'>";
                $result[] = array('check' => $check, 'code' => $res['code'], 'name' => $res['name'], 'company_code' => $res['company_code'], 'branch_code' => $res['branch_code']);
            }
        }
        /* log_message('error',"cus data:". json_encode($result)); */
        echo json_encode($result);
    }

    function generate_drop_down() {

        $type = $this->input->post('type');

        $this->load->helper('drop_down_helper');

        $response = get_measurement_units($type, 'SELECT');

        echo $response;
    }

    public function delete($id) {
        $result = $this->common->updatetbledata(' tb_knuom_conversion', array('status' => 0), array('id' => $id));
        if ($result) {

            echo "1";
        } else {

            echo "0";
        }
    }

    public function checkname() {
        $post = $this->input->post();
        $id = isset($post['id']) ? $post['id'] : "";
        $name = isset($post['name']) ? $post['name'] : "";
        $user_id = $this->session->userdata('user_id');
        ;
        $where = array(
            'name' => $name,
            'user_id' => $user_id
        );
        if ($id) {
            $where['id !='] = $id;
        }
        $get_data = $this->common->gettblrowdata($where, 'name', 'tb_knuom_conversion', 0, 0);
        if (empty($get_data)) {

            echo "2";
        } else {

            echo "1";
        }
    }

}
