<?php
defined('BASEPATH') or exit('No direct script access allowed');

class KNraterecord extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("orderrevenuesmodel");
        if (!checkUrlAccessForUser('KNRATERECORD')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
         $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('KNraterecord');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["rate_rec"] = array();
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        $wher = array(
            'rr.status' => 1,'rr.company_code'=>$company_code
        );
        $whr = array();
        if (! empty($post)) {
            extract($post);
            if (isset($company_code) && $company_code != "") {
                $whr['rr.company_code'] = $company_code;
            }
            if (isset($branch_code) && $branch_code != "") {
                $whr['rr.branch_code'] = $branch_code;
            }
            if (isset($rate_id) && $rate_id != "") {
                $whr['rr.rate_id'] = $rate_id;
            }
            if (isset($offering_id) && $offering_id != "") {
                $whr['ro.offering_id'] = $offering_id;
            }

            if (isset($from_date) && $from_date != "") {
                $fromdate1 = date('Y-m-d', strtotime($from_date));
                $wher["DATE_FORMAT(rr.createdon,'%Y-%m-%d') >="] = $fromdate1;
            }
            if (isset($to_date) && $to_date != "") {
                $todate1 = date('Y-m-d', strtotime($to_date));
                $wher["DATE_FORMAT(rr.updatedon,'%Y-%m-%d') <="] = $todate1;
            }
        }
            $data['rate_rec'] = $this->getrecordtabl($wher, $whr);

        $this->newtemplate->dashboard("knraterecord/index", $data);
    }

    public function add()
    {
        $data['currencies']=array();
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data['currency'] = $_SESSION['usr_tzone']['currency'];
        $data["page_title"] = $this->lang->line('KNraterecord');
        $data["sub_title"] = $this->lang->line('general_add');
        $whr = array(
            'status' => 1,'company_code'=>$company_code
        ); $whr1 = array(
            'status' => 1
        );
        $allwhere = array(
            'status' => 1,
            'company_code' => $this->session->userdata('company_code'),
            'branch_code' => $this->session->userdata('branch_code')
        );
        if($company_code == 'RUKN'){
            $allwhere1 = array('company_code'=>$company_code,'status' => 1);
        }else{
            $allwhere1 = array('company_code!='=>'RUKN','status' => 1);
        }

        //$data['ref'] = $this->common->gettbldata($whr1, 'id,order_id,reference_id', 'tb_order_references', 0, 0);
      //$data['ref'] = $this->common->gettbldata($whr1, 'id,name,description', 'tb_reference_master', 0, 0);
      //SELECT `id`, `name`, `description`, `status`, `createdon`, `updatedon` FROM `tb_reference_master` WHERE 1
        $data_ref = $this->db->query("SELECT id,name,description FROM tb_reference_master where status = 1  ORDER BY id ASC");
        $data['ref']=$data_ref->result_array();
        $data['vaslist'] = $this->common->gettbldata($allwhere1, 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        $res = $this->db->query("SELECT id,charge_code,name FROM tb_charge_codes where status = 1  ORDER BY charge_code ASC");
        $data['chr']=$res->result_array();
        $data['offering_ids'] = $this->common->gettbldata($whr, 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
        $data['tier'] = $this->common->gettbldata($whr, ' `id`, `tier_id`, `tier_name`', 'tb_tier_master', 0, 0);
        $data['geo_tier'] = $this->common->gettbldata($whr, ' `id`, `geo_tier_id`, `geo_tier_name`', ' tb_geo_tier', 0, 0);
        $data['exch_id'] = $this->common->gettbldata($whr, ' `id`, `exchange_rate_id`, `exchange_rate_name`', 'tb_rate_exchange', 0, 0);
       $res=$this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
        if($res->num_rows() > 0){
            foreach ($res->result() as $cur) {
                $data['currencies'][] = $cur->currency;
            }
        }

        //$this->newtemplate->dashboard("knraterecord/add", $data);
        $this->load->view("knraterecord/add", $data);
    }
    /* Rate Record Edit Function */
    public function edit($id){
        $data=array();
         $company_code = $this->session->userdata('company_code');
        $data['currency'] = $_SESSION['usr_tzone']['currency'];
        $data["page_title"] = $this->lang->line('KNraterecord');
        $data["sub_title"] = $this->lang->line('general_edit');
        $data['currencies']=array();
        $whr = array(
            'status' => 1,'company_code'=>$company_code
        );
        $whr1 = array(
            'status' => 1
        );
        $allwhere = array(
            'status' => 1,
            'company_code' => $this->session->userdata('company_code'),
            'branch_code' => $this->session->userdata('branch_code')
        );
        if($company_code == 'RUKN'){
            $allwhere1 = array('company_code'=>$company_code,'status' => 1);
        }else{
            $allwhere1 = array('company_code!='=>'RUKN','status' => 1);
        }

        //$data['ref'] = $this->common->gettbldata($whr1, 'id,order_id,reference_id', 'tb_order_references', 0, 0);
        $data_ref = $this->db->query("SELECT id,name,description FROM tb_reference_master where status = 1  ORDER BY id ASC");
        $data['ref']=$data_ref->result_array();
        $data['vaslist'] = $this->common->gettbldata($allwhere1, 'id,vas_id,vas_name', 'tb_vas_master', 0, 0);
        $res = $this->db->query("SELECT id,charge_code,name FROM tb_charge_codes where status = 1  ORDER BY charge_code ASC");
        $data['chr']=$res->result_array();
        $data['offering_ids'] = $this->common->gettbldata($whr, 'id,offering_id,offering_name', 'tb_rate_offerings', 0, 0);
        $data['tier'] = $this->common->gettbldata($whr, ' `id`, `tier_id`, `tier_name`', 'tb_tier_master', 0, 0);
        $data['geo_tier'] = $this->common->gettbldata($whr, ' `id`, `geo_tier_id`, `geo_tier_name`', ' tb_geo_tier', 0, 0);
        $data["rate_rec"] = array();
        $qry = $this->db->query("SELECT rr.*,ro.offering_name FROM `tb_rate_records` rr LEFT JOIN tb_rate_offerings ro ON rr.offering_id=ro.id WHERE rr.status=1 and rr.id='$id'");
        if ($qry->num_rows() > 0) {
            $data['rate_rec'] = $qry->row_array();
        }
        $data['exch_id'] = $this->common->gettbldata($whr, ' `id`, `exchange_rate_id`, `exchange_rate_name`', 'tb_rate_exchange', 0, 0);

        $res=$this->db->query("SELECT DISTINCT currency  FROM `tbl_country_master`WHERE status=1  ORDER BY currency");
        if($res->num_rows() > 0){
            foreach ($res->result() as $cur) {
                $data['currencies'][] = $cur->currency;
            }
        }



         //$this->newtemplate->dashboard("knraterecord/edit", $data);
         $this->load->view("knraterecord/edit", $data);

    }
    /* Rate Record view */
    public function view($id){
        $data=array();
        $data["rate_rec"] = array();
        $data["page_title"] = $this->lang->line('KNraterecord');
        $data["sub_title"] = $this->lang->line('general_view');
        $qry = $this->db->query("SELECT rr.*,ro.offering_id offering_name FROM `tb_rate_records` rr LEFT JOIN tb_rate_offerings ro ON rr.offering_id=ro.id WHERE rr.status=1 and rr.id='$id'");
        if ($qry->num_rows() > 0) {
            $data['rate_rec'] = $qry->row_array();
        }
         //$this->newtemplate->dashboard("knraterecord/view", $data);
        $this->load->view("knraterecord/view", $data);
    }

   /* Get  Vas Name */
    public function getvasname()
    {
        $id = $this->input->post('id', TRUE);
        $vas = array();
        if (! empty($id)) {
            $vas = $this->common->gettblrowdata(array(
                'id' => $id
            ), 'vas_name', 'tb_vas_master', 0, 0);
        }
        echo json_encode($vas);
    }

    public function getrefval()
    {
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $data = array();
        $ref_id = isset($ref_id) ? $ref_id : 0;
        //$qry = $this->db->query("SELECT rm.description ,tor.ref_value FROM `tb_reference_master` rm INNER JOIN tb_order_references tor ON tor.reference_id = rm.name where tor.id='" . $ref_id . "'");
       $qry = $this->db->query("SELECT description FROM `tb_reference_master` where id='" . $ref_id . "'");
        if ($qry->num_rows() > 0) {
            $data = $qry->row_array();
        }
        echo json_encode($data);
    }
/* Rate Record Condition Save add page  */
    public function conditionssave($id = null)
    {
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $data = array();
        $condata = array(
            'ref_id' => isset($ref_id) ? $ref_id : "",
            'ref_name' => isset($ref_name) ? $ref_name : "",
            'ref_value' => isset($ref_val) ? $ref_val : "",
            'condition_type' => isset($cond_type) ? $cond_type : ""
        );

        if ($id == null) {
            $condata['status'] = 1;
            $condata['rate_record_id'] = 0;
            $data['rr_con_id'] = $this->common->insertTableData("tb_raterecord_conditions", $condata);
        } else {
            $condata['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_raterecord_conditions', $condata, array(
                'id' => $id
            ));
            $data['rr_con_id'] = $id;
        }
        echo json_encode($data);
    }
    /* Rate Record Condition Save edit page  */
    public function editconditionssave($id)
    {
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $data = array();
        $condata = array(
            'rate_record_id' => $id,
            'ref_id' => isset($ref_id) ? $ref_id : "",
            'ref_name' => isset($ref_name) ? $ref_name : "",
            'ref_value' => isset($ref_val) ? $ref_val : "",
            'condition_type' => isset($cond_type) ? $cond_type : ""
        );
            $condata['status'] = 1;
            $data['rr_con_id'] = $this->common->insertTableData("tb_raterecord_conditions", $condata);
            echo json_encode($data);
    }

    public function showcondetails()
    {
        $ids = isset($_POST['con_ids']) ? $_POST['con_ids'] : "";
        $data = array();
        if ($ids != "") {
            $con_ids1 = implode(',', $ids);
            if (! empty($con_ids1)) {
                $qry = $this->db->query("SELECT * FROM tb_raterecord_conditions WHERE id IN (" . $con_ids1 . ") AND status='1' GROUP BY id ORDER BY id DESC");

                if ($qry->num_rows() > 0) {

                    foreach ($qry->result() as $res) {
                        $reference_id = "";
                        $chk_s = $this->db->select('name')->get_where('tb_reference_master', array(
                            'id' => $res->ref_id
                        ));
                        if ($chk_s->num_rows() > 0) {
                            $reference_id = $chk_s->row()->name;
                        }
                        $info = array('id'=>$res->id,'ref_id'=>htmlentities($res->ref_name,ENT_QUOTES),'ref_name'=>htmlentities($res->ref_name,ENT_QUOTES),'ref_value'=>htmlentities($res->ref_value,ENT_QUOTES),'condition_type'=>$res->condition_type);
                        $info = htmlentities(json_encode($info));
                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default' onclick='rowcondiEdit(this," . $info . ");' ><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletecondetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";
                        $data[] = array(
                            'ref_id' => $reference_id,
                            'ref_name' => $res->ref_name,
                            'ref_value' => $res->ref_value,
                            'condition_type' => $res->condition_type,
                            'action' => $action
                        );
                    }
                }
            }
        }
        echo json_encode($data);
    }
 
    public function getcondetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : "";
        $data = array();

                $qry = $this->db->query("SELECT * FROM tb_raterecord_conditions WHERE rate_record_id='$id' AND status='1' ORDER BY id DESC");

                if ($qry->num_rows() > 0) {
                    $reference_id = "";
                    foreach ($qry->result() as $res) {

                        $chk_s = $this->db->select('name')->get_where('tb_reference_master', array(
                            'id' => $res->ref_id
                        ));
                        if ($chk_s->num_rows() > 0) {
                            $reference_id = $chk_s->row()->name;
                        }
                        $info = array('id'=>$res->id,'ref_id'=>htmlentities($res->ref_id,ENT_QUOTES),'ref_name'=>htmlentities($res->ref_name,ENT_QUOTES),'ref_value'=>htmlentities($res->ref_value,ENT_QUOTES),'condition_type'=>$res->condition_type);
                        $info = htmlentities(json_encode($info));
                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default' onclick='rowcondiEdit(this," . $info . ");' ><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletecondetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";
                        $data[] = array(
                            'ref_id' => $reference_id,
                            'ref_name' => $res->ref_name,
                            'ref_value' => $res->ref_value,
                            'condition_type' => $res->condition_type,
                            'action' => $action
                        );
                    }
                }


        echo json_encode($data);
    }


    public function deletecondetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id')->get_where('tb_raterecord_conditions', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {

                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_raterecord_conditions', array(
                    'status' => 0
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function getrefval1()
    {
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $data = array();
        $vas_id = isset($vas_id) ? $vas_id : 0;
        $qry = $this->db->query("SELECT  vas_name FROM `tb_vas_master` WHERE id='" . $vas_id . "'");
        if ($qry->num_rows() > 0) {
            $data = $qry->row_array();
        }
        echo json_encode($data);
    }
   /* save and update charges add page */
    public function saverrcharge($id = null)
    {
        $post   = $this->input->post(NULL, TRUE);
        $rr_exch_id = $post['rr_exch_id'] ?? 0;
        $geo_tier_id = $post['geo_tier_id'] ?? 0;
        $tier_id = $post['tier_id'] ?? 0;
        $rr_charge_id = $post['rr_charge_id'] ?? 0;
        $rr_min_amount=isset($post['rr_min_amount']) ? trim($post['rr_min_amount']) : 0.000000;
        if($rr_min_amount == "" || empty($rr_min_amount)){ $rr_min_amount=0.000000; }
        $rr_amount=isset($post['rr_amount']) ? trim($post['rr_amount']) : 0.000000;
		if($rr_amount == "" || empty($rr_amount)){ $rr_amount=0.000000; }
        $rr_percentage = $post['rr_percentage'] ?? "";
        $fuel_surcharge = $post['fuel_surcharge'] ?? 0;
        $chargeData = [
            'exchange_rate_id' => $rr_exch_id,
            'rr_charge_type' => $post['charge_type'] ?? null,
            'geo_tier_id' => $geo_tier_id ?? 0,
            'rr_tier_id' => $tier_id ?? 0,
            'rr_charge_id' => $rr_charge_id,
            'charge_basis' => $post['rr_char_basis'] ?? null,
            'min_amount' => round($rr_min_amount,6),
            'amount' => round($rr_amount,6),
            'percentage'=>$rr_percentage,
            'fuel_surcharge_id'=>$fuel_surcharge,
            'currency' => $post['rr_currency'] ?? null,
            'status' => 1
        ];
        if ($id == null) {
            $chargeData['raterecord_id'] = 0;
            $result = $this->common->insertTableData("tb_raterecord_charges", $chargeData);
            $data = ['rr_chr_id' => $result];
        } else {
            $chargeData['updatedon'] = date('Y-m-d H:i:s');
            $result = $this->common->updatetbledata('tb_raterecord_charges', $chargeData, [
                'id' => $id
            ]);
            $data = ['rr_chr_id' => $result];
        }
     echo json_encode($data ?? []);
    }

/* save  charges edit page */
    public function editsaverrcharge($id)
    {
        $user_id = $this->session->userdata('user_id');
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        $data = array();
        //extract($post);
        $rr_exch_id=isset($post['rr_exch_id']) ? $post['rr_exch_id'] : 0;
        if($rr_exch_id ==""){ $rr_exch_id=0; }
        $geo_tier_id=isset($post['geo_tier_id']) ? $post['geo_tier_id'] : 0;
        if($geo_tier_id ==""){ $geo_tier_id=0; }
        $tier_id=isset($post['tier_id']) ? $post['tier_id'] : 0;
        if($tier_id ==""){ $tier_id=0; }
        $rr_charge_id=isset($post['rr_charge_id']) ? $post['rr_charge_id'] : 0;
        if($rr_charge_id ==""){ $rr_charge_id=0; }
        $rr_min_amount= (isset($post['rr_min_amount'])) ? $post['rr_min_amount'] : 0.000000;
        $percentage= (isset($post['rr_percentage'])) ? $post['rr_percentage'] :"";
        $fuel_surcharge = isset($post['fuel_surcharge']) ? $post['fuel_surcharge'] : "0";
        if($fuel_surcharge == ""){
            $fuel_surcharge = 0;
        }
        $rr_min_amount=trim($rr_min_amount);
        if($rr_min_amount == "" || empty($rr_min_amount)){ $rr_min_amount=0.000000; }

        $rr_amount=(isset($post['rr_amount'])) ? $post['rr_amount'] : 0.000000;
        $rr_amount=trim($rr_amount);
        if($rr_amount == "" || empty($rr_amount)){ $rr_amount=0.000000; }
        $chrdata = array(
            'exchange_rate_id' => $rr_exch_id,
            'rr_charge_type' => isset($post['charge_type']) ? $post['charge_type'] : " ",
            'geo_tier_id' => $geo_tier_id ?? 0,
            'rr_tier_id' => $tier_id ?? 0,
            'rr_charge_id' => $rr_charge_id,
            'fuel_surcharge_id'=> $fuel_surcharge,
            'charge_basis' =>isset($post['rr_char_basis']) ? $post['rr_char_basis'] : " ",
            'min_amount' => round($rr_min_amount,6),
            'amount' => round($rr_amount,6),
            'percentage'=>$percentage,
            'currency' => isset($post['rr_currency']) ? $post['rr_currency'] : " ",
            'raterecord_id' => $id ?? 0,
            'status' => 1
        );

            $data = $this->common->insertTableData("tb_raterecord_charges", $chrdata);
       /*  log_message('error'," data:".json_encode($chrdata));
        log_message('error',"Query data:".$this->db->last_query());
         */
        echo json_encode($data);
    }
/* charge details add page */
public function showchargedetails()
    {
        $ids = isset($_POST['charge_ids']) ? $_POST['charge_ids'] : "";
        $data = array();
         //$charge_code = $tier_code="";
        if ($ids != "") {
            $charge_ids1 = implode(',', $ids);
            if (! empty($charge_ids1)) {
                $qry = $this->db->query("SELECT * FROM tb_raterecord_charges WHERE id IN (" . $charge_ids1 . ") AND status='1' GROUP BY id ORDER BY id DESC");
                if ($qry->num_rows() > 0) {

                    foreach ($qry->result() as $res) {
                        // extract($res);
                        $charge_code = $fuel_surcharge = "";
                        $fuel_surcharge_id = $res->fuel_surcharge_id;
                        if($fuel_surcharge_id == "" ){
                            $fuel_surcharge_id = 0;
                        }
                        if($fuel_surcharge_id >0){
                            $get_surcharge_qry = $this->common->gettblrowdata(array('id' => $fuel_surcharge_id,'status' =>'1'),'faf_id,faf_id,faf_name','tb_fuel_surcharge', 0, 0);
                            if(!empty($get_surcharge_qry)){
                                $fuel_surcharge = $get_surcharge_qry['faf_id']."-".$get_surcharge_qry['faf_name'];
                            }
                        }
                        $data_res = $this->common->gettblrowdata(array('id' => $res->rr_charge_id), 'charge_code', 'tb_charge_codes', 0, 0);
                        if(! empty($data_res)){
                        $charge_code=$data_res['charge_code'];
                        }
                        $tier_code= $exch_id=  $exchid=$geo_tier_id="";
                       $data_res_t = $this->common->gettblrowdata(array('id' => $res->rr_tier_id), 'tier_id', 'tb_tier_master', 0, 0);
                       if(! empty($data_res_t)){
                        $tier_code=$data_res_t['tier_id'];
                        }
                         $geo_data_res = $this->common->gettblrowdata(array('id' => $res->geo_tier_id), 'geo_tier_id', 'tb_geo_tier', 0, 0);
                       if(! empty($geo_data_res)){
                        $geo_tier_id=$geo_data_res['geo_tier_id'];
                        }
                        $chk_e = $this->db->select('id,exchange_rate_id')->get_where('tb_rate_exchange', array(
                            'id' => $res->exchange_rate_id
                        ));
                        if ($chk_e->num_rows() > 0) {
                            $exch_id = $chk_e->row()->exchange_rate_id;
                            $exchid = $chk_e->row()->id;
                        }
                        $exch_id1 = '"' . $exchid . '"';
                        $charge_code2 = '"' . $res->rr_charge_id . '"';
                        $charge_basis = '"' . $res->charge_basis . '"';
                        $rr_charge_type = '"' . $res->rr_charge_type . '"';
                        $currency = '"' . $res->currency . '"';
                        $geo_tier_id1 = '"' . $res->geo_tier_id . '"';
                        $percentage = '"' . $res->percentage . '"';
                        $fuel_surcharge_id = '"' . $res->fuel_surcharge_id . '"';

                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcharEdit(this," . $res->id . "," . $rr_charge_type . "," . $charge_code2 . "," . $res->rr_tier_id . "," . $charge_basis . "," . $res->min_amount . "," . $res->amount . "," . $currency . ",".$exch_id1.",".$geo_tier_id1.",".$percentage.",".$fuel_surcharge_id.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletechrdetail(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowaddCharges(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";

                        $data[] = array(
                            'exch_id' => $exch_id,
                            'rr_charge_type' => $res->rr_charge_type,
                            'rr_tier_id' => $tier_code,
                            'geo_tier_id' => $geo_tier_id,
                            'rr_charge_id' => $charge_code,
                            'charge_basis' => $res->charge_basis,
                            'min_amount' => $res->min_amount,
                            'amount' => $res->amount,
                            'currency' => $res->currency,
                            'percentage'=>$fuel_surcharge,
                            'action' => $action
                        );
                    }
                }
            }
        }
        echo json_encode($data);
    }

    /* public function getdatacodes($sel_val,$t){
         $code = "";
         $chk_s = $this->db->select('charge_code')->get_where('tb_charge_codes', );

                        if ($chk_s->num_rows() > 0) {
                            $code = $chk_s->row()->charge_code;
                        }
                        return $code

    } */

/* charge details edit page */
    public function showeidtchargedetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : "";
        $data = array();
                $qry = $this->db->query("SELECT * FROM tb_raterecord_charges WHERE raterecord_id='$id' AND status='1' GROUP BY id ORDER BY id DESC");
                if ($qry->num_rows() > 0) {

                    foreach ($qry->result() as $res) {
                        // extract($res);
                        $charge_code =$tier_id1=$exch_id=  $exchid= $geo_tier_id=$geo_tier_id1= $fuel_surcharge ="";
                        $fuel_surcharge_id = $res->fuel_surcharge_id;
                        if($fuel_surcharge_id == "" ){
                            $fuel_surcharge_id = 0;
                        }
                        if($fuel_surcharge_id >0){
                            $get_surcharge_qry = $this->common->gettblrowdata(array('id' => $fuel_surcharge_id,'status' =>'1'),'faf_id,faf_id,faf_name','tb_fuel_surcharge', 0, 0);
                            if(!empty($get_surcharge_qry)){
                                $fuel_surcharge = $get_surcharge_qry['faf_id']."-".$get_surcharge_qry['faf_name'];
                            }
                        }
                        $chk_s = $this->db->select('charge_code')->get_where('tb_charge_codes', array('id' => $res->rr_charge_id
                        ));

                        if ($chk_s->num_rows() > 0) {
                            $charge_code = $chk_s->row()->charge_code;
                        }
                        $chk_t = $this->db->select('tier_id')->get_where('tb_tier_master', array('id' => $res->rr_tier_id
                        ));

                        if ($chk_t->num_rows() > 0) {
                            $tier_id1 = $chk_t->row()->tier_id;
                        }

                         $geo_data_res = $this->common->gettblrowdata(array('id' => $res->geo_tier_id), 'geo_tier_id', 'tb_geo_tier', 0, 0);
                       if(! empty($geo_data_res)){
                        $geo_tier_id=$geo_data_res['geo_tier_id'];
                        }


                        $chk_e = $this->db->select('id,exchange_rate_id')->get_where('tb_rate_exchange', array(
                            'id' => $res->exchange_rate_id
                        ));
                        if ($chk_e->num_rows() > 0) {
                            $exch_id = $chk_e->row()->exchange_rate_id;
                            $exchid = $chk_e->row()->id;
                        }
                        $exch_id1 = '"' . $exchid . '"';
                        $charge_code1 = '"' . $charge_code . '"';
                        $charge_code2 = '"' . $res->rr_charge_id . '"';
                        $charge_basis = '"' . $res->charge_basis . '"';
                        $rr_charge_type = '"' . $res->rr_charge_type . '"';
                        $currency = '"' . $res->currency . '"';
                        $geo_tier_id1 = '"' . $res->geo_tier_id . '"';
                        $percentage = '"' . $res->percentage . '"';
                        $fuel_surcharge_id = '"' . $fuel_surcharge_id . '"';

                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowcharEdit(this," . $res->id . "," . $rr_charge_type . "," . $charge_code2 . "," . $res->rr_tier_id . "," . $charge_basis . "," . $res->min_amount . "," . $res->amount . "," . $currency . ",".$exch_id1.",".$geo_tier_id1.",".$percentage.",".$fuel_surcharge_id.");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletechrdetail(this," . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowaddCharges(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";

                        $data[] = array(
                            'exch_id' => $exch_id,
                            'rr_charge_type' => $res->rr_charge_type,
                            'rr_tier_id' => $tier_id1,
                            'geo_tier_id' => $geo_tier_id,
                            'rr_charge_id' => $charge_code,
                            'charge_basis' => $res->charge_basis,
                            'min_amount' => $res->min_amount,
                            'amount' => $res->amount,
                            'percentage' => $res->percentage,
                            'currency' => $res->currency,
                            'fuel_surcharge'=>$fuel_surcharge,
                            'action' => $action
                        );
                    }
                }


        echo json_encode($data);
    }

    public function deletechrdetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id')->get_where('tb_raterecord_charges', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {

                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_raterecord_charges', array(
                    'status' => 0
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }
/* save services add page */
    public function saveservice($id = null)
    {
        $post = $_POST;
        $data['id']=array();
        $service['min_amount'] = ! empty($post['min_amount']) ? $post['min_amount'] : 0.000000;
        $service['min_amount'] = round($service['min_amount'],6);
        $service['amount'] = ! empty($post['amount']) ? $post['amount'] : 0.000000;
        $service['amount'] = round($service['amount'],6);
        $service['currency'] = $post['currency'];
        $service['charge_basis'] = $post['charge_basis'];
        $service['raterecord_charge_id'] = $post['charge_id'];
        $service['raterecord_vas_id'] = $post['vas_id'];

        // SELECT `id`, `raterecord_id`, `raterecord_vas_id`, `raterecord_charge_id`, `charge_basis`, `min_amount`, `amount`, `currency`, `status`, `createdon`, `updatedon` FROM `tb_raterecord_services` WHERE 1
        if ($id == null) {
            $service['raterecord_id'] = 0;
            $service['status'] = 1;
            $service['createdon'] = date('Y-m-d H:i:s');
            $service['updatedon'] = date('Y-m-d H:i:s');
            $data['id'] = $this->common->insertTableData('tb_raterecord_services', $service);
        } else {
            $service['updatedon'] = date('Y-m-d H:i:s');
            $this->common->updatetbledata('tb_raterecord_services', $service, array(
                'id' => $id
            ));
            $data['id'] = $id;
        }
        echo json_encode($data);
    }

    /* save services add page */
    public function editsaveVAS($id)
    {
        $data=array();
        $post = $_POST;
        $service['min_amount'] = ! empty($post['min_amount']) ? $post['min_amount'] : 0;
        $service['amount'] = ! empty($post['amount']) ? $post['amount'] : 0.000000;
        $service['amount'] = round($service['amount'],6);
        $service['currency'] = $post['currency'];
        $service['charge_basis'] = $post['charge_basis'];
        $service['raterecord_charge_id'] = $post['charge_id'];
        $service['raterecord_vas_id'] = $post['vas_id'];
        $service['raterecord_id'] = $id ?? 0;
        $service['status'] = 1;
        $service['createdon'] = date('Y-m-d H:i:s');
        $data = $this->common->insertTableData('tb_raterecord_services', $service);
        echo json_encode($data);
    }


/* Get services Add page */
    public function showservices()
    {
        $docs = array();
        $ids = isset($_POST['services_list']) ? $_POST['services_list'] : "";
        $services=array();
        if ($ids != "") {
            // $servicelist = $this->rateofferingmodel->vaslist($ids);
            // $this->db->select('rs.*,vas.vas_id vasid,vas.vas_name,cc.charge_code')->from('tb_raterecord_services rs');
            // $this->db->join('tb_vas_master vas','vas.id = rs.raterecord_vas_id','LEFT');
            // $this->db->join('tb_charge_codes cc','cc.id = rs.raterecord_charge_id','LEFT');
            // $whr=array('status' => '1');
            // $this->db->where($whr);
            // $this->db->where_in('rs.id',$ids);
            // $query = $this->db->get();
            $ids1 = implode(',', $ids);
            $query = $this->db->query(" SELECT `rs`.*, `vas`.`vas_id` `vasid`, `vas`.`vas_name`, `cc`.`charge_code` FROM `tb_raterecord_services` `rs` LEFT JOIN `tb_vas_master` `vas` ON `vas`.`id` = `rs`.`raterecord_vas_id` LEFT JOIN `tb_charge_codes` `cc` ON `cc`.`id` = `rs`.`raterecord_charge_id` WHERE rs.id IN (" . $ids1 . ") AND `rs`.status='1'");

            $servicelist = $query->result_array();
            foreach ($servicelist as $service) {
                $vasname = '"' . $service['vas_name'] . '"';
                $currency = '"' . $service['currency'] . '"';
                $chargebasis = '"' . $service['charge_basis'] . '"';
                $service['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowserEdit(this," . $service['id'] . "," . $service['raterecord_vas_id'] . "," . $vasname . "," . $service['raterecord_charge_id'] . "," . $chargebasis . "," . $service['min_amount'] . "," . $service['amount'] . "," . $currency . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteserdetails(this," . $service['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddser(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";
                $services[] = $service;
            }
        }
        echo json_encode($services);
    }
/* Get services Edit page */
public function showeditservices()
    {
         $id = isset($_POST['id']) ? $_POST['id'] : "";
            $services=array();
            $query = $this->db->query(" SELECT `rs`.*, `vas`.`vas_id` `vasid`, `vas`.`vas_name`, `cc`.`charge_code` FROM `tb_raterecord_services` `rs` LEFT JOIN `tb_vas_master` `vas` ON `vas`.`id` = `rs`.`raterecord_vas_id` LEFT JOIN `tb_charge_codes` `cc` ON `cc`.`id` = `rs`.`raterecord_charge_id` WHERE rs.raterecord_id='$id' AND `rs`.status='1'");

            $servicelist = $query->result_array();
            foreach ($servicelist as $service) {
                $vasname = '"' . $service['vas_name'] . '"';
                $currency = '"' . $service['currency'] . '"';
                $chargebasis = '"' . $service['charge_basis'] . '"';
                $service['action'] = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowserEdit(this," . $service['id'] . "," . $service['raterecord_vas_id'] . "," . $vasname . "," . $service['raterecord_charge_id'] . "," . $chargebasis . "," . $service['min_amount'] . "," . $service['amount'] . "," . $currency . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deleteserdetails(this," . $service['id'] . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAddser(this);'><span class='glyphicon glyphicon-plus' > </span>Add New</a></li>";
                $services[] = $service;
            }

        echo json_encode($services);
    }


    public function deleteserdetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id')->get_where('tb_raterecord_services', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {

                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_raterecord_services', array(
                    'status' => 0
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function checkname()
    {
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);

        $id = isset($id) ? $id : "";
        $record_name = isset($record_name) ? $record_name : 0;
        //$company_code = isset($company_code) ? $company_code : "";
       // $branch_code = isset($branch_code) ? $branch_code : "";
        // $id = $this->uri->segment(3);

        $company_code=$this->session->userdata('company_code');
        $branch_code=$this->session->userdata('branch_code');
        if($company_code == "RUKN"){
             $where = array('status'=>1, 'record_name' => $record_name,'company_code'=>$company_code);
        }else{
             $where = array(
            'record_name' => $record_name,
            'company_code' => $company_code,
            'branch_code' => $branch_code,
            'status'=>1
        );
        }

        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'record_name', 'tb_rate_records', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function raterecordinsert()
    {
        $user_id = $this->session->userdata('user_id');

        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $year = date('y');
        $week = date('W');
        $res = $this->db->query("SELECT rate_id FROM tb_rate_records ORDER BY id DESC LIMIT 1");
        if ($res->num_rows() > 0) {
            $get_id = $res->row()->rate_id;
            $get_id_c = strlen($get_id);
            if ($get_id_c > 7) {

                $previous_weeknumber = substr($get_id, 4, 2);
                $get_id1 = substr($get_id, 6);
                $get_id2 = ltrim($get_id1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_id2;
                    $i_id ++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $gen_id = "RR" . $year . $week . $id1;
            $chk = $this->db->query("select rate_id FROM tb_rate_records WHERE rate_id='" . $gen_id . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $gen_id = "RR" . $year . $week . $ii_d;
            } else {
                $gen_id = $gen_id;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $gen_id = "RR" . $year . $week . $id1;
        }
        $savedata = array(
            'rate_id' => isset($gen_id) ? $gen_id : 0,
            'record_name' => isset($record_name) ? $record_name : "",
            'offering_id' => isset($offering_id) ? $offering_id : 0,
            'description' => isset($desc) ? $desc : "",
            'company_code' => isset($company_code) ? $company_code : "",
            'branch_code' => isset($branch_code) ? $branch_code : "",
            'user_id' => isset($user_id) ? $user_id : 0,
            'status' => 1
        );
        $rateRecordId = $this->common->insertTableData("tb_rate_records", $savedata);
        if ($rateRecordId > 0) {
            $rate_r_con_ids = explode(',', $rate_r_con_id);
            $rate_r_charge_ids = explode(',', $rate_r_charge_id);
            $service_ids = explode(',', $service_id);
            $this->db->where_in('id', $rate_r_con_ids)->update("tb_raterecord_conditions", ['rate_record_id' => $rateRecordId]);
            $this->db->where_in('id', $rate_r_charge_ids)->update("tb_raterecord_charges", ['raterecord_id' => $rateRecordId]);
            $this->db->where_in('id', $service_ids)->update("tb_raterecord_services", ['raterecord_id' => $rateRecordId]);
        }
        redirect('KNraterecord');
 }

    public function raterecordupdate(){
        $user_id = $this->session->userdata('user_id');
        $post   = array();
        $post   = $this->input->post(NULL, TRUE);
        extract($post);
        $savedata = array(
            'record_name' => isset($record_name) ? $record_name : "",
            'offering_id' => isset($offering_id) ? $offering_id : 0,
            'description' => isset($desc) ? $desc : "",
            'company_code' => isset($company_code) ? $company_code : "",
            'branch_code' => isset($branch_code) ? $branch_code : "",
            'user_id' => $user_id
        );
         $id = $edit_rr_id;
         $result = $this->common->updatetbledata("tb_rate_records", $savedata, array(
            'id' => $id
        ));

        redirect('KNraterecord');


    }



     public function delete($id)
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_rate_records');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }
    public function getrecordtabl($wher, $whr)
    {
        $this->db->select('rr.*,ro.offering_id offering_name')->from('tb_rate_records rr');
        $this->db->join('tb_rate_offerings ro', 'rr.offering_id=ro.id', 'LEFT');
        $this->db->where($wher);
        $this->db->like($whr);
        $this->db->order_by('rr.id', 'DESC');
        $query = $this->db->get();
        return $query->result_array();

    }
    
    public function getamountfromfuelsurcharge(){
        $post   = array();
        $result = array();
        $post   = $this->input->post(NULL, TRUE);
        $company_code = $this->session->userdata('company_code');
        if(!empty($post)){
            $offering_id = isset($post['offering_id']) ? $post['offering_id'] : "0";
            if($offering_id > 0){
                $getprofileid = $this->common->gettblrowdata(array( 'id' => $offering_id), 'tarrif_type,cust_profile_id,vendor_profile_id', 'tb_rate_offerings', 0, 0);
                if(!empty($getprofileid)){
                    $tarrif_type         = strtoupper($getprofileid['tarrif_type']);
                    $customer_profile_id = $getprofileid['cust_profile_id'];
                    $vendor_profile_id   = $getprofileid['vendor_profile_id'];
                    $tarrif_match = $this->gettarrifmatchedrecords($tarrif_type,$customer_profile_id,$vendor_profile_id);
                    $empty_tarrif = $this->getemptytarrifrecords();
                    if(!empty($tarrif_match)){
                        foreach ($tarrif_match as $row){
                            if(!empty($result)){
                                if(in_array($row['row_id'],$result)){
                                }else{
                                    $result[] = array('row_id'=>$row['row_id'],'faf_id'=>$row['faf_id'],'faf_name'=>$row['faf_name']);
                                }
                            }else{
                                $result[] = array('row_id'=>$row['row_id'],'faf_id'=>$row['faf_id'],'faf_name'=>$row['faf_name']);
                            }
                        }
                    }
                    if(!empty($empty_tarrif)){
                        foreach ($empty_tarrif as $row){
                            if(!empty($result)){
                                if(in_array($row['row_id'],$result)){
                                }else{
                                    $result[] = array('row_id'=>$row['row_id'],'faf_id'=>$row['faf_id'],'faf_name'=>$row['faf_name']);
                                }
                            }else{
                                $result[] = array('row_id'=>$row['row_id'],'faf_id'=>$row['faf_id'],'faf_name'=>$row['faf_name']);
                            }
                        }
                    }
                }
            }
        }
        echo json_encode($result);
    }

    public function getemptytarrifrecords(){
        $faf_ids = array();
        $company_code = $this->session->userdata('company_code');
        $whr = " ( tariff_type IS NULL OR tariff_type = '' ) AND company_code LIKE '".$company_code."' AND status ='1'";
        $getempty_surcharge = $this->orderrevenuesmodel->getemptytariffrecords_forfaf($whr);
        if(!empty($getempty_surcharge)){
            foreach ($getempty_surcharge as $res){
                $faf_ids[] = array('row_id'=>$res['id'],'faf_name'=>$res['faf_name'],'faf_id'=>$res['faf_id']);
            }
        }
        return $faf_ids;
    }

    public function gettarrifmatchedrecords($tarrif_type,$customer_profile_id,$vendor_profile_id){
        $surcharge_customer_id = $surcharge_carrier_id = 0;
        $surcharge_customer_code = $surcharge_carrier_code = "";
        $company_code = $this->session->userdata('company_code');
        $faf_ids = array();
        if($tarrif_type != ""){
            $get_surcharge_qry = $this->common->gettbldata(array('tariff_type' => $tarrif_type,'company_code'=>$company_code,'status' =>'1'),'id,faf_id,faf_name,customer_id,carrier_id','tb_fuel_surcharge', 0, 0);
            if(!empty($get_surcharge_qry)){
                foreach ($get_surcharge_qry as $get_surcharge){
                    $surcharge_customer_id = $get_surcharge['customer_id'];
                    $surcharge_carrier_id  = $get_surcharge['carrier_id'];
                    if($tarrif_type == "SELL"){
                        if($surcharge_customer_id > 0){
                            $getcustomer_code = $this->common->gettblrowdata(array('id' =>$surcharge_customer_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_customers', 0, 0);
                            if(!empty($getcustomer_code)){
                                $surcharge_customer_code = $getcustomer_code['code'];
                            }
                            if($surcharge_customer_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('cp_id' =>$customer_profile_id,'profile_id'=>$surcharge_customer_code,'status' =>'1'),'id','tb_customer_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }else if($tarrif_type == "BUY"){
                        if($surcharge_carrier_id > 0){
                            $getcarrier_code = $this->common->gettblrowdata(array('id' =>$surcharge_carrier_id,'company_code'=>$company_code,'status' =>'1'),'code','tb_vendors', 0, 0);
                            if(!empty($getcarrier_code)){
                                $surcharge_carrier_code = $getcarrier_code['code'];
                            }
                            if($surcharge_carrier_code != ""){
                                $chkoffering_profile = $this->common->gettblrowdata(array('vp_id' =>$vendor_profile_id,'profile_id'=>$surcharge_carrier_code,'status' =>'1'),'id','tb_vendor_profile_list', 0, 0);
                                if(!empty($chkoffering_profile)){
                                    $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                                }
                            }
                        }else{
                            $faf_ids[] = array('row_id'=>$get_surcharge['id'],'faf_name'=>$get_surcharge['faf_name'],'faf_id'=>$get_surcharge['faf_id']);
                        }
                    }
                }
            }
        }
        return $faf_ids;
    }

    public function deletebulkrecords(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids = $this->input->post('deleteids');
            $result = true;
            foreach ($ids as $id) {
                $this->db->where('id', $id);
                $this->db->set('status', 0);
                $result = $this->db->update('tb_rate_records');
                if (!$result) {
                    $result = false;
                }
            }
            echo $result ? "success" : "failed";
        }
    }
}
