<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Knlogincron extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
        $this->load->model(['common','Order']);
        $this->load->library('knlogin');
	}
	/* send knlogin bookings and status to svkonekt */
    public function index()
    {
        $packageCodes = $countries = $finalCountries = [];
        $current_dt = date('Y-m-d', strtotime("-2 days"));
        $currentdt = date("Y-m-d H:i:s");
        $customers = $this->common->gettbldata(["status" => 1, "sendto_knlogin" => 1], "id,name,phone,code,company_code,branch_code,state,street,location,pincode,address,email_id,code,country", "tb_customers", 0, 0);
            $getPackageCode = $this->common->gettbldata("unit_code IS NOT NULL ","unit_name,unit_code,description","tb_handling_units",0,0);
            foreach($getPackageCode as $singlePackageCode){
                $packageCodes[$singlePackageCode['description']] = $packageCodes[$singlePackageCode['unit_name']] = $packageCodes[$singlePackageCode['unit_code']] = $singlePackageCode['unit_code'];
            }
        foreach ($customers as $res) {
            $company_code = $res['company_code'];
            $branch_code = $res['branch_code'];
            $cntrycode = substr($company_code, 0, 2);
            $curtz = "Asia/Singapore";
            $dthrs = "+08.00";
            $code = 66;
            $cntryname = "Singapore";
            $cntrys = $this->common->gettblrowdata(["country_code" => $cntrycode, "status" => 1], "country_name,cntry_timezone,cntry_hrs,phone_code", "tbl_country_master", 0, 0);
            if (!empty($cntrys)) {
                $curtz = $cntrys['cntry_timezone'];
                $dthrs = $cntrys['cntry_hrs'];
                $cntryname = $cntrys['country_name'];
                $code = $cntrys['phone_code'];
            }
            $gentime = getdatetimebytimezone($curtz, $currentdt, DFLT_TZ);
            $currentdt = $gentime['datetime'];
            $custord = $this->common->getknloginorders(["o.customer_id" => $res['id'], "DATE(o.updatedon) >=" => $current_dt, "o.status <>" => 0], 0, 0);
            foreach ($custord as $cres) {
                $id = $cres->id;
                $serviceId = $cres->service;
                $createdon = $cres->createdon;
                $getactual = getdatetimebytimezone($curtz, $createdon, DFLT_TZ);
                $curdt = $getactual['datetime'];
                $parties = $carrierDetails = [];
                $s = 0;
                $chekparty = $this->common->getpartiesbyorder($id);
                foreach ($chekparty as $rr) {
                    $ptype = $rr->party_type;
                    $chktype = $this->common->gettblrowdata(["id" => $ptype], "name", "tbl_party_types", 0, 0);
                    if (count($chktype) > 0) {
                        if ($rr->party_master_id != "") {
                            $countries[] = strtoupper($rr->country);
                            $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->paddress, 'pincode' => $rr->ppincode, 'country' => strtoupper($rr->country), 'street' => $rr->street, 'city' => $rr->plocation_id, 'state' => $rr->pstate, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier];
                        } else {
                            $countries[] = strtoupper($rr->country);
                            $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->address, 'pincode' => $rr->pincode, 'country' =>  strtoupper($rr->country), 'street' => $rr->street, 'city' => $rr->location_id, 'state' => $rr->state, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier];
                        }
                        if ($chktype['name'] == "Consignee") {
                            $pdetail['type'] = "Consignee";
                        } elseif ($chktype['name'] == "Consignor") {
                            $pdetail['type'] = "Consignor";
                        } elseif ($chktype['name'] == "Shipper") {
                            $pdetail['type'] = "Shipper";
                        } elseif ($chktype['name'] == "Carrier") {
                            $pdetail['type'] = "Carrier";
                            $carrierDetails = $pdetail;
                        } elseif ($chktype['name'] == "FREIGHT_PAYER") {
                            $pdetail['type'] = "PF";
                            $s = 1;
                        } elseif ($chktype['name'] == "Customer") {
                            $pdetail['type'] = "PF";
                            $s = 1;
                        } else {
                            $pdetail['type'] = "PF";
                        }
                        $parties[] = $pdetail;
                    }
                }
                if ($s == 0) {
                    $countries[] = strtoupper($res['country']);
                    $pdetail = ['name' => $res['name'], 'cust_id' => $res['code'], 'address' => $res['address'], 'pincode' => $res['pincode'], 'country' => strtoupper($res['country']), 'street' => $res['street'], 'city' => $res['location'], 'state' => $res['state'], 'phone' => $res['phone'], 'email' => $res['email_id'], 'party_id' => $res['code']];
                    $pdetail['type'] = "PF";
                    $parties[] = $pdetail;
                }
                $pickup_country = $cres->pickup_country;
                $delivery_country = $cres->delivery_country;
                $countries[] = strtoupper($pickup_country);
                $countries[] = strtoupper($delivery_country);
                if (!empty($countries)) {
                    $countries = array_unique($countries);
                    $finalCountries = $this->Order->getCountryCodesFromMaster($countries);
                }
                $cargos = [];
                $total_volume = $total_weight = $totalQuantity = 0;
                $getcargos = $this->common->gettbldata(["order_id" => $id,'status'=>'1'], "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
                foreach ($getcargos as $cargores) {
                    $volume = $cargores['volume'] ?: "1";
                    $weight = $cargores['weight'] ?: "1";
                    $weight_unit = "KG";
                    $volume_unit = "CBM";
                    $length_unit = $width_unit = $height_unit = "CM";
                    if ($cargores['cargo_id'] != "") {
                        $chk = $this->common->gettblrowdata(["id" => $cargores['cargo_id']], "length_unit,width_unit,height_unit,weight_unit,volume_unit", "tb_cargo_details", 0, 0);
                        if (!empty($chk)) {
                            $weight_unit = $chk['weight_unit'];
                            $volume_unit = $chk['volume_unit'];
                            $length_unit = $chk['length_unit'];
                            $width_unit = $chk['width_unit'];
                            $height_unit = $chk['height_unit'];
                        }
                    }
                    if($length_unit == 'M'){
                        $cargores['length'] *= 100;
                    }
                    if($width_unit == 'M'){
                        $cargores['width'] *= 100;
                    }
                    if($height_unit == 'M'){
                        $cargores['height'] *= 100;
                    }
                    if($length_unit == 'Inches'){
                        $cargores['length'] *= 2.54;
                    }
                    if($width_unit == 'Inches'){
                        $cargores['width'] *= 2.54;
                    }
                    if($height_unit == 'Inches'){
                        $cargores['height'] *= 2.54;
                    }
                    $content = $cargores['cargo_content'] ?? "";
                    $cargos[] = ['cargo_type' => $cargores['quantity_type'], 'content' => $content, 'length' => $cargores['length'], 'width' => $cargores['width'], 'height' => $cargores['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $cargores['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit,'height_unit'=>$height_unit,'length_unit'=>$length_unit,'width_unit'=>$width_unit];

                    $total_volume += $volume;
                    $total_weight += $weight;
                    $totalQuantity += $cargores['quantity'];
                }
                if ($cres->company_code != "") {
                    $company_code = $cres->company_code;
                }
                if ($cres->branch_code != "") {
                    $branch_code = $cres->branch_code;
                }
                $shipinfo = $cres->shipment_id;
                $LogicalReceiver = "WWWWW99";
                $newLogicalSender = '';
                $logicalinfo = $this->common->gettblrowdata(['company_code' => $company_code, 'branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
                if (!empty($logicalinfo)) {
                    $newLogicalSender = $logicalinfo['logical_sender'];
                }
                $shipid = $cres->shipmentid;
                $incoterm =  $freight_term = $freight_termname = "";
                if ($shipinfo != "" && $shipinfo != 0) {
                    $chk = $this->common->gettblrowdata(['id' => $shipinfo], "shipid, txnid, insertuserdate, insdate, incoterm, freight_term, freight_termname,physicalreceiver, logicalreceiver, physicalsender,logicalsender", "tb_shipments", 0, 0);
                    if (count($chk) > 0) {
                        if ($chk['physicalreceiver'] != "") {
                            $PhysicalReceiver = $chk['physicalreceiver'];
                        }
                        if ($chk['logicalreceiver'] != "") {
                            $LogicalReceiver = $chk['logicalreceiver'];
                        }
                        if ($chk['physicalsender'] != "") {
                            $PhysicalSender = $chk['physicalsender'];
                        }
                        if ($chk['logicalsender'] != "") {
                            $LogicalSender = $chk['logicalsender'];
                        }
                        if ($shipid == "") {
                            $shipid = $chk['shipid'];
                        }
                        $incoterm = $chk['incoterm'];
                    }
                }
                $references = $shipperReferences = [];
                $checkReference = $this->common->gettbldata(["order_id" => $id,"status"=>'1'], "reference_id,ref_value", "tb_order_references", 0, 0);
                foreach ($checkReference as $eachreference) {
                    $referenceId = $eachreference['reference_id'];
                    if(strlen($referenceId) == 2){
                        $references[] = ["id" => $eachreference['reference_id'], "value" => $eachreference['ref_value']];
                    }else{
                        $shipperReferences[] = ['id'=>$referenceId,'value'=>$eachreference['ref_value']];
                    }
                }
                $product = $cres->product;
                if ($product == "") {
                    $product = "KN AsiaDirect";
                }
                $service_type = "";
                if($serviceId >0){
                    $getServiceName = $this->common->gettblrowdata(["id" => $serviceId], "name", "tb_service_master", 0, 0);
                    if(!empty($getServiceName)){
                        $service_type = $getServiceName['name'];
                    }
                }

                $vtype = 1;
                if ($cres->vehicle_type == "") {
                    $vtype = $cres->vehicle_type;
                }
                $t_mode = 1;
                $tmode = $cres->transport_mode;
                if ($tmode == "LTL") {
                    $t_mode = 0;
                }
                $vehtype = $cres->vehicle_type;
                if ($vehtype == "") {
                    $vehtype = "F";
                }
                $PhysicalReceiver = 'WWDPT01';
                $PhysicalSender = 'KNRLG09';
                if(SYS_TYPE == 'TMS'){
                    $PhysicalSender = 'KNRLG01';
                    $PhysicalReceiver = 'WWDPP01';
                }
                $data = [
                    'SenderTransmissionNo' => $cres->order_id,
                    'pickup_datetime' => $cres->pickup_datetime,
                    'delivery_datetime' => $cres->delivery_datetime,
                    'pickup_endtime' => $cres->pickup_endtime,
                    'delivery_endtime' => $cres->drop_endtime,
                    'createdon' => $createdon,
                    "delivery_company" => $cres->delivery,
                    'delivery_city' => $cres->delivery_city,
                    'delivery_country' => $finalCountries[strtoupper($delivery_country)] ?? $delivery_country,
                    'delivery_address1' => $cres->delivery_address1,
                    'delivery_address2' => $cres->delivery_address2,
                    'delivery_pincode' => $cres->delivery_pincode,
                    'branch_code' => $branch_code,
                    'company_code' => $company_code,
                    'transport_mode' => $cres->transport_mode,
                    'pickup_country' =>  $finalCountries[strtoupper($pickup_country)] ?? $pickup_country,
                    'pickup_pincode' => $cres->pickup_pincode,
                    'country_code' => $code,
                    "pickup_company" => $cres->pickup,
                    'pickup_city' => $cres->pickup_city,
                    'pickup_address1' => $cres->pickup_address1,
                    'pickup_address2' => $cres->pickup_address2,
                    'cargos' => $cargos,
                    'total_weight' => $total_weight,
                    'total_volume' => $total_volume,
                    "vehicle_type" => $vehtype,
                    "parties" => $parties,
                    "physicalreceiver" => $PhysicalReceiver,
                    "logicalreceiver" => $LogicalReceiver,
                    "physicalsender" => $PhysicalSender,
                    "logicalsender" => $newLogicalSender,
                    "refs" => $references,
                    "quantity" => $totalQuantity,
                    "incoterm" => $incoterm,
                    "freight_term" => $freight_term,
                    "freight_termname" => $freight_termname,
                    "product" => $product,
                    "service_type" => $service_type,
                    "hrs" => $dthrs,
                    't_mode' => $t_mode,
                    "pickup_custid" => $cres->pickup_custid,
                    "drop_custid" => $cres->drop_custid,
                    "pickup_partyid" => $cres->pickup_partyid,
                    "drop_partyid" => $cres->drop_partyid,
                    'country_name' => $cntryname,
                    "cntrycode" => $cntrycode,
                    "weight" => $total_weight,
                    "shipmentid"=>$cres->shipmentid,
                    'carrierDetails'=>$carrierDetails,
                    'packageCodes'=>$packageCodes,
                    'shipperReferences'=>$shipperReferences,
                    'finalCountries'=>$finalCountries,

                ];
                $send = $this->knlogin->sendKNloginOrderxmlservice($data);
                $upd = $this->common->updatetbledata("tb_orders", ["is_created" => 2], ["id" => $id]);
            }
        }
    }

    public function sendknloginstatus()
    {
        $whr = ["status" => 1, "sendto_knlogin" => 1];
        $select = "id,name,phone,code,company_code,branch_code,state,street,location,pincode,address,email_id,code,country";
        $tbl = "tb_customers";
        $currentdt = date("Y-m-d H:i:s");
        $customers = $this->common->gettbldata($whr, $select, $tbl, 0, 0);
        if (empty($customers)) {
            return;
        }
        foreach ($customers as $res) {
            $company_code = $res['company_code'];
            $branch_code = $res['branch_code'];
            $cntrycode = substr($company_code, 0, 2);
            $curtz = "Asia/Singapore";
            $dthrs = "+08.00";
            $cntrys = $this->common->gettblrowdata(["country_code" => $cntrycode, "status" => 1], "country_name,cntry_timezone,cntry_hrs,phone_code", "tbl_country_master", 0, 0);
            if (!empty($cntrys)) {
                $curtz = $cntrys['cntry_timezone'];
                $dthrs = $cntrys['cntry_hrs'];
            }
            $gentime = getdatetimebytimezone($curtz, $currentdt, DFLT_TZ);
            $currentdt = $gentime['datetime'];
            $curdt1 = date('Y-m-d\TH:i:s', strtotime($currentdt));
            $hrs = str_replace(".", ":", $dthrs);
            $where = ["o.customer_id" => $res['id'], "o.status <>" => 0, "o.is_created" => 2, "d.status" => 1, "d.sentknlogin" => 0];
            $custord = $this->common->getknloginorderstatus($where, 0, 0);
            $instransitData = $orderRowIds = [];
            foreach ($custord as $cres) {
                $stsid = $cres->stid;
                $LogicalReceiver = "WWWWW99";
                $PhysicalReceiver = 'WWDPT01';
                $PhysicalSender = 'KNRLG09';
                if(SYS_TYPE == 'TMS'){
                    $PhysicalReceiver = 'WWDPP01';
                    $PhysicalSender = 'KNRLG01';
                }
                $ref_id = "INN";
                $ref_num = "RL" . $cres->order_id;
                if ($cres->company_code != "") {
                    $company_code = $cres->company_code;
                }
                if ($cres->branch_code != "") {
                    $branch_code = $cres->branch_code;
                }
                $logicalinfo = $this->common->gettblrowdata(['company_code' => $company_code, 'branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
                $newLogicalSender = $logicalinfo['logical_sender'] ?: "THPNA74";
                $getDepartmentCode = $this->common->gettblrowdata(['order_row_id' => $cres->id, 'status' => '1'], "department_code", "tb_order_details", 0, 0);
                $department_code = $getDepartmentCode['department_code'] ?: "ETRA";
                $sendStatus = 1;
                if (checkAccessConditions('RELATED_2_TW_CN', $company_code)) {
                    if ($cres->status_code == "1550") {
                        $sendStatus = 0;
                        $instransitData[$cres->stid] = $cres;
                        if (!in_array($cres->id, $orderRowIds)) {
                            $orderRowIds[] = $cres->id;
                        }
                    }
                }
                if ($sendStatus === 1) {
                    $getactual = getdatetimebytimezone($curtz, $cres->createdon, DFLT_TZ);
                    $createdon = $getactual['datetime'];
                    $date = $getactual['date'];
                    $time = $getactual['time'] . "" . $hrs;
                    $curdt = date('Y-m-d\TH:i:s', strtotime($createdon)) . "" . $hrs;
                    $postdata = [
                        "shipment_id" => $cres->shipmentid,
                        "latitude" => $cres->latitude,
                        "longitude" => $cres->longitude,
                        "status_code" => $cres->status_code,
                        "company_code" => $company_code,
                        "branch_code" => $branch_code,
                        "pickup_city" => $cres->pickup_city,
                        "delivery_city" => $cres->delivery_city,
                        "status_location"=>$cres->loc_name,
                        "logicalreceiver" => $LogicalReceiver,
                        "physicalreceiver" => $PhysicalReceiver,
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $newLogicalSender,
                        "modeoftransport" => $cres->modeoftransport,
                        "department_code" => $department_code,
                        "trackingnumber" => $cres->order_id,
                        "ref_id" => $ref_id,
                        "ref_num" => $ref_num,
                        "createdon" => $createdon,
                        "date" => $date,
                        "time" => $time,
                        'curdt' => $curdt,
                        'curdt1' => $curdt1
                    ];
                    if ($cres->driver_id != "") {
                        $updateQuery = $this->common->updatetbledata("tb_stop_status", ["sentknlogin" => 1], ["id" => $stsid]);
                    } else {
                        $updateQuery = $this->common->updatetbledata("tb_order_status", ["sentknlogin" => 1], ["id" => $stsid]);
                    }
                    $sendKnloginStatus = $this->knlogin->knloginsendorderstatus($postdata);
                }
            }
            if (!empty($instransitData)) {
                $this->knlogin->sendHighestIntransitStatusFORCNTW($instransitData, $orderRowIds, ['companyCode' => $company_code, 'branchCode' => $branch_code, 'timeZone' => $curtz, 'updatedDate' => $curdt1, 'hours' => $hrs]);
            }
        }
    }

    public function manualTriggerETNtoKNLogin(int $customerPkId=0, string $fromDate='', string $toDate='', string $branchCode='') {
        if ($customerPkId > 0 && !empty($fromDate) && !empty($toDate) && !empty($branchCode)) {
            $packageCodes = $countries = $finalCountries = [];
            $current_dt = date('Y-m-d', strtotime($fromDate));
            $currentdt  = date("Y-m-d", strtotime($toDate));
            $customers  = $this->common->gettbldata(["status" => 1, "sendto_knlogin" => 1,"id"=>$customerPkId], "id,name,phone,code,company_code,branch_code,state,street,location,pincode,address,email_id,code,country", "tb_customers", 0, 0);
            $getPackageCode = $this->common->gettbldata("unit_code IS NOT NULL ","unit_name,unit_code,description","tb_handling_units",0,0);
            foreach($getPackageCode as $singlePackageCode){
                    $packageCodes[$singlePackageCode['description']] = $packageCodes[$singlePackageCode['unit_name']] = $packageCodes[$singlePackageCode['unit_code']] = $singlePackageCode['unit_code'];
                }
            foreach ($customers as $res) {
                $company_code = $res['company_code'];
                $branch_code = $res['branch_code'];
                $cntrycode = substr($company_code, 0, 2);
                $curtz = "Asia/Singapore";
                $dthrs = "+08.00";
                $code = 66;
                $cntryname = "Singapore";
                $cntrys = $this->common->gettblrowdata(["country_code" => $cntrycode, "status" => 1], "country_name,cntry_timezone,cntry_hrs,phone_code", "tbl_country_master", 0, 0);
                if (!empty($cntrys)) {
                    $curtz = $cntrys['cntry_timezone'];
                    $dthrs = $cntrys['cntry_hrs'];
                    $cntryname = $cntrys['country_name'];
                    $code = $cntrys['phone_code'];
                }
                $gentime = getdatetimebytimezone($curtz, $currentdt, DFLT_TZ);
                $currentdt = $gentime['datetime'];
                $custord = $this->common->getknloginorders(["o.customer_id" => $res['id'], "DATE(o.createdon) >=" => $current_dt, "DATE(o.createdon) <=" => $currentdt,"branch_code"=> $branchCode,"o.status <>" => 0], 0, 0, 1);
                foreach ($custord as $cres) {
                    $id = $cres->id;
                    $serviceId = $cres->service;
                    $createdon = $cres->createdon;
                    $getactual = getdatetimebytimezone($curtz, $createdon, DFLT_TZ);
                    $curdt = $getactual['datetime'];
                    $parties = $carrierDetails = [];
                    $s = 0;
                    $chekparty = $this->common->getpartiesbyorder($id);
                    foreach ($chekparty as $rr) {
                        $ptype = $rr->party_type;
                        $chktype = $this->common->gettblrowdata(["id" => $ptype], "name", "tbl_party_types", 0, 0);
                        if (count($chktype) > 0) {
                            if ($rr->party_master_id != "") {
                                $countries[] = strtoupper($rr->country);
                                $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->paddress, 'pincode' => $rr->ppincode, 'country' => strtoupper($rr->country), 'street' => $rr->street, 'city' => $rr->plocation_id, 'state' => $rr->pstate, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier];
                            } else {
                                $countries[] = strtoupper($rr->country);
                                $pdetail = ['name' => $rr->name, 'cust_id' => $rr->code, 'address' => $rr->address, 'pincode' => $rr->pincode, 'country' =>  strtoupper($rr->country), 'street' => $rr->street, 'city' => $rr->location_id, 'state' => $rr->state, 'phone' => $rr->mobile, 'email' => $rr->email, 'party_id' => $rr->partyindetifier];
                            }
                            if ($chktype['name'] == "Consignee") {
                                $pdetail['type'] = "Consignee";
                            } elseif ($chktype['name'] == "Consignor") {
                                $pdetail['type'] = "Consignor";
                            } elseif ($chktype['name'] == "Shipper") {
                                $pdetail['type'] = "Shipper";
                            } elseif ($chktype['name'] == "Carrier") {
                                $pdetail['type'] = "Carrier";
                                $carrierDetails = $pdetail;
                            } elseif ($chktype['name'] == "FREIGHT_PAYER") {
                                $pdetail['type'] = "PF";
                                $s = 1;
                            } elseif ($chktype['name'] == "Customer") {
                                $pdetail['type'] = "PF";
                                $s = 1;
                            } else {
                                $pdetail['type'] = "PF";
                            }
                            $parties[] = $pdetail;
                        }
                    }
                    if ($s == 0) {
                        $countries[] = strtoupper($res['country']);
                        $pdetail = ['name' => $res['name'], 'cust_id' => $res['code'], 'address' => $res['address'], 'pincode' => $res['pincode'], 'country' => strtoupper($res['country']), 'street' => $res['street'], 'city' => $res['location'], 'state' => $res['state'], 'phone' => $res['phone'], 'email' => $res['email_id'], 'party_id' => $res['code']];
                        $pdetail['type'] = "PF";
                        $parties[] = $pdetail;
                    }
                    $pickup_country = $cres->pickup_country;
                    $delivery_country = $cres->delivery_country;
                    $countries[] = strtoupper($pickup_country);
                    $countries[] = strtoupper($delivery_country);
                    if (!empty($countries)) {
                        $countries = array_unique($countries);
                        $finalCountries = $this->Order->getCountryCodesFromMaster($countries);
                    }
                    $cargos = [];
                    $total_volume = $total_weight = $totalQuantity = 0;
                    $getcargos = $this->common->gettbldata(["order_id" => $id,'status'=>'1'], "cargo_id, handling_unit, length, width, height, weight, volume, quantity,quantity_type,cargo_content", "tb_order_cargodetails", 0, 0);
                    foreach ($getcargos as $cargores) {
                        $volume = $cargores['volume'] ?: "1";
                        $weight = $cargores['weight'] ?: "1";
                        $weight_unit = "KG";
                        $volume_unit = "CBM";
                        $length_unit = $width_unit = $height_unit = "CM";
                        if ($cargores['cargo_id'] != "") {
                            $chk = $this->common->gettblrowdata(["id" => $cargores['cargo_id']], "length_unit,width_unit,height_unit,weight_unit,volume_unit", "tb_cargo_details", 0, 0);
                            if (!empty($chk)) {
                                $weight_unit = $chk['weight_unit'];
                                $volume_unit = $chk['volume_unit'];
                                $length_unit = $chk['length_unit'];
                                $width_unit = $chk['width_unit'];
                                $height_unit = $chk['height_unit'];
                            }
                        }
                        if($length_unit == 'M'){
                            $cargores['length'] *= 100;
                        }
                        if($width_unit == 'M'){
                            $cargores['width'] *= 100;
                        }
                        if($height_unit == 'M'){
                            $cargores['height'] *= 100;
                        }
                        if($length_unit == 'Inches'){
                            $cargores['length'] *= 2.54;
                        }
                        if($width_unit == 'Inches'){
                            $cargores['width'] *= 2.54;
                        }
                        if($height_unit == 'Inches'){
                            $cargores['height'] *= 2.54;
                        }
                        $content = $cargores['cargo_content'] ?? "";
                        $cargos[] = ['cargo_type' => $cargores['quantity_type'], 'content' => $content, 'length' => $cargores['length'], 'width' => $cargores['width'], 'height' => $cargores['height'], 'weight' => $weight, 'volume' => $volume, 'quantity' => $cargores['quantity'], 'weight_unit' => $weight_unit, 'volume_unit' => $volume_unit,'height_unit'=>$height_unit,'length_unit'=>$length_unit,'width_unit'=>$width_unit];

                        $total_volume += $volume;
                        $total_weight += $weight;
                        $totalQuantity += $cargores['quantity'];
                    }
                    if ($cres->company_code != "") {
                        $company_code = $cres->company_code;
                    }
                    if ($cres->branch_code != "") {
                        $branch_code = $cres->branch_code;
                    }
                    $shipinfo = $cres->shipment_id;
                    $LogicalReceiver = "WWWWW99";
                    $newLogicalSender = '';
                    $logicalinfo = $this->common->gettblrowdata(['company_code' => $company_code, 'branch_code' => $branch_code], "logical_sender", "tb_branch_master", 0, 0);
                    if (!empty($logicalinfo)) {
                        $newLogicalSender = $logicalinfo['logical_sender'];
                    }
                    $shipid = $cres->shipmentid;
                    $incoterm =  $freight_term = $freight_termname = "";
                    if ($shipinfo != "" && $shipinfo != 0) {
                        $chk = $this->common->gettblrowdata(['id' => $shipinfo], "shipid, txnid, insertuserdate, insdate, incoterm, freight_term, freight_termname,physicalreceiver, logicalreceiver, physicalsender,logicalsender", "tb_shipments", 0, 0);
                        if (count($chk) > 0) {
                            if ($chk['physicalreceiver'] != "") {
                                $PhysicalReceiver = $chk['physicalreceiver'];
                            }
                            if ($chk['logicalreceiver'] != "") {
                                $LogicalReceiver = $chk['logicalreceiver'];
                            }
                            if ($chk['physicalsender'] != "") {
                                $PhysicalSender = $chk['physicalsender'];
                            }
                            if ($chk['logicalsender'] != "") {
                                $LogicalSender = $chk['logicalsender'];
                            }
                            if ($shipid == "") {
                                $shipid = $chk['shipid'];
                            }
                            $incoterm = $chk['incoterm'];
                        }
                    }
                    $references = $shipperReferences = [];
                    $checkReference = $this->common->gettbldata(["order_id" => $id,"status"=>'1'], "reference_id,ref_value", "tb_order_references", 0, 0);
                    foreach ($checkReference as $eachreference) {
                        $referenceId = $eachreference['reference_id'];
                        if(strlen($referenceId) == 2){
                            $references[] = ["id" => $eachreference['reference_id'], "value" => $eachreference['ref_value']];
                        }else{
                            $shipperReferences[] = ['id'=>$referenceId,'value'=>$eachreference['ref_value']];
                        }
                    }
                    $product = $cres->product;
                    if ($product == "") {
                        $product = "KN AsiaDirect";
                    }
                    $service_type = "";
                    if($serviceId >0){
                        $getServiceName = $this->common->gettblrowdata(["id" => $serviceId], "name", "tb_service_master", 0, 0);
                        if(!empty($getServiceName)){
                            $service_type = $getServiceName['name'];
                        }
                    }

                    $vtype = 1;
                    if ($cres->vehicle_type == "") {
                        $vtype = $cres->vehicle_type;
                    }
                    $t_mode = 1;
                    $tmode = $cres->transport_mode;
                    if ($tmode == "LTL") {
                        $t_mode = 0;
                    }
                    $vehtype = $cres->vehicle_type;
                    if ($vehtype == "") {
                        $vehtype = "F";
                    }
                    $PhysicalReceiver = 'WWDPT01';
                    $PhysicalSender = 'KNRLG09';
                    if(SYS_TYPE == 'TMS'){
                        $PhysicalSender = 'KNRLG01';
                        $PhysicalReceiver = 'WWDPP01';
                    }
                    $data = [
                        'SenderTransmissionNo' => $cres->order_id,
                        'pickup_datetime' => $cres->pickup_datetime,
                        'delivery_datetime' => $cres->delivery_datetime,
                        'pickup_endtime' => $cres->pickup_endtime,
                        'delivery_endtime' => $cres->drop_endtime,
                        'createdon' => $createdon,
                        "delivery_company" => $cres->delivery,
                        'delivery_city' => $cres->delivery_city,
                        'delivery_country' => $finalCountries[strtoupper($delivery_country)] ?? $delivery_country,
                        'delivery_address1' => $cres->delivery_address1,
                        'delivery_address2' => $cres->delivery_address2,
                        'delivery_pincode' => $cres->delivery_pincode,
                        'branch_code' => $branch_code,
                        'company_code' => $company_code,
                        'transport_mode' => $cres->transport_mode,
                        'pickup_country' =>  $finalCountries[strtoupper($pickup_country)] ?? $pickup_country,
                        'pickup_pincode' => $cres->pickup_pincode,
                        'country_code' => $code,
                        "pickup_company" => $cres->pickup,
                        'pickup_city' => $cres->pickup_city,
                        'pickup_address1' => $cres->pickup_address1,
                        'pickup_address2' => $cres->pickup_address2,
                        'cargos' => $cargos,
                        'total_weight' => $total_weight,
                        'total_volume' => $total_volume,
                        "vehicle_type" => $vehtype,
                        "parties" => $parties,
                        "physicalreceiver" => $PhysicalReceiver,
                        "logicalreceiver" => $LogicalReceiver,
                        "physicalsender" => $PhysicalSender,
                        "logicalsender" => $newLogicalSender,
                        "refs" => $references,
                        "quantity" => $totalQuantity,
                        "incoterm" => $incoterm,
                        "freight_term" => $freight_term,
                        "freight_termname" => $freight_termname,
                        "product" => $product,
                        "service_type" => $service_type,
                        "hrs" => $dthrs,
                        't_mode' => $t_mode,
                        "pickup_custid" => $cres->pickup_custid,
                        "drop_custid" => $cres->drop_custid,
                        "pickup_partyid" => $cres->pickup_partyid,
                        "drop_partyid" => $cres->drop_partyid,
                        'country_name' => $cntryname,
                        "cntrycode" => $cntrycode,
                        "weight" => $total_weight,
                        "shipmentid"=>$cres->shipmentid,
                        'carrierDetails'=>$carrierDetails,
                        'packageCodes'=>$packageCodes,
                        'shipperReferences'=>$shipperReferences,
                        'finalCountries'=>$finalCountries,

                    ];
                    $send = $this->knlogin->sendKNloginOrderxmlservice($data);
                    $upd = $this->common->updatetbledata("tb_orders", ["is_created" => 2], ["id" => $id]);
                }
            }
        } else {
            $validationErrors = [];
            if (!($customerPkId > 0)) {
                $validationErrors[] = "<li><b>Valid Customer Id</b> is required.</li>";
            }
            if (empty($fromDate)) {
                $validationErrors[] = "<li><b>From Date</b> is required.</li>";
            }

            if (empty($toDate)) {
                $validationErrors[] = "<li><b>To Date</b> is required.</li>";
            }

            if (empty($branchCode)) {
                $validationErrors[] = "<li><b>Branch name</b> is required.</li>";
            }
            if (!empty($validationErrors)) {
                echo '<h1>Data not found!</h1>';
                echo '<ol>'.implode('<br>',$validationErrors).'</ol>';
            }
        }
    }
}
