<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Knlogpod extends CI_Controller
{
    private const BEGIN_DATE = "1970-01-01";
    public function __construct()
    {
        parent::__construct();
        $this->load->library("sendpodtoknservice");
    }

    public function sendKnLogInPod(int $customerId=0,string $podsFromDate = '',string $podsToDate = '',int $podOrderId=0): void
    {
        if($customerId == 0 || $podsFromDate == ""){
            return;
        }

        $podsFromDate = date('Y-m-d',strtotime($podsFromDate));
        $podsToDate = ($podsToDate != "") ? date('Y-m-d',strtotime($podsToDate)) : $podsFromDate;
        if(strpos($podsFromDate, self::BEGIN_DATE) !== false || strpos($podsToDate, self::BEGIN_DATE) !== false){
            return;
        }
        $orderWhereCondition = $podOrderId > 0 ? " AND o.id=".$podOrderId : "";
        $getPod = $this->db->query(
            "SELECT p.imgpath, o.order_id, o.company_code, o.branch_code  FROM tb_pod_uploads p, tb_orders o  WHERE p.order_id = o.id  AND p.doc_type = 3 AND p.imgpath != '' $orderWhereCondition AND o.customer_id = ? AND (DATE(p.createdon) BETWEEN ? AND ?) AND o.status != 0",
            [
                $customerId,
                $podsFromDate,
                $podsToDate,
            ]);
        if ($getPod->num_rows() > 0) {
            foreach ($getPod->result_array() as $res) {
                $fileName = $res['imgpath'];
                $company_code = $res['company_code'];
                $branch_code = $res['branch_code'];
                $orderNumber = $res['order_id'];
                $filePath = NEW_POD_PATH . $fileName;
                $newPdfPath = './assets/trippods/RL' . $orderNumber . '.pdf';
                $ext = pathinfo($fileName, PATHINFO_EXTENSION);
                if (file_exists($filePath)) {
                    if ($ext != "pdf") {
                        $filePath = $this->sendpodtoknservice->imageToPdf($filePath, $ext, $newPdfPath);
                    }
                    $pages = $this->sendpodtoknservice->getNumPagesPdf($filePath);
                    $unique_id = "RL" . $orderNumber . "." . date("Ymd") . "." . date("his");
                    $jplData = [
                        "country" => substr($company_code, 0, -2),
                        "branch" => substr($branch_code, 2),
                        "order_id" => $orderNumber,
                        "time" => date("hi"),
                        "unique_id" => $unique_id,
                        "date" => date("d.m.Y"),
                        "pages" => $pages,
                    ];
                    $jplFilePath = $this->sendpodtoknservice->saveJPF($jplData);
                    $this->sendpodtoknservice->uploadKNFile($jplFilePath);
                    $this->sendpodtoknservice->uploadKNFile($filePath);
                }
            }
            echo "Sent to KNLogin";
        } else {
            echo "No PODs";
        }
    }
}
