<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use App\Generators\RandomString;

class Knmacdambooking extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('common');
	}

    public function index(){
		$postData = file_get_contents('php://input');
		log_message("error","macdam_reqdata ".json_encode($postData));
		if(!empty($postData)){
			$xml = new SimpleXMLElement($postData);
			$userid = 1;
			$response = array();
			$statusmsg = "";
			$preceiver = $lreceiver = $psender = $lsender = $shipmentid = $sendertransmode = $pickup_city = $company_code = $branch_code = "";
			if ($xml === false) {
			 	$statusmsg = "Invalid request,Please try again!";
			}else{
				$shipdata11 = $this->read_shipmentdata($xml);
				$curtz = date_default_timezone_get();
				$curdt = date('Y-m-d H:i:s');
				$getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
				$logdate = $getactual['datetime'];
				if(!empty($shipdata11)){
				   log_message("error","macdam_parseddata ".json_encode($shipdata11));
				   $response = $this->insertShipmentData($shipdata11,$logdate);
				}
				if(!empty($response)){
					$shipid = $response[0];
					/* update status */
					$chk = $this->db->select("id")->get_where("tb_stop_status",array("shipment_id"=>$shipid,"status_id"=>9),1,0);
					if($chk->num_rows() == 0){
						$ins = array("shipment_id"=>$shipid,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>9,"status_code"=>"0100","status"=>1,"reason"=>"Coming from E-Booking","createdon"=>$curdt);
						$insqry = $this->db->insert("tb_stop_status",$ins);
						$ordid = isset($shipdata11['shipdata'][0]['orderid']) ? $shipdata11['shipdata'][0]['orderid'] : "";
						$sendertransmode = isset($shipdata11['shipdata'][0]['sendertransmode']) ? $shipdata11['shipdata'][0]['sendertransmode'] : "";
						$company_code = isset($shipdata11['shipdata'][0]['sendercmpcode']) ? $shipdata11['shipdata'][0]['sendercmpcode'] : "";
						$branch_code = isset($shipdata11['shipdata'][0]['senderbranchcode']) ? $shipdata11['shipdata'][0]['senderbranchcode'] : "";
						$pickup_city = isset($shipdata11['shipdata'][0]['pickdrops'][0]['pickup_city']) ? $shipdata11['shipdata'][0]['pickdrops'][0]['pickup_city'] : "";
						$pdatefromtime = isset($shipdata11['shipdata'][0]['pickdrops'][0]['pickup_datefromtime']) ? $shipdata11['shipdata'][0]['pickdrops'][0]['pickup_datefromtime'] : "";
						$preceiver = isset($shipdata11['header']['preceiver']) ? $shipdata11['header']['preceiver'] : "";
						$lreceiver = isset($shipdata11['header']['lreceiver']) ? $shipdata11['header']['lreceiver'] : "";
						$psender = isset($shipdata11['header']['psender']) ? $shipdata11['header']['psender'] : "";
						$lsender = isset($shipdata11['header']['lsender']) ? $shipdata11['header']['lsender'] : "";
						$shipmentid = isset($shipdata11['truck']['shipment_id']) ? $shipdata11['truck']['shipment_id'] : "";
						$lstchars = "+05:30";
						if($pdatefromtime != ""){
							$lstchars = substr($pdatefromtime, -6);
						}
						if($lstchars == ""){
							$lstchars = "+08:00";
						}
			      		$curtzs = gettimezonebygmtplusval($lstchars);
						if($ordid != ""){
							$postdata = array(
	                            "shipment_id" => $shipid,
	                            "preceiver"     => $preceiver,
	                            "lreceiver"   => $lreceiver,
	                            "order_id"    => $ordid,
	                            "psender"     => $psender,
	                            "lsender"     => $lsender,
	                            "latitude"    => '',
	                            "longitude"   => '',
	                            "curtz" => $curtzs,
	                            "shipmentid"   => $shipmentid,
	                            "modeoftransport"   => $sendertransmode,
	                            "pickup_city"   => $pickup_city,
	                            "company_code"   => $company_code,
	                            "branch_code"   => $branch_code,
	                            "hrs"   => $lstchars
	                        );
	                        $ins = array("shipment_id"=>$shipid,"stop_id"=>0,"stop_detail_id"=>0,"stop_type"=>"","trip_id"=>0,"status_id"=>11,"status_code"=>"2400","status"=>1,"reason"=>"Planned Delivery Date","createdon"=>$curdt);
							$insqry = $this->db->insert("tb_stop_status",$ins);
	                        $this->load->library("macdambookingstatusintigration");
	                        $sts = $this->macdambookingstatusintigration->macdamshipbookedbysupplier($postdata);
	                        $sts = $this->macdambookingstatusintigration->macdamshipplandeliverdate($postdata);
	                    }
					}
					$statusmsg = "Success";
				}else{
					$statusmsg = "Failed for unformatted request,Please try again!";
				}
	    	}
	    }else{
	    	$statusmsg = "Invalid request,Please try again!";
	    }
    	echo $statusmsg;
    }
   	public function read_shipmentdata($xml){
		$res = array();
		$xml->registerXPathNamespace('lhdr', 'http://knie4.int.kn/com/lhdr/0200');
		$data = $xml->xpath('lhdr:MessageHeader');
		$physicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->PhysicalReceiver);
		$logicalreceiver = (string)($data[0]->xpath('ReceiverDetails')[0]->LogicalReceiver);
		$physicalsender = (string)($data[0]->xpath('PhysicalSender')[0]);
		$logicalsender = (string)($data[0]->xpath('LogicalSender')[0]);
		$lreceiver = $preceiver = $psender = $lsender = $triptype = "";
		$loadcapacity = 0;
		$driver = $carrier = array();
		$preceiver = $physicalreceiver;
		$lreceiver = $logicalreceiver;
		$psender = $physicalsender;
		$lsender = $logicalsender;
		$sendapp = (string)($data[0]->xpath('SendingApplication')[0]);
		$msgtype = (string)($data[0]->xpath('MessageType')[0]);
		$version = (string)($data[0]->xpath('VersionNumber')[0]);
		$createdtime = (string)($data[0]->xpath('CreationDateTime')[0]);
		if($createdtime != ""){
		 $createdtime = date("Y-m-d H:i:s",strtotime($createdtime));
		}else{
		 $createdtime = date("Y-m-d H:i:s");
		}
		$res['header'] = array("preceiver"=>$preceiver,"lreceiver"=>$lreceiver,"psender"=>$psender,"lsender"=>$lsender,"sendapp"=>$sendapp,"msgtype"=>$msgtype,"version"=>$version,"createdtime"=>$createdtime);
		/* truck and trailer info */
		$arr = array();
		$xml->registerXPathNamespace('ltru', 'http://knie4.int.kn/com/ltru/0200');
		$titledata = $xml->xpath('//ltru:TruckAndTrailer');
		if(isset($titledata)){
			if(isset($titledata[0])){
			$veh_number = isset($titledata[0]->xpath('TruckLicenseNumber')[0]) ? $titledata[0]->xpath('TruckLicenseNumber')[0] : "";
			$arr['veh_number'] = (string)($veh_number);
			$veh_type = isset($titledata[0]->xpath('VehicleType')[0]) ? $titledata[0]->xpath('VehicleType')[0] : "";
			$arr['veh_type'] = (string)($veh_type);
			$arr['ordernum'] = (string)($titledata[0]->xpath('VoyageNumber')[0]);
			$arr['shipment_id'] = (string)($titledata[0]->xpath('TourNumber')[0]);
			$arr['origin'] = (string)($titledata[0]->xpath('Origin')[0]->Location[0]);
			$arr['originloc2'] = (string)($titledata[0]->xpath('Origin')[0]->Location[1]);
			$arr['origindate'] = (string)($titledata[0]->xpath('Origin')[0]->Date);
			$arr['noofshipments'] = (string)($titledata[0]->xpath('NumberOfShipments')[0]);
			$address = $triptype = $loadcapacity = "";
			if(null !== $titledata[0]->xpath('Address')){
				if(!empty($titledata[0]->xpath('Address'))){
				$address = (string)($titledata[0]->xpath('Address')[0]->attributes('ns2', TRUE)->AddressType);
				if($address == "CA"){
					$carrier['name'] = (string)($titledata[0]->xpath('Address')[0]->Name);
					$carrier['street'] = (string)($titledata[0]->xpath('Address')[0]->Street[0]);
					$carrier['street1'] = (string)($titledata[0]->xpath('Address')[0]->Street[1]);
					$carrier['city'] = (string)($titledata[0]->xpath('Address')[0]->City);
					$carrier['country'] = (string)($titledata[0]->xpath('Address')[0]->CountryCode);
					$carrier['zip'] = (string)($titledata[0]->xpath('Address')[0]->ZipCode);
					$carrier['custid'] = (string)($titledata[0]->xpath('Address')[0]->CustomerIdentifier);
					$carrier['partyid'] = (string)($titledata[0]->xpath('Address')[0]->PartyIdentifier);
					if(null !== (string)$titledata[0]->xpath('Address')[0]->ContactDetails){
						$contacttype = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->ContactType);
						if($contacttype == "Driver"){
						$driver['contacttype'] = $contacttype;
						$driver['lastname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->LastName);
						$driver['firstname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->FirstName);
						$driver['commtype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication['ns2:CommunicationType']);
						}
						$driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails->Communication);
						if(null !== $titledata[0]->xpath('DriverID')){
							if(!empty($titledata[0]->xpath('DriverID'))){
								$driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
							}
						}
					}
					if(null !== $titledata[0]->xpath('Address')[0]->ContactDetails[1]){
						if(null !== (string)$titledata[0]->xpath('Address')[0]->ContactDetails[1]){
							$contacttype = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->ContactType);
							if($contacttype == "Driver"){
							$driver['contacttype'] = $contacttype;
							$driver['lastname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->LastName);
							$driver['firstname'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->FirstName);
							$driver['commtype'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->Communication['ns2:CommunicationType']);
							}
							$driver['commtypename'] = (string)($titledata[0]->xpath('Address')[0]->ContactDetails[1]->Communication);
							if(null !== $titledata[0]->xpath('DriverID')){
								if(!empty($titledata[0]->xpath('DriverID'))){
									$driver['driverid'] = (string)($titledata[0]->xpath('DriverID')[0]);
								}
							}
						}
					}
					}
				} }
				if(null !== $titledata[0]->xpath('TripType')){
					if(!empty($titledata[0]->xpath('TripType'))){
					$triptype = (string)($titledata[0]->xpath('TripType')[0]);
				}
				}
				if(null !== $titledata[0]->xpath('LoadingCapacity')){
					if(!empty($titledata[0]->xpath('LoadingCapacity'))){
					$loadcapacity = (string)($titledata[0]->xpath('LoadingCapacity')[0]);
					}
				}
			}
		}
		$res['carrier'] = $carrier;
		$res['driver'] = $driver;
		$arr['triptype'] = $triptype;
		$arr['loadcapacity'] = $loadcapacity;
		$res['truck'] = $arr;
		$res['shipdata'] = array();
		$xml->registerXPathNamespace('ns0', 'http://knie4.int.kn/msg/roadshipment/0100');
		$mdata = $xml->xpath('//ns0:RoadShipment');
		$shinfo = $mdata[0]->xpath('Message')[0]->Shipment;
		foreach($shinfo as $key=>$cships){
			$res['shipdata'][] = $this->generateshipmentdata($cships,$key);
		}
		return $res;
    }
   	function generateshipmentdata($xml,$key){
   		$xml->registerXPathNamespace('lmlv', 'http://knie4.int.kn/com/lmlv/0200');
		$titledata = $xml->xpath('lmlv:MessageLevel');
		$arr['orderid'] = "";
		if(null !== $titledata[0]->xpath('TrackingNumber')){
			$arr['orderid'] = isset($titledata[0]->xpath('TrackingNumber')[0]) ? (string)($titledata[0]->xpath('TrackingNumber')[0]) : "";
		}
		$arr['sendercmpcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->CompanyCode);
		$arr['senderbranchcode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->BranchCode);
		$arr['sendertransmode'] = 1;
		if(null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport)){
	        $arr['sendertransmode'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ModeOfTransport);
	    }
        $arr['senderflag'] = $arr['refcode'] = $arr['refvalue'] = "";
        if(null !== (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag)){
	        $arr['senderflag'] = (string)($titledata[0]->xpath('SenderInformation')[0]->ExportImportFlag);
	    }
	    $arr['references'] = array();
	    if(null !== $titledata[0]->xpath('MessageReferences')){
	    	if(!empty($titledata[0]->xpath('MessageReferences'))){
		    	$arr['refcode'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Code);
	        	$arr['refvalue'] = (string)($titledata[0]->xpath('MessageReferences')[0]->Value);
	        	$arr['references'][] = array('code'=>$arr['refcode'],'value'=>$arr['refvalue']);
	        }
	    }
        $infodata = $xml->ShipmentInformation;
        $infodata->registerXPathNamespace('lshpd', 'http://knie4.int.kn/com/lshpd/0200');
		$details = $infodata->xpath('lshpd:ShipmentDetails');
		$arr['packages'] = 1;
		$arr['measurements'] = array();
		$arr['dangerousflag'] = $arr['totaldangerousflag'] = $arr['source'] = $arr['sourcedate'] = $arr['destination'] = $arr['destinationdate'] = $arr['slocationcountry'] = $arr['dlocationcountry'] = $arr['incoterm'] = "";
		if(!empty($details)){
			if(null !== $details[0]->xpath('TotalPackages')){
		    	if(!empty($details[0]->xpath('TotalPackages'))){
					$arr['packages'] = (string)($details[0]->xpath('TotalPackages')[0]);
				}
			}
			if(null !== $details[0]->xpath('Measurements')){
		    	if(!empty($details[0]->xpath('Measurements'))){
					foreach($details[0]->xpath('Measurements') as $mm){
						$arr['measurements'][] = array('mtype'=>(string)$mm->attributes('ns2', TRUE)->MeasurementType,'value'=>(string)$mm->Value,'uom'=>(string)$mm->UnitOfMeasurementCode);
					}
				}
			}
			if(null !== $details[0]->xpath('DangerousGoodsFlag')){
		    	if(!empty($details[0]->xpath('DangerousGoodsFlag'))){
				$arr['dangerousflag'] = (string)($details[0]->xpath('DangerousGoodsFlag')[0]);
			}}
			if(null !== $details[0]->xpath('TotalPackagesOfDangerousGoods')){
			    	if(!empty($details[0]->xpath('TotalPackagesOfDangerousGoods'))){
				$arr['totaldangerousflag'] = (string)($details[0]->xpath('TotalPackagesOfDangerousGoods')[0]);
			}}
			if(null !== $details[0]->xpath('TermsOfTrade')){
			    	if(!empty($details[0]->xpath('TermsOfTrade'))){
				$arr['incoterm'] = (string)($details[0]->xpath('TermsOfTrade')[0]->Incoterm);
			}}
			if(null !== $details[0]->xpath('Origin')){
			    	if(!empty($details[0]->xpath('Origin'))){
				$arr['source'] = (string)($details[0]->xpath('Origin')[0]->OriginLocation);
				$arr['sourcedate'] = (string)($details[0]->xpath('Origin')[0]->Date);
			}}
			if(null !== $details[0]->xpath('Destination')){
			    	if(!empty($details[0]->xpath('Destination'))){
				$arr['destination'] = (string)($details[0]->xpath('Destination')[0]->DestinationLocation);
				$arr['destinationdate'] = (string)($details[0]->xpath('Destination')[0]->Date);
			}}
			if(null !== $details[0]->xpath('Location')){
			    	if(!empty($details[0]->xpath('Location'))){
				$arr['slocationcountry'] = (string)($details[0]->xpath('Location')[0]);
				$arr['dlocationcountry'] = (string)($details[0]->xpath('Location')[1]);
			}}
		}
		$shipper = $consignee = $pf = array();
		$infodata->registerXPathNamespace('ladr', 'http://knie4.int.kn/com/ladr/0200');
		foreach($infodata->xpath('ladr:NameAddress') as $addr){
			if($addr->attributes('ltypes', TRUE)->AddressType == "SH"){
				$custid = $partyid = "";
				if(null !== $addr->xpath('CustomerIdentifier')){
					if(!empty($addr->xpath('CustomerIdentifier'))){
						$custid = (string)($addr->xpath('CustomerIdentifier')[0]);
					}
				}
				if(null !== $addr->xpath('PartyIdentifier')){
					if(!empty($addr->xpath('PartyIdentifier'))){
						$partyid = (string)($addr->xpath('PartyIdentifier')[0]);
					}
				}
				$shipper = array('name'=>(string)($addr->xpath('Name')[0]),'street'=>(string)($addr->xpath('Street')[0]),'city'=>(string)($addr->xpath('City')[0]),'country'=>(string)($addr->xpath('CountryCode')[0]),'zip'=>(string)($addr->xpath('ZipCode')[0]),'custid'=>$custid,'partyid'=>$partyid);
				if(null !== $addr->xpath('References')){
					if(!empty($addr->xpath('References'))){
						foreach($addr->xpath('References') as $cref){
							$arr['references'][] = array('code'=>(string)$cref->Code,'value'=>(string)$cref->Value);
						}
					}
				}
			}
			if($addr->attributes('ltypes', TRUE)->AddressType == "CN"){
				$custid = $partyid = "";
				if(null !== $addr->xpath('CustomerIdentifier')){
					if(!empty($addr->xpath('CustomerIdentifier'))){
						$custid = (string)($addr->xpath('CustomerIdentifier')[0]);
					}
				}
				if(null !== $addr->xpath('PartyIdentifier')){
					if(!empty($addr->xpath('PartyIdentifier'))){
						$partyid = (string)($addr->xpath('PartyIdentifier')[0]);
					}
				}
				$consignee = array('name'=>(string)($addr->xpath('Name')[0]),'street'=>(string)($addr->xpath('Street')[0]),'city'=>(string)($addr->xpath('City')[0]),'country'=>(string)($addr->xpath('CountryCode')[0]),'zip'=>(string)($addr->xpath('ZipCode')[0]),'custid'=>$custid,'partyid'=>$partyid);
				if(null !== $addr->xpath('References')){
					if(!empty($addr->xpath('References'))){
						foreach($addr->xpath('References') as $cref){
							$arr['references'][] = array('code'=>(string)$cref->Code,'value'=>(string)$cref->Value);
						}
					}
				}
			}
			if($addr->attributes('ltypes', TRUE)->AddressType == "PF"){
				$custid = $partyid = $pfname = $pfstreet = $pfcity = $pfcountry = $pfzip = "";
				if(null !== $addr->xpath('Name')){
					if(!empty($addr->xpath('Name'))){
						$pfname = (string)($addr->xpath('Name')[0]);
					}
				}if(null !== $addr->xpath('Street')){
					if(!empty($addr->xpath('Street'))){
						$pfstreet = (string)($addr->xpath('Street')[0]);
					}
				}if(null !== $addr->xpath('City')){
					if(!empty($addr->xpath('City'))){
						$pfcity = (string)($addr->xpath('City')[0]);
					}
				}if(null !== $addr->xpath('CountryCode')){
					if(!empty($addr->xpath('CountryCode'))){
						$pfcountry = (string)($addr->xpath('CountryCode')[0]);
					}
				}if(null !== $addr->xpath('ZipCode')){
					if(!empty($addr->xpath('ZipCode'))){
						$pfzip = (string)($addr->xpath('ZipCode')[0]);
					}
				}
				if(null !== $addr->xpath('CustomerIdentifier')){
					if(!empty($addr->xpath('CustomerIdentifier'))){
						$custid = (string)($addr->xpath('CustomerIdentifier')[0]);
					}
				}
				if(null !== $addr->xpath('PartyIdentifier')){
					if(!empty($addr->xpath('PartyIdentifier'))){
						$partyid = (string)($addr->xpath('PartyIdentifier')[0]);
					}
				}
				if($pfname != ""){
					$pf = array('name'=>$pfname,'street'=>$pfstreet,'city'=>$pfcity,'country'=>$pfcountry,'zip'=>$pfzip,'custid'=>$custid,'partyid'=>$partyid);
					if(null !== $addr->xpath('References')){
						if(!empty($addr->xpath('References'))){
							foreach($addr->xpath('References') as $cref){
								$arr['references'][] = array('code'=>(string)$cref->Code,'value'=>(string)$cref->Value);
							}
						}
					}
				}
			}
		}
		$arr['items_count'] = $arr['pkgs_count'] = 1;
		$arr['pkgs_uom'] = 'PCS';
		$arr['gross_weight'] = $arr['volume'] = 1;
		$arr['weight_uom'] = 'KGM';
		$arr['volume_uom'] = 'MTQ';
		$arr['cargo_content'] = 'Boxes';
		if(null !== $infodata[0]->xpath('CargoDescription')){
			if(!empty($infodata[0]->xpath('CargoDescription'))){
				$cargo = $infodata[0]->xpath('CargoDescription')[0];
				$cargo->registerXPathNamespace('lcgod', 'http://knie4.int.kn/com/lcgod/0200');
				$cargodetails = $cargo->xpath('lcgod:CargoDescriptionDetails');
				$arr['items_count'] = (string)($cargodetails[0]->xpath('CargoItem')[0]);
				$arr['pkgs_count'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->Value);
				$arr['pkgs_uom'] = (string)($cargodetails[0]->xpath('NumberOfPackages')[0]->QuantityType);
				$arr['gross_weight'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->Value);
				$arr['weight_uom'] = (string)($cargodetails[0]->xpath('GrossWeight')[0]->UnitOfMeasurementCode);
				if(null !== $cargodetails[0]->xpath('Volume')){
					$arr['volume'] = isset($cargodetails[0]->xpath('Volume')[0]->Value) ? (string)($cargodetails[0]->xpath('Volume')[0]->Value) : 1;
				}
				if(null !== $cargodetails[0]->xpath('Volume')){
					$arr['volume_uom'] = isset($cargodetails[0]->xpath('Volume')[0]->UnitOfMeasurementCode) ? (string)($cargodetails[0]->xpath('Volume')[0]->UnitOfMeasurementCode) : 'MTQ';
				}
				$arr['cargo_content'] = (string)($cargodetails[0]->xpath('CargoContent')[0]);
			}
		}
		$arr['shipper'] = $shipper;
		$arr['consignee'] = $consignee;
		$arr['pf'] = $pf;
		$infodata1 = $xml->ShipmentRoad;
        $infodata1->registerXPathNamespace('rdtl', 'http://knie4.int.kn/com/lrdtl/0200');
		$roaddetail = $infodata1->xpath('rdtl:RoadDetails');
		$arr['serviceproduct'] = $arr['servicetype'] = $arr['freight_term'] = $arr['freight_termname'] = "";
		if(null !== $roaddetail[0]->xpath('Product')){
			if(!empty($roaddetail[0]->xpath('Product'))){
			$arr['serviceproduct'] = (string)($roaddetail[0]->xpath('Product')[0]);
			} }
		if(null !== $roaddetail[0]->xpath('ServiceType')){
				if(!empty($roaddetail[0]->xpath('ServiceType'))){
	        $arr['servicetype'] = (string)($roaddetail[0]->xpath('ServiceType')[0]);
	    }}
	    if(null !== $roaddetail[0]->xpath('FreightName')){
				if(!empty($roaddetail[0]->xpath('FreightName'))){
	        $arr['freight_term'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Term);
	    }}
	    if(null !== $roaddetail[0]->xpath('FreightName')){
				if(!empty($roaddetail[0]->xpath('FreightName'))){
	        $arr['freight_termname'] = (string)($roaddetail[0]->xpath('FreightName')[0]->Name);
	    }}
        $pickdrop = array();
        $p = $d = 0;
        $waypoints = $infodata1->TruckingWayPoint;
		foreach($waypoints as $sd){
			if($sd->attributes('ns0', TRUE)->WayPointType == "PUP"){
				$sd->registerXPathNamespace('ladr', 'http://knie4.int.kn/com/ladr/0200');
				$point = $sd->xpath('ladr:NameAddress');
				$arr1 = array();
				$arr1['pickup_company'] = (string)($point[0]->xpath('Name')[0]);
				$street1 = isset($point[0]->xpath('Street')[0]) ? $point[0]->xpath('Street')[0] : "";
				$arr1['pickup_address'] = (string)($street1);
				$street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
				$arr1['pickup_address1'] = (string)($street2);
				$arr1['pickup_city'] = (string)($point[0]->xpath('City')[0]);
				$arr1['pickup_countrycode'] = (string)($point[0]->xpath('CountryCode')[0]);
				$arr1['pickup_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
				$arr1['pickup_custid'] = $arr1['pickup_partyid'] = "";
				if(null !== $point[0]->xpath('CustomerIdentifier')){
					$arr1['pickup_custid'] = isset($point[0]->xpath('CustomerIdentifier')[0]) ? (string)($point[0]->xpath('CustomerIdentifier')[0]) : "";
				}
				if(null !== $point[0]->xpath('PartyIdentifier')){
					$arr1['pickup_partyid'] = isset($point[0]->xpath('PartyIdentifier')[0]) ? (string)($point[0]->xpath('PartyIdentifier')[0]) : "";
				}
				$arr1['pickup_datefrom'] = (string)$sd->DateRange->DateFrom;
				$arr1['pickup_datefromtime'] = (string)$sd->DateRange->TimeFrom;
				$arr1['pickup_dateto'] = (string)$sd->DateRange->DateTo;
				$arr1['pickup_datetotime'] = (string)$sd->DateRange->TimeTo;
				$arr1['sequence'] = (string)$sd->Sequence;
				$arr1['stoptype'] = 'P';
				$arr1['stop_type'] = (string)($point[0]->attributes('ns2', TRUE)->AddressType);
				$p++;
				$pickdrop[] = $arr1;
			}
			if($sd->attributes('ns0', TRUE)->WayPointType == "DEL"){
				$sd->registerXPathNamespace('ladr', 'http://knie4.int.kn/com/ladr/0200');
				$point = $sd->xpath('ladr:NameAddress');
				$arr2 = array();
				$arr2['drop_company'] = (string)($point[0]->xpath('Name')[0]);
				$street1 = isset($point[0]->xpath('Street')[0]) ? $point[0]->xpath('Street')[0] : "";
				$arr2['drop_address'] = (string)($street1);
				$street2 = isset($point[0]->xpath('Street')[1]) ? $point[0]->xpath('Street')[1] : "";
				$arr2['drop_address1'] = (string)($street2);
				$arr2['drop_city'] = (string)($point[0]->xpath('City')[0]);
				$arr2['drop_countrycode'] = (string)($point[0]->xpath('CountryCode')[0]);
				$arr2['drop_postal'] = (string)($point[0]->xpath('ZipCode')[0]);
				$arr2['drop_custid'] = $arr2['drop_partyid'] = "";
				if(null !== $point[0]->xpath('CustomerIdentifier')){
					$arr2['drop_custid'] = isset($point[0]->xpath('CustomerIdentifier')[0]) ? (string)($point[0]->xpath('CustomerIdentifier')[0]) : "";
				}
				if(null !== $point[0]->xpath('PartyIdentifier')){
					$arr2['drop_partyid'] = isset($point[0]->xpath('PartyIdentifier')[0]) ? (string)($point[0]->xpath('PartyIdentifier')[0]) : "";
				}
				$arr2['drop_datefrom'] = (string)$sd->DateRange->DateFrom;
				$arr2['drop_datefromtime'] = (string)$sd->DateRange->TimeFrom;
				$arr2['drop_dateto'] = (string)$sd->DateRange->DateTo;
				$arr2['drop_datetotime'] = (string)$sd->DateRange->TimeTo;
				$arr2['sequence'] = (string)$sd->Sequence;
				$arr2['stoptype'] = 'D';
				$arr2['stop_type'] = (string)($point[0]->attributes('ns2', TRUE)->AddressType);
				$d++;
				$pickdrop[] = $arr2;
			}
		}
		$arr['pickdrops'] = $pickdrop;
		$arr['pickcount'] = $p;
		$arr['dropcount'] = $d;
		$arr['typeofbusiness'] = "";
		return $arr;
   	}

   	public function insertShipmentData($data,$logdate){
   		$curtz = date_default_timezone_get();
		$curdt = $logdate;
		$responseord = array();
		$transmode = "TL";
		$dedicateveh = 1;
		$user_id = 1;
		foreach($data['shipdata'] as $shipdata){
		$ttansmode = $shipdata['servicetype'];
		if($ttansmode != "Full Truck Load"){
			$transmode = "LTL";
			$dedicateveh = 0;
		}
		if(strlen($data['header']['lsender']) > 2){
		    $firsttwochars = substr($data['header']['lsender'], 0,2);
		}else{
			$firsttwochars = $data['header']['lsender'];
		}
		$company_code = $shipdata['sendercmpcode'];
		if($company_code == "KNFR"){
			$company_code = "FRKN";
		}
		$branch_code = $shipdata['senderbranchcode'];
		$chk = $this->db->query("SELECT id FROM tb_users WHERE company_code='".$company_code."' AND branch_code='".$branch_code."' AND status='Active' LIMIT 1");
		if($chk->num_rows()>0){
			$user_id = $chk->row()->id;
		}else{
			$chk01 = $this->db->query("SELECT user_id FROM tb_user_companies WHERE company_code='".$company_code."' AND branch_code='".$branch_code."' AND status=1 LIMIT 1");
			if($chk01->num_rows()>0){
				$user_id = $chk01->row()->user_id;
			}else{
				$adminrand = time();
				$adminpwd = base64_encode(base64_encode($adminrand));
				$udata = array('country_code'=>$firsttwochars, 'name'=>$firsttwochars."_Admin", 'company_indv_name'=>$company_code, 'business_type'=>'Truck_Owner', 'mobile_no'=>$adminrand, 'password'=>$adminpwd, 'emailid'=>'etsvkonektrucknow@kuehne-nagel.com', 'domain_name'=>$branch_code, 'location_id'=>1646, 'createdby'=>1, 'status'=>'Active', 'createdon'=>$curdt, 'company_code'=>$company_code, 'branch_code'=>$branch_code);
				$user_id = $this->common->insertTableData('tb_users',$udata);
			}
		}
		if(!empty($data['carrier'])){
		  if(!isset($data['carrier']['custid'])){
		  	$getcar = $this->db->select("name,mobile,location,address,pincode,country,code,custid,partyid")->get_where("tb_vendors",array("user_id"=>$user_id,"company_code"=>$shipdata['sendercmpcode'],"branch_code"=>$shipdata['senderbranchcode'],"status"=>1),1,0);
		  	if($getcar->num_rows()>0){
		  		$cardata = $getcar->row();
		  		$data['carrier']=array('name'=>$cardata->name,'street'=>$cardata->address,'street1'=>'','city'=>$cardata->location,'country'=>$cardata->country,'zip'=>$cardata->pincode,'custid'=>$cardata->custid,'partyid'=>$cardata->partyid);
		  	}
		  }
		}
		$ca_partytype = 2;
		$carrier = $this->checkcarrier($data['carrier'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id);
		$carrier_id = $carrier['id'];
		if(isset($carrier['party_id'])){ $carrier_party_id = $carrier['party_id']; $ca_partytype = $carrier['party_type']; }
		if(!isset($data['truck']['shipment_id'])){
			$data['truck']['shipment_id'] = mt_rand();
		}
		if(!isset($data['truck']['ordernum'])){
			$data['truck']['ordernum'] = mt_rand();
		}
		$getactual = getdatetimebytimezone(DFLT_TZ,$shipdata['sourcedate'],$curtz);
		$shipdata['sourcedate'] = $getactual['datetime'];
		$getactual = getdatetimebytimezone(DFLT_TZ,$shipdata['destinationdate'],$curtz);
		$shipdata['destinationdate'] = $getactual['datetime'];
      	$shipdatains = array('shipid'=>$data['truck']['shipment_id'], 'txnid'=>$data['truck']['ordernum'], 'trucktype'=>$ttansmode,'product'=>$shipdata['serviceproduct'], 'pickupcnt'=>$shipdata['pickcount'], 'dropcnt'=>$shipdata['dropcount'], 'unitspec'=>$shipdata['cargo_content'], 'insertusr'=>$shipdata['shipper']['custid'], 'carrier'=>$carrier_id, 'insertuserdate'=>$shipdata['sourcedate'], 'enddate'=>$shipdata['destinationdate'], 'insdate'=>$shipdata['sourcedate'], 'upddate'=>$shipdata['destinationdate'], 'reason'=>'SHIPMENT', 'purpose'=>'SEND INTEGRATION', 'ship_object'=>'SHIPMENT', 'logdate'=>$logdate, 'status'=>1, 'createdon'=>$curdt, 'transport_mode'=>$transmode, 'txncode'=>$shipdata['orderid'],'domainname'=>$data['header']['lsender'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'freight_term'=>$shipdata['freight_term'],'freight_termname'=>$shipdata['freight_termname'],'incoterm'=>$shipdata['incoterm'],'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
      $sship_id = $this->common->insertTableData('tb_shipments',$shipdatains);
      $pickup_datetime = $pickup_endtime = $delivery_datetime = $drop_endtime = $pickup_company = "";
      $starttime = $endtime = "";
      if(isset($shipdata['pickdrops'])){
      	foreach($shipdata['pickdrops'] as $res){
	      	if($res['stoptype'] == "P"){
	      		$starttime = $res['pickup_datefromtime'];
	      		$pickup_datetime = $res['pickup_datefrom']." ".$res['pickup_datefromtime'];
	      		$pickup_datetime = date('Y-m-d H:i:s',strtotime($pickup_datetime));
	      		$lstchars = substr($res['pickup_datefromtime'], -6);
	      		$curtzs = gettimezonebygmtplusval($lstchars);
	      		$getactual = getdatetimebytimezone(DFLT_TZ,$pickup_datetime,$curtzs);
	      		$pickup_datetime = $getactual['datetime'];
	      		$pickup_endtime = $res['pickup_dateto']." ".$res['pickup_datetotime'];
	      		$pickup_endtime = date('Y-m-d H:i:s',strtotime($pickup_endtime));
	      		$lstchars = substr($res['pickup_datetotime'], -6);
	      		$curtzs = gettimezonebygmtplusval($lstchars);
	      		$getactual = getdatetimebytimezone(DFLT_TZ,$pickup_endtime,$curtzs);
	      		$pickup_endtime = $getactual['datetime'];
	      		$pickup_company = $res['pickup_company'];
	      		$pickup_address = $res['pickup_address'];
	      		$pickup_city = $res['pickup_city'];
	      		$pickup_countrycode = $res['pickup_countrycode'];
	      		$pickup_postal = $res['pickup_postal'];
	      		$pickup_address1 = $res['pickup_address1'];
	      		$pickup_custid = $res['pickup_custid'];
	      		$pickup_partyid = $res['pickup_partyid'];
	      	}
	      	if($res['stoptype'] == "D"){
	      		$endtime = $res['drop_datefromtime'];
	      		$delivery_datetime = $res['drop_datefrom']." ".$res['drop_datefromtime'];
	      		$delivery_datetime = date('Y-m-d H:i:s',strtotime($delivery_datetime));
	      		$lstchars = substr($res['drop_datefromtime'], -6);
	      		$curtzs = gettimezonebygmtplusval($lstchars);
	      		$getactual = getdatetimebytimezone(DFLT_TZ,$delivery_datetime,$curtzs);
	      		$delivery_datetime = $getactual['datetime'];
	      		$drop_endtime = $res['drop_dateto']." ".$res['drop_datetotime'];
	      		$drop_endtime = date('Y-m-d H:i:s',strtotime($drop_endtime));
	      		$lstchars = substr($res['drop_datetotime'], -6);
	      		$curtzs = gettimezonebygmtplusval($lstchars);
	      		$getactual = getdatetimebytimezone(DFLT_TZ,$drop_endtime,$curtzs);
	      		$drop_endtime = $getactual['datetime'];
	      		$drop_company = $res['drop_company'];
	      		$drop_address = $res['drop_address'];
	      		$drop_city = $res['drop_city'];
	      		$drop_countrycode = $res['drop_countrycode'];
	      		$drop_postal = $res['drop_postal'];
	      		$drop_address1 = $res['drop_address1'];
	      		$drop_custid = $res['drop_custid'];
	      		$drop_partyid = $res['drop_partyid'];
	      	}
	    }
      	$chkcusttype = "";
      	if(isset($shipdata['freight_term'])){
      		if($shipdata['freight_term'] == "30" || $shipdata['freight_term'] == "31"){
      			$chkcusttype = "CN";
      		} else if($shipdata['freight_term'] == "20"){
      			$chkcusttype = "PF";
      		} else if($shipdata['freight_term'] == "10"){
      			$chkcusttype = "SH";
      		} else if($shipdata['freight_term'] == "60"){
      			$chkcusttype = "PF";
      			if(isset($shipdata['incoterm'])){
      				if($shipdata['incoterm'] == "DAP" || $shipdata['incoterm'] == "DDP"){
      					$chkcusttype = "SH";
      				}else if($shipdata['incoterm'] == "EXW" || $shipdata['incoterm'] == "FCA"){
      					$chkcusttype = "CN";
      				}
      			}
      		}
      	}else{
      		$shipdata['freight_term'] = 60;
      	}
      	$customer_id = 0; $cn_partytype = 3; $sh_partytype = 1; $pf_partytype = 1;
		$consignee = $this->checkconsignee($shipdata['consignee'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
		if($consignee['id'] > 0){
			$customer_id = $consignee['id'];
		}
		if(isset($consignee['party_id'])){ $consignee_id = $consignee['party_id']; $cn_partytype = $consignee['party_type']; }
		$shipper = $this->checkshipper($shipdata['shipper'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
		if($shipper['id'] > 0){
			$customer_id = $shipper['id'];
		}
		if(isset($shipper['party_id'])){ $shipper_id = $shipper['party_id']; $sh_partytype = $shipper['party_type']; }
		if(isset($shipdata['pf'])){
			if(!empty($shipdata['pf'])){
				if($chkcusttype == ""){ $chkcusttype = "PF"; }
				$customer = $this->checkcustomer($shipdata['pf'],$shipdata['sendercmpcode'],$shipdata['senderbranchcode'],$user_id,$chkcusttype);
				if($customer['id'] > 0){
					$customer_id = $customer['id'];
				}
				if(isset($customer['party_id'])){ $cust_id = $customer['party_id']; $pf_partytype = $customer['party_type']; }
			}
		}
		if($customer_id == 0){
			if($shipdata['freight_term'] != "60"){
				$branchwisecust = $this->db->query("SELECT id FROM tb_customers WHERE user_id=$user_id AND company_code='".$company_code."' AND branch_code='".$branch_code."' ORDER BY id ASC LIMIT 1");
				if($branchwisecust->num_rows() > 0){
					$customer_id = $branchwisecust->row()->id;
				}else{
					$randnum = mt_rand();
					$pwd = base64_encode(base64_encode($randnum));
					$cinsdata = array('name'=>$company_code."_Customer", 'phone'=>$randnum, 'location'=>$firsttwochars, 'address'=>$firsttwochars, 'pincode'=>$firsttwochars, 'code'=>$randnum, 'country'=>$firsttwochars, 'password'=>$pwd, 'user_id'=>$user_id,'company_code'=>$company_code, 'branch_code'=>$branch_code, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
					$customer_id = $this->common->insertTableData('tb_customers',$cinsdata);
				}
			}
		}
		$shiptxnid = trim($data['truck']['shipment_id']);
		/*orders table */
        $chechord = $this->db->select("id")->get_where("tb_orders",array("order_id"=>$shipdata['orderid']),1,0);
    	if($chechord->num_rows()>0){
    		$orddata = array('pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address, 'delivery_address1'=>$drop_address, 'pickup_address2'=>$pickup_address1, 'delivery_address2'=>$drop_address1, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$data['truck']['triptype'], 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'customer_name'=>$shipdata['consignee']['name'], 'customer_code'=>$shipdata['consignee']['custid'], 'customer_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'customer_phone'=>$shipdata['consignee']['custid'], 'vendor_name'=>$shipdata['shipper']['name'], 'vendor_code'=>$shipdata['shipper']['custid'], 'vendor_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'vendor_phone'=>$shipdata['shipper']['custid'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'product'=>$shipdata['serviceproduct'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'status'=>2, 'updatedon'=>$curdt,'shipmentid'=>$shiptxnid,'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
    		$ord_id = $chechord->row()->id;
      		$upd = $this->db->where(array("id"=>$ord_id))->update('tb_orders',$orddata);
  		}else{
  			$orddata = array('order_id'=>$shipdata['orderid'], 'pickup_datetime'=>$pickup_datetime, 'pickup_endtime'=>$pickup_endtime, 'delivery_datetime'=>$delivery_datetime, 'drop_endtime'=>$drop_endtime, 'pickup_company'=>$pickup_company, 'delivery_company'=>$drop_company, 'pickup_country'=>$pickup_countrycode, 'delivery_country'=>$drop_countrycode, 'pickup_city'=>$pickup_city, 'delivery_city'=>$drop_city, 'pickup_pincode'=>$pickup_postal, 'delivery_pincode'=>$drop_postal, 'pickup_address1'=>$pickup_address, 'delivery_address1'=>$drop_address, 'pickup_address2'=>$pickup_address1, 'delivery_address2'=>$drop_address1, 'quantity'=>$shipdata['pkgs_count'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'goods_value'=>$shipdata['pkgs_count'], 'transport_mode'=>$transmode, 'dedicated_vehicle'=>$dedicateveh, 'vehicle_type'=>$data['truck']['triptype'], 'user_id'=>$user_id, 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'customer_name'=>$shipdata['consignee']['name'], 'customer_code'=>$shipdata['consignee']['custid'], 'customer_area'=>($shipdata['consignee']['street'].", ".$shipdata['consignee']['city'].", ".$shipdata['consignee']['zip']), 'customer_phone'=>$shipdata['consignee']['custid'], 'vendor_name'=>$shipdata['shipper']['name'], 'vendor_code'=>$shipdata['shipper']['custid'], 'vendor_area'=>($shipdata['shipper']['street'].", ".$shipdata['shipper']['city'].", ".$shipdata['shipper']['zip']), 'vendor_phone'=>$shipdata['shipper']['custid'],'company_code'=>$shipdata['sendercmpcode'],'branch_code'=>$shipdata['senderbranchcode'],'product'=>$shipdata['serviceproduct'],'shipment_id'=>$sship_id, 'pickup_custid'=>$pickup_custid, 'pickup_partyid'=>$pickup_partyid, 'drop_custid'=>$drop_custid, 'drop_partyid'=>$drop_partyid, 'status'=>2, 'createdon'=>$curdt, 'updatedon'=>$curdt,"created_source"=>12,'shipmentid'=>$shiptxnid,'logicalreceiver'=>$data['header']['lreceiver'],'physicalreceiver'=>$data['header']['preceiver'],'physicalsender'=>$data['header']['psender'],'logicalsender'=>$data['header']['lsender'],'modeoftransport'=>$shipdata['sendertransmode']);
      		$ord_id = $this->common->insertTableData('tb_orders',$orddata);
  		}
  		if($ord_id >0){
  			/*cargo details*/
  			$chkarr = array('cargo_type'=>$shipdata['cargo_content'],'weight'=>$shipdata['gross_weight'],'volume'=>$shipdata['volume'],'quantity'=>$shipdata['pkgs_count']);
  			$cargo = array('cargo_type' => $shipdata['cargo_content'], 'goods_description' => $shipdata['cargo_content'], 'quantity' => $shipdata['pkgs_count'], 'length'=>0.00, 'length_unit' => 'Cm', 'width'=>0.00, 'width_unit' => 'Cm', 'height'=>0.00, 'height_unit' => 'Cm', 'weight' => $shipdata['gross_weight'], 'weight_unit' => $shipdata['weight_uom'], 'volume' => $shipdata['volume'], 'volume_unit' => $shipdata['volume_uom'], 'stackable' => 0, 'createdby' => $user_id, 'createdon' => $curdt);
  			$chkcargo = $this->common->gettblrowdata($chkarr,"id","tb_cargo_details",0,0);
  			if(count($chkcargo) == 0){
  				$cargotbl_id = $this->common->insertTableData('tb_cargo_details',$cargo);
  			}else{
  				$cargotbl_id = $chkcargo['id'];
  			}
  			$cargodt = array('order_id'=>$ord_id,'cargo_id'=>$cargotbl_id,'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content']);
  			$chkcargo = $this->db->select("id")->get_where("tb_order_cargodetails",$cargodt);
  			if($chkcargo->num_rows() == 0){
  				$hunit = 1;
  				$chkhandlingunit = $this->db->select("id")->get_where("tbl_shipunit_types",array("user_id"=>$user_id),1,0);
  				if($chkhandlingunit->num_rows()>0){
  					$hunit = $chkhandlingunit->row()->id;
  				}
	  			$cargodata = array('order_id'=>$ord_id, 'cargo_id'=>$cargotbl_id, 'handling_unit'=>$hunit, 'length'=>0.00, 'width'=>0.00, 'height'=>0.00, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content'], 'status'=>1);
	  			$cargo_id = $this->common->insertTableData('tb_order_cargodetails',$cargodata);
	  			$qrcode = $this->generateQRCodes($cargo_id,$cargodata);
	  			/*send mail to customer*/
	  			$custdata = array("cust_id"=>$customer_id,"qr_path"=>$qrcode['qr_path'],"order_id"=>$shipdata['orderid'],'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'quantity'=>$shipdata['pkgs_count'], 'quantity_type'=>$shipdata['pkgs_uom'], 'cargo_content'=>$shipdata['cargo_content']);
	  			$sendQRmail = $this->sendQRmail($custdata);
	  		}
  			if(!empty($shipdata['references'])){
  				foreach($shipdata['references'] as $sref){
  					$chkdt = array('order_id'=>$ord_id, 'reference_id'=>$sref['code'], 'ref_value'=>$sref['value']);
  					$chkref = $this->db->select("id")->get_where("tb_order_references",$chkdt);
  					if($chkref->num_rows() == 0){
	  					$srefqry = array('order_id'=>$ord_id, 'reference_id'=>$sref['code'], 'ref_value'=>$sref['value'], 'status'=>1, 'createdon'=>$curdt);
	  					$srefqryins = $this->common->insertTableData('tb_order_references',$srefqry);
	  					$srefqryins = $this->common->insertTableData('tb_order_references_history',$srefqry);
	  				}
  				}
  			}
  		}
      	if($sship_id > 0){
	    	if(isset($consignee_id)){
	      		$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$consignee_id,'party_type'=>$cn_partytype),1,0);
	      		if($checkparty->num_rows()>0){
	      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$consignee_id,'party_type'=>$cn_partytype, 'status'=>1);
		      		$partyid = $checkparty->row()->id;
		      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
	      		}else{
			      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$consignee_id,'party_type'=>$cn_partytype, 'status'=>1,'createdon'=>$curdt);
			      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
		      	}
	    	}
		    if(isset($shipper_id)){
		    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$shipper_id,'party_type'=>$sh_partytype),1,0);
	      		if($checkparty->num_rows()>0){
	      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$shipper_id,'party_type'=>$sh_partytype, 'status'=>1);
		      		$partyid = $checkparty->row()->id;
		      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
	      		}else{
			      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$shipper_id,'party_type'=>$sh_partytype, 'status'=>1,'createdon'=>$curdt);
			      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
			    }
		    }
		    if(isset($carrier_party_id)){
		    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$carrier_party_id, 'party_type'=>$ca_partytype),1,0);
	      		if($checkparty->num_rows()>0){
	      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$carrier_party_id, 'party_type'=>$ca_partytype, 'status'=>1);
		      		$partyid = $checkparty->row()->id;
		      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
	      		}else{
		      		$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$carrier_party_id, 'party_type'=>$ca_partytype, 'status'=>1,'createdon'=>$curdt);
		      		$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
		      	}
		    }
		    if(isset($cust_id)){
		    	$checkparty = $this->db->select("id")->get_where("tb_order_parties",array('order_id'=>$ord_id,'party_id'=>$cust_id, 'party_type'=>$pf_partytype),1,0);
	      		if($checkparty->num_rows()>0){
	      			$partyarr = array('order_number'=>$shipdata['orderid'],'party_id'=>$cust_id, 'party_type'=>$pf_partytype, 'status'=>1);
		      		$partyid = $checkparty->row()->id;
		      		$upd = $this->db->where(array("id"=>$partyid))->update('tb_order_parties',$partyarr);
	      		}else{
		      	$partyarr = array('order_id'=>$ord_id,'order_number'=>$shipdata['orderid'],'party_id'=>$cust_id, 'party_type'=>$pf_partytype, 'status'=>1,'createdon'=>$curdt);
		      	$ins = $this->common->insertTableData("tb_order_parties",$partyarr);
		      }
		    }
    	}
	/* store in shipment table */
	$startlat = $startlong = $endlat = $endlong = "";
	$sloc = $shipdata['pickdrops'][0]['pickup_address'].", ".$shipdata['pickdrops'][0]['pickup_city'].", ".$shipdata['pickdrops'][0]['pickup_countrycode'].", ".$shipdata['pickdrops'][0]['pickup_postal'];
	$eloc = $shipdata['pickdrops'][1]['drop_address'].", ".$shipdata['pickdrops'][1]['drop_city'].", ".$shipdata['pickdrops'][1]['drop_countrycode'].", ".$shipdata['pickdrops'][1]['drop_postal'];
	$cheklatlng = $this->getlatlongbylocname($sloc);
	if(!empty($cheklatlng)){
		$startlat = $cheklatlng['latitude'];
		$startlong = $cheklatlng['longitude'];
	}
	if($startlat == ""){
		$sloc1 = $shipdata['pickdrops'][0]['pickup_city'].", ".$shipdata['pickdrops'][0]['pickup_countrycode'].", ".$shipdata['pickdrops'][0]['pickup_postal'];
		$cheklatlng = $this->getlatlongbylocname($sloc1);
		if(!empty($cheklatlng)){
			$startlat = $cheklatlng['latitude'];
			$startlong = $cheklatlng['longitude'];
		}
	}
	$cheklatlng1 = $this->getlatlongbylocname($eloc);
	if(!empty($cheklatlng1)){
		$endlat = $cheklatlng1['latitude'];
		$endlong = $cheklatlng1['longitude'];
	}
	if($endlat == ""){
		$eloc1 = $shipdata['pickdrops'][1]['drop_city'].", ".$shipdata['pickdrops'][1]['drop_countrycode'].", ".$shipdata['pickdrops'][1]['drop_postal'];
		$cheklatlng1 = $this->getlatlongbylocname($eloc1);
		if(!empty($cheklatlng1)){
			$endlat = $cheklatlng1['latitude'];
			$endlong = $cheklatlng1['longitude'];
		}
	}
	/*log_message("error",$startlat."-".$startlong."-".$endlat."-".$endlong);*/
	$pickuploc = array('pickup_country'=>$pickup_countrycode,'pickup_city'=>$pickup_city,'pickup_location'=>$pickup_address);
	$droploc = array('drop_country'=>$drop_countrycode,'drop_city'=>$drop_city,'drop_location'=>$drop_address);
	$border_type = getshipbordertype($pickuploc,$droploc);

	$checkshipment = $this->db->select("id")->get_where("tb_shifts",array('shipmentid'=>$shiptxnid),1,0);
	if($checkshipment->num_rows() == 0){
	$shipment = array('user_id'=>$user_id, 'stime'=>date("H:i",strtotime($starttime)), 'etime'=>date("H:i",strtotime($endtime)), 'splace'=>$pickup_company, 'slat'=>$startlat, 'slng'=>$startlong, 'eplace'=>$drop_company, 'elat'=>$endlat, 'elng'=>$endlong, 'scity'=>$pickup_city, 'dcity'=>$drop_city, 'zone_id'=>1, 'empshift_start'=>date("H:i",strtotime($starttime)), 'empshift_end'=>date("H:i",strtotime($endtime)), 'trip_type'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shipment_name'=>$shipdata['cargo_content'], 'shipmentid'=>$shiptxnid, 'shipment_id'=>$shiptxnid, 'customer_id'=>$customer_id, 'transport_mode'=>$transmode, 'vendor_id'=>$carrier_id, 'carrier_type'=>0, 'txnid'=>$data['truck']['ordernum'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'units'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender'], 'vehicle_type'=>$data['truck']['triptype'],'company_code'=>$shipdata['sendercmpcode'], 'branch_code'=>$shipdata['senderbranchcode'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		if($border_type == 1){
		    $shipment['border_type'] = $border_type;
		}
	$ship_id = $this->common->insertTableData("tb_shifts",$shipment);
	}else{
	$shipment = array('user_id'=>$user_id, 'stime'=>date("H:i",strtotime($starttime)), 'etime'=>date("H:i",strtotime($endtime)), 'splace'=>$pickup_company, 'slat'=>$startlat, 'slng'=>$startlong, 'eplace'=>$drop_company, 'elat'=>$endlat, 'elng'=>$endlong, 'scity'=>$pickup_city, 'dcity'=>$drop_city, 'zone_id'=>1, 'empshift_start'=>date("H:i",strtotime($starttime)), 'empshift_end'=>date("H:i",strtotime($endtime)), 'trip_type'=>0, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shipment_name'=>$shipdata['cargo_content'], 'shipment_id'=>$shiptxnid, 'customer_id'=>$customer_id, 'transport_mode'=>$transmode, 'vendor_id'=>$carrier_id, 'carrier_type'=>0, 'txnid'=>$data['truck']['ordernum'], 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'units'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender'], 'vehicle_type'=>$data['truck']['triptype'], 'company_code'=>$shipdata['sendercmpcode'], 'branch_code'=>$shipdata['senderbranchcode'], 'status'=>1, 'updated_on'=>$curdt);
		if($border_type == 1){
		    $shipment['border_type'] = $border_type;
		}
		$ship_id = $checkshipment->row()->id;
		$upd = $this->db->where(array("id"=>$ship_id))->update('tb_shifts',$shipment);
	}
  	/*update order table*/
    $upddt = array("shift_id"=>$ship_id,"plat"=>$startlat,"plng"=>$startlong,"dlat"=>$endlat,"dlng"=>$endlong);
    $updwhr = array("id"=>$ord_id);
    $upd = $this->common->updatetbledata("tb_orders",$upddt,$updwhr);
	$responseord[] = $ship_id;
	/*stop legs*/
	$stop1 = $shipdata['pickdrops'][0]['pickup_company'].", ".$shipdata['pickdrops'][0]['pickup_address'].", ".$shipdata['pickdrops'][0]['pickup_city'].", ".$shipdata['pickdrops'][0]['pickup_countrycode'].", ".$shipdata['pickdrops'][0]['pickup_postal'];
	$chkstoplegs = $this->db->select("id")->get_where("tb_shiporder_stops",array('stopname'=>$shipdata['pickdrops'][0]['pickup_company'], 'stopcity'=>$shipdata['pickdrops'][0]['pickup_city'],'stoptype'=>'P', 'shipment_id'=>$ship_id,'txncode'=>$data['truck']['ordernum']),1,0);
	if($chkstoplegs->num_rows() > 0){
		$shiporder = array('address'=>$stop1, 'plat'=>$startlat, 'plng'=>$startlong, 'stoptype'=>'P', 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'updated_on'=>$curdt);
			$stopleg1_id = $chkstoplegs->row()->id;
	  	$upd = $this->db->where(array("id"=>$stopleg1_id))->update('tb_shiporder_stops',$shiporder);
	}else{
	  	$shiporder = array('stopname'=>$shipdata['pickdrops'][0]['pickup_company'], 'plat'=>$startlat,  'plng'=>$startlong, 'stopcity'=>$shipdata['pickdrops'][0]['pickup_city'], 'address'=>$stop1, 'stoptype'=>'P', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>1, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'shipmentstopid'=>0, 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'txncode'=>$data['truck']['ordernum'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
	 	$stopleg1_id = $this->common->insertTableData("tb_shiporder_stops",$shiporder);
	}
	$stop2 = $shipdata['pickdrops'][1]['drop_company'].", ".$shipdata['pickdrops'][1]['drop_address'].", ".$shipdata['pickdrops'][1]['drop_city'].", ".$shipdata['pickdrops'][1]['drop_countrycode'].", ".$shipdata['pickdrops'][1]['drop_postal'];
	$chkstoplegs = $this->db->select("id")->get_where("tb_shiporder_stops",array('stopname'=>$shipdata['pickdrops'][1]['drop_company'], 'stopcity'=>$shipdata['pickdrops'][1]['drop_city'],'stoptype'=>'D','shipment_id'=>$ship_id, 'txncode'=>$data['truck']['ordernum']),1,0);
	if($chkstoplegs->num_rows() > 0){
		$shiporder = array('address'=>$stop2, 'plat'=>$endlat, 'plng'=>$endlong, 'stoptype'=>'D', 'startdate'=>$delivery_datetime, 'enddate'=>$drop_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'updated_on'=>$curdt);
			$stopleg2_id = $chkstoplegs->row()->id;
	  	$upd = $this->db->where(array("id"=>$stopleg2_id))->update('tb_shiporder_stops',$shiporder);
	}else{
      $shiporder = array('stopname'=>$shipdata['pickdrops'][1]['drop_company'],'plat'=>$endlat, 'plng'=>$endlong, 'stopcity'=>$shipdata['pickdrops'][1]['drop_city'], 'address'=>$stop2, 'stoptype'=>'D', 'stopstatus'=>0, 'shipment_id'=>$ship_id, 'ordernumber'=>2, 'startdate'=>$delivery_datetime, 'enddate'=>$drop_endtime, 'weight'=>$shipdata['gross_weight'], 'volume'=>$shipdata['volume'], 'shipmentstopid'=>0, 'serviceprovider'=>$data['header']['sendapp'], 'ship_units'=>$shipdata['pkgs_count'], 'txncode'=>$data['truck']['ordernum'], 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
      $stopleg2_id = $this->common->insertTableData("tb_shiporder_stops",$shiporder);
  	}
	/*stops*/
	$chkemp = $this->db->select("id")->get_where("tb_employee",array('assoc_id'=>$data['truck']['ordernum'],'order_id'=>$shipdata['orderid'],'shift_id'=>$ship_id,'stop_id'=>$stopleg1_id, 'drop_stopid'=>$stopleg2_id),1,0);
	if($chkemp->num_rows()>0){
		$stops = array('pickup'=>$pickup_company, 'drop'=>$drop_company, 'pickup_city'=>$pickup_city,'plat'=>$startlat, 'plng'=>$startlong, 'drop_city'=>$drop_city, 'dlat'=>$endlat, 'dlng'=>$endlong, 'pickup_datetime'=>$pickup_datetime, 'drop_datetime'=>$delivery_datetime, 'name'=>$shipdata['cargo_content'], 'address'=>$stop1, 'user_id'=>$user_id, 'updatedon'=>$curdt, 'capacity'=>$shipdata['gross_weight'], 'shipment_weight'=>$shipdata['gross_weight'], 'shipment_volume'=>$shipdata['volume'], 'ship_type'=>'P', 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'pkgitemid'=>$shipdata['cargo_content'], 'no_of_pkgs'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender']);
		$stop_id = $chkemp->row()->id;
	$upd = $this->db->where(array("id"=>$stop_id))->update('tb_employee',$stops);
	}else{
		$jk = 1;
	$stops = array('assoc_id'=>$data['truck']['ordernum'], 'pickup'=>$pickup_company,'plat'=>$startlat, 'plng'=>$startlong, 'drop'=>$drop_company,'dlat'=>$endlat, 'dlng'=>$endlong, 'pickup_city'=>$pickup_city, 'drop_city'=>$drop_city, 'pickup_datetime'=>$pickup_datetime, 'drop_datetime'=>$delivery_datetime, 'name'=>$shipdata['cargo_content'], 'phone'=>"", 'address'=>$stop1, 'user_id'=>$user_id, 'password' => RandomString::generate(10),'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'material_id'=>0, 'capacity'=>$shipdata['gross_weight'], 'information'=>"", 'shipment_weight'=>$shipdata['gross_weight'], 'shipment_volume'=>$shipdata['volume'], 'ship_type'=>'P', 'customer_id'=>$customer_id, 'vendor_id'=>$carrier_id, 'shipment_id'=>$sship_id, 'startdate'=>$pickup_datetime, 'enddate'=>$delivery_datetime, 'shift_id'=>$ship_id, 'stop_order'=>$jk, 'drop_order'=>$jk, 'basic_stop'=>1, 'stop_id'=>$stopleg1_id, 'drop_stopid'=>$stopleg2_id, 'order_id'=>$shipdata['orderid'], 'pkgitemid'=>$shipdata['cargo_content'], 'no_of_pkgs'=>$shipdata['pkgs_count'], 'domainname'=>$data['header']['lsender']);
	$stop_id = $this->common->insertTableData("tb_employee",$stops);
	}
     	/*driver info*/
      	$driver_id = 0;
        if(isset($data['driver'])){
	       	if(isset($data['driver']['driverid'])){
	       		$data['driver']['driverid'] = trim($data['driver']['driverid']);
	      		$chk_driver = $this->db->select("id")->get_where("tb_truck_drivers",array("contact_num"=>$data['driver']['driverid']),1,0);
	      		if($chk_driver->num_rows() == 0){
	      			$drifname = isset($data['driver']['firstname']) ? $data['driver']['firstname'] : "SVK";
	      			$drilname = isset($data['driver']['lastname']) ? $data['driver']['lastname'] : "DRIVER";
					$driver = array('name'=>($drifname." ".$drilname), 'password'=>'TVRJek5EVTI=', 'contact_num'=>$data['driver']['driverid'], 'age'=>0, 'driving_since'=>'0', 'driving_licence_num'=>'', 'city'=>$pickup_city, 'createdon'=>$curdt, 'updatedon'=>$curdt, 'createdby'=>$user_id, 'updatedby'=>$user_id, 'user_id'=>$user_id, 'vendor_id'=>$carrier_id, 'status'=>'Active');
					$driver_id = $this->common->insertTableData("tb_truck_drivers",$driver);
				}else{
					$driver_id = $chk_driver->row()->id;
					$upddri = array('name'=>($data['driver']['firstname']." ".$data['driver']['lastname']),'city'=>$pickup_city,'vendor_id'=>$carrier_id);
					$updqry = $this->db->where(array("id"=>$driver_id))->update("tb_truck_drivers",$upddri);
				}
			}
	  	}

	  	$rand = mt_rand(1111111111,9999999999);
  		$vehnum = $data['truck']['veh_number'];
  		$vehtype = $data['truck']['veh_type'];
  		$vehnumchk = $vehicleid = "";

  		if($vehnum != ""){
  			$vehnumchk = $vehnum;
  		}

  		if($vehnumchk != ""){
			$chkveh = $this->db->query("SELECT id,register_number FROM tb_trucks_data WHERE register_number='".$vehnumchk."' LIMIT 1");
  			if($chkveh->num_rows()>0){
  				$vehicleid = $chkveh->row()->id;
  			}else{
  				$ttype1 = $this->db->select("id")->get_where("tb_trucktypes",array("trucktype"=>$vehtype),1,0);
  				if($ttype1->num_rows()>0){
  					$ttype = $ttype1->row()->id;
  				}else{
  					$arrvehtype = array("trucktype"=>$vehtype,"description"=>$vehtype,"company_code"=>$shipdata['sendercmpcode'],"branch_code"=>$shipdata['senderbranchcode'],"status"=>"Active",'createdon'=>$curdt, 'updatedon'=>$curdt);
  					$ttype = $this->common->insertTableData("tb_trucktypes",$arrvehtype);
  				}
  				$arr = array('truck_number'=>$vehnumchk, 'length'=>"100", 'breadth'=>"100", 'truck_capacity'=>"100", 'truck_type'=>$ttype, 'available_type'=>"", 'description'=>"", 'register_number'=>$vehnumchk, 'insurence'=>"Yes", 'insuredby'=>"", 'insurestart'=>'0000-00-00 00:00:00', 'insureexp'=>'0000-00-00 00:00:00', 'route'=>$rand, 'user_id'=>$user_id, 'vendor_id'=>$carrier_id, 'createdby'=>"0", 'updatedby'=>"0", 'status'=>'Active', 'createdon'=>$curdt, 'updatedon'=>$curdt);
  				$vehicleid = $this->common->insertTableData("tb_trucks_data",$arr);
  			}
  		}
  		$shipvehid = "";
  		if($vehicleid != ""){
  			$assignarr = array("carrier_id"=>$carrier_id,"driver_id"=>$driver_id,"vehicleid"=>$vehicleid,"user_id"=>$user_id,"curdt"=>$curdt);
  			$chkvehfun = $this->setvehiclewithin($assignarr);
  			/*assign to carrier*/
  			$veharr = array("user_id"=>$user_id,"shft_id"=>$ship_id,"carrier_id"=>$carrier_id,"vehicle_id"=>$vehicleid);
		  	$chkveh = $this->db->select("id")->get_where("tb_shft_veh",$veharr,1,0);
		  	if($chkveh->num_rows() == 0){
		  		$insveh = array("user_id"=>$user_id,"shft_id"=>$ship_id,"carrier_id"=>$carrier_id,"vehicle_id"=>$vehicleid,"register_number"=>$vehnumchk,"status"=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		  		$shipvehid = $this->common->insertTableData("tb_shft_veh",$insveh);
		  	}else{
		  		$shipvehid = $chkveh->row()->id;
		  		$updveh = array("status"=>1, 'updated_on'=>$curdt);
		  		$upd = $this->db->where($veharr)->update("tb_shft_veh",$updveh);
		  	}
  		}
  		/*else{
  			$vehnumchk = "SVK".mt_rand(22222222,99999999);
  			$assignarr = array("carrier_id"=>$carrier_id,"driver_id"=>$driver_id,"user_id"=>$user_id,"vehnumchk"=>$vehnumchk,"rand"=>$rand,"curdt"=>$curdt);
  			$chkvehfun = $this->setvehiclewithout($assignarr);
  			$vehicleid = $chkvehfun['vehicleid'];
  			$vehnumchk = $chkvehfun['vehnumchk'];
  		}*/
	  	/*assign to priority stops */
	  	if($shipvehid != ""){
		  	$veharr = array("shft_veh_id"=>$shipvehid);
		  	$chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp",$veharr,1,0);
		  	if($chkveh->num_rows() == 0){
		  		$getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
		  		if($getemp->num_rows()>0){
		  			$pri = 1;
		  			foreach($getemp->result() as $gt){
		  				$insveh1 = array("user_id"=>$user_id,"shft_veh_id"=>$shipvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
		  				$ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);
		  				$pri++;
		  			}
		  		}
		  	}else{
		  		$getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee",array("shift_id"=>$ship_id));
		  		if($getemp->num_rows()>0){
		  			$pri = 1;
		  			foreach($getemp->result() as $gt){
		  				$veharr = array("user_id"=>$user_id,"shft_veh_id"=>$shipvehid,"emp_id"=>$gt->id);
					  	$chkveh = $this->db->select("id")->get_where("tb_shft_veh_emp",$veharr,1,0);
					  	if($chkveh->num_rows() == 0){
			  				$insveh1 = array("user_id"=>$user_id,"shft_veh_id"=>$shipvehid,"emp_id"=>$gt->id,"priority"=>$pri,"pickup_time"=>$gt->pickup_datetime, 'created_on'=>$curdt,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
			  				$ins = $this->common->insertTableData("tb_shft_veh_emp",$insveh1);
					  	}else{
					  		$veharr11 = array("id"=>$chkveh->row()->id);
			  				$updveh1 = array("priority"=>$pri,"pickup_time"=>$gt->pickup_datetime,'updated_on'=>$curdt,"status"=>1,"drop_time"=>$gt->drop_datetime);
		  					$upd = $this->db->where($veharr11)->update("tb_shft_veh_emp",$updveh1);
			  			}
			  			$pri++;
		  			}
		  		}
		  	}
		}
	  	/*assign to driver*/
	  	if($vehicleid != "" && $driver_id != 0){
		  	$veharr1 = array("vehicle_id"=>$vehicleid,"driver_id"=>$driver_id);
		  	$updveho = array("vehicle_id"=>$vehicleid);
	  		$updveho1 = array("status"=>0,'updated_on'=>$curdt);
	  		$upd = $this->db->where($updveho1)->update("tbl_assigned_drivers",$updveho);
		  	$chkveh1 = $this->db->select("id")->get_where("tbl_assigned_drivers",$veharr1,1,0);
		  	if($chkveh1->num_rows() == 0){
		  		$insveh1 = array("vehicle_id"=>$vehicleid,"user_id"=>$user_id,"driver_id"=>$driver_id,"from_time"=>$curdt,"to_time"=>$curdt,"status"=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		  		$ins = $this->common->insertTableData("tbl_assigned_drivers",$insveh1);
		  	}else{
		  		$updveh1 = array("status"=>1, 'updated_on'=>$curdt);
		  		$upd = $this->db->where($veharr1)->update("tbl_assigned_drivers",$updveh1);
		  	}
		}
	  	}
	  	}
      	return $responseord;
    }

    function setvehiclewithin($data){
    	$driver_id = $data['driver_id'];
    	$carrier_id = $data['carrier_id'];
    	$vehicleid = $data['vehicleid'];
    	$user_id = $data['user_id'];
    	$curdt = $data['curdt'];
    	$chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vendor_id"=>$carrier_id,"vehicle_id"=>$vehicleid),1,0);
	  	if($chkvveh->num_rows()>0){
	  		$upd = $this->db->where(array("vehicle_id"=>$vehicleid))->update("tb_vendor_vehicles",array("status"=>"0"));
			$upd = $this->db->where(array("id"=>$chkvveh->row()->id))->update("tb_vendor_vehicles",array("status"=>"1"));
  		}else{
  			$arr1 = array('vendor_id'=>$carrier_id, 'vehicle_id'=>$vehicleid, 'status'=>1);
	  		$ins = $this->common->insertTableData("tb_vendor_vehicles",$arr1);
  		}
  		if($driver_id != 0){
	  		$chkdrive = $this->db->select("id,vehicle_id")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicleid,"driver_id"=>$driver_id),1,0);
			if($chkdrive->num_rows()>0){
				$ischk = array("id"=>$chkdrive->row()->id);
				$upd = $this->db->set(array("status"=>1))->where($ischk)->update("tb_vehicles_drivers");
			}else{
				$arr1 = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>"1");
		  		$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr1);
			}
		}
		$response['vehicleid'] = $vehicleid;
  		return $response;
    }

    function setvehiclewithout($data){
    	$driver_id = $data['driver_id'];
    	$carrier_id = $data['carrier_id'];
    	$user_id = $data['user_id'];
    	$vehnumchk = $data['vehnumchk'];
    	$rand = $data['rand'];
    	$curdt = $data['curdt'];
    	$response = array();
    	$chkdrive = $this->db->select("id,vehicle_id")->get_where("tb_vehicles_drivers",array("driver_id"=>$driver_id,"status"=>1),1,0);
  		if($chkdrive->num_rows()>0){
  			$vehicleid = $chkdrive->row()->vehicle_id;
  			$chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vendor_id"=>$carrier_id,"vehicle_id"=>$vehicleid),1,0);
		  	if($chkvveh->num_rows()>0){
				$upd = $this->db->where(array("vehicle_id"=>$vehicleid))->update("tb_vendor_vehicles",array("status"=>"0"));
				$upd = $this->db->where(array("id"=>$chkvveh->row()->id))->update("tb_vendor_vehicles",array("status"=>"1"));
		  	}else{
		  		$arr1 = array('vendor_id'=>$carrier_id, 'vehicle_id'=>$vehicleid, 'status'=>"1");
		  		$ins = $this->common->insertTableData("tb_vendor_vehicles",$arr1);
		  	}
  		}else{
  			$chk = $this->db->query("SELECT id,register_number FROM tb_trucks_data WHERE id NOT IN(SELECT vehicle_id FROM tb_vendor_vehicles WHERE vendor_id=$carrier_id AND status=1 GROUP BY vehicle_id) AND user_id=$user_id AND status='Active' LIMIT 1");
  			if($chk->num_rows()>0){
  				$vehicleid = $chk->row()->id;
  				$vehnumchk = $chk->row()->register_number;
  			}else{
  				$arr = array('truck_number'=>$driver_id, 'length'=>"100", 'breadth'=>"100", 'truck_capacity'=>"100", 'truck_type'=>"1", 'available_type'=>"", 'description'=>"", 'register_number'=>$vehnumchk, 'insurence'=>"Yes", 'insuredby'=>"", 'insurestart'=>'0000-00-00 00:00:00', 'insureexp'=>'0000-00-00 00:00:00', 'route'=>$rand, 'user_id'=>$user_id, 'vendor_id'=>$carrier_id, 'createdby'=>"0", 'updatedby'=>"0", 'status'=>'Active', 'createdon'=>$curdt, 'updatedon'=>$curdt);
  				$vehicleid = $this->common->insertTableData("tb_trucks_data",$arr);
  			}
  			$chkd = $this->db->select("id,driver_id,status")->order_by("status","DESC")->get_where("tb_vehicles_drivers",array("vehicle_id"=>$vehicleid,"driver_id"=>$driver_id));
  			if($chkd->num_rows()>0){
	  			$upd = $this->db->where(array("id"=>$chkd->row()->id))->update("tb_vehicles_drivers",array("status"=>1));
	  		}else{
	  			$arr = array('vehicle_id'=>$vehicleid, 'driver_id'=>$driver_id, 'imei'=>"", 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	  			$ins = $this->common->insertTableData("tb_vehicles_drivers",$arr);
	  		}
	  		$chkvveh = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vendor_id"=>$carrier_id,"vehicle_id"=>$vehicleid),1,0);
		  	if($chkvveh->num_rows()>0){
				/*$upd = $this->db->where(array("vehicle_id"=>$vehicleid))->update("tb_vendor_vehicles",array("status"=>"0"));*/
				$upd = $this->db->where(array("id"=>$chkvveh->row()->id))->update("tb_vendor_vehicles",array("status"=>"1"));
		  	}else{
		  		$chkvveh1 = $this->db->select("id")->get_where("tb_vendor_vehicles",array("vehicle_id"=>$vehicleid),1,0);
		  		if($chkvveh1->num_rows()>0){
		  			$upvh = array('vendor_id'=>$carrier_id, 'vehicle_id'=>$vehicleid, 'status'=>"1");
		  			$upd = $this->db->where(array("id"=>$chkvveh1->row()->id))->update("tb_vendor_vehicles",$upvh);
		  		}else{
			  		$arr1 = array('vendor_id'=>$carrier_id, 'vehicle_id'=>$vehicleid, 'status'=>"1");
			  		$ins = $this->common->insertTableData("tb_vendor_vehicles",$arr1);
			  	}
		  	}
  		}
  		$response['vehicleid'] = $vehicleid;
  		$response['vehnumchk'] = $vehnumchk;
  		return $response;
    }

    function getlatlongbylocname($address){
        $response = getlatlngsbyplace($address);
        return [
            'latitude' => $response[0],
            'longitude' => $response[1]
        ];
    }
    public function checkconsignee($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr1 = array("code"=>$customer['custid']);
	  $cselect = 'id';
	  $curdt = date("Y-m-d H:i:s");
	  $curtz = date_default_timezone_get();
      $getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
	  $curdt = $getactual['datetime'];
      $cust_id = 0;
      if($custtype == "CN"){
	      $ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = base64_encode(base64_encode($randnum));
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd,'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 3;
      $chkpartytype = $this->db->select("id")->get_where("tbl_party_types",array("name"=>"Consignee","user_id"=>$uid,'company_code'=>$cmpcode),1,0);
      if($chkpartytype->num_rows()>0){
      	$cwhr['party_type_id'] = $chkpartytype->row()->id;
      }
      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = base64_encode(base64_encode($randnum));
         $cinsdata = array('party_type_id'=>$cwhr['party_type_id'], 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      $res['party_type'] = $cwhr['party_type_id'];
      return $res;
   }

	public function checkshipper($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr1 = array("code"=>$customer['custid']);
      $cselect = 'id';
      $curdt = date("Y-m-d H:i:s");
	  $curtz = date_default_timezone_get();
      $getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
	  $curdt = $getactual['datetime'];
      $cust_id = 0;
      if($custtype == "SH"){
      	$ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = base64_encode(base64_encode($randnum));
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd, 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 1;
      $chkpartytype = $this->db->select("id")->get_where("tbl_party_types",array("name"=>"Shipper","user_id"=>$uid,'company_code'=>$cmpcode),1,0);
      if($chkpartytype->num_rows()>0){
      	$cwhr['party_type_id'] = $chkpartytype->row()->id;
      }
      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode,'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = base64_encode(base64_encode($randnum));
         $cinsdata = array('party_type_id'=>$cwhr['party_type_id'], 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      $res['party_type'] = $cwhr['party_type_id'];
      return $res;
   }

	public function checkcustomer($customer,$cmpcode,$branchcode,$uid,$custtype){
      $cwhr1 = array("code"=>$customer['custid']);
      $cselect = 'id';
      $curdt = date("Y-m-d H:i:s");
	  $curtz = date_default_timezone_get();
      $getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
	  $curdt = $getactual['datetime'];
      $cust_id = 0;
      if($custtype == "PF"){
	      $ctable = 'tb_customers';
	      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,$ctable,0,0);
	      if(count($chkcust) > 0){
	         $cust_id = $chkcust['id'];
	         $upddata = array('location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updatedon'=>$curdt);
	         $upd = $this->db->where(array("id"=>$cust_id))->update('tb_customers',$upddata);
	      }else{
	         $randnum = $customer['custid'];
	         $pwd = base64_encode(base64_encode($randnum));
	         $cinsdata = array('name'=>$customer['name'], 'phone'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'], 'password'=>$pwd, 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'createdon'=>$curdt, 'updatedon'=>$curdt);
	         $cust_id = $this->common->insertTableData('tb_customers',$cinsdata);
	      }
	  }
      $cwhr['party_type_id'] = 7;
      $chkpartytype = $this->db->select("id")->get_where("tbl_party_types",array("name"=>"FREIGHT_PAYER","user_id"=>$uid,'company_code'=>$cmpcode),1,0);
      if($chkpartytype->num_rows()>0){
      	$cwhr['party_type_id'] = $chkpartytype->row()->id;
      }
      $chkcust = $this->common->gettblrowdata($cwhr1,$cselect,"tbl_party_master",0,0);
      if(count($chkcust) > 0){
         $custid = $chkcust['id'];
         $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
         $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
      }else{
         $randnum = $customer['custid'];
         $pwd = base64_encode(base64_encode($randnum));
         $cinsdata = array('party_type_id'=>$cwhr['party_type_id'], 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
         $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
      }
      $res['id'] = $cust_id;
      $res['party_id'] = $custid;
      $res['party_type'] = $cwhr['party_type_id'];
      return $res;
    }

public function checkcarrier($customer,$cmpcode,$branchcode,$uid){
   	$res = array();
   	$curdt = date("Y-m-d H:i:s");
	$curtz = date_default_timezone_get();
	$getactual = getdatetimebytimezone(DFLT_TZ,$curdt,$curtz);
	$curdt = $getactual['datetime'];
	$cwhr1['party_type_id'] = 2;
	$chkpartytype = $this->db->select("id")->get_where("tbl_party_types",array("name"=>"Carrier","user_id"=>$uid,'company_code'=>$cmpcode),1,0);
	if($chkpartytype->num_rows()>0){
		$cwhr1['party_type_id'] = $chkpartytype->row()->id;
	}
   	if(isset($customer['custid'])){
		$cwhr = array('name'=>$customer['name'],"code"=>$customer['custid']);
		$ctable = 'tb_vendors';
		$cselect = 'id';
		$chkcust = $this->common->gettblrowdata($cwhr,$cselect,$ctable,0,0);
		if(count($chkcust) > 0){
		 $cust_id = $chkcust['id'];
		 $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
		 $upddata = array('location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'],'country'=>$customer['country'], 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'],'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
		 $upd = $this->db->where(array("id"=>$cust_id))->update('tb_vendors',$upddata);
		}else{
		 $randnum = trim($customer['custid']);
		 $randnum = str_replace(" ", "", $randnum);
		 $randnum = str_replace("+", "", $randnum);
		 $randnum = str_replace("-", "", $randnum);
		 $pwd = base64_encode(base64_encode($randnum));
		 $addr = $customer['street'].", ".$customer['street1'].", ".$customer['city'].", ".$customer['country'].", ".$customer['zip'];
		 $cinsdata = array('name'=>$customer['name'], 'mobile'=>$customer['custid'], 'location'=>$customer['city'], 'address'=>$addr, 'pincode'=>$customer['zip'], 'country'=>$customer['country'], 'password'=>$pwd,'email'=>'', 'code'=>$customer['custid'], 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>date('Y-m-d'), 'expiry_date'=>date('Y-m-d'), 'service_id'=>$customer['custid'], 'service_name'=>$customer['partyid'], 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		 $cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
		}
		$chkcust = $this->common->gettblrowdata($cwhr,$cselect,"tbl_party_master",0,0);
		if(count($chkcust) > 0){
		 $custid = $chkcust['id'];
		 $upddata = array('location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'], 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1,'updated_on'=>$curdt);
		 $upd = $this->db->where(array("id"=>$custid))->update('tbl_party_master',$upddata);
		}else{
		 $randnum = trim($customer['custid']);
		 $randnum = str_replace(" ", "", $randnum);
		 $randnum = str_replace("+", "", $randnum);
		 $randnum = str_replace("-", "", $randnum);
		 $pwd = base64_encode(base64_encode($randnum));
		 $cinsdata = array('party_type_id'=>$cwhr1['party_type_id'], 'name'=>$customer['name'], 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$customer['custid'], 'location_id'=>$customer['city'], 'address'=>$customer['street'], 'pincode'=>$customer['zip'], 'code'=>$customer['custid'], 'country'=>$customer['country'],'user_id'=>$uid,'customeridentifier'=>$customer['custid'],'partyindetifier'=>$customer['partyid'],'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		 $custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
		}
	}else{
		$randnum = time();
		$pwd = base64_encode(base64_encode($randnum));
		if(strlen($cmpcode)>2){
			$cntry = substr($cmpcode, 0,2);
		}else{
			$cntry = $cmpcode;
		}
		$addr = $cntry;
		$effctdate = date('Y-m-d');
		$cinsdata = array('name'=>$cntry."_Carrier", 'mobile'=>$randnum, 'location'=>$cntry, 'address'=>$addr, 'pincode'=>$addr, 'country'=>$cntry, 'password'=>$pwd,'email'=>'', 'code'=>$randnum, 'offering_type'=>'FTL', 'carrier_grade'=>'ABC', 'effective_date'=>$effctdate, 'expiry_date'=>$effctdate, 'service_id'=>$randnum, 'service_name'=>"", 'user_id'=>$uid,'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		$cust_id = $this->common->insertTableData('tb_vendors',$cinsdata);
		$cinsdata = array('party_type_id'=>$cwhr1['party_type_id'], 'name'=>$cntry."_Carrier", 'email'=>'svkonekt@kuehne-nagel.com','mobile'=>$randnum, 'location_id'=>$cntry, 'address'=>$addr, 'pincode'=>'1111', 'code'=>$randnum, 'country'=>$cntry,'user_id'=>$uid, 'company_code'=>$cmpcode, 'branch_code'=>$branchcode, 'status'=>1, 'created_on'=>$curdt, 'updated_on'=>$curdt);
		$custid = $this->common->insertTableData('tbl_party_master',$cinsdata);
	}
	$res['id'] = $cust_id;
	$res['party_id'] = $custid;
	$res['party_type'] = $cwhr1['party_type_id'];
	return $res;
}
    //dhanu added
    //generating QR codes and storing as foreigh key with tb_order_cargo_details table id column with tb_order_cargo_qrdetails table order_cargo_details_id
    public function generateQRCodes($cargo_id,$cargodata) {
    	$this->load->library('barcode');
    	$qrid = array();
    	$handling_unit = $cargodata["handling_unit"];
    	$quantity = $cargodata["quantity"];
    	$data = [];
    	$data["order_cargo_details_id"] = $cargo_id;
    	$data["handling_unit"] = $handling_unit;
    	$data["quantity"] = $quantity;
    	$data["path"] = $qrid['qr_path'] = $this->barcode->generate(json_encode(array("cargo_id"=>$handling_unit,"quantity"=>$quantity)));
    	$qrid['id'] = $this->common->insertTableData("tb_order_cargo_qrdetails",$data);
    	return $qrid;
    }

    public function barcode()
    {
        $data["path"]="";
        $this->load->library('barcode');
        if (! empty($_POST["qr_text"])) {
            $data["path"] = $this->barcode->generate($_POST["qr_text"]);
        }
        $this->load->view("barcode",$data);
    }

    public function sendQRmail($cust)
    {
    	$chkcust = $this->db->select("name,email_id")->get_where("tb_customers",array("id"=>$cust['cust_id'],"email_id <>"=>""),1,0);
    	if($chkcust->num_rows()>0){
    		$this->load->library('email');
	        $receivecc   = "external.ram.k@kuehne-nagel.com";
            $receivemail = $chkcust->row()->email_id;
            $receivename = $chkcust->row()->name;
	        $this->email->to($receivemail, $receivename);
	        if ($receivecc != "") {
	            $this->email->cc($receivecc,"RCREDDY");
	        }
	        $data['page_title'] = "QR CODE";
	        $data['receivename'] = $receivename;
	        $data['weight']=isset($cust['gross_weight']) ? $cust['gross_weight'] : 1;
	        $data['volume']=isset($cust['volume']) ? $cust['volume'] : 1;
	        $data['quantity']=isset($cust['pkgs_count']) ? $cust['pkgs_count'] : 1;
	        $data['quantity_type']=isset($cust['pkgs_uom']) ? $cust['pkgs_uom'] : "PCS";
	        $data['cargo_content']=isset($cust['cargo_content']) ? $cust['cargo_content'] : "Boxes";
	        $data['order_id'] = isset($cust['order_id']) ? $cust['order_id'] : "NA";
	        $data['qr_path'] = isset($cust['qr_path']) ? $cust['qr_path'] : "NA";
	        $data['subject'] = "svkonekt :: QR Code for your order cargo";
	        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
	        $this->email->subject($data['subject']);
	        $this->email->set_mailtype('html');
	        $body = $this->load->view('mail_forms/orderqrinfo', $data, true);
	        $this->email->message($body);
	        $send = $this->email->send();
	    }
    }
}
