<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}


class Knops extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->userRole = $this->session->userdata('user_role_id');
        if ($this->userRole !== "5") {
            redirect('home');
        }
        $this->companyCode = $this->session->userdata('company_code');
        $this->branchCode = $this->session->userdata('branch_code');
        $this->departmentCode = $this->session->userdata('department_code');
        $this->timeZone = $this->session->userdata("usr_tzone")['timezone'];
        $this->userIds = $this->session->userdata('userIds');
        $this->userId = $this->session->userdata('user_id');
        $this->childId = $this->session->userdata('childId');
        $this->usersWithDepartmentCodes = $this->session->userdata('usersWithDepartmentCodes');
        $this->load->library("knopsmassstatuslibrary");
        $this->load->model(["knopstripsmodel", "orderrevenuesmodel"]);
    }

    public function index()
    {
        echo "<pre>";
        print_r($this->session->userdata());
        echo "Kn Ops";
    }

    public function massstatus()
    {
        $config = [];
        $data['page_title'] = $this->lang->line('menu_massstsupd');
        $data['sub_title'] = $this->lang->line('general_search');
        $post = $this->input->post(null, true);
        $finalTripsData = $this->knopsmassstatuslibrary->getNormalTripsForKnOps($post, $this->session->userdata);
        $ordersData = $finalTripsData['ordersData'];
        $orderIds = $finalTripsData['orderIds'];
        $shiftIds = $finalTripsData['finalTripsData']['shiftIds'];
        $tripDetails = $finalTripsData['finalTripsData']['tripDetails'];
        if (!empty($shiftIds)) {
            $totalCount = count($ordersData);
            $config["base_url"] = base_url() . "Knops/massstatus";
            $config["total_rows"] = $totalCount;
            $config["per_page"] = 10;
            $config["uri_segment"] = 3;
            $config['display_pages'] = true;
            $this->pagination->initialize($config);
            $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
            if ($page == "01") {
                $page = 0;
            }
            $idsToDisplay = $this->knopstripsmodel->getTripsBasedOnOrderId($orderIds, $shiftIds, $config['per_page'], $page);
            foreach ($idsToDisplay as $eachLine) {
                $ordersWithShift[$eachLine['orderRowId']] = $eachLine['shiftRowId'];
                $finalShiftIds[] = $eachLine['shiftRowId'];
            }
            $tripsDetails = $this->knopsmassstatuslibrary->getStopsStatusAndArrangeFinalArray(['shiftIds' => $finalShiftIds ?? [], 'ordersData' => $ordersData, 'tripDetails' => $tripDetails, 'orderIds' => $ordersWithShift ?? []]);
        }
        $data['postdata'] = $post;
        $data['timeZone'] = $this->timeZone;
        $data['tripsdata'] = $tripsDetails ?? [];
        $data['companyCode'] = $this->companyCode;
        $this->newtemplate->dashboard("knops/massstatuspage", $data);
    }

    public function ordersWhereConditions(array $input): string
    {
        $whereCondition = "";
        $bookingId = $input['bookingid'] ?? [];
        $pickup = $input['pickup'] ?? "";
        $delivery = $input['drop'] ?? "";
        $fromDate = $input['fromdate_search'] ?? "";
        $toDate = $input['todate_search'] ?? "";
        $references = $input['reference'] ?? [];
        $orderTypes = $input['order_type'] ?? [];
        if (!empty($bookingId)) {
            $finalBookingIds = implode("','", $bookingId);
            $whereCondition .= " AND o.order_id IN('" . $finalBookingIds . "')";
        }
        if ($pickup != "") {
            $whereCondition .= " AND (o.pickup_country LIKE '%" . $pickup . "%' OR o.pickup_city LIKE '%" . $pickup . "%') ";
        }
        if ($delivery != "") {
            $whereCondition .= " AND (o.delivery_country LIKE '%" . $delivery . "%' OR o.delivery_city LIKE '%" . $delivery . "%') ";
        }
        if ($fromDate != "") {
            $getactual = getdatetimebytimezone(DFLT_TZ, $fromDate, $this->timeZone);
            $fromDate = $getactual['date'];
            $whereCondition .= " AND DATE(o.pickup_datetime)>='" . $fromDate . "' ";
        }
        if ($toDate != "") {
            $getactual = getdatetimebytimezone(DFLT_TZ, $toDate, $this->timeZone);
            $toDate = $getactual['date'];
            $whereCondition .= " AND DATE(o.delivery_datetime)<='" . $toDate . "' ";
        }
        $getords = [];
        if (!empty($references)) {
            $getords = $this->getOrdersbyReferenceValue($references);
        }
        if (!empty($orderTypes)) {
            $ordtye = implode("','", $orderTypes);
            $getords1 = $this->getOrdersbyOTReference("OT", $ordtye);
            if (!empty($getords1)) {
                $getords = array_merge($getords, $getords1);
            }
        }
        if (!empty($getords)) {
            $gords = implode("','", $getords);
            $whereCondition .= " AND o.id IN('$gords') ";
        }
        return $whereCondition;
    }

    private function getOrdersbyOTReference($refnum, $refval)
    {
        $userCondition = $this->generateUserWhereCondition(1);
        if (!empty($refval)) {
            $query = $this->orderrevenuesmodel->getordersbyref("r.reference_id='" . $refnum . "' AND r.ref_value IN('" . $refval . "') AND r.status=1" . $userCondition);
            $result = $query->num_rows() > 0 ? $query->result_array() : [];
            foreach ($result as $eachLine) {
                $response[] = $eachLine['order_id'];
            }
        }
        return $response ?? [];
    }

    private function getOrdersbyReferenceValue($references)
    {
        $whereCondition = $this->generateUserWhereCondition(1);
        if (!empty($references)) {
            $query = $this->orderrevenuesmodel->getordersbyref("r.status = 1 AND r.ref_value IN ('" . implode("','", $references) . "')" . $whereCondition);
            $result = $query->num_rows() > 0 ? $query->result_array() : [];
            foreach ($result as $eachRow) {
                $response[] = $eachRow['order_id'];
            }
        }
        return $response ?? [];
    }

    private function generateUserWhereCondition($checkCondition = 0): string
    {
        $whereCondition = "";
        $userIdsWithoutDepartmentCode = [];
        if ($this->childId > 0) {
            if (!empty($this->usersWithoutDepartment)) {
                $whereCondition = $this->generateMutlipleUsersWhereCondition($this->usersWithoutDepartment, $whereCondition);
            }
            if (!empty($this->usersWithDepartmentCodes)) {
                if ($checkCondition > 0) {
                    foreach ($this->usersWithDepartmentCodes as $eachLine) {
                        $userIdsWithoutDepartmentCode[] = ['companyCode' => $eachLine['companyCode'], 'branchCode' => $eachLine['brancCode']];
                    }
                    $whereCondition = $this->generateMutlipleUsersWhereCondition($userIdsWithoutDepartmentCode ?? [], $whereCondition);
                } else {
                    $whereCondition = $this->generateMutlipleUsersWhereCondition($this->usersWithDepartmentCodes, $whereCondition);
                }
            }
        } else {
            $whereCondition .= " AND o.company_code = '" . $this->companyCode . "' AND o.branch_code ='" . $this->branchCode . "' ";
            if ($this->departmentCode != "" && $checkCondition == 0) {
                $whereCondition .= " AND d.department_code = '" . $this->departmentCode . "' ";
            }
        }
        return $whereCondition;
    }

    private function generateMutlipleUsersWhereCondition(array $data, string $whereCondition): string
    {
        $i = 1;
        $arrayCount = count($data);
        foreach ($data as $eachLine) {
            $departmentCode = $eachLine['departmentCode'] ?? "";
            if ($i > 1) {
                $whereCondition .= " OR (o.company_code ='" . $eachLine['companyCode'] . "' AND o.branch_code ='" . $eachLine['branchCode'] . "' ";
            } else {
                $whereCondition .= " AND ( (o.company_code ='" . $eachLine['companyCode'] . "' AND o.branch_code ='" . $eachLine['branchCode'] . "' ";
            }
            if ($departmentCode != "") {
                $whereCondition .= " AND d.department_code = '" . $departmentCode . "' )";
            } else {
                $whereCondition .= " ) ";
            }
            if ($arrayCount === $i) {
                $whereCondition .= " ) ";
            }
            $i++;
        }
        return $whereCondition;
    }

    public function doneOrders()
    {
        $data['page_title'] = $this->lang->line('menu_completed');
        $data['sub_title'] = $this->lang->line('menu_completed') . " " . $this->lang->line('bookings');
        $data['pageType'] = 'done';
        $data['ord_type'] = "";
        $data['orders'] = [];
        $whereCondition = $this->generateUserWhereCondition();
        $input = $this->input->post(null, true);
        if (!empty($input)) {
            $whereCondition .= $this->ordersWhereConditions($input);
        }
        $data['postData'] = $input;
        $data['companyCode'] = $this->companyCode;
        $data['userTimeZone'] = $this->timeZone;
        $completedOrders = $this->knopstripsmodel->getCompletedOrdersData($whereCondition, $this->timeZone);
        $pageCount = count($completedOrders);
        $config = [];
        $config["base_url"] = base_url() . "knops/doneOrders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        $perPage = $page + $config["per_page"];
        for ($page; $page < $perPage; $page++) {
            $orderRowId = $completedOrders[$page]['id'] ?? 0;
            if ($orderRowId === 0) {
                break;
            }
            $data['orders'][] = $completedOrders[$page] ?? [];
        }

        $this->newtemplate->dashboard('knops/orderspage', $data);
    }

    public function activeOrders()
    {
        $data['page_title'] = $this->lang->line('menu_active');
        $data['sub_title'] = $this->lang->line('menu_active') . " " . $this->lang->line('bookings');
        $data['pageType'] = 'active';
        $data['ord_type'] = "";
        $data['orders'] = [];
        $whereCondition = $this->generateUserWhereCondition();
        $input = $this->input->post(null, true);
        if (!empty($input)) {
            $whereCondition .= $this->ordersWhereConditions($input);
        }
        $data['postData'] = $input;
        $data['companyCode'] = $this->companyCode;
        $data['userTimeZone'] = $this->timeZone;
        $activeOrders = $this->knopstripsmodel->getActiveOrdersData($whereCondition, $this->timeZone);
        $pageCount = count($activeOrders);
        $config = [];
        $config["base_url"] = base_url() . "knops/activeOrders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        $perPage = $page + $config["per_page"];
        for ($page; $page < $perPage; $page++) {
            $orderRowId = $activeOrders[$page]['id'] ?? 0;
            if ($orderRowId === 0) {
                break;
            }
            $data['orders'][] = $activeOrders[$page] ?? [];
        }

        $this->newtemplate->dashboard('knops/orderspage', $data);
    }

    public function pendingOrders()
    {
        $data['page_title'] = $this->lang->line('menu_pending');
        $data['sub_title'] = $this->lang->line('menu_pending') . " " . $this->lang->line('bookings');
        $data['pageType'] = 'pending';
        $data['ord_type'] = "";
        $data['orders'] = [];
        $whereCondition = $this->generateUserWhereCondition();
        $input = $this->input->post(null, true);
        if (!empty($input)) {
            $whereCondition .= $this->ordersWhereConditions($input);
        }
        $data['postData'] = $input;
        $data['companyCode'] = $this->companyCode;
        $data['userTimeZone'] = $this->timeZone;
        $pendingOrders = $this->knopstripsmodel->getPendingOrdersData($whereCondition, $this->timeZone);
        $pageCount = count($pendingOrders);
        $config = [];
        $config["base_url"] = base_url() . "knops/pendingOrders";
        $config["total_rows"] = $pageCount;
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $config['display_pages'] = true;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? (int)$this->uri->segment(3) : 0;
        $perPage = $page + $config["per_page"];
        for ($page; $page < $perPage; $page++) {
            $orderRowId = $pendingOrders[$page]['id'] ?? 0;
            if ($orderRowId === 0) {
                break;
            }
            $data['orders'][] = $pendingOrders[$page] ?? [];
        }

        $this->newtemplate->dashboard('knops/orderspage', $data);
    }

    public function getreferencesDatsinfo(string $type)
    {
        $data = [];
        $input = $this->input->post(null, true);
        $whereCondition = $this->generateUserWhereCondition();
        $searchTerm = $input['searchTerm'] ?? "";
        if ($searchTerm != "") {
            $whereCondition .= " AND r.ref_value LIKE '%" . $this->db->escape_str($searchTerm) . "%'";
        }
        $queryResult = $this->knopstripsmodel->getReferencesDataInfoForAllOrders($whereCondition, $type);
        foreach ($queryResult as $ores) {
            $data[] = ["id" => $ores['ref_value'], "text" => $ores['ref_value']];
        }
        echo json_encode($data);
    }

    public function getbookingDetails($type)
    {
        $whereCondition = $this->generateUserWhereCondition();
        $data = [];
        $input = $this->input->post(null, true);
        $searchTerm = $input['searchTerm'] ?? "";
        if ($searchTerm != "") {
            $whereCondition .= " AND o.order_id LIKE '%" . $this->db->escape_str($searchTerm) . "%' ";
        }
        $queryResult = $this->knopstripsmodel->getAllBookingDetails($whereCondition, $type);
        foreach ($queryResult as $ores) {
            $data[] = ["id" => $ores['order_id'], "text" => $ores['order_id']];
        }
        echo json_encode($data);
    }

}

?>
