<?php

defined('BASEPATH') or exit('No direct script access allowed');
error_reporting(0);

class Knratecalendar extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        $this->load->model("ratecalendermodel");
        if (!checkUrlAccessForUser('KNRATECALENDAR')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index() {

        $data["page_title"] = "Rate Calender";
        $data["sub_title"] = $this->lang->line('general_search');
        $data["services"] = array();
        $select = '`id`,`calendar_id`,`name`,`company_code`,`branch_code`,`status`';

        $where['company_code'] = $this->session->userdata('company_code');
        $where['branch_code'] = $this->session->userdata('branch_code');
        $where['user_id'] = $this->session->userdata('user_id');
        $where['status'] = 1;

        if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == 'search') {

            $from_date = $this->input->post('from_date');
            if ($from_date != '') {
                $from_date = date('Y-m-d', strtotime($from_date));
            }
            $to_date = $this->input->post('to_date');
            if ($to_date != '') {
                $to_date = date('Y-m-d', strtotime($to_date));
            }
            $calendar_id = $this->input->post('calendar_id');

            if ($calendar_id != '') {
                $this->db->like('calendar_id', $calendar_id);
            }
            if (!($from_date == '' && $to_date == '')) {
                if (!($from_date != '' && $to_date != '')) {
                    $date_ = ($from_date == '') ? $to_date : $from_date;
                    $this->db->where(array('date(createdon)' => $date_));
                }
            }
            if ($from_date != '' && $to_date != '') {
                $this->db->where("date(`createdon`) BETWEEN '$from_date' AND '$to_date'");
            }
            $this->db->where($where);
            $this->db->from('tb_calendar_data');
            $data['calendar_data'] = $this->db->get()->result_array();
//            log_message('error', $this->db->last_query());
        } else if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "adv_search") {

//            log_message('error','error at adv search..');
            $from_date = $this->input->post('from_date');
            if ($from_date != '') {
                $from_date = date('Y-m-d', strtotime($from_date));
            }

            $to_date = $this->input->post('to_date');
            if ($to_date != '') {
                $to_date = date('Y-m-d', strtotime($to_date));
            }

            $calendar_id = $this->input->post('calendar_id');
            if ($calendar_id != '') {
                $this->db->like('calendar_id', $calendar_id);
            }

            if (!($from_date == '' && $to_date == '')) {
                if (!($from_date != '' && $to_date != '')) {
                    $date_ = ($from_date == '') ? $to_date : $from_date;
                    $this->db->where(array('date(createdon)' => $date_));
                }
            }

            if ($from_date != '' && $to_date != '') {
                $this->db->where("date(`createdon`) BETWEEN '$from_date' AND '$to_date'");
            }

            $company_code = $this->input->post('company_code');
            if ($company_code != '') {
                $this->db->like('company_code', $company_code);
                unset($where['company_code']);
            }

            $calendar_name = $this->input->post('calendar_name');
            if ($calendar_name != '') {
                $this->db->like('name', $calendar_name);
            }
            $this->db->where($where);

            $this->db->from('tb_calendar_data');
            $data['calendar_data'] = $this->db->get()->result_array();
//            log_message('error', $this->db->last_query());
        } else {
            $data['calendar_data'] = $this->ratecalendermodel->get_table_data($select, 'tb_calendar_data', $where);
        }
        $this->newtemplate->dashboard("knratecalendar/index", $data);
    }

    public function add() {
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $data['user_id'] = $this->session->userdata('user_id');

        $data["page_title"] = "Rate Calender";
        $data["sub_title"] = $this->lang->line('general_add');
        $data['calendar_id'] = $this->generate_rate_calandar_id();
        //$this->newtemplate->dashboard("knratecalendar/add", $data);
        $this->load->view("knratecalendar/add", $data);
    }

    function add_general_info() {
        $user_id = $this->session->userdata('user_id');
        $data['user_id'] = $this->session->userdata('user_id');

//        $data['company_code'] = $this->session->userdata('company_code');
//        $data['branch_code'] = $this->session->userdata('branch_code');

        $data['company_code'] = $this->input->post('company_code');
        $data['branch_code'] = $this->input->post('branch_code');

        $data['name'] = $this->input->post("name");
        $bill_type = $this->input->post("bill_type");
        $data['bill_type'] = $bill_type;
        $data['description'] = $this->input->post("description");
        $data['apply_type'] = $this->input->post("apply_type");

        $calendar_id = $this->input->post("calendar_id");
        if ($this->ratecalendermodel->record_exist_or_not(array('calendar_id'), 'tb_calendar_data', array('calendar_id' => $calendar_id))) {
            $calendar_id = $this->generate_rate_calandar_id();
//            echo $calendar_id;
        }
        $data['calendar_id'] = $calendar_id;


        // 1 -both, 2-day calculation,3-Holiday
        if ($bill_type == 2) {
            if (!$this->day_calculation_records_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under day calculation section "));
                return;
            }
        }
        if ($bill_type == 3) {
            if (!$this->holidays_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under holidays section."));
                return;
            }
        }

        if ($bill_type == 1) {
            if (!$this->day_calculation_records_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under day calculation section"));
                return;
            }

            if (!$this->holidays_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under holidays section."));
                return;
            }
        }

        if ($this->common->insertTableData('tb_calendar_data', $data)) {

            $calendar_id = $this->db->insert_id();

            /*
             *      Add Daily Caluculation Tab
             */
            $monday = $this->input->post('monday');
            $this->day_calculation_insert($monday, $calendar_id, $user_id);

            $tuesday = $this->input->post('tuesday');
            $this->day_calculation_insert($tuesday, $calendar_id, $user_id);

            $wednesday = $this->input->post('wednesday');
            $this->day_calculation_insert($wednesday, $calendar_id, $user_id);

            $thursday = $this->input->post('thursday');
            $this->day_calculation_insert($thursday, $calendar_id, $user_id);

            $friday = $this->input->post('friday');
            $this->day_calculation_insert($friday, $calendar_id, $user_id);

            $saturday = $this->input->post('saturday');
            $this->day_calculation_insert($saturday, $calendar_id, $user_id);

            $sunday = $this->input->post('sunday');
            $this->day_calculation_insert($sunday, $calendar_id, $user_id);

            /*
             *      Add holidays
             */
            $holiday_date = $this->input->post('holiday_date');
            $absolute = $this->input->post('absolute');
            $currency = $this->input->post('currency');
            $margin = $this->input->post('margin');
            $holidays_data = array();
            if (sizeof($holiday_date) > 0) {
                $count = sizeof($holiday_date);
                for ($k = 0; $k < $count; $k++) {
                    $holiday = $holiday_date[$k];
                    $abs = $absolute[$k];
                    $curr = $currency[$k];
                    $marg = $margin[$k];
                    if ($holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                        $holidays_data[] = array(
                            'rate_cal_id' => $calendar_id,
                            'holiday_date' => $holiday,
                            'asolute' => $abs,
                            'currency' => $curr,
                            'margin_percent' => $marg,
                            'user_id' => $user_id
                        );
                    }
                }
            }
            if (sizeof($holidays_data) > 0) {
                $this->ratecalendermodel->insert_batch_records('tb_ratecal_holidays', $holidays_data);
            }
            echo json_encode(array("status" => 1, "message" => "General information added successfully"));
            return;
        } else {
            echo json_encode(array("status" => 1, "message" => "Oops something went wrong please try again."));
            return;
        }
    }

    function edit_general_info($id) {

        $data['company_code'] = $this->input->post('company_code');
        $data['branch_code'] = $this->input->post('branch_code');

        // from session
//        $data['branch_code'] = $this->session->userdata('branch_code');
//        $data['company_code'] = $this->session->userdata('company_code');

        $user_id = $this->session->userdata('user_id');
        $data['user_id'] = $user_id;

        $data['name'] = $this->input->post("name");
        $bill_type = $this->input->post("bill_type");
        $data['bill_type'] = $bill_type;
        $data['description'] = $this->input->post("description");
        $data['status'] = $this->input->post("status");
        $data['apply_type'] = $this->input->post("apply_type");


        // 1 -both, 2-day calculation,3-Holiday
        if ($bill_type == 2) {
            if (!$this->day_calculation_update_records_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under day calculation section "));
                return;
            }
        }
        if ($bill_type == 3) {
            if (!$this->holidays_update_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under holidays section."));
                return;
            }
        }

        if ($bill_type == 1) {
            if (!$this->day_calculation_update_records_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under day calculation section"));
                return;
            }

            if (!$this->holidays_update_count()) {
                echo json_encode(array("status" => 0, "message" => "Please enter valid data under holidays section."));
                return;
            }
        }


        $this->common->updatetbledata('tb_calendar_data', $data, array('id' => $id));

        $rate_cal_id = $this->input->post('rate_cal_id');
        if (!is_numeric($rate_cal_id)) {
            echo json_encode(array("status" => 1, "message" => "Please enter valid data."));
            return;
        }

        /*
         *      update/Insert Daily Caluculation Tab
         */
        $monday = $this->input->post('monday');
        $this->day_calculation_update($monday, $rate_cal_id, $user_id);

        $tuesday = $this->input->post('tuesday');
        $this->day_calculation_update($tuesday, $rate_cal_id, $user_id);

        $wednesday = $this->input->post('wednesday');
        $this->day_calculation_update($wednesday, $rate_cal_id, $user_id);

        $thursday = $this->input->post('thursday');
        $this->day_calculation_update($thursday, $rate_cal_id, $user_id);

        $friday = $this->input->post('friday');
        $this->day_calculation_update($friday, $rate_cal_id, $user_id);

        $saturday = $this->input->post('saturday');
        $this->day_calculation_update($saturday, $rate_cal_id, $user_id);

        $sunday = $this->input->post('sunday');
        $this->day_calculation_update($sunday, $rate_cal_id, $user_id);

        /*
         *      update/insert holidays
         */
        $holiday_date = $this->input->post('holiday_date');
        $absolute = $this->input->post('absolute');
        $currency = $this->input->post('currency');
        $margin = $this->input->post('margin');
        $holiday_ids = $this->input->post('holiday_ids');
        if (sizeof($holiday_date) > 0) {
            $count = sizeof($holiday_date);
            for ($k = 0; $k < $count; $k++) {
                $holiday_id = $holiday_ids[$k];
                $holiday = $holiday_date[$k];
                $abs = $absolute[$k];
                $curr = $currency[$k];
                $marg = $margin[$k];
                if (is_numeric($rate_cal_id) && is_numeric($holiday_id) && $holiday_id > 0 && $holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                    // update
                    $holidays_data = array(
                        'holiday_date' => $holiday,
                        'asolute' => $abs,
                        'currency' => $curr,
                        'margin_percent' => $marg,
                        'user_id' => $user_id
                    );
                    $where = array('id' => $holiday_id, 'rate_cal_id' => $rate_cal_id);
                    $this->common->updatetbledata('tb_ratecal_holidays', $holidays_data, $where);
                } else {
                    if (is_numeric($holiday_id) && $holiday_id > 0) {
                        $holidays_data = array(
                            'status' => 0
                        );
                        $where = array('id' => $holiday_id, 'rate_cal_id' => $rate_cal_id);
                        $this->common->updatetbledata('tb_ratecal_holidays', $holidays_data, $where);
                    } else {
                        // insert
                        if ($holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                            $holidays_data1 = array(
                                'rate_cal_id' => $rate_cal_id,
                                'holiday_date' => $holiday,
                                'asolute' => $abs,
                                'currency' => $curr,
                                'margin_percent' => $marg,
                                'user_id' => $user_id
                            );
                            $this->common->insertTableData('tb_ratecal_holidays', $holidays_data1);
                        }
                    }
                }
            }
        }

        echo json_encode(array("status" => 1, "message" => "Records updated successfully"));
        return;
    }

    public function edit($id) {
        if (is_numeric($id) && $id > 0) {
            $data['id'] = $id;
            $data["page_title"] = "Rate Calender";
            $data["sub_title"] = $this->lang->line('general_edit');
            $data["services"] = array();
            $select = '`id`,`calendar_id`,`name`,`bill_type`,`apply_type`,`description`,`company_code`,`branch_code`,`status`';

            $where['company_code'] = $this->session->userdata('company_code');
            $where['branch_code'] = $this->session->userdata('branch_code');
            $where['user_id'] = $this->session->userdata('user_id');
            $where['id'] = $id;
            $calendar_data = $this->common->gettblrowdata($where, $select, 'tb_calendar_data', '1', '1');
            if (sizeof($calendar_data) > 0) {
                $data['calendar_data'] = $calendar_data;
            } else {
                redirect('Knratecalendar/index');
            }

            //$this->newtemplate->dashboard("knratecalendar/edit", $data);
            $this->load->view("knratecalendar/edit", $data);
    
        } else {
            show_error('Please provide valid data.');
        }
    }

    function generate_rate_calandar_id() {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $country = $this->session->userdata('usr_tzone')['country'];
        $date = date('Y-m-d');
        $query = "SELECT IFNULL(COUNT(*),0) AS records_count FROM `tb_calendar_data` WHERE DATE(createdon)='$date' ";
        $result = $this->db->query($query)->row_array();
        if (isset($result['records_count'])) {
            $records_count = $result['records_count'] + 1;
            if (strlen($records_count) == "1") {
                $records_count = "00" . $records_count;
            }
            if (strlen($records_count) == "2") {
                $records_count = "0" . $records_count;
            }
            return 'CL' . $country . substr(date('Y'), 2) . date('m') . $records_count;
        }
    }

    function day_calculation_insert($day, $calendar_id, $user_id) {
        if (sizeof($day) > 0) {
            $day_as_chunk = array_chunk($day, 6);
            $table_data = array();
            foreach ($day_as_chunk as $key => $record) {
                $day_name = $record[0];
                $daystart_time = $record[1];
                $dayend_time = $record[2];
                $abs_value = $record[3];
                $currency = $record[4];
                $percent_value = $record[5];
                $rate_cal_id = $calendar_id;
                if ($day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                    $table_data[] = array("day_name" => $day_name, "daystart_time" => $daystart_time, "dayend_time" => $dayend_time,
                        "abs_value" => $abs_value, "currency" => $currency, "percent_value" => $percent_value, "rate_cal_id" => $rate_cal_id,
                        "user_id" => $user_id
                    );
                }
            }
            if (sizeof($table_data) > 0) {
                // insert tb_ratecal_calculates..
                $this->ratecalendermodel->insert_batch_records('tb_ratecal_calculates', $table_data);
            }
        }
    }

    function get_holidays_list() {
        $id = $this->input->post('id');
        if (is_numeric($id) && $id > 0) {
            $rows = array();
            $select = array('id', 'holiday_date', 'asolute', 'currency', 'margin_percent');
            $table = 'tb_ratecal_holidays';
            $where = array('rate_cal_id' => $id, 'status' => 1);
            $rows[] = $this->ratecalendermodel->get_table_data_with_orderby($select, $table, $where, 'id');
            if (sizeof($rows) > 0) {
                echo json_encode(array('status' => '1', "response_body" => $rows));
            } else {
                echo json_encode(array('status' => '0'));
            }
        }
    }

    function day_calculation_update($day, $rate_cal_id, $user_id) {
        if (sizeof($day) > 0) {
            $table = '';
            $day_as_chunk = array_chunk($day, 7);

            foreach ($day_as_chunk as $key => $record) {
                $id = $record[0];
                $day_name = $record[1];
                $daystart_time = $record[2];
                $dayend_time = $record[3];
                $abs_value = $record[4];
                $currency = $record[5];
                $percent_value = $record[6];
                if (is_numeric($rate_cal_id) && is_numeric($id) && $id > 0 && $day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                    // update block
                    $updatearray = array(
                        "abs_value" => $abs_value, "currency" => $currency, "percent_value" => $percent_value, "user_id" => $user_id
                    );
                    $where = array('id' => $id, 'rate_cal_id' => $rate_cal_id);
                    $this->common->updatetbledata('tb_ratecal_calculates', $updatearray, $where);
                } else {
                    if (is_numeric($id) && $id > 0) {
                        // make record status=0
                        $updatearray = array(
                            "status" => 0
                        );

                        $where = array('id' => $id, 'rate_cal_id' => $rate_cal_id);
                        $this->common->updatetbledata('tb_ratecal_calculates', $updatearray, $where);
                    } else if (is_numeric($id) && $id == 0) {
                        // Insert if not exist
                        if ($day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                            $table_data = array("day_name" => $day_name, "daystart_time" => $daystart_time, "dayend_time" => $dayend_time,
                                "abs_value" => $abs_value, "currency" => $currency, "percent_value" => $percent_value, "rate_cal_id" => $rate_cal_id,
                                "user_id" => $user_id
                            );
                            $this->common->insertTableData('tb_ratecal_calculates', $table_data);
                        }
                    }
                }
            }
        }
    }

    function delete_holiday() {
        $id = $this->input->post('id');
        $rate_cal_id = $this->input->post('rate_cal_id');
        $row = $this->common->gettblrowdata(array('id' => $rate_cal_id), array('bill_type'), 'tb_calendar_data', 1, 1);
        $bill_type = $row['bill_type'];

        if ($bill_type == 1) {
            // both
        }
        if ($bill_type == 2) {
            // Day Calculation
            if (is_numeric($id) && $id > 0 && is_numeric($rate_cal_id) && $rate_cal_id > 0) {
                $this->common->updatetbledata('tb_ratecal_holidays', array('status' => 0), array('rate_cal_id' => $rate_cal_id, 'id' => $id));
                echo json_encode(array('status' => '1', 'message' => 'Holiday has been deleted successfully'));
            } else {
                echo json_encode(array('status' => '0', 'message' => 'Holiday deletion failed'));
            }
        }

        if ($bill_type == 3 || $bill_type == 1) {
            $rows = $this->ratecalendermodel->get_record_count(array('id'), 'tb_ratecal_holidays', array('status' => '1', 'rate_cal_id' => $rate_cal_id));
            if ($rows > 1) {
                if (is_numeric($id) && $id > 0 && is_numeric($rate_cal_id) && $rate_cal_id > 0) {
                    $this->common->updatetbledata('tb_ratecal_holidays', array('status' => 0), array('rate_cal_id' => $rate_cal_id, 'id' => $id));
                    echo json_encode(array('status' => '1', 'message' => 'Holiday has been deleted successfully'));
                } else {
                    echo json_encode(array('status' => '0', 'message' => 'Holiday deletion failed'));
                }
            } else {
                echo json_encode(array('status' => '0', 'message' => 'Based on bill type atleast one record must in holidays section'));
            }
        }
    }

    public function view($id) {
        if (is_numeric($id) && $id > 0) {
            $data['id'] = $id;
            $data["page_title"] = "Rate Calender";
            $data["sub_title"] = $this->lang->line('general_view');
            $data["services"] = array();
            $select = '`id`,`calendar_id`,`name`,`bill_type`,`apply_type`,`description`,`company_code`,`branch_code`,`status`';

            $where['company_code'] = $this->session->userdata('company_code');
            $where['branch_code'] = $this->session->userdata('branch_code');
            $where['user_id'] = $this->session->userdata('user_id');
            $where['id'] = $id;
            $data['calendar_data'] = $this->common->gettblrowdata($where, $select, 'tb_calendar_data', '1', '1');
            //$this->newtemplate->dashboard("knratecalendar/view", $data);
            $this->load->view("knratecalendar/view", $data);
        } else {
            show_error('Please provide valid data.');
        }
    }

    function delete_customer_data() {
        $id = $this->input->post('id');
        if (is_numeric($id) && $id > 0) {
            $this->common->updatetbledata('tb_calendar_data', array('status' => 0), array('id' => $id));
            echo json_encode(array('status' => '1', 'message' => 'Calendar record has been deleted successfully'));
        } else {
            echo json_encode(array('status' => '0', 'message' => 'Calendar record deletion failed'));
        }
    }

    function save_holiday() {
//        log_message('error', json_encode($_POST));
        if (!(isset($_POST['holiday_ids']) && isset($_POST['holiday_date']) && isset($_POST['absolute']) && isset($_POST['currency']) && isset($_POST['margin']) )) {
            return;
        }
        $holiday_ids = $this->input->post('holiday_ids');
        if ($holiday_ids[0] != 0) {
            echo json_encode(array('status_code' => '200', "message" => "Holiday record added successfully."));
            return;
        }
        $holiday_date = $this->input->post('holiday_date');
        if ($holiday_date[0] == '') {
            echo json_encode(array('status_code' => '422', "message" => "Please select valid holiday date"));
            return;
        }

        $absolute = $this->input->post('absolute');
        if (!(is_numeric($absolute[0]) && $absolute[0] > 0)) {
            echo json_encode(array('status_code' => '422', "message" => "Please enter valid absolute"));
            return;
        }
        $currency = $this->input->post('currency');
        if (trim($currency[0]) == 'CURR') {
            echo json_encode(array('status_code' => '422', "message" => "Please select valid currency"));
            return;
        }
        $margin = $this->input->post('margin');
        if (!(is_numeric($margin[0]) && $margin[0] > 0)) {
            echo json_encode(array('status_code' => '422', "message" => "Please enter valid margin"));
            return;
        }

        $rate_cal_id = $this->input->post('rate_cal_id');
        $holiday_ids = $this->input->post('holiday_ids');
        $user_id = $this->session->userdata('user_id');
        if (sizeof($holiday_date) > 0) {
            $count = sizeof($holiday_date);
            for ($k = 0; $k < $count; $k++) {
                $holiday_id = $holiday_ids[$k];
                $holiday = $holiday_date[$k];
                $abs = $absolute[$k];
                $curr = $currency[$k];
                $marg = $margin[$k];
                if (is_numeric($rate_cal_id) && $rate_cal_id > 0 && is_numeric($holiday_id) && $holiday_id == 0 && $holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                    // update
                    $holidays_data = array(
                        'rate_cal_id' => $rate_cal_id,
                        'holiday_date' => $holiday,
                        'asolute' => $abs,
                        'currency' => $curr,
                        'margin_percent' => $marg,
                        'user_id' => $user_id
                    );
                    if ($this->common->insertTableData('tb_ratecal_holidays', $holidays_data)) {
                        echo json_encode(array('status_code' => '200', "message" => "Holiday record added successfully."));
                        return;
                    } else {
                        echo json_encode(array('status_code' => '412', "message" => "Holiday record adding failed."));
                        return;
                    }
                } else {
                    echo json_encode(array('status_code' => '412', "message" => "Holiday record adding failed."));
                    return;
                }
            }
        }
    }

    function day_calculation_records_count() {
        $monday = $this->input->post('monday');
        if ($this->day_calculation_array_cal($monday)) {
            return TRUE;
        }

        $tuesday = $this->input->post('tuesday');
        if ($this->day_calculation_array_cal($tuesday)) {
            return TRUE;
        }
        $wednesday = $this->input->post('wednesday');
        if ($this->day_calculation_array_cal($wednesday)) {
            return TRUE;
        }
        $thursday = $this->input->post('thursday');
        if ($this->day_calculation_array_cal($thursday)) {
            return TRUE;
        }
        $friday = $this->input->post('friday');
        if ($this->day_calculation_array_cal($friday)) {
            return TRUE;
        }

        $saturday = $this->input->post('saturday');
        if ($this->day_calculation_array_cal($saturday)) {
            return TRUE;
        }
        $sunday = $this->input->post('sunday');
        if ($this->day_calculation_array_cal($sunday)) {
            return TRUE;
        }

        return FALSE;
    }

    function day_calculation_array_cal($day) {
        if (sizeof($day) > 0) {
            $day_as_chunk = array_chunk($day, 6);
            $table_data = array();
            foreach ($day_as_chunk as $key => $record) {
                $day_name = $record[0];
                $daystart_time = $record[1];
                $dayend_time = $record[2];
                $abs_value = $record[3];
                $currency = $record[4];
                $percent_value = $record[5];
                if ($day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                    $table_data[] = array("day_name" => $day_name);
                }
            }
            if (sizeof($table_data) > 0) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    function holidays_count() {
        $holiday_date = $this->input->post('holiday_date');
        $absolute = $this->input->post('absolute');
        $currency = $this->input->post('currency');
        $margin = $this->input->post('margin');
        $holidays_data = array();
        if (sizeof($holiday_date) > 0) {
            $count = sizeof($holiday_date);
            for ($k = 0; $k < $count; $k++) {
                $holiday = $holiday_date[$k];
                $abs = $absolute[$k];
                $curr = $currency[$k];
                $marg = $margin[$k];
                if ($holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                    $holidays_data[] = array('holiday_date' => $holiday, 'asolute' => $abs);
                }
            }
        }
        if (sizeof($holidays_data) > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function day_calculation_update_records_count() {
        $monday = $this->input->post('monday');
        if ($this->day_calculation_update_array_cal($monday)) {
            return TRUE;
        }

        $tuesday = $this->input->post('tuesday');
        if ($this->day_calculation_update_array_cal($tuesday)) {
            return TRUE;
        }
        $wednesday = $this->input->post('wednesday');
        if ($this->day_calculation_update_array_cal($wednesday)) {
            return TRUE;
        }
        $thursday = $this->input->post('thursday');
        if ($this->day_calculation_update_array_cal($thursday)) {
            return TRUE;
        }
        $friday = $this->input->post('friday');
        if ($this->day_calculation_update_array_cal($friday)) {
            return TRUE;
        }

        $saturday = $this->input->post('saturday');
        if ($this->day_calculation_update_array_cal($saturday)) {
            return TRUE;
        }
        $sunday = $this->input->post('sunday');
        if ($this->day_calculation_update_array_cal($sunday)) {
            return TRUE;
        }

        return FALSE;
    }

    function day_calculation_update_array_cal($day) {
        if (sizeof($day) > 0) {
            $updatearray = array();
            $table = '';
            $day_as_chunk = array_chunk($day, 7);

            foreach ($day_as_chunk as $key => $record) {
                $id = $record[0];
                $day_name = $record[1];
                $daystart_time = $record[2];
                $dayend_time = $record[3];
                $abs_value = $record[4];
                $currency = $record[5];
                $percent_value = $record[6];
                if (is_numeric($id) && $id > 0 && $day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                    // update block
                    $updatearray[] = array(
                        "abs_value" => $abs_value, "currency" => $currency, "percent_value" => $percent_value
                    );
                } else {
                    if (is_numeric($id) && $id == 0) {
                        // Insert if not exist
                        if ($day_name != "" && $daystart_time != "" && $dayend_time != "" && is_numeric($abs_value) && $currency != "" && $currency != 'CURR' && is_numeric($percent_value)) {
                            $updatearray[] = array("day_name" => $day_name, "daystart_time" => $daystart_time, "dayend_time" => $dayend_time,
                                "abs_value" => $abs_value, "currency" => $currency, "percent_value" => $percent_value
                            );
                        }
                    }
                }
            }
            if (sizeof($updatearray) > 0) {
                return TRUE;
            } else {
                return FALSE;
            }
        }
    }

    function holidays_update_count() {
        $holiday_date = $this->input->post('holiday_date');
        $absolute = $this->input->post('absolute');
        $currency = $this->input->post('currency');
        $margin = $this->input->post('margin');
        $holiday_ids = $this->input->post('holiday_ids');
        $holidays_data = array();
        if (sizeof($holiday_date) > 0) {
            $count = sizeof($holiday_date);
            for ($k = 0; $k < $count; $k++) {
                $holiday_id = $holiday_ids[$k];
                $holiday = $holiday_date[$k];
                $abs = $absolute[$k];
                $curr = $currency[$k];
                $marg = $margin[$k];
                if (is_numeric($holiday_id) && $holiday_id > 0 && $holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                    // update
                    $holidays_data[] = array(
                        'holiday_date' => $holiday,
                        'asolute' => $abs,
                        'currency' => $curr,
                        'margin_percent' => $marg
                    );
                } else {
                    // insert
                    if ($holiday != "" && is_numeric($abs) && $curr != "" && $curr != 'CURR' && is_numeric($marg)) {
                        $holidays_data[] = array(
                            'holiday_date' => $holiday,
                            'asolute' => $abs,
                            'currency' => $curr,
                            'margin_percent' => $marg
                        );
                    }
                }
            }
        }
        if (sizeof($holidays_data) > 0) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

}
