<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Knrateservice extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if ($this->session->userdata('user_id') == "") {
            redirect("login");
        }
        $this->load->model("common");
        if (!checkUrlAccessForUser('KNRATESERVICE')) {
            redirect("Forbiddenaccess");
        }
    }

    public function index()
    {
        $data = array();
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $data["page_title"] = $this->lang->line('Knrateservice');
        $data["sub_title"] = $this->lang->line('general_search');
        $data["services"] = array();
        $post = $this->input->post(NULL,TRUE);
        if($company_code == "RUKN"){
             $wher = array(
                'rs.status' => 1,'rs.company_code'=>$company_code
            );
        }else{
             $wher = array(
                'rs.status' => 1,'rs.user_id'=>$user_id
            );
        }

        $whr = array();
        if (! empty($post)) {
            extract($post);
            if (isset($company_code) && $company_code != "") {
                $whr['rs.company_code'] = $company_code;
            }
            if (isset($branch_code) && $branch_code != "") {
                $whr['rs.branch_code'] = $branch_code;
            }
            if (isset($service_name) && $service_name != "") {
                $whr['rs.service_name'] = $service_name;
            }
            if (isset($service_id) && $service_id != "") {
                $whr['rs.service_id'] = $service_id;
            }

            if (isset($from_date) && $from_date != "") {
                $fromdate1 = date('Y-m-d', strtotime($from_date));
                $wher["DATE_FORMAT(rs.createdon,'%Y-%m-%d') >="] = $fromdate1;
            }
            if (isset($to_date) && $to_date != "") {
                $todate1 = date('Y-m-d', strtotime($to_date));
                $wher["DATE_FORMAT(rs.createdon,'%Y-%m-%d') <="] = $todate1;
            }
        }

        $data["services"] = $this->getservicetabl($wher, $whr);

        $this->newtemplate->dashboard("knrateservices/index", $data);
    }
 /* Rate service Add */
    public function add()
    {
        $company_code = $this->session->userdata('company_code');
        $branch_code = $this->session->userdata('branch_code');
        $user_id = $this->session->userdata('user_id');
        $data['company_code'] = $company_code;
        $data['branch_code'] = $branch_code;
        $data['user_id'] = $user_id;
        $data["page_title"] = $this->lang->line('Knrateservice');
        $data["sub_title"] = $this->lang->line('general_add');
        $where = array('status' => 1 );
        $table = "tb_service_master";
        $data['service'] = $this->common->gettbldata($where, 'id,name', $table, 0, 0);
        $data['geo'] = $this->common->gettbldata($where, 'id,name', 'tb_geo_master', 0, 0);
        $where1 = array('status' => 1,'company_code'=>$company_code);
        $data['cal'] = $this->common->gettbldata($where1, 'id,name,calendar_id', 'tb_calendar_data', 0, 0);
        $data['lane'] = $this->common->gettbldata(array('status' => 1,'company_code'=>$company_code), 'id,lane_id,lane_name', ' tb_lanes_master', 0, 0);
        //$this->newtemplate->dashboard("knrateservices/add", $data);
        $this->load->view("knrateservices/add", $data);
    }

    public function serviceinsert()
    {
        $data = array();
        $ids = array();
        ;
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');

        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $companycode = isset($company_code) ? $company_code : "";
        $branchcode = isset($branch_code) ? $branch_code : "";
        $servicename= isset($service_name) ? $service_name : "";
        $desc = isset($desc) ? $desc : "";
        $servicetype = isset($service_type) ? $service_type : 0;
        $product1 = isset($product) ? $product : "";
		if($servicetype==""){$servicetype=0; }
        $ser_id = $this->seridgen();
		if($ser_id==""){$ser_id=0; }
        $service1 = array(
            'service_id' => $ser_id,
            'service_name' => $servicename,
            'service_type' => $servicetype,
            'description' => $desc,
            'company_code' => $companycode,
            'branch_code' => $branchcode,
            'product' => $product1,
            'user_id' => $user_id,
            'status' => '1'
        );
        $result = $this->common->insertTableData("tb_rate_services", $service1);
        if ($result) {
            $ids = isset($rate_lane_id) ? $rate_lane_id : "";
            if ($ids != "") {
                $ids1 = explode(',', $ids);
                for ($i = 0; $i < count($ids1); $i ++) {
                    $data1 = array('rate_id' => $result ?? null );
                    $table = 'tb_rateservice_lanes';
                    $whr = array('id' => $ids1[$i]);
                    $result1 = $this->common->updatetbledata($table, $data1, $whr);
                }
            } else {}
            $this->session->set_flashdata('success_msgi', 'New Record Inserted Successfully !!');
        } else {
            $this->session->set_flashdata('error_msgi', "An error occurred while inserting data.");
        }
        redirect('Knrateservice');
    }

    public function serviceupdate()
    {
        $data = array();
        $ids = array();
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $id = $service_rate_id;
        $companycode = isset($company_code) ? $company_code : "";
        $branchcode = isset($branch_code) ? $branch_code : "";
        $servicename = isset($service_name) ? $service_name : "";
        $desc1 = isset($desc) ? $desc : "";
        $servicetype = isset($service_type) ? $service_type : 0;
		 $product1 = isset($product) ? $product : "";
		if($servicetype==""){$servicetype=0; }
        $service1 = array(
            'service_name' => $servicename,
            'service_type' => $servicetype,
            'description' => $desc1,
            'company_code' => $companycode,
            'branch_code' => $branchcode,
			'product' => $product1,
            'user_id' => $user_id,
            'status' => '1'
        );
        $result = $this->common->updatetbledata("tb_rate_services", $service1, array(
            'id' => $id
        ));

        redirect('Knrateservice');
    }

    public function seridgen()
    {
        $year = date('y');
        $week = date('W');
        $lane_res = $this->db->query("SELECT service_id FROM tb_rate_services ORDER BY id DESC LIMIT 1");
        if ($lane_res->num_rows() > 0) {
            $get_lane_id = $lane_res->row()->service_id;
            $get_lane_id_c = strlen($get_lane_id);
            if ($get_lane_id_c > 7) {

                $previous_weeknumber = substr($get_lane_id, 4, 2);
                $get_lane_id1 = substr($get_lane_id, 6);
                $get_lane_id2 = ltrim($get_lane_id1, 0);
                if ($previous_weeknumber < $week) {
                    $id1 = '0001';
                } else {
                    $i_id = $get_lane_id2;
                    $i_id ++;
                    $idlength = strlen($i_id);
                    if ($idlength == '1') {
                        $id1 = "000" . $i_id;
                    } else if ($idlength == '2') {
                        $id1 = "00" . $i_id;
                    } else if ($idlength == '3') {
                        $id1 = "0" . $i_id;
                    } else if ($idlength == '4') {
                        $id1 = $i_id;
                    } else {
                        $id1 = $i_id;
                    }
                }
            } else {
                $id1 = '0001';
            }

            $ser_id = "RS" . $year . $week . $id1;
            $chk = $this->db->query("select service_id FROM tb_rate_services WHERE service_id='" . $ser_id . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $ser_id = "RS" . $year . $week . $ii_d;
            } else {
                $ser_id = $ser_id;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $ser_id = "RS" . $year . $week . $id1;
        }
        return $ser_id;
    }

    /* Edit Services */
    public function edit($id)
    {
         $company_code = $this->session->userdata('company_code');
        $data["page_title"] = $this->lang->line('Knrateservice');
        $data["sub_title"] = $this->lang->line('general_edit');
        $user_id = $this->session->userdata('user_id');
        $chk = $this->db->query("SELECT rs.*,sm.name FROM tb_rate_services rs inner join tb_service_master sm on rs.service_type=sm.id where rs.status=1 and rs.id='$id' ORDER BY rs.id DESC");
        $data["services"] = $chk->row_array();
        $where = array('status' => 1 );
        $table = "tb_service_master";
        $data['service'] = $this->common->gettbldata($where, 'id,name', $table, 0, 0);
        $data['geo'] = $this->common->gettbldata($where, 'id,name', 'tb_geo_master', 0, 0);
        $where1 = array('status' => 1,'company_code'=>$company_code);
        $data['cal'] = $this->common->gettbldata($where1, 'id,name,calendar_id', 'tb_calendar_data', 0, 0);
        $data['lane'] = $this->common->gettbldata(array('status' => 1,'company_code'=>$company_code), 'id,lane_id,lane_name', ' tb_lanes_master', 0, 0);
        //$this->newtemplate->dashboard("knrateservices/edit", $data);
        $this->load->view("knrateservices/edit", $data);
    }

    public function view($id)
    {
        $data["page_title"] = $this->lang->line('Knrateservice');
        $data["sub_title"] = $this->lang->line('general_view');
        $user_id = $this->session->userdata('user_id');
        $chk = $this->db->query("SELECT rs.*,sm.name FROM tb_rate_services rs inner join tb_service_master sm on rs.service_type=sm.id where rs.status=1 and rs.id='$id' ORDER BY rs.id DESC");
        $data["services"] = $chk->row_array();
        //$this->newtemplate->dashboard("knrateservices/view", $data);
        $this->load->view("knrateservices/view", $data);
    }

    public function editlanedetails()
    {
        $user_id = $this->session->userdata('user_id');
        $data = array();
        $id = $this->input->post('id');
        $qry = $this->db->query("SELECT sl.*,lm.lane_id as lane_ido,lm.lane_name,lm.source_geo,lm.source,lm.destination_geo,lm.destination FROM tb_rateservice_lanes sl INNER JOIN tb_lanes_master lm ON  sl.lane_id=lm.id  WHERE sl.rate_id='$id' AND sl.status='1' ORDER BY sl.id DESC");

        if ($qry->num_rows() > 0) {
            $source_geo = "";
            $destination_geo = "";
            $calendar_name = "";
            foreach ($qry->result() as $res) {
                $chk_s = $this->db->select('name')->get_where('tb_geo_master', array(
                    'id' => $res->source_geo
                ));
                if ($chk_s->num_rows() > 0) {
                    $source_geo = $chk_s->row()->name;
                }
                $chk_d = $this->db->select('name')->get_where('tb_geo_master', array(
                    'id' => $res->destination_geo
                ));
                if ($chk_d->num_rows() > 0) {
                    $destination_geo = $chk_d->row()->name;
                }
                $chk_c = $this->db->select('name')->get_where('tb_calendar_data', array(
                    'id' => $res->calendar_id
                ));

                if ($chk_c->num_rows() > 0) {
                    $calendar_name = $chk_c->row()->name;
                }
                $info = array('id'=>$res->id,'laneid'=>$res->lane_ido,'lane_name'=> htmlentities($res->lane_name ,ENT_QUOTES),'sor_geo'=>$res->source_geo,'sor'=>htmlentities($res->source, ENT_QUOTES),'desc_geo'=>$res->destination_geo,'desc'=>htmlentities($res->destination, ENT_QUOTES),'cal'=>$res->calendar_id,'day'=>$res->rs_lane_days,'hour'=>$res->rs_lane_hours,'min'=>$res->rs_lane_mins);
                $info = htmlentities(json_encode($info));
                $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu ' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowlaneEdit(this," . $info . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletelanedetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Lane Details</a></li>";
                 $data[] = array(
                     'lane_id' => $res->lane_ido,
                     'id' => $res->id,
                     'lane_name' => htmlentities($res->lane_name, ENT_QUOTES),
                     'source_geo' => $source_geo,
                     'source' => htmlentities($res->source, ENT_QUOTES),
                     'destination_geo' => $destination_geo,
                     'destination' => htmlentities($res->destination, ENT_QUOTES),
                     'rs_lane_days' => $res->rs_lane_days,
                     'rs_lane_hours' => $res->rs_lane_hours,
                     'rs_lane_mins' => $res->rs_lane_mins,
                     'calendar_id' => $calendar_name,
                     'action' => $action
                 );
            }
        }

        echo json_encode($data);
    }
/* lane table save  add page*/
    public function savelane()
    {
        $data = array();
        $user_id = $this->session->userdata('user_id');
         $company_code = $this->session->userdata('company_code');
        $lane_get_id = "";

        $post = $this->input->post(NULL,TRUE);
        extract($post);

        if ($lane_id == "") {
            $lane = array(
                'source_geo' => $src_geo,
                'source' => $source,
                'destination_geo' => $des_geo,
                'destination' => $destination,
                'user_id'=>$user_id,
                'lane_name'=>$lane_name,
                'company_code'=>$company_code,
                'status' => '1'
            );
            $res = $this->db->select('id')->get_where('tb_lanes_master', $lane);
            if ($res->num_rows() > 0) {
                $lane_get_id = $res->row()->id;
            } else {

                $lane_id2 = $this->laneidgen();
                $lane1 = array(
                    'lane_id' => $lane_id2,
                    'lane_name' => isset($lane_name) ? $lane_name : "",
                    'source_geo' => isset($src_geo) ? $src_geo : "",
                    'source' => isset($source) ? $source : "",
                    'destination_geo' => isset($des_geo) ? $des_geo : "",
                    'destination' => isset($destination) ? $destination : "",
                    'status' => 1,
                    'company_code' =>  $company_code,
                    'user_id' => $user_id
                );
                // isset($charge_type) ? $charge_type : " ",
                $this->db->insert("tb_lanes_master", $lane1);
                $lane_get_id = $this->db->insert_id();
            }
        } else {
            $lane_get_id = $lane_id;
        }
        $calender1=isset($calendar) ? $calendar : 0;
        if($calender1 == ""){ $calender1 = 0; }
        $ser_day=isset($ser_day) ? $ser_day : 0;
        if($ser_day == ""){ $ser_day = 0; }
        $ser_hours=isset($ser_hours) ? $ser_hours : 0;
        if($ser_hours == ""){ $ser_hours = 0; }
        $ser_min=isset($ser_min) ? $ser_min : 0;
        if($ser_min == ""){ $ser_min = 0; }
        $lane_h_d = array(
            'rate_id' => 0,
            'lane_id' => $lane_get_id,
            'calendar_id' => $calender1,
            'rs_lane_days' => $ser_day,
            'rs_lane_hours' => $ser_hours,
            'rs_lane_mins' => $ser_min,
            'status' => 1,
            'user_id' => $user_id
        );
        $this->db->insert("tb_rateservice_lanes", $lane_h_d);
        $lane_get_id1 = "";
        $lane_get_id1 = $this->db->insert_id();
        $data = array(
            'lane_ser_id' => $lane_get_id1
        );

        echo json_encode($data);
    }
/* lane table save  edit  page*/
    public function editsavelane($id)
    {
        $data = array();
        $user_id = $this->session->userdata('user_id');
        $company_code = $this->session->userdata('company_code');
        $lane_get_id = "";

        $post = $this->input->post(NULL,TRUE);
        extract($post);

        if ($lane_id == "") {
            $lane = array(
                'source_geo' => $src_geo,
                'source' => $source,
                'destination_geo' => $des_geo,
                'destination' => $destination,
                'user_id'=>$user_id,
                'lane_name'=>$lane_name,
                'company_code'=>$company_code,
                'status' => '1'
            );
            $res = $this->db->select('id')->get_where('tb_lanes_master', $lane);
            if ($res->num_rows() > 0) {
                $lane_get_id = $res->row()->id;
            } else {

                $lane_id2 = $this->laneidgen();
                $lane1 = array(
                    'lane_id' => $lane_id2,
                    'lane_name' => isset($lane_name) ? $lane_name : "",
                    'source_geo' => isset($src_geo) ? $src_geo : "",
                    'source' => isset($source) ? $source : "",
                    'destination_geo' => isset($des_geo) ? $des_geo : "",
                    'destination' => isset($destination) ? $destination : "",
                    'status' => 1,
                    'company_code' => $company_code,
                    'user_id' => $user_id
                );
                // isset($charge_type) ? $charge_type : " ",
                $this->db->insert("tb_lanes_master", $lane1);
                $lane_get_id = $this->db->insert_id();
            }
        } else {
            $lane_get_id = $lane_id;
        }
        $calender1=isset($calendar) ? $calendar : 0;
        if($calender1 == ""){ $calender1 = 0; }
        $ser_day=isset($ser_day) ? $ser_day : 0;
        if($ser_day == ""){ $ser_day = 0; }
        $ser_hours=isset($ser_hours) ? $ser_hours : 0;
        if($ser_hours == ""){ $ser_hours = 0; }
        $ser_min=isset($ser_min) ? $ser_min : 0;
        if($ser_min == ""){ $ser_min = 0; }
        $lane_h_d = array(
            'rate_id' => $id ?? null,
            'lane_id' => $lane_get_id,
            'calendar_id' => $calender1,
            'rs_lane_days' => $ser_day,
            'rs_lane_hours' => $ser_hours,
            'rs_lane_mins' => $ser_min,
            'status' => 1,
            'user_id' => $user_id
        );
        $this->db->insert("tb_rateservice_lanes", $lane_h_d);
        $lane_get_id1 = "";
        $lane_get_id1 = $this->db->insert_id();
        $data = array(
            'lane_ser_id' => $lane_get_id1
        );

        echo json_encode($data);
    }
/* lane Id  function*/
    public function laneidgen()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $lane_res = $this->db->query("SELECT lane_id FROM tb_lanes_master ORDER BY id DESC LIMIT 1");
        if ($lane_res->num_rows() > 0) {
            $get_lane_id = $lane_res->row()->lane_id;
            $get_lane_id_c = strlen($get_lane_id);
            $previous_weeknumber = substr($get_lane_id, 6, 2);
            $get_lane_id1 = substr($get_lane_id, 8);
            $get_lane_id2 = ltrim($get_lane_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_lane_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $lane_id1 = "LN" . $country_code . $year . $week . $id1;
            $chk = $this->db->query("select lane_id FROM tb_lanes_master WHERE lane_id='" . $lane_id1 . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $lane_id1 = "LN" . $country_code . $year . $week . $ii_d;
            } else {
                $lane_id1 = $lane_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $lane_id1 = "LN" . $country_code . $year . $week . $id1;
        }
        return $lane_id1;

    }
/* lane table Update  ADD & Edit  page*/
    function update($id)
    {
        $company_code = $this->session->userdata('company_code');
        $user_id = $this->session->userdata('user_id');
        $post = $this->input->post(NULL,TRUE);
        extract($post);
        $calender1=isset($calendar) ? $calendar : 0;
        if($calender1 == ""){ $calender1 = 0; }
        $ser_day=isset($ser_day) ? $ser_day : 0;
        if($ser_day == ""){ $ser_day = 0; }
        $ser_hours=isset($ser_hours) ? $ser_hours : 0;
        if($ser_hours == ""){ $ser_hours = 0; }
        $ser_min=isset($ser_min) ? $ser_min : 0;
        if($ser_min == ""){ $ser_min = 0; }
        $lane_h_d = array(
            'calendar_id' => $calender1,
            'rs_lane_days' => $ser_day,
            'rs_lane_hours' => $ser_hours,
            'rs_lane_mins' => $ser_min,
            'user_id' => $user_id
        );
        $lane_h_d['updatedon'] = date('Y-m-d H:i:s');
        $result = $this->common->updatetbledata('tb_rateservice_lanes', $lane_h_d, array(
            'id' => $id
        ));
        $l_id = $this->common->gettblrowdata(array(
            'id' => $id
        ), 'lane_id', 'tb_rateservice_lanes', 0, 0);

        if ($l_id) {
            $lane1 = array(
                'lane_name' => isset($lane_name) ? $lane_name : "",
                'source_geo' => isset($src_geo) ? $src_geo : "",
                'source' => isset($source) ? $source : "",
                'destination_geo' => isset($des_geo) ? $des_geo : "",
                'destination' => isset($destination) ? $destination : "",
                'status' => 1,
                'company_code' => $company_code,
                'user_id' => $user_id
            );
            $lane1['updated_on'] = date('Y-m-d H:i:s');
            $result1 = $this->common->updatetbledata('tb_lanes_master', $lane1, array(
                'id' => $l_id['lane_id']
            ));
            $data = array(
                'lane_ser_id' => $id
            );
        }
        echo json_encode($data);
    }
    
    public function showlanedetails()
    {
        $user_id = $this->session->userdata('user_id');

        $ids = isset($_POST['lane_ids']) ? $_POST['lane_ids'] : "";
        $data = array();
        if ($ids != "") {
            $lane_ids = implode(',', $ids);
            if (! empty($lane_ids)) {
                $qry = $this->db->query("SELECT sl.*,lm.lane_id as lane_ido,lm.lane_name, lm.source_geo,lm.source,lm.destination_geo,lm.destination FROM tb_rateservice_lanes sl INNER JOIN tb_lanes_master lm ON  sl.lane_id=lm.id  WHERE sl.id IN(" . $lane_ids . ") AND sl.status='1' GROUP BY sl.id ORDER BY sl.id DESC");

                if ($qry->num_rows() > 0) {
                    $source_geo = "";
                    $destination_geo = "";
                    $calendar_name = "";
                    foreach ($qry->result() as $res) {
                        $chk_s = $this->db->select('name')->get_where('tb_geo_master', array(
                            'id' => $res->source_geo
                        ));
                        if ($chk_s->num_rows() > 0) {
                            $source_geo = $chk_s->row()->name;
                        }
                        $chk_d = $this->db->select('name')->get_where('tb_geo_master', array(
                            'id' => $res->destination_geo
                        ));
                        if ($chk_d->num_rows() > 0) {
                            $destination_geo = $chk_d->row()->name;
                        }
                        $chk_c = $this->db->select('name')->get_where('tb_calendar_data', array(
                            'id' => $res->calendar_id
                        ));

                        if ($chk_c->num_rows() > 0) {
                            $calendar_name = $chk_c->row()->name;
                        }
                        $info = array('id'=>$res->id,'laneid'=>$res->lane_ido,'lane_name'=> htmlentities($res->lane_name ,ENT_QUOTES),'sor_geo'=>$res->source_geo,'sor'=>htmlentities($res->source, ENT_QUOTES),'desc_geo'=>$res->destination_geo,'desc'=>htmlentities($res->destination, ENT_QUOTES),'cal'=>$res->calendar_id,'day'=>$res->rs_lane_days,'hour'=>$res->rs_lane_hours,'min'=>$res->rs_lane_mins);
                        $info = htmlentities(json_encode($info));
                        $action = "<ul class='nav nav-tabs'><li class='dropdown'> <a class='dropdown-toggle' data-toggle='dropdown' href='#''><span class='icon  tru-icon-action-setting'></span></a><ul class='dropdown-menu ' role='menu'>" . "<li><a id='bEdit' type='button' class='btn btn-sm btn-default'  onclick='rowlaneEdit(this," . $info . ");'><span class='glyphicon glyphicon-pencil' ></span>Edit</a></li><li><a id='bElim' type='button' class='btn btn-sm btn-default' onclick='deletelanedetails(" . $res->id . ");'><span class='glyphicon glyphicon-trash' > </span>Remove</a></li><li><a id='bAdd' type='button' class='btn btn-sm btn-default' onclick='rowAdd(this);'><span class='glyphicon glyphicon-plus' > </span>Add Lane Details</a></li>";

                        $data[] = array(
                            'lane_id' => $res->lane_ido,
                            'lane_name' => htmlentities($res->lane_name ,ENT_QUOTES),
                            'id' => $res->id,
                            'source_geo' => $source_geo,
                            'source' => htmlentities($res->source, ENT_QUOTES),
                            'destination_geo' => $destination_geo,
                            'destination' => htmlentities($res->destination, ENT_QUOTES),
                            'rs_lane_days' => $res->rs_lane_days,
                            'rs_lane_hours' => $res->rs_lane_hours,
                            'rs_lane_mins' => $res->rs_lane_mins,
                            'calendar_id' => $calendar_name,
                            'action' => $action
                        );
                    }
                }
            }
        }
        echo json_encode($data);
    }

    public function deletelanedetails()
    {
        $id = isset($_POST['id']) ? $_POST['id'] : '0';
        if ($id != '0') {
            $chk = $this->db->select('id,lane_id')->get_where('tb_rateservice_lanes', array(
                'id' => $id
            ));
            if ($chk->num_rows() > 0) {
                $row_id = $chk->row()->lane_id;
                $upd = $this->db->where(array(
                    'id' => $id
                ))->update('tb_rateservice_lanes', array(
                    'status' => 0
                ));
                if ($upd) {
                    echo "1";
                } else {
                    echo "0";
                }
            } else {
                echo "0";
            }
        } else {
            echo "0";
        }
    }

    public function checkname()
    {
        $post = $this->input->post(NULL,TRUE);
        extract($post);

        $id = isset($id) ? $id : "";
        $service_name = isset($service_name) ? $service_name : 0;
        $company_code = isset($company_code) ? $company_code : "";
        $branch_code = isset($branch_code) ? $branch_code : "";
        // $id = $this->uri->segment(3);
        $where = array(
            'service_name' => $service_name,
            'company_code' => $company_code,
            'branch_code' => $branch_code
        );
        if ($id) {
            $where['id !='] = $id;
        }
        $company = $this->common->gettblrowdata($where, 'service_name', 'tb_rate_services', 0, 0);
        if (empty($company)) {
            echo "2";
        } else {

            echo "1";
        }
    }

    public function getlaneid()
    {
        $id = $this->input->post('id');
        $lane = array();
        if (! empty($id)) {
            $lane = $this->common->gettblrowdata(array(
                'id' => $id
            ), 'id,lane_id,lane_name,source_geo,source,destination_geo, destination', 'tb_lanes_master', 0, 0);
        }
        echo json_encode($lane);
    }

    public function delete($id)
    {
        if ($id != '') {
            $this->db->where('id', $id);
            $this->db->set('status', 0);
            $result = $this->db->update('tb_rate_services');
            if ($result) {
                echo "1";
            } else {
                echo "0";
            }
        }
    }

    public function getservicetabl($wher, $whr)
    {
        $this->db->select('rs.*,sm.name')->from('tb_rate_services rs');
        $this->db->join('tb_service_master sm', 'rs.service_type=sm.id', 'LEFT');
        $this->db->where($wher);
        $this->db->like($whr);
        $this->db->order_by('rs.id', 'DESC');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function deletebulkrecords(): void
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $ids = $this->input->post('deleteids');
            $result = true;
            foreach ($ids as $id) {
                $this->db->where('id', $id);
                $this->db->set('status', 0);
                $result = $this->db->update('tb_rate_services');
                if (!$result) {
                    $result = false;
                }
            }
            echo $result ? "success" : "failed";
        }
    }
}
