<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
use Dompdf\Dompdf;
class Kntruckwaybill extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->library(['session','form_validation','email','barcode']);
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->helper("jwt");
        $this->load->model(['common','Order','truckwaybillmodel']);
    }

    public function index($order_id)
    {
        $data = $order_types = [];
        require 'vendor/autoload.php';

        $data['shipper'] = $add_info = [];
        $pickup_address = $delivery_address = $shipper_address = $newshipper_address = $consignee_address = $order_reference = $noity_address = $branch_details = [];
        $cargo_info = $driver_name = $departure_date = $gene_order_id = $add_info['debtor_jfr'] = $salogTrackingNumber = "";
        $add_info['ldm'] = 0;

        if ($order_id != "") {
            $chkorder = $this->Order->getordertoedit($order_id);

            if ($chkorder->num_rows() > 0) {
                $gene_order_id = $chkorder->row()->order_id;
                $trackingNo = getorderreftypeinfo('TKN', $chkorder->row()->id); 
                $add_info['twbNo'] = $chkorder->row()->order_id;
                $add_info['tracking_number'] = $trackingNo;
                $add_info['created_source'] = $chkorder->row()->created_source;
                $pickup_address['pickup_company'] = $chkorder->row()->pickup;
                $pickup_address['pickup_country'] = $chkorder->row()->pickup_country;
                $pickup_address['pickup_city'] = $chkorder->row()->pickup_city;
                $pickup_address['pickup_pincode'] = $chkorder->row()->pickup_pincode;
                $pickup_address['pickup_address1'] = $chkorder->row()->pickup_address1;
                $pickup_address['pickup_address2'] = $chkorder->row()->pickup_address2;

                $delivery_address['delivery_company'] = $chkorder->row()->delivery;
                $delivery_address['delivery_country'] = $chkorder->row()->delivery_country;
                $delivery_address['delivery_city'] = $chkorder->row()->delivery_city;
                $delivery_address['delivery_pincode'] = $chkorder->row()->delivery_pincode;
                $delivery_address['delivery_address1'] = $chkorder->row()->delivery_address1;
                $delivery_address['delivery_address2'] = $chkorder->row()->delivery_address2;

                $early_pickup = $chkorder->row()->pickup_datetime;
                $late_delivery = $chkorder->row()->drop_endtime;
                $curtz = $this->session->userdata("usr_tzone")['timezone'];

                if ($early_pickup != "" && $early_pickup != "0000-00-00 00:00:00") {
                    $epickup = getdatetimebytimezone($curtz, $early_pickup, DFLT_TZ);
                    $early_pickup = $epickup['datetime'];
                }

                if ($late_delivery != "" && $late_delivery != "0000-00-00 00:00:00") {
                    $ldelivery = getdatetimebytimezone($curtz, $late_delivery, DFLT_TZ);
                    $add_info['late_delivery'] = $late_delivery = $ldelivery['datetime'];
                }

                $o_shipper_id = $chkorder->row()->o_shipper_id;
                if ($o_shipper_id != "") {
                    $where = array("id" => $o_shipper_id);
                    $newshipperdetails = $this->common->gettblrowdata($where,
                        "name,mobile,code,email,location_id,street,state,country,pincode", "tbl_party_master", 0, 0);
                    if (count($newshipperdetails) > 0) {
                        $newshipper_address['name'] = $newshipperdetails['name'];
                        $newshipper_address['location'] = $newshipperdetails['location_id'];
                        $newshipper_address['street'] = $newshipperdetails['street'];
                        $newshipper_address['state'] = $newshipperdetails['state'];
                        $newshipper_address['country'] = $newshipperdetails['country'];
                        $newshipper_address['pincode'] = $newshipperdetails['pincode'];
                    }

                }

                $consignee_id = $chkorder->row()->consignee_id;

                if ($consignee_id != "") {
                    $where = array("id" => $consignee_id);
                    $consigneedetails = $this->common->gettblrowdata($where,
                        "name,mobile,code,email,location_id,street,state,country,pincode", "tbl_party_master", 0, 0);
                    if (count($consigneedetails) > 0) {
                        $consignee_address['name'] = $consigneedetails['name'];
                        $consignee_address['location'] = $consigneedetails['location_id'];
                        $consignee_address['street'] = $consigneedetails['street'];
                        $consignee_address['state'] = $consigneedetails['state'];
                        $consignee_address['country'] = $consigneedetails['country'];
                        $consignee_address['pincode'] = $consigneedetails['pincode'];
                    }

                }

                $ord_pikinst = $ord_dlvinst = "";
                $order_reference = [];
                $getrefers = $this->db->query("SELECT reference_id,ref_value FROM tb_order_references WHERE order_id='" . $order_id . "' AND reference_id in('ORD_PIKINST','ORD_DLVINST','DQ','PO','XSR','ADDINFO','MARKS_NUMBERS')");
                $multipleMarksNumbers = "";
                if ($getrefers->num_rows() > 0) {
                    $result = $getrefers->result();

                    foreach ($result as $res) {
                        if ($res->reference_id == "XSR") {
                            $salogTrackingNumber = $res->ref_value;
                        } elseif ($res->reference_id == "MARKS_NUMBERS") {
                            $multipleMarksNumbers = $res->ref_value;
                            $multipleMarksNumbers = str_replace(['\r\n','\r','\n'], ", ", $multipleMarksNumbers);
                        }
                        else {
                            $order_reference[] = [
                                "reference_id" => $res->reference_id,
                                "ref_value" => $res->ref_value
                            ];
                        }
                    }
                }

                $ship_id = $chkorder->row()->shipmentid;

                //expiry of token after 10 days
                $expDate = strtotime('+10 days');
                $jwt_claim = ["sub" => $ship_id, "exp" => $expDate];
                $get_jwt = generate_jwt($jwt_claim);
                $data["link_id"] = base_url() . "driverappv3/" . $get_jwt;
                $data["barcode"] = $this->barcode->generate($data["link_id"]);

                if ($data["checkCompanyCode"] = checkAccessConditions('DISPLAY_BARCODE_ON_TRUCKWAYBILL', $this->session->userdata('company_code'))) {
                    $shipmentnumber = "SVK" . $gene_order_id;
                    $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
                    $data["barcode"] = 'data:image/png;base64,' . base64_encode($generator->getBarcode($shipmentnumber, $generator::TYPE_CODE_128));
                }


                $customer_id = $chkorder->row()->customer_id;
                $where = array("id" => $customer_id);

                $custdetails = $this->common->gettblrowdata($where,
                    "name,phone,code,email_id,location,street,state,country,pincode", "tb_customers", 0, 0);

                if (count($custdetails) > 0) {
                    $shipper_address['name'] = $custdetails['name'];
                    $shipper_address['location'] = $custdetails['location'];
                    $shipper_address['street'] = $custdetails['street'];
                    $shipper_address['state'] = $custdetails['state'];
                    $shipper_address['country'] = $custdetails['country'];
                    $shipper_address['pincode'] = $custdetails['pincode'];
                }

                $ordwhere = array("order_row_id" => $order_id);

                $order_sub_details = $this->common->gettblrowdata($ordwhere,
                    "delivery_term,incoterm,delivery_note,notify_party,customs_required,lane_reference",
                    "tb_order_details", 0, 0);

                if (count($order_sub_details) > 0) {
                    $add_info['inco_term'] = $order_sub_details['incoterm'];
                    $add_info['delivery_term'] = $order_sub_details['delivery_term'];

                    if ($order_sub_details['customs_required'] == 1) {
                        $add_info['customs_required'] = 'Y';
                    } else {
                        $add_info['customs_required'] = 'N';
                    }
                    $add_info['lane_reference'] = $order_sub_details['lane_reference'];

                    if ($add_info['delivery_term'] != "") {
                        $where = array("term_id" => $add_info['delivery_term']);
                        $delivery_incoterms = $this->common->gettblrowdata($where, "name", "tb_delivery_terms", 0, 0);

                        if (count($delivery_incoterms) > 0) {
                            $add_info['delivery_term'] = $add_info['delivery_term'] . " - " . $delivery_incoterms['name'];
                        }
                    }
                }
                $cargo_info = $this->common->gettbldata(
                    ["order_id" => $order_id, 'cargo_id >' => '0', 'status' => '1'],
                    "cargo_id,handling_unit,quantity_type,length,width,height,weight,ldm,volume,quantity,quantity_type,cargo_content,marks_numbers",
                    "tb_order_cargodetails ",
                    0,
                    0
                );

                if (!empty($cargo_info)) {
                    foreach ($cargo_info as $cargoinfo){
                        $add_info['ldm'] += $cargoinfo['ldm'];
                    }
                }

                $getjfr = $this->common->gettblrowdata(array(
                    'order_id' => $order_id,
                    'type' => 0,
                    'invoice_status >' => 0,
                    'status' => 1
                ), 'debtor_jfr', 'tb_reveneus', 0, 0);

                if (count($getjfr) > 0) {
                    $add_info['debtor_jfr'] = $getjfr['debtor_jfr'];
                }


                $notify_party = $this->truckwaybillmodel->notify_party($order_id);

                if ($notify_party->num_rows() > 0) {
                    $noity_address['name'] = $notify_party->row()->name;
                    $noity_address['location_id'] = $notify_party->row()->location_id;
                    $noity_address['address'] = $notify_party->row()->address;
                    $noity_address['country'] = $notify_party->row()->country;
                    $noity_address['state'] = $notify_party->row()->state;
                    $noity_address['street'] = $notify_party->row()->street;
                    $noity_address['pincode'] = $notify_party->row()->pincode;
                }

                $branchcode = $chkorder->row()->branch_code;
                $branch_info = $this->truckwaybillmodel->branch_info($branchcode);

                if ($branch_info->num_rows() > 0) {
                    $branch_details['branch_name'] = $branch_info->row()->branch_name;
                    $branch_details['street'] = $branch_info->row()->street;
                    $branch_details['city'] = $branch_info->row()->city;
                    $branch_details['state'] = $branch_info->row()->state;
                    $branch_details['country'] = $branch_info->row()->country;
                    $branch_details['zipcode'] = $branch_info->row()->zipcode;
                    $branch_details['phone'] = $branch_info->row()->phone;
                    $branch_details['fax'] = $branch_info->row()->fax;
                    $branch_details['email'] = $branch_info->row()->email;
                    $branch_details['bank_name'] = $branch_info->row()->bank_name;
                    $branch_details['bank_address'] = $branch_info->row()->bank_address;
                    $branch_details['bank_code'] = $branch_info->row()->bank_code;
                    $branch_details['bank_city'] = $branch_info->row()->bank_city;
                    $branch_details['bank_phone'] = $branch_info->row()->bank_phone;
                    $branch_details['bank_zipcode'] = $branch_info->row()->bank_zipcode;
                }
                $getbrachoffno = $this->common->gettblrowdata(array('branch_code' => $branchcode), 'branch_officeno',
                    'tb_branch_master', 0, 0);

                if (count($getbrachoffno) > 0) {
                    $add_info['branch_officeno'] = $getbrachoffno['branch_officeno'];
                }

                $tracknum = $chkorder->row()->order_id;
                if ($tracknum != '') {
                    $tripinfo = getTripinfoByOrder($tracknum);
                    if (isset($tripinfo['ship_id'])) {
                        $shift_id = $tripinfo['ship_id'];
                        if (isset($tripinfo['trip_id'])) {
                            $driver_info = $this->truckwaybillmodel->driverinfo($tripinfo['trip_id']);
                            if ($driver_info->num_rows() > 0) {
                                $driver_name = $driver_info->row()->name;
                            }
                        } else {
                            $driver_name = $this->truckwaybillmodel->shiftdriverinfo($shift_id);

                        }

                        //get vehicel information
                        $add_info['truck_num'] = $add_info['trailer_num'] = $add_info['trucktype'] = "";
                        $truck_details = $this->truckwaybillmodel->vehicelinfo($shift_id);

                        if (!empty($truck_details)) {
                            $add_info['truck_num'] = $truck_details['register_number'];
                            $add_info['trailer_num'] = $truck_details['truck_number'];
                            $add_info['trucktype'] = $truck_details['trucktype'];
                        }

                        $getvehicletype = $this->common->gettblrowdata(array('id' => $shift_id, 'status' => 1),
                            'vehicle_type', 'tb_shifts', 0, 0);

                        if (count($getvehicletype) > 0) {
                            $add_info['trucktype'] = $getvehicletype['vehicle_type'];
                        }
                    }
                }
            }

            $departure_date = $this->truckwaybillmodel->getvehicledetails($gene_order_id);

        }

        $data['pickup_address'] = $pickup_address;
        $data['newshipper_address'] = $newshipper_address;
        $data['consignee_address'] = $consignee_address;
        $data['delivery_address'] = $delivery_address;
        $add_info['driver_name'] = $driver_name;
        $add_info['departure_date'] = ($departure_date == "") ? $early_pickup : $departure_date;
        $data['add_info'] = $add_info;
        $data['ord_pikinst'] = $ord_pikinst;
        $data['ord_dlvinst'] = $ord_dlvinst;
        $data['shipper_address'] = $shipper_address;
        $data['cargo_details'] = $cargo_info;
        $data['order_reference'] = $order_reference;
        $data['noity_address'] = $noity_address;
        $data['branch_details'] = $branch_details;
        $data['salog_tracking_number'] = $salogTrackingNumber;
        $data['multiple_marks_numbers'] = $multipleMarksNumbers;
        $childid = 0;
        $user_name = "";

        $company_code = $this->session->userdata('company_code');
        $data['company_code'] = $company_code;
        $user_id = $this->session->userdata('user_id');

        if ($this->session->userdata('childid')) {
            $childid = $this->session->userdata('childid');
        }

        if ($childid > 0) {
            $getusername = $this->common->gettblrowdata(array("id" => $childid), "name", "tb_user_logins", 0, 0);
        } else {
            $getusername = $this->common->gettblrowdata(array("id" => $user_id), "name", "tb_users", 0, 0);
        }

        if (!empty($getusername)) {
            $user_name = $getusername['name'];
        }

        $data['user_name'] = $user_name;
        $html = "";

        if (checkAccessConditions('RELATED_2_SG_MY', $company_code)) {
            $mpdf = new \Mpdf\Mpdf([
                'mode' => 'utf-8',
                'tempDir' => FCPATH . 'assets/tmp',
                'default_font_size' => 9,
                'format' => 'A4'
            ]);

            $mpdf->setAutoBottomMargin = 'stretch';
            $html .= $this->load->view('truckwaybill/index_sg', $data, true);
            $html .= $this->load->view('truckwaybill/terms_sg', $data, true);
        } else {
            if ($company_code == 'AEKN') {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 8,
                    'format' => 'A4'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html .= $this->load->view('truckwaybill/truckwaybill_uae', $data, true);
            } elseif (checkAccessConditions('RELATED_2_TW_CN', $company_code)) {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => '-aCJK',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4'
                ]);
                $mpdf->autoScriptToLang = true;
                $mpdf->autoLangToFont = true;
                $mpdf->setAutoBottomMargin = 'stretch';
                $html = $this->load->view('truckwaybill/index', $data, true);

            } else {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html = $this->load->view('truckwaybill/index', $data, true);
            }
        }
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont   = true;
        $mpdf->WriteHTML($html);
        $mpdf->Output($gene_order_id . "_" . date('YmdHis') . ".pdf", 'D');

    }

    public function tripwisetruckwaybill($order_id)
    {
        $userid = $this->session->userdata("user_id");
        $chkusr = $this->db->select("name,emailid")->get_where("tb_users", array("id" => $userid), 1, 0);
        $email = "";
        if ($chkusr->num_rows() > 0) {
            $email = $chkusr->row()->emailid;
        }
        $lang = "english";
        $ord_lang = explode('_', $order_id);
        if (!empty($ord_lang)) {
            $order_id = $ord_lang[0];
            $lang = $ord_lang[1];
        }
        $data = $order_types = array();
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        require 'vendor/autoload.php';
        $data['shipper'] = array();
        $add_info = array();
        $pickup_address = $delivery_address = $shipper_address = $cargo_details = $order_reference = $noity_address = $branch_details = $pickupsequence = $deliverysequence = $orders_data = array();
        $cargo_info = $from_loc = $to_loc = $truck_num = $driver_name = $departure_date = '';
        $gene_order_id = '';
        if (is_numeric($order_id) && $order_id > 0) {
            $trip_id = 0;
            $order_ids = array($order_id);
            $where = array('id' => $order_id);
            $branch_code = $this->session->userdata('branch_code');
            $branch_info = $this->truckwaybillmodel->branch_info($branch_code);
            if ($branch_info->num_rows() > 0) {
                $branch_details['branch_name'] = $branch_info->row()->branch_name;
                $branch_details['street'] = $branch_info->row()->street;
                $branch_details['city'] = $branch_info->row()->city;
                $branch_details['state'] = $branch_info->row()->state;
                $branch_details['country'] = $branch_info->row()->country;
                $branch_details['zipcode'] = $branch_info->row()->zipcode;
                $branch_details['phone'] = $branch_info->row()->phone;
                $branch_details['fax'] = $branch_info->row()->fax;
                $branch_details['email'] = $branch_info->row()->email;
                $branch_details['bank_name'] = $branch_info->row()->bank_name;
                $branch_details['bank_address'] = $branch_info->row()->bank_address;
                $branch_details['bank_code'] = $branch_info->row()->bank_code;
                $branch_details['bank_city'] = $branch_info->row()->bank_city;
                $branch_details['bank_phone'] = $branch_info->row()->bank_phone;
                $branch_details['bank_zipcode'] = $branch_info->row()->bank_zipcode;
            }
            $data = array(
                'driver_name' => "",
                'truck_num' => "",
                'register_number' => "",
                'driver_contact_num' => "",
                'vehicle_type' => "",
                'carrier_name' => "",
                'carrier_mobile' => "",
                'carrier_location' => "",
                'carrier_address' => "",
                'carrier_pincode' => "",
                'carrier_country' => "",
                'carrier_email' => "",
                'shipmentid' => "",
                "price" => 0,
                "currency" => "",
                "carrier_instructions" => ""
            );
            $gettripinfo = $this->common->gettblrowdata($where, "order_id,shift_id,trip_id,shipmentid", "tb_orders", 0,
                0);
            if (count($gettripinfo) > 0) {
                $ord_tracknum = $gettripinfo['order_id'];
                $data['shipmentid'] = $gettripinfo['shipmentid'];
                $shift_id = $gettripinfo['shift_id'];
                $trip_id = $gettripinfo['trip_id'];
                if ($shift_id > 0) {
                    $getshiftinfo = $this->common->gettblrowdata(array('id' => $shift_id),
                        "vendor_id,vehicle_type,carrier_instructions", "tb_shifts", 0, 0);
                    if (count($getshiftinfo) > 0) {
                        $vendor_id = $getshiftinfo['vendor_id'];
                        $data['vehicle_type'] = $getshiftinfo['vehicle_type'];
                        $data['carrier_instructions'] = $getshiftinfo['carrier_instructions'];
                        if ($vendor_id > 0) {
                            $getcarrierinfo = $this->common->gettblrowdata(array('id' => $vendor_id, 'status' => 1),
                                "name,mobile,location,address,pincode,country,email", "tb_vendors", 0, 0);
                            if (count($getcarrierinfo) > 0) {
                                $data['carrier_name'] = $getcarrierinfo['name'];
                                $data['carrier_mobile'] = $getcarrierinfo['mobile'];
                                $data['carrier_location'] = $getcarrierinfo['location'];
                                $data['carrier_address'] = $getcarrierinfo['address'];
                                $data['carrier_pincode'] = $getcarrierinfo['pincode'];
                                $data['carrier_country'] = $getcarrierinfo['country'];
                                $data['carrier_email'] = $getcarrierinfo['email'];
                            }
                        }
                    }
                    if ($trip_id > 0) {
                        $getdriverinfo = $this->db->query("SELECT d.id,d.name,d.contact_num from tb_trips  td LEFT JOIN tb_truck_drivers d ON d.id = td.driver_id WHERE td.id=" . $trip_id . " order by td.id desc LIMIT 1");
                        if ($getdriverinfo->num_rows() > 0) {
                            $data['driver_name'] = $getdriverinfo->row()->name;
                            $data['driver_contact_num'] = $getdriverinfo->row()->contact_num;
                        }
                        $getvehicleinfo = $this->db->query("SELECT d.truck_number,d.register_number from tb_trips  td LEFT JOIN tb_trucks_data d ON d.id = td.vehicle_id WHERE td.id=" . $trip_id . " order by td.id DESC LIMIT 1");
                        if ($getvehicleinfo->num_rows() > 0) {
                            $data['truck_num'] = $getvehicleinfo->row()->truck_number;
                            $data['register_number'] = $getvehicleinfo->row()->register_number;
                        }
                    }
                    /*$data['truck_num']  =$this->truckwaybillmodel->vehicelinfo($shift_id);*/
                    /*	log_message("error","truck_num - - ".$data['truck_num']);*/
                    $order_ids = array();
                    $getorder_ids = $this->common->gettbldata(array('shift_id' => $shift_id, 'status !=' => 0), "id",
                        "tb_orders", 0, 0);
                    if (count($getorder_ids) > 0) {
                        foreach ($getorder_ids as $ordids){
                            $order_ids[] = $ordids['id'];
                        }
                    }
                }
            }
            if (count($order_ids) > 0) {
                $getcharges = $this->truckwaybillmodel->getcharges($order_ids);
                if (!empty($getcharges)) {
                    foreach ($getcharges as $getcharge){
                        if ($getcharge['charge_amount'] > 0) {
                            $data['price'] += $getcharge['charge_amount'];
                        }
                        $data['currency'] = $getcharge['charge_currency'];
                        /*$local_amount = $getcharge['local_amount'];
                        $local_currency = $getcharge['local_currency'];*/
                    }
                }
            }

            foreach ($order_ids as $orderid){
                $pickupsequence = $deliverysequence = array();
                $chkorder = $this->Order->getordertoedit($orderid);
                if ($chkorder->num_rows() > 0) {
                    $pickup_datetime = $chkorder->row()->pickup_datetime;
                    $delivery_datetime = $chkorder->row()->delivery_datetime;
                    $getactual = getdatetimebytimezone($curtz, $pickup_datetime, DFLT_TZ);
                    $pickup_date = date('d.m.Y', strtotime($getactual['datetime']));
                    $pickup_time = date('H:00 - i:00', strtotime($getactual['datetime']));
                    $getactual = getdatetimebytimezone($curtz, $delivery_datetime, DFLT_TZ);
                    $delivery_date = date('d.m.Y', strtotime($getactual['datetime']));
                    $delivery_time = date('H:00 - i:00', strtotime($getactual['datetime']));
                    $cargo_info = "";
                    $cargo_info = $this->common->gettbldata(array("order_id" => $orderid),
                        "cargo_id,handling_unit,quantity_type,length,width,height,weight,ldm,volume,quantity,quantity_type,cargo_content",
                        "tb_order_cargodetails ", 0, 0);
                    $gene_order_id = $chkorder->row()->order_id;
                    $ord_pikinst = $ord_dlvinst = "";
                    $getrefers = $this->db->query("SELECT r.reference_id,r.ref_value FROM tb_order_references r,tb_orders o WHERE o.id='" . $orderid . "' AND r.order_id=o.id AND r.status=1 AND reference_id in('ORD_PIKINST','ORD_DLVINST') GROUP BY r.id");
                    if ($getrefers->num_rows() > 0) {
                        foreach ($getrefers->result() as $res){
                            if ($res->reference_id == "ORD_PIKINST") {
                                $ord_pikinst = $res->ref_value;
                            } else {
                                if ($res->reference_id == "ORD_DLVINST") {
                                    $ord_dlvinst = $res->ref_value;
                                }
                            }
                        }
                    }
                    $createdon = date('d.m.Y', strtotime($chkorder->row()->createdon));
                    $orderdata_arr = array(
                        'pickup_company' => $chkorder->row()->pickup,
                        'pickup_country' => $chkorder->row()->pickup_country,
                        'pickup_city' => $chkorder->row()->pickup_city,
                        'pickup_pincode' => $chkorder->row()->pickup_pincode,
                        'pickup_address1' => $chkorder->row()->pickup_address1,
                        'order_id' => $gene_order_id,
                        'consignee_name' => $chkorder->row()->delivery,
                        'pickup_date' => $pickup_date,
                        'pickup_time' => $pickup_time,
                        'delivery_company' => $chkorder->row()->delivery,
                        'delivery_country' => $chkorder->row()->delivery_country,
                        'delivery_city' => $chkorder->row()->delivery_city,
                        'delivery_pincode' => $chkorder->row()->delivery_pincode,
                        'delivery_address1' => $chkorder->row()->delivery_address1,
                        'order_id' => $gene_order_id,
                        'shipper_name' => $chkorder->row()->pickup,
                        'delivery_date' => $delivery_date,
                        'delivery_time' => $delivery_time,
                        'cargo_info' => $cargo_info,
                        'ord_pikinst' => $ord_pikinst,
                        'ord_dlvinst' => $ord_dlvinst,
                        'createdon' => $createdon
                    );
                    $orders_data[] = $orderdata_arr;

                }
            }
        }

        $data['branch_details'] = $branch_details;
        /*log_message("error","gettripinfo - - ".json_encode($data));*/
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH . 'assets/tmp',
            'format' => 'A4'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $footer = '';
        $header = '';
        $html = '';
        $data['i'] = 1;
        foreach ($orders_data as $ordersdata){
            $data['order_data'] = $ordersdata;
            if ($lang == "english") {
                $html .= $this->load->view('pldocs/twb_eng', $data, true);
            } else {
                $html .= $this->load->view('pldocs/twb_pl', $data, true);
            }
            $html .= "<pagebreak/>";
            $data['i']++;
        }

        if ($lang == "english") {
            $html .= $this->load->view('pldocs/terms', $data, true);
        } else {
            $html .= $this->load->view('pldocs/terms_pl', $data, true);
        }
        $footer = $this->load->view('pldocs/footer', $data, true);
        $mpdf->SetFooter($footer);
        $mpdf->WriteHTML($html);
        $mpdf->Output("TWB" . "_" . date('YmdHis') . ".pdf", 'D');
        $pdf = $mpdf->Output("", 'S');
        if ($data['carrier_email'] != "" && $data['shipmentid'] != "") {
            $postdata = array(
                'emailid' => $data['carrier_email'],
                'username' => $data['carrier_name'],
                'subject' => "Transport Order",
                'attachment' => $pdf,
                "shipmentid" => $data['shipmentid'],
                "lang" => $lang,
                "useremail" => $email
            );
            $this->sendstatusmail($postdata);
        }
    }

    public function sendstatusmail($data)
    {
        if ($data['lang'] == "english") {
            $body = $this->load->view('pldocs/mail_eng', $data, true);
        } else {
            $body = $this->load->view('pldocs/mail_pl', $data, true);
        }
        $this->load->library('email');
        $this->email->from('svkonekt@kuehne-nagel.com', 'svkonekt');
        $this->email->to($data['emailid'], $data['username']);
        $this->email->subject($data['subject']);
        $this->email->set_mailtype("html");
        $this->email->message($body);
        if (isset($data['attachment']) && !empty($data['attachment'])) {
            $this->email->attach($data['attachment'], 'attachment', "Transport_Order.pdf", 'application/pdf');
        }
        if (!$this->email->send()) {
            log_message('error', ' poland pdf mail failed MailID: ' . $data['emailid'] . " Action :");
            log_message("error", $this->email->print_debugger());
        }
        return true;
    }

    private function getOrderDetailsTableData(array $orderRowIds, array $orderData): array
    {
        $getOrderDetailsData = $this->truckwaybillmodel->getOrderDetailsTableData($orderRowIds);
        foreach ($getOrderDetailsData as $eachDetailData) {
            $orderRowId = $eachDetailData['order_row_id'];
            $checkOrder = $orderData[$orderRowId]['id'] ?? 0;
            if ($checkOrder > 0) {
                $orderData[$orderRowId]['inco_term'] = $eachDetailData['incoterm'];
                $orderData[$orderRowId]['delivery_term'] = $eachDetailData['delivery_term'];
                $orderData[$orderRowId]['customs_required'] = $eachDetailData['customs_required'] === 1 ? "Y" : "N";
                $orderData[$orderRowId]['lane_reference'] = $eachDetailData['lane_reference'];
                $orderData[$orderRowId]['delivery_term'] = $eachDetailData['delivery_term'];
                $deliveryTerms = $eachDetailData['delivery_term'];
                if ($deliveryTerms != "") {
                    $deliveryIncoterms = $this->common->gettblrowdata(['term_id' => $deliveryTerms], "name", "tb_delivery_terms", 0, 0);
                    if (!empty($deliveryIncoterms)) {
                        $orderData[$orderRowId]['delivery_term'] = $deliveryTerms . " - " . $deliveryIncoterms['name'];
                    }
                }
            }
        }
        return $orderData;
    }

    private function getOrderCargoDetails(array $orderRowIds, array $orderData): array
    {
        $getCargoDetials = $this->truckwaybillmodel->getOrderCargoDetails($orderRowIds);
        foreach ($getCargoDetials as $eachCargo) {
            $orderRowId = $eachCargo['order_id'];
            $checkOrder = $orderData[$orderRowId]['id'] ?? 0;
            if ($checkOrder > 0) {
                $orderData[$orderRowId]['cargo_details'][] = $eachCargo;
            }
        }
        foreach ($orderData as $eachOrder) {
            $cargos = $eachOrder['cargo_details'] ?? [];
            $orderRowId = $eachOrder['id'];
            foreach ($cargos as $eachCargoPerOrder) {
                $orderData[$orderRowId]['totalLdm'] += $eachCargoPerOrder['ldm'];
            }
        }
        return $orderData;
    }

    private function getCustomerMasterDetails(array $customerIds, array $orderData): array
    {
        $customerData = [];
        $getCustomerDetails = $this->truckwaybillmodel->getCustomerMasterDetails($customerIds);
        foreach ($getCustomerDetails as $eachCustomer) {
            $rowId = $eachCustomer['id'];
            $customerData[$rowId] = ['id' => $eachCustomer['id'], 'name' => $eachCustomer['name'], 'phone' => $eachCustomer['phone'], 'code' => $eachCustomer['code'], 'email_id' => $eachCustomer['email_id'], 'location' => $eachCustomer['location'], 'street' => $eachCustomer['street'], 'state' => $eachCustomer['state'], 'country' => $eachCustomer['country'], 'pincode' => $eachCustomer['pincode']];
        }
        foreach ($orderData as $eachOrder) {
            $orderRowId = $eachOrder['id'];
            $customerRowId = $eachOrder['customerRowId'];
            $checkCustomer = $customerData[$customerRowId]['id'] ?? 0;
            if ($checkCustomer > 0) {
                $orderData[$orderRowId]['customerName'] = $customerData[$customerRowId]['name'];
                $orderData[$orderRowId]['customerPhone'] = $customerData[$customerRowId]['phone'];
                $orderData[$orderRowId]['customerCode'] = $customerData[$customerRowId]['code'];
                $orderData[$orderRowId]['customerMailId'] = $customerData[$customerRowId]['email_id'];
                $orderData[$orderRowId]['customerLocation'] = $customerData[$customerRowId]['location'];
                $orderData[$orderRowId]['customerStreet'] = $customerData[$customerRowId]['street'];
                $orderData[$orderRowId]['customerState'] = $customerData[$customerRowId]['state'];
                $orderData[$orderRowId]['customerCountry'] = $customerData[$customerRowId]['country'];
                $orderData[$orderRowId]['customerPincode'] = $customerData[$customerRowId]['pincode'];
            }
        }
        return $orderData;
    }

    private function getOrderReferencesWithCodes(array $orderRowIds, array $orderData): array
    {
        $references = [];
        $getReferences = $this->truckwaybillmodel->getOrderReferencesWithCodes($orderRowIds, ['ORD_PIKINST', 'ORD_DLVINST', 'DQ', 'PO', 'XSR', 'ADDINFO']);
        foreach ($getReferences as $eachReference) {
            $orderRowId = $eachReference['order_id'];
            $checkOrder = $orderData[$orderRowId]['id'] ?? 0;
            if ($checkOrder > 0) {
                $referenceId = $eachReference['reference_id'];
                $referenceValue = $eachReference['ref_value'];
                if ($referenceId === 'XSR') {
                    $orderData[$orderRowId]['salogTrackingNumber'] = $referenceValue;
                } else {
                    $references[$orderRowId][] = ['reference_id' => $referenceId, 'ref_value' => $referenceValue];
                }
            }
        }
        foreach ($orderData as $eachOrder) {
            $orderRowId = $eachOrder['id'];
            $orderData[$orderRowId]['references'] = $references[$orderRowId] ?? [];
        }
        return $orderData;
    }

    private function getOrderPartyTypes(array $orderRowIds, array $orderData): array
    {
        $partyTypes = $this->truckwaybillmodel->getOrderPartyTypes($orderRowIds, ['Shipper', 'Consignee', 'NOTIFY_PARTY']);
        foreach ($partyTypes as $eachPartyType) {
            $orderRowId = $eachPartyType['order_row_id'];
            $checkOrder = $orderData[$orderRowId]['id'] ?? 0;
            if ($checkOrder > 0) {
                $partyType = $eachPartyType['party_type_name'];
                if (strtoupper($partyType) == 'SHIPPER') {
                    $orderData[$orderRowId]['shipperName'] = $eachPartyType['name'];
                    $orderData[$orderRowId]['shipperLocation'] = $eachPartyType['location_id'];
                    $orderData[$orderRowId]['shipperStreet'] = $eachPartyType['street'];
                    $orderData[$orderRowId]['shipperState'] = $eachPartyType['state'];
                    $orderData[$orderRowId]['shipperCountry'] = $eachPartyType['country'];
                    $orderData[$orderRowId]['shipperPincode'] = $eachPartyType['pincode'];
                }
                if (strtoupper($partyType) == 'CONSIGNEE') {
                    $orderData[$orderRowId]['consigneeName'] = $eachPartyType['name'];
                    $orderData[$orderRowId]['consigneeLocation'] = $eachPartyType['location_id'];
                    $orderData[$orderRowId]['consigneeStreet'] = $eachPartyType['street'];
                    $orderData[$orderRowId]['consigneeState'] = $eachPartyType['state'];
                    $orderData[$orderRowId]['consigneeCountry'] = $eachPartyType['country'];
                    $orderData[$orderRowId]['consigneePincode'] = $eachPartyType['pincode'];
                }
                if (strtoupper($partyType) == 'NOTIFY_PARTY') {
                    $orderData[$orderRowId]['notifyName'] = $eachPartyType['name'];
                    $orderData[$orderRowId]['notifyLocation'] = $eachPartyType['location_id'];
                    $orderData[$orderRowId]['notifyStreet'] = $eachPartyType['street'];
                    $orderData[$orderRowId]['notifyState'] = $eachPartyType['state'];
                    $orderData[$orderRowId]['notifyCountry'] = $eachPartyType['country'];
                    $orderData[$orderRowId]['notifyPincode'] = $eachPartyType['pincode'];
                }
            }
        }
        return $orderData;
    }
    
    public function generateLR()
    {
        $data = ['status' => '1', 'message' => ''];
        $shiftId = $this->input->post('shiftId', true);
        log_message("error", "shiftId - - " . $shiftId);
        $companyCode = $this->session->userdata('company_code');
    
        if ($shiftId == 0) {
            $data = ['status' => '0', 'message' => 'Something went wrong'];
            echo json_encode($data);
            return;
        }
    
        // Load the view and capture HTML
        $html = $this->load->view('truckwaybill/KNRoadLR', $data, true);
    
        // Load Dompdf
        //require_once APPPATH . 'third_party/dompdf/autoload.inc.php'; // Adjust path if needed
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
    
        // Output PDF to browser
        $dompdf->stream("Consignment_Note.pdf", ['Attachment' => 0]);
    }

    public function validateTruckWayBillGeneration(): void
    {
        $orderIds = [];
        $data = ['status' => '1', 'message' => ''];
        $shiftId = $this->input->post('shiftId', true);
        $companyCode = $this->session->userdata('company_code');
        if ($shiftId == 0) {
            $data = ['status' => '0', 'message' => 'Something went wrong'];
        }
        $orderData = $this->truckwaybillmodel->getOrderIdsByShiftId($shiftId);
        if (!empty($orderData)) {
            $crossBorderMainTrip = $orderData['crossBorderMainTrip'] ?? 0;
            if ($crossBorderMainTrip > 0) {
                $data = ['status' => '0', 'message' => 'TWB cannot be generated for Xborder Main Trip '];
            }
        }
        echo json_encode($data);
    }

    public function generateTruckWayBillByShiftId(int $shiftId): void
    {
        $orderRowIds = $orderData = $customerIds = [];
        if ($shiftId > 0) {
            $tripData = $this->truckwaybillmodel->getTripsDetailsByshiftId($shiftId);
            $orderDetails = $this->truckwaybillmodel->getOrderIdsByShiftId($shiftId);
            if (!empty($orderDetails)) {
                $crossBorderMainTrip = $orderDetails['crossBorderMainTrip'] ?? 0;
                if ($crossBorderMainTrip === 0) {
                    foreach ($orderDetails as $eachOrderId) {
                        $orderRowId = $eachOrderId['id'];
                        $customerRowId = $eachOrderId['customer_id'];
                        $orderRowIds[] = $orderRowId;
                        $customerIds[] = $customerRowId;
                        $orderData[$orderRowId] = [
                            'id' => $orderRowId,
                            'bookingId' => $eachOrderId['order_id'],
                            'customerRowId' => $customerRowId,
                            'pickupCompany' => $eachOrderId['pickup_company'],
                            'pickupCountry' => $eachOrderId['pickup_country'],
                            'pickupCity' => $eachOrderId['pickup_city'],
                            'pickupPincode' => $eachOrderId['pickup_pincode'],
                            'pickupAddress1' => $eachOrderId['pickup_address1'],
                            'pickupAddress2' => $eachOrderId['pickup_address2'],
                            'deliveryCompany' => $eachOrderId['delivery_company'],
                            'deliveryCountry' => $eachOrderId['delivery_country'],
                            'deliveryCity' => $eachOrderId['delivery_city'],
                            'deliveryPincode' => $eachOrderId['delivery_pincode'],
                            'deliveryAddress1' => $eachOrderId['delivery_address1'],
                            'deliveryAddress2' => $eachOrderId['delivery_address2'],
                            'pickupDateTime' => $eachOrderId['pickup_datetime'],
                            'dropEndTime' => $eachOrderId['drop_endtime'],
                            'createdSource' => $eachOrderId['created_source'],
                            'branchCode' => $eachOrderId['branch_code'],
                            'totalLdm' => 0,
                            'jfr' => ''
                        ];
                    }
                    if (!empty($orderRowIds)) {
                        $orderData = $this->getOrderDetailsTableData($orderRowIds, $orderData);
                        $orderData = $this->getOrderCargoDetails($orderRowIds, $orderData);
                        $orderData = $this->getCustomerMasterDetails($customerIds, $orderData);
                        $orderData = $this->getOrderReferencesWithCodes($orderRowIds, $orderData);
                        $orderData = $this->getOrderPartyTypes($orderRowIds, $orderData);
                        $getDebtorJfr = $this->truckwaybillmodel->getDebtorJfrFromOrder($orderRowIds);
                        foreach ($getDebtorJfr as $eachRev) {
                            $orderRowId = $eachRev['order_id'];
                            $checkOrder = $orderData[$orderRowId]['id'] ?? 0;
                            if ($checkOrder > 0) {
                                $orderData[$orderRowId]['jfr'] = $eachRev['debtor_jfr'];
                            }
                        }
                    }
                    $this->arrangDataDownloadForTruckWayBill($orderData, $tripData);
                }
            }
        }
    }

    private function arrangDataDownloadForTruckWayBill(array $orderData, array $tripData): void
    {
        require 'vendor/autoload.php';
        $i = 0;
        $data['company_code'] = $this->session->userdata('company_code');
        $data['branch_code'] = $this->session->userdata('branch_code');
        $branchInfo = $this->truckwaybillmodel->branch_info($data['branch_code']);
        $data['user_id'] = $this->session->userdata('user_id');
        $userData = $this->truckwaybillmodel->getUserAndBranchAddressDetails();
        $branchAddressDetails = $branchInfo->row_array();
        $html = "";
        $shipmentId = $tripData['shipmentId'];
        $expiryRange = strtotime('+10 days');
        $jwtClaim = ["sub" => $shipmentId, "exp" => $expiryRange];
        $jwtKey = generate_jwt($jwtClaim);
        $linkId = base_url() . "driverappv3/" . $jwtKey;
        $orderDataCount = count($orderData);
        foreach ($orderData as $eachOrder) {
            $data['salog_tracking_number'] = $eachOrder['salogTrackingNumber'] ?? "";
            $data['order_reference'] = $eachOrder['references'] ?? [];
            $data['cargo_details'] = $eachOrder['cargo_details'];
            $data['user_name'] = $userData['userName'];
            if ($data["checkCompanyCode"] = checkAccessConditions('DISPLAY_BARCODE_ON_TRUCKWAYBILL', $data['company_code'])) {
                $shipmentnumber = "SVK" . $eachOrder['bookingId'];
                $generator = new Picqer\Barcode\BarcodeGeneratorPNG();
                $data["barcode"] = 'data:image/png;base64,' . base64_encode($generator->getBarcode($shipmentnumber, $generator::TYPE_CODE_128));
            } else {
                $data["barcode"] = $this->barcode->generate($linkId);
            }
            $branchDetails['branch_name'] = $branchAddressDetails['branch_name'] ?? "";
            $branchDetails['street'] = $branchAddressDetails['street'] ?? "";
            $branchDetails['city'] = $branchAddressDetails['city'] ?? "";
            $branchDetails['state'] = $branchAddressDetails['state'] ?? "";
            $branchDetails['country'] = $branchAddressDetails['country'] ?? "";
            $branchDetails['zipcode'] = $branchAddressDetails['zipcode'] ?? "";
            $branchDetails['phone'] = $branchAddressDetails['phone'] ?? "";
            $branchDetails['fax'] = $branchAddressDetails['fax'] ?? "";
            $branchDetails['email'] = $branchAddressDetails['email'] ?? "";
            $branchDetails['bank_name'] = $branchAddressDetails['bank_name'] ?? "";
            $branchDetails['bank_address'] = $branchAddressDetails['bank_address'] ?? "";
            $branchDetails['bank_code'] = $branchAddressDetails['bank_code'] ?? "";
            $branchDetails['bank_city'] = $branchAddressDetails['bank_city'] ?? "";
            $branchDetails['bank_phone'] = $branchAddressDetails['bank_phone'] ?? "";
            $branchDetails['bank_zipcode'] = $branchAddressDetails['bank_zipcode'] ?? "";
            $data['branch_details'] = $branchDetails;

            $additionalInfo['tracking_number'] = $eachOrder['bookingId'];
            $additionalInfo['created_source'] = $eachOrder['createdSource'];
            $additionalInfo['late_delivery'] = $eachOrder['dropEndTime'];
            $additionalInfo['inco_term'] = $eachOrder['inco_term'];
            $additionalInfo['delivery_term'] = $eachOrder['delivery_term'];
            $additionalInfo['customs_required'] = $eachOrder['customs_required'];
            $additionalInfo['lane_reference'] = $eachOrder['lane_reference'];
            $additionalInfo['ldm'] = $eachOrder['totalLdm'];
            $additionalInfo['debtor_jfr'] = $eachOrder['jfr'];
            $additionalInfo['driver_name'] = $tripData['driverName'];
            $additionalInfo['truck_num'] = $tripData['vehicleNumber'];
            $additionalInfo['trailer_num'] = $tripData['tailerNumber'];
            $additionalInfo['trucktype'] = $tripData['vehicleType'];
            $additionalInfo['departure_date'] = $tripData['departureDate'] ?: $eachOrder['pickupDateTime'];
            $additionalInfo['branch_officeno'] = $userData['BranchOfficeNumber'];
            $data['add_info'] = $additionalInfo;

            $pickup_address['pickup_company'] = $eachOrder['pickupCompany'];
            $pickup_address['pickup_country'] = $eachOrder['pickupCountry'];
            $pickup_address['pickup_city'] = $eachOrder['pickupCity'];
            $pickup_address['pickup_pincode'] = $eachOrder['pickupPincode'];
            $pickup_address['pickup_address1'] = $eachOrder['pickupAddress1'];
            $pickup_address['pickup_address2'] = $eachOrder['pickupAddress2'];
            $data['pickup_address'] = $pickup_address;

            $delivery_address['delivery_company'] = $eachOrder['deliveryCompany'];
            $delivery_address['delivery_country'] = $eachOrder['deliveryCountry'];
            $delivery_address['delivery_city'] = $eachOrder['deliveryCity'];
            $delivery_address['delivery_pincode'] = $eachOrder['deliveryPincode'];
            $delivery_address['delivery_address1'] = $eachOrder['deliveryAddress1'];
            $delivery_address['delivery_address2'] = $eachOrder['deliveryAddress2'];
            $data['delivery_address'] = $delivery_address;

            $newshipper_address['name'] = $eachOrder['shipperName'] ?? "";
            $newshipper_address['location'] = $eachOrder['shipperLocation'] ?? "";
            $newshipper_address['street'] = $eachOrder['shipperStreet'] ?? "";
            $newshipper_address['state'] = $eachOrder['shipperState'] ?? "";
            $newshipper_address['country'] = $eachOrder['shipperCountry'] ?? "";
            $newshipper_address['pincode'] = $eachOrder['shipperPincode'] ?? "";
            $data['newshipper_address'] = $newshipper_address;

            $consignee_address['name'] = $eachOrder['consigneeName'] ?? "";
            $consignee_address['location'] = $eachOrder['consigneeLocation'] ?? "";
            $consignee_address['street'] = $eachOrder['consigneeStreet'] ?? "";
            $consignee_address['state'] = $eachOrder['consigneeState'] ?? "";
            $consignee_address['country'] = $eachOrder['consigneeCountry'] ?? "";
            $consignee_address['pincode'] = $eachOrder['consigneePincode'] ?? "";
            $data['consignee_address'] = $consignee_address;

            $noity_address['name'] = $eachOrder['notifyName'] ?? "";
            $noity_address['location_id'] = $eachOrder['notifyLocation'] ?? "";
            $noity_address['address'] = "";
            $noity_address['country'] = $eachOrder['notifyCountry'] ?? "";
            $noity_address['state'] = $eachOrder['notifyState'] ?? "";
            $noity_address['street'] = $eachOrder['notifyStreet'] ?? "";
            $noity_address['pincode'] = $eachOrder['notifyPincode'] ?? "";
            $data['noity_address'] = $noity_address;

            $shipper_address['name'] = $eachOrder['customerName'];
            $shipper_address['location'] = $eachOrder['customerLocation'];
            $shipper_address['street'] = $eachOrder['customerStreet'];
            $shipper_address['state'] = $eachOrder['customerState'];
            $shipper_address['country'] = $eachOrder['customerCountry'];
            $shipper_address['pincode'] = $eachOrder['customerPincode'];
            $data['shipper_address'] = $shipper_address;
            if (checkAccessConditions('RELATED_2_SG_MY', $data['company_code'])) {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html .= $this->load->view('truckwaybill/index_sg', $data, true);
            } elseif ($data['company_code'] == 'AEKN') {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 8,
                    'format' => 'A4'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html .= $this->load->view('truckwaybill/truckwaybill_uae', $data, true);
            } elseif (checkAccessConditions('RELATED_2_TW_CN', $data['company_code'])) {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => '-aCJK',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4'
                ]);
                $mpdf->autoScriptToLang = true;
                $mpdf->autoLangToFont = true;
                $mpdf->setAutoBottomMargin = 'stretch';
                $html .= $this->load->view('truckwaybill/index', $data, true);
            } else {
                $mpdf = new \Mpdf\Mpdf([
                    'mode' => 'utf-8',
                    'tempDir' => FCPATH . 'assets/tmp',
                    'default_font_size' => 9,
                    'format' => 'A4'
                ]);
                $mpdf->setAutoBottomMargin = 'stretch';
                $html .= $this->load->view('truckwaybill/index', $data, true);
            }
            if ($i < ($orderDataCount - 1)) {
                $html .= "<pagebreak/>";
            } else {
                if (checkAccessConditions('RELATED_2_SG_MY', $data['company_code'])) {
                    $html .= $this->load->view('truckwaybill/terms_sg', $data, true);
                }
            }
            $i++;
        }
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont   = true;
        $mpdf->WriteHTML($html);
        if ($shipmentId != "") {
            $mpdf->Output($shipmentId . "_" . date('YmdHis') . ".pdf", 'D');
        } else {
            $mpdf->Output(date('YmdHis') . ".pdf", 'D');
        }
    }
}
