<?php

if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

class Kpireport extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('kpimodel');
		$this->load->model('common');
        if (!checkUrlAccessForUser('KPIREPORT')) {
            redirect("Forbiddenaccess");
        }

	}

    /**
     * display search data for MIS Report page
     *
     *
     *
     * @param
     * @return    Array
     * @author    Developer Name external.ravikumar@kuehne-nagel.com
     * @date      25-11-2021 11:00:00+05.30
     * @change    china,taiwan
     */

    public function index()
    {
    	$this->kpireports();
    }

    public function kpireports()
    {
    	$data['page_title'] = $this->lang->line('menu_kpireport');
    	$data["table_search"] = $whr = "";
        $userId = $this->session->userdata('user_id');
    	$curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data=[];
        $page=0;
    	if ($_POST) {
            $post = $_POST;
    	$post['user_id']=$userId;
    	$data['sub_title'] = 'KPI Reports';
    	$kpicount = $this->kpimodel->getReports($post,0,0)->num_rows();
    	$data['kpicount']=$kpicount;
    	$config = array();
    	$config["base_url"] = base_url() . "kpireport";
    	$config["total_rows"] = $kpicount;
    	$config["per_page"] = $kpicount;
    	$config["uri_segment"] = 2;
    	$config['display_pages'] = TRUE;
    	$this->pagination->initialize($config);
    	$data['page'] = $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
    	$data['kpidata'] = $this->kpimodel->getReports($post,$config["per_page"],$page);
    	$data['post'] = $post;
        }
        $businessType = $this->session->userdata("business_type");
        $id = $this->session->userdata('id');
        $carrierListWhere = ($businessType != "Carrier")  ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['carrierlist'] = $this->common->gettbldata($carrierListWhere, "id,name", "tb_vendors", 0, 0);

        $customersListWhere = ($businessType != "Customer") ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['customerslist'] = $this->common->gettbldata($customersListWhere, "id,name", "tb_customers", 0, 0);
        
        $this->settemplate->dashboard("kpireport/kpireport", $data);
    }



}
