<?php

if (!defined('BASEPATH')) {
	exit('No direct script access allowed');
}

class Kpireportoneday extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		if ($this->session->userdata('user_id') == '') {
			redirect('login');
		}
		$this->load->model('kpionedaymodel');
		$this->load->model('common');
        if (!checkUrlAccessForUser('KPIREPORTONEDAY')) {
            redirect("Forbiddenaccess");
        }

	}

    public function index()
    {
    	$this->kpireports();
    }

    public function kpireports()
    {
    	$data['page_title'] = $this->lang->line('menu_kpireportoneday');
    	$data["table_search"] = $whr = "";
        $userId = $this->session->userdata('user_id');
    	$curtz = $this->session->userdata("usr_tzone")['timezone'];
        $data=[];
        $page=0;
    	if ($_POST) {
            $post = $_POST;
    	$post['user_id']=$userId;
    	$data['sub_title'] = 'KPI One Day Reports';
        $result = $this->kpionedaymodel->getReports($post,0,0);
        if(!empty($result)) { $kpicount=$result->num_rows();}else{ $kpicount= 0; }
    	$data['kpicount']=$kpicount;
    	$config = array();
    	$config["base_url"] = base_url() . "kpireportoneday";
    	$config["total_rows"] = $kpicount;
    	$config["per_page"] = $kpicount;
    	$config["uri_segment"] = 2;
    	$config['display_pages'] = TRUE;
    	$this->pagination->initialize($config);
    	$data['page'] = $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
    	$data['kpidata'] = $this->kpionedaymodel->getReports($post,$config["per_page"],$page);
    	$data['post'] = $post;
        }
        $businessType = $this->session->userdata("business_type");
        $id = $this->session->userdata('id');
        $carrierListWhere = ($businessType != "Carrier")  ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['carrierlist'] = $this->common->gettbldata($carrierListWhere, "id,name", "tb_vendors", 0, 0);

        $customersListWhere = ($businessType != "Customer") ? ["user_id" => $userId, "status" => 1] : ["id" => $id, "status" => 1];
        $data['customerslist'] = $this->common->gettbldata($customersListWhere, "id,name", "tb_customers", 0, 0);
//echo '<pre>';print_r($data); echo '</pre>';exit;
        $this->settemplate->dashboard("kpireportoneday/kpireportoneday", $data);
    }



}
