<?php

defined('BASEPATH') or exit('No direct script access allowed');



class Lanesmaster extends CI_Controller

{



    public function __construct()

    {

        parent::__construct();

        if ($this->session->userdata('user_id') == "") {

            redirect("login");

        }

        $this->load->library('form_validation');

        $this->load->model("common");

        $this->load->model("lanesmodel");

        if (!checkUrlAccessForUser('LANESMASTER')) {
            redirect("Forbiddenaccess");
        }

    }



    public function index()

    {

        $data["page_title"] = $this->lang->line('bpartner_lanes');

        $data["sub_title"] = $this->lang->line('general_search');

        $whr = [];

        $where1 = [];

        $where = [];



        $user_id = $this->session->userdata('user_id');

        $data['user_id'] = $user_id;

        $table = 'tb_geo_master';

        $geo_master = $this->lanesmodel->selectlist('id,name', $table, ["status" => 1], 'name');

        $data['geo_master'] = $geo_master;

        $table1 = 'tbl_country_master';

        $whr1 = [

            "status" => 1

        ];

        $country_master = $this->lanesmodel->selectlist('country_name', $table1, $whr1, 'country_name');

        $data['country_master'] = $country_master;


        /*if (isset($_POST['searchsubmit']) && $_POST['searchsubmit'] == "Search") {

            $where = [

                'lane_name' => $this->input->post('name1',TRUE),
                'lane_id1' => $this->input->post('lane_id1',TRUE),
                'fromdate' => $this->input->post('fromdate',TRUE),
                'todate' => $this->input->post('todate',TRUE),

            ];

            if (isset($where['fromdate']) && $where['fromdate'] != "") {
                $fromdate    = date('Y-m-d', strtotime($where['fromdate']));
                $whr["DATE_FORMAT(tl.created_on,'%Y-%m-%d') >="] = $fromdate;

            }
            if (isset($where['todate']) && $where['todate'] != "") {
                $todate      = date('Y-m-d', strtotime($where['todate']));
                $whr["DATE_FORMAT(tl.created_on,'%Y-%m-%d') <="] = $todate;

            }

            if (isset($where['lane_name']) && $where['lane_name'] != "") {

                $where1['tl.lane_name'] = $where['lane_name'];

            }

            if (isset($where['lane_id1']) && $where['lane_id1'] != "") {

                $where1['tl.lane_id'] = $where['lane_id1'];

            }

            $whr['tl.status'] = 1;

            $whr['tl.user_id'] = $user_id;

            $data['lanes_list'] = $this->lanesmodel->getsearchdata($where1, $whr);



            $this->newtemplate->dashboard("lanes/index", $data);

        } else*/if (isset($_POST['searchsubmita']) && $_POST['searchsubmita'] == "Search") {

            $where = [

                'lane_id' => $this->input->post('lane_id',TRUE),

                'lane_name1' => $this->input->post('lane_name1',TRUE),

                'source_geo' => $this->input->post('source_geo',TRUE),

                'source' => $this->input->post('source',TRUE),

                'destination_geo' => $this->input->post('destination_geo',TRUE),

                'destination' => $this->input->post('destination',TRUE),

                'statusa' => $this->input->post('status',TRUE),
                
                'fromdate' => $this->input->post('fromdate',TRUE),
                
                'todate' => $this->input->post('todate',TRUE)

            ];

            $where1 = [];

            if (isset($where['lane_id']) && $where['lane_id'] != "") {

                $where1['tl.lane_id'] = $where['lane_id'];

            }

            if (isset($where['lane_name1']) && $where['lane_name1'] != "") {

                $where1['tl.lane_name'] = $where['lane_name1'];

            }

            if (isset($where['source_geo']) && $where['source_geo'] != "") {

                $whr['tl.source_geo'] = $where['source_geo'];

            }


            if (isset($where['source']) && $where['source'] != "") {

                $where1['tl.source'] = $where['source'];

            }

            if (isset($where['destination_geo']) && $where['destination_geo'] != "") {

                $whr['tl.destination_geo'] = $where['destination_geo'];

            }


            if (isset($where['destination']) && $where['destination'] != "") {

                $where1['tl.destination'] = $where['destination'];

            }

            if (isset($where['statusa']) && $where['statusa'] != "") {

                $where1['tl.status'] = $where['statusa'];

            }
            
             if (isset($where['fromdate']) && $where['fromdate'] != "") {
                $fromdate    = date('Y-m-d', strtotime($where['fromdate']));
                $whr["DATE_FORMAT(tl.created_on,'%Y-%m-%d') >="] = $fromdate;

            }
            if (isset($where['todate']) && $where['todate'] != "") {
                $todate      = date('Y-m-d', strtotime($where['todate']));
                $whr["DATE_FORMAT(tl.created_on,'%Y-%m-%d') <="] = $todate;

            }


            $whr['tl.user_id'] = $user_id;

            $data['lanes_list'] = $this->lanesmodel->getsearchdata($where1, $whr);

            $this->newtemplate->dashboard("lanes/index", $data);

        } else {

            $whr['tl.user_id'] = $this->session->userdata('user_id');

            $whr['tl.status'] = 1;

            $data['lanes_list'] = $this->lanesmodel->getsearchdata($where, $whr);

            $this->newtemplate->dashboard("lanes/index", $data);

        }

    }


    public function add()

    {

        $company_code = $this->session->userdata('company_code');

        $user_id = $this->session->userdata('user_id');

        $data['company_code'] = $company_code;

        $data['user_id'] = $user_id;

        $table = 'tb_geo_master';

        $whr = [

            "status" => 1

        ];

        $geo_master = $this->lanesmodel->selectlist('id,name', $table, $whr, 'name');

        $data['geo_master'] = $geo_master;


        $table1 = 'tbl_country_master';

        $whr1 = [

            "status" => 1

        ];

        $country_master = $this->lanesmodel->selectlist('country_name', $table1, $whr1, 'country_name');

        $data['country_master'] = $country_master;



        $data["page_title"] = $this->lang->line('bpartner_lanes');

        $data["sub_title"] = $this->lang->line('general_add');



        //$this->newtemplate->dashboard("lanes/add", $data);
        $this->load->view("lanes/add", $data);

    }



    public function update()

    {

        $id = $this->input->post('id');

        if (isset($id)) {

            $post = $this->input->post(NULL,TRUE);

            $user_id = $this->session->userdata('user_id');

            extract($post);

            $source_geo = isset($source_geo) ? $source_geo : 0;

            $source_country = isset($source_country) ? $source_country : "";

            $source = isset($source) ? $source : "";

            $company_code = isset($company_code) ? $company_code : "";

            $destination_geo = isset($destination_geo) ? $destination_geo : 0;

            $destination_country = isset($destination_country) ? $destination_country : "";

            $destination = isset($destination) ? $destination : '';

            $status = isset($status) ? $status : 0;

            $lane_id = isset($lane_id) ? $lane_id : "";

            $lane_name = isset($lane_name) ? $lane_name : "";

            if($source_geo == 2) {
                $source = $source_country;
            }


            if($destination_geo == 2) {
                $destination = $destination_country;
            }


            if ($id) {

                $where1['id !='] = $id;

            }

            $where1 = ['source_geo' => $source_geo,'source_country' => $source_country,'destination_geo' => $destination_geo,'destination_country'=>$destination_country,'user_id' => $user_id,'status'=> 1];

            $check_lane = $this->common->gettblrowdata($where1, '*', 'tb_lanes_master', 0, 0);

            if(empty($check_lane)){


            $data = [

                'lane_name' => $lane_name,

                'source_geo' => $source_geo,

                'source_country' => strtoupper($source_country),

                'source' => $source,

                'company_code' => $company_code,

                'destination_geo' => $destination_geo,

                'destination_country' => $destination_country,

                'destination' => $destination,

                'status' => $status

            ];

            $table = 'tb_lanes_master';

            $whr = [

                'id' => $id

            ];


            $result = $this->common->updatetbledata($table, $data, $whr);
            } else {
                $result = '2';
            }

            echo json_encode($result);

        }

    }



    public function edit($id)

    {

        $data["page_title"] = $this->lang->line('bpartner_lanes');

        $data["sub_title"] = $this->lang->line('general_edit');

        $user_id = $this->session->userdata('user_id');

        $company_code = $this->session->userdata('company_code');

        $data['company_code'] = $company_code;

        $data['user_id'] = $user_id;

        $table = 'tb_geo_master';

        $whr = [

            "status" => 1

        ];

        $geo_master = $this->lanesmodel->selectlist('id,name', $table, $whr, 'name');

        $data['geo_master'] = $geo_master;

        $table1 = 'tbl_country_master';

        $whr1 = [

            "status" => 1

        ];

        $country_master = $this->lanesmodel->selectlist('country_name', $table1, $whr1, 'country_name');

        $data['country_master'] = $country_master;

        $data['lane_edit_data'] = $this->lanesmodel->editdata($id);

        //$this->newtemplate->dashboard('lanes/edit', $data);
        $this->load->view("lanes/edit", $data);

    }



    public function view($id)

    {

        $data["page_title"] = $this->lang->line('bpartner_lanes');

        $data["sub_title"] = $this->lang->line('general_view');

        $data['lane_data'] = $this->lanesmodel->viewdata($id);

        //$this->newtemplate->dashboard('lanes/view', $data);
        $this->load->view("lanes/view", $data);

    }



    public function delete($id)

    {

        if ($id != '') {

            $this->db->where('id', $id);

            $this->db->set('status', 0);

            $result = $this->db->update('tb_lanes_master');

            if ($result) {

                echo "1";

            } else {

                echo "0";

            }

        }

    }



    public function check_lane()

    {

        $post = $this->input->post(NULL,TRUE);

        $lane_name = isset($post['lane_name']) ? $post['lane_name'] : "";

        $id = isset($post['id']) ? $post['id'] : "";

        $user_id = $this->session->userdata('user_id');

        $where = [

            'lane_name' => $lane_name,

            'user_id' => $user_id

        ];

        if ($id) {

            $where['id !='] = $id;

        }

        $check_lane_data = $this->common->gettblrowdata($where, '*', 'tb_lanes_master', 0, 0);

        if (empty($check_lane_data)) {

            echo "2";

        } else {

            echo "1";

        }

    }



    public function save()

    {

        $result = [];

        $post = $this->input->post(NULL,TRUE);

        extract($post);

        $lane_name = isset($lane_name) ? $lane_name : "";

        $source_geo = isset($source_geo) ? $source_geo : 0;

        $source_country = isset($source_country) ? $source_country : "";

        $source = isset($source) ? $source : "";

        $company_code = isset($company_code) ? $company_code : "";

        $destination_geo = isset($destination_geo) ? $destination_geo : 0;

        $destination_country = isset($destination_country) ? $destination_country : '';

        $destination = isset($destination) ? $destination : '';

        $user_id = $this->session->userdata('user_id');

        $lane_id = $this->laneidgen();

        if($source_geo == 2) {
            $source = $source_country;
        }

        if($destination_geo == 2) {
            $destination = $destination_country;
        }

        $where1 = ['source_geo' => $source_geo,'source_country' => $source_country,'source'=>$source,'destination_geo' => $destination_geo,'destination_country'=>$destination_country,'destination'=>$destination,'user_id' => $user_id,'status' => 1];

        $check_lane = $this->common->gettblrowdata($where1, '*', 'tb_lanes_master', 0, 0);
        if(empty($check_lane)) {

            $data = [

                'lane_id' => $lane_id,

                'lane_name' => $lane_name,

                'source_geo' => $source_geo,

                'source_country' => strtoupper($source_country),

                'source' => $source,

                'destination_geo' => $destination_geo,

                'destination_country' => $destination_country,

                'destination' => $destination,

                'company_code' => $company_code,

                'user_id' => $user_id,

                'status' => 1,

            ];

            $table = 'tb_lanes_master';

            $whr = [];

            $result = $this->common->insertTableData($table, $data);
        } else {
            $result = 2;
        }


        echo json_encode($result);

    }

    public function laneidgen()
    {
        $company_code = $this->session->userdata('company_code');
        $year = date('y');
        $week = date('W');
        $country_code = substr($company_code, 0, 2);
        $lane_res = $this->db->query("SELECT lane_id FROM tb_lanes_master ORDER BY id DESC LIMIT 1");
        if ($lane_res->num_rows() > 0) {
            $get_lane_id = $lane_res->row()->lane_id;
            $get_lane_id_c = strlen($get_lane_id);
            $previous_weeknumber = substr($get_lane_id, 6, 2);
            $get_lane_id1 = substr($get_lane_id, 8);
            $get_lane_id2 = ltrim($get_lane_id1, 0);
            if ($previous_weeknumber < $week) {
                    $id1 = '0001';
             } else {
               $i_id = $get_lane_id2;
               $i_id ++;
               $idlength = strlen($i_id);
               if ($idlength == '1') {
                   $id1 = "000" . $i_id;
               } else if ($idlength == '2') {
                   $id1 = "00" . $i_id;
               } else if ($idlength == '3') {
                   $id1 = "0" . $i_id;
               } else if ($idlength == '4') {
                   $id1 = $i_id;
               } else {
                   $id1 = $i_id;
               }
            }
            $lane_id1 = "LN" . $country_code . $year . $week . $id1;
            $chk = $this->db->query("select lane_id FROM tb_lanes_master WHERE lane_id='" . $lane_id1 . "'");
            if ($chk->num_rows() > 0) {
                $iid = $id1;
                $iid ++;
                $ii_d = $iid;
                $id_length = strlen($iid);
                if ($id_length == '1') {
                    $ii_d = "000" . $iid;
                } else if ($id_length == '2') {
                    $ii_d = "00" . $iid;
                } else if ($id_length == '3') {
                    $ii_d = "0" . $iid;
                } else if ($id_length == '4') {
                    $ii_d = $iid;
                } else {
                    $ii_d = $iid;
                }
                $lane_id1 = "LN" . $country_code . $year . $week . $ii_d;
            } else {
                $lane_id1 = $lane_id1;
            }
        } else {
            $i_id = 1;
            $id1 = '000' . $i_id;
            $lane_id1 = "LN" . $country_code . $year . $week . $id1;
        }
        return $lane_id1;

    }

    public function getlaneid(){

        $uid = $this->session->userdata('user_id');

        $lane_id = isset($_REQUEST["lane_id"])?$_REQUEST["lane_id"]:"";

        $data = [];

        $get_data = $this->db->query("SELECT lane_id FROM tb_lanes_master  WHERE lane_id like '%$lane_id%' and user_id='$uid'");

        if($get_data->num_rows() > 0){

            foreach ($get_data->result() as $get_data_f) {

                $data[] = $get_data_f->lane_id;

            }

        }

        echo json_encode($data);

    }


}
