<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Login extends CI_Controller
{
    public function __construct() {
        parent::__construct();
        $this->load->model("common");
    }

    public function index()
    {
        if ($this->session->userdata('user_id')) {
            redirect('home');
        }
        $defaultAccountType = 'Customer';
        $validAccountTypes = [
            'Customer',
            'Carrier',
            'Admin',
            'CountryAdmin',
            'AppAdmin',
        ];
        $currentAccountType = $this->session->flashdata('account_type') ?? $this->input->get('type', true);
        $data['account_type'] = in_array($currentAccountType, $validAccountTypes) ? $currentAccountType : $defaultAccountType;
        $data['page_title'] = 'Login';
        $this->settemplate->auth('login', $data);
    }

    private function isOps(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("(mobile_no ='" . $userName . "' OR emailid ='" . $userName . "' ) AND status ='Active'", "id,country_code,user_id,password,company_indv_name,business_type,company_code,branch_code,map_type,department_code", "kn_operators", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password, $allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('id', $userData['id']);
            $this->session->set_userdata('user_id', $userData['user_id']);
            $this->session->set_userdata('companyname', $userData['company_indv_name']);
            $this->session->set_userdata('business_type', $userData['business_type']);
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', $userData['branch_code']);
            $this->session->set_userdata('department_code', $userData['department_code']);
            $tzone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
            $this->session->set_userdata('usr_tzone', $tzone);
            $this->session->set_userdata('site_lang', 'english');
            $this->session->set_userdata('map_type', $userData['map_type']);
            $this->session->set_userdata('user_role_id', "5");
            $checkSubUsers = $this->common->gettbldata(['parent_id' => $userData['id'], 'status' => 'Active'], "id,user_id,company_code,branch_code,department_code", "kn_operators", 0, 0);
            if (!empty($checkSubUsers)) {
                $this->session->set_userdata('childId', '1');
                if ($userData['department_code'] != "") {
                    $usersWithDepartmentCodes[] = ['companyCode' => $userData['company_code'], 'branchCode' => $userData['branch_code'], 'departmentCode' => $userData['department_code']];
                } else {
                    $usersWithoutDepartment[] = ['companyCode' => $userData['company_code'], 'branchCode' => $userData['branch_code']];
                }
                foreach ($checkSubUsers as $eachLine) {
                    $departmentCode = $eachLine['department_code'];
                    if ($departmentCode != "") {
                        $usersWithDepartmentCodes[] = ['companyCode' => $eachLine['company_code'], 'branchCode' => $eachLine['branch_code'], 'departmentCode' => $departmentCode];
                    } else {
                        $usersWithoutDepartment[] = ['companyCode' => $eachLine['company_code'], 'branchCode' => $eachLine['branch_code']];
                    }
                    $knIds[] = $eachLine['id'];
                }
            } else {
                $this->session->set_userdata('childId', '0');
            }
            $this->session->set_userdata('usersWithoutDepartment', $usersWithoutDepartment ?? []);
            $this->session->set_userdata('knIds', $knIds ?? []);
            $this->session->set_userdata('usersWithDepartmentCodes', $usersWithDepartmentCodes ?? []);
            redirect("home");
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid login or password');
            $this->session->set_flashdata('account_type', $accountType);
            redirect('login');
        }
    }

    private function isAdmin(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $currentDate = date("Y-m-d H:i:s");
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("(mobile_no ='" . $userName . "' OR emailid ='" . $userName . "' ) AND mobile_no != 'appadmin' AND status ='Active'", "id,country_code,password,company_indv_name,business_type,company_code,branch_code,map_type,department_code", "tb_users", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('user_id', $userData['id']);
            $this->session->set_userdata('companyname', $userData['company_indv_name']);
            $this->session->set_userdata('business_type', $userData['business_type']);
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', $userData['branch_code']);
            $timeZone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
            $this->session->set_userdata('usr_tzone', $timeZone);
            $this->session->set_userdata('site_lang', 'english');
            $this->session->set_userdata('map_type', $userData['map_type']);
            $this->session->set_userdata('user_role_id', "2");
            $ip = @$this->input->ip_address();
            $logdt = ['user_id' => $userData['id'], 'user_type' => 1, 'activity_id' => 0, 'action_name' => "Admin Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Admin Login", "user_ip" => $ip, 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            $user = $this->db->where(["id" => $userData['id']])->update('tb_users', ["online" => 1]);
            redirect("home");
        } else {
            $allUsersData = $this->common->getjointbldata(
                "tb_users u",
                "tb_user_logins l",
                "u.id = l.user_id",
                "( l.emailid='" . $userName . "' OR l.mobile_no='" . $userName . "' ) AND u.status ='Active' AND l.status =1",
                "u.id,u.country_code,u.company_indv_name,u.business_type,
            u.company_code,u.branch_code,u.map_type,l.id as childid ,l.password",
                0,
                0
            );
            foreach ($allUsersData as $eachRow) {
                $usersData[$eachRow['id']] = $eachRow;
            }
            $userRowId = $this->checkUserPassword($password,$allUsersData);
            if ($userRowId > 0) {
                $userData = $usersData[$userRowId];
                $this->session->set_userdata('user_id', $userData['id']);
                $this->session->set_userdata('companyname', $userData['company_indv_name']);
                $this->session->set_userdata('business_type', $userData['business_type']);
                $this->session->set_userdata('company_code', $userData['company_code']);
                $this->session->set_userdata('branch_code', $userData['branch_code']);
                $timeZone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
                $this->session->set_userdata('usr_tzone', $timeZone);
                $this->session->set_userdata('site_lang', 'english');
                $this->session->set_userdata('map_type', $userData['map_type']);
                $this->session->set_userdata('user_role_id', "2");
                $this->session->set_userdata('childid', $userData['childid']);
                $ip = @$this->input->ip_address();
                $logdt = ['user_id' => $userData['id'], 'user_type' => 1, 'activity_id' => 0, 'action_name' => "Admin Login", 'child_id' => $userData['childid'], 'device_type' => 1, 'description' => "Admin Login", "user_ip" => $ip, 'status' => 1, 'createdon' => $currentDate];
                $ins = $this->db->insert("tb_user_activities", $logdt);
                $user = $this->db->where(["id" => $userData['id']])->update('tb_users', ["online" => 1]);
                redirect("home");
            } else {
                $this->session->set_flashdata('error_msg', 'Invalid login or password');
                $this->session->set_flashdata('account_type', $accountType);
                redirect('login');
            }
        }
    }

    private function isCustomer(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $currentDate = date("Y-m-d H:i:s");
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("(phone ='" . $userName . "' OR email_id ='" . $userName . "' OR code ='" . $userName . "') AND status ='1'", "id,name,code,password,country,user_id,company_code,branch_code,parent_id", "tb_customers", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('cust_id', $userData['id']);
            $this->session->set_userdata('user_id', $userData['user_id']);
            $this->session->set_userdata('customer_code', $userData['code']);
            $this->session->set_userdata('companyname', $userData['name']);
            $this->session->set_userdata('business_type', 'Customer');
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', $userData['branch_code']);
            $timeZone = $this->getUserTimeZone($userData['id'], $userData['country']);
            $this->session->set_userdata('usr_tzone', $timeZone);
            $this->session->set_userdata('site_lang', 'english');
            $utype1 = $this->db->select("map_type")->get_where("tb_users", ["id" => $userData['user_id']], 1, 0);
            if ($utype1->num_rows() > 0) {
                $this->session->set_userdata('map_type', $utype1->row()->map_type);
            } else {
                $this->session->set_userdata('map_type', '0');
            }
            $this->session->set_userdata('user_role_id', "4");
            if ($userData['parent_id'] == 0) {
                $getQuery = $this->db->query(
                    "SELECT id FROM tb_customers WHERE
                    parent_id='" . $userData['id'] . "'"
                );
                $subCustomer = [];
                if ($getQuery->num_rows() > 0) {
                    foreach ($getQuery->result() as $row) {
                        $subCustomer[] = $row->id;
                    }
                }
                if (!empty($subCustomer)) {
                    $this->session->set_userdata('sub_cust', $subCustomer);
                }
            } else {
                $this->session->set_userdata('subcustomer', '1');
            }
            $ip = @$this->input->ip_address();
            $logdt = ['user_id' => $userData['id'], 'user_type' => 3, 'activity_id' => 0, 'action_name' => "Customer Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Customer Login", "user_ip" => $ip, 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            $user = $this->db->where(["id" => $userData['id']])->update('tb_customers', ["online" => 1]);
            redirect("home");
        } else {
            $allUsersData = $this->common->gettbldata("(code ='" . $userName . "' OR email_id ='" . $userName . "') AND status ='1'", "id,name,countrycode,code,parent_id,user_id,password", "tb_customer_logins", 0, 0);
            foreach ($allUsersData as $eachRow) {
                $usersData[$eachRow['id']] = $eachRow;
            }
            $userRowId = $this->checkUserPassword($password,$allUsersData);
            if ($userRowId > 0) {
                $userData = $usersData[$userRowId];
                $this->session->set_userdata('cust_id', $userData['parent_id']);
                $this->session->set_userdata('child_id', $userData['id']);
                $this->session->set_userdata('user_id', $userData['user_id']);
                $this->session->set_userdata('companyname', $userData['name']);
                $this->session->set_userdata('business_type', 'Customer');
                $this->session->set_userdata('customer_code', $userData['code']);
                $timeZone = $this->getUserTimeZone($userData['id'], $userData['countrycode']);
                $this->session->set_userdata('usr_tzone', $timeZone);
                $custumerQuery = $this->db->select('company_code,branch_code')->get_where('tb_customers', ["id" => $userData['parent_id']], 1, 0);
                if ($custumerQuery->num_rows() > 0) {
                    $this->session->set_userdata('company_code', $custumerQuery->row()->company_code);
                    $this->session->set_userdata('branch_code', $custumerQuery->row()->branch_code);
                }
                $this->session->set_userdata('site_lang', 'english');
                $utype1 = $this->db->select("map_type")->get_where("tb_users", ["id" => $userData['user_id']], 1, 0);
                if ($utype1->num_rows() > 0) {
                    $this->session->set_userdata('map_type', $utype1->row()->map_type);
                } else {
                    $this->session->set_userdata('map_type', '0');
                }
                $this->session->set_userdata('user_role_id', "4");
                $ip = @$this->input->ip_address();
                $logdt = ['user_id' => $userData['parent_id'], 'user_type' => 3, 'activity_id' => 0, 'action_name' => "Customer Login", 'child_id' => $userData['id'], 'device_type' => 1, 'description' => "Customer Login", "user_ip" => $ip, 'status' => 1, 'createdon' => $currentDate];
                $ins = $this->db->insert("tb_user_activities", $logdt);
                $user = $this->db->where(["id" => $userData['parent_id']])->update('tb_customers', ["online" => 1]);
                redirect("home");
            } else {
                $this->session->set_flashdata('error_msg', 'Invalid login or password');
                $this->session->set_flashdata('account_type', $accountType);
                redirect('login');
            }
        }
    }

    private function isCountryAdmin(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $currentDate = date("Y-m-d H:i:s");
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("(mobile_no ='" . $userName . "' OR emailid ='" . $userName . "' ) AND status ='1'", "id,business_type,company_code,company_indv_name,password,country_code", "tb_admin_users", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('user_id', $userData['id']);
            $this->session->set_userdata('companyname', $userData['company_indv_name']);
            $this->session->set_userdata('business_type', $userData['business_type']);
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', "");
            $timeZone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
            $this->session->set_userdata('usr_tzone', $timeZone);
            $countryUsersData = $this->getCountryUsers($userData['id']);
            $this->session->set_userdata('country_users', $countryUsersData["users"]);
            $this->session->set_userdata('country_user_ids', $countryUsersData["user_ids"]);
            $this->session->set_userdata('site_lang', 'english');
            $this->session->set_userdata('map_type', '0');
            $this->session->set_userdata('user_role_id', "1");
            $logdt = ['user_id' => $userData['id'], 'user_type' => 0, 'activity_id' => 0, 'action_name' => "Country Admin Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Country Admin Login", 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            redirect("home");
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid login or password');
            $this->session->set_flashdata('account_type', $accountType);
            redirect('login');
        }
    }

    private function isAppAdmin(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $currentDate = date("Y-m-d H:i:s");
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("id='30' AND (mobile_no ='" . $userName . "' OR emailid ='" . $userName . "' ) AND status ='Active'", "id,country_code,company_indv_name,business_type,company_code,branch_code,map_type,password", "tb_users", 0, 0);
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $allUsersData[0];
            $this->session->set_userdata('user_id', $userData['id']);
            $this->session->set_userdata('companyname', $userData['company_indv_name']);
            $this->session->set_userdata('business_type', $userData['business_type']);
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', "");
            $timeZone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
            $this->session->set_userdata('usr_tzone', $timeZone);
            /*here country_users,country_user_ids will not be there, so updating as empty for below 2 session values*/
            $users = [];
            $user_ids = [];
            $cntryusrs = ["users" => $users, "user_ids" => $user_ids];
            $this->session->set_userdata('country_users', $cntryusrs["users"]);
            $this->session->set_userdata('country_user_ids', $cntryusrs["user_ids"]);
            $this->session->set_userdata('site_lang', 'english');
            $this->session->set_userdata('map_type', '0');
            $this->session->set_userdata('user_role_id', "1");
            $logdt = ['user_id' => $userData['id'], 'user_type' => 0, 'activity_id' => 0, 'action_name' => "Country Admin Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Country Admin Login", 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            redirect("home");
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid login or password');
            $this->session->set_flashdata('account_type', $accountType);
            redirect('login');
        }
    }

    private function isCarrier(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $currentDate = date("Y-m-d H:i:s");
        $accountType = $this->input->get_post('adminlogin-email');
        $allUsersData = $this->common->gettbldata("(mobile ='" . $userName . "' OR email ='" . $userName . "' OR code ='" . $userName . "') AND status ='1'", "id,name,mobile,country,email,user_id,company_code,branch_code,code,password", "tb_vendors", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('id', $userData['id']);
            $this->session->set_userdata('name', $userData['name']);
            $this->session->set_userdata('mobile', $userData['mobile']);
            $this->session->set_userdata('email', $userData['email']);
            $this->session->set_userdata('user_id', $userData['user_id']);
            $this->session->set_userdata('carrier_code', $userData['code']);
            $this->session->set_userdata('business_type', "Carrier");
            $this->session->set_userdata('companyname', $userData['name']);
            $cntry = $userData['country'];
            if ($userData['company_code'] != "") {
                $companycode = $userData['company_code'];
                $userData['company_code'] = substr($userData['company_code'], 0, 2);
                $this->session->set_userdata('company_code', $companycode);
            } else {
                $this->session->set_userdata('company_code', $userData['country']);
            }
            $this->session->set_userdata('branch_code', $userData['branch_code']);
            $timeZone = $this->getUserTimeZone($userData['user_id'], $cntry);
            $this->session->set_userdata('usr_tzone', $timeZone);
            $this->session->set_userdata('site_lang', 'english');
            $utype1 = $this->db->select("map_type")->get_where("tb_users", ["id" => $userData['user_id']], 1, 0);
            if ($utype1->num_rows() > 0) {
                $this->session->set_userdata('map_type', $utype1->row()->map_type);
            } else {
                $this->session->set_userdata('map_type', '0');
            }
            $this->session->set_userdata('user_role_id', "3");
            $logdt = ['user_id' => $userData['id'], 'user_type' => 2, 'activity_id' => 0, 'action_name' => "Carrier Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Carrier Login", 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            redirect("home");
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid login or password');
            $this->session->set_flashdata('account_type', $accountType);
            redirect('login');
        }
    }

    private function isCorpCustomer(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email'));
        $password = $this->input->get_post('adminlogin-password');
        $accountType = $this->input->get_post('adminlogin-email');
        $currentDate = date("Y-m-d H:i:s");
        $allUsersData = $this->common->gettbldata("(mobile_no ='" . $userName . "' OR emailid ='" . $userName . "' ) AND status ='1'", "id,business_type,company_code,company_indv_name,mobile_no,password,country_code", "tb_admin_users", 0, 0);
        foreach ($allUsersData as $eachRow) {
            $usersData[$eachRow['id']] = $eachRow;
        }
        $userRowId = $this->checkUserPassword($password,$allUsersData);
        if ($userRowId > 0) {
            $userData = $usersData[$userRowId];
            $this->session->set_userdata('user_id', $userData['id']);
            $this->session->set_userdata('companyname', $userData['company_indv_name']);
            $this->session->set_userdata('customer_code', $userData['mobile_no']);
            $this->session->set_userdata('business_type', $userData['business_type']);
            $this->session->set_userdata('company_code', $userData['company_code']);
            $this->session->set_userdata('branch_code', "");
            $tzone = $this->getUserTimeZone($userData['id'], $userData['country_code']);
            $this->session->set_userdata('usr_tzone', $tzone);
            $usersData = $this->getCountryUsers($userData['id']);
            $this->session->set_userdata('country_users', $usersData["users"]);
            $this->session->set_userdata('country_user_ids', $usersData["user_ids"]);
            $this->session->set_userdata('site_lang', 'english');
            $this->session->set_userdata('map_type', '0');
            $this->session->set_userdata('user_role_id', "6");
            $logdt = ['user_id' => $userData['id'], 'user_type' => 0, 'activity_id' => 0, 'action_name' => "Corp Customer Login", 'child_id' => 0, 'device_type' => 1, 'description' => "Corp Customer Login", 'status' => 1, 'createdon' => $currentDate];
            $ins = $this->db->insert("tb_user_activities", $logdt);
            redirect("home");
        } else {
            $this->session->set_flashdata('error_msg', 'Invalid login or password');
            $this->session->set_flashdata('account_type', $accountType);
            redirect('login');
        }
    }

    private function isDefaultType(): void
    {
        $this->session->set_flashdata('error_msg', 'Invalid request');
        redirect('login');
    }

    public function adminlogin(): void
    {
        $userName = $this->db->escape_str($this->input->get_post('adminlogin-email', true));
        $password = $this->passwordEncrypt($this->input->get_post('adminlogin-password', true));
        $accountType = $this->input->get_post('account_type', true);
        if (isset($_POST['log_type'])) {
            if ($_POST['log_type'] == "carrier") {
                $carrier_info = $this->db->query("SELECT * FROM tb_vendors WHERE (mobile='$userName' OR email ='$userName') AND status='1' AND password='$password'");
                if ($carrier_info->num_rows() > 0) {
                    $this->session->set_userdata('id', $carrier_info->row()->id);
                    $this->session->set_userdata('user_id', $carrier_info->row()->user_id);
                    $this->session->set_userdata('business_type', 'Carrier');
                    $this->session->set_userdata('site_lang', 'english');
                    $carrier_id = $this->input->post('carrier_id', true);
                    $tender_id = $this->input->post('tender_id', true);
                    $this->session->set_userdata('carrier_id', $carrier_id);
                    $this->session->set_userdata('tender_id', $tender_id);
                    $this->session->set_userdata('company_code', $carrier_info->row()->company_code);
                    $this->session->set_userdata('branch_code', $carrier_info->row()->branch_code);
                    $this->session->set_userdata('user_role_id', "3");
                    $utype1 = $this->db->select("map_type")->get_where("tb_users", ["id" => $carrier_info->row()->user_id], 1, 0);
                    if ($utype1->num_rows() > 0) {
                        $this->session->set_userdata('map_type', $utype1->row()->map_type);
                    } else {
                        $this->session->set_userdata('map_type', '0');
                    }
                    redirect('tender/carrier');
                }
            }
            redirect('login');
        }
        /* code from acceptance email check*/
        match ($accountType) {
            'Admin' => $this->isAdmin(),
            'Customer' => $this->isCustomer(),
            'CountryAdmin' => $this->isCountryAdmin(),
            'AppAdmin' => $this->isAppAdmin(),
            'Carrier' => $this->isCarrier(),
            'Ops' => $this->isOps(),
            'CorpCustomer' => $this->isCorpCustomer(),
            default => $this->isDefaultType()
        };
    }

    private function getCountryUsers($admin_user_id='')
    {
        $users = [];
        $user_ids = [];
        $users_query = $this->db->query("SELECT u.id,u.name,u.company_code,u.branch_code FROM tb_user_mappings m LEFT JOIN tb_users u on u.id = m.user_id WHERE m.admin_user_id='$admin_user_id' AND m.status='1' AND u.status='Active'");
        foreach($users_query->result() as $row){
            $users[] = array(
                "id" => $row->id,
                "company_code" => $row->company_code,
                "branch_code" => $row->branch_code,
                "name" => $row->name
            );
            $user_ids[] = $row->id;
        }
        return ["users"=>$users,"user_ids"=>$user_ids];
    }

    function getUserTimeZone(string $uid, string $cmpcode): array
    {
        $getqry = $this->db->query("SELECT country_name,country_code,cntry_timezone,cntry_hrs,currency,phone_code,is_panic_alert_required FROM tbl_country_master WHERE (country_code='" . $cmpcode . "' OR country_name='" . $cmpcode . "') AND status=1 LIMIT 1");
        if ($getqry && $getqry->num_rows() > 0) {
            return ["currency" => $getqry->row()->currency, "timezone" => $getqry->row()->cntry_timezone, "hrs" => $getqry->row()->cntry_hrs, 'country' => $getqry->row()->country_code, "phone_code" => $getqry->row()->phone_code, 'country_name' => $getqry->row()->country_name, 'is_panic_alert_required' => $getqry->row()->is_panic_alert_required];
        } else {
            throw new RuntimeException("login user's timezone is undefined.");
        }
    }

    private function checkUserPassword(string $password, array $userData): int
    {
        if(empty($userData)){
            return 0;
        }
        foreach ($userData as $eachRow) {
            $rowId = $eachRow['id'];
            $encryptedPassword = $eachRow['password'];
            if (password_verify($password, $encryptedPassword)) {
                return $rowId;
            }
        }
        return 0;
    }

    public function passwordEncrypt($str)
    {
        return password_hash($str, PASSWORD_DEFAULT);
    }
    function showpassword($str)
    {
        echo (($str));
    }
    function signup()
    {
        // $this->settemplate->innerpagesview('signup',"");
    }

    public function showuseractivity(){
        $udata = array();
        $data = $this->db->order_by("createdon","DESC")->get_where("tb_user_activities",array("status"=>1));
        foreach($data->result() as $res){
            $uname = $utype = $dtype = "";
            if($res->user_type == "1"){
                $utype1 = $this->db->select("name")->get_where("tb_users",array("id"=>$res->user_id),1,0);
                if($utype1->num_rows()>0){
                    $uname = $utype1->row()->name;
                }
                $utype = "Admin";
            }else if($res->user_type == "2"){
                $utype = "Carrier";
                $utype1 = $this->db->select("name")->get_where("tb_vendors",array("id"=>$res->user_id),1,0);
                if($utype1->num_rows()>0){
                    $uname = $utype1->row()->name;
                }
            }else if($res->user_type == "3"){
                $utype1 = $this->db->select("name")->get_where("tb_customers",array("id"=>$res->user_id),1,0);
                if($utype1->num_rows()>0){
                    $uname = $utype1->row()->name;
                }
                $utype = "Customer";
            }else{
                $utype1 = $this->db->select("name")->get_where("tb_users",array("id"=>$res->user_id),1,0);
                if($utype1->num_rows()>0){
                    $uname = $utype1->row()->name;
                }
                $utype = "Super Admin";
            }
            if($res->device_type == "1"){
                $dtype = "Desktop";
            }else{
                $dtype = "Mobile";
            }
            $udata[] = array("id"=>$res->user_id,"username"=>$uname,"user_type"=>$utype,"action_name"=>$res->action_name,"device_type"=>$dtype,"description"=>$res->description,"user_ip"=>$res->user_ip,"date"=>$res->createdon);
        }
        $message = "";
        if(count($udata)>0){
            $message .= "<table style='width:100%;' border='1'>";
            $message .= "<tr><th>ID</th> <th>Name</th> <th>User Type</th> <th>Action</th> <th>Device</th> <th>IP</th> <th>Date</th><th>Description</th></tr>";
            foreach($udata as $rr){
                $message .= "<tr>";
                $message .= "<td>".$rr['id']."</td>";
                $message .= "<td>".$rr['username']."</td>";
                $message .= "<td>".$rr['user_type']."</td>";
                $message .= "<td>".$rr['action_name']."</td>";
                $message .= "<td>".$rr['device_type']."</td>";
                $message .= "<td>".$rr['user_ip']."</td>";
                $message .= "<td>".$rr['date']."</td>";
                $message .= "<td>".$rr['description']."</td>";
                $message .= "</tr>";
            }
            $message .= "</table>";
        }
        echo $message;
    }
    /* getting kn admin users list under country admin user */
    public function knloginbycountryusr($knusrid){
        $roleid=$this->session->userdata('user_role_id');
        $cntryusrid=$this->session->userdata('user_id');
        $role_type = $this->session->userdata('business_type');
        if($roleid == 1 && $role_type == "Country Admin" && $knusrid != ""){
            /* unset country users sessions */
            $this->session->unset_userdata('country_users');
            $this->session->unset_userdata('country_user_ids');
            $user = $this->db->query("SELECT id,country_code,company_indv_name,business_type,company_code,branch_code,map_type FROM tb_users WHERE id=$knusrid AND status='Active' LIMIT 1");
            if($user->num_rows() > 0){
                $userID = $user->row_array();
                $this->session->set_userdata('user_id',$userID['id']);
                $this->session->set_userdata('companyname',$userID['company_indv_name']);
                $this->session->set_userdata('business_type',$userID['business_type']);
                $this->session->set_userdata('company_code',$userID['company_code']);
                $this->session->set_userdata('branch_code',$userID['branch_code']);
                $tzone = $this->getUserTimeZone($userID['id'],$userID['country_code']);
                $this->session->set_userdata('usr_tzone',$tzone);
                $this->session->set_userdata('site_lang','english');
                $this->session->set_userdata('map_type', $userID['map_type']);
                $this->session->set_userdata('user_role_id',"2");
                $this->session->set_userdata('country_admin_id',$cntryusrid);
                $curdt = date("Y-m-d H:i:s");
                $ip = @$this->input->ip_address();
                $logdt = array('user_id'=>$userID['id'], 'user_type'=>1, 'activity_id'=>0, 'action_name'=>"Admin Login", 'child_id'=>0, 'device_type'=>1, 'description'=>"Admin Login","user_ip"=>$ip, 'status'=>1, 'createdon'=>$curdt);
                $ins = $this->db->insert("tb_user_activities",$logdt);
                $user = $this->db->where(array("id"=>$userID['id']))->update('tb_users',array("online"=>1));
                redirect("home");
            }
        }else if($roleid == 2 && $knusrid != ""){
            $cntry_adm_id = $this->session->userdata('country_admin_id');
            if($cntry_adm_id == $knusrid){
                $sql = "SELECT * FROM tb_admin_users WHERE id=$knusrid AND status=1 LIMIT 1";
                $user = $this->db->query($sql);
                if($user->num_rows() > 0){
                    $userID = $user->row_array();
                    $this->session->set_userdata('user_id',$userID['id']);
                    $this->session->set_userdata('companyname',$userID['company_indv_name']);
                    $this->session->set_userdata('business_type',$userID['business_type']);
                    $this->session->set_userdata('company_code',$userID['company_code']);
                    $this->session->set_userdata('branch_code',"");
                    $tzone = $this->getUserTimeZone($userID['id'],$userID['country_code']);
                    $this->session->set_userdata('usr_tzone',$tzone);
                    $userData = $this->getCountryUsers($userID['id']);
                    $this->session->set_userdata('country_users',$userData["users"]);
                    $this->session->set_userdata('country_user_ids',$userData["user_ids"]);
                    $this->session->set_userdata('site_lang','english');
                    $this->session->set_userdata('map_type','0');
                    $this->session->set_userdata('user_role_id',"1");
                    $curdt = date("Y-m-d H:i:s");
                    $logdt = array('user_id'=>$userID['id'], 'user_type'=>0, 'activity_id'=>0, 'action_name'=>"Country Admin Login", 'child_id'=>0, 'device_type'=>1, 'description'=>"Country Admin Login", 'status'=>1, 'createdon'=>$curdt);
                    $ins = $this->db->insert("tb_user_activities",$logdt);
                    redirect("home");
                }
            }
        }
    }
}
