<?php

defined('BASEPATH') OR exit('No direct script access allowed');
require_once './vendor/autoload.php';

use phpseclib\Net\SSH2;
use phpseclib\Net\SFTP;

/*
 *  Rabbitmq
 */
use PhpAmqpLib\Connection\AMQPStreamConnection;
use PhpAmqpLib\Message\AMQPMessage;
use PhpAmqpLib\Connection\AMQPSSLConnection;
use PhpAmqpLib\Wire;

class MacadamTest extends CI_Controller {

    public function __construct() {
        parent::__construct();
    }

    public function index() {
        $this->test_d3_dms();
    }

    function test_d3_dms() {
        $this->load->library('D3_dms');
        $request = array(
            "branch_code" => '845624',
            "order_id" => '8686287762',
            "assoc_id" => "9705535967",
            "upload_type" => "POD | POP",
            "file_path" => './assets/poduploads/template3.png',
            'ref_value_kn_office'=>'12345456',
            'physical_sender' => '7981623150'
        );
        $documentid = $this->d3_dms->generate_jpl($request);
    }

    function macadam_status_test() {
        $this->load->library('Macadam_Status');
        $status_stage = 'PICKUP_GATE_IN';
        $data = array(
            "physicalreceiver"    => "physicalreceiver"   ,
            "logicalreceiver"     => "logicalreceiver"    ,
            "physicalsender"      => "physicalsender"     ,
            "logicalsender"       => "logicalsender"      ,
            "order_id"            => "order_id"           ,
            "assoc_id"            => "assoc_id"           ,
            "ref_value_kn_office" => "ref_value_kn_office",
            "city"                => "order_city",
            "current_date_time"   => "current date tie",
            "current_time"        => "current_time",
            "current_date"        => "current_date",
            "document_id"         => "document_id"        ,
            "picture_id"          => "picture_id"         ,
            "remark"              => "remark"             ,
            "missing_qty"         => "missing_qty"        ,
            "status_code"         => "status_code"        ,
            "upload_type"         => "upload_type"        ,
            "exception_code"      => "exception_code"     ,
            "pod_signee"          => "pod_signee"         ,
            "branch_code"         => "branch_code"        ,
            "company_code"        => "company_code"       ,
            "user_id"             => "1"            ,
            "device_id"           => 'device_id'
        );
        $this->macadam_status->macadam_status_hanlder($data, $status_stage);
    }

    function image_to_pdf($file = '') {
        if ($file == '') {
            $file = './assets/poduploads/macos_sierra_wallpaper_by_arnoldantonio_da6ahat.jpg';
        }
        require 'vendor/autoload.php';
        $mpdf = new \Mpdf\Mpdf([
            'tempDir' => FCPATH .'assets/tmp'
        ]);
        $size = getimagesize("$file");
        $width = $size[0];
        $height = $size[1];
        $mpdf->WriteHTML('');
        $mpdf->Image($file, 60, 50, $width, $height, 'jpg', '', true, true);
        $mpdf->Output('./assets/poduploads/test.pdf', 'F');
    }

    function rabbitmq_test() {
        /*$this->load->library('Macadam_Status');*/
        $status_stage = 'PICKUP_GATE_IN';
        $post = array(
            "physicalreceiver" => "1234",
            "logicalreceiver" => "5678",
            "physicalsender" => "9012",
            "logicalsender" => "3456",
            "company_code" => "C1234",
            "branch_code" => "4356C"
        );
        $request = $this->get_status_xml();
        $this->publishxml($request, $post);
    }

    public function publishxml($request, $post) {
        $this->load->library('uuid');
        $uuid = $this->uuid->v4();
        $ssl_options = array(
            'verify_peer' => false,
            'verify_peer_name' => false
        );
        $headers = new Wire\AMQPTable(array(
            'uuid' => $uuid,
            'KNESB_Routing_SenderId' => 'Svkonekt',
            'KNESB_Routing_ReceiverId' => 'macadam',
            'KN_MS_PhysRecvID' => 'KNALT01',
            'KN_MS_LogRecvID' => 'FRVSS02',
            'KN_MS_PhysSenderID' => 'KNETR09'
        ));
        $headers->set('short', -1024, Wire\AMQPTable::T_INT_SHORT);
        $connection = new AMQPSSLConnection('esb-test.int.kn', 5671, 'svkonekt','5QD4pmsk+gs+', 'esb-test', $ssl_options);
        $channel = $connection->channel();
        $Xmldata = new AMQPMessage($request,array('content_type' => 'Application/xml','delivery_mode' => AMQPMessage::DELIVERY_MODE_PERSISTENT));
        $Xmldata->set('application_headers', $headers);
        $channel->basic_publish($Xmldata,'e.road.roadstatusv0100test',null);
        $channel->close();
        $connection->close();
        echo "processdone....";
    }

    function get_status_xml() {
        return '<?xml version="1.0" encoding="UTF-8"?>
            <roadstatus:RoadStatus xmlns:roadstatus="http://knie4.int.kn/msg/roadstatus/0100" xmlns:DateUtil="com.surikat.mobility.common.util.DateUtil" xmlns:date="http://exslt.org/dates-and-times" xmlns:ext="http://exslt.org/common" xmlns:lhdr="http://knie4.int.kn/com/lhdr/0200" xmlns:lmlv="http://knie4.int.kn/com/lmlv/0200" xmlns:lpaci="http://knie4.int.kn/com/lpaci/0200" xmlns:lrcc="http://knie4.int.kn/msg/roadcarriercost/0100" xmlns:lref="http://knie4.int.kn/com/lref/0100" xmlns:lsts="http://knie4.int.kn/com/lsts/0200" xmlns:ltru="http://knie4.int.kn/com/ltru/0200" xmlns:ltypes="http://knie4.int.kn/com/ltypes/0200">
               <lhdr:MessageHeader>
                  <ReceiverDetails ltypes:AddressType="FW">
                     <PhysicalReceiver>KNALT01</PhysicalReceiver>
                     <LogicalReceiver>FRVSS02</LogicalReceiver>
                  </ReceiverDetails>
                  <PhysicalSender>KNETR09</PhysicalSender>
                  <LogicalSender>SEMND10</LogicalSender>
                  <SendingApplication>SVKONEKT</SendingApplication>
                  <MessageType>RoadStatus</MessageType>
                  <VersionNumber>0100</VersionNumber>
                  <CreationDateTime>2021-01-19T11:38:42Z</CreationDateTime>
               </lhdr:MessageHeader>
               <Message>
                  <lmlv:MessageLevel>
                     <TrackingNumber>21-01-0001831</TrackingNumber>
                     <SenderInformation>
                        <CompanyCode>KNFR</CompanyCode>
                        <BranchCode>FRVSS02</BranchCode>
                        <ModeOfTransport>1</ModeOfTransport>
                        <ExportImportFlag>1</ExportImportFlag>
                     </SenderInformation>
                     <MessageNumber>21-01-0001831</MessageNumber>
                     <MessageReferences ltypes:AddressType="FF">
                        <Code>INN</Code>
                        <Value>514260204</Value>
                     </MessageReferences>
                  </lmlv:MessageLevel>
                  <lsts:StatusInformation ltypes:StatusCode="0490">
                    <StatusDate>2021-01-19</StatusDate>
                    <StatusTime>11:38:42Z</StatusTime>
                    <StatusLocation ltypes:LocationIssuer="ZZZ">ST GAUDENS</StatusLocation>
                    <AdditionalStatusInformation>
                        <CreationIdentifier>X</CreationIdentifier>
                        <StatusEntryDateTime>2021-01-19T11:38:42Z</StatusEntryDateTime>
                        <UserIdentifier>9210ec43-4f33-4f6f-8afa-2db7e974044c</UserIdentifier>
                    </AdditionalStatusInformation>
                    <AdditionalRoadStatusInformation>
                        <DeviceId></DeviceId>
                        <User></User>
                    </AdditionalRoadStatusInformation>
                  </lsts:StatusInformation>
                  <Shipment>
                    <lref:ReferencesDetails ltypes:AddressType="FF">
                      Â <Code>TTY</Code>
                      Â <Value>CLL</Value>
                    </lref:ReferencesDetails>
                  </Shipment>
                  </Message>
            </roadstatus:RoadStatus>';
    }

}
