<?php
if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Macpaclabel extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->model('Aulabelmodel');
    }

    public function multiplelabels($ord_id)
    {
        require 'vendor/autoload.php';
        $data = $order_types = array();
        $data['carrier_img'] = "";
        $reference = $shipmentnumber = $communication_reference = $date = "";
        $drop_details['name'] = $drop_details['street'] = $drop_details['country'] = $drop_details['pincode'] = $shipper_details['name'] = $shipper_details['street'] = $shipper_details['country'] = $shipper_details['pincode'] = $shipper_details['city'] = $data['count'] = $data['weight'] = $data['delivery_ins'] = "";
        $cargos = $drop_details = $shipper_details = array();
        if (!empty($ord_id)) {
            /*
             * get cargo details
             */
            $c_where = array('r.id' => $ord_id,'r.status !='=>0);
            /*$cargoqry = $this->Aulabelmodel->getcargodetails($c_where);*/
            $cargos = $this->Aulabelmodel->getcargodetails($c_where);
            /**
             * Cargo is empty result set call manifest override function
             * 
             */
            $whr_barcode=['order_id'=>$ord_id,'status'=>1];
            $barcode_count= $this->Aulabelmodel->count_labels($whr_barcode);
            $total_barcodes=(int)$barcode_count['count_barcodes']??0;
            $cargo_count= $this->Aulabelmodel->count_cargos($c_where);
            $total_quantity=(int)$cargo_count['totqty']??0;
            if(empty($cargos) || $total_barcodes!=$total_quantity){
                $this->load->helper('aulabel_helper');
                $info = manifestoverride($ord_id);
                $cargos = $this->Aulabelmodel->getcargodetails($c_where);
            }
            /*
             * get barcodes
             */
            /* $cargos=$this->getcargos($cargoqry);*/

            if ($ord_id != "" && !empty($cargos)) {

                /*
                  * get delivery instructions
                 */
                $where = array(
                    "order_id" => $ord_id,
                    'status' => '1',
                    'reference_id' => 'ORD_DLVINST'
                );
                $select = "order_id,ref_value";
                $table = "tb_order_references";
                $data_ref = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                if (!empty($data_ref)) {
                    $data['delivery_ins'] = $data_ref['ref_value'];
                }

                /*
                * get routing detils
                 */
                $routingdata = $this->getroutingdetils($ord_id);
                $data = array_merge($routingdata, $data);
                /*
                * get carrier images
                */
                $crr_img = $this->getcarrierimgs($data['vendor_id']);
                $data = array_merge($data, $crr_img);
                /*
                * get carrier head ports
                */
                $headports = $this->getheadports($data);
                $data = array_merge($data, $headports);

                /*
                * get container number
                */
                $data['container_no'] = '';
                $reference = $this->common->gettblrowdata(array(
                    'order_id' => $ord_id,
                    'reference_id' => 'CTR'
                ), 'ref_value', 'tb_order_references', 0, 0);
                if (!empty($reference)) {
                    $data['container_no'] = $reference['ref_value'];
                }

                $data['reference'] = $reference;
                $data['cargos'] = $cargos;


                /*
                *  Barcode generator
                */
                $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
                $mpdf = new \Mpdf\Mpdf([
                    'tempDir' => FCPATH . 'assets/tmp',
                    'mode' => 'utf-8',
                    'format' => [
                        112.0,
                        152.0
                    ],
                    'margin_left' => 0,
                    'margin_right' => 0,
                    'margin_top' => 0,
                    'margin_bottom' => 0,
                    'margin_header' => 0,
                    'margin_footer' => 0
                ]);
                $html = "";
                $carton_number = 0;
                $data['count'] = count($cargos);
                $barcode_arr = array();
                //$cargo_total_quantity=0;
               // $cargo_total_quantity=;
                foreach ($cargos as $cargo) {
                    
                    if (!in_array($cargo['id'], $barcode_arr)) {
                        $barcode_arr[] = $cargo['id'];
                         //$cargo_total_quantity=$cargo['quantity']+$cargo_total_quantity;
                        if($cargo['quantity']>1){
                            $whr_barcode=['cargo_id'=>$cargo['cargo_id'],'status'=>1];
                            $barcodes = $this->Aulabelmodel->get_barcodes($whr_barcode);
                            $barcodes = array_column($barcodes, 'bar_code');
                            for ($i=0;$i<$cargo['quantity'];$i++){
                                $data['weight'] = $cargo['weight'];
                                $data['cargo_type'] = $cargo['cargo_type'];
                                $data['cargo_content'] = $cargo['cargo_content'];
                               
                               
                                $request_data = array(
                                    'order_id' => $ord_id,
                                    'cargo_id' => $cargo['id']
                                );
                                $get_cargo_qty = $this->gettotalcargos($request_data);
                                $data['qty'] = $total_quantity;
                                $data['no'] =$carton_number+1;
                                $data['caseid'] = $cargo['qr_code'];
                                $data['barcode_no'] = $barcodes[$i];
                                $data['label_create_date'] = $cargo['createdon'];
                                $html .= $this->load->view('aulabels/macpaclabel', $data, true);
                                $carton_number= $data['no'];
                            }
                        }else{
                                $data['weight'] = $cargo['weight'];
                                $data['cargo_type'] = $cargo['cargo_type'];
                                $data['cargo_content'] = $cargo['cargo_content'];

                                $request_data = array(
                                    'order_id' => $ord_id,
                                    'cargo_id' => $cargo['id']
                                );
                                $get_cargo_qty = $this->gettotalcargos($request_data);
                                $data['qty'] = $total_quantity;
                                $data['no'] = $carton_number+1;

                                $data['caseid'] = $cargo['qr_code'];
                                $data['barcode_no'] = $cargo['bar_code'];
                                $data['label_create_date'] = $cargo['createdon'];
                                $html .= $this->load->view('aulabels/macpaclabel', $data, true);
                        }
                        $carton_number= $data['no'];
                    }
                } 
               
                $data1['labelcontent'] = $html;
                $output = $this->load->view('orders/order_label', $data1, true);
                $mpdf->WriteHTML($output);
                $mpdf->Output($shipmentnumber . "_" . date('YmdHis') . ".pdf", 'I');
            }
        }
    }

    public function getcargos($cargodata)
    {
        $cargos =  array();
        if (!empty($cargodata)) {
            foreach ($cargodata as $cargo) {
                $barcodes = $this->common->gettblrowdata(array(
                    'cargo_id' => $cargo['cargo_id'],
                    'status' => 1
                ), 'bar_code,createdon', 'tb_order_cargo_labels', 0, 0);
                if (!empty($barcodes)) {
                    $cargos[] = array(
                        'weight' => $cargo['weight'],
                        'qty' => $cargo['quantity'],
                        'cargo_type' => $cargo['cargo_type'],
                        'cargo_content' => $cargo['cargo_content'],
                        'bar_code' => $barcodes['bar_code'],
                        'createdon' => $barcodes['createdon'],
                        'qr_code' => $cargo['qr_code'],
                        'id' => $cargo['id'] //imp
                    );
                }
            }
        }
        return $cargos;
    }
    
    private  function getroutingdetils($order_id)
    {
        $data = $shipper_details = $drop_details = array();
        $shipmentnumber = '';
        if (!empty($order_id)) {
            $chkorder = $this->Order->getordertoedit($order_id);
            if ($chkorder->num_rows() > 0) {
                $shipmentnumber = $chkorder->row()->order_id;
                $r_whr = array('p.status' => 1, 'o.order_id' => $order_id);
                $chekparty = $this->Aulabelmodel->routingdetils($r_whr);
                if (!empty($chekparty)) {
                    foreach ($chekparty as $rr) {
                        $ptype = $rr['party_type'];
                        $chktype = $this->db->select("name")->get_where("tbl_party_types", array(
                            "id" => $ptype
                        ), 1, 0);
                        if ($chktype->num_rows() > 0) {
                            if ($chktype->row()->name == "Consignee") {
                                $drop_details = array(
                                    'id' => $rr['id'],
                                    'name' => $rr['name'],
                                    'phone' => $rr['mobile'],
                                    'email' => $rr['email'],
                                    'fax' => $rr['fax'],
                                    'party_id' => $rr['code']
                                );
                            } else if ($chktype->row()->name == "Shipper") {
                                $shipper_details = array(
                                    'id' => $rr['id'],
                                    'name' => $rr['name'],
                                    'phone' => $rr['mobile'],
                                    'email' => $rr['email'],
                                    'fax' => $rr['fax'],
                                    'party_id' => $rr['code']
                                );
                            }
                        }
                    }
                }


                $data['delivery_date'] = date('d/m/Y', strtotime($chkorder->row()->delivery_datetime));
                $data['pickup_date'] = date('d/m/Y', strtotime($chkorder->row()->pickup_datetime));
                $data['consignment_no'] = $chkorder->row()->consignment_note;
                if(empty($data['consignment_no'])){
                    $data['consignment_no']=$chkorder->row()->order_id;
                }
                // $data['consignment_no'] = "SRGK100000";
                $shipper_details['name'] = $chkorder->row()->pickup;
                $shipper_details['street'] = $chkorder->row()->pickup_address1;
                $shipper_details['state'] = $chkorder->row()->pickup_address2;
                $shipper_details['city'] = $chkorder->row()->pickup_city;
                $shipper_details['country'] = $chkorder->row()->pickup_country;
                $shipper_details['pincode'] = $chkorder->row()->pickup_pincode;

                $drop_details['name'] = $chkorder->row()->delivery;
                $drop_details['street'] = $chkorder->row()->delivery_address1;
                $drop_details['state'] = $chkorder->row()->delivery_address2;
                $drop_details['city'] = $chkorder->row()->delivery_city;
                $drop_details['country'] = $chkorder->row()->delivery_country;
                $drop_details['pincode'] = $chkorder->row()->delivery_pincode;
                $data['drop_details'] = $drop_details;
                $data['shipper_details'] = $shipper_details;
                // $data['reference'] = $reference;
                $data['shipmentnumber'] = $shipmentnumber;
                $data['vendor_id'] = $chkorder->row()->vendor_id;
            }
        }
        return $data;
    }
    
    private function getcarrierimgs($id)
    {
        $data = array();
        if (!empty($id)) {
            $carrier_details = $this->common->gettblrowdata(array(
                'id' => $id
            ), 'name', 'tb_vendors', 0, 0);

            if (!empty($carrier_details)) {
                $data['carrier_name'] = ((isset($carrier_details['name'])) && (!empty($carrier_details['name']))) ? $carrier_details['name'] : '';

                $data['carrier_name'] = (strtoupper($data['carrier_name']) == "BORDER EXPRESS") ? "BEX" : $data['carrier_name'];
                $data['carrier_new_name'] = "";

                if (strtoupper($data['carrier_name']) == "BEX") {
                    $data['carrier_img'] = "BEX.jpg";
                    $data['carrier_new_name'] = "REGIONAL";
                } elseif (strtoupper($data['carrier_name']) == "BONDS TRANSPORT") {
                    $data['carrier_img'] = "Bonds.jpg";
                    $data['carrier_new_name'] = "METRO";
                } elseif (strtoupper($data['carrier_name']) == "BONDS DC") {
                    $data['carrier_img'] = "DC.jpg";
                    $data['carrier_new_name'] = "DC";
                } else {
                    $data['carrier_img'] = "";
                }
            }
        }
        return $data;
    }

    private function getheadports($h_data)
    {
        $data = array();
        $data['routecode'] = '';
        $routeinfo['routing_code'] = "";
        if ((!empty($h_data)) && (isset($h_data['carrier_name'])) && (!empty($h_data['carrier_name']))) {

            if ( $h_data['carrier_name'] == 'BONDS TRANSPORT') {
                $routeinfo = $this->common->gettblrowdata(array(
                    'correct_zip' => $h_data['drop_details']['pincode'],
                    'status' => 1,
                    'carrier_name' => 'Bonds'
                ), 'headport', 'tb_au_carrier_headports', 0, 0);
                $routeinfo['routing_code'] = $routeinfo['headport'];
            } else {
                $routeinfo = $this->common->gettblrowdata(array(
                    'postalcode' =>  $h_data['drop_details']['pincode'],
                    'status' => 1,
                    'type' => 2
                ), 'routing_code', 'tb_au_carrier_postalcodes', 0, 0);
            }
        }
        $data['routecode'] = !empty($routeinfo['routing_code']) ? $routeinfo['routing_code'] : '';
        return $data;
    }
    
    public function gettotalcargos($res_arr)
    {
        $res = array();
        $data = array(
            'carton_num' => 1,
            'carton_qty' => 1
        );

        if (!empty($res_arr)) {
            $order_id = $res_arr['order_id'];
            $cargo_id = $res_arr['cargo_id'];
            $chk = $this->db->select("id")
                ->order_by("id", "DESC")
                ->get_where("tb_order_cargodetails", array(
                    "order_id" => $order_id
                ));
            if ($chk->num_rows() > 0) {
                $res = $chk->result_array();
                $final_res = array_column($res, 'id');
                $carton_num = array_search($cargo_id, $final_res, true);
                $carton_num++;
                $carton_qty = count($res);
                $data = array(
                    'carton_num' => $carton_num,
                    'carton_qty' => $carton_qty
                );
            }
        }

        return $data;
    }
}
