<?php
if (! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Manifest extends CI_Controller
{

    public function __Construct()
    {
        parent::__Construct();
        $this->load->library('session');
        if ($this->session->userdata('user_id') == '') {
            redirect('login');
        }
        $this->load->model('Order');
        $this->load->model('common');
        $this->load->library('email');
        $this->load->model('Aumanifestmodel');
    }

    public function manifesttrip()
    {
        $input['company_code'] = $this->session->userdata('company_code');

        if($input['company_code'] == 'KNAU'){ // server side validation for carrier name (if select box not selected)
            $selected_carrier =  $this->input->post('carrier_0', true);
            if(isset($selected_carrier) && empty($selected_carrier)) {
                $this->session->set_flashdata('error_msg', 'Please Select Carrier Name');
                redirect('orders');
            }
        }

        $orderids = $this->input->post('orderids');
        $orders = explode(',', $this->input->post('orderids'));
        foreach ($orders as $order) {
            $orderinfo = $this->common->gettblrowdata(array(
                'id' => $order
            ), 'vendor_id', 'tb_orders', 0, 0);
            if($input['company_code'] == 'KNAU' && empty($orderinfo['vendor_id'])){
                $orderinfo['vendor_id'] = $this->input->post('carrier_0', true);  //Carrier id from Popup (select box)
                $this->common->updatetbledata("tb_orders", array(
                    'vendor_id' => $orderinfo['vendor_id']
                ), array(
                    "id" => $order
                ));
            }
        }
        $response = 0;
        $userid = $this->session->userdata('user_id');
        $curtz = $this->session->userdata("usr_tzone")['timezone'];
        $logdate = date('Y-m-d H:i:s');
        $getactual = getdatetimebytimezone(DFLT_TZ, $logdate, $curtz);
        $curdt = $getactual['datetime'];
        $files = $edi_res = array();
        $input['user_id'] = $userid;
        $input['curtz'] = $curtz;
        $input['curdt'] = $curdt;
        $input['branch_code'] = $this->session->userdata('branch_code');
        $error_msg = '';
        $ordquery = $this->db->query('select group_concat(id) orderids from tb_orders where id in (' . $orderids . ') GROUP BY vendor_id order by vendor_id desc');
        $ordquery = $ordquery ? $ordquery->result_array() : [];
        foreach ($ordquery as $li) {
            $files[] = $this->generatemanifest($li['orderids']);
        }
        $this->session->set_userdata('download_files', $files);
        $this->load->helper('bonds_helper');
        foreach ($orders as $order) {
            $orderinfo = $this->common->gettblrowdata(array(
                'id' => $order
            ), 'vendor_id', 'tb_orders', 0, 0);
            $vendor_id = $orderinfo['vendor_id'];
            $input['ordid'] = $order;
            $input['carrierid'] = $vendor_id;
            $input['vehicle_type'] = $this->input->post('vehicle_type_' . $vendor_id);
           
            $vendor =array();
            if(SYS_TYPE == 'TMS'){
                $vendor = checkbondsCarrier($input['carrierid']);
            }
            if (! empty($vendor)) {
                $chkrefbn = $this->common->gettblrowdata(array(
                    'order_id' => $order,
                    'reference_id' => 'BN'
                ), "id,ref_value", "tb_order_references", 0, 0);
                /* log('error', "bn vallue::" . json_encode($chkrefbn)); */
                if (empty($chkrefbn)) {
                    $edi_res = bondsBooking(array(
                        'ordid' => $order,
                        'vehicle_type' => $input['vehicle_type']
                    ), 'generated');

                    if ($edi_res['status'] == 0) {
                        $orderinfo = $this->common->gettblrowdata(array(
                            'id' => $order
                        ), 'order_id', 'tb_orders', 0, 0);
                        $error_msg .= "Bonds Couriers Errors for order #" . $orderinfo['order_id'];
                        if(isset($edi_res['errors'])){
                            foreach ($edi_res['errors'] as $error) {
                                if (is_array($error)) {
                                    foreach ($error as $er) {
                                        $error_msg .= '<p>' . $er . '</p>';
                                    }
                                } else {
                                    $error_msg .= '<p>' . $error . '</p>';
                                }
                            }
                        }
                    }
                }
            }
            $response = $this->tripcreatemultiorder($input);
        }
        if ($response == 1) {
            $this->session->set_flashdata('success_msg', 'Trip Created Successfully.');
        } else if ($response == 2) {
            $this->session->set_flashdata('error_msg', 'Your selected orders are not in same root.(example: Ref. ID (ROT))');
        } else {
            $this->session->set_flashdata('error_msg', 'Oops..Something Went Wrong.');
        }
        redirect('orders');
    }

     public function tripcreatemultiorder($input)
    {
        $response = 0;
        $userid = $input['user_id'];
        $curtz = $input['curtz'];
        $logdate = $ordcreated = date('Y-m-d H:i:s');
        $curdt = $input['curdt'];
        $year = date('y');
        $week = date('W');
        $coun_sess = $input['company_code'];
        $count_code = substr($coun_sess, 0, 2);
        $where = " id IN(" . $input['ordid'] . ")";
        $select = "*";
        $table = "tb_orders";
        $orders = $this->common->gettbldata($where, $select, $table, 0, 0);
        $seq_num = 000001;
        $ordcnt = count($orders);
        if ($ordcnt > 0) {
            $order_nm = $orders[0]['order_id'];
            $seq_num = substr($order_nm, - 6);
            $shipid = "T" . $count_code . $week . $year . $seq_num;
            $vendor_id = $input['carrierid'];
            $vehicle_id = isset($input['tvehnum']) ? $input['tvehnum'] : "";
            $driver_id = isset($input['tdrivernum']) ? $input['tdrivernum'] : "";
            $tpvehicle_type = isset($input['vehicle_type']) ? $input['vehicle_type'] : 0;
            $carrier_instructions = isset($input['carrier_instructions']) ? $input['carrier_instructions'] : "";
            $vehicle_type = "";
            if ($shipid != "" && $vendor_id > 0) {
                $i = $j = 0;
                $weight = 0;
                $volume = 0;
                $quantity = 0;
                foreach ($orders as $order) {
                    $j ++;
                    $i ++;
                    $ordid = $order['id'];
                    $ordcreated = $order['createdon'];
                    $pickup = $order['pickup_address1'];
                    if ($pickup == "") {
                        $pickup = $order['pickup_city'];
                    }
                    $delivery = $order['delivery_address1'];
                    if ($delivery == "") {
                        $delivery = $order['delivery_city'];
                    }
                    $address = $dropaddr = "";
                    if ($order['pickup_address1'] != "") {
                        $address .= $order['pickup_address1'];
                        $dropaddr .= $order['delivery_address1'];
                    }
                    if ($order['pickup_company'] != "") {
                        $address .= ", " . $order['pickup_company'];
                        $dropaddr .= ", " . $order['delivery_company'];
                    }
                    if ($order['pickup_country'] != "") {
                        $address .= ", " . $order['pickup_country'];
                        $dropaddr .= ", " . $order['delivery_country'];
                    }
                    if ($order['pickup_city'] != "") {
                        $address .= ", " . $order['pickup_city'];
                        $dropaddr .= ", " . $order['delivery_city'];
                    }
                    if ($order['pickup_pincode'] != "") {
                        $address .= ", " . $order['pickup_pincode'];
                        $dropaddr .= ", " . $order['delivery_pincode'];
                    }
                    if ($order['weight'] == "") {
                        $order['weight'] = 1;
                    }
                    if ($order['volume'] == "") {
                        $order['volume'] = 1;
                    }
                    if ($order['quantity'] == "") {
                        $order['quantity'] = 1;
                    }
                    $weight += $order['weight'];
                    $volume += $order['volume'];
                    $quantity += $order['quantity'];
                    $plat = $order['plat'];
                    $plng = $order['plng'];
                    $dlat = $order['dlat'];
                    $dlng = $order['dlng'];
                    $where = array(
                        "shipmentid" => $shipid
                    );
                    $select = "id,splace,slat,slng,eplace,elat,elng,vendor_id,weight,volume,units,vehicle_type";
                    $table = "tb_shifts";
                    $shipment = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($shipment) == 0) {
                        $customer_id = $order['customer_id'];
                        $transport_mode = $order['transport_mode'];
                        $txnid = $shipid;
                        if ($tpvehicle_type != '' && $tpvehicle_type != 0) {
                            $vtwhere = array(
                                "id" => $tpvehicle_type
                            );
                            $vtselect = "trucktype";
                            $vttable = "tb_trucktypes";
                            $vtorder = $this->common->gettblrowdata($vtwhere, $vtselect, $vttable, 0, 0);
                            if (count($vtorder) > 0) {
                                $vehicle_type = $vtorder['trucktype'];
                            } else {
                                $vehicle_type = $order['vehicle_type'];
                            }
                        } else {
                            $vehicle_type = $order['vehicle_type'];
                        }
                        $startdate = $order['pickup_datetime'];
                        $starttime = date('H:i', strtotime($startdate));
                        $enddate = $order['delivery_datetime'];
                        $endtime = date('H:i', strtotime($enddate));
                        $insarr = array(
                            'user_id' => $userid,
                            'stime' => $starttime,
                            'etime' => $endtime,
                            'splace' => $order['pickup_city'],
                            'slat' => $plat,
                            'slng' => $plng,
                            'eplace' => $order['delivery_city'],
                            'elat' => $dlat,
                            'elng' => $dlng,
                            'scity' => $order['pickup_city'],
                            'dcity' => $order['delivery_city'],
                            'zone_id' => 1,
                            'empshift_start' => $starttime,
                            'empshift_end' => $endtime,
                            'trip_type' => 0,
                            'startdate' => $startdate,
                            'enddate' => $enddate,
                            'shipment_name' => 'Boxes',
                            'shipment_id' => 0,
                            'transport_mode' => $transport_mode,
                            'customer_id' => $customer_id,
                            'vendor_id' => $vendor_id,
                            'carrier_type' => 0,
                            'shipmentid' => $shipid,
                            'txnid' => $txnid,
                            'weight' => $weight,
                            'volume' => $volume,
                            'units' => $quantity,
                            'domainname' => 'INFD',
                            'vehicle_type' => $vehicle_type,
                            'company_code' => $order['company_code'],
                            'branch_code' => $order['branch_code'],
                            'carrier_instructions' => $carrier_instructions,
                            'status' => 1
                        );
                        $ship_id = $this->common->insertTableData("tb_shifts", $insarr);
                    } else {
                        if ($ordcnt == $j) {
                            $enddate = $order['delivery_datetime'];
                            $endtime = date('H:i', strtotime($enddate));
                            $updarr = array(
                                'etime' => $endtime,
                                'eplace' => $order['delivery_city'],
                                'elat' => $dlat,
                                'elng' => $dlng,
                                'dcity' => $order['delivery_city'],
                                'empshift_end' => $endtime,
                                'enddate' => $enddate,
                                'weight' => $weight,
                                'volume' => $volume,
                                'units' => $quantity,
                                'carrier_instructions' => $carrier_instructions
                            );
                            $upd = $this->common->updatetbledata("tb_shifts", $updarr, array(
                                "id" => $shipment['id']
                            ));
                        }
                        $ship_id = $shipment['id'];
                    }
                    /* update order table */
                    $upddt = array(
                        'vendor_id' => $vendor_id,
                        'shift_id' => $ship_id,
                        "shipmentid" => $shipid,
                        'status' => 2
                    );
                    $updwhr = array(
                        "id" => $ordid
                    );
                    $upd = $this->common->updatetbledata("tb_orders", $upddt, $updwhr);
                    $this->ordernotify('trip_create', $ordid);
                    $capacity = $order['weight'];
                    if ($capacity == "") {
                        $capacity = "0";
                    }
                    /* insert stops records */
                    $where = array(
                        "shipment_id" => $ship_id,
                        'plat' => $plat,
                        'plng' => $plng,
                        "stopcity" => $order['pickup_city'],
                        "stoptype" => "P"
                    );
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = array(
                            'stopname' => $order['pickup_city'],
                            'plat' => $plat,
                            'plng' => $plng,
                            'stopcity' => $order['pickup_city'],
                            'address' => $address,
                            'stoptype' => 'P',
                            'stopstatus' => 0,
                            'shipment_id' => $ship_id,
                            'ordernumber' => $j,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['pickup_endtime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $curdt
                        );
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $pickupstop_id = $this->db->insert_id();
                    } else {
                        $pickupstop_id = $chkstop['id'];
                    }
                    $where = array(
                        "shipment_id" => $ship_id,
                        'plat' => $dlat,
                        'plng' => $dlng,
                        "stopcity" => $order['delivery_city'],
                        "stoptype" => "D"
                    );
                    $select = "id";
                    $table = "tb_shiporder_stops";
                    $chkstop = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkstop) == 0) {
                        $insarr = array(
                            'stopname' => $order['delivery_city'],
                            'plat' => $dlat,
                            'plng' => $dlng,
                            'stopcity' => $order['delivery_city'],
                            'address' => $dropaddr,
                            'stoptype' => 'D',
                            'stopstatus' => 0,
                            'shipment_id' => $ship_id,
                            'ordernumber' => $i + 1,
                            'startdate' => $order['delivery_datetime'],
                            'enddate' => $order['drop_endtime'],
                            'weight' => $order['weight'],
                            'volume' => $order['volume'],
                            'shipmentstopid' => 0,
                            'ship_units' => $order['quantity'],
                            'txncode' => 'NP',
                            'status' => 1,
                            'created_on' => $curdt
                        );
                        $ins = $this->db->insert("tb_shiporder_stops", $insarr);
                        $dropstop_id = $this->db->insert_id();
                    } else {
                        $dropstop_id = $chkstop['id'];
                    }
                    /* add pickupstop and drop stop id into details/tb_employee table */

                    $where = array(
                        'stop_id' => $pickupstop_id,
                        'drop_stopid' => $dropstop_id,
                        'order_id' => $order['order_id'],
                        'shift_id' => $ship_id
                    );
                    $select = "id";
                    $table = "tb_employee";
                    $chkemp = $this->common->gettblrowdata($where, $select, $table, 0, 0);
                    if (count($chkemp) == 0) {
                        $insarr = array(
                            'assoc_id' => $shipid,
                            'pickup' => $pickup,
                            'plat' => $plat,
                            'plng' => $plng,
                            'drop' => $delivery,
                            'dlat' => $dlat,
                            'dlng' => $dlng,
                            'pickup_city' => $order['pickup_city'],
                            'drop_city' => $order['delivery_city'],
                            'pickup_datetime' => $order['pickup_datetime'],
                            'drop_datetime' => $order['delivery_datetime'],
                            'name' => 'Boxes',
                            'phone' => $order['customer_phone'],
                            'address' => $address,
                            'emailid' => $order['customer_email'],
                            'user_id' => $userid,
                            'status' => 1,
                            'createdon' => $curdt,
                            'material_id' => 0,
                            'capacity' => $capacity,
                            'information' => $order['customer_comments'],
                            'shipment_weight' => $order['weight'],
                            'shipment_volume' => $order['volume'],
                            'ship_type' => 'P',
                            'customer_id' => $order['customer_id'],
                            'vendor_id' => $vendor_id,
                            'shipment_id' => 0,
                            'startdate' => $order['pickup_datetime'],
                            'enddate' => $order['delivery_datetime'],
                            'shift_id' => $ship_id,
                            'stop_order' => 1,
                            'drop_order' => 0,
                            'basic_stop' => 0,
                            'stop_id' => $pickupstop_id,
                            'drop_stopid' => $dropstop_id,
                            'order_id' => $order['order_id'],
                            'pkgitemid' => 'BOXES',
                            'no_of_pkgs' => $order['quantity'],
                            'domainname' => 'INFD'
                        );
                        $detail_id = $this->common->insertTableData("tb_employee", $insarr);
                    } else {
                        $detail_id = $chkemp['id'];
                    }
                    $sql = "SELECT oc.id,oc.quantity,oc.width,oc.height,oc.length,oc.weight,im.unit_name FROM tb_order_cargodetails oc,tbl_shipunit_types im WHERE oc.order_id = ? AND im.id = oc.handling_unit AND oc.status='1'";
                    $stops_units = $this->db->query($sql, [$ordid]);
                    if ($stops_units->num_rows() > 1) {
                        $odata = $stops_units->row();
                        $sql = "UPDATE tb_order_cargodetails set stop_detail_id=? WHERE id =?";
                        $upd = $this->db->query($sql, [$detail_id,$odata->id]);
                    }
                    $chk1 = $this->db->select("id")->get_where("tb_shft_veh", array(
                        "shft_id" => $ship_id
                    ), 1, 0);
                    if ($chk1->num_rows() > 0) {
                        $shftvehid = $chk1->row()->id;
                        $chk = $this->db->select("id")->get_where("tb_shft_veh_emp", array(
                            "shft_veh_id" => $shftvehid,
                            "status" => 1
                        ), 1, 0);
                        if ($chk->num_rows() == 0) {
                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array(
                                "shift_id" => $ship_id
                            ));
                            if ($getemp->num_rows() > 0) {
                                $pri = 1;
                                foreach ($getemp->result() as $gt) {
                                    $insveh1 = array(
                                        "user_id" => $userid,
                                        "shft_veh_id" => $shftvehid,
                                        "emp_id" => $gt->id,
                                        "priority" => $pri,
                                        "pickup_time" => $gt->pickup_datetime,
                                        'created_on' => $curdt,
                                        'updated_on' => $curdt,
                                        "status" => 1,
                                        "drop_time" => $gt->drop_datetime
                                    );
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    $pri ++;
                                }
                            }
                        } else {
                            $chkemp = $this->db->select("id")->get_where("tb_shft_veh_emp", array(
                                "shft_veh_id" => $shftvehid,
                                "emp_id" => $detail_id,
                                "status" => 1
                            ), 1, 0);
                            if ($chkemp->num_rows() == 0) {
                                $insveh1 = array(
                                    "user_id" => $userid,
                                    "shft_veh_id" => $shftvehid,
                                    "emp_id" => $detail_id,
                                    "priority" => 3,
                                    "pickup_time" => $order['pickup_datetime'],
                                    'created_on' => $curdt,
                                    'updated_on' => $curdt,
                                    "status" => 1,
                                    "drop_time" => $order['delivery_datetime']
                                );
                                $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                            }
                        }
                    } else {
                        if ($vehicle_id != "") {
                            $veh_num = isset($input['vehicle_id']) ? $input['vehicle_id'] : "";
                            $arr = array(
                                'user_id' => $userid,
                                'route_id' => 0,
                                'shft_id' => $ship_id,
                                'carrier_id' => $vendor_id,
                                'vehicle_id' => $vehicle_id,
                                'register_number' => $veh_num,
                                'created_on' => $curdt,
                                'updated_on' => $curdt,
                                'status' => 1
                            );
                            $shftvehid = $this->common->insertTableData("tb_shft_veh", $arr);
                            $getemp = $this->db->select("id,pickup_datetime,drop_datetime")->get_where("tb_employee", array(
                                "shift_id" => $ship_id
                            ));
                            if ($getemp->num_rows() > 0) {
                                $pri = 1;
                                foreach ($getemp->result() as $gt) {
                                    $insveh1 = array(
                                        "user_id" => $userid,
                                        "shft_veh_id" => $shftvehid,
                                        "emp_id" => $gt->id,
                                        "priority" => $pri,
                                        "pickup_time" => $gt->pickup_datetime,
                                        'created_on' => $curdt,
                                        'updated_on' => $curdt,
                                        "status" => 1,
                                        "drop_time" => $gt->drop_datetime
                                    );
                                    $ins = $this->common->insertTableData("tb_shft_veh_emp", $insveh1);
                                    $pri ++;
                                }
                            }
                        }
                    }
                    if ($vehicle_id != "" && $driver_id != "") {
                        $chk = $this->db->select("id,driver_id,status")
                            ->order_by("id", "DESC")
                            ->get_where("tb_vehicles_drivers", array(
                            "vehicle_id" => $vehicle_id
                        ));
                        if ($chk->num_rows() > 0) {
                            if ($driver_id == $chk->row()->driver_id) {
                                $upd = $this->db->where(array(
                                    "id" => $chk->row()->id
                                ))
                                    ->update("tb_vehicles_drivers", array(
                                    "status" => 1
                                ));
                            } else {
                                $arr = array(
                                    'vehicle_id' => $vehicle_id,
                                    'driver_id' => $driver_id,
                                    'imei' => "",
                                    'status' => 1,
                                    'createdon' => $curdt,
                                    'updatedon' => $curdt
                                );
                                $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                            }
                        } else {
                            $arr = array(
                                'vehicle_id' => $vehicle_id,
                                'driver_id' => $driver_id,
                                'imei' => "",
                                'status' => 1,
                                'createdon' => $curdt,
                                'updatedon' => $curdt
                            );
                            $ins = $this->common->insertTableData("tb_vehicles_drivers", $arr);
                        }
                        $chk11 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                            "driver_id" => $driver_id,
                            "vehicle_id" => $vehicle_id
                        ), 1, 0);
                        if ($chk11->num_rows() > 0) {
                            $upd = $this->db->where(array(
                                "id" => $chk11->row()->id
                            ))
                                ->update("tbl_assigned_drivers", array(
                                "status" => "1",
                                'updated_on' => $curdt
                            ));
                        } else {
                            $chk111 = $this->db->select("id")->get_where("tbl_assigned_drivers", array(
                                "driver_id <>" => $driver_id,
                                "vehicle_id" => $vehicle_id,
                                "status" => 1
                            ), 1, 0);
                            if ($chk111->num_rows() == 0) {
                                
                                $imei=0;
                                $ins = $this->common->insertTableData("tbl_assigned_drivers", array(
                                    "vehicle_id" => $vehicle_id,
                                    "user_id" => $userid,
                                    "driver_id" => $driver_id,
                                    "mobile_no" => $driver_id,
                                    "imei" => $imei,
                                    "from_time" => $curdt,
                                    "to_time" => $curdt,
                                    "status" => "1",
                                    'created_on' => $curdt
                                ));
                            } else {
                                $upd = $this->db->where(array(
                                    "id" => $chk111->row()->id
                                ))
                                    ->update("tbl_assigned_drivers", array(
                                    "driver_id" => $driver_id,
                                    'updated_on' => $curdt
                                ));
                            }
                        }
                    }
                    $response = 1;
                    /* update status */
                    $chk = $this->db->select("id")->get_where("tb_stop_status", array(
                        "shipment_id" => $ship_id,
                        "status_id" => 9
                    ), 1, 0);
                    if ($chk->num_rows() == 0) {
                        $ins = array(
                            "shipment_id" => $ship_id,
                            "stop_id" => 0,
                            "stop_detail_id" => 0,
                            "stop_type" => "",
                            "trip_id" => 0,
                            "status_id" => 9,
                            "status" => 1,
                            "status_code" => "0100",
                            "order_id" => $ordid,
                            "reason" => "Coming from E-Booking",
                            "createdon" => $ordcreated
                        );
                        $insqry = $this->common->insertTableData("tb_stop_status", $ins);
                    }
                    $company_code = $coun_sess;

                    $this->load->helper('border_helper');
                    
                    $vendor_check=array();
                    if(SYS_TYPE == 'TMS'){
                     $vendor_check = checkborderCarrier($vendor_id);
                    }
                    if ((in_array($company_code, ["AUKN", "KNAU"], true)) && ! empty($vendor_check)) {
                        borderconsignment(array(
                            'ordid' => $ordid
                        ));
                    }
                }
            }
        }
        return $response;
    }

    public function ordernotify($action, $orderid)
    {
        $this->load->library('notifytrigger');
        $info['page_title'] = 'Booking Notification';
        $info['subject'] = 'Booking Notification';
        $info['order_id'] = $orderid;
        $info['action'] = $action;
        $orderinfo = $this->common->gettblrowdata(array(
            'id' => $orderid
        ), 'order_id,shift_id', 'tb_orders', 0, 0);
        if ($orderinfo) {
            $info['orderid'] = $orderinfo['order_id'];
            $info['cargos'] = $this->common->gettbldata(array(
                'order_id' => $orderid
            ), 'quantity_type,quantity', 'tb_order_cargodetails', 0, 0);
            if ($action != 'trip_create') {
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendordernotify($info);
            } else {
                $info['shift_id'] = $orderinfo['shift_id'];
                $shipinfo = $this->common->gettblrowdata(array(
                    'id' => $info['shift_id']
                ), 'shipmentid', 'tb_shifts', 0, 0);
                $info['shiftid'] = (! empty($shipinfo['shipmentid'])) ? $shipinfo['shipmentid'] : '';
                $info['body'] = $this->load->view('mail_forms/notifytrigger/' . $action, $info, true);
                $this->notifytrigger->sendtripnotify($info);
            }
        }
    }

    public function generatemanifest($orderids)
    {
        $this->load->model('common');
        $this->load->model('truckwaybillmodel');
        $this->load->helper('bonds_helper');
        $data =$palletData= array();
        $sql = "select ref_value from tb_order_references where reference_id = 'MN' order by ref_value DESC limit 1";
        $current_data = $this->db->query($sql)->row_array();
        if (empty($current_data)) {
            $latestid = '000ETN000';
        } else {
            $latestid = $current_data['ref_value'];
        }
        $num = substr($latestid, 6);
        $num ++;
        $numlength = strlen((string) $num);
        if ($numlength == 1) {
            $finalid = '000ETN000' . $num;
        } else if ($numlength == 2) {
            $finalid = '000ETN00' . $num;
        } else if ($numlength == 3) {
            $finalid = '000ETN0' . $num;
        } else {
            $finalid = '000ETN' . $num;
        }
        $data['manifest_no'] = $finalid;
        $data['items_count'] = $data['tot_weight'] = $data['tot_vol'] = $data['tot_pallet'] = 0;
        $data['cargo_type'] = '';
        $data['isDG'] = 'No';
        $orders = $this->db->query('select o.id,o.plat,o.plng,o.customer_id,o.vendor_id,o.pickup_city,o.pickup_address2,o.pickup_pincode,o.pickup_address1,o.delivery_address2,o.delivery_pincode,o.delivery_city,od.order_id,od.consignment_note,od.num_of_pallets from tb_orders o LEFT JOIN tb_order_details od ON od.order_row_id = o.id where o.id in(' . $orderids . ')')->result_array();
        foreach ($orders as $ord) {
            $ordref = $this->common->gettblrowdata(array(
                'order_id' => $ord['id'],
                'reference_id' => 'BN'
            ), 'ref_value', 'tb_order_references', 0, 0);
            $delnote = $this->common->gettblrowdata(array(
                'order_id' => $ord['id'],
                'reference_id' => 'DQ'
            ), 'ref_value', 'tb_order_references', 0, 0);
            $receiverinfo = $this->truckwaybillmodel->getshipper($ord['id'], 'Consignee');
            $pickupinfo = $this->truckwaybillmodel->getshipper($ord['id'], 'Shipper');
            $customer = $this->common->gettblrowdata(array(
                'id' => $ord['customer_id']
            ), 'name', 'tb_customers', 0, 0);
            $order_cargos = $this->common->gettbldata(array(
                "order_id" => $ord['id'],
                'status' => 1
            ), 'cargo_id,quantity,weight,volume', 'tb_order_cargodetails', 0, 0);
            $ord['total_items'] = 0;
            $ord['total_weight'] = 0;
            $ord['total_volume'] = 0;
            $cargolist = array();
            foreach ($order_cargos as $cargo) {
                $cargoinfo = $this->common->gettblrowdata(array(
                    'id' => $cargo['cargo_id']
                ), 'dg_goods,cargo_type', 'tb_cargo_details', 0, 0);
                $data['isDG'] = ($cargoinfo['dg_goods'] == 0) ? 'No' : 'Yes';
                $ord['total_items'] += $cargo['quantity'];
                $ord['total_weight'] += $cargo['weight'];
                $ord['total_volume'] += $cargo['volume'];
                $data['cargo_type'] = $cargoinfo['cargo_type'];
            }
            $ord['palletno'] = $ord['num_of_pallets'];
            $data['tot_pallet'] += $ord['num_of_pallets'];
            $data['items_count'] += $ord['total_items'];
            $data['tot_weight'] += $ord['total_weight'];
            $data['tot_vol'] += $ord['total_volume'];
            $ord['service'] = "EXPRESS";
            $ord['ref_value'] = isset($ordref['ref_value']) ? $ordref['ref_value'] : '';
            $ord['delivery_note'] = isset($delnote['ref_value']) ? $delnote['ref_value'] : '';
            $ord['consignee_name'] = $receiverinfo['name'];
            $ord['customer_name'] = isset($customer['name']) ? $customer['name'] : '';
            $vendor_id = $ord['vendor_id'];
            $vendor = $this->common->gettblrowdata(array(
                'id' => $ord['vendor_id']
            ), 'name', 'tb_vendors', 0, 0);
            $ord['vendor_name'] = ! empty($vendor['name']) ? $vendor['name'] : '';
            $ord['cargolist'] = $cargolist;
            $ordinfo[] = $ord;
            $data['shipper_name'] = $pickupinfo['name'];
            $data['customer_name'] = $ord['customer_name'];
            
            $dt = date('Y-m-d H:i:s');
            $curtz = $this->session->userdata("usr_tzone")['timezone'];
            $gentime = getdatetimebytimezone(DFLT_TZ, $dt, $curtz);
            $dt = $gentime['datetime'];

            $palletData[$receiverinfo['party_master_id']][$ord['id']] = $ord['total_items'];
             

            /* Delivery date */
            $bonds_carrier = checkbondsCarrier($vendor_id);
            $macpac_customer = $this->Aumanifestmodel->checkMacpacCustomer($ord['id']);
            if (! empty($bonds_carrier) &&  empty($macpac_customer) ) { // if bonds carrier and not a macpac customer or sub customer
                $chkdelres['days'] = 3;  // 3 weekdays
            } else {
                /* Delivery date */
                $deli_whr = array(
                    'pickup_pincode' => $ord['pickup_pincode'],
                    'delivery_pincode' => $ord['delivery_pincode']
                );
                $chkdelres = $this->common->gettblrowdata($deli_whr, 'days', 'tb_au_deliverydays', 0, 0);
            }

            if (! empty($chkdelres)) {
                $deli_days = $chkdelres['days'];
                if (empty($deli_days)) {
                    $deli_days = 6;
                }
                $del_date = date('Y-m-d h:i:s', strtotime('+' . $deli_days . 'weekdays'));
            } else {
                $del_date = date('Y-m-d h:i:s', strtotime('+ 6 weekdays'));
            }

            $deli_state = $ord['delivery_address2'];
            $delivery_date =  $this->Aumanifestmodel->aupublicholidays_list($deli_state, $dt, $del_date);
            if (isset($delivery_date) && ! empty($delivery_date)) {
                $del_date = $delivery_date;
            }
            $deliverytime = getdatetimebytimezone(DFLT_TZ, $del_date, $curtz);
            $del_date = $deliverytime['datetime'];
            $ins_ar = array(
                'order_id' => $ord['id'],
                'reference_id' => 'MN'
            );
            $chkqry = $this->common->gettblrowdata($ins_ar, 'id', 'tb_order_references', 0, 0);
            if (empty($chkqry)) {
                $ins_ar['ref_value'] = $data['manifest_no'];
                $ins_ar['status'] = 1;
                $ins_ar['createdon'] = $dt;
                $ins = $this->db->insert('tb_order_references', $ins_ar);
            } else {
                $upd['updatedon'] = $dt;
                $up = $this->common->updatetbledata('tb_order_references', array(
                    'ref_value' => $data['manifest_no']
                ), array(
                    'id' => $chkqry['id']
                ));
            }
            /* Manifested status updation */
            $code = '2492';
            $statusinfo = $this->common->gettblrowdata(array(
                "status_code" => $code,
                'status' => 1
            ), 'id', 'tb_status_master', 0, 0);
            if (! empty($statusinfo)) {
                $status_id = $statusinfo['id'];
                $innr_array = array(
                    'order_id' => $ord['id'],
                    'status_id' => $status_id,
                    'status_code' => $code,
                    'status' => 1,
                    'updatedon' => $dt
                );
                $check_array = array(
                    'order_id' => $ord['id'],
                    'status_id' => $status_id,
                    'status_code' => $code,
                    'status' => 1
                );
                $chk_qry = $this->db->select("id")->get_where('tb_order_status', $check_array);
                if ($chk_qry->num_rows() == 0) {
                    $innr_array['createdon'] = $dt;
                    $innr_array['status_date'] = $dt;
                    $stsins = $this->db->insert('tb_order_status', $innr_array);
                } else {
                    $stsins = $this->db->where_in("id", array(
                        "id" => $chk_qry->row()->id
                    ))
                        ->update("tb_order_status", $innr_array);
                }
            }

            $update = $this->common->updatetbledata('tb_orders', array(
                'pickup_datetime' => $dt,
                'delivery_datetime' => $del_date
            ), array(
                'id' => $ord['id']
            ));
        }

        $data['orders'] = $ordinfo;
        $data['vendor_name'] = ! empty($vendor['name']) ? $vendor['name'] : '';
        $data['pick_city'] = $ordinfo[0]['pickup_city'];
        $data['del_city'] = $ordinfo[0]['delivery_city'];
        $data['pick_state'] = $ordinfo[0]['pickup_address2'];
        $data['del_state'] = $ordinfo[0]['delivery_address2'];
        $data['pick_pincode'] = $ordinfo[0]['pickup_pincode'];
        $data['pick_address1'] = $ordinfo[0]['pickup_address1'];
        require 'vendor/autoload.php';
        $data['generator'] = new Picqer\Barcode\BarcodeGeneratorPNG();
        $mpdf = new \Mpdf\Mpdf([
            'default_font_size' => 9,
            'tempDir' => FCPATH .'assets/tmp',
            'format' => 'A4'
        ]);
        $mpdf->setAutoBottomMargin = 'stretch';
        $company_code = $this->session->userdata('company_code');
        $data['company_code'] = $company_code;
        $html = "";
        $html = $this->load->view('manifestdoc/index', $data, true);
        $mpdf->WriteHTML($html);
        $filename = "mnf" . $vendor_id . date('YmdHis') . ".pdf";
        $filepath = "./assets/manifestdocs/" . $filename;
        $mpdf->Output($filepath, 'F');
        return $filename;
    }

    public function updatebondsedistatus($id){
        $this->common->updatetbledata("tb_edi_bonds", array(
            'edi_status' => 0
        ), array(
            "id" => $id
        ));
    }

    /*private function aupublicholidays($state, $pickupdate, $delivery_date)
    {
        $public_holidays = array();
        // Aus States array
        $state_arr = array(
            'ACT',
            'NSW',
            'NT',
            'QLD',
            'SA',
            'TAS',
            'VIC',
            'WA'
        );
        if (in_array($state, $state_arr)) {
            $delivery_whr = array(
                'status' => 1
            );
            $public_holidays = $this->common->gettbldata($delivery_whr, $state, 'tb_au_public_holidays', 0, 0);
            if (! empty($public_holidays)) {
                foreach ($public_holidays as $Key1 => $delivery_days1) {
                    if ($delivery_days1[$state] == '0000-00-00') {
                        unset($public_holidays[$Key1]);
                    }
                }
                // public holidays array geting from db
                $public_holidays = array_column($public_holidays, $state);

                while ($pickupdate <= $delivery_date) {
                    $date1 = date('Y-m-d', strtotime($pickupdate));
                    if (in_array($date1, $public_holidays)) {
                        $delivery_date = date('Y-m-d h:i:s', strtotime($delivery_date . ' +1 Weekday'));
                    }
                    $pickupdate = date('Y-m-d h:i:s', strtotime($pickupdate . ' +1 weekday'));
                }
            }
        }
        return $delivery_date;
    }*/

    private function notifyPalletCount($data)
	{
		if (!empty($data)) {
			$this->load->library('notifytrigger');
			$user_name = "";
			foreach ($data as $party_master_id => $value) {
				$where = array(
					'id' => $party_master_id,
					'status' => 1
				);
				$get_data = $this->common->gettblrowdata($where, 'name,email', 'tbl_party_master', 0, 0);
				if (!empty($get_data)) {
                    $user_name=$get_data['name'];
					$data['username'] = $get_data['name'];
					$data['emailid'] = !empty($get_data['email']) ? $get_data['email'] : "daniel.grote@kuehne-nagel.com";
					$data['subject'] = "Notification For Cargo Count";
					$message  =  "Dear Customer,<br><br><br>";
					$message .= "Below are the orders Manifested and you will be receiving them to your store<br>";
					$message .= "Hello" . $data['username'] . " your Cargo Count is " . array_sum($value) . "<br><br><br><br><br><br>";
					$message .= "Thanks,<br>Support Team,<br>svkonekt.com";
					/* $data['body'] = "Hello".$data['username']." your palletCount is ".array_sum($value);  */
					$data['body'] = $message;
                   /* log_message('error',json_encode($data).':::data-------->'); */
					$this->notifytrigger->sendstatusmail($data);
				}
			}
		}
		return $user_name;
	}





}
