<?php
if ( ! defined( 'BASEPATH' ) ) {
    exit( 'No direct script access allowed' );
}

class Milestonereport extends CI_Controller {

	public function __construct() {
		parent::__construct();
		if (!$this->session->userdata('user_id')) {
			redirect('login');
		}
		$this->load->model('Order');
		$this->load->model('milestonereportmodel');
		$this->load->model('aquaticamodel');
	}

	public function index(){
		$country_userids =  $result = $searchids = $whr = $post = $getdata = array();
		$user_id            = $this->session->userdata('user_id');
		$custid             = $this->session->userdata( "cust_id" );
		$country_userids    = $this->session->userdata( "country_user_ids" );
		if ( isset( $_POST['searchsubmit'] ) && $_POST['searchsubmit'] == "Search" ) {
			$post = $_POST;
		}
		$subcusts     = array();
		$role_id      = $this->session->userdata( 'user_role_id' );
		if ( $role_id == "4" ) {
			if ( $this->session->userdata( 'sub_cust' ) ) {
				$subcusts = $this->session->userdata( 'sub_cust' );
				if ( ! empty( $subcusts ) ) {
					array_push( $subcusts, $custid );
				}
			}
		}
		if(!empty($post)){
			$whr   = $this->searchdata( $post );
			$searchids       = isset( $post['bookingid'] ) ? $post['bookingid'] : array();
			$search_container_no    = isset( $post['container_no'] ) ? $post['container_no'] : "";
			$advcontainer_no = isset( $post['advcontainer_no'] ) ? $post['advcontainer_no'] : "";
			if($advcontainer_no != ""){
				$search_container_no = $advcontainer_no;
			}
			if($search_container_no != ""){
				$container_num_arr = $this->GetContainernum($search_container_no);
				$searchids         = array_merge( $container_num_arr, $searchids );
			}
			if($custid >0){
				$user_id = 0;
			}
		$getdata = $this->milestonereportmodel->getOrdersDatawithreport($user_id,$country_userids,$whr,$searchids,$custid,$subcusts);
		}
		/*echo "<pre>";
		print_r($getdata);exit;*/
		if(!empty($getdata)){
			foreach ($getdata as $res) {
				$referenceData = $container_no = $delivery_note = $store_code = $ref_order_num = "";
				if ( isset( $res['reference_value'] ) ) {
						$referenceData = $res['reference_value'];
					}
					if ( $referenceData != '' ) {
						$referenceDataArray = explode( '?????', $referenceData );
						if ( ! empty( $referenceDataArray ) && sizeof( $referenceDataArray ) > 0 ) {
							foreach ( $referenceDataArray as $eachRefData ) {
								$reqArray = $this->giveReferenceParameters( $eachRefData );
								if ( $reqArray['type'] == "CTR" ) {
									$container_no = $reqArray['value'];
								} else if ( $reqArray['type'] == "DQ" ) {
									$delivery_note = $reqArray['value'];
								} else if ( $reqArray['type'] == "COI" ) {
									$store_code = $reqArray['value'];
								} else if ( $reqArray['type'] == "PO" ) {
									$ref_order_num = $reqArray['value'];
								}
							}
						}
					}
                if ($this->session->userdata('company_code') == "AUKN") {
                    $ref_order_num = $this->getrefordernum($res['id']);
                }
                $curtz       = $this->session->userdata( "usr_tzone" )['timezone'];
                $shift_id    = $res['shift_id'];
                $order_cdate = $res['order_creation'];
                if($order_cdate != "" && $order_cdate != "0000-00-00 00:00:00" && $order_cdate != "0"){
					$ocreatedon      = getdatetimebytimezone( $curtz, $order_cdate, DFLT_TZ );
					$order_cdate = date('Y-m-d h:i A',strtotime($ocreatedon['datetime']));
				}
				$accepted = $res['accepted'];
                if($accepted != "" && $accepted != "0000-00-00 00:00:00" && $accepted != "0"){
					$acreatedon      = getdatetimebytimezone( $curtz, $accepted, DFLT_TZ );
					$accepted = date('Y-m-d h:i A',strtotime($acreatedon['datetime']));
				}
				$transit = $res['transit'];
                if($transit != "" && $transit != "0000-00-00 00:00:00" && $transit != "0"){
					$tcreatedon      = getdatetimebytimezone( $curtz, $transit, DFLT_TZ );
					$transit = date('Y-m-d h:i A',strtotime($tcreatedon['datetime']));
				}
				$gateout = $res['gateout'];
                if($gateout != "" && $gateout != "0000-00-00 00:00:00" && $gateout != "0"){
					$gcreatedon      = getdatetimebytimezone( $curtz, $gateout, DFLT_TZ );
					$gateout = date('Y-m-d h:i A',strtotime($gcreatedon['datetime']));
				}
				$pickup = $res['pickup'];
                if($pickup != "" && $pickup != "0000-00-00 00:00:00" && $pickup != "0"){
					$pcreatedon      = getdatetimebytimezone( $curtz, $pickup, DFLT_TZ );
					$pickup = date('Y-m-d h:i A',strtotime($pcreatedon['datetime']));
				}
                $last_status_name = "Booked by Supplier";
                if($shift_id >0 ){
                	$recentstatus_code = $this->milestonereportmodel->getrecentstatusfororder($res['id']);
	                if($recentstatus_code == "0212"){
	                    $last_status_name = 'Accepted by Driver';
	                }
	                if($recentstatus_code == "0420"){
	                    $last_status_name = 'Pickup Gate In';
	                }
	                if($recentstatus_code == "0500"){
	                	$last_status_name = 'Actual Pick Up';
	                }
	                if($recentstatus_code == "1550"){
	                    $last_status_name = 'In-Transit';
	                }if($recentstatus_code == "0192"){
	                    $last_status_name = 'Delivery Gate In';
	                }
	                if($recentstatus_code == "3000"){
	                	$last_status_name = 'Delivered To Consignee';
	                }
	                if($recentstatus_code == "2300"){
	                	$last_status_name = 'Arrival at Delivery Point';
	                }
                }
                $delivered_time = $final_delivery = $res['delivered_time'];
                if($delivered_time != "" && $delivered_time != "0000-00-00 00:00:00" && $delivered_time != "0"){
					$fdelivery      = getdatetimebytimezone( $curtz, $delivered_time, DFLT_TZ );
					$final_delivery = date('Y-m-d h:i A',strtotime($fdelivery['datetime']));
				}
				if($accepted != "" && $final_delivery != ""){
					if($accepted > $final_delivery){
						$pickup_datetime = $res['pickup_datetime'];
						if($pickup_datetime != "" && $pickup_datetime != "0000-00-00 00:00:00" && $pickup_datetime != "0"){
							$paccept      = getdatetimebytimezone( $curtz, $pickup_datetime, DFLT_TZ );
							$pdatetime = date('Y-m-d H:i:s',strtotime($paccept['datetime']));
							$accepted = date( 'Y-m-d h:i:A', strtotime( '+1 day', strtotime( $pdatetime ) ) );
						}
					}
				}
				$result[] = array('order_row_id'=>$res['id'],'booking_id'=>$res['order_id'],'consignee_name'=>$res['delivery'],'container_no'=>$container_no,'delivery_note'=>$delivery_note,'store_code'=>$store_code,'deliver_date'=>$final_delivery,'ref_order_num'=>$ref_order_num,'last_status_name'=>$last_status_name,'pickup'=>$pickup,'gateout'=>$gateout,'transit'=>$transit,'accepted'=>$accepted,'order_cdate'=>$order_cdate);

			}
		}
		$data['result'] = $result;
		$custid = $vendor_id = "";
		if(!empty($this->session->userdata("cust_id"))) {
            $custid = $this->session->userdata("cust_id");
        }
        if(!empty($this->session->userdata('id'))){
            $vendor_id = $this->session->userdata('id');
        }
		$data['cust_id'] = $custid;
		$data['vendor_id'] = $vendor_id;
		$this->newtemplate->dashboard("milestonereport/index", $data);

	}

	public function GetContainernum($container_no) {
		$result = $res = array();
		$user_id         = $this->session->userdata( 'user_id' );
		$country_userids = $this->session->userdata( "country_user_ids" );
		$ref_val         = trim( $container_no );
		$where_like      = array( 'r.ref_value' => $ref_val );
		$whr             = array( 'o.status!=' => '0', 'r.reference_id' => 'CTR', 'r.status' => 1, );
		$result          = $this->Order->getrefvals( $whr, $where_like, $user_id, $country_userids );
		/* log_message('error',"container to order ids ::->".$this->db->last_query()."<---"); */
		if ( ! empty( $result ) ) {
			$res = array_column( $result, "order_id" );
		}

		return $res;
	}

	public function searchdata($post){
		$whr   = array();
		$session_company_code = $this->session->userdata('company_code');
		if ( isset( $post['fromdate'] ) && $post['fromdate'] != "" ) {
			$fromdate                                      = date( 'Y-m-d', strtotime( $post['fromdate'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') >="] = $fromdate;
			if ( isset( $post['todate'] ) ) {
				if ( $post['todate'] == "" ) {
					$todate                                        = date( 'Y-m-d', strtotime( $cdate ) );
					$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
				}
			} else {
				$todate                                        = date( 'Y-m-d', strtotime( $cdate ) );
				$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;
			}

		}

		if ( isset( $post['todate'] ) && $post['todate'] != "" ) {
			$todate                                        = date( 'Y-m-d', strtotime( $post['todate'] ) );
			$whr["DATE_FORMAT(o.createdon,'%Y-%m-%d') <="] = $todate;

		}
		if ( isset( $post['order_id'] ) && $post['order_id'] != "" ) {
			$whr['o.order_id'] = $post['order_id'];

		}
		if ( isset( $post['advstore_code'] ) && $post['advstore_code'] != "" ) {
			$getcoi = $this->getOrderWithReferencesForCompanyCodeAndReference($session_company_code, 'COI', $post['advstore_code']);
			if ( $getcoi->num_rows() > 0 ) {
				$order_id    = $getcoi->row()->id;
				$whr['o.id'] = $order_id;
			} else {
				$whr['o.id'] = '0';
			}
		}
		if ( isset( $post['advconsignment_note'] ) && $post['advconsignment_note'] != "" ) {
            $getcoi = $this->getOrderWithReferencesForCompanyCodeAndReference($session_company_code, 'DQ', $post['advconsignment_note']);
			if ( $getcoi->num_rows() > 0 ) {
				$order_id    = $getcoi->row()->id;
				$whr['o.id'] = $order_id;
			} else {
				$whr['o.id'] = '0';
			}
		}
		return $whr;
	}

	public function getrefordernum($id)
    {
        $ref_order_num = "";
        $whr = array(
            'c.order_id' => $id,
            'i.status' => 1,
            'c.status' => 1
        );
        $res = $this->aquaticamodel->getaurefnums($whr);
        if (! empty($res)) {
            $res = array_column($res, 'ref_order_num');
            $res = array_unique($res);
            $ref_ordernum = implode(" , ", $res);
            $ref_order_num = (! empty($ref_ordernum)) ? $ref_ordernum : "";
        }
        return $ref_order_num;
    }

	public function giveReferenceParameters( $referenceParam ) {
		$finalArray = array();
		if ( ! empty( $referenceParam ) && $referenceParam != '' ) {
			$requiredArray = explode( '=====', $referenceParam );
			if ( ! empty( $requiredArray ) && sizeof( $requiredArray ) > 0 ) {
				$finalArray['type']  = isset( $requiredArray[0] ) ? trim( $requiredArray[0] ) : "";
				$finalArray['value'] = isset( $requiredArray[1] ) ? trim( $requiredArray[1] ) : "";
			}
		}

		return $finalArray;
	}

    private function getOrderWithReferencesForCompanyCodeAndReference($companyCode, $referenceId, $referenceValue)
    {
        return $this->db->query(
            "SELECT o.id
                    FROM tb_orders o,tb_order_references r
                    WHERE o.id = r.order_id
                      AND o.company_code LIKE ?
                      AND o.status !=0
                      AND r.reference_id = ?
                      AND r.ref_value = ? ",
        [ $companyCode, $referenceId, $referenceValue]);
    }
}


